# coding: utf-8

"""
    OpenPay API

    super charge your subscription management.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictInt, StrictStr
from pydantic import Field
from getopenpay.models.invoice_item_discount_amounts_external import InvoiceItemDiscountAmountsExternal
from getopenpay.models.object_name import ObjectName
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class InvoiceItemExternal(BaseModel):
    """
    InvoiceItemExternal
    """ # noqa: E501
    id: StrictStr = Field(description="Unique identifier of the invoice_item.")
    object: Optional[ObjectName] = None
    created_at: datetime = Field(description="DateTime at which the object was created, in 'ISO 8601' format.")
    updated_at: datetime = Field(description="DateTime at which the object was updated, in 'ISO 8601' format.")
    is_deleted: Optional[StrictBool] = Field(default=False, description="If true, indicates that this object has been deleted")
    invoice_id: Optional[StrictStr]
    account_id: StrictStr = Field(description="Unique identifier of the account.")
    amount_atom: StrictInt = Field(description="Total amount of invoice_item in atomic units (in USD this is cents).")
    currency: StrictStr
    customer_id: StrictStr = Field(description="Unique identifier of the customer.")
    description: Optional[StrictStr]
    period_end: datetime = Field(description="End of the usage period of the invoice_item. It is in 'ISO 8601' format.")
    period_start: datetime = Field(description="Start of the usage period of the invoice_item. It is in 'ISO 8601' format.")
    price_id: StrictStr = Field(description="Unique identifier of the price.")
    product_id: StrictStr = Field(description="Unique identifier of the product.")
    quantity: StrictInt = Field(description="Quantity of the invoice_item.")
    subscription_id: Optional[StrictStr]
    subscription_item_id: Optional[StrictStr] = None
    discounts: List[StrictStr]
    discount_amount_atoms: List[InvoiceItemDiscountAmountsExternal]
    amount_atom_considering_discount_applied: StrictInt = Field(description="Total amount of invoice_item in atomic units considering discounts. Contains both invoice-level and invoice item-level discounts")
    proration_details_debit_invoice_item: Optional[StrictStr]
    __properties: ClassVar[List[str]] = ["id", "object", "created_at", "updated_at", "is_deleted", "invoice_id", "account_id", "amount_atom", "currency", "customer_id", "description", "period_end", "period_start", "price_id", "product_id", "quantity", "subscription_id", "subscription_item_id", "discounts", "discount_amount_atoms", "amount_atom_considering_discount_applied", "proration_details_debit_invoice_item"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of InvoiceItemExternal from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in discount_amount_atoms (list)
        _items = []
        if self.discount_amount_atoms:
            for _item in self.discount_amount_atoms:
                if _item:
                    _items.append(_item.to_dict())
            _dict['discount_amount_atoms'] = _items
        # set to None if invoice_id (nullable) is None
        # and model_fields_set contains the field
        if self.invoice_id is None and "invoice_id" in self.model_fields_set:
            _dict['invoice_id'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if subscription_id (nullable) is None
        # and model_fields_set contains the field
        if self.subscription_id is None and "subscription_id" in self.model_fields_set:
            _dict['subscription_id'] = None

        # set to None if subscription_item_id (nullable) is None
        # and model_fields_set contains the field
        if self.subscription_item_id is None and "subscription_item_id" in self.model_fields_set:
            _dict['subscription_item_id'] = None

        # set to None if proration_details_debit_invoice_item (nullable) is None
        # and model_fields_set contains the field
        if self.proration_details_debit_invoice_item is None and "proration_details_debit_invoice_item" in self.model_fields_set:
            _dict['proration_details_debit_invoice_item'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of InvoiceItemExternal from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "object": obj.get("object"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "is_deleted": obj.get("is_deleted") if obj.get("is_deleted") is not None else False,
            "invoice_id": obj.get("invoice_id"),
            "account_id": obj.get("account_id"),
            "amount_atom": obj.get("amount_atom"),
            "currency": obj.get("currency"),
            "customer_id": obj.get("customer_id"),
            "description": obj.get("description"),
            "period_end": obj.get("period_end"),
            "period_start": obj.get("period_start"),
            "price_id": obj.get("price_id"),
            "product_id": obj.get("product_id"),
            "quantity": obj.get("quantity"),
            "subscription_id": obj.get("subscription_id"),
            "subscription_item_id": obj.get("subscription_item_id"),
            "discounts": obj.get("discounts"),
            "discount_amount_atoms": [InvoiceItemDiscountAmountsExternal.from_dict(_item) for _item in obj.get("discount_amount_atoms")] if obj.get("discount_amount_atoms") is not None else None,
            "amount_atom_considering_discount_applied": obj.get("amount_atom_considering_discount_applied"),
            "proration_details_debit_invoice_item": obj.get("proration_details_debit_invoice_item")
        })
        return _obj


