# coding: utf-8

"""
    OpenPay API

    super charge your subscription management.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictInt, StrictStr
from pydantic import Field
from getopenpay.models.billing_reason_enum import BillingReasonEnum
from getopenpay.models.collection_method_enum import CollectionMethodEnum
from getopenpay.models.discount_external import DiscountExternal
from getopenpay.models.invoice_discount_amounts_external import InvoiceDiscountAmountsExternal
from getopenpay.models.invoice_item_external import InvoiceItemExternal
from getopenpay.models.invoice_status_enum import InvoiceStatusEnum
from getopenpay.models.object_name import ObjectName
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class InvoiceExternal(BaseModel):
    """
    InvoiceExternal
    """ # noqa: E501
    id: StrictStr = Field(description="Unique identifier of the invoice.")
    object: Optional[ObjectName] = None
    created_at: datetime = Field(description="DateTime at which the object was created, in 'ISO 8601' format.")
    updated_at: datetime = Field(description="DateTime at which the object was updated, in 'ISO 8601' format.")
    is_deleted: Optional[StrictBool] = Field(default=False, description="If true, indicates that this object has been deleted")
    account_id: StrictStr = Field(description="Unique identifier of the account.")
    billing_reason: BillingReasonEnum
    collection_method: CollectionMethodEnum
    customer_id: StrictStr = Field(description="Unique identifier of the customer.")
    currency: StrictStr
    default_payment_method_id: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    latest_payment_intent_id: Optional[StrictStr] = None
    period_end: datetime = Field(description="End of the usage period during which invoice_items were added to this invoice. It is in 'ISO 8601' format.")
    period_start: datetime = Field(description="Start of the usage period during which invoice_items were added to this invoice. It is in 'ISO 8601' format.")
    status: InvoiceStatusEnum
    paid_out_of_band: Optional[StrictBool]
    subscription_id: Optional[StrictStr] = None
    total_amount_atom: StrictInt = Field(description="Total amount of the invoice. Sum of invoice_items’ total amount. It is in atomic units (in USD this is cents).")
    remaining_amount_atom: StrictInt = Field(description="Remaining amount of the invoice to be paid. It is in atomic units (in USD this is cents).")
    tax_amount_atom: StrictInt = Field(description="Total tax amount in atomic units.")
    lines: List[InvoiceItemExternal]
    pre_payment_credit_notes_amount: Optional[StrictInt] = None
    post_payment_credit_notes_amount: Optional[StrictInt] = None
    credit_note_ids: Optional[List[StrictStr]] = None
    applied_balance_amount_atom: StrictInt = Field(description="Amount applied from customer balance either from credit or debit. It is in atomic units (in USD this is cents).")
    due_amount_atom: StrictInt = Field(description="Final amount due at this time for this invoice. It isin atomic units (in USD this is cents).")
    paid_amount_atom: StrictInt = Field(description="The amount that was paid in atomic units (in USD this is cents).")
    discounts: Optional[List[DiscountExternal]] = None
    total_discount_amount_atoms: Optional[List[InvoiceDiscountAmountsExternal]] = None
    net_d: Optional[StrictInt] = Field(default=-1, description="Number of days the customer has to pay the invoice, from 0 to 365, where -1 indicates due immediately.")
    hosted_invoice_url: Optional[StrictStr] = None
    latest_payment_attempt_failure_message: Optional[StrictStr] = None
    tax_processor_updated_at: Optional[datetime] = None
    refund_ids: List[StrictStr]
    refunded_amount_atom: Optional[StrictInt]
    __properties: ClassVar[List[str]] = ["id", "object", "created_at", "updated_at", "is_deleted", "account_id", "billing_reason", "collection_method", "customer_id", "currency", "default_payment_method_id", "description", "latest_payment_intent_id", "period_end", "period_start", "status", "paid_out_of_band", "subscription_id", "total_amount_atom", "remaining_amount_atom", "tax_amount_atom", "lines", "pre_payment_credit_notes_amount", "post_payment_credit_notes_amount", "credit_note_ids", "applied_balance_amount_atom", "due_amount_atom", "paid_amount_atom", "discounts", "total_discount_amount_atoms", "net_d", "hosted_invoice_url", "latest_payment_attempt_failure_message", "tax_processor_updated_at", "refund_ids", "refunded_amount_atom"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of InvoiceExternal from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in lines (list)
        _items = []
        if self.lines:
            for _item in self.lines:
                if _item:
                    _items.append(_item.to_dict())
            _dict['lines'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in discounts (list)
        _items = []
        if self.discounts:
            for _item in self.discounts:
                if _item:
                    _items.append(_item.to_dict())
            _dict['discounts'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in total_discount_amount_atoms (list)
        _items = []
        if self.total_discount_amount_atoms:
            for _item in self.total_discount_amount_atoms:
                if _item:
                    _items.append(_item.to_dict())
            _dict['total_discount_amount_atoms'] = _items
        # set to None if default_payment_method_id (nullable) is None
        # and model_fields_set contains the field
        if self.default_payment_method_id is None and "default_payment_method_id" in self.model_fields_set:
            _dict['default_payment_method_id'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if latest_payment_intent_id (nullable) is None
        # and model_fields_set contains the field
        if self.latest_payment_intent_id is None and "latest_payment_intent_id" in self.model_fields_set:
            _dict['latest_payment_intent_id'] = None

        # set to None if paid_out_of_band (nullable) is None
        # and model_fields_set contains the field
        if self.paid_out_of_band is None and "paid_out_of_band" in self.model_fields_set:
            _dict['paid_out_of_band'] = None

        # set to None if subscription_id (nullable) is None
        # and model_fields_set contains the field
        if self.subscription_id is None and "subscription_id" in self.model_fields_set:
            _dict['subscription_id'] = None

        # set to None if pre_payment_credit_notes_amount (nullable) is None
        # and model_fields_set contains the field
        if self.pre_payment_credit_notes_amount is None and "pre_payment_credit_notes_amount" in self.model_fields_set:
            _dict['pre_payment_credit_notes_amount'] = None

        # set to None if post_payment_credit_notes_amount (nullable) is None
        # and model_fields_set contains the field
        if self.post_payment_credit_notes_amount is None and "post_payment_credit_notes_amount" in self.model_fields_set:
            _dict['post_payment_credit_notes_amount'] = None

        # set to None if hosted_invoice_url (nullable) is None
        # and model_fields_set contains the field
        if self.hosted_invoice_url is None and "hosted_invoice_url" in self.model_fields_set:
            _dict['hosted_invoice_url'] = None

        # set to None if latest_payment_attempt_failure_message (nullable) is None
        # and model_fields_set contains the field
        if self.latest_payment_attempt_failure_message is None and "latest_payment_attempt_failure_message" in self.model_fields_set:
            _dict['latest_payment_attempt_failure_message'] = None

        # set to None if tax_processor_updated_at (nullable) is None
        # and model_fields_set contains the field
        if self.tax_processor_updated_at is None and "tax_processor_updated_at" in self.model_fields_set:
            _dict['tax_processor_updated_at'] = None

        # set to None if refunded_amount_atom (nullable) is None
        # and model_fields_set contains the field
        if self.refunded_amount_atom is None and "refunded_amount_atom" in self.model_fields_set:
            _dict['refunded_amount_atom'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of InvoiceExternal from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "object": obj.get("object"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "is_deleted": obj.get("is_deleted") if obj.get("is_deleted") is not None else False,
            "account_id": obj.get("account_id"),
            "billing_reason": obj.get("billing_reason"),
            "collection_method": obj.get("collection_method"),
            "customer_id": obj.get("customer_id"),
            "currency": obj.get("currency"),
            "default_payment_method_id": obj.get("default_payment_method_id"),
            "description": obj.get("description"),
            "latest_payment_intent_id": obj.get("latest_payment_intent_id"),
            "period_end": obj.get("period_end"),
            "period_start": obj.get("period_start"),
            "status": obj.get("status"),
            "paid_out_of_band": obj.get("paid_out_of_band"),
            "subscription_id": obj.get("subscription_id"),
            "total_amount_atom": obj.get("total_amount_atom"),
            "remaining_amount_atom": obj.get("remaining_amount_atom"),
            "tax_amount_atom": obj.get("tax_amount_atom"),
            "lines": [InvoiceItemExternal.from_dict(_item) for _item in obj.get("lines")] if obj.get("lines") is not None else None,
            "pre_payment_credit_notes_amount": obj.get("pre_payment_credit_notes_amount"),
            "post_payment_credit_notes_amount": obj.get("post_payment_credit_notes_amount"),
            "credit_note_ids": obj.get("credit_note_ids"),
            "applied_balance_amount_atom": obj.get("applied_balance_amount_atom"),
            "due_amount_atom": obj.get("due_amount_atom"),
            "paid_amount_atom": obj.get("paid_amount_atom"),
            "discounts": [DiscountExternal.from_dict(_item) for _item in obj.get("discounts")] if obj.get("discounts") is not None else None,
            "total_discount_amount_atoms": [InvoiceDiscountAmountsExternal.from_dict(_item) for _item in obj.get("total_discount_amount_atoms")] if obj.get("total_discount_amount_atoms") is not None else None,
            "net_d": obj.get("net_d") if obj.get("net_d") is not None else -1,
            "hosted_invoice_url": obj.get("hosted_invoice_url"),
            "latest_payment_attempt_failure_message": obj.get("latest_payment_attempt_failure_message"),
            "tax_processor_updated_at": obj.get("tax_processor_updated_at"),
            "refund_ids": obj.get("refund_ids"),
            "refunded_amount_atom": obj.get("refunded_amount_atom")
        })
        return _obj


