# coding: utf-8

"""
    OpenPay API

    super charge your subscription management.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictInt, StrictStr
from pydantic import Field
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class InlineSubscriptionItemUpdate(BaseModel):
    """
    InlineSubscriptionItemUpdate
    """ # noqa: E501
    id: Optional[StrictStr] = None
    delete: Optional[StrictBool] = Field(default=False, description="A flag that, if set to true, will delete the specified item immediately from subscription. drop_at_end flag cannot be used while using this behaviour")
    add_at_period_end: Optional[StrictBool] = None
    drop_at_end: Optional[StrictBool] = None
    price_id: Optional[StrictStr] = None
    quantity: Optional[StrictInt] = None
    starts_at: Optional[datetime] = None
    __properties: ClassVar[List[str]] = ["id", "delete", "add_at_period_end", "drop_at_end", "price_id", "quantity", "starts_at"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of InlineSubscriptionItemUpdate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['id'] = None

        # set to None if add_at_period_end (nullable) is None
        # and model_fields_set contains the field
        if self.add_at_period_end is None and "add_at_period_end" in self.model_fields_set:
            _dict['add_at_period_end'] = None

        # set to None if drop_at_end (nullable) is None
        # and model_fields_set contains the field
        if self.drop_at_end is None and "drop_at_end" in self.model_fields_set:
            _dict['drop_at_end'] = None

        # set to None if price_id (nullable) is None
        # and model_fields_set contains the field
        if self.price_id is None and "price_id" in self.model_fields_set:
            _dict['price_id'] = None

        # set to None if quantity (nullable) is None
        # and model_fields_set contains the field
        if self.quantity is None and "quantity" in self.model_fields_set:
            _dict['quantity'] = None

        # set to None if starts_at (nullable) is None
        # and model_fields_set contains the field
        if self.starts_at is None and "starts_at" in self.model_fields_set:
            _dict['starts_at'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of InlineSubscriptionItemUpdate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "delete": obj.get("delete") if obj.get("delete") is not None else False,
            "add_at_period_end": obj.get("add_at_period_end"),
            "drop_at_end": obj.get("drop_at_end"),
            "price_id": obj.get("price_id"),
            "quantity": obj.get("quantity"),
            "starts_at": obj.get("starts_at")
        })
        return _obj


