# coding: utf-8

"""
    OpenPay API

    super charge your subscription management.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictStr
from pydantic import Field
from getopenpay.models.coupon_external import CouponExternal
from getopenpay.models.object_name import ObjectName
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class DiscountExternal(BaseModel):
    """
    DiscountExternal
    """ # noqa: E501
    id: StrictStr
    object: Optional[ObjectName] = None
    created_at: datetime = Field(description="DateTime at which the object was created, in 'ISO 8601' format.")
    updated_at: datetime = Field(description="DateTime at which the object was updated, in 'ISO 8601' format.")
    is_deleted: Optional[StrictBool] = Field(default=False, description="If true, indicates that this object has been deleted")
    start_date: datetime
    end_date: Optional[datetime]
    coupon_id: StrictStr
    coupon: CouponExternal
    customer_id: Optional[StrictStr]
    subscription_id: Optional[StrictStr]
    invoice_id: Optional[StrictStr]
    invoice_item_id: Optional[StrictStr]
    promotion_code_id: Optional[StrictStr]
    __properties: ClassVar[List[str]] = ["id", "object", "created_at", "updated_at", "is_deleted", "start_date", "end_date", "coupon_id", "coupon", "customer_id", "subscription_id", "invoice_id", "invoice_item_id", "promotion_code_id"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of DiscountExternal from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of coupon
        if self.coupon:
            _dict['coupon'] = self.coupon.to_dict()
        # set to None if end_date (nullable) is None
        # and model_fields_set contains the field
        if self.end_date is None and "end_date" in self.model_fields_set:
            _dict['end_date'] = None

        # set to None if customer_id (nullable) is None
        # and model_fields_set contains the field
        if self.customer_id is None and "customer_id" in self.model_fields_set:
            _dict['customer_id'] = None

        # set to None if subscription_id (nullable) is None
        # and model_fields_set contains the field
        if self.subscription_id is None and "subscription_id" in self.model_fields_set:
            _dict['subscription_id'] = None

        # set to None if invoice_id (nullable) is None
        # and model_fields_set contains the field
        if self.invoice_id is None and "invoice_id" in self.model_fields_set:
            _dict['invoice_id'] = None

        # set to None if invoice_item_id (nullable) is None
        # and model_fields_set contains the field
        if self.invoice_item_id is None and "invoice_item_id" in self.model_fields_set:
            _dict['invoice_item_id'] = None

        # set to None if promotion_code_id (nullable) is None
        # and model_fields_set contains the field
        if self.promotion_code_id is None and "promotion_code_id" in self.model_fields_set:
            _dict['promotion_code_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of DiscountExternal from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "object": obj.get("object"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "is_deleted": obj.get("is_deleted") if obj.get("is_deleted") is not None else False,
            "start_date": obj.get("start_date"),
            "end_date": obj.get("end_date"),
            "coupon_id": obj.get("coupon_id"),
            "coupon": CouponExternal.from_dict(obj.get("coupon")) if obj.get("coupon") is not None else None,
            "customer_id": obj.get("customer_id"),
            "subscription_id": obj.get("subscription_id"),
            "invoice_id": obj.get("invoice_id"),
            "invoice_item_id": obj.get("invoice_item_id"),
            "promotion_code_id": obj.get("promotion_code_id")
        })
        return _obj


