# coding: utf-8

"""
    OpenPay API

    super charge your subscription management.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool
from pydantic import Field
from getopenpay.models.subscription_cancellation_details import SubscriptionCancellationDetails
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class DeleteSubscriptionRequest(BaseModel):
    """
    DeleteSubscriptionRequest
    """ # noqa: E501
    cancellation_details: Optional[SubscriptionCancellationDetails] = None
    prorate: Optional[StrictBool] = Field(default=True, description="Will generate a proration invoice_item that credits remaining unused time until the subscription period end, also creates invoice_item for un-invoiced metered usage.Setting this to false will not invoice for un-invoiced metered usage.")
    __properties: ClassVar[List[str]] = ["cancellation_details", "prorate"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of DeleteSubscriptionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of cancellation_details
        if self.cancellation_details:
            _dict['cancellation_details'] = self.cancellation_details.to_dict()
        # set to None if cancellation_details (nullable) is None
        # and model_fields_set contains the field
        if self.cancellation_details is None and "cancellation_details" in self.model_fields_set:
            _dict['cancellation_details'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of DeleteSubscriptionRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cancellation_details": SubscriptionCancellationDetails.from_dict(obj.get("cancellation_details")) if obj.get("cancellation_details") is not None else None,
            "prorate": obj.get("prorate") if obj.get("prorate") is not None else True
        })
        return _obj


