# coding: utf-8

"""
    OpenPay API

    super charge your subscription management.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictStr
from pydantic import Field
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class DeleteSubscriptionItemResponse(BaseModel):
    """
    DeleteSubscriptionItemResponse
    """ # noqa: E501
    message: Optional[StrictStr] = Field(default='SubscriptionItem deleted successfully.', description="Message describing result of API call.")
    subscription_item_id: StrictStr = Field(description="Unique identifier of the subscription_item.")
    deleted_at: Optional[datetime]
    drop_at_end: Optional[StrictBool] = Field(default=False, description="Whether or not this item will be dropped from subscription before next renewal")
    __properties: ClassVar[List[str]] = ["message", "subscription_item_id", "deleted_at", "drop_at_end"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of DeleteSubscriptionItemResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # set to None if deleted_at (nullable) is None
        # and model_fields_set contains the field
        if self.deleted_at is None and "deleted_at" in self.model_fields_set:
            _dict['deleted_at'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of DeleteSubscriptionItemResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "message": obj.get("message") if obj.get("message") is not None else 'SubscriptionItem deleted successfully.',
            "subscription_item_id": obj.get("subscription_item_id"),
            "deleted_at": obj.get("deleted_at"),
            "drop_at_end": obj.get("drop_at_end") if obj.get("drop_at_end") is not None else False
        })
        return _obj


