# coding: utf-8

"""
    OpenPay API

    super charge your subscription management.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictInt, StrictStr
from pydantic import Field
from getopenpay.models.complete_address import CompleteAddress
from getopenpay.models.discount_external import DiscountExternal
from getopenpay.models.object_name import ObjectName
from getopenpay.models.subscription_external import SubscriptionExternal
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class CustomerExternal(BaseModel):
    """
    CustomerExternal
    """ # noqa: E501
    id: StrictStr = Field(description="Unique identifier of the customer.")
    object: Optional[ObjectName] = None
    created_at: datetime = Field(description="DateTime at which the object was created, in 'ISO 8601' format.")
    updated_at: datetime = Field(description="DateTime at which the object was updated, in 'ISO 8601' format.")
    is_deleted: Optional[StrictBool] = Field(default=False, description="If true, indicates that this object has been deleted")
    account_id: StrictStr = Field(description="Unique identifier for the account.")
    email: StrictStr = Field(description="Customer’s email address.")
    first_name: Optional[StrictStr]
    last_name: Optional[StrictStr]
    address: Optional[CompleteAddress]
    subscriptions: Optional[List[SubscriptionExternal]] = None
    balance_atom: Optional[StrictInt] = None
    discount: Optional[DiscountExternal] = None
    __properties: ClassVar[List[str]] = ["id", "object", "created_at", "updated_at", "is_deleted", "account_id", "email", "first_name", "last_name", "address", "subscriptions", "balance_atom", "discount"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of CustomerExternal from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of address
        if self.address:
            _dict['address'] = self.address.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in subscriptions (list)
        _items = []
        if self.subscriptions:
            for _item in self.subscriptions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['subscriptions'] = _items
        # override the default output from pydantic by calling `to_dict()` of discount
        if self.discount:
            _dict['discount'] = self.discount.to_dict()
        # set to None if first_name (nullable) is None
        # and model_fields_set contains the field
        if self.first_name is None and "first_name" in self.model_fields_set:
            _dict['first_name'] = None

        # set to None if last_name (nullable) is None
        # and model_fields_set contains the field
        if self.last_name is None and "last_name" in self.model_fields_set:
            _dict['last_name'] = None

        # set to None if address (nullable) is None
        # and model_fields_set contains the field
        if self.address is None and "address" in self.model_fields_set:
            _dict['address'] = None

        # set to None if balance_atom (nullable) is None
        # and model_fields_set contains the field
        if self.balance_atom is None and "balance_atom" in self.model_fields_set:
            _dict['balance_atom'] = None

        # set to None if discount (nullable) is None
        # and model_fields_set contains the field
        if self.discount is None and "discount" in self.model_fields_set:
            _dict['discount'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of CustomerExternal from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "object": obj.get("object"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "is_deleted": obj.get("is_deleted") if obj.get("is_deleted") is not None else False,
            "account_id": obj.get("account_id"),
            "email": obj.get("email"),
            "first_name": obj.get("first_name"),
            "last_name": obj.get("last_name"),
            "address": CompleteAddress.from_dict(obj.get("address")) if obj.get("address") is not None else None,
            "subscriptions": [SubscriptionExternal.from_dict(_item) for _item in obj.get("subscriptions")] if obj.get("subscriptions") is not None else None,
            "balance_atom": obj.get("balance_atom"),
            "discount": DiscountExternal.from_dict(obj.get("discount")) if obj.get("discount") is not None else None
        })
        return _obj


