# coding: utf-8

"""
    OpenPay API

    super charge your subscription management.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictInt, StrictStr
from pydantic import Field
from getopenpay.models.credit_note_item_external import CreditNoteItemExternal
from getopenpay.models.credit_note_reason import CreditNoteReason
from getopenpay.models.object_name import ObjectName
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class CreditNoteExternal(BaseModel):
    """
    CreditNoteExternal
    """ # noqa: E501
    id: StrictStr = Field(description="Unique Identifier of the credit_note.")
    object: Optional[ObjectName] = None
    created_at: datetime = Field(description="DateTime at which the object was created, in 'ISO 8601' format.")
    updated_at: datetime = Field(description="DateTime at which the object was updated, in 'ISO 8601' format.")
    is_deleted: Optional[StrictBool] = Field(default=False, description="If true, indicates that this object has been deleted")
    total_amount_atom: StrictInt = Field(description="The integer amount representing the total amount of the credit note. It is in atomic units (in USD this is cents).")
    currency: StrictStr
    reason: Optional[CreditNoteReason]
    invoice_id: StrictStr = Field(description="Unique ID of the invoice.")
    items: List[CreditNoteItemExternal]
    credit_amount_atom: StrictInt = Field(description="The integer amount representing the amount to credit the customer’s balance, which will be automatically applied to their next invoice. It is in atomic units (in USD this is cents).")
    refund_amount_atom: StrictInt = Field(description="The integer amount representing the amount to refund. If set, a refund will be created for the charge associated with the invoice. It is in atomic units (in USD this is cents).")
    __properties: ClassVar[List[str]] = ["id", "object", "created_at", "updated_at", "is_deleted", "total_amount_atom", "currency", "reason", "invoice_id", "items", "credit_amount_atom", "refund_amount_atom"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of CreditNoteExternal from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item in self.items:
                if _item:
                    _items.append(_item.to_dict())
            _dict['items'] = _items
        # set to None if reason (nullable) is None
        # and model_fields_set contains the field
        if self.reason is None and "reason" in self.model_fields_set:
            _dict['reason'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of CreditNoteExternal from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "object": obj.get("object"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "is_deleted": obj.get("is_deleted") if obj.get("is_deleted") is not None else False,
            "total_amount_atom": obj.get("total_amount_atom"),
            "currency": obj.get("currency"),
            "reason": obj.get("reason"),
            "invoice_id": obj.get("invoice_id"),
            "items": [CreditNoteItemExternal.from_dict(_item) for _item in obj.get("items")] if obj.get("items") is not None else None,
            "credit_amount_atom": obj.get("credit_amount_atom"),
            "refund_amount_atom": obj.get("refund_amount_atom")
        })
        return _obj


