# coding: utf-8

"""
    OpenPay API

    super charge your subscription management.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictInt, StrictStr
from pydantic import Field
from getopenpay.models.selected_price_quantity import SelectedPriceQuantity
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class CreateSubscriptionRequest(BaseModel):
    """
    CreateSubscriptionRequest
    """ # noqa: E501
    customer_id: StrictStr = Field(description="Unique Identifier of the customer.")
    payment_method_id: StrictStr = Field(description="ID of the default payment method for the subscription. It must belong to the customer associated with the subscription.")
    selected_product_price_quantity: List[SelectedPriceQuantity]
    total_amount_atom: StrictInt = Field(description="Total amount of this subscription. It is in atomic units (in USD this is cents).")
    cancel_at_end: Optional[StrictBool] = Field(default=False, description="Boolean indicating whether this subscription should cancel at the end of the current period.")
    description: Optional[StrictStr] = None
    trial_end: Optional[datetime] = None
    trial_period_days: Optional[StrictInt] = None
    trial_from_price: Optional[StrictBool] = None
    coupon_id: Optional[StrictStr] = None
    promotion_code_id: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["customer_id", "payment_method_id", "selected_product_price_quantity", "total_amount_atom", "cancel_at_end", "description", "trial_end", "trial_period_days", "trial_from_price", "coupon_id", "promotion_code_id"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of CreateSubscriptionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in selected_product_price_quantity (list)
        _items = []
        if self.selected_product_price_quantity:
            for _item in self.selected_product_price_quantity:
                if _item:
                    _items.append(_item.to_dict())
            _dict['selected_product_price_quantity'] = _items
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if trial_end (nullable) is None
        # and model_fields_set contains the field
        if self.trial_end is None and "trial_end" in self.model_fields_set:
            _dict['trial_end'] = None

        # set to None if trial_period_days (nullable) is None
        # and model_fields_set contains the field
        if self.trial_period_days is None and "trial_period_days" in self.model_fields_set:
            _dict['trial_period_days'] = None

        # set to None if trial_from_price (nullable) is None
        # and model_fields_set contains the field
        if self.trial_from_price is None and "trial_from_price" in self.model_fields_set:
            _dict['trial_from_price'] = None

        # set to None if coupon_id (nullable) is None
        # and model_fields_set contains the field
        if self.coupon_id is None and "coupon_id" in self.model_fields_set:
            _dict['coupon_id'] = None

        # set to None if promotion_code_id (nullable) is None
        # and model_fields_set contains the field
        if self.promotion_code_id is None and "promotion_code_id" in self.model_fields_set:
            _dict['promotion_code_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of CreateSubscriptionRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "customer_id": obj.get("customer_id"),
            "payment_method_id": obj.get("payment_method_id"),
            "selected_product_price_quantity": [SelectedPriceQuantity.from_dict(_item) for _item in obj.get("selected_product_price_quantity")] if obj.get("selected_product_price_quantity") is not None else None,
            "total_amount_atom": obj.get("total_amount_atom"),
            "cancel_at_end": obj.get("cancel_at_end") if obj.get("cancel_at_end") is not None else False,
            "description": obj.get("description"),
            "trial_end": obj.get("trial_end"),
            "trial_period_days": obj.get("trial_period_days"),
            "trial_from_price": obj.get("trial_from_price"),
            "coupon_id": obj.get("coupon_id"),
            "promotion_code_id": obj.get("promotion_code_id")
        })
        return _obj


