# coding: utf-8

"""
    OpenPay API

    super charge your subscription management.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictInt, StrictStr
from pydantic import Field
from getopenpay.models.proration_enum import ProrationEnum
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class CreateSubscriptionItemRequest(BaseModel):
    """
    CreateSubscriptionItemRequest
    """ # noqa: E501
    subscription_id: StrictStr = Field(description="The identifier of the subscription to modify")
    add_at_period_end: Optional[StrictBool] = Field(default=False, description="If the flag is set to True, item will be added when renewing the subscription at next billing cycle.")
    price_id: StrictStr = Field(description="The ID of the price.")
    quantity: Optional[StrictInt] = Field(default=1, description="The quantity you’d like to apply to the subscription item you’re creating.")
    proration_behavior: Optional[ProrationEnum] = None
    __properties: ClassVar[List[str]] = ["subscription_id", "add_at_period_end", "price_id", "quantity", "proration_behavior"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of CreateSubscriptionItemRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of CreateSubscriptionItemRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "subscription_id": obj.get("subscription_id"),
            "add_at_period_end": obj.get("add_at_period_end") if obj.get("add_at_period_end") is not None else False,
            "price_id": obj.get("price_id"),
            "quantity": obj.get("quantity") if obj.get("quantity") is not None else 1,
            "proration_behavior": obj.get("proration_behavior")
        })
        return _obj


