# coding: utf-8

"""
    OpenPay API

    super charge your subscription management.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictInt, StrictStr
from pydantic import Field
from getopenpay.models.refund_reason_enum import RefundReasonEnum
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class CreateRefundRequest(BaseModel):
    """
    CreateRefundRequest
    """ # noqa: E501
    charge_id: Optional[StrictStr] = None
    payment_intent_id: Optional[StrictStr] = None
    amount_atom: Optional[StrictInt] = None
    reason: Optional[RefundReasonEnum] = None
    description: Optional[StrictStr] = Field(default='Manually triggered refund by admin.', description="Description of the refund.")
    __properties: ClassVar[List[str]] = ["charge_id", "payment_intent_id", "amount_atom", "reason", "description"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of CreateRefundRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # set to None if charge_id (nullable) is None
        # and model_fields_set contains the field
        if self.charge_id is None and "charge_id" in self.model_fields_set:
            _dict['charge_id'] = None

        # set to None if payment_intent_id (nullable) is None
        # and model_fields_set contains the field
        if self.payment_intent_id is None and "payment_intent_id" in self.model_fields_set:
            _dict['payment_intent_id'] = None

        # set to None if amount_atom (nullable) is None
        # and model_fields_set contains the field
        if self.amount_atom is None and "amount_atom" in self.model_fields_set:
            _dict['amount_atom'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of CreateRefundRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "charge_id": obj.get("charge_id"),
            "payment_intent_id": obj.get("payment_intent_id"),
            "amount_atom": obj.get("amount_atom"),
            "reason": obj.get("reason"),
            "description": obj.get("description") if obj.get("description") is not None else 'Manually triggered refund by admin.'
        })
        return _obj


