# coding: utf-8

"""
    OpenPay API

    super charge your subscription management.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictStr
from pydantic import Field
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class CreateProductRequest(BaseModel):
    """
    CreateProductRequest
    """ # noqa: E501
    name: StrictStr = Field(description="Name of product.")
    description: StrictStr = Field(description="Product's description.")
    account_sku: Optional[StrictStr] = None
    features: Optional[List[StrictStr]] = None
    unit_label: Optional[StrictStr] = None
    is_active: Optional[StrictBool] = Field(default=True, description="Whether or not this product is accepting new subscriptions.")
    __properties: ClassVar[List[str]] = ["name", "description", "account_sku", "features", "unit_label", "is_active"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of CreateProductRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # set to None if account_sku (nullable) is None
        # and model_fields_set contains the field
        if self.account_sku is None and "account_sku" in self.model_fields_set:
            _dict['account_sku'] = None

        # set to None if unit_label (nullable) is None
        # and model_fields_set contains the field
        if self.unit_label is None and "unit_label" in self.model_fields_set:
            _dict['unit_label'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of CreateProductRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "account_sku": obj.get("account_sku"),
            "features": obj.get("features"),
            "unit_label": obj.get("unit_label"),
            "is_active": obj.get("is_active") if obj.get("is_active") is not None else True
        })
        return _obj


