# coding: utf-8

"""
    OpenPay API

    super charge your subscription management.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictStr
from pydantic import Field
from getopenpay.models.checkout_mode import CheckoutMode
from getopenpay.models.create_checkout_line_item import CreateCheckoutLineItem
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class CreatePaymentLinkRequest(BaseModel):
    """
    CreatePaymentLinkRequest
    """ # noqa: E501
    line_items: Optional[List[CreateCheckoutLineItem]] = None
    mode: CheckoutMode
    success_url: StrictStr = Field(description="The URL to which OpenPay should send customers when payment or setup is complete.")
    __properties: ClassVar[List[str]] = ["line_items", "mode", "success_url"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of CreatePaymentLinkRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in line_items (list)
        _items = []
        if self.line_items:
            for _item in self.line_items:
                if _item:
                    _items.append(_item.to_dict())
            _dict['line_items'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of CreatePaymentLinkRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "line_items": [CreateCheckoutLineItem.from_dict(_item) for _item in obj.get("line_items")] if obj.get("line_items") is not None else None,
            "mode": obj.get("mode"),
            "success_url": obj.get("success_url")
        })
        return _obj


