# coding: utf-8

"""
    OpenPay API

    super charge your subscription management.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictStr
from pydantic import Field
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class CreateCustomerRequest(BaseModel):
    """
    CreateCustomerRequest
    """ # noqa: E501
    first_name: StrictStr = Field(description="The customer’s first name.")
    last_name: StrictStr = Field(description="The customer’s last name.")
    line1: Optional[StrictStr] = None
    line2: Optional[StrictStr] = None
    line3: Optional[StrictStr] = None
    city: Optional[StrictStr] = None
    state: StrictStr = Field(description="State, province, or region.")
    country: StrictStr = Field(description="Country name. If possible two-letter country code.")
    zip_code: StrictStr = Field(description="ZIP or postal code.")
    coupon_id: Optional[StrictStr] = None
    promotion_code_id: Optional[StrictStr] = None
    email: StrictStr = Field(description="The customer’s email address.")
    __properties: ClassVar[List[str]] = ["first_name", "last_name", "line1", "line2", "line3", "city", "state", "country", "zip_code", "coupon_id", "promotion_code_id", "email"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of CreateCustomerRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # set to None if line1 (nullable) is None
        # and model_fields_set contains the field
        if self.line1 is None and "line1" in self.model_fields_set:
            _dict['line1'] = None

        # set to None if line2 (nullable) is None
        # and model_fields_set contains the field
        if self.line2 is None and "line2" in self.model_fields_set:
            _dict['line2'] = None

        # set to None if line3 (nullable) is None
        # and model_fields_set contains the field
        if self.line3 is None and "line3" in self.model_fields_set:
            _dict['line3'] = None

        # set to None if city (nullable) is None
        # and model_fields_set contains the field
        if self.city is None and "city" in self.model_fields_set:
            _dict['city'] = None

        # set to None if coupon_id (nullable) is None
        # and model_fields_set contains the field
        if self.coupon_id is None and "coupon_id" in self.model_fields_set:
            _dict['coupon_id'] = None

        # set to None if promotion_code_id (nullable) is None
        # and model_fields_set contains the field
        if self.promotion_code_id is None and "promotion_code_id" in self.model_fields_set:
            _dict['promotion_code_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of CreateCustomerRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "first_name": obj.get("first_name"),
            "last_name": obj.get("last_name"),
            "line1": obj.get("line1"),
            "line2": obj.get("line2"),
            "line3": obj.get("line3"),
            "city": obj.get("city"),
            "state": obj.get("state"),
            "country": obj.get("country"),
            "zip_code": obj.get("zip_code"),
            "coupon_id": obj.get("coupon_id"),
            "promotion_code_id": obj.get("promotion_code_id"),
            "email": obj.get("email")
        })
        return _obj


