# coding: utf-8

"""
    OpenPay API

    super charge your subscription management.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictInt, StrictStr
from pydantic import Field
from getopenpay.models.create_credit_note_line import CreateCreditNoteLine
from getopenpay.models.credit_note_reason import CreditNoteReason
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class CreateCreditNoteRequest(BaseModel):
    """
    CreateCreditNoteRequest
    """ # noqa: E501
    invoice_id: StrictStr = Field(description="ID of the invoice")
    reason: Optional[CreditNoteReason] = None
    total_amount_atom: StrictInt = Field(description="The int amount representing the total amount of the credit note.")
    credit_amount_atom: Optional[StrictInt] = Field(default=0, description="The integer amount representing the amount to credit the customer’s balance, which will be automatically applied to their next invoice.")
    refund_amount_atom: Optional[StrictInt] = Field(default=0, description="The integer amount representing the amount to refund. If set, a refund will be created for the charge associated with the invoice.")
    lines: List[CreateCreditNoteLine]
    currency: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["invoice_id", "reason", "total_amount_atom", "credit_amount_atom", "refund_amount_atom", "lines", "currency"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of CreateCreditNoteRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in lines (list)
        _items = []
        if self.lines:
            for _item in self.lines:
                if _item:
                    _items.append(_item.to_dict())
            _dict['lines'] = _items
        # set to None if reason (nullable) is None
        # and model_fields_set contains the field
        if self.reason is None and "reason" in self.model_fields_set:
            _dict['reason'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of CreateCreditNoteRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "invoice_id": obj.get("invoice_id"),
            "reason": obj.get("reason"),
            "total_amount_atom": obj.get("total_amount_atom"),
            "credit_amount_atom": obj.get("credit_amount_atom") if obj.get("credit_amount_atom") is not None else 0,
            "refund_amount_atom": obj.get("refund_amount_atom") if obj.get("refund_amount_atom") is not None else 0,
            "lines": [CreateCreditNoteLine.from_dict(_item) for _item in obj.get("lines")] if obj.get("lines") is not None else None,
            "currency": obj.get("currency")
        })
        return _obj


