# coding: utf-8

"""
    OpenPay API

    super charge your subscription management.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictInt, StrictStr
from pydantic import Field
from getopenpay.models.credit_note_line_type import CreditNoteLineType
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class CreateCreditNoteLine(BaseModel):
    """
    CreateCreditNoteLine
    """ # noqa: E501
    amount_atom: StrictInt = Field(description="The integer amount representing the gross amount being credited for this line item.")
    currency: StrictStr
    type: CreditNoteLineType
    quantity: Optional[StrictInt] = 1
    invoice_item_id: Optional[StrictStr] = None
    unit_amount_atom: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["amount_atom", "currency", "type", "quantity", "invoice_item_id", "unit_amount_atom"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of CreateCreditNoteLine from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # set to None if invoice_item_id (nullable) is None
        # and model_fields_set contains the field
        if self.invoice_item_id is None and "invoice_item_id" in self.model_fields_set:
            _dict['invoice_item_id'] = None

        # set to None if unit_amount_atom (nullable) is None
        # and model_fields_set contains the field
        if self.unit_amount_atom is None and "unit_amount_atom" in self.model_fields_set:
            _dict['unit_amount_atom'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of CreateCreditNoteLine from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "amount_atom": obj.get("amount_atom"),
            "currency": obj.get("currency"),
            "type": obj.get("type"),
            "quantity": obj.get("quantity") if obj.get("quantity") is not None else 1,
            "invoice_item_id": obj.get("invoice_item_id"),
            "unit_amount_atom": obj.get("unit_amount_atom")
        })
        return _obj


