# coding: utf-8

"""
    OpenPay API

    super charge your subscription management.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictInt, StrictStr
from pydantic import Field
from typing_extensions import Annotated
from getopenpay.models.coupon_duration import CouponDuration
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class CreateCouponRequest(BaseModel):
    """
    CreateCouponRequest
    """ # noqa: E501
    name: StrictStr = Field(description="Name of the coupon displayed to customers on, for instance invoices, or receipts.")
    amount_atom_off: Optional[StrictInt] = None
    percent_off: Optional[Annotated[int, Field(le=100, strict=True)]] = None
    currency: Optional[StrictStr] = None
    duration: Optional[CouponDuration] = None
    duration_in_months: Optional[StrictInt] = None
    product_ids: Optional[List[StrictStr]] = None
    product_family_ids: Optional[List[StrictStr]] = None
    max_redemptions: Optional[StrictInt] = None
    redeem_by: Optional[datetime] = None
    is_active: Optional[StrictBool] = Field(default=True, description="Whether the coupon is available to be redeemed.")
    __properties: ClassVar[List[str]] = ["name", "amount_atom_off", "percent_off", "currency", "duration", "duration_in_months", "product_ids", "product_family_ids", "max_redemptions", "redeem_by", "is_active"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of CreateCouponRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # set to None if amount_atom_off (nullable) is None
        # and model_fields_set contains the field
        if self.amount_atom_off is None and "amount_atom_off" in self.model_fields_set:
            _dict['amount_atom_off'] = None

        # set to None if percent_off (nullable) is None
        # and model_fields_set contains the field
        if self.percent_off is None and "percent_off" in self.model_fields_set:
            _dict['percent_off'] = None

        # set to None if duration_in_months (nullable) is None
        # and model_fields_set contains the field
        if self.duration_in_months is None and "duration_in_months" in self.model_fields_set:
            _dict['duration_in_months'] = None

        # set to None if max_redemptions (nullable) is None
        # and model_fields_set contains the field
        if self.max_redemptions is None and "max_redemptions" in self.model_fields_set:
            _dict['max_redemptions'] = None

        # set to None if redeem_by (nullable) is None
        # and model_fields_set contains the field
        if self.redeem_by is None and "redeem_by" in self.model_fields_set:
            _dict['redeem_by'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of CreateCouponRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "amount_atom_off": obj.get("amount_atom_off"),
            "percent_off": obj.get("percent_off"),
            "currency": obj.get("currency"),
            "duration": obj.get("duration"),
            "duration_in_months": obj.get("duration_in_months"),
            "product_ids": obj.get("product_ids"),
            "product_family_ids": obj.get("product_family_ids"),
            "max_redemptions": obj.get("max_redemptions"),
            "redeem_by": obj.get("redeem_by"),
            "is_active": obj.get("is_active") if obj.get("is_active") is not None else True
        })
        return _obj


