# coding: utf-8

"""
    OpenPay API

    super charge your subscription management.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictStr
from getopenpay.models.checkout_mode import CheckoutMode
from getopenpay.models.create_checkout_line_item import CreateCheckoutLineItem
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class CreateCheckoutSessionRequest(BaseModel):
    """
    CreateCheckoutSessionRequest
    """ # noqa: E501
    client_reference_id: Optional[StrictStr] = None
    currency: Optional[StrictStr] = None
    customer_id: Optional[StrictStr] = None
    customer_email: Optional[StrictStr] = None
    line_items: Optional[List[CreateCheckoutLineItem]] = None
    mode: CheckoutMode
    return_url: Optional[StrictStr] = None
    success_url: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["client_reference_id", "currency", "customer_id", "customer_email", "line_items", "mode", "return_url", "success_url"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of CreateCheckoutSessionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in line_items (list)
        _items = []
        if self.line_items:
            for _item in self.line_items:
                if _item:
                    _items.append(_item.to_dict())
            _dict['line_items'] = _items
        # set to None if client_reference_id (nullable) is None
        # and model_fields_set contains the field
        if self.client_reference_id is None and "client_reference_id" in self.model_fields_set:
            _dict['client_reference_id'] = None

        # set to None if customer_id (nullable) is None
        # and model_fields_set contains the field
        if self.customer_id is None and "customer_id" in self.model_fields_set:
            _dict['customer_id'] = None

        # set to None if customer_email (nullable) is None
        # and model_fields_set contains the field
        if self.customer_email is None and "customer_email" in self.model_fields_set:
            _dict['customer_email'] = None

        # set to None if return_url (nullable) is None
        # and model_fields_set contains the field
        if self.return_url is None and "return_url" in self.model_fields_set:
            _dict['return_url'] = None

        # set to None if success_url (nullable) is None
        # and model_fields_set contains the field
        if self.success_url is None and "success_url" in self.model_fields_set:
            _dict['success_url'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of CreateCheckoutSessionRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "client_reference_id": obj.get("client_reference_id"),
            "currency": obj.get("currency"),
            "customer_id": obj.get("customer_id"),
            "customer_email": obj.get("customer_email"),
            "line_items": [CreateCheckoutLineItem.from_dict(_item) for _item in obj.get("line_items")] if obj.get("line_items") is not None else None,
            "mode": obj.get("mode"),
            "return_url": obj.get("return_url"),
            "success_url": obj.get("success_url")
        })
        return _obj


