# coding: utf-8

"""
    OpenPay API

    super charge your subscription management.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictInt, StrictStr
from pydantic import Field
from getopenpay.models.checkout_mode import CheckoutMode
from getopenpay.models.checkout_session_line_item_external import CheckoutSessionLineItemExternal
from getopenpay.models.checkout_session_status import CheckoutSessionStatus
from getopenpay.models.object_name import ObjectName
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class CheckoutSessionExternal(BaseModel):
    """
    CheckoutSessionExternal
    """ # noqa: E501
    id: StrictStr = Field(description="Unique Identifier of the checkout session.")
    object: Optional[ObjectName] = None
    created_at: datetime = Field(description="DateTime at which the object was created, in 'ISO 8601' format.")
    updated_at: datetime = Field(description="DateTime at which the object was updated, in 'ISO 8601' format.")
    is_deleted: Optional[StrictBool] = Field(default=False, description="If true, indicates that this object has been deleted")
    account_id: StrictStr = Field(description="Unique Identifier of the account.")
    account_name: StrictStr = Field(description="Name of the account.")
    amount_subtotal_atom: StrictInt = Field(description="The integer amount representing the subtotal amount for the line items.")
    amount_total_atom: StrictInt = Field(description="The integer amount representing the total amount for the line items, after discounts and taxes.")
    client_reference_id: Optional[StrictStr] = None
    currency: Optional[StrictStr]
    customer_id: Optional[StrictStr]
    customer_email: Optional[StrictStr]
    line_items: List[CheckoutSessionLineItemExternal]
    mode: CheckoutMode
    payment_intent_id: Optional[StrictStr]
    return_url: Optional[StrictStr]
    secure_token: StrictStr = Field(description="The random secure token associated with the checkout session.")
    status: CheckoutSessionStatus
    subscription_id: Optional[StrictStr]
    success_url: Optional[StrictStr]
    tax_amount_atom: StrictInt = Field(description="The integer amount representing the tax amount for the line items.")
    url: StrictStr = Field(description="The main URL for this checkout session.")
    __properties: ClassVar[List[str]] = ["id", "object", "created_at", "updated_at", "is_deleted", "account_id", "account_name", "amount_subtotal_atom", "amount_total_atom", "client_reference_id", "currency", "customer_id", "customer_email", "line_items", "mode", "payment_intent_id", "return_url", "secure_token", "status", "subscription_id", "success_url", "tax_amount_atom", "url"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of CheckoutSessionExternal from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in line_items (list)
        _items = []
        if self.line_items:
            for _item in self.line_items:
                if _item:
                    _items.append(_item.to_dict())
            _dict['line_items'] = _items
        # set to None if client_reference_id (nullable) is None
        # and model_fields_set contains the field
        if self.client_reference_id is None and "client_reference_id" in self.model_fields_set:
            _dict['client_reference_id'] = None

        # set to None if currency (nullable) is None
        # and model_fields_set contains the field
        if self.currency is None and "currency" in self.model_fields_set:
            _dict['currency'] = None

        # set to None if customer_id (nullable) is None
        # and model_fields_set contains the field
        if self.customer_id is None and "customer_id" in self.model_fields_set:
            _dict['customer_id'] = None

        # set to None if customer_email (nullable) is None
        # and model_fields_set contains the field
        if self.customer_email is None and "customer_email" in self.model_fields_set:
            _dict['customer_email'] = None

        # set to None if payment_intent_id (nullable) is None
        # and model_fields_set contains the field
        if self.payment_intent_id is None and "payment_intent_id" in self.model_fields_set:
            _dict['payment_intent_id'] = None

        # set to None if return_url (nullable) is None
        # and model_fields_set contains the field
        if self.return_url is None and "return_url" in self.model_fields_set:
            _dict['return_url'] = None

        # set to None if subscription_id (nullable) is None
        # and model_fields_set contains the field
        if self.subscription_id is None and "subscription_id" in self.model_fields_set:
            _dict['subscription_id'] = None

        # set to None if success_url (nullable) is None
        # and model_fields_set contains the field
        if self.success_url is None and "success_url" in self.model_fields_set:
            _dict['success_url'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of CheckoutSessionExternal from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "object": obj.get("object"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "is_deleted": obj.get("is_deleted") if obj.get("is_deleted") is not None else False,
            "account_id": obj.get("account_id"),
            "account_name": obj.get("account_name"),
            "amount_subtotal_atom": obj.get("amount_subtotal_atom"),
            "amount_total_atom": obj.get("amount_total_atom"),
            "client_reference_id": obj.get("client_reference_id"),
            "currency": obj.get("currency"),
            "customer_id": obj.get("customer_id"),
            "customer_email": obj.get("customer_email"),
            "line_items": [CheckoutSessionLineItemExternal.from_dict(_item) for _item in obj.get("line_items")] if obj.get("line_items") is not None else None,
            "mode": obj.get("mode"),
            "payment_intent_id": obj.get("payment_intent_id"),
            "return_url": obj.get("return_url"),
            "secure_token": obj.get("secure_token"),
            "status": obj.get("status"),
            "subscription_id": obj.get("subscription_id"),
            "success_url": obj.get("success_url"),
            "tax_amount_atom": obj.get("tax_amount_atom"),
            "url": obj.get("url")
        })
        return _obj


