# coding: utf-8

"""
    OpenPay API

    super charge your subscription management.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictInt, StrictStr
from pydantic import Field
from getopenpay.models.charge_status_enum import ChargeStatusEnum
from getopenpay.models.object_name import ObjectName
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class ChargeExternal(BaseModel):
    """
    ChargeExternal
    """ # noqa: E501
    id: StrictStr = Field(description="Unique Identifier of the charge.")
    object: Optional[ObjectName] = None
    created_at: datetime = Field(description="DateTime at which the object was created, in 'ISO 8601' format.")
    updated_at: datetime = Field(description="DateTime at which the object was updated, in 'ISO 8601' format.")
    is_deleted: Optional[StrictBool] = Field(default=False, description="If true, indicates that this object has been deleted")
    amount_atom: StrictInt = Field(description="Amount charged, in smallest currency unit.")
    currency: StrictStr
    customer_id: StrictStr = Field(description="Unique Identifier of the customer associated with this charge.")
    payment_method_id: StrictStr = Field(description="Unique Identifier of the payment method used for this charge.")
    payment_intent_id: StrictStr = Field(description="Unique Identifier of the payment intent associated with this charge.")
    invoice_id: Optional[StrictStr]
    status: ChargeStatusEnum
    refunded: StrictBool = Field(description="Indicates whether the charge has been refunded.")
    refunded_amount_atom: StrictInt = Field(description="Amount refunded, in smallest currency unit.")
    disputed: StrictBool = Field(description="Indicates whether the charge is disputed.")
    failure_code: Optional[StrictStr]
    failure_message: Optional[StrictStr]
    __properties: ClassVar[List[str]] = ["id", "object", "created_at", "updated_at", "is_deleted", "amount_atom", "currency", "customer_id", "payment_method_id", "payment_intent_id", "invoice_id", "status", "refunded", "refunded_amount_atom", "disputed", "failure_code", "failure_message"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of ChargeExternal from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # set to None if invoice_id (nullable) is None
        # and model_fields_set contains the field
        if self.invoice_id is None and "invoice_id" in self.model_fields_set:
            _dict['invoice_id'] = None

        # set to None if failure_code (nullable) is None
        # and model_fields_set contains the field
        if self.failure_code is None and "failure_code" in self.model_fields_set:
            _dict['failure_code'] = None

        # set to None if failure_message (nullable) is None
        # and model_fields_set contains the field
        if self.failure_message is None and "failure_message" in self.model_fields_set:
            _dict['failure_message'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of ChargeExternal from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "object": obj.get("object"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "is_deleted": obj.get("is_deleted") if obj.get("is_deleted") is not None else False,
            "amount_atom": obj.get("amount_atom"),
            "currency": obj.get("currency"),
            "customer_id": obj.get("customer_id"),
            "payment_method_id": obj.get("payment_method_id"),
            "payment_intent_id": obj.get("payment_intent_id"),
            "invoice_id": obj.get("invoice_id"),
            "status": obj.get("status"),
            "refunded": obj.get("refunded"),
            "refunded_amount_atom": obj.get("refunded_amount_atom"),
            "disputed": obj.get("disputed"),
            "failure_code": obj.get("failure_code"),
            "failure_message": obj.get("failure_message")
        })
        return _obj


