# getopenpay
super charge your subscription management.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import getopenpay
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import getopenpay
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import getopenpay
from getopenpay.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://connto.getopenpay.com
# See configuration.py for a list of all supported configuration parameters.
configuration = getopenpay.Configuration(
    host = "https://connto.getopenpay.com"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization: HTTPBearer
configuration = getopenpay.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
with getopenpay.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = getopenpay.BillingPortalApi(api_client)
    create_portal_session_request = getopenpay.CreatePortalSessionRequest() # CreatePortalSessionRequest | 

    try:
        # Create Portal Session
        api_response = api_instance.create_portal_session(create_portal_session_request)
        print("The response of BillingPortalApi->create_portal_session:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling BillingPortalApi->create_portal_session: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://connto.getopenpay.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*BillingPortalApi* | [**create_portal_session**](docs/BillingPortalApi.md#create_portal_session) | **POST** /billing_portal/sessions | Create Portal Session
*ChargesApi* | [**list_charges**](docs/ChargesApi.md#list_charges) | **POST** /charges/list | List Charges
*ChargesApi* | [**search_charges**](docs/ChargesApi.md#search_charges) | **POST** /charges/search | Search Charges
*CheckoutApi* | [**create_checkout_session**](docs/CheckoutApi.md#create_checkout_session) | **POST** /checkout/sessions | Create Checkout Session
*CheckoutApi* | [**get_checkout_session**](docs/CheckoutApi.md#get_checkout_session) | **GET** /checkout/sessions/{session_id} | Get Checkout Session
*CheckoutApi* | [**list_checkout_sessions**](docs/CheckoutApi.md#list_checkout_sessions) | **POST** /checkout/list | List Checkout Sessions
*CouponsApi* | [**create_coupon**](docs/CouponsApi.md#create_coupon) | **POST** /coupons/ | Create Coupon
*CouponsApi* | [**delete_coupon**](docs/CouponsApi.md#delete_coupon) | **DELETE** /coupons/{coupon_id} | Delete Coupon
*CouponsApi* | [**get_coupon**](docs/CouponsApi.md#get_coupon) | **GET** /coupons/{coupon_id} | Get Coupon
*CouponsApi* | [**list_coupons**](docs/CouponsApi.md#list_coupons) | **POST** /coupons/list | List Coupons
*CouponsApi* | [**update_coupon**](docs/CouponsApi.md#update_coupon) | **PUT** /coupons/{coupon_id} | Update Coupon
*CreditNotesApi* | [**create_credit_note**](docs/CreditNotesApi.md#create_credit_note) | **POST** /credit-notes/ | Create Credit Note
*CreditNotesApi* | [**get_credit_note**](docs/CreditNotesApi.md#get_credit_note) | **GET** /credit-notes/{credit_note_id} | Get Credit Note
*CreditNotesApi* | [**list_credit_notes**](docs/CreditNotesApi.md#list_credit_notes) | **POST** /credit-notes/list | List Credit Notes
*CustomersApi* | [**create_customer**](docs/CustomersApi.md#create_customer) | **POST** /customers/ | Create Customer
*CustomersApi* | [**create_customer_balance_transaction**](docs/CustomersApi.md#create_customer_balance_transaction) | **POST** /customers/{customer_id}/balance-transactions | Create Customer Balance Transaction
*CustomersApi* | [**delete_customer_discount**](docs/CustomersApi.md#delete_customer_discount) | **DELETE** /customers/{customer_id}/discount | Delete Customer Discount
*CustomersApi* | [**get_customer**](docs/CustomersApi.md#get_customer) | **GET** /customers/{customer_id} | Get Customer
*CustomersApi* | [**get_customer_balance_transaction**](docs/CustomersApi.md#get_customer_balance_transaction) | **GET** /customers/{customer_id}/balance-transactions/{transaction_id} | Get Customer Balance Transaction
*CustomersApi* | [**get_customer_balance_transactions**](docs/CustomersApi.md#get_customer_balance_transactions) | **GET** /customers/{customer_id}/balance-transactions | Get Customer Balance Transactions
*CustomersApi* | [**list_customer_payment_methods**](docs/CustomersApi.md#list_customer_payment_methods) | **POST** /customers/{customer_id}/payment-methods | List Customer Payment Methods
*CustomersApi* | [**list_customers**](docs/CustomersApi.md#list_customers) | **POST** /customers/list | List Customers
*CustomersApi* | [**list_valid_subscriptions**](docs/CustomersApi.md#list_valid_subscriptions) | **POST** /customers{customer_id}/list_valid_subscriptions | List Valid Subscriptions
*CustomersApi* | [**search_customers**](docs/CustomersApi.md#search_customers) | **POST** /customers/search | Search Customers
*CustomersApi* | [**update_customer**](docs/CustomersApi.md#update_customer) | **PUT** /customers/{customer_external_id} | Update Customer
*EventsApi* | [**get_event**](docs/EventsApi.md#get_event) | **GET** /events/{event_id} | Get Event
*EventsApi* | [**list_events**](docs/EventsApi.md#list_events) | **POST** /events/list | List Events
*EventsApi* | [**search_events**](docs/EventsApi.md#search_events) | **POST** /events/search | Search Events
*InvoiceItemsApi* | [**delete_invoice_item_by_id**](docs/InvoiceItemsApi.md#delete_invoice_item_by_id) | **DELETE** /invoice-items/{invoice_item_id} | Delete Invoice Item By Id
*InvoiceItemsApi* | [**get_invoice_item**](docs/InvoiceItemsApi.md#get_invoice_item) | **GET** /invoice-items/{invoice_item_id} | Get Invoice Item
*InvoiceItemsApi* | [**list_invoice_items**](docs/InvoiceItemsApi.md#list_invoice_items) | **POST** /invoice-items/list | List Invoice Items
*InvoicesApi* | [**create_invoice**](docs/InvoicesApi.md#create_invoice) | **POST** /invoices/ | Create Invoice
*InvoicesApi* | [**finalize_invoice**](docs/InvoicesApi.md#finalize_invoice) | **POST** /invoices/{invoice_external_id}/finalize | Finalize Invoice
*InvoicesApi* | [**get_invoice**](docs/InvoicesApi.md#get_invoice) | **GET** /invoices/{invoice_external_id} | Get Invoice
*InvoicesApi* | [**get_invoice_public**](docs/InvoicesApi.md#get_invoice_public) | **GET** /invoices/public/{public_permanent_token} | Get Invoice Public
*InvoicesApi* | [**list_invoices**](docs/InvoicesApi.md#list_invoices) | **POST** /invoices/list | List Invoices
*InvoicesApi* | [**mark_invoice_as_uncollectible**](docs/InvoicesApi.md#mark_invoice_as_uncollectible) | **POST** /invoices/{invoice_external_id}/mark_uncollectible | Mark Invoice As Uncollectible
*InvoicesApi* | [**mark_invoice_as_void**](docs/InvoicesApi.md#mark_invoice_as_void) | **POST** /invoices/{invoice_external_id}/void | Mark Invoice As Void
*InvoicesApi* | [**pay_invoice**](docs/InvoicesApi.md#pay_invoice) | **POST** /invoices/{invoice_external_id}/pay | Pay Invoice
*InvoicesApi* | [**search_invoices**](docs/InvoicesApi.md#search_invoices) | **POST** /invoices/search | Search Invoices
*InvoicesApi* | [**update_invoice**](docs/InvoicesApi.md#update_invoice) | **PUT** /invoices/{invoice_id} | Update Invoice
*PaymentIntentsApi* | [**get_payment_intent**](docs/PaymentIntentsApi.md#get_payment_intent) | **GET** /payment-intents/{payment_intent_id} | Get Payment Intent
*PaymentIntentsApi* | [**list_payment_intents**](docs/PaymentIntentsApi.md#list_payment_intents) | **POST** /payment-intents/list | List Payment Intents
*PaymentIntentsApi* | [**search_payment_intents**](docs/PaymentIntentsApi.md#search_payment_intents) | **POST** /payment-intents/search | Search Payment Intents
*PaymentLinksApi* | [**create_payment_link**](docs/PaymentLinksApi.md#create_payment_link) | **POST** /payment-link/ | Create Payment Link
*PaymentLinksApi* | [**get_payment_link**](docs/PaymentLinksApi.md#get_payment_link) | **GET** /payment-link/{plink_id} | Get Payment Link
*PaymentLinksApi* | [**list_payment_links**](docs/PaymentLinksApi.md#list_payment_links) | **POST** /payment-link/list | List Payment Links
*PaymentLinksApi* | [**open_payment_link_page_public**](docs/PaymentLinksApi.md#open_payment_link_page_public) | **GET** /payment-link/public/{secure_token} | Open Payment Link Page Public
*PaymentMethodsApi* | [**attach_payment_method**](docs/PaymentMethodsApi.md#attach_payment_method) | **POST** /payment-methods/{payment_method_id}/attach | Attach Payment Method
*PaymentMethodsApi* | [**authorize_credit_card**](docs/PaymentMethodsApi.md#authorize_credit_card) | **PUT** /payment-methods/{payment_method_id}/authorize | Authorize Credit Card
*PaymentMethodsApi* | [**detach_payment_method**](docs/PaymentMethodsApi.md#detach_payment_method) | **POST** /payment-methods/{payment_method_id}/detach | Detach Payment Method
*PaymentMethodsApi* | [**get_payment_method**](docs/PaymentMethodsApi.md#get_payment_method) | **GET** /payment-methods/{payment_method_id} | Get Payment Method
*PricesApi* | [**create_price_for_product**](docs/PricesApi.md#create_price_for_product) | **POST** /prices/ | Create Price For Product
*PricesApi* | [**delete_price_for_product**](docs/PricesApi.md#delete_price_for_product) | **DELETE** /prices/{price_id} | Delete Price For Product
*PricesApi* | [**get_price_for_product**](docs/PricesApi.md#get_price_for_product) | **GET** /prices/{price_id} | Get Price For Product
*PricesApi* | [**list_prices**](docs/PricesApi.md#list_prices) | **POST** /prices/list | List Prices
*PricesApi* | [**search_prices**](docs/PricesApi.md#search_prices) | **POST** /prices/search | Search Prices
*PricesApi* | [**update_price_for_product**](docs/PricesApi.md#update_price_for_product) | **PUT** /prices/{price_id} | Update Price For Product
*ProductFamilyApi* | [**create_product_family**](docs/ProductFamilyApi.md#create_product_family) | **POST** /product-family/ | Create Product Family
*ProductFamilyApi* | [**delete_product_family**](docs/ProductFamilyApi.md#delete_product_family) | **DELETE** /product-family/{id} | Delete Product Family
*ProductFamilyApi* | [**get_product_family**](docs/ProductFamilyApi.md#get_product_family) | **GET** /product-family/{id} | Get Product Family
*ProductFamilyApi* | [**list_product_families**](docs/ProductFamilyApi.md#list_product_families) | **POST** /product-family/list | List Product Families
*ProductFamilyApi* | [**update_product_family**](docs/ProductFamilyApi.md#update_product_family) | **PUT** /product-family/{id} | Update Product Family
*ProductsApi* | [**create_product**](docs/ProductsApi.md#create_product) | **POST** /products/ | Create Product
*ProductsApi* | [**delete_product**](docs/ProductsApi.md#delete_product) | **DELETE** /products/{product_id} | Delete Product
*ProductsApi* | [**get_product**](docs/ProductsApi.md#get_product) | **GET** /products/{product_id} | Get Product
*ProductsApi* | [**list_products**](docs/ProductsApi.md#list_products) | **POST** /products/list | List Products
*ProductsApi* | [**search_products**](docs/ProductsApi.md#search_products) | **POST** /products/search | Search Products
*ProductsApi* | [**update_product**](docs/ProductsApi.md#update_product) | **PUT** /products/{product_id} | Update Product
*PromotionCodesApi* | [**create_promo_code**](docs/PromotionCodesApi.md#create_promo_code) | **POST** /promotion-codes/ | Create Promo Code
*PromotionCodesApi* | [**get_promo_code**](docs/PromotionCodesApi.md#get_promo_code) | **GET** /promotion-codes/{promo_code_id} | Get Promo Code
*PromotionCodesApi* | [**list_promo_codes**](docs/PromotionCodesApi.md#list_promo_codes) | **POST** /promotion-codes/list | List Promo Codes
*PromotionCodesApi* | [**update_promo_code**](docs/PromotionCodesApi.md#update_promo_code) | **PUT** /promotion-codes/{promo_code_id} | Update Promo Code
*RefundsApi* | [**create_refund**](docs/RefundsApi.md#create_refund) | **POST** /refunds/ | Create Refund
*RefundsApi* | [**list_refunds**](docs/RefundsApi.md#list_refunds) | **POST** /refunds/list | List Refunds
*SubscriptionItemsApi* | [**create_subscription_item**](docs/SubscriptionItemsApi.md#create_subscription_item) | **POST** /subscription-items/ | Create Subscription Item
*SubscriptionItemsApi* | [**delete_subscription_item**](docs/SubscriptionItemsApi.md#delete_subscription_item) | **DELETE** /subscription-items/{subscription_item_id} | Delete Subscription Item
*SubscriptionItemsApi* | [**get_subscription_item**](docs/SubscriptionItemsApi.md#get_subscription_item) | **GET** /subscription-items/{subscription_item_id} | Get Subscription Item
*SubscriptionItemsApi* | [**list_subscription_items**](docs/SubscriptionItemsApi.md#list_subscription_items) | **POST** /subscription-items/list | List Subscription Items
*SubscriptionItemsApi* | [**update_subscription_item**](docs/SubscriptionItemsApi.md#update_subscription_item) | **PUT** /subscription-items/{subscription_item_id} | Update Subscription Item
*SubscriptionsApi* | [**create_subscriptions**](docs/SubscriptionsApi.md#create_subscriptions) | **POST** /subscriptions/ | Create Subscriptions
*SubscriptionsApi* | [**delete_subscription**](docs/SubscriptionsApi.md#delete_subscription) | **DELETE** /subscriptions/{subscription_id} | Delete Subscription
*SubscriptionsApi* | [**delete_subscription_discount**](docs/SubscriptionsApi.md#delete_subscription_discount) | **DELETE** /subscriptions/{subscription_id}/discount | Delete Subscription Discount
*SubscriptionsApi* | [**get_subscription**](docs/SubscriptionsApi.md#get_subscription) | **GET** /subscriptions/{subscription_id} | Get Subscription
*SubscriptionsApi* | [**list_subscriptions**](docs/SubscriptionsApi.md#list_subscriptions) | **POST** /subscriptions/list | List Subscriptions
*SubscriptionsApi* | [**pause_subscription**](docs/SubscriptionsApi.md#pause_subscription) | **PUT** /subscriptions/{subscription_id}/pause | Pause Subscription
*SubscriptionsApi* | [**refresh_subscription_status**](docs/SubscriptionsApi.md#refresh_subscription_status) | **POST** /subscriptions/{subscription_id}/refresh-status | Refresh Subscription Status
*SubscriptionsApi* | [**resume_subscription**](docs/SubscriptionsApi.md#resume_subscription) | **PUT** /subscriptions/{subscription_id}/resume | Resume Subscription
*SubscriptionsApi* | [**search_subscriptions**](docs/SubscriptionsApi.md#search_subscriptions) | **POST** /subscriptions/search | Search Subscriptions
*SubscriptionsApi* | [**update_subscription**](docs/SubscriptionsApi.md#update_subscription) | **PUT** /subscriptions/{subscription_id} | Update Subscription


## Documentation For Models

 - [AccountExternal](docs/AccountExternal.md)
 - [ActiveSubResponse](docs/ActiveSubResponse.md)
 - [ApiTokenExternal](docs/ApiTokenExternal.md)
 - [AttachPaymentMethodRequest](docs/AttachPaymentMethodRequest.md)
 - [BillingReasonEnum](docs/BillingReasonEnum.md)
 - [BillingSchemeEnum](docs/BillingSchemeEnum.md)
 - [BusinessType](docs/BusinessType.md)
 - [CalendarIntervalEnum](docs/CalendarIntervalEnum.md)
 - [ChargeExternal](docs/ChargeExternal.md)
 - [ChargeQueryParams](docs/ChargeQueryParams.md)
 - [ChargeStatusEnum](docs/ChargeStatusEnum.md)
 - [CheckoutMode](docs/CheckoutMode.md)
 - [CheckoutSessionExternal](docs/CheckoutSessionExternal.md)
 - [CheckoutSessionLineItemExternal](docs/CheckoutSessionLineItemExternal.md)
 - [CheckoutSessionQueryParams](docs/CheckoutSessionQueryParams.md)
 - [CheckoutSessionStatus](docs/CheckoutSessionStatus.md)
 - [CollectionMethodEnum](docs/CollectionMethodEnum.md)
 - [CompleteAddress](docs/CompleteAddress.md)
 - [CouponDuration](docs/CouponDuration.md)
 - [CouponExternal](docs/CouponExternal.md)
 - [CouponQueryParams](docs/CouponQueryParams.md)
 - [CreateCheckoutLineItem](docs/CreateCheckoutLineItem.md)
 - [CreateCheckoutSessionRequest](docs/CreateCheckoutSessionRequest.md)
 - [CreateCouponRequest](docs/CreateCouponRequest.md)
 - [CreateCreditNoteLine](docs/CreateCreditNoteLine.md)
 - [CreateCreditNoteRequest](docs/CreateCreditNoteRequest.md)
 - [CreateCustomerBalanceTransactionRequest](docs/CreateCustomerBalanceTransactionRequest.md)
 - [CreateCustomerRequest](docs/CreateCustomerRequest.md)
 - [CreateInvoiceRequest](docs/CreateInvoiceRequest.md)
 - [CreatePaymentLinkRequest](docs/CreatePaymentLinkRequest.md)
 - [CreatePortalSessionRequest](docs/CreatePortalSessionRequest.md)
 - [CreatePriceRequest](docs/CreatePriceRequest.md)
 - [CreateProductFamilyRequest](docs/CreateProductFamilyRequest.md)
 - [CreateProductRequest](docs/CreateProductRequest.md)
 - [CreatePromoCodeRequest](docs/CreatePromoCodeRequest.md)
 - [CreateRefundRequest](docs/CreateRefundRequest.md)
 - [CreateSubscriptionItemRequest](docs/CreateSubscriptionItemRequest.md)
 - [CreateSubscriptionRequest](docs/CreateSubscriptionRequest.md)
 - [CreateSubscriptionResponse](docs/CreateSubscriptionResponse.md)
 - [CreditCardType](docs/CreditCardType.md)
 - [CreditNoteExternal](docs/CreditNoteExternal.md)
 - [CreditNoteItemExternal](docs/CreditNoteItemExternal.md)
 - [CreditNoteLineType](docs/CreditNoteLineType.md)
 - [CreditNoteQueryParams](docs/CreditNoteQueryParams.md)
 - [CreditNoteReason](docs/CreditNoteReason.md)
 - [CustomerBalanceTransactionExternal](docs/CustomerBalanceTransactionExternal.md)
 - [CustomerBalanceTransactionType](docs/CustomerBalanceTransactionType.md)
 - [CustomerExternal](docs/CustomerExternal.md)
 - [CustomerPaymentMethodQueryParams](docs/CustomerPaymentMethodQueryParams.md)
 - [CustomerQueryParams](docs/CustomerQueryParams.md)
 - [DateTimeFilter](docs/DateTimeFilter.md)
 - [DeleteInvoiceItemResponse](docs/DeleteInvoiceItemResponse.md)
 - [DeletePriceResponse](docs/DeletePriceResponse.md)
 - [DeleteProductResponse](docs/DeleteProductResponse.md)
 - [DeleteSubscriptionItemRequest](docs/DeleteSubscriptionItemRequest.md)
 - [DeleteSubscriptionItemResponse](docs/DeleteSubscriptionItemResponse.md)
 - [DeleteSubscriptionRequest](docs/DeleteSubscriptionRequest.md)
 - [DiscountExternal](docs/DiscountExternal.md)
 - [Discounts](docs/Discounts.md)
 - [EventExternal](docs/EventExternal.md)
 - [EventSearchParams](docs/EventSearchParams.md)
 - [EventType](docs/EventType.md)
 - [EventsQueryParams](docs/EventsQueryParams.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [InlineSubscriptionItemUpdate](docs/InlineSubscriptionItemUpdate.md)
 - [IntRangeFilter](docs/IntRangeFilter.md)
 - [InviteExternal](docs/InviteExternal.md)
 - [InviteStatusEnum](docs/InviteStatusEnum.md)
 - [InvoiceDiscountAmountsExternal](docs/InvoiceDiscountAmountsExternal.md)
 - [InvoiceDiscountOptions](docs/InvoiceDiscountOptions.md)
 - [InvoiceExternal](docs/InvoiceExternal.md)
 - [InvoiceItemDiscountAmountsExternal](docs/InvoiceItemDiscountAmountsExternal.md)
 - [InvoiceItemDiscountAmountsPublic](docs/InvoiceItemDiscountAmountsPublic.md)
 - [InvoiceItemExternal](docs/InvoiceItemExternal.md)
 - [InvoiceItemPublic](docs/InvoiceItemPublic.md)
 - [InvoiceItemsQueryParams](docs/InvoiceItemsQueryParams.md)
 - [InvoicePublic](docs/InvoicePublic.md)
 - [InvoiceQueryParams](docs/InvoiceQueryParams.md)
 - [InvoiceSettings](docs/InvoiceSettings.md)
 - [InvoiceStatusEnum](docs/InvoiceStatusEnum.md)
 - [ListActiveSubParams](docs/ListActiveSubParams.md)
 - [ListResponseChargeExternal](docs/ListResponseChargeExternal.md)
 - [ListResponseCheckoutSessionExternal](docs/ListResponseCheckoutSessionExternal.md)
 - [ListResponseCouponExternal](docs/ListResponseCouponExternal.md)
 - [ListResponseCreditNoteExternal](docs/ListResponseCreditNoteExternal.md)
 - [ListResponseCustomerExternal](docs/ListResponseCustomerExternal.md)
 - [ListResponseEventExternal](docs/ListResponseEventExternal.md)
 - [ListResponseInvoiceExternal](docs/ListResponseInvoiceExternal.md)
 - [ListResponseInvoiceItemExternal](docs/ListResponseInvoiceItemExternal.md)
 - [ListResponsePaymentIntentExternal](docs/ListResponsePaymentIntentExternal.md)
 - [ListResponsePaymentLinkExternal](docs/ListResponsePaymentLinkExternal.md)
 - [ListResponsePaymentMethodExternal](docs/ListResponsePaymentMethodExternal.md)
 - [ListResponsePriceExternal](docs/ListResponsePriceExternal.md)
 - [ListResponseProductExternal](docs/ListResponseProductExternal.md)
 - [ListResponseProductFamilyExternal](docs/ListResponseProductFamilyExternal.md)
 - [ListResponsePromotionCodeExternal](docs/ListResponsePromotionCodeExternal.md)
 - [ListResponseRefundExternal](docs/ListResponseRefundExternal.md)
 - [ListResponseSubscriptionExternal](docs/ListResponseSubscriptionExternal.md)
 - [ListResponseSubscriptionItemExternal](docs/ListResponseSubscriptionItemExternal.md)
 - [ObjectName](docs/ObjectName.md)
 - [PayInvoiceRequest](docs/PayInvoiceRequest.md)
 - [PaymentIntentExternal](docs/PaymentIntentExternal.md)
 - [PaymentIntentQueryParams](docs/PaymentIntentQueryParams.md)
 - [PaymentIntentStatus](docs/PaymentIntentStatus.md)
 - [PaymentLinkExternal](docs/PaymentLinkExternal.md)
 - [PaymentLinkLineItemExternal](docs/PaymentLinkLineItemExternal.md)
 - [PaymentLinkQueryParams](docs/PaymentLinkQueryParams.md)
 - [PaymentMethodExternal](docs/PaymentMethodExternal.md)
 - [PaymentProcessorExternal](docs/PaymentProcessorExternal.md)
 - [PaymentProcessorName](docs/PaymentProcessorName.md)
 - [PortalSessionExternal](docs/PortalSessionExternal.md)
 - [PriceExternal](docs/PriceExternal.md)
 - [PriceQueryParams](docs/PriceQueryParams.md)
 - [PriceTierExternal](docs/PriceTierExternal.md)
 - [PriceTierParams](docs/PriceTierParams.md)
 - [PriceTierPublic](docs/PriceTierPublic.md)
 - [PriceTypeEnum](docs/PriceTypeEnum.md)
 - [PricingModel](docs/PricingModel.md)
 - [PricingTiersEnum](docs/PricingTiersEnum.md)
 - [ProductExternal](docs/ProductExternal.md)
 - [ProductFamilyExternal](docs/ProductFamilyExternal.md)
 - [ProductFamilyQueryParams](docs/ProductFamilyQueryParams.md)
 - [ProductQueryParams](docs/ProductQueryParams.md)
 - [PromoCodeQueryParams](docs/PromoCodeQueryParams.md)
 - [PromoRestrictions](docs/PromoRestrictions.md)
 - [PromotionCodeExternal](docs/PromotionCodeExternal.md)
 - [ProrationEnum](docs/ProrationEnum.md)
 - [RecurringDetails](docs/RecurringDetails.md)
 - [RefundExternal](docs/RefundExternal.md)
 - [RefundQueryParams](docs/RefundQueryParams.md)
 - [RefundReasonEnum](docs/RefundReasonEnum.md)
 - [RefundStatusEnum](docs/RefundStatusEnum.md)
 - [RoleEnum](docs/RoleEnum.md)
 - [SearchChargeRequest](docs/SearchChargeRequest.md)
 - [SearchCustomerRequest](docs/SearchCustomerRequest.md)
 - [SearchInvoiceRequest](docs/SearchInvoiceRequest.md)
 - [SearchPaymentIntentRequest](docs/SearchPaymentIntentRequest.md)
 - [SearchPriceRequest](docs/SearchPriceRequest.md)
 - [SearchProductRequest](docs/SearchProductRequest.md)
 - [SearchSubscriptionRequest](docs/SearchSubscriptionRequest.md)
 - [SelectedPriceQuantity](docs/SelectedPriceQuantity.md)
 - [SubscriptionCancelFeedbackEnum](docs/SubscriptionCancelFeedbackEnum.md)
 - [SubscriptionCancellationDetails](docs/SubscriptionCancellationDetails.md)
 - [SubscriptionExternal](docs/SubscriptionExternal.md)
 - [SubscriptionItemExternal](docs/SubscriptionItemExternal.md)
 - [SubscriptionItemQueryParams](docs/SubscriptionItemQueryParams.md)
 - [SubscriptionPauseRequest](docs/SubscriptionPauseRequest.md)
 - [SubscriptionQueryParams](docs/SubscriptionQueryParams.md)
 - [SubscriptionResumeRequest](docs/SubscriptionResumeRequest.md)
 - [SubscriptionStatusEnum](docs/SubscriptionStatusEnum.md)
 - [TokenizedCreditCardInput](docs/TokenizedCreditCardInput.md)
 - [TransitionEligibilityExternal](docs/TransitionEligibilityExternal.md)
 - [UpdateCouponRequest](docs/UpdateCouponRequest.md)
 - [UpdateCustomerRequest](docs/UpdateCustomerRequest.md)
 - [UpdateInvoiceRequest](docs/UpdateInvoiceRequest.md)
 - [UpdatePriceRequest](docs/UpdatePriceRequest.md)
 - [UpdateProductFamilyRequest](docs/UpdateProductFamilyRequest.md)
 - [UpdateProductRequest](docs/UpdateProductRequest.md)
 - [UpdatePromoCodeRequest](docs/UpdatePromoCodeRequest.md)
 - [UpdateSubscriptionItemRequest](docs/UpdateSubscriptionItemRequest.md)
 - [UpdateSubscriptionRequest](docs/UpdateSubscriptionRequest.md)
 - [UpdateSubscriptionResponse](docs/UpdateSubscriptionResponse.md)
 - [UsageAggMethodEnum](docs/UsageAggMethodEnum.md)
 - [UsageRecordAction](docs/UsageRecordAction.md)
 - [UsageTypeEnum](docs/UsageTypeEnum.md)
 - [UserExternal](docs/UserExternal.md)
 - [ValidationError](docs/ValidationError.md)
 - [ValidationErrorLocInner](docs/ValidationErrorLocInner.md)
 - [WebhookEndpointExternal](docs/WebhookEndpointExternal.md)
 - [WebhookEndpointExternalNoSecret](docs/WebhookEndpointExternalNoSecret.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="HTTPBearer"></a>
### HTTPBearer

- **Type**: Bearer authentication


## Author




