##
# File:    PdbDistroSchemaDef.py
# Author:  J. Westbrook
# Date:    21-May-2015
# Version: 0.001 Initial version
#
# Updates:
#
##
"""
Database schema defintions for chemical component definitions.

"""

__docformat__ = "restructuredtext en"
__author__ = "John Westbrook"
__email__ = "jwest@rcsb.rutgers.edu"
__license__ = "Creative Commons Attribution 3.0 Unported"
__version__ = "V0.001"

import sys
from typing import ClassVar

from wwpdb.utils.db.SchemaDefBase import SchemaDefBase, SchemaDictType


class PdbDistroSchemaDef(SchemaDefBase):
    """A data class containing schema definitions chemical component definitions."""

    _databaseName = "stat"
    # fmt: off
    _schemaDefDict: ClassVar[SchemaDictType] = {
        'DIFFRN_RADIATION_WAVELENGTH': {'ATTRIBUTES': {'ID': 'id',
                                                       'STRUCTURE_ID': 'Structure_ID',
                                                       'WAVELENGTH': 'wavelength',
                                                       'WT': 'wt'},
                                        'ATTRIBUTE_INFO': {'ID': {'NULLABLE': False,
                                                                  'ORDER': 2,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': True,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': '10'},
                                                           'STRUCTURE_ID': {'NULLABLE': False,
                                                                            'ORDER': 1,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': True,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': '10'},
                                                           'WAVELENGTH': {'NULLABLE': True,
                                                                          'ORDER': 3,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'FLOAT',
                                                                          'WIDTH': 10},
                                                           'WT': {'NULLABLE': True,
                                                                  'ORDER': 4,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'FLOAT',
                                                                  'WIDTH': 10}},
                                        'ATTRIBUTE_MAP': {'ID': ('diffrn_radiation_wavelength', 'id', None, None),
                                                          'STRUCTURE_ID': ('diffrn_radiation_wavelength',
                                                                           'Structure_ID',
                                                                           None,
                                                                           None),
                                                          'WAVELENGTH': ('diffrn_radiation_wavelength',
                                                                         'wavelength',
                                                                         None,
                                                                         None),
                                                          'WT': ('diffrn_radiation_wavelength', 'wt', None, None)},
                                        'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ID'), 'TYPE': 'UNIQUE'}},
                                        'MAP_MERGE_INDICES': {'diffrn_radiation_wavelength': {'ATTRIBUTES': ('STRUCTURE_ID',
                                                                                                             'ID'),
                                                                                              'TYPE': 'EQUI-JOIN'}},
                                        'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                        'TABLE_ID': 'DIFFRN_RADIATION_WAVELENGTH',
                                        'TABLE_NAME': 'diffrn_radiation_wavelength',
                                        'TABLE_TYPE': 'transactional'},
        'EXPTL_CRYSTAL': {'ATTRIBUTES': {'COLOUR': 'colour',
                                         'COLOUR_LUSTRE': 'colour_lustre',
                                         'COLOUR_MODIFIER': 'colour_modifier',
                                         'COLOUR_PRIMARY': 'colour_primary',
                                         'DENSITY_DIFFRN': 'density_diffrn',
                                         'DENSITY_MATTHEWS': 'density_Matthews',
                                         'DENSITY_MEAS': 'density_meas',
                                         'DENSITY_MEAS_ESD': 'density_meas_esd',
                                         'DENSITY_MEAS_GT': 'density_meas_gt',
                                         'DENSITY_MEAS_LT': 'density_meas_lt',
                                         'DENSITY_MEAS_TEMP': 'density_meas_temp',
                                         'DENSITY_MEAS_TEMP_ESD': 'density_meas_temp_esd',
                                         'DENSITY_MEAS_TEMP_GT': 'density_meas_temp_gt',
                                         'DENSITY_MEAS_TEMP_LT': 'density_meas_temp_lt',
                                         'DENSITY_METHOD': 'density_method',
                                         'DENSITY_PERCENT_SOL': 'density_percent_sol',
                                         'DESCRIPTION': 'description',
                                         'F_000': 'F_000',
                                         'ID': 'id',
                                         'PDBX_CRYSTAL_IMAGE_FORMAT': 'pdbx_crystal_image_format',
                                         'PDBX_CRYSTAL_IMAGE_URL': 'pdbx_crystal_image_url',
                                         'PDBX_MOSAICITY': 'pdbx_mosaicity',
                                         'PDBX_MOSAICITY_ESD': 'pdbx_mosaicity_esd',
                                         'PREPARATION': 'preparation',
                                         'SIZE_MAX': 'size_max',
                                         'SIZE_MID': 'size_mid',
                                         'SIZE_MIN': 'size_min',
                                         'SIZE_RAD': 'size_rad',
                                         'STRUCTURE_ID': 'Structure_ID'},
                          'ATTRIBUTE_INFO': {'COLOUR': {'NULLABLE': True,
                                                        'ORDER': 2,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': '80'},
                                             'COLOUR_LUSTRE': {'NULLABLE': True,
                                                               'ORDER': 15,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': '80'},
                                             'COLOUR_MODIFIER': {'NULLABLE': True,
                                                                 'ORDER': 16,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': '80'},
                                             'COLOUR_PRIMARY': {'NULLABLE': True,
                                                                'ORDER': 17,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': '80'},
                                             'DENSITY_DIFFRN': {'NULLABLE': True,
                                                                'ORDER': 3,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                             'DENSITY_MATTHEWS': {'NULLABLE': True,
                                                                  'ORDER': 4,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'FLOAT',
                                                                  'WIDTH': 10},
                                             'DENSITY_MEAS': {'NULLABLE': True,
                                                              'ORDER': 18,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'FLOAT',
                                                              'WIDTH': 10},
                                             'DENSITY_MEAS_ESD': {'NULLABLE': True,
                                                                  'ORDER': 19,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'FLOAT',
                                                                  'WIDTH': 10},
                                             'DENSITY_MEAS_GT': {'NULLABLE': True,
                                                                 'ORDER': 20,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                             'DENSITY_MEAS_LT': {'NULLABLE': True,
                                                                 'ORDER': 21,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                             'DENSITY_MEAS_TEMP': {'NULLABLE': True,
                                                                   'ORDER': 22,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                             'DENSITY_MEAS_TEMP_ESD': {'NULLABLE': True,
                                                                       'ORDER': 23,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'FLOAT',
                                                                       'WIDTH': 10},
                                             'DENSITY_MEAS_TEMP_GT': {'NULLABLE': True,
                                                                      'ORDER': 24,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'FLOAT',
                                                                      'WIDTH': 10},
                                             'DENSITY_MEAS_TEMP_LT': {'NULLABLE': True,
                                                                      'ORDER': 25,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'FLOAT',
                                                                      'WIDTH': 10},
                                             'DENSITY_METHOD': {'NULLABLE': True,
                                                                'ORDER': 5,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': '200'},
                                             'DENSITY_PERCENT_SOL': {'NULLABLE': True,
                                                                     'ORDER': 6,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'FLOAT',
                                                                     'WIDTH': 10},
                                             'DESCRIPTION': {'NULLABLE': True,
                                                             'ORDER': 7,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': '5000'},
                                             'F_000': {'NULLABLE': True,
                                                       'ORDER': 8,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': False,
                                                       'SQL_TYPE': 'INT',
                                                       'WIDTH': '11'},
                                             'ID': {'NULLABLE': False,
                                                    'ORDER': 9,
                                                    'PRECISION': 0,
                                                    'PRIMARY_KEY': True,
                                                    'SQL_TYPE': 'VARCHAR',
                                                    'WIDTH': '10'},
                                             'PDBX_CRYSTAL_IMAGE_FORMAT': {'NULLABLE': True,
                                                                           'ORDER': 27,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'VARCHAR',
                                                                           'WIDTH': '80'},
                                             'PDBX_CRYSTAL_IMAGE_URL': {'NULLABLE': True,
                                                                        'ORDER': 26,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': '80'},
                                             'PDBX_MOSAICITY': {'NULLABLE': True,
                                                                'ORDER': 28,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                             'PDBX_MOSAICITY_ESD': {'NULLABLE': True,
                                                                    'ORDER': 29,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'FLOAT',
                                                                    'WIDTH': 10},
                                             'PREPARATION': {'NULLABLE': True,
                                                             'ORDER': 10,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': '200'},
                                             'SIZE_MAX': {'NULLABLE': True,
                                                          'ORDER': 11,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'FLOAT',
                                                          'WIDTH': 10},
                                             'SIZE_MID': {'NULLABLE': True,
                                                          'ORDER': 12,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'FLOAT',
                                                          'WIDTH': 10},
                                             'SIZE_MIN': {'NULLABLE': True,
                                                          'ORDER': 13,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'FLOAT',
                                                          'WIDTH': 10},
                                             'SIZE_RAD': {'NULLABLE': True,
                                                          'ORDER': 14,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'FLOAT',
                                                          'WIDTH': 10},
                                             'STRUCTURE_ID': {'NULLABLE': False,
                                                              'ORDER': 1,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': True,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': '10'}},
                          'ATTRIBUTE_MAP': {'COLOUR': ('exptl_crystal', 'colour', None, None),
                                            'COLOUR_LUSTRE': ('exptl_crystal', 'colour_lustre', None, None),
                                            'COLOUR_MODIFIER': ('exptl_crystal', 'colour_modifier', None, None),
                                            'COLOUR_PRIMARY': ('exptl_crystal', 'colour_primary', None, None),
                                            'DENSITY_DIFFRN': ('exptl_crystal', 'density_diffrn', None, None),
                                            'DENSITY_MATTHEWS': ('exptl_crystal', 'density_Matthews', None, None),
                                            'DENSITY_MEAS': ('exptl_crystal', 'density_meas', None, None),
                                            'DENSITY_MEAS_ESD': ('exptl_crystal', 'density_meas_esd', None, None),
                                            'DENSITY_MEAS_GT': ('exptl_crystal', 'density_meas_gt', None, None),
                                            'DENSITY_MEAS_LT': ('exptl_crystal', 'density_meas_lt', None, None),
                                            'DENSITY_MEAS_TEMP': ('exptl_crystal', 'density_meas_temp', None, None),
                                            'DENSITY_MEAS_TEMP_ESD': ('exptl_crystal',
                                                                      'density_meas_temp_esd',
                                                                      None,
                                                                      None),
                                            'DENSITY_MEAS_TEMP_GT': ('exptl_crystal',
                                                                     'density_meas_temp_gt',
                                                                     None,
                                                                     None),
                                            'DENSITY_MEAS_TEMP_LT': ('exptl_crystal',
                                                                     'density_meas_temp_lt',
                                                                     None,
                                                                     None),
                                            'DENSITY_METHOD': ('exptl_crystal', 'density_method', None, None),
                                            'DENSITY_PERCENT_SOL': ('exptl_crystal',
                                                                    'density_percent_sol',
                                                                    None,
                                                                    None),
                                            'DESCRIPTION': ('exptl_crystal', 'description', None, None),
                                            'F_000': ('exptl_crystal', 'F_000', None, None),
                                            'ID': ('exptl_crystal', 'id', None, None),
                                            'PDBX_CRYSTAL_IMAGE_FORMAT': ('exptl_crystal',
                                                                          'pdbx_crystal_image_format',
                                                                          None,
                                                                          None),
                                            'PDBX_CRYSTAL_IMAGE_URL': ('exptl_crystal',
                                                                       'pdbx_crystal_image_url',
                                                                       None,
                                                                       None),
                                            'PDBX_MOSAICITY': ('exptl_crystal', 'pdbx_mosaicity', None, None),
                                            'PDBX_MOSAICITY_ESD': ('exptl_crystal', 'pdbx_mosaicity_esd', None, None),
                                            'PREPARATION': ('exptl_crystal', 'preparation', None, None),
                                            'SIZE_MAX': ('exptl_crystal', 'size_max', None, None),
                                            'SIZE_MID': ('exptl_crystal', 'size_mid', None, None),
                                            'SIZE_MIN': ('exptl_crystal', 'size_min', None, None),
                                            'SIZE_RAD': ('exptl_crystal', 'size_rad', None, None),
                                            'STRUCTURE_ID': ('exptl_crystal', 'Structure_ID', None, None)},
                          'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ID'), 'TYPE': 'UNIQUE'}},
                          'MAP_MERGE_INDICES': {'exptl_crystal': {'ATTRIBUTES': ('STRUCTURE_ID', 'ID'),
                                                                  'TYPE': 'EQUI-JOIN'}},
                          'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                          'TABLE_ID': 'EXPTL_CRYSTAL',
                          'TABLE_NAME': 'exptl_crystal',
                          'TABLE_TYPE': 'transactional'},
        'EXPTL_CRYSTAL_GROW': {'ATTRIBUTES': {'APPARATUS': 'apparatus',
                                              'ATMOSPHERE': 'atmosphere',
                                              'CRYSTAL_ID': 'crystal_id',
                                              'DETAILS': 'details',
                                              'METHOD': 'method',
                                              'METHOD_REF': 'method_ref',
                                              'PDBX_DETAILS': 'pdbx_details',
                                              'PDBX_PH_RANGE': 'pdbx_pH_range',
                                              'PH': 'pH',
                                              'PRESSURE': 'pressure',
                                              'PRESSURE_ESD': 'pressure_esd',
                                              'SEEDING': 'seeding',
                                              'SEEDING_REF': 'seeding_ref',
                                              'STRUCTURE_ID': 'Structure_ID',
                                              'TEMP': 'temp',
                                              'TEMP_DETAILS': 'temp_details',
                                              'TEMP_ESD': 'temp_esd',
                                              'TIME': 'time'},
                               'ATTRIBUTE_INFO': {'APPARATUS': {'NULLABLE': True,
                                                                'ORDER': 3,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': '200'},
                                                  'ATMOSPHERE': {'NULLABLE': True,
                                                                 'ORDER': 4,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': '200'},
                                                  'CRYSTAL_ID': {'NULLABLE': False,
                                                                 'ORDER': 2,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': True,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': '10'},
                                                  'DETAILS': {'NULLABLE': True,
                                                              'ORDER': 5,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': '200'},
                                                  'METHOD': {'NULLABLE': True,
                                                             'ORDER': 6,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': '200'},
                                                  'METHOD_REF': {'NULLABLE': True,
                                                                 'ORDER': 7,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': '200'},
                                                  'PDBX_DETAILS': {'NULLABLE': True,
                                                                   'ORDER': 17,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': '5000'},
                                                  'PDBX_PH_RANGE': {'NULLABLE': True,
                                                                    'ORDER': 18,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': '80'},
                                                  'PH': {'NULLABLE': True,
                                                         'ORDER': 8,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                                  'PRESSURE': {'NULLABLE': True,
                                                               'ORDER': 9,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                                  'PRESSURE_ESD': {'NULLABLE': True,
                                                                   'ORDER': 10,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                                  'SEEDING': {'NULLABLE': True,
                                                              'ORDER': 11,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': '200'},
                                                  'SEEDING_REF': {'NULLABLE': True,
                                                                  'ORDER': 12,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': '200'},
                                                  'STRUCTURE_ID': {'NULLABLE': False,
                                                                   'ORDER': 1,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': True,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': '10'},
                                                  'TEMP': {'NULLABLE': True,
                                                           'ORDER': 13,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'FLOAT',
                                                           'WIDTH': 10},
                                                  'TEMP_DETAILS': {'NULLABLE': True,
                                                                   'ORDER': 14,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': '200'},
                                                  'TEMP_ESD': {'NULLABLE': True,
                                                               'ORDER': 15,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                                  'TIME': {'NULLABLE': True,
                                                           'ORDER': 16,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': '200'}},
                               'ATTRIBUTE_MAP': {'APPARATUS': ('exptl_crystal_grow', 'apparatus', None, None),
                                                 'ATMOSPHERE': ('exptl_crystal_grow', 'atmosphere', None, None),
                                                 'CRYSTAL_ID': ('exptl_crystal_grow', 'crystal_id', None, None),
                                                 'DETAILS': ('exptl_crystal_grow', 'details', None, None),
                                                 'METHOD': ('exptl_crystal_grow', 'method', None, None),
                                                 'METHOD_REF': ('exptl_crystal_grow', 'method_ref', None, None),
                                                 'PDBX_DETAILS': ('exptl_crystal_grow', 'pdbx_details', None, None),
                                                 'PDBX_PH_RANGE': ('exptl_crystal_grow', 'pdbx_pH_range', None, None),
                                                 'PH': ('exptl_crystal_grow', 'pH', None, None),
                                                 'PRESSURE': ('exptl_crystal_grow', 'pressure', None, None),
                                                 'PRESSURE_ESD': ('exptl_crystal_grow', 'pressure_esd', None, None),
                                                 'SEEDING': ('exptl_crystal_grow', 'seeding', None, None),
                                                 'SEEDING_REF': ('exptl_crystal_grow', 'seeding_ref', None, None),
                                                 'STRUCTURE_ID': ('exptl_crystal_grow', 'Structure_ID', None, None),
                                                 'TEMP': ('exptl_crystal_grow', 'temp', None, None),
                                                 'TEMP_DETAILS': ('exptl_crystal_grow', 'temp_details', None, None),
                                                 'TEMP_ESD': ('exptl_crystal_grow', 'temp_esd', None, None),
                                                 'TIME': ('exptl_crystal_grow', 'time', None, None)},
                               'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'CRYSTAL_ID'), 'TYPE': 'UNIQUE'}},
                               'MAP_MERGE_INDICES': {'exptl_crystal_grow': {'ATTRIBUTES': ('STRUCTURE_ID',
                                                                                           'CRYSTAL_ID'),
                                                                            'TYPE': 'EQUI-JOIN'}},
                               'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                               'TABLE_ID': 'EXPTL_CRYSTAL_GROW',
                               'TABLE_NAME': 'exptl_crystal_grow',
                               'TABLE_TYPE': 'transactional'},
        'GEOMETRY': {'ATTRIBUTES': {'ALL_ATOM_CLASHSCORE': 'all_atom_clashscore',
                                    'ANGLE_LIGAND_MAX': 'angle_ligand_max',
                                    'ANGLE_LIGAND_RMS': 'angle_ligand_rms',
                                    'ANGLE_OVERALL_MAX': 'angle_overall_max',
                                    'ANGLE_OVERALL_RMS': 'angle_overall_rms',
                                    'BOND_LIGAND_MAX': 'bond_ligand_max',
                                    'BOND_LIGAND_RMS': 'bond_ligand_rms',
                                    'BOND_OVERALL_MAX': 'bond_overall_max',
                                    'BOND_OVERALL_RMS': 'bond_overall_rms',
                                    'CBETA_DEVIATIONS': 'cbeta_deviations',
                                    'CHIRALITY_OVERALL_MAX': 'chirality_overall_max',
                                    'CHIRALITY_OVERALL_RMS': 'chirality_overall_rms',
                                    'DIHEDRAL_OVERALL_MAX': 'dihedral_overall_max',
                                    'DIHEDRAL_OVERALL_RMS': 'dihedral_overall_rms',
                                    'NON_BONDED_RMS': 'non_bonded_rms',
                                    'OVERALL_SCORE': 'overall_score',
                                    'PLANARITY_OVERALL_MAX': 'planarity_overall_max',
                                    'PLANARITY_OVERALL_RMS': 'planarity_overall_rms',
                                    'RAMACHANDRAN_ALLOWED_NUMBER': 'Ramachandran_allowed_number',
                                    'RAMACHANDRAN_ALLOWED_PERCENT': 'Ramachandran_allowed_percent',
                                    'RAMACHANDRAN_FAVORED_NUMBER': 'Ramachandran_favored_number',
                                    'RAMACHANDRAN_FAVORED_PERCENT': 'Ramachandran_favored_percent',
                                    'RAMACHANDRAN_OUTLIER_NUMBER': 'Ramachandran_outlier_number',
                                    'RAMACHANDRAN_OUTLIER_PERCENT': 'Ramachandran_outlier_percent',
                                    'ROTAMER_OUTLIERS_NUMBER': 'rotamer_outliers_number',
                                    'ROTAMER_OUTLIERS_PERCENT': 'rotamer_outliers_percent',
                                    'STRUCTURE_ID': 'Structure_ID'},
                     'ATTRIBUTE_INFO': {'ALL_ATOM_CLASHSCORE': {'NULLABLE': True,
                                                                'ORDER': 11,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                        'ANGLE_LIGAND_MAX': {'NULLABLE': True,
                                                             'ORDER': 20,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                        'ANGLE_LIGAND_RMS': {'NULLABLE': True,
                                                             'ORDER': 19,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                        'ANGLE_OVERALL_MAX': {'NULLABLE': True,
                                                              'ORDER': 18,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'FLOAT',
                                                              'WIDTH': 10},
                                        'ANGLE_OVERALL_RMS': {'NULLABLE': True,
                                                              'ORDER': 17,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'FLOAT',
                                                              'WIDTH': 10},
                                        'BOND_LIGAND_MAX': {'NULLABLE': True,
                                                            'ORDER': 16,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'FLOAT',
                                                            'WIDTH': 10},
                                        'BOND_LIGAND_RMS': {'NULLABLE': True,
                                                            'ORDER': 15,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'FLOAT',
                                                            'WIDTH': 10},
                                        'BOND_OVERALL_MAX': {'NULLABLE': True,
                                                             'ORDER': 14,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                        'BOND_OVERALL_RMS': {'NULLABLE': True,
                                                             'ORDER': 13,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                        'CBETA_DEVIATIONS': {'NULLABLE': True,
                                                             'ORDER': 10,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                        'CHIRALITY_OVERALL_MAX': {'NULLABLE': True,
                                                                  'ORDER': 24,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'FLOAT',
                                                                  'WIDTH': 10},
                                        'CHIRALITY_OVERALL_RMS': {'NULLABLE': True,
                                                                  'ORDER': 23,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'FLOAT',
                                                                  'WIDTH': 10},
                                        'DIHEDRAL_OVERALL_MAX': {'NULLABLE': True,
                                                                 'ORDER': 22,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                        'DIHEDRAL_OVERALL_RMS': {'NULLABLE': True,
                                                                 'ORDER': 21,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                        'NON_BONDED_RMS': {'NULLABLE': True,
                                                           'ORDER': 27,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'FLOAT',
                                                           'WIDTH': 10},
                                        'OVERALL_SCORE': {'NULLABLE': True,
                                                          'ORDER': 12,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'FLOAT',
                                                          'WIDTH': 10},
                                        'PLANARITY_OVERALL_MAX': {'NULLABLE': True,
                                                                  'ORDER': 26,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'FLOAT',
                                                                  'WIDTH': 10},
                                        'PLANARITY_OVERALL_RMS': {'NULLABLE': True,
                                                                  'ORDER': 25,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'FLOAT',
                                                                  'WIDTH': 10},
                                        'RAMACHANDRAN_ALLOWED_NUMBER': {'NULLABLE': True,
                                                                        'ORDER': 5,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'INT',
                                                                        'WIDTH': '11'},
                                        'RAMACHANDRAN_ALLOWED_PERCENT': {'NULLABLE': True,
                                                                         'ORDER': 4,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'FLOAT',
                                                                         'WIDTH': 10},
                                        'RAMACHANDRAN_FAVORED_NUMBER': {'NULLABLE': True,
                                                                        'ORDER': 7,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'INT',
                                                                        'WIDTH': '11'},
                                        'RAMACHANDRAN_FAVORED_PERCENT': {'NULLABLE': True,
                                                                         'ORDER': 6,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'FLOAT',
                                                                         'WIDTH': 10},
                                        'RAMACHANDRAN_OUTLIER_NUMBER': {'NULLABLE': True,
                                                                        'ORDER': 3,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'INT',
                                                                        'WIDTH': '11'},
                                        'RAMACHANDRAN_OUTLIER_PERCENT': {'NULLABLE': True,
                                                                         'ORDER': 2,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'FLOAT',
                                                                         'WIDTH': 10},
                                        'ROTAMER_OUTLIERS_NUMBER': {'NULLABLE': True,
                                                                    'ORDER': 9,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'INT',
                                                                    'WIDTH': '11'},
                                        'ROTAMER_OUTLIERS_PERCENT': {'NULLABLE': True,
                                                                     'ORDER': 8,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'FLOAT',
                                                                     'WIDTH': 10},
                                        'STRUCTURE_ID': {'NULLABLE': False,
                                                         'ORDER': 1,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': True,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': '6'}},
                     'ATTRIBUTE_MAP': {'ALL_ATOM_CLASHSCORE': ('geometry', 'all_atom_clashscore', None, None),
                                       'ANGLE_LIGAND_MAX': ('geometry', 'angle_ligand_max', None, None),
                                       'ANGLE_LIGAND_RMS': ('geometry', 'angle_ligand_rms', None, None),
                                       'ANGLE_OVERALL_MAX': ('geometry', 'angle_overall_max', None, None),
                                       'ANGLE_OVERALL_RMS': ('geometry', 'angle_overall_rms', None, None),
                                       'BOND_LIGAND_MAX': ('geometry', 'bond_ligand_max', None, None),
                                       'BOND_LIGAND_RMS': ('geometry', 'bond_ligand_rms', None, None),
                                       'BOND_OVERALL_MAX': ('geometry', 'bond_overall_max', None, None),
                                       'BOND_OVERALL_RMS': ('geometry', 'bond_overall_rms', None, None),
                                       'CBETA_DEVIATIONS': ('geometry', 'cbeta_deviations', None, None),
                                       'CHIRALITY_OVERALL_MAX': ('geometry', 'chirality_overall_max', None, None),
                                       'CHIRALITY_OVERALL_RMS': ('geometry', 'chirality_overall_rms', None, None),
                                       'DIHEDRAL_OVERALL_MAX': ('geometry', 'dihedral_overall_max', None, None),
                                       'DIHEDRAL_OVERALL_RMS': ('geometry', 'dihedral_overall_rms', None, None),
                                       'NON_BONDED_RMS': ('geometry', 'non_bonded_rms', None, None),
                                       'OVERALL_SCORE': ('geometry', 'overall_score', None, None),
                                       'PLANARITY_OVERALL_MAX': ('geometry', 'planarity_overall_max', None, None),
                                       'PLANARITY_OVERALL_RMS': ('geometry', 'planarity_overall_rms', None, None),
                                       'RAMACHANDRAN_ALLOWED_NUMBER': ('geometry',
                                                                       'Ramachandran_allowed_number',
                                                                       None,
                                                                       None),
                                       'RAMACHANDRAN_ALLOWED_PERCENT': ('geometry',
                                                                        'Ramachandran_allowed_percent',
                                                                        None,
                                                                        None),
                                       'RAMACHANDRAN_FAVORED_NUMBER': ('geometry',
                                                                       'Ramachandran_favored_number',
                                                                       None,
                                                                       None),
                                       'RAMACHANDRAN_FAVORED_PERCENT': ('geometry',
                                                                        'Ramachandran_favored_percent',
                                                                        None,
                                                                        None),
                                       'RAMACHANDRAN_OUTLIER_NUMBER': ('geometry',
                                                                       'Ramachandran_outlier_number',
                                                                       None,
                                                                       None),
                                       'RAMACHANDRAN_OUTLIER_PERCENT': ('geometry',
                                                                        'Ramachandran_outlier_percent',
                                                                        None,
                                                                        None),
                                       'ROTAMER_OUTLIERS_NUMBER': ('geometry', 'rotamer_outliers_number', None, None),
                                       'ROTAMER_OUTLIERS_PERCENT': ('geometry',
                                                                    'rotamer_outliers_percent',
                                                                    None,
                                                                    None),
                                       'STRUCTURE_ID': ('geometry', 'Structure_ID', None, None)},
                     'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'UNIQUE'}},
                     'MAP_MERGE_INDICES': {'geometry': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'EQUI-JOIN'}},
                     'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                     'TABLE_ID': 'GEOMETRY',
                     'TABLE_NAME': 'geometry',
                     'TABLE_TYPE': 'transactional'},
        'PDBX_DENSITY': {'ATTRIBUTES': {'ANISOTROPY': 'anisotropy',
                                        'BISO_MAX': 'Biso_max',
                                        'BISO_MEAN': 'Biso_mean',
                                        'BISO_MIN': 'Biso_min',
                                        'BMEAN_BWILSON': 'Bmean_Bwilson',
                                        'B_SOLVENT': 'B_solvent',
                                        'B_WILSON': 'B_wilson',
                                        'B_WILSON_SCALE': 'B_wilson_scale',
                                        'CORRELATION_OVERALL': 'correlation_overall',
                                        'CRUICKSHANK_DPI_XYZ': 'Cruickshank_dpi_xyz',
                                        'DCC_VERSION': 'DCC_version',
                                        'DPI_FREE_R': 'dpi_free_R',
                                        'ERROR': 'error',
                                        'FOM': 'fom',
                                        'FREE_SET_COUNT': 'free_set_count',
                                        'ICE_RING': 'ice_ring',
                                        'ISO_B_VALUE_TYPE': 'iso_B_value_type',
                                        'I_OVER_SIGI_DIFF': 'I_over_sigI_diff',
                                        'I_OVER_SIGI_MEAN': 'I_over_sigI_mean',
                                        'I_OVER_SIGI_RESH': 'I_over_sigI_resh',
                                        'K_SOLVENT': 'K_solvent',
                                        'LS_D_RES_HIGH': 'ls_d_res_high',
                                        'MATTHEW_COEFF': 'Matthew_coeff',
                                        'MEAN_E2_1_ABS': 'mean_E2_1_abs',
                                        'MEAN_F_SQUARE_OVER_MEAN_F2': 'mean_F_square_over_mean_F2',
                                        'MEAN_I2_OVER_MEAN_I_SQUARE': 'mean_I2_over_mean_I_square',
                                        'MFO_DFC_3SIGMA_NEGATIVE': 'mFo_DFc_3sigma_negative',
                                        'MFO_DFC_3SIGMA_POSITIVE': 'mFo_DFc_3sigma_positive',
                                        'MFO_DFC_6SIGMA_NEGATIVE': 'mFo_DFc_6sigma_negative',
                                        'MFO_DFC_6SIGMA_POSITIVE': 'mFo_DFc_6sigma_positive',
                                        'MTRIX_NUMBER': 'mtrix_number',
                                        'NCS_GROUP_NUMBER': 'ncs_group_number',
                                        'OCCUPANCY_MAX': 'occupancy_max',
                                        'OCCUPANCY_MEAN': 'occupancy_mean',
                                        'OCCUPANCY_MIN': 'occupancy_min',
                                        'PADILLA_YEATES_L2_MEAN': 'Padilla_Yeates_L2_mean',
                                        'PADILLA_YEATES_L2_MEAN_POINTLESS': 'Padilla_Yeates_L2_mean_pointless',
                                        'PADILLA_YEATES_L_MEAN': 'Padilla_Yeates_L_mean',
                                        'PARTIAL_B_VALUE_CORRECTION_ATTEMPTED': 'partial_B_value_correction_attempted',
                                        'PARTIAL_B_VALUE_CORRECTION_SUCCESS': 'partial_B_value_correction_success',
                                        'PDBTYPE': 'pdbtype',
                                        'PROB_PEAK_VALUE': 'prob_peak_value',
                                        'REAL_SPACE_R_OVERALL': 'real_space_R_overall',
                                        'REFLECTION_STATUS_ARCHIVED': 'reflection_status_archived',
                                        'REFLECTION_STATUS_USED': 'reflection_status_used',
                                        'REFLNS_TWIN': 'reflns_twin',
                                        'RFREE_PHENIX': 'Rfree_phenix',
                                        'RFREE_REFMAC': 'Rfree_refmac',
                                        'RFREE_RWORK': 'Rfree_Rwork',
                                        'RWORK_PHENIX': 'Rwork_phenix',
                                        'RWORK_REFMAC': 'Rwork_refmac',
                                        'R_VALUE_R_FREE': 'R_value_R_free',
                                        'R_VALUE_R_WORK': 'R_value_R_work',
                                        'SOLVENT_CONTENT': 'solvent_content',
                                        'SPACE_GROUP_NAME_H_M': 'space_group_name_H_M',
                                        'SPACE_GROUP_POINTLESS': 'space_group_pointless',
                                        'STRUCTURE_ID': 'Structure_ID',
                                        'TLS_GROUP_NUMBER': 'tls_group_number',
                                        'TLS_REFINEMENT_REPORTED': 'TLS_refinement_reported',
                                        'TRANSLATIONAL_PSEUDO_SYMMETRY': 'translational_pseudo_symmetry',
                                        'TWIN_BY_XTRIAGE': 'twin_by_xtriage',
                                        'TWIN_FRACTION': 'twin_fraction',
                                        'TWIN_FRACTION_XTRIAGE': 'twin_fraction_xtriage',
                                        'TWIN_OPERATOR': 'twin_operator',
                                        'TWIN_OPERATOR_XTRIAGE': 'twin_operator_xtriage',
                                        'TWIN_RFACTOR': 'twin_Rfactor',
                                        'TWIN_TYPE': 'twin_type',
                                        'UNIT_CELL': 'unit_cell',
                                        'WAVELENGTH': 'wavelength',
                                        'WORKING_SET_COUNT': 'working_set_count',
                                        'Z_SCORE': 'Z_score',
                                        'Z_SCORE_L_TEST': 'Z_score_L_test'},
                         'ATTRIBUTE_INFO': {'ANISOTROPY': {'NULLABLE': True,
                                                           'ORDER': 35,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'FLOAT',
                                                           'WIDTH': 10},
                                            'BISO_MAX': {'NULLABLE': True,
                                                         'ORDER': 16,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                            'BISO_MEAN': {'NULLABLE': True,
                                                          'ORDER': 17,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'FLOAT',
                                                          'WIDTH': 10},
                                            'BISO_MIN': {'NULLABLE': True,
                                                         'ORDER': 15,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                            'BMEAN_BWILSON': {'NULLABLE': True,
                                                              'ORDER': 70,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'FLOAT',
                                                              'WIDTH': 10},
                                            'B_SOLVENT': {'NULLABLE': True,
                                                          'ORDER': 40,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'FLOAT',
                                                          'WIDTH': 10},
                                            'B_WILSON': {'NULLABLE': True,
                                                         'ORDER': 18,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                            'B_WILSON_SCALE': {'NULLABLE': True,
                                                               'ORDER': 19,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                            'CORRELATION_OVERALL': {'NULLABLE': True,
                                                                    'ORDER': 60,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'FLOAT',
                                                                    'WIDTH': 10},
                                            'CRUICKSHANK_DPI_XYZ': {'NULLABLE': True,
                                                                    'ORDER': 57,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'FLOAT',
                                                                    'WIDTH': 10},
                                            'DCC_VERSION': {'NULLABLE': True,
                                                            'ORDER': 1,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': '50'},
                                            'DPI_FREE_R': {'NULLABLE': True,
                                                           'ORDER': 58,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'FLOAT',
                                                           'WIDTH': 10},
                                            'ERROR': {'NULLABLE': True,
                                                      'ORDER': 72,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'TEXT',
                                                      'WIDTH': 10},
                                            'FOM': {'NULLABLE': True,
                                                    'ORDER': 59,
                                                    'PRECISION': 0,
                                                    'PRIMARY_KEY': False,
                                                    'SQL_TYPE': 'FLOAT',
                                                    'WIDTH': 10},
                                            'FREE_SET_COUNT': {'NULLABLE': True,
                                                               'ORDER': 11,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'INT',
                                                               'WIDTH': '11'},
                                            'ICE_RING': {'NULLABLE': True,
                                                         'ORDER': 34,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': '2'},
                                            'ISO_B_VALUE_TYPE': {'NULLABLE': True,
                                                                 'ORDER': 47,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': '15'},
                                            'I_OVER_SIGI_DIFF': {'NULLABLE': True,
                                                                 'ORDER': 32,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                            'I_OVER_SIGI_MEAN': {'NULLABLE': True,
                                                                 'ORDER': 33,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                            'I_OVER_SIGI_RESH': {'NULLABLE': True,
                                                                 'ORDER': 31,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                            'K_SOLVENT': {'NULLABLE': True,
                                                          'ORDER': 41,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'FLOAT',
                                                          'WIDTH': 10},
                                            'LS_D_RES_HIGH': {'NULLABLE': True,
                                                              'ORDER': 7,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'FLOAT',
                                                              'WIDTH': 10},
                                            'MATTHEW_COEFF': {'NULLABLE': True,
                                                              'ORDER': 55,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'FLOAT',
                                                              'WIDTH': 10},
                                            'MEAN_E2_1_ABS': {'NULLABLE': True,
                                                              'ORDER': 22,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'FLOAT',
                                                              'WIDTH': 10},
                                            'MEAN_F_SQUARE_OVER_MEAN_F2': {'NULLABLE': True,
                                                                           'ORDER': 21,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'FLOAT',
                                                                           'WIDTH': 10},
                                            'MEAN_I2_OVER_MEAN_I_SQUARE': {'NULLABLE': True,
                                                                           'ORDER': 20,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'FLOAT',
                                                                           'WIDTH': 10},
                                            'MFO_DFC_3SIGMA_NEGATIVE': {'NULLABLE': True,
                                                                        'ORDER': 64,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'FLOAT',
                                                                        'WIDTH': 10},
                                            'MFO_DFC_3SIGMA_POSITIVE': {'NULLABLE': True,
                                                                        'ORDER': 62,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'FLOAT',
                                                                        'WIDTH': 10},
                                            'MFO_DFC_6SIGMA_NEGATIVE': {'NULLABLE': True,
                                                                        'ORDER': 65,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'FLOAT',
                                                                        'WIDTH': 10},
                                            'MFO_DFC_6SIGMA_POSITIVE': {'NULLABLE': True,
                                                                        'ORDER': 63,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'FLOAT',
                                                                        'WIDTH': 10},
                                            'MTRIX_NUMBER': {'NULLABLE': True,
                                                             'ORDER': 54,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'INT',
                                                             'WIDTH': '11'},
                                            'NCS_GROUP_NUMBER': {'NULLABLE': True,
                                                                 'ORDER': 53,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'INT',
                                                                 'WIDTH': '11'},
                                            'OCCUPANCY_MAX': {'NULLABLE': True,
                                                              'ORDER': 13,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'FLOAT',
                                                              'WIDTH': 10},
                                            'OCCUPANCY_MEAN': {'NULLABLE': True,
                                                               'ORDER': 14,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                            'OCCUPANCY_MIN': {'NULLABLE': True,
                                                              'ORDER': 12,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'FLOAT',
                                                              'WIDTH': 10},
                                            'PADILLA_YEATES_L2_MEAN': {'NULLABLE': True,
                                                                       'ORDER': 24,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'FLOAT',
                                                                       'WIDTH': 10},
                                            'PADILLA_YEATES_L2_MEAN_POINTLESS': {'NULLABLE': True,
                                                                                 'ORDER': 25,
                                                                                 'PRECISION': 0,
                                                                                 'PRIMARY_KEY': False,
                                                                                 'SQL_TYPE': 'FLOAT',
                                                                                 'WIDTH': 10},
                                            'PADILLA_YEATES_L_MEAN': {'NULLABLE': True,
                                                                      'ORDER': 23,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'FLOAT',
                                                                      'WIDTH': 10},
                                            'PARTIAL_B_VALUE_CORRECTION_ATTEMPTED': {'NULLABLE': True,
                                                                                     'ORDER': 43,
                                                                                     'PRECISION': 0,
                                                                                     'PRIMARY_KEY': False,
                                                                                     'SQL_TYPE': 'VARCHAR',
                                                                                     'WIDTH': '2'},
                                            'PARTIAL_B_VALUE_CORRECTION_SUCCESS': {'NULLABLE': True,
                                                                                   'ORDER': 44,
                                                                                   'PRECISION': 0,
                                                                                   'PRIMARY_KEY': False,
                                                                                   'SQL_TYPE': 'VARCHAR',
                                                                                   'WIDTH': '2'},
                                            'PDBTYPE': {'NULLABLE': True,
                                                        'ORDER': 3,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': '50'},
                                            'PROB_PEAK_VALUE': {'NULLABLE': True,
                                                                'ORDER': 37,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                            'REAL_SPACE_R_OVERALL': {'NULLABLE': True,
                                                                     'ORDER': 61,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'FLOAT',
                                                                     'WIDTH': 10},
                                            'REFLECTION_STATUS_ARCHIVED': {'NULLABLE': True,
                                                                           'ORDER': 45,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'VARCHAR',
                                                                           'WIDTH': '2'},
                                            'REFLECTION_STATUS_USED': {'NULLABLE': True,
                                                                       'ORDER': 46,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': '2'},
                                            'REFLNS_TWIN': {'NULLABLE': True,
                                                            'ORDER': 48,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': '50'},
                                            'RFREE_PHENIX': {'NULLABLE': True,
                                                             'ORDER': 69,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                            'RFREE_REFMAC': {'NULLABLE': True,
                                                             'ORDER': 67,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                            'RFREE_RWORK': {'NULLABLE': True,
                                                            'ORDER': 71,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'FLOAT',
                                                            'WIDTH': 10},
                                            'RWORK_PHENIX': {'NULLABLE': True,
                                                             'ORDER': 68,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                            'RWORK_REFMAC': {'NULLABLE': True,
                                                             'ORDER': 66,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                            'R_VALUE_R_FREE': {'NULLABLE': True,
                                                               'ORDER': 9,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                            'R_VALUE_R_WORK': {'NULLABLE': True,
                                                               'ORDER': 8,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                            'SOLVENT_CONTENT': {'NULLABLE': True,
                                                                'ORDER': 56,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                            'SPACE_GROUP_NAME_H_M': {'NULLABLE': True,
                                                                     'ORDER': 5,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': '15'},
                                            'SPACE_GROUP_POINTLESS': {'NULLABLE': True,
                                                                      'ORDER': 6,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': '15'},
                                            'STRUCTURE_ID': {'NULLABLE': False,
                                                             'ORDER': 2,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': '6'},
                                            'TLS_GROUP_NUMBER': {'NULLABLE': True,
                                                                 'ORDER': 52,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'INT',
                                                                 'WIDTH': '11'},
                                            'TLS_REFINEMENT_REPORTED': {'NULLABLE': True,
                                                                        'ORDER': 42,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': '2'},
                                            'TRANSLATIONAL_PSEUDO_SYMMETRY': {'NULLABLE': True,
                                                                              'ORDER': 38,
                                                                              'PRECISION': 0,
                                                                              'PRIMARY_KEY': False,
                                                                              'SQL_TYPE': 'VARCHAR',
                                                                              'WIDTH': '2'},
                                            'TWIN_BY_XTRIAGE': {'NULLABLE': True,
                                                                'ORDER': 49,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': '2'},
                                            'TWIN_FRACTION': {'NULLABLE': True,
                                                              'ORDER': 51,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': '50'},
                                            'TWIN_FRACTION_XTRIAGE': {'NULLABLE': True,
                                                                      'ORDER': 29,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'FLOAT',
                                                                      'WIDTH': 10},
                                            'TWIN_OPERATOR': {'NULLABLE': True,
                                                              'ORDER': 50,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': '50'},
                                            'TWIN_OPERATOR_XTRIAGE': {'NULLABLE': True,
                                                                      'ORDER': 28,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': '50'},
                                            'TWIN_RFACTOR': {'NULLABLE': True,
                                                             'ORDER': 30,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                            'TWIN_TYPE': {'NULLABLE': True,
                                                          'ORDER': 27,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': '2'},
                                            'UNIT_CELL': {'NULLABLE': True,
                                                          'ORDER': 4,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': '50'},
                                            'WAVELENGTH': {'NULLABLE': True,
                                                           'ORDER': 39,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'FLOAT',
                                                           'WIDTH': 10},
                                            'WORKING_SET_COUNT': {'NULLABLE': True,
                                                                  'ORDER': 10,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'INT',
                                                                  'WIDTH': '11'},
                                            'Z_SCORE': {'NULLABLE': True,
                                                        'ORDER': 36,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'FLOAT',
                                                        'WIDTH': 10},
                                            'Z_SCORE_L_TEST': {'NULLABLE': True,
                                                               'ORDER': 26,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10}},
                         'ATTRIBUTE_MAP': {'ANISOTROPY': ('pdbx_density', 'anisotropy', None, None),
                                           'BISO_MAX': ('pdbx_density', 'Biso_max', None, None),
                                           'BISO_MEAN': ('pdbx_density', 'Biso_mean', None, None),
                                           'BISO_MIN': ('pdbx_density', 'Biso_min', None, None),
                                           'BMEAN_BWILSON': ('pdbx_density', 'Bmean_Bwilson', None, None),
                                           'B_SOLVENT': ('pdbx_density', 'B_solvent', None, None),
                                           'B_WILSON': ('pdbx_density', 'B_wilson', None, None),
                                           'B_WILSON_SCALE': ('pdbx_density', 'B_wilson_scale', None, None),
                                           'CORRELATION_OVERALL': ('pdbx_density', 'correlation_overall', None, None),
                                           'CRUICKSHANK_DPI_XYZ': ('pdbx_density', 'Cruickshank_dpi_xyz', None, None),
                                           'DCC_VERSION': ('pdbx_density', 'DCC_version', None, None),
                                           'DPI_FREE_R': ('pdbx_density', 'dpi_free_R', None, None),
                                           'ERROR': ('pdbx_density', 'error', None, None),
                                           'FOM': ('pdbx_density', 'fom', None, None),
                                           'FREE_SET_COUNT': ('pdbx_density', 'free_set_count', None, None),
                                           'ICE_RING': ('pdbx_density', 'ice_ring', None, None),
                                           'ISO_B_VALUE_TYPE': ('pdbx_density', 'iso_B_value_type', None, None),
                                           'I_OVER_SIGI_DIFF': ('pdbx_density', 'I_over_sigI_diff', None, None),
                                           'I_OVER_SIGI_MEAN': ('pdbx_density', 'I_over_sigI_mean', None, None),
                                           'I_OVER_SIGI_RESH': ('pdbx_density', 'I_over_sigI_resh', None, None),
                                           'K_SOLVENT': ('pdbx_density', 'K_solvent', None, None),
                                           'LS_D_RES_HIGH': ('pdbx_density', 'ls_d_res_high', None, None),
                                           'MATTHEW_COEFF': ('pdbx_density', 'Matthew_coeff', None, None),
                                           'MEAN_E2_1_ABS': ('pdbx_density', 'mean_E2_1_abs', None, None),
                                           'MEAN_F_SQUARE_OVER_MEAN_F2': ('pdbx_density',
                                                                          'mean_F_square_over_mean_F2',
                                                                          None,
                                                                          None),
                                           'MEAN_I2_OVER_MEAN_I_SQUARE': ('pdbx_density',
                                                                          'mean_I2_over_mean_I_square',
                                                                          None,
                                                                          None),
                                           'MFO_DFC_3SIGMA_NEGATIVE': ('pdbx_density',
                                                                       'mFo_DFc_3sigma_negative',
                                                                       None,
                                                                       None),
                                           'MFO_DFC_3SIGMA_POSITIVE': ('pdbx_density',
                                                                       'mFo_DFc_3sigma_positive',
                                                                       None,
                                                                       None),
                                           'MFO_DFC_6SIGMA_NEGATIVE': ('pdbx_density',
                                                                       'mFo_DFc_6sigma_negative',
                                                                       None,
                                                                       None),
                                           'MFO_DFC_6SIGMA_POSITIVE': ('pdbx_density',
                                                                       'mFo_DFc_6sigma_positive',
                                                                       None,
                                                                       None),
                                           'MTRIX_NUMBER': ('pdbx_density', 'mtrix_number', None, None),
                                           'NCS_GROUP_NUMBER': ('pdbx_density', 'ncs_group_number', None, None),
                                           'OCCUPANCY_MAX': ('pdbx_density', 'occupancy_max', None, None),
                                           'OCCUPANCY_MEAN': ('pdbx_density', 'occupancy_mean', None, None),
                                           'OCCUPANCY_MIN': ('pdbx_density', 'occupancy_min', None, None),
                                           'PADILLA_YEATES_L2_MEAN': ('pdbx_density',
                                                                      'Padilla_Yeates_L2_mean',
                                                                      None,
                                                                      None),
                                           'PADILLA_YEATES_L2_MEAN_POINTLESS': ('pdbx_density',
                                                                                'Padilla_Yeates_L2_mean_pointless',
                                                                                None,
                                                                                None),
                                           'PADILLA_YEATES_L_MEAN': ('pdbx_density',
                                                                     'Padilla_Yeates_L_mean',
                                                                     None,
                                                                     None),
                                           'PARTIAL_B_VALUE_CORRECTION_ATTEMPTED': ('pdbx_density',
                                                                                    'partial_B_value_correction_attempted',
                                                                                    None,
                                                                                    None),
                                           'PARTIAL_B_VALUE_CORRECTION_SUCCESS': ('pdbx_density',
                                                                                  'partial_B_value_correction_success',
                                                                                  None,
                                                                                  None),
                                           'PDBTYPE': ('pdbx_density', 'pdbtype', None, None),
                                           'PROB_PEAK_VALUE': ('pdbx_density', 'prob_peak_value', None, None),
                                           'REAL_SPACE_R_OVERALL': ('pdbx_density',
                                                                    'real_space_R_overall',
                                                                    None,
                                                                    None),
                                           'REFLECTION_STATUS_ARCHIVED': ('pdbx_density',
                                                                          'reflection_status_archived',
                                                                          None,
                                                                          None),
                                           'REFLECTION_STATUS_USED': ('pdbx_density',
                                                                      'reflection_status_used',
                                                                      None,
                                                                      None),
                                           'REFLNS_TWIN': ('pdbx_density', 'reflns_twin', None, None),
                                           'RFREE_PHENIX': ('pdbx_density', 'Rfree_phenix', None, None),
                                           'RFREE_REFMAC': ('pdbx_density', 'Rfree_refmac', None, None),
                                           'RFREE_RWORK': ('pdbx_density', 'Rfree_Rwork', None, None),
                                           'RWORK_PHENIX': ('pdbx_density', 'Rwork_phenix', None, None),
                                           'RWORK_REFMAC': ('pdbx_density', 'Rwork_refmac', None, None),
                                           'R_VALUE_R_FREE': ('pdbx_density', 'R_value_R_free', None, None),
                                           'R_VALUE_R_WORK': ('pdbx_density', 'R_value_R_work', None, None),
                                           'SOLVENT_CONTENT': ('pdbx_density', 'solvent_content', None, None),
                                           'SPACE_GROUP_NAME_H_M': ('pdbx_density',
                                                                    'space_group_name_H_M',
                                                                    None,
                                                                    None),
                                           'SPACE_GROUP_POINTLESS': ('pdbx_density',
                                                                     'space_group_pointless',
                                                                     None,
                                                                     None),
                                           'STRUCTURE_ID': ('pdbx_density', 'Structure_ID', None, None),
                                           'TLS_GROUP_NUMBER': ('pdbx_density', 'tls_group_number', None, None),
                                           'TLS_REFINEMENT_REPORTED': ('pdbx_density',
                                                                       'TLS_refinement_reported',
                                                                       None,
                                                                       None),
                                           'TRANSLATIONAL_PSEUDO_SYMMETRY': ('pdbx_density',
                                                                             'translational_pseudo_symmetry',
                                                                             None,
                                                                             None),
                                           'TWIN_BY_XTRIAGE': ('pdbx_density', 'twin_by_xtriage', None, None),
                                           'TWIN_FRACTION': ('pdbx_density', 'twin_fraction', None, None),
                                           'TWIN_FRACTION_XTRIAGE': ('pdbx_density',
                                                                     'twin_fraction_xtriage',
                                                                     None,
                                                                     None),
                                           'TWIN_OPERATOR': ('pdbx_density', 'twin_operator', None, None),
                                           'TWIN_OPERATOR_XTRIAGE': ('pdbx_density',
                                                                     'twin_operator_xtriage',
                                                                     None,
                                                                     None),
                                           'TWIN_RFACTOR': ('pdbx_density', 'twin_Rfactor', None, None),
                                           'TWIN_TYPE': ('pdbx_density', 'twin_type', None, None),
                                           'UNIT_CELL': ('pdbx_density', 'unit_cell', None, None),
                                           'WAVELENGTH': ('pdbx_density', 'wavelength', None, None),
                                           'WORKING_SET_COUNT': ('pdbx_density', 'working_set_count', None, None),
                                           'Z_SCORE': ('pdbx_density', 'Z_score', None, None),
                                           'Z_SCORE_L_TEST': ('pdbx_density', 'Z_score_L_test', None, None)},
                         'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'UNIQUE'}},
                         'MAP_MERGE_INDICES': {'pdbx_density': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'EQUI-JOIN'}},
                         'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                         'TABLE_ID': 'PDBX_DENSITY',
                         'TABLE_NAME': 'pdbx_density',
                         'TABLE_TYPE': 'transactional'},
        'PDBX_DENSITY_CORR': {'ATTRIBUTES': {'CORRELATION': 'correlation',
                                             'CORRELATION_COEFF_FO_TO_FC': 'correlation_coeff_Fo_to_Fc',
                                             'DETAILS': 'details',
                                             'LS_D_RES_HIGH': 'ls_d_res_high',
                                             'LS_D_RES_LOW': 'ls_d_res_low',
                                             'LS_NUMBER_REFLNS_OBS': 'ls_number_reflns_obs',
                                             'LS_NUMBER_REFLNS_R_FREE': 'ls_number_reflns_R_free',
                                             'LS_PERCENT_REFLNS_OBS': 'ls_percent_reflns_obs',
                                             'LS_R_FACTOR_R_ALL': 'ls_R_factor_R_all',
                                             'LS_R_FACTOR_R_FREE': 'ls_R_factor_R_free',
                                             'LS_R_FACTOR_R_WORK': 'ls_R_factor_R_work',
                                             'ORDINAL': 'ordinal',
                                             'PROGRAM': 'program',
                                             'REAL_SPACE_R': 'real_space_R',
                                             'STRUCTURE_ID': 'Structure_ID'},
                              'ATTRIBUTE_INFO': {'CORRELATION': {'NULLABLE': True,
                                                                 'ORDER': 14,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                 'CORRELATION_COEFF_FO_TO_FC': {'NULLABLE': True,
                                                                                'ORDER': 12,
                                                                                'PRECISION': 0,
                                                                                'PRIMARY_KEY': False,
                                                                                'SQL_TYPE': 'FLOAT',
                                                                                'WIDTH': 10},
                                                 'DETAILS': {'NULLABLE': True,
                                                             'ORDER': 15,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'TEXT',
                                                             'WIDTH': 10},
                                                 'LS_D_RES_HIGH': {'NULLABLE': True,
                                                                   'ORDER': 4,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                                 'LS_D_RES_LOW': {'NULLABLE': True,
                                                                  'ORDER': 5,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'FLOAT',
                                                                  'WIDTH': 10},
                                                 'LS_NUMBER_REFLNS_OBS': {'NULLABLE': True,
                                                                          'ORDER': 9,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'INT',
                                                                          'WIDTH': '11'},
                                                 'LS_NUMBER_REFLNS_R_FREE': {'NULLABLE': True,
                                                                             'ORDER': 11,
                                                                             'PRECISION': 0,
                                                                             'PRIMARY_KEY': False,
                                                                             'SQL_TYPE': 'INT',
                                                                             'WIDTH': '11'},
                                                 'LS_PERCENT_REFLNS_OBS': {'NULLABLE': True,
                                                                           'ORDER': 10,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'FLOAT',
                                                                           'WIDTH': 10},
                                                 'LS_R_FACTOR_R_ALL': {'NULLABLE': True,
                                                                       'ORDER': 6,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'FLOAT',
                                                                       'WIDTH': 10},
                                                 'LS_R_FACTOR_R_FREE': {'NULLABLE': True,
                                                                        'ORDER': 8,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'FLOAT',
                                                                        'WIDTH': 10},
                                                 'LS_R_FACTOR_R_WORK': {'NULLABLE': True,
                                                                        'ORDER': 7,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'FLOAT',
                                                                        'WIDTH': 10},
                                                 'ORDINAL': {'NULLABLE': True,
                                                             'ORDER': 2,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'INT',
                                                             'WIDTH': '11'},
                                                 'PROGRAM': {'NULLABLE': True,
                                                             'ORDER': 3,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': '15'},
                                                 'REAL_SPACE_R': {'NULLABLE': True,
                                                                  'ORDER': 13,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'FLOAT',
                                                                  'WIDTH': 10},
                                                 'STRUCTURE_ID': {'NULLABLE': False,
                                                                  'ORDER': 1,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': True,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': '6'}},
                              'ATTRIBUTE_MAP': {'CORRELATION': ('pdbx_density_corr', 'correlation', None, None),
                                                'CORRELATION_COEFF_FO_TO_FC': ('pdbx_density_corr',
                                                                               'correlation_coeff_Fo_to_Fc',
                                                                               None,
                                                                               None),
                                                'DETAILS': ('pdbx_density_corr', 'details', None, None),
                                                'LS_D_RES_HIGH': ('pdbx_density_corr', 'ls_d_res_high', None, None),
                                                'LS_D_RES_LOW': ('pdbx_density_corr', 'ls_d_res_low', None, None),
                                                'LS_NUMBER_REFLNS_OBS': ('pdbx_density_corr',
                                                                         'ls_number_reflns_obs',
                                                                         None,
                                                                         None),
                                                'LS_NUMBER_REFLNS_R_FREE': ('pdbx_density_corr',
                                                                            'ls_number_reflns_R_free',
                                                                            None,
                                                                            None),
                                                'LS_PERCENT_REFLNS_OBS': ('pdbx_density_corr',
                                                                          'ls_percent_reflns_obs',
                                                                          None,
                                                                          None),
                                                'LS_R_FACTOR_R_ALL': ('pdbx_density_corr',
                                                                      'ls_R_factor_R_all',
                                                                      None,
                                                                      None),
                                                'LS_R_FACTOR_R_FREE': ('pdbx_density_corr',
                                                                       'ls_R_factor_R_free',
                                                                       None,
                                                                       None),
                                                'LS_R_FACTOR_R_WORK': ('pdbx_density_corr',
                                                                       'ls_R_factor_R_work',
                                                                       None,
                                                                       None),
                                                'ORDINAL': ('pdbx_density_corr', 'ordinal', None, None),
                                                'PROGRAM': ('pdbx_density_corr', 'program', None, None),
                                                'REAL_SPACE_R': ('pdbx_density_corr', 'real_space_R', None, None),
                                                'STRUCTURE_ID': ('pdbx_density_corr', 'Structure_ID', None, None)},
                              'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'UNIQUE'}},
                              'MAP_MERGE_INDICES': {'pdbx_density_corr': {'ATTRIBUTES': ('STRUCTURE_ID',),
                                                                          'TYPE': 'EQUI-JOIN'}},
                              'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                              'TABLE_ID': 'PDBX_DENSITY_CORR',
                              'TABLE_NAME': 'pdbx_density_corr',
                              'TABLE_TYPE': 'transactional'},
        'PDBX_RSCC_MAPMAN': {'ATTRIBUTES': {'AUTH_ASYM_ID': 'auth_asym_id',
                                            'AUTH_COMP_ID': 'auth_comp_id',
                                            'AUTH_SEQ_ID': 'auth_seq_id',
                                            'BISO_MEAN': 'Biso_mean',
                                            'CORRELATION': 'correlation',
                                            'LABEL_ALT_ID': 'label_alt_id',
                                            'LABEL_INS_CODE': 'label_ins_code',
                                            'OCCUPANCY_MEAN': 'occupancy_mean',
                                            'REAL_SPACE_R': 'real_space_R',
                                            'REAL_SPACE_ZSCORE': 'real_space_Zscore',
                                            'RSR_OVER_CORRELATION': 'RsR_over_correlation',
                                            'SECONDARY_STRUCTURE': 'secondary_structure',
                                            'STRUCTURE_ID': 'Structure_ID'},
                             'ATTRIBUTE_INFO': {'AUTH_ASYM_ID': {'NULLABLE': True,
                                                                 'ORDER': 2,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': '5'},
                                                'AUTH_COMP_ID': {'NULLABLE': True,
                                                                 'ORDER': 3,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': '5'},
                                                'AUTH_SEQ_ID': {'NULLABLE': True,
                                                                'ORDER': 4,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'INT',
                                                                'WIDTH': '11'},
                                                'BISO_MEAN': {'NULLABLE': True,
                                                              'ORDER': 10,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'FLOAT',
                                                              'WIDTH': 10},
                                                'CORRELATION': {'NULLABLE': True,
                                                                'ORDER': 7,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                                'LABEL_ALT_ID': {'NULLABLE': True,
                                                                 'ORDER': 5,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': '2'},
                                                'LABEL_INS_CODE': {'NULLABLE': True,
                                                                   'ORDER': 6,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': '2'},
                                                'OCCUPANCY_MEAN': {'NULLABLE': True,
                                                                   'ORDER': 11,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                                'REAL_SPACE_R': {'NULLABLE': True,
                                                                 'ORDER': 8,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                'REAL_SPACE_ZSCORE': {'NULLABLE': True,
                                                                      'ORDER': 9,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'FLOAT',
                                                                      'WIDTH': 10},
                                                'RSR_OVER_CORRELATION': {'NULLABLE': True,
                                                                         'ORDER': 12,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'FLOAT',
                                                                         'WIDTH': 10},
                                                'SECONDARY_STRUCTURE': {'NULLABLE': True,
                                                                        'ORDER': 13,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': '2'},
                                                'STRUCTURE_ID': {'NULLABLE': False,
                                                                 'ORDER': 1,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': True,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': '6'}},
                             'ATTRIBUTE_MAP': {'AUTH_ASYM_ID': ('pdbx_rscc_mapman', 'auth_asym_id', None, None),
                                               'AUTH_COMP_ID': ('pdbx_rscc_mapman', 'auth_comp_id', None, None),
                                               'AUTH_SEQ_ID': ('pdbx_rscc_mapman', 'auth_seq_id', None, None),
                                               'BISO_MEAN': ('pdbx_rscc_mapman', 'Biso_mean', None, None),
                                               'CORRELATION': ('pdbx_rscc_mapman', 'correlation', None, None),
                                               'LABEL_ALT_ID': ('pdbx_rscc_mapman', 'label_alt_id', None, None),
                                               'LABEL_INS_CODE': ('pdbx_rscc_mapman', 'label_ins_code', None, None),
                                               'OCCUPANCY_MEAN': ('pdbx_rscc_mapman', 'occupancy_mean', None, None),
                                               'REAL_SPACE_R': ('pdbx_rscc_mapman', 'real_space_R', None, None),
                                               'REAL_SPACE_ZSCORE': ('pdbx_rscc_mapman',
                                                                     'real_space_Zscore',
                                                                     None,
                                                                     None),
                                               'RSR_OVER_CORRELATION': ('pdbx_rscc_mapman',
                                                                        'RsR_over_correlation',
                                                                        None,
                                                                        None),
                                               'SECONDARY_STRUCTURE': ('pdbx_rscc_mapman',
                                                                       'secondary_structure',
                                                                       None,
                                                                       None),
                                               'STRUCTURE_ID': ('pdbx_rscc_mapman', 'Structure_ID', None, None)},
                             'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'UNIQUE'}},
                             'MAP_MERGE_INDICES': {'pdbx_rscc_mapman': {'ATTRIBUTES': ('STRUCTURE_ID',),
                                                                        'TYPE': 'EQUI-JOIN'}},
                             'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                             'TABLE_ID': 'PDBX_RSCC_MAPMAN',
                             'TABLE_NAME': 'pdbx_rscc_mapman',
                             'TABLE_TYPE': 'transactional'},
        'PDBX_RSCC_MAPMAN_OVERALL': {'ATTRIBUTES': {'CORRELATION': 'correlation',
                                                    'CORRELATION_SIGMA': 'correlation_sigma',
                                                    'REAL_SPACE_R': 'real_space_R',
                                                    'REAL_SPACE_R_SIGMA': 'real_space_R_sigma',
                                                    'STRUCTURE_ID': 'Structure_ID'},
                                     'ATTRIBUTE_INFO': {'CORRELATION': {'NULLABLE': True,
                                                                        'ORDER': 2,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'FLOAT',
                                                                        'WIDTH': 10},
                                                        'CORRELATION_SIGMA': {'NULLABLE': True,
                                                                              'ORDER': 3,
                                                                              'PRECISION': 0,
                                                                              'PRIMARY_KEY': False,
                                                                              'SQL_TYPE': 'FLOAT',
                                                                              'WIDTH': 10},
                                                        'REAL_SPACE_R': {'NULLABLE': True,
                                                                         'ORDER': 4,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'FLOAT',
                                                                         'WIDTH': 10},
                                                        'REAL_SPACE_R_SIGMA': {'NULLABLE': True,
                                                                               'ORDER': 5,
                                                                               'PRECISION': 0,
                                                                               'PRIMARY_KEY': False,
                                                                               'SQL_TYPE': 'FLOAT',
                                                                               'WIDTH': 10},
                                                        'STRUCTURE_ID': {'NULLABLE': False,
                                                                         'ORDER': 1,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': True,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': '6'}},
                                     'ATTRIBUTE_MAP': {'CORRELATION': ('pdbx_rscc_mapman_overall',
                                                                       'correlation',
                                                                       None,
                                                                       None),
                                                       'CORRELATION_SIGMA': ('pdbx_rscc_mapman_overall',
                                                                             'correlation_sigma',
                                                                             None,
                                                                             None),
                                                       'REAL_SPACE_R': ('pdbx_rscc_mapman_overall',
                                                                        'real_space_R',
                                                                        None,
                                                                        None),
                                                       'REAL_SPACE_R_SIGMA': ('pdbx_rscc_mapman_overall',
                                                                              'real_space_R_sigma',
                                                                              None,
                                                                              None),
                                                       'STRUCTURE_ID': ('pdbx_rscc_mapman_overall',
                                                                        'Structure_ID',
                                                                        None,
                                                                        None)},
                                     'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'UNIQUE'}},
                                     'MAP_MERGE_INDICES': {'pdbx_rscc_mapman_overall': {'ATTRIBUTES': ('STRUCTURE_ID',),
                                                                                        'TYPE': 'EQUI-JOIN'}},
                                     'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                     'TABLE_ID': 'PDBX_RSCC_MAPMAN_OVERALL',
                                     'TABLE_NAME': 'pdbx_rscc_mapman_overall',
                                     'TABLE_TYPE': 'transactional'},
        'PDBX_WEBSELECT': {'ATTRIBUTES': {'CRYSTAL_TWIN': 'crystal_twin',
                                          'DATE_OF_RCSB_RELEASE': 'date_of_RCSB_release',
                                          'ENTRY_TYPE': 'entry_type',
                                          'LS_D_RES_HIGH': 'ls_d_res_high',
                                          'METHOD_TO_DETERMINE_STRUCT': 'method_to_determine_struct',
                                          'REFINEMENT_SOFTWARE': 'refinement_software',
                                          'R_VALUE_R_FREE': 'R_value_R_free',
                                          'SOLVENT_CONTENT': 'solvent_content',
                                          'SPACE_GROUP_NAME_H_M': 'space_group_name_H_M',
                                          'STRUCTURE_ID': 'Structure_ID',
                                          'WEIGHT_IN_ASU': 'weight_in_ASU'},
                           'ATTRIBUTE_INFO': {'CRYSTAL_TWIN': {'NULLABLE': True,
                                                               'ORDER': 11,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                              'DATE_OF_RCSB_RELEASE': {'NULLABLE': True,
                                                                       'ORDER': 3,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'FLOAT',
                                                                       'WIDTH': 10},
                                              'ENTRY_TYPE': {'NULLABLE': True,
                                                             'ORDER': 8,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': '20'},
                                              'LS_D_RES_HIGH': {'NULLABLE': True,
                                                                'ORDER': 4,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                              'METHOD_TO_DETERMINE_STRUCT': {'NULLABLE': True,
                                                                             'ORDER': 6,
                                                                             'PRECISION': 0,
                                                                             'PRIMARY_KEY': False,
                                                                             'SQL_TYPE': 'VARCHAR',
                                                                             'WIDTH': '30'},
                                              'REFINEMENT_SOFTWARE': {'NULLABLE': True,
                                                                      'ORDER': 10,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': '20'},
                                              'R_VALUE_R_FREE': {'NULLABLE': True,
                                                                 'ORDER': 5,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                              'SOLVENT_CONTENT': {'NULLABLE': True,
                                                                  'ORDER': 7,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'FLOAT',
                                                                  'WIDTH': 10},
                                              'SPACE_GROUP_NAME_H_M': {'NULLABLE': True,
                                                                       'ORDER': 2,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': '12'},
                                              'STRUCTURE_ID': {'NULLABLE': False,
                                                               'ORDER': 1,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': '6'},
                                              'WEIGHT_IN_ASU': {'NULLABLE': True,
                                                                'ORDER': 9,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10}},
                           'ATTRIBUTE_MAP': {'CRYSTAL_TWIN': ('pdbx_webselect', 'crystal_twin', None, None),
                                             'DATE_OF_RCSB_RELEASE': ('pdbx_webselect',
                                                                      'date_of_RCSB_release',
                                                                      None,
                                                                      None),
                                             'ENTRY_TYPE': ('pdbx_webselect', 'entry_type', None, None),
                                             'LS_D_RES_HIGH': ('pdbx_webselect', 'ls_d_res_high', None, None),
                                             'METHOD_TO_DETERMINE_STRUCT': ('pdbx_webselect',
                                                                            'method_to_determine_struct',
                                                                            None,
                                                                            None),
                                             'REFINEMENT_SOFTWARE': ('pdbx_webselect',
                                                                     'refinement_software',
                                                                     None,
                                                                     None),
                                             'R_VALUE_R_FREE': ('pdbx_webselect', 'R_value_R_free', None, None),
                                             'SOLVENT_CONTENT': ('pdbx_webselect', 'solvent_content', None, None),
                                             'SPACE_GROUP_NAME_H_M': ('pdbx_webselect',
                                                                      'space_group_name_H_M',
                                                                      None,
                                                                      None),
                                             'STRUCTURE_ID': ('pdbx_webselect', 'Structure_ID', None, None),
                                             'WEIGHT_IN_ASU': ('pdbx_webselect', 'weight_in_ASU', None, None)},
                           'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'UNIQUE'}},
                           'MAP_MERGE_INDICES': {'pdbx_webselect': {'ATTRIBUTES': ('STRUCTURE_ID',),
                                                                    'TYPE': 'EQUI-JOIN'}},
                           'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                           'TABLE_ID': 'PDBX_WEBSELECT',
                           'TABLE_NAME': 'pdbx_webselect',
                           'TABLE_TYPE': 'transactional'},
        'PDB_ENTRY': {'ATTRIBUTES': {'AUTHOR_APPROVAL_TYPE': 'author_approval_type',
                                     'AUTHOR_LIST': 'author_list',
                                     'AUTHOR_RELEASE_SEQUENCE': 'author_release_sequence',
                                     'AUTHOR_RELEASE_STATUS_CODE': 'author_release_status_code',
                                     'DATE_AUTHOR_APPROVAL': 'date_author_approval',
                                     'DATE_CHEMICAL_SHIFTS': 'date_chemical_shifts',
                                     'DATE_COORDINATES': 'date_coordinates',
                                     'DATE_DEPOSITION_FORM': 'date_deposition_form',
                                     'DATE_HOLD_CHEMICAL_SHIFTS': 'date_hold_chemical_shifts',
                                     'DATE_HOLD_COORDINATES': 'date_hold_coordinates',
                                     'DATE_HOLD_NMR_CONSTRAINTS': 'date_hold_nmr_constraints',
                                     'DATE_HOLD_STRUCT_FACT': 'date_hold_struct_fact',
                                     'DATE_LAST_UPDATE': 'date_last_update',
                                     'DATE_MANUSCRIPT': 'date_manuscript',
                                     'DATE_NMR_CONSTRAINTS': 'date_nmr_constraints',
                                     'DATE_OF_CS_RELEASE': 'date_of_cs_release',
                                     'DATE_OF_MR_RELEASE': 'date_of_mr_release',
                                     'DATE_OF_RCSB_RELEASE': 'date_of_RCSB_release',
                                     'DATE_OF_SF_RELEASE': 'date_of_sf_release',
                                     'DATE_STRUCT_FACT': 'date_struct_fact',
                                     'DEPOSIT_SITE': 'deposit_site',
                                     'EBI_ID': 'ebi_id',
                                     'HEADER': 'header',
                                     'INITIAL_DEPOSITION_DATE': 'initial_deposition_date',
                                     'METHOD': 'method',
                                     'METHODS_DEVELOPMENT_CATEGORY': 'methods_development_category',
                                     'NDB_ID': 'ndb_id',
                                     'PDB_FORMAT_COMPATIBLE': 'pdb_format_compatible',
                                     'PDB_ID': 'pdb_id',
                                     'PROCESS_SITE': 'process_site',
                                     'RCSB_ANNOTATOR': 'rcsb_annotator',
                                     'RECVD_AUTHOR_APPROVAL': 'recvd_author_approval',
                                     'REPLACED_ENTRY_ID': 'replaced_entry_id',
                                     'REVISION_DESCRIPTION': 'revision_description',
                                     'SG_ENTRY': 'SG_entry',
                                     'STATUS_CODE': 'status_code',
                                     'STATUS_CODE_CS': 'status_code_cs',
                                     'STATUS_CODE_MR': 'status_code_mr',
                                     'STATUS_CODE_SF': 'status_code_sf',
                                     'STRUCTURE_ID': 'structure_id',
                                     'SUPPRESSED_TITLE_Y_N': 'suppressed_title_Y_N',
                                     'TITLE': 'title',
                                     'TITLEUC': 'titleUC'},
                      'ATTRIBUTE_INFO': {'AUTHOR_APPROVAL_TYPE': {'NULLABLE': True,
                                                                  'ORDER': 11,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': '10'},
                                         'AUTHOR_LIST': {'NULLABLE': True,
                                                         'ORDER': 23,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': '700'},
                                         'AUTHOR_RELEASE_SEQUENCE': {'NULLABLE': True,
                                                                     'ORDER': 27,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': '20'},
                                         'AUTHOR_RELEASE_STATUS_CODE': {'NULLABLE': True,
                                                                        'ORDER': 5,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': '10'},
                                         'DATE_AUTHOR_APPROVAL': {'NULLABLE': True,
                                                                  'ORDER': 9,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'DATE',
                                                                  'WIDTH': 10},
                                         'DATE_CHEMICAL_SHIFTS': {'NULLABLE': True,
                                                                  'ORDER': 39,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'DATE',
                                                                  'WIDTH': 10},
                                         'DATE_COORDINATES': {'NULLABLE': True,
                                                              'ORDER': 17,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'DATE',
                                                              'WIDTH': 10},
                                         'DATE_DEPOSITION_FORM': {'NULLABLE': True,
                                                                  'ORDER': 16,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'DATE',
                                                                  'WIDTH': 10},
                                         'DATE_HOLD_CHEMICAL_SHIFTS': {'NULLABLE': True,
                                                                       'ORDER': 40,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'DATE',
                                                                       'WIDTH': 10},
                                         'DATE_HOLD_COORDINATES': {'NULLABLE': True,
                                                                   'ORDER': 12,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'DATE',
                                                                   'WIDTH': 10},
                                         'DATE_HOLD_NMR_CONSTRAINTS': {'NULLABLE': True,
                                                                       'ORDER': 14,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'DATE',
                                                                       'WIDTH': 10},
                                         'DATE_HOLD_STRUCT_FACT': {'NULLABLE': True,
                                                                   'ORDER': 13,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'DATE',
                                                                   'WIDTH': 10},
                                         'DATE_LAST_UPDATE': {'NULLABLE': True,
                                                              'ORDER': 26,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'DATETIME',
                                                              'WIDTH': 10},
                                         'DATE_MANUSCRIPT': {'NULLABLE': True,
                                                             'ORDER': 19,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'DATE',
                                                             'WIDTH': 10},
                                         'DATE_NMR_CONSTRAINTS': {'NULLABLE': True,
                                                                  'ORDER': 20,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'DATE',
                                                                  'WIDTH': 10},
                                         'DATE_OF_CS_RELEASE': {'NULLABLE': True,
                                                                'ORDER': 41,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'DATE',
                                                                'WIDTH': 10},
                                         'DATE_OF_MR_RELEASE': {'NULLABLE': True,
                                                                'ORDER': 32,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'DATE',
                                                                'WIDTH': 10},
                                         'DATE_OF_RCSB_RELEASE': {'NULLABLE': True,
                                                                  'ORDER': 15,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'DATE',
                                                                  'WIDTH': 10},
                                         'DATE_OF_SF_RELEASE': {'NULLABLE': True,
                                                                'ORDER': 31,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'DATE',
                                                                'WIDTH': 10},
                                         'DATE_STRUCT_FACT': {'NULLABLE': True,
                                                              'ORDER': 18,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'DATE',
                                                              'WIDTH': 10},
                                         'DEPOSIT_SITE': {'NULLABLE': True,
                                                          'ORDER': 6,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': '10'},
                                         'EBI_ID': {'NULLABLE': True,
                                                    'ORDER': 35,
                                                    'PRECISION': 0,
                                                    'PRIMARY_KEY': False,
                                                    'SQL_TYPE': 'VARCHAR',
                                                    'WIDTH': '10'},
                                         'HEADER': {'NULLABLE': True,
                                                    'ORDER': 34,
                                                    'PRECISION': 0,
                                                    'PRIMARY_KEY': False,
                                                    'SQL_TYPE': 'VARCHAR',
                                                    'WIDTH': '80'},
                                         'INITIAL_DEPOSITION_DATE': {'NULLABLE': True,
                                                                     'ORDER': 8,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'DATE',
                                                                     'WIDTH': 10},
                                         'METHOD': {'NULLABLE': True,
                                                    'ORDER': 33,
                                                    'PRECISION': 0,
                                                    'PRIMARY_KEY': False,
                                                    'SQL_TYPE': 'VARCHAR',
                                                    'WIDTH': '80'},
                                         'METHODS_DEVELOPMENT_CATEGORY': {'NULLABLE': True,
                                                                          'ORDER': 42,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': '20'},
                                         'NDB_ID': {'NULLABLE': True,
                                                    'ORDER': 36,
                                                    'PRECISION': 0,
                                                    'PRIMARY_KEY': False,
                                                    'SQL_TYPE': 'VARCHAR',
                                                    'WIDTH': '10'},
                                         'PDB_FORMAT_COMPATIBLE': {'NULLABLE': True,
                                                                   'ORDER': 43,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': '2'},
                                         'PDB_ID': {'NULLABLE': False,
                                                    'ORDER': 2,
                                                    'PRECISION': 0,
                                                    'PRIMARY_KEY': True,
                                                    'SQL_TYPE': 'VARCHAR',
                                                    'WIDTH': '8'},
                                         'PROCESS_SITE': {'NULLABLE': True,
                                                          'ORDER': 7,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': '10'},
                                         'RCSB_ANNOTATOR': {'NULLABLE': True,
                                                            'ORDER': 3,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': '10'},
                                         'RECVD_AUTHOR_APPROVAL': {'NULLABLE': True,
                                                                   'ORDER': 10,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': '1'},
                                         'REPLACED_ENTRY_ID': {'NULLABLE': True,
                                                               'ORDER': 21,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': '10'},
                                         'REVISION_DESCRIPTION': {'NULLABLE': True,
                                                                  'ORDER': 22,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': '255'},
                                         'SG_ENTRY': {'NULLABLE': True,
                                                      'ORDER': 30,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'VARCHAR',
                                                      'WIDTH': '50'},
                                         'STATUS_CODE': {'NULLABLE': True,
                                                         'ORDER': 4,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': '10'},
                                         'STATUS_CODE_CS': {'NULLABLE': True,
                                                            'ORDER': 38,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': '10'},
                                         'STATUS_CODE_MR': {'NULLABLE': True,
                                                            'ORDER': 29,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': '10'},
                                         'STATUS_CODE_SF': {'NULLABLE': True,
                                                            'ORDER': 28,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': '10'},
                                         'STRUCTURE_ID': {'NULLABLE': False,
                                                          'ORDER': 1,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': True,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': '15'},
                                         'SUPPRESSED_TITLE_Y_N': {'NULLABLE': True,
                                                                  'ORDER': 37,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': '2'},
                                         'TITLE': {'NULLABLE': True,
                                                   'ORDER': 24,
                                                   'PRECISION': 0,
                                                   'PRIMARY_KEY': False,
                                                   'SQL_TYPE': 'VARCHAR',
                                                   'WIDTH': '500'},
                                         'TITLEUC': {'NULLABLE': True,
                                                     'ORDER': 25,
                                                     'PRECISION': 0,
                                                     'PRIMARY_KEY': False,
                                                     'SQL_TYPE': 'VARCHAR',
                                                     'WIDTH': '500'}},
                      'ATTRIBUTE_MAP': {'AUTHOR_APPROVAL_TYPE': ('pdb_entry', 'author_approval_type', None, None),
                                        'AUTHOR_LIST': ('pdb_entry', 'author_list', None, None),
                                        'AUTHOR_RELEASE_SEQUENCE': ('pdb_entry',
                                                                    'author_release_sequence',
                                                                    None,
                                                                    None),
                                        'AUTHOR_RELEASE_STATUS_CODE': ('pdb_entry',
                                                                       'author_release_status_code',
                                                                       None,
                                                                       None),
                                        'DATE_AUTHOR_APPROVAL': ('pdb_entry', 'date_author_approval', None, None),
                                        'DATE_CHEMICAL_SHIFTS': ('pdb_entry', 'date_chemical_shifts', None, None),
                                        'DATE_COORDINATES': ('pdb_entry', 'date_coordinates', None, None),
                                        'DATE_DEPOSITION_FORM': ('pdb_entry', 'date_deposition_form', None, None),
                                        'DATE_HOLD_CHEMICAL_SHIFTS': ('pdb_entry',
                                                                      'date_hold_chemical_shifts',
                                                                      None,
                                                                      None),
                                        'DATE_HOLD_COORDINATES': ('pdb_entry', 'date_hold_coordinates', None, None),
                                        'DATE_HOLD_NMR_CONSTRAINTS': ('pdb_entry',
                                                                      'date_hold_nmr_constraints',
                                                                      None,
                                                                      None),
                                        'DATE_HOLD_STRUCT_FACT': ('pdb_entry', 'date_hold_struct_fact', None, None),
                                        'DATE_LAST_UPDATE': ('pdb_entry', 'date_last_update', None, None),
                                        'DATE_MANUSCRIPT': ('pdb_entry', 'date_manuscript', None, None),
                                        'DATE_NMR_CONSTRAINTS': ('pdb_entry', 'date_nmr_constraints', None, None),
                                        'DATE_OF_CS_RELEASE': ('pdb_entry', 'date_of_cs_release', None, None),
                                        'DATE_OF_MR_RELEASE': ('pdb_entry', 'date_of_mr_release', None, None),
                                        'DATE_OF_RCSB_RELEASE': ('pdb_entry', 'date_of_RCSB_release', None, None),
                                        'DATE_OF_SF_RELEASE': ('pdb_entry', 'date_of_sf_release', None, None),
                                        'DATE_STRUCT_FACT': ('pdb_entry', 'date_struct_fact', None, None),
                                        'DEPOSIT_SITE': ('pdb_entry', 'deposit_site', None, None),
                                        'EBI_ID': ('pdb_entry', 'ebi_id', None, None),
                                        'HEADER': ('pdb_entry', 'header', None, None),
                                        'INITIAL_DEPOSITION_DATE': ('pdb_entry',
                                                                    'initial_deposition_date',
                                                                    None,
                                                                    None),
                                        'METHOD': ('pdb_entry', 'method', None, None),
                                        'METHODS_DEVELOPMENT_CATEGORY': ('pdb_entry',
                                                                         'methods_development_category',
                                                                         None,
                                                                         None),
                                        'NDB_ID': ('pdb_entry', 'ndb_id', None, None),
                                        'PDB_FORMAT_COMPATIBLE': ('pdb_entry', 'pdb_format_compatible', None, None),
                                        'PDB_ID': ('pdb_entry', 'pdb_id', None, None),
                                        'PROCESS_SITE': ('pdb_entry', 'process_site', None, None),
                                        'RCSB_ANNOTATOR': ('pdb_entry', 'rcsb_annotator', None, None),
                                        'RECVD_AUTHOR_APPROVAL': ('pdb_entry', 'recvd_author_approval', None, None),
                                        'REPLACED_ENTRY_ID': ('pdb_entry', 'replaced_entry_id', None, None),
                                        'REVISION_DESCRIPTION': ('pdb_entry', 'revision_description', None, None),
                                        'SG_ENTRY': ('pdb_entry', 'SG_entry', None, None),
                                        'STATUS_CODE': ('pdb_entry', 'status_code', None, None),
                                        'STATUS_CODE_CS': ('pdb_entry', 'status_code_cs', None, None),
                                        'STATUS_CODE_MR': ('pdb_entry', 'status_code_mr', None, None),
                                        'STATUS_CODE_SF': ('pdb_entry', 'status_code_sf', None, None),
                                        'STRUCTURE_ID': ('pdb_entry', 'structure_id', None, None),
                                        'SUPPRESSED_TITLE_Y_N': ('pdb_entry', 'suppressed_title_Y_N', None, None),
                                        'TITLE': ('pdb_entry', 'title', None, None),
                                        'TITLEUC': ('pdb_entry', 'titleUC', None, None)},
                      'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'PDB_ID'), 'TYPE': 'UNIQUE'}},
                      'MAP_MERGE_INDICES': {'pdb_entry': {'ATTRIBUTES': ('STRUCTURE_ID', 'PDB_ID'),
                                                          'TYPE': 'EQUI-JOIN'}},
                      'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                      'TABLE_ID': 'PDB_ENTRY',
                      'TABLE_NAME': 'pdb_entry',
                      'TABLE_TYPE': 'transactional'},
        'PDB_ENTRY_TMP': {'ATTRIBUTES': {'AUTHOR_APPROVAL_TYPE': 'author_approval_type',
                                         'AUTHOR_LIST': 'author_list',
                                         'AUTHOR_RELEASE_SEQUENCE': 'author_release_sequence',
                                         'AUTHOR_RELEASE_STATUS_CODE': 'author_release_status_code',
                                         'DATE_AUTHOR_APPROVAL': 'date_author_approval',
                                         'DATE_CHEMICAL_SHIFTS': 'date_chemical_shifts',
                                         'DATE_COORDINATES': 'date_coordinates',
                                         'DATE_DEPOSITION_FORM': 'date_deposition_form',
                                         'DATE_HOLD_CHEMICAL_SHIFTS': 'date_hold_chemical_shifts',
                                         'DATE_HOLD_COORDINATES': 'date_hold_coordinates',
                                         'DATE_HOLD_NMR_CONSTRAINTS': 'date_hold_nmr_constraints',
                                         'DATE_HOLD_STRUCT_FACT': 'date_hold_struct_fact',
                                         'DATE_LAST_UPDATE': 'date_last_update',
                                         'DATE_MANUSCRIPT': 'date_manuscript',
                                         'DATE_NMR_CONSTRAINTS': 'date_nmr_constraints',
                                         'DATE_OF_CS_RELEASE': 'date_of_cs_release',
                                         'DATE_OF_MR_RELEASE': 'date_of_mr_release',
                                         'DATE_OF_RCSB_RELEASE': 'date_of_RCSB_release',
                                         'DATE_OF_SF_RELEASE': 'date_of_sf_release',
                                         'DATE_STRUCT_FACT': 'date_struct_fact',
                                         'DEPOSIT_SITE': 'deposit_site',
                                         'EBI_ID': 'ebi_id',
                                         'HEADER': 'header',
                                         'INITIAL_DEPOSITION_DATE': 'initial_deposition_date',
                                         'METHOD': 'method',
                                         'METHODS_DEVELOPMENT_CATEGORY': 'methods_development_category',
                                         'NDB_ID': 'ndb_id',
                                         'PDB_FORMAT_COMPATIBLE': 'pdb_format_compatible',
                                         'PDB_ID': 'pdb_id',
                                         'PROCESS_SITE': 'process_site',
                                         'RCSB_ANNOTATOR': 'rcsb_annotator',
                                         'RECVD_AUTHOR_APPROVAL': 'recvd_author_approval',
                                         'REPLACED_ENTRY_ID': 'replaced_entry_id',
                                         'REVISION_DESCRIPTION': 'revision_description',
                                         'SG_ENTRY': 'SG_entry',
                                         'STATUS_CODE': 'status_code',
                                         'STATUS_CODE_CS': 'status_code_cs',
                                         'STATUS_CODE_MR': 'status_code_mr',
                                         'STATUS_CODE_SF': 'status_code_sf',
                                         'STRUCTURE_ID': 'structure_id',
                                         'SUPPRESSED_TITLE_Y_N': 'suppressed_title_Y_N',
                                         'TITLE': 'title',
                                         'TITLEUC': 'titleUC'},
                          'ATTRIBUTE_INFO': {'AUTHOR_APPROVAL_TYPE': {'NULLABLE': True,
                                                                      'ORDER': 11,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': '10'},
                                             'AUTHOR_LIST': {'NULLABLE': True,
                                                             'ORDER': 23,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': '700'},
                                             'AUTHOR_RELEASE_SEQUENCE': {'NULLABLE': True,
                                                                         'ORDER': 27,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': '20'},
                                             'AUTHOR_RELEASE_STATUS_CODE': {'NULLABLE': True,
                                                                            'ORDER': 5,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': '10'},
                                             'DATE_AUTHOR_APPROVAL': {'NULLABLE': True,
                                                                      'ORDER': 9,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'DATE',
                                                                      'WIDTH': 10},
                                             'DATE_CHEMICAL_SHIFTS': {'NULLABLE': True,
                                                                      'ORDER': 39,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'DATE',
                                                                      'WIDTH': 10},
                                             'DATE_COORDINATES': {'NULLABLE': True,
                                                                  'ORDER': 17,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'DATE',
                                                                  'WIDTH': 10},
                                             'DATE_DEPOSITION_FORM': {'NULLABLE': True,
                                                                      'ORDER': 16,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'DATE',
                                                                      'WIDTH': 10},
                                             'DATE_HOLD_CHEMICAL_SHIFTS': {'NULLABLE': True,
                                                                           'ORDER': 40,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'DATE',
                                                                           'WIDTH': 10},
                                             'DATE_HOLD_COORDINATES': {'NULLABLE': True,
                                                                       'ORDER': 12,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'DATE',
                                                                       'WIDTH': 10},
                                             'DATE_HOLD_NMR_CONSTRAINTS': {'NULLABLE': True,
                                                                           'ORDER': 14,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'DATE',
                                                                           'WIDTH': 10},
                                             'DATE_HOLD_STRUCT_FACT': {'NULLABLE': True,
                                                                       'ORDER': 13,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'DATE',
                                                                       'WIDTH': 10},
                                             'DATE_LAST_UPDATE': {'NULLABLE': True,
                                                                  'ORDER': 26,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'DATETIME',
                                                                  'WIDTH': 10},
                                             'DATE_MANUSCRIPT': {'NULLABLE': True,
                                                                 'ORDER': 19,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'DATE',
                                                                 'WIDTH': 10},
                                             'DATE_NMR_CONSTRAINTS': {'NULLABLE': True,
                                                                      'ORDER': 20,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'DATE',
                                                                      'WIDTH': 10},
                                             'DATE_OF_CS_RELEASE': {'NULLABLE': True,
                                                                    'ORDER': 41,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'DATE',
                                                                    'WIDTH': 10},
                                             'DATE_OF_MR_RELEASE': {'NULLABLE': True,
                                                                    'ORDER': 32,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'DATE',
                                                                    'WIDTH': 10},
                                             'DATE_OF_RCSB_RELEASE': {'NULLABLE': True,
                                                                      'ORDER': 15,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'DATE',
                                                                      'WIDTH': 10},
                                             'DATE_OF_SF_RELEASE': {'NULLABLE': True,
                                                                    'ORDER': 31,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'DATE',
                                                                    'WIDTH': 10},
                                             'DATE_STRUCT_FACT': {'NULLABLE': True,
                                                                  'ORDER': 18,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'DATE',
                                                                  'WIDTH': 10},
                                             'DEPOSIT_SITE': {'NULLABLE': True,
                                                              'ORDER': 6,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': '10'},
                                             'EBI_ID': {'NULLABLE': True,
                                                        'ORDER': 35,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': '10'},
                                             'HEADER': {'NULLABLE': True,
                                                        'ORDER': 34,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': '80'},
                                             'INITIAL_DEPOSITION_DATE': {'NULLABLE': True,
                                                                         'ORDER': 8,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'DATE',
                                                                         'WIDTH': 10},
                                             'METHOD': {'NULLABLE': True,
                                                        'ORDER': 33,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': '80'},
                                             'METHODS_DEVELOPMENT_CATEGORY': {'NULLABLE': True,
                                                                              'ORDER': 42,
                                                                              'PRECISION': 0,
                                                                              'PRIMARY_KEY': False,
                                                                              'SQL_TYPE': 'VARCHAR',
                                                                              'WIDTH': '20'},
                                             'NDB_ID': {'NULLABLE': True,
                                                        'ORDER': 36,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': '10'},
                                             'PDB_FORMAT_COMPATIBLE': {'NULLABLE': True,
                                                                       'ORDER': 43,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': '2'},
                                             'PDB_ID': {'NULLABLE': False,
                                                        'ORDER': 2,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': True,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': '8'},
                                             'PROCESS_SITE': {'NULLABLE': True,
                                                              'ORDER': 7,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': '10'},
                                             'RCSB_ANNOTATOR': {'NULLABLE': True,
                                                                'ORDER': 3,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': '10'},
                                             'RECVD_AUTHOR_APPROVAL': {'NULLABLE': True,
                                                                       'ORDER': 10,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': '1'},
                                             'REPLACED_ENTRY_ID': {'NULLABLE': True,
                                                                   'ORDER': 21,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': '10'},
                                             'REVISION_DESCRIPTION': {'NULLABLE': True,
                                                                      'ORDER': 22,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': '255'},
                                             'SG_ENTRY': {'NULLABLE': True,
                                                          'ORDER': 30,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': '50'},
                                             'STATUS_CODE': {'NULLABLE': True,
                                                             'ORDER': 4,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': '10'},
                                             'STATUS_CODE_CS': {'NULLABLE': True,
                                                                'ORDER': 38,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': '10'},
                                             'STATUS_CODE_MR': {'NULLABLE': True,
                                                                'ORDER': 29,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': '10'},
                                             'STATUS_CODE_SF': {'NULLABLE': True,
                                                                'ORDER': 28,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': '10'},
                                             'STRUCTURE_ID': {'NULLABLE': False,
                                                              'ORDER': 1,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': True,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': '15'},
                                             'SUPPRESSED_TITLE_Y_N': {'NULLABLE': True,
                                                                      'ORDER': 37,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': '2'},
                                             'TITLE': {'NULLABLE': True,
                                                       'ORDER': 24,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': False,
                                                       'SQL_TYPE': 'VARCHAR',
                                                       'WIDTH': '500'},
                                             'TITLEUC': {'NULLABLE': True,
                                                         'ORDER': 25,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': '500'}},
                          'ATTRIBUTE_MAP': {'AUTHOR_APPROVAL_TYPE': ('pdb_entry_tmp',
                                                                     'author_approval_type',
                                                                     None,
                                                                     None),
                                            'AUTHOR_LIST': ('pdb_entry_tmp', 'author_list', None, None),
                                            'AUTHOR_RELEASE_SEQUENCE': ('pdb_entry_tmp',
                                                                        'author_release_sequence',
                                                                        None,
                                                                        None),
                                            'AUTHOR_RELEASE_STATUS_CODE': ('pdb_entry_tmp',
                                                                           'author_release_status_code',
                                                                           None,
                                                                           None),
                                            'DATE_AUTHOR_APPROVAL': ('pdb_entry_tmp',
                                                                     'date_author_approval',
                                                                     None,
                                                                     None),
                                            'DATE_CHEMICAL_SHIFTS': ('pdb_entry_tmp',
                                                                     'date_chemical_shifts',
                                                                     None,
                                                                     None),
                                            'DATE_COORDINATES': ('pdb_entry_tmp', 'date_coordinates', None, None),
                                            'DATE_DEPOSITION_FORM': ('pdb_entry_tmp',
                                                                     'date_deposition_form',
                                                                     None,
                                                                     None),
                                            'DATE_HOLD_CHEMICAL_SHIFTS': ('pdb_entry_tmp',
                                                                          'date_hold_chemical_shifts',
                                                                          None,
                                                                          None),
                                            'DATE_HOLD_COORDINATES': ('pdb_entry_tmp',
                                                                      'date_hold_coordinates',
                                                                      None,
                                                                      None),
                                            'DATE_HOLD_NMR_CONSTRAINTS': ('pdb_entry_tmp',
                                                                          'date_hold_nmr_constraints',
                                                                          None,
                                                                          None),
                                            'DATE_HOLD_STRUCT_FACT': ('pdb_entry_tmp',
                                                                      'date_hold_struct_fact',
                                                                      None,
                                                                      None),
                                            'DATE_LAST_UPDATE': ('pdb_entry_tmp', 'date_last_update', None, None),
                                            'DATE_MANUSCRIPT': ('pdb_entry_tmp', 'date_manuscript', None, None),
                                            'DATE_NMR_CONSTRAINTS': ('pdb_entry_tmp',
                                                                     'date_nmr_constraints',
                                                                     None,
                                                                     None),
                                            'DATE_OF_CS_RELEASE': ('pdb_entry_tmp', 'date_of_cs_release', None, None),
                                            'DATE_OF_MR_RELEASE': ('pdb_entry_tmp', 'date_of_mr_release', None, None),
                                            'DATE_OF_RCSB_RELEASE': ('pdb_entry_tmp',
                                                                     'date_of_RCSB_release',
                                                                     None,
                                                                     None),
                                            'DATE_OF_SF_RELEASE': ('pdb_entry_tmp', 'date_of_sf_release', None, None),
                                            'DATE_STRUCT_FACT': ('pdb_entry_tmp', 'date_struct_fact', None, None),
                                            'DEPOSIT_SITE': ('pdb_entry_tmp', 'deposit_site', None, None),
                                            'EBI_ID': ('pdb_entry_tmp', 'ebi_id', None, None),
                                            'HEADER': ('pdb_entry_tmp', 'header', None, None),
                                            'INITIAL_DEPOSITION_DATE': ('pdb_entry_tmp',
                                                                        'initial_deposition_date',
                                                                        None,
                                                                        None),
                                            'METHOD': ('pdb_entry_tmp', 'method', None, None),
                                            'METHODS_DEVELOPMENT_CATEGORY': ('pdb_entry_tmp',
                                                                             'methods_development_category',
                                                                             None,
                                                                             None),
                                            'NDB_ID': ('pdb_entry_tmp', 'ndb_id', None, None),
                                            'PDB_FORMAT_COMPATIBLE': ('pdb_entry_tmp',
                                                                      'pdb_format_compatible',
                                                                      None,
                                                                      None),
                                            'PDB_ID': ('pdb_entry_tmp', 'pdb_id', None, None),
                                            'PROCESS_SITE': ('pdb_entry_tmp', 'process_site', None, None),
                                            'RCSB_ANNOTATOR': ('pdb_entry_tmp', 'rcsb_annotator', None, None),
                                            'RECVD_AUTHOR_APPROVAL': ('pdb_entry_tmp',
                                                                      'recvd_author_approval',
                                                                      None,
                                                                      None),
                                            'REPLACED_ENTRY_ID': ('pdb_entry_tmp', 'replaced_entry_id', None, None),
                                            'REVISION_DESCRIPTION': ('pdb_entry_tmp',
                                                                     'revision_description',
                                                                     None,
                                                                     None),
                                            'SG_ENTRY': ('pdb_entry_tmp', 'SG_entry', None, None),
                                            'STATUS_CODE': ('pdb_entry_tmp', 'status_code', None, None),
                                            'STATUS_CODE_CS': ('pdb_entry_tmp', 'status_code_cs', None, None),
                                            'STATUS_CODE_MR': ('pdb_entry_tmp', 'status_code_mr', None, None),
                                            'STATUS_CODE_SF': ('pdb_entry_tmp', 'status_code_sf', None, None),
                                            'STRUCTURE_ID': ('pdb_entry_tmp', 'structure_id', None, None),
                                            'SUPPRESSED_TITLE_Y_N': ('pdb_entry_tmp',
                                                                     'suppressed_title_Y_N',
                                                                     None,
                                                                     None),
                                            'TITLE': ('pdb_entry_tmp', 'title', None, None),
                                            'TITLEUC': ('pdb_entry_tmp', 'titleUC', None, None)},
                          'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'PDB_ID'), 'TYPE': 'UNIQUE'}},
                          'MAP_MERGE_INDICES': {'pdb_entry_tmp': {'ATTRIBUTES': ('STRUCTURE_ID', 'PDB_ID'),
                                                                  'TYPE': 'EQUI-JOIN'}},
                          'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                          'TABLE_ID': 'PDB_ENTRY_TMP',
                          'TABLE_NAME': 'pdb_entry_tmp',
                          'TABLE_TYPE': 'transactional'},
        'REFINE': {'ATTRIBUTES': {'ANISO_B_1_1': 'aniso_B_1_1',
                                  'ANISO_B_1_2': 'aniso_B_1_2',
                                  'ANISO_B_1_3': 'aniso_B_1_3',
                                  'ANISO_B_2_2': 'aniso_B_2_2',
                                  'ANISO_B_2_3': 'aniso_B_2_3',
                                  'ANISO_B_3_3': 'aniso_B_3_3',
                                  'B_ISO_MAX': 'B_iso_max',
                                  'B_ISO_MEAN': 'B_iso_mean',
                                  'B_ISO_MIN': 'B_iso_min',
                                  'CORRELATION_COEFF_FO_TO_FC': 'correlation_coeff_Fo_to_Fc',
                                  'CORRELATION_COEFF_FO_TO_FC_FREE': 'correlation_coeff_Fo_to_Fc_free',
                                  'DETAILS': 'details',
                                  'DIFF_DENSITY_MAX': 'diff_density_max',
                                  'DIFF_DENSITY_MAX_ESD': 'diff_density_max_esd',
                                  'DIFF_DENSITY_MIN': 'diff_density_min',
                                  'DIFF_DENSITY_MIN_ESD': 'diff_density_min_esd',
                                  'DIFF_DENSITY_RMS': 'diff_density_rms',
                                  'DIFF_DENSITY_RMS_ESD': 'diff_density_rms_esd',
                                  'ENTRY_ID': 'entry_id',
                                  'LS_ABS_STRUCTURE_DETAILS': 'ls_abs_structure_details',
                                  'LS_ABS_STRUCTURE_FLACK': 'ls_abs_structure_Flack',
                                  'LS_ABS_STRUCTURE_FLACK_ESD': 'ls_abs_structure_Flack_esd',
                                  'LS_ABS_STRUCTURE_ROGERS': 'ls_abs_structure_Rogers',
                                  'LS_ABS_STRUCTURE_ROGERS_ESD': 'ls_abs_structure_Rogers_esd',
                                  'LS_D_RES_HIGH': 'ls_d_res_high',
                                  'LS_D_RES_LOW': 'ls_d_res_low',
                                  'LS_EXTINCTION_COEF': 'ls_extinction_coef',
                                  'LS_EXTINCTION_COEF_ESD': 'ls_extinction_coef_esd',
                                  'LS_EXTINCTION_EXPRESSION': 'ls_extinction_expression',
                                  'LS_EXTINCTION_METHOD': 'ls_extinction_method',
                                  'LS_GOODNESS_OF_FIT_ALL': 'ls_goodness_of_fit_all',
                                  'LS_GOODNESS_OF_FIT_ALL_ESD': 'ls_goodness_of_fit_all_esd',
                                  'LS_GOODNESS_OF_FIT_GT': 'ls_goodness_of_fit_gt',
                                  'LS_GOODNESS_OF_FIT_OBS': 'ls_goodness_of_fit_obs',
                                  'LS_GOODNESS_OF_FIT_OBS_ESD': 'ls_goodness_of_fit_obs_esd',
                                  'LS_GOODNESS_OF_FIT_REF': 'ls_goodness_of_fit_ref',
                                  'LS_HYDROGEN_TREATMENT': 'ls_hydrogen_treatment',
                                  'LS_MATRIX_TYPE': 'ls_matrix_type',
                                  'LS_NUMBER_CONSTRAINTS': 'ls_number_constraints',
                                  'LS_NUMBER_PARAMETERS': 'ls_number_parameters',
                                  'LS_NUMBER_REFLNS_ALL': 'ls_number_reflns_all',
                                  'LS_NUMBER_REFLNS_OBS': 'ls_number_reflns_obs',
                                  'LS_NUMBER_REFLNS_R_FREE': 'ls_number_reflns_R_free',
                                  'LS_NUMBER_REFLNS_R_WORK': 'ls_number_reflns_R_work',
                                  'LS_NUMBER_RESTRAINTS': 'ls_number_restraints',
                                  'LS_PERCENT_REFLNS_OBS': 'ls_percent_reflns_obs',
                                  'LS_PERCENT_REFLNS_R_FREE': 'ls_percent_reflns_R_free',
                                  'LS_REDUNDANCY_REFLNS_ALL': 'ls_redundancy_reflns_all',
                                  'LS_REDUNDANCY_REFLNS_OBS': 'ls_redundancy_reflns_obs',
                                  'LS_RESTRAINED_S_ALL': 'ls_restrained_S_all',
                                  'LS_RESTRAINED_S_OBS': 'ls_restrained_S_obs',
                                  'LS_R_FACTOR_ALL': 'ls_R_factor_all',
                                  'LS_R_FACTOR_GT': 'ls_R_factor_gt',
                                  'LS_R_FACTOR_OBS': 'ls_R_factor_obs',
                                  'LS_R_FACTOR_R_FREE': 'ls_R_factor_R_free',
                                  'LS_R_FACTOR_R_FREE_ERROR': 'ls_R_factor_R_free_error',
                                  'LS_R_FACTOR_R_FREE_ERROR_DETAILS': 'ls_R_factor_R_free_error_details',
                                  'LS_R_FACTOR_R_WORK': 'ls_R_factor_R_work',
                                  'LS_R_FSQD_FACTOR_OBS': 'ls_R_Fsqd_factor_obs',
                                  'LS_R_I_FACTOR_OBS': 'ls_R_I_factor_obs',
                                  'LS_SHIFT_OVER_ESD_MAX': 'ls_shift_over_esd_max',
                                  'LS_SHIFT_OVER_ESD_MEAN': 'ls_shift_over_esd_mean',
                                  'LS_SHIFT_OVER_SU_MAX': 'ls_shift_over_su_max',
                                  'LS_SHIFT_OVER_SU_MAX_LT': 'ls_shift_over_su_max_lt',
                                  'LS_SHIFT_OVER_SU_MEAN': 'ls_shift_over_su_mean',
                                  'LS_SHIFT_OVER_SU_MEAN_LT': 'ls_shift_over_su_mean_lt',
                                  'LS_STRUCTURE_FACTOR_COEF': 'ls_structure_factor_coef',
                                  'LS_WEIGHTING_DETAILS': 'ls_weighting_details',
                                  'LS_WEIGHTING_SCHEME': 'ls_weighting_scheme',
                                  'LS_WR_FACTOR_ALL': 'ls_wR_factor_all',
                                  'LS_WR_FACTOR_OBS': 'ls_wR_factor_obs',
                                  'LS_WR_FACTOR_R_FREE': 'ls_wR_factor_R_free',
                                  'LS_WR_FACTOR_R_WORK': 'ls_wR_factor_R_work',
                                  'OCCUPANCY_MAX': 'occupancy_max',
                                  'OCCUPANCY_MIN': 'occupancy_min',
                                  'OVERALL_FOM_FREE_R_SET': 'overall_FOM_free_R_set',
                                  'OVERALL_FOM_WORK_R_SET': 'overall_FOM_work_R_set',
                                  'OVERALL_SU_B': 'overall_SU_B',
                                  'OVERALL_SU_ML': 'overall_SU_ML',
                                  'OVERALL_SU_R_CRUICKSHANK_DPI': 'overall_SU_R_Cruickshank_DPI',
                                  'OVERALL_SU_R_FREE': 'overall_SU_R_free',
                                  'PDBX_DATA_CUTOFF_HIGH_ABSF': 'pdbx_data_cutoff_high_absF',
                                  'PDBX_DATA_CUTOFF_HIGH_RMS_ABSF': 'pdbx_data_cutoff_high_rms_absF',
                                  'PDBX_DATA_CUTOFF_LOW_ABSF': 'pdbx_data_cutoff_low_absF',
                                  'PDBX_DENSITY_CORRELATION': 'pdbx_density_correlation',
                                  'PDBX_DIFFRN_ID': 'pdbx_diffrn_id',
                                  'PDBX_ISOTROPIC_THERMAL_MODEL': 'pdbx_isotropic_thermal_model',
                                  'PDBX_LS_CROSS_VALID_METHOD': 'pdbx_ls_cross_valid_method',
                                  'PDBX_LS_SIGMA_F': 'pdbx_ls_sigma_F',
                                  'PDBX_LS_SIGMA_FSQD': 'pdbx_ls_sigma_Fsqd',
                                  'PDBX_LS_SIGMA_I': 'pdbx_ls_sigma_I',
                                  'PDBX_METHOD_TO_DETERMINE_STRUCT': 'pdbx_method_to_determine_struct',
                                  'PDBX_OVERALL_ESU_R': 'pdbx_overall_ESU_R',
                                  'PDBX_OVERALL_ESU_R_FREE': 'pdbx_overall_ESU_R_Free',
                                  'PDBX_OVERALL_PHASE_ERROR': 'pdbx_overall_phase_error',
                                  'PDBX_OVERALL_SU_R_BLOW_DPI': 'pdbx_overall_SU_R_Blow_DPI',
                                  'PDBX_OVERALL_SU_R_FREE_BLOW_DPI': 'pdbx_overall_SU_R_free_Blow_DPI',
                                  'PDBX_OVERALL_SU_R_FREE_CRUICKSHANK_DPI': 'pdbx_overall_SU_R_free_Cruickshank_DPI',
                                  'PDBX_PD_FSQRD_R_FACTOR': 'pdbx_pd_Fsqrd_R_factor',
                                  'PDBX_PD_LS_MATRIX_BAND_WIDTH': 'pdbx_pd_ls_matrix_band_width',
                                  'PDBX_PD_MARQUARDT_CORRELATION_COEFF': 'pdbx_pd_Marquardt_correlation_coeff',
                                  'PDBX_PD_MEAS_NUMBER_OF_POINTS': 'pdbx_pd_meas_number_of_points',
                                  'PDBX_PD_NUMBER_OF_POINTS': 'pdbx_pd_number_of_points',
                                  'PDBX_PD_NUMBER_OF_POWDER_PATTERNS': 'pdbx_pd_number_of_powder_patterns',
                                  'PDBX_PD_PROC_LS_PROF_R_FACTOR': 'pdbx_pd_proc_ls_prof_R_factor',
                                  'PDBX_PD_PROC_LS_PROF_WR_FACTOR': 'pdbx_pd_proc_ls_prof_wR_factor',
                                  'PDBX_REAL_SPACE_R': 'pdbx_real_space_R',
                                  'PDBX_REFINE_ID': 'pdbx_refine_id',
                                  'PDBX_R_FREE_SELECTION_DETAILS': 'pdbx_R_Free_selection_details',
                                  'PDBX_SOLVENT_ION_PROBE_RADII': 'pdbx_solvent_ion_probe_radii',
                                  'PDBX_SOLVENT_SHRINKAGE_RADII': 'pdbx_solvent_shrinkage_radii',
                                  'PDBX_SOLVENT_VDW_PROBE_RADII': 'pdbx_solvent_vdw_probe_radii',
                                  'PDBX_STARTING_MODEL': 'pdbx_starting_model',
                                  'PDBX_STEREOCHEMISTRY_TARGET_VALUES': 'pdbx_stereochemistry_target_values',
                                  'PDBX_STEREOCHEM_TARGET_VAL_SPEC_CASE': 'pdbx_stereochem_target_val_spec_case',
                                  'PDBX_TLS_RESIDUAL_ADP_FLAG': 'pdbx_TLS_residual_ADP_flag',
                                  'SOLVENT_MODEL_DETAILS': 'solvent_model_details',
                                  'SOLVENT_MODEL_PARAM_BSOL': 'solvent_model_param_bsol',
                                  'SOLVENT_MODEL_PARAM_KSOL': 'solvent_model_param_ksol',
                                  'STRUCTURE_ID': 'Structure_ID'},
                   'ATTRIBUTE_INFO': {'ANISO_B_1_1': {'NULLABLE': True,
                                                      'ORDER': 3,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'FLOAT',
                                                      'WIDTH': 10},
                                      'ANISO_B_1_2': {'NULLABLE': True,
                                                      'ORDER': 4,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'FLOAT',
                                                      'WIDTH': 10},
                                      'ANISO_B_1_3': {'NULLABLE': True,
                                                      'ORDER': 5,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'FLOAT',
                                                      'WIDTH': 10},
                                      'ANISO_B_2_2': {'NULLABLE': True,
                                                      'ORDER': 6,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'FLOAT',
                                                      'WIDTH': 10},
                                      'ANISO_B_2_3': {'NULLABLE': True,
                                                      'ORDER': 7,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'FLOAT',
                                                      'WIDTH': 10},
                                      'ANISO_B_3_3': {'NULLABLE': True,
                                                      'ORDER': 8,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'FLOAT',
                                                      'WIDTH': 10},
                                      'B_ISO_MAX': {'NULLABLE': True,
                                                    'ORDER': 9,
                                                    'PRECISION': 0,
                                                    'PRIMARY_KEY': False,
                                                    'SQL_TYPE': 'FLOAT',
                                                    'WIDTH': 10},
                                      'B_ISO_MEAN': {'NULLABLE': True,
                                                     'ORDER': 10,
                                                     'PRECISION': 0,
                                                     'PRIMARY_KEY': False,
                                                     'SQL_TYPE': 'FLOAT',
                                                     'WIDTH': 10},
                                      'B_ISO_MIN': {'NULLABLE': True,
                                                    'ORDER': 11,
                                                    'PRECISION': 0,
                                                    'PRIMARY_KEY': False,
                                                    'SQL_TYPE': 'FLOAT',
                                                    'WIDTH': 10},
                                      'CORRELATION_COEFF_FO_TO_FC': {'NULLABLE': True,
                                                                     'ORDER': 12,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'FLOAT',
                                                                     'WIDTH': 10},
                                      'CORRELATION_COEFF_FO_TO_FC_FREE': {'NULLABLE': True,
                                                                          'ORDER': 13,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'FLOAT',
                                                                          'WIDTH': 10},
                                      'DETAILS': {'NULLABLE': True,
                                                  'ORDER': 14,
                                                  'PRECISION': 0,
                                                  'PRIMARY_KEY': False,
                                                  'SQL_TYPE': 'TEXT',
                                                  'WIDTH': 10},
                                      'DIFF_DENSITY_MAX': {'NULLABLE': True,
                                                           'ORDER': 15,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'FLOAT',
                                                           'WIDTH': 10},
                                      'DIFF_DENSITY_MAX_ESD': {'NULLABLE': True,
                                                               'ORDER': 16,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                      'DIFF_DENSITY_MIN': {'NULLABLE': True,
                                                           'ORDER': 17,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'FLOAT',
                                                           'WIDTH': 10},
                                      'DIFF_DENSITY_MIN_ESD': {'NULLABLE': True,
                                                               'ORDER': 18,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                      'DIFF_DENSITY_RMS': {'NULLABLE': True,
                                                           'ORDER': 19,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'FLOAT',
                                                           'WIDTH': 10},
                                      'DIFF_DENSITY_RMS_ESD': {'NULLABLE': True,
                                                               'ORDER': 20,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                      'ENTRY_ID': {'NULLABLE': False,
                                                   'ORDER': 2,
                                                   'PRECISION': 0,
                                                   'PRIMARY_KEY': True,
                                                   'SQL_TYPE': 'VARCHAR',
                                                   'WIDTH': '10'},
                                      'LS_ABS_STRUCTURE_DETAILS': {'NULLABLE': True,
                                                                   'ORDER': 22,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': '200'},
                                      'LS_ABS_STRUCTURE_FLACK': {'NULLABLE': True,
                                                                 'ORDER': 23,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                      'LS_ABS_STRUCTURE_FLACK_ESD': {'NULLABLE': True,
                                                                     'ORDER': 24,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'FLOAT',
                                                                     'WIDTH': 10},
                                      'LS_ABS_STRUCTURE_ROGERS': {'NULLABLE': True,
                                                                  'ORDER': 25,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'FLOAT',
                                                                  'WIDTH': 10},
                                      'LS_ABS_STRUCTURE_ROGERS_ESD': {'NULLABLE': True,
                                                                      'ORDER': 26,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'FLOAT',
                                                                      'WIDTH': 10},
                                      'LS_D_RES_HIGH': {'NULLABLE': True,
                                                        'ORDER': 27,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'FLOAT',
                                                        'WIDTH': 10},
                                      'LS_D_RES_LOW': {'NULLABLE': True,
                                                       'ORDER': 28,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': False,
                                                       'SQL_TYPE': 'FLOAT',
                                                       'WIDTH': 10},
                                      'LS_EXTINCTION_COEF': {'NULLABLE': True,
                                                             'ORDER': 29,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                      'LS_EXTINCTION_COEF_ESD': {'NULLABLE': True,
                                                                 'ORDER': 30,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                      'LS_EXTINCTION_EXPRESSION': {'NULLABLE': True,
                                                                   'ORDER': 31,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': '200'},
                                      'LS_EXTINCTION_METHOD': {'NULLABLE': True,
                                                               'ORDER': 32,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': '200'},
                                      'LS_GOODNESS_OF_FIT_ALL': {'NULLABLE': True,
                                                                 'ORDER': 33,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                      'LS_GOODNESS_OF_FIT_ALL_ESD': {'NULLABLE': True,
                                                                     'ORDER': 34,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'FLOAT',
                                                                     'WIDTH': 10},
                                      'LS_GOODNESS_OF_FIT_GT': {'NULLABLE': True,
                                                                'ORDER': 81,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                      'LS_GOODNESS_OF_FIT_OBS': {'NULLABLE': True,
                                                                 'ORDER': 35,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                      'LS_GOODNESS_OF_FIT_OBS_ESD': {'NULLABLE': True,
                                                                     'ORDER': 36,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'FLOAT',
                                                                     'WIDTH': 10},
                                      'LS_GOODNESS_OF_FIT_REF': {'NULLABLE': True,
                                                                 'ORDER': 82,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                      'LS_HYDROGEN_TREATMENT': {'NULLABLE': True,
                                                                'ORDER': 37,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': '10'},
                                      'LS_MATRIX_TYPE': {'NULLABLE': True,
                                                         'ORDER': 38,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': '10'},
                                      'LS_NUMBER_CONSTRAINTS': {'NULLABLE': True,
                                                                'ORDER': 39,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'INT',
                                                                'WIDTH': '11'},
                                      'LS_NUMBER_PARAMETERS': {'NULLABLE': True,
                                                               'ORDER': 40,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'INT',
                                                               'WIDTH': '11'},
                                      'LS_NUMBER_REFLNS_ALL': {'NULLABLE': True,
                                                               'ORDER': 41,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'INT',
                                                               'WIDTH': '11'},
                                      'LS_NUMBER_REFLNS_OBS': {'NULLABLE': True,
                                                               'ORDER': 42,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'INT',
                                                               'WIDTH': '11'},
                                      'LS_NUMBER_REFLNS_R_FREE': {'NULLABLE': True,
                                                                  'ORDER': 43,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'INT',
                                                                  'WIDTH': '11'},
                                      'LS_NUMBER_REFLNS_R_WORK': {'NULLABLE': True,
                                                                  'ORDER': 44,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'INT',
                                                                  'WIDTH': '11'},
                                      'LS_NUMBER_RESTRAINTS': {'NULLABLE': True,
                                                               'ORDER': 45,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'INT',
                                                               'WIDTH': '11'},
                                      'LS_PERCENT_REFLNS_OBS': {'NULLABLE': True,
                                                                'ORDER': 46,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                      'LS_PERCENT_REFLNS_R_FREE': {'NULLABLE': True,
                                                                   'ORDER': 47,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                      'LS_REDUNDANCY_REFLNS_ALL': {'NULLABLE': True,
                                                                   'ORDER': 56,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                      'LS_REDUNDANCY_REFLNS_OBS': {'NULLABLE': True,
                                                                   'ORDER': 57,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                      'LS_RESTRAINED_S_ALL': {'NULLABLE': True,
                                                              'ORDER': 58,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'FLOAT',
                                                              'WIDTH': 10},
                                      'LS_RESTRAINED_S_OBS': {'NULLABLE': True,
                                                              'ORDER': 59,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'FLOAT',
                                                              'WIDTH': 10},
                                      'LS_R_FACTOR_ALL': {'NULLABLE': True,
                                                          'ORDER': 48,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'FLOAT',
                                                          'WIDTH': 10},
                                      'LS_R_FACTOR_GT': {'NULLABLE': True,
                                                         'ORDER': 80,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                      'LS_R_FACTOR_OBS': {'NULLABLE': True,
                                                          'ORDER': 49,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'FLOAT',
                                                          'WIDTH': 10},
                                      'LS_R_FACTOR_R_FREE': {'NULLABLE': True,
                                                             'ORDER': 50,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                      'LS_R_FACTOR_R_FREE_ERROR': {'NULLABLE': True,
                                                                   'ORDER': 51,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                      'LS_R_FACTOR_R_FREE_ERROR_DETAILS': {'NULLABLE': True,
                                                                           'ORDER': 52,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'VARCHAR',
                                                                           'WIDTH': '200'},
                                      'LS_R_FACTOR_R_WORK': {'NULLABLE': True,
                                                             'ORDER': 53,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                      'LS_R_FSQD_FACTOR_OBS': {'NULLABLE': True,
                                                               'ORDER': 54,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                      'LS_R_I_FACTOR_OBS': {'NULLABLE': True,
                                                            'ORDER': 55,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'FLOAT',
                                                            'WIDTH': 10},
                                      'LS_SHIFT_OVER_ESD_MAX': {'NULLABLE': True,
                                                                'ORDER': 60,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                      'LS_SHIFT_OVER_ESD_MEAN': {'NULLABLE': True,
                                                                 'ORDER': 61,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                      'LS_SHIFT_OVER_SU_MAX': {'NULLABLE': True,
                                                               'ORDER': 83,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                      'LS_SHIFT_OVER_SU_MAX_LT': {'NULLABLE': True,
                                                                  'ORDER': 84,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'FLOAT',
                                                                  'WIDTH': 10},
                                      'LS_SHIFT_OVER_SU_MEAN': {'NULLABLE': True,
                                                                'ORDER': 85,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                      'LS_SHIFT_OVER_SU_MEAN_LT': {'NULLABLE': True,
                                                                   'ORDER': 86,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                      'LS_STRUCTURE_FACTOR_COEF': {'NULLABLE': True,
                                                                   'ORDER': 62,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': '10'},
                                      'LS_WEIGHTING_DETAILS': {'NULLABLE': True,
                                                               'ORDER': 63,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': '200'},
                                      'LS_WEIGHTING_SCHEME': {'NULLABLE': True,
                                                              'ORDER': 64,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': '10'},
                                      'LS_WR_FACTOR_ALL': {'NULLABLE': True,
                                                           'ORDER': 65,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'FLOAT',
                                                           'WIDTH': 10},
                                      'LS_WR_FACTOR_OBS': {'NULLABLE': True,
                                                           'ORDER': 66,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'FLOAT',
                                                           'WIDTH': 10},
                                      'LS_WR_FACTOR_R_FREE': {'NULLABLE': True,
                                                              'ORDER': 67,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'FLOAT',
                                                              'WIDTH': 10},
                                      'LS_WR_FACTOR_R_WORK': {'NULLABLE': True,
                                                              'ORDER': 68,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'FLOAT',
                                                              'WIDTH': 10},
                                      'OCCUPANCY_MAX': {'NULLABLE': True,
                                                        'ORDER': 69,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'FLOAT',
                                                        'WIDTH': 10},
                                      'OCCUPANCY_MIN': {'NULLABLE': True,
                                                        'ORDER': 70,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'FLOAT',
                                                        'WIDTH': 10},
                                      'OVERALL_FOM_FREE_R_SET': {'NULLABLE': True,
                                                                 'ORDER': 75,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                      'OVERALL_FOM_WORK_R_SET': {'NULLABLE': True,
                                                                 'ORDER': 76,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                      'OVERALL_SU_B': {'NULLABLE': True,
                                                       'ORDER': 71,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': False,
                                                       'SQL_TYPE': 'FLOAT',
                                                       'WIDTH': 10},
                                      'OVERALL_SU_ML': {'NULLABLE': True,
                                                        'ORDER': 72,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'FLOAT',
                                                        'WIDTH': 10},
                                      'OVERALL_SU_R_CRUICKSHANK_DPI': {'NULLABLE': True,
                                                                       'ORDER': 73,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'FLOAT',
                                                                       'WIDTH': 10},
                                      'OVERALL_SU_R_FREE': {'NULLABLE': True,
                                                            'ORDER': 74,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'FLOAT',
                                                            'WIDTH': 10},
                                      'PDBX_DATA_CUTOFF_HIGH_ABSF': {'NULLABLE': True,
                                                                     'ORDER': 90,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'FLOAT',
                                                                     'WIDTH': 10},
                                      'PDBX_DATA_CUTOFF_HIGH_RMS_ABSF': {'NULLABLE': True,
                                                                         'ORDER': 91,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'FLOAT',
                                                                         'WIDTH': 10},
                                      'PDBX_DATA_CUTOFF_LOW_ABSF': {'NULLABLE': True,
                                                                    'ORDER': 92,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'FLOAT',
                                                                    'WIDTH': 10},
                                      'PDBX_DENSITY_CORRELATION': {'NULLABLE': True,
                                                                   'ORDER': 106,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                      'PDBX_DIFFRN_ID': {'NULLABLE': True,
                                                         'ORDER': 120,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': '10'},
                                      'PDBX_ISOTROPIC_THERMAL_MODEL': {'NULLABLE': True,
                                                                       'ORDER': 93,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': '200'},
                                      'PDBX_LS_CROSS_VALID_METHOD': {'NULLABLE': True,
                                                                     'ORDER': 94,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': '550'},
                                      'PDBX_LS_SIGMA_F': {'NULLABLE': True,
                                                          'ORDER': 88,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'FLOAT',
                                                          'WIDTH': 10},
                                      'PDBX_LS_SIGMA_FSQD': {'NULLABLE': True,
                                                             'ORDER': 89,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                      'PDBX_LS_SIGMA_I': {'NULLABLE': True,
                                                          'ORDER': 87,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'FLOAT',
                                                          'WIDTH': 10},
                                      'PDBX_METHOD_TO_DETERMINE_STRUCT': {'NULLABLE': True,
                                                                          'ORDER': 95,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': '550'},
                                      'PDBX_OVERALL_ESU_R': {'NULLABLE': True,
                                                             'ORDER': 100,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                      'PDBX_OVERALL_ESU_R_FREE': {'NULLABLE': True,
                                                                  'ORDER': 101,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'FLOAT',
                                                                  'WIDTH': 10},
                                      'PDBX_OVERALL_PHASE_ERROR': {'NULLABLE': True,
                                                                   'ORDER': 115,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                      'PDBX_OVERALL_SU_R_BLOW_DPI': {'NULLABLE': True,
                                                                     'ORDER': 118,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'FLOAT',
                                                                     'WIDTH': 10},
                                      'PDBX_OVERALL_SU_R_FREE_BLOW_DPI': {'NULLABLE': True,
                                                                          'ORDER': 117,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'FLOAT',
                                                                          'WIDTH': 10},
                                      'PDBX_OVERALL_SU_R_FREE_CRUICKSHANK_DPI': {'NULLABLE': True,
                                                                                 'ORDER': 116,
                                                                                 'PRECISION': 0,
                                                                                 'PRIMARY_KEY': False,
                                                                                 'SQL_TYPE': 'FLOAT',
                                                                                 'WIDTH': 10},
                                      'PDBX_PD_FSQRD_R_FACTOR': {'NULLABLE': True,
                                                                 'ORDER': 113,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                      'PDBX_PD_LS_MATRIX_BAND_WIDTH': {'NULLABLE': True,
                                                                       'ORDER': 114,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'INT',
                                                                       'WIDTH': '11'},
                                      'PDBX_PD_MARQUARDT_CORRELATION_COEFF': {'NULLABLE': True,
                                                                              'ORDER': 112,
                                                                              'PRECISION': 0,
                                                                              'PRIMARY_KEY': False,
                                                                              'SQL_TYPE': 'FLOAT',
                                                                              'WIDTH': 10},
                                      'PDBX_PD_MEAS_NUMBER_OF_POINTS': {'NULLABLE': True,
                                                                        'ORDER': 109,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'INT',
                                                                        'WIDTH': '11'},
                                      'PDBX_PD_NUMBER_OF_POINTS': {'NULLABLE': True,
                                                                   'ORDER': 108,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'INT',
                                                                   'WIDTH': '11'},
                                      'PDBX_PD_NUMBER_OF_POWDER_PATTERNS': {'NULLABLE': True,
                                                                            'ORDER': 107,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'INT',
                                                                            'WIDTH': '11'},
                                      'PDBX_PD_PROC_LS_PROF_R_FACTOR': {'NULLABLE': True,
                                                                        'ORDER': 110,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'FLOAT',
                                                                        'WIDTH': 10},
                                      'PDBX_PD_PROC_LS_PROF_WR_FACTOR': {'NULLABLE': True,
                                                                         'ORDER': 111,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'FLOAT',
                                                                         'WIDTH': 10},
                                      'PDBX_REAL_SPACE_R': {'NULLABLE': True,
                                                            'ORDER': 105,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'FLOAT',
                                                            'WIDTH': 10},
                                      'PDBX_REFINE_ID': {'NULLABLE': False,
                                                         'ORDER': 21,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': True,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': '80'},
                                      'PDBX_R_FREE_SELECTION_DETAILS': {'NULLABLE': True,
                                                                        'ORDER': 98,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': '550'},
                                      'PDBX_SOLVENT_ION_PROBE_RADII': {'NULLABLE': True,
                                                                       'ORDER': 103,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'FLOAT',
                                                                       'WIDTH': 10},
                                      'PDBX_SOLVENT_SHRINKAGE_RADII': {'NULLABLE': True,
                                                                       'ORDER': 104,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'FLOAT',
                                                                       'WIDTH': 10},
                                      'PDBX_SOLVENT_VDW_PROBE_RADII': {'NULLABLE': True,
                                                                       'ORDER': 102,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'FLOAT',
                                                                       'WIDTH': 10},
                                      'PDBX_STARTING_MODEL': {'NULLABLE': True,
                                                              'ORDER': 96,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': '550'},
                                      'PDBX_STEREOCHEMISTRY_TARGET_VALUES': {'NULLABLE': True,
                                                                             'ORDER': 97,
                                                                             'PRECISION': 0,
                                                                             'PRIMARY_KEY': False,
                                                                             'SQL_TYPE': 'VARCHAR',
                                                                             'WIDTH': '550'},
                                      'PDBX_STEREOCHEM_TARGET_VAL_SPEC_CASE': {'NULLABLE': True,
                                                                               'ORDER': 99,
                                                                               'PRECISION': 0,
                                                                               'PRIMARY_KEY': False,
                                                                               'SQL_TYPE': 'VARCHAR',
                                                                               'WIDTH': '550'},
                                      'PDBX_TLS_RESIDUAL_ADP_FLAG': {'NULLABLE': True,
                                                                     'ORDER': 119,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': '80'},
                                      'SOLVENT_MODEL_DETAILS': {'NULLABLE': True,
                                                                'ORDER': 77,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': '550'},
                                      'SOLVENT_MODEL_PARAM_BSOL': {'NULLABLE': True,
                                                                   'ORDER': 78,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                      'SOLVENT_MODEL_PARAM_KSOL': {'NULLABLE': True,
                                                                   'ORDER': 79,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                      'STRUCTURE_ID': {'NULLABLE': False,
                                                       'ORDER': 1,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': True,
                                                       'SQL_TYPE': 'VARCHAR',
                                                       'WIDTH': '10'}},
                   'ATTRIBUTE_MAP': {'ANISO_B_1_1': ('refine', 'aniso_B_1_1', None, None),
                                     'ANISO_B_1_2': ('refine', 'aniso_B_1_2', None, None),
                                     'ANISO_B_1_3': ('refine', 'aniso_B_1_3', None, None),
                                     'ANISO_B_2_2': ('refine', 'aniso_B_2_2', None, None),
                                     'ANISO_B_2_3': ('refine', 'aniso_B_2_3', None, None),
                                     'ANISO_B_3_3': ('refine', 'aniso_B_3_3', None, None),
                                     'B_ISO_MAX': ('refine', 'B_iso_max', None, None),
                                     'B_ISO_MEAN': ('refine', 'B_iso_mean', None, None),
                                     'B_ISO_MIN': ('refine', 'B_iso_min', None, None),
                                     'CORRELATION_COEFF_FO_TO_FC': ('refine',
                                                                    'correlation_coeff_Fo_to_Fc',
                                                                    None,
                                                                    None),
                                     'CORRELATION_COEFF_FO_TO_FC_FREE': ('refine',
                                                                         'correlation_coeff_Fo_to_Fc_free',
                                                                         None,
                                                                         None),
                                     'DETAILS': ('refine', 'details', None, None),
                                     'DIFF_DENSITY_MAX': ('refine', 'diff_density_max', None, None),
                                     'DIFF_DENSITY_MAX_ESD': ('refine', 'diff_density_max_esd', None, None),
                                     'DIFF_DENSITY_MIN': ('refine', 'diff_density_min', None, None),
                                     'DIFF_DENSITY_MIN_ESD': ('refine', 'diff_density_min_esd', None, None),
                                     'DIFF_DENSITY_RMS': ('refine', 'diff_density_rms', None, None),
                                     'DIFF_DENSITY_RMS_ESD': ('refine', 'diff_density_rms_esd', None, None),
                                     'ENTRY_ID': ('refine', 'entry_id', None, None),
                                     'LS_ABS_STRUCTURE_DETAILS': ('refine', 'ls_abs_structure_details', None, None),
                                     'LS_ABS_STRUCTURE_FLACK': ('refine', 'ls_abs_structure_Flack', None, None),
                                     'LS_ABS_STRUCTURE_FLACK_ESD': ('refine',
                                                                    'ls_abs_structure_Flack_esd',
                                                                    None,
                                                                    None),
                                     'LS_ABS_STRUCTURE_ROGERS': ('refine', 'ls_abs_structure_Rogers', None, None),
                                     'LS_ABS_STRUCTURE_ROGERS_ESD': ('refine',
                                                                     'ls_abs_structure_Rogers_esd',
                                                                     None,
                                                                     None),
                                     'LS_D_RES_HIGH': ('refine', 'ls_d_res_high', None, None),
                                     'LS_D_RES_LOW': ('refine', 'ls_d_res_low', None, None),
                                     'LS_EXTINCTION_COEF': ('refine', 'ls_extinction_coef', None, None),
                                     'LS_EXTINCTION_COEF_ESD': ('refine', 'ls_extinction_coef_esd', None, None),
                                     'LS_EXTINCTION_EXPRESSION': ('refine', 'ls_extinction_expression', None, None),
                                     'LS_EXTINCTION_METHOD': ('refine', 'ls_extinction_method', None, None),
                                     'LS_GOODNESS_OF_FIT_ALL': ('refine', 'ls_goodness_of_fit_all', None, None),
                                     'LS_GOODNESS_OF_FIT_ALL_ESD': ('refine',
                                                                    'ls_goodness_of_fit_all_esd',
                                                                    None,
                                                                    None),
                                     'LS_GOODNESS_OF_FIT_GT': ('refine', 'ls_goodness_of_fit_gt', None, None),
                                     'LS_GOODNESS_OF_FIT_OBS': ('refine', 'ls_goodness_of_fit_obs', None, None),
                                     'LS_GOODNESS_OF_FIT_OBS_ESD': ('refine',
                                                                    'ls_goodness_of_fit_obs_esd',
                                                                    None,
                                                                    None),
                                     'LS_GOODNESS_OF_FIT_REF': ('refine', 'ls_goodness_of_fit_ref', None, None),
                                     'LS_HYDROGEN_TREATMENT': ('refine', 'ls_hydrogen_treatment', None, None),
                                     'LS_MATRIX_TYPE': ('refine', 'ls_matrix_type', None, None),
                                     'LS_NUMBER_CONSTRAINTS': ('refine', 'ls_number_constraints', None, None),
                                     'LS_NUMBER_PARAMETERS': ('refine', 'ls_number_parameters', None, None),
                                     'LS_NUMBER_REFLNS_ALL': ('refine', 'ls_number_reflns_all', None, None),
                                     'LS_NUMBER_REFLNS_OBS': ('refine', 'ls_number_reflns_obs', None, None),
                                     'LS_NUMBER_REFLNS_R_FREE': ('refine', 'ls_number_reflns_R_free', None, None),
                                     'LS_NUMBER_REFLNS_R_WORK': ('refine', 'ls_number_reflns_R_work', None, None),
                                     'LS_NUMBER_RESTRAINTS': ('refine', 'ls_number_restraints', None, None),
                                     'LS_PERCENT_REFLNS_OBS': ('refine', 'ls_percent_reflns_obs', None, None),
                                     'LS_PERCENT_REFLNS_R_FREE': ('refine', 'ls_percent_reflns_R_free', None, None),
                                     'LS_REDUNDANCY_REFLNS_ALL': ('refine', 'ls_redundancy_reflns_all', None, None),
                                     'LS_REDUNDANCY_REFLNS_OBS': ('refine', 'ls_redundancy_reflns_obs', None, None),
                                     'LS_RESTRAINED_S_ALL': ('refine', 'ls_restrained_S_all', None, None),
                                     'LS_RESTRAINED_S_OBS': ('refine', 'ls_restrained_S_obs', None, None),
                                     'LS_R_FACTOR_ALL': ('refine', 'ls_R_factor_all', None, None),
                                     'LS_R_FACTOR_GT': ('refine', 'ls_R_factor_gt', None, None),
                                     'LS_R_FACTOR_OBS': ('refine', 'ls_R_factor_obs', None, None),
                                     'LS_R_FACTOR_R_FREE': ('refine', 'ls_R_factor_R_free', None, None),
                                     'LS_R_FACTOR_R_FREE_ERROR': ('refine', 'ls_R_factor_R_free_error', None, None),
                                     'LS_R_FACTOR_R_FREE_ERROR_DETAILS': ('refine',
                                                                          'ls_R_factor_R_free_error_details',
                                                                          None,
                                                                          None),
                                     'LS_R_FACTOR_R_WORK': ('refine', 'ls_R_factor_R_work', None, None),
                                     'LS_R_FSQD_FACTOR_OBS': ('refine', 'ls_R_Fsqd_factor_obs', None, None),
                                     'LS_R_I_FACTOR_OBS': ('refine', 'ls_R_I_factor_obs', None, None),
                                     'LS_SHIFT_OVER_ESD_MAX': ('refine', 'ls_shift_over_esd_max', None, None),
                                     'LS_SHIFT_OVER_ESD_MEAN': ('refine', 'ls_shift_over_esd_mean', None, None),
                                     'LS_SHIFT_OVER_SU_MAX': ('refine', 'ls_shift_over_su_max', None, None),
                                     'LS_SHIFT_OVER_SU_MAX_LT': ('refine', 'ls_shift_over_su_max_lt', None, None),
                                     'LS_SHIFT_OVER_SU_MEAN': ('refine', 'ls_shift_over_su_mean', None, None),
                                     'LS_SHIFT_OVER_SU_MEAN_LT': ('refine', 'ls_shift_over_su_mean_lt', None, None),
                                     'LS_STRUCTURE_FACTOR_COEF': ('refine', 'ls_structure_factor_coef', None, None),
                                     'LS_WEIGHTING_DETAILS': ('refine', 'ls_weighting_details', None, None),
                                     'LS_WEIGHTING_SCHEME': ('refine', 'ls_weighting_scheme', None, None),
                                     'LS_WR_FACTOR_ALL': ('refine', 'ls_wR_factor_all', None, None),
                                     'LS_WR_FACTOR_OBS': ('refine', 'ls_wR_factor_obs', None, None),
                                     'LS_WR_FACTOR_R_FREE': ('refine', 'ls_wR_factor_R_free', None, None),
                                     'LS_WR_FACTOR_R_WORK': ('refine', 'ls_wR_factor_R_work', None, None),
                                     'OCCUPANCY_MAX': ('refine', 'occupancy_max', None, None),
                                     'OCCUPANCY_MIN': ('refine', 'occupancy_min', None, None),
                                     'OVERALL_FOM_FREE_R_SET': ('refine', 'overall_FOM_free_R_set', None, None),
                                     'OVERALL_FOM_WORK_R_SET': ('refine', 'overall_FOM_work_R_set', None, None),
                                     'OVERALL_SU_B': ('refine', 'overall_SU_B', None, None),
                                     'OVERALL_SU_ML': ('refine', 'overall_SU_ML', None, None),
                                     'OVERALL_SU_R_CRUICKSHANK_DPI': ('refine',
                                                                      'overall_SU_R_Cruickshank_DPI',
                                                                      None,
                                                                      None),
                                     'OVERALL_SU_R_FREE': ('refine', 'overall_SU_R_free', None, None),
                                     'PDBX_DATA_CUTOFF_HIGH_ABSF': ('refine',
                                                                    'pdbx_data_cutoff_high_absF',
                                                                    None,
                                                                    None),
                                     'PDBX_DATA_CUTOFF_HIGH_RMS_ABSF': ('refine',
                                                                        'pdbx_data_cutoff_high_rms_absF',
                                                                        None,
                                                                        None),
                                     'PDBX_DATA_CUTOFF_LOW_ABSF': ('refine', 'pdbx_data_cutoff_low_absF', None, None),
                                     'PDBX_DENSITY_CORRELATION': ('refine', 'pdbx_density_correlation', None, None),
                                     'PDBX_DIFFRN_ID': ('refine', 'pdbx_diffrn_id', None, None),
                                     'PDBX_ISOTROPIC_THERMAL_MODEL': ('refine',
                                                                      'pdbx_isotropic_thermal_model',
                                                                      None,
                                                                      None),
                                     'PDBX_LS_CROSS_VALID_METHOD': ('refine',
                                                                    'pdbx_ls_cross_valid_method',
                                                                    None,
                                                                    None),
                                     'PDBX_LS_SIGMA_F': ('refine', 'pdbx_ls_sigma_F', None, None),
                                     'PDBX_LS_SIGMA_FSQD': ('refine', 'pdbx_ls_sigma_Fsqd', None, None),
                                     'PDBX_LS_SIGMA_I': ('refine', 'pdbx_ls_sigma_I', None, None),
                                     'PDBX_METHOD_TO_DETERMINE_STRUCT': ('refine',
                                                                         'pdbx_method_to_determine_struct',
                                                                         None,
                                                                         None),
                                     'PDBX_OVERALL_ESU_R': ('refine', 'pdbx_overall_ESU_R', None, None),
                                     'PDBX_OVERALL_ESU_R_FREE': ('refine', 'pdbx_overall_ESU_R_Free', None, None),
                                     'PDBX_OVERALL_PHASE_ERROR': ('refine', 'pdbx_overall_phase_error', None, None),
                                     'PDBX_OVERALL_SU_R_BLOW_DPI': ('refine',
                                                                    'pdbx_overall_SU_R_Blow_DPI',
                                                                    None,
                                                                    None),
                                     'PDBX_OVERALL_SU_R_FREE_BLOW_DPI': ('refine',
                                                                         'pdbx_overall_SU_R_free_Blow_DPI',
                                                                         None,
                                                                         None),
                                     'PDBX_OVERALL_SU_R_FREE_CRUICKSHANK_DPI': ('refine',
                                                                                'pdbx_overall_SU_R_free_Cruickshank_DPI',
                                                                                None,
                                                                                None),
                                     'PDBX_PD_FSQRD_R_FACTOR': ('refine', 'pdbx_pd_Fsqrd_R_factor', None, None),
                                     'PDBX_PD_LS_MATRIX_BAND_WIDTH': ('refine',
                                                                      'pdbx_pd_ls_matrix_band_width',
                                                                      None,
                                                                      None),
                                     'PDBX_PD_MARQUARDT_CORRELATION_COEFF': ('refine',
                                                                             'pdbx_pd_Marquardt_correlation_coeff',
                                                                             None,
                                                                             None),
                                     'PDBX_PD_MEAS_NUMBER_OF_POINTS': ('refine',
                                                                       'pdbx_pd_meas_number_of_points',
                                                                       None,
                                                                       None),
                                     'PDBX_PD_NUMBER_OF_POINTS': ('refine', 'pdbx_pd_number_of_points', None, None),
                                     'PDBX_PD_NUMBER_OF_POWDER_PATTERNS': ('refine',
                                                                           'pdbx_pd_number_of_powder_patterns',
                                                                           None,
                                                                           None),
                                     'PDBX_PD_PROC_LS_PROF_R_FACTOR': ('refine',
                                                                       'pdbx_pd_proc_ls_prof_R_factor',
                                                                       None,
                                                                       None),
                                     'PDBX_PD_PROC_LS_PROF_WR_FACTOR': ('refine',
                                                                        'pdbx_pd_proc_ls_prof_wR_factor',
                                                                        None,
                                                                        None),
                                     'PDBX_REAL_SPACE_R': ('refine', 'pdbx_real_space_R', None, None),
                                     'PDBX_REFINE_ID': ('refine', 'pdbx_refine_id', None, None),
                                     'PDBX_R_FREE_SELECTION_DETAILS': ('refine',
                                                                       'pdbx_R_Free_selection_details',
                                                                       None,
                                                                       None),
                                     'PDBX_SOLVENT_ION_PROBE_RADII': ('refine',
                                                                      'pdbx_solvent_ion_probe_radii',
                                                                      None,
                                                                      None),
                                     'PDBX_SOLVENT_SHRINKAGE_RADII': ('refine',
                                                                      'pdbx_solvent_shrinkage_radii',
                                                                      None,
                                                                      None),
                                     'PDBX_SOLVENT_VDW_PROBE_RADII': ('refine',
                                                                      'pdbx_solvent_vdw_probe_radii',
                                                                      None,
                                                                      None),
                                     'PDBX_STARTING_MODEL': ('refine', 'pdbx_starting_model', None, None),
                                     'PDBX_STEREOCHEMISTRY_TARGET_VALUES': ('refine',
                                                                            'pdbx_stereochemistry_target_values',
                                                                            None,
                                                                            None),
                                     'PDBX_STEREOCHEM_TARGET_VAL_SPEC_CASE': ('refine',
                                                                              'pdbx_stereochem_target_val_spec_case',
                                                                              None,
                                                                              None),
                                     'PDBX_TLS_RESIDUAL_ADP_FLAG': ('refine',
                                                                    'pdbx_TLS_residual_ADP_flag',
                                                                    None,
                                                                    None),
                                     'SOLVENT_MODEL_DETAILS': ('refine', 'solvent_model_details', None, None),
                                     'SOLVENT_MODEL_PARAM_BSOL': ('refine', 'solvent_model_param_bsol', None, None),
                                     'SOLVENT_MODEL_PARAM_KSOL': ('refine', 'solvent_model_param_ksol', None, None),
                                     'STRUCTURE_ID': ('refine', 'Structure_ID', None, None)},
                   'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTRY_ID', 'PDBX_REFINE_ID'), 'TYPE': 'UNIQUE'}},
                   'MAP_MERGE_INDICES': {'refine': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTRY_ID', 'PDBX_REFINE_ID'),
                                                    'TYPE': 'EQUI-JOIN'}},
                   'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                   'TABLE_ID': 'REFINE',
                   'TABLE_NAME': 'refine',
                   'TABLE_TYPE': 'transactional'},
        'REFINE_ANALYZE': {'ATTRIBUTES': {'ENTRY_ID': 'entry_id',
                                          'LUZZATI_COORDINATE_ERROR_FREE': 'Luzzati_coordinate_error_free',
                                          'LUZZATI_COORDINATE_ERROR_OBS': 'Luzzati_coordinate_error_obs',
                                          'LUZZATI_D_RES_LOW_FREE': 'Luzzati_d_res_low_free',
                                          'LUZZATI_D_RES_LOW_OBS': 'Luzzati_d_res_low_obs',
                                          'LUZZATI_SIGMA_A_FREE': 'Luzzati_sigma_a_free',
                                          'LUZZATI_SIGMA_A_FREE_DETAILS': 'Luzzati_sigma_a_free_details',
                                          'LUZZATI_SIGMA_A_OBS': 'Luzzati_sigma_a_obs',
                                          'LUZZATI_SIGMA_A_OBS_DETAILS': 'Luzzati_sigma_a_obs_details',
                                          'NUMBER_DISORDERED_RESIDUES': 'number_disordered_residues',
                                          'OCCUPANCY_SUM_HYDROGEN': 'occupancy_sum_hydrogen',
                                          'OCCUPANCY_SUM_NON_HYDROGEN': 'occupancy_sum_non_hydrogen',
                                          'PDBX_LUZZATI_D_RES_HIGH_OBS': 'pdbx_Luzzati_d_res_high_obs',
                                          'PDBX_REFINE_ID': 'pdbx_refine_id',
                                          'RG_D_RES_HIGH': 'RG_d_res_high',
                                          'RG_D_RES_LOW': 'RG_d_res_low',
                                          'RG_FREE': 'RG_free',
                                          'RG_FREE_WORK_RATIO': 'RG_free_work_ratio',
                                          'RG_WORK': 'RG_work',
                                          'STRUCTURE_ID': 'Structure_ID'},
                           'ATTRIBUTE_INFO': {'ENTRY_ID': {'NULLABLE': False,
                                                           'ORDER': 2,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': True,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': '10'},
                                              'LUZZATI_COORDINATE_ERROR_FREE': {'NULLABLE': True,
                                                                                'ORDER': 4,
                                                                                'PRECISION': 0,
                                                                                'PRIMARY_KEY': False,
                                                                                'SQL_TYPE': 'FLOAT',
                                                                                'WIDTH': 10},
                                              'LUZZATI_COORDINATE_ERROR_OBS': {'NULLABLE': True,
                                                                               'ORDER': 5,
                                                                               'PRECISION': 0,
                                                                               'PRIMARY_KEY': False,
                                                                               'SQL_TYPE': 'FLOAT',
                                                                               'WIDTH': 10},
                                              'LUZZATI_D_RES_LOW_FREE': {'NULLABLE': True,
                                                                         'ORDER': 6,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'FLOAT',
                                                                         'WIDTH': 10},
                                              'LUZZATI_D_RES_LOW_OBS': {'NULLABLE': True,
                                                                        'ORDER': 7,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'FLOAT',
                                                                        'WIDTH': 10},
                                              'LUZZATI_SIGMA_A_FREE': {'NULLABLE': True,
                                                                       'ORDER': 8,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'FLOAT',
                                                                       'WIDTH': 10},
                                              'LUZZATI_SIGMA_A_FREE_DETAILS': {'NULLABLE': True,
                                                                               'ORDER': 9,
                                                                               'PRECISION': 0,
                                                                               'PRIMARY_KEY': False,
                                                                               'SQL_TYPE': 'VARCHAR',
                                                                               'WIDTH': '200'},
                                              'LUZZATI_SIGMA_A_OBS': {'NULLABLE': True,
                                                                      'ORDER': 10,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'FLOAT',
                                                                      'WIDTH': 10},
                                              'LUZZATI_SIGMA_A_OBS_DETAILS': {'NULLABLE': True,
                                                                              'ORDER': 11,
                                                                              'PRECISION': 0,
                                                                              'PRIMARY_KEY': False,
                                                                              'SQL_TYPE': 'VARCHAR',
                                                                              'WIDTH': '200'},
                                              'NUMBER_DISORDERED_RESIDUES': {'NULLABLE': True,
                                                                             'ORDER': 12,
                                                                             'PRECISION': 0,
                                                                             'PRIMARY_KEY': False,
                                                                             'SQL_TYPE': 'FLOAT',
                                                                             'WIDTH': 10},
                                              'OCCUPANCY_SUM_HYDROGEN': {'NULLABLE': True,
                                                                         'ORDER': 13,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'FLOAT',
                                                                         'WIDTH': 10},
                                              'OCCUPANCY_SUM_NON_HYDROGEN': {'NULLABLE': True,
                                                                             'ORDER': 14,
                                                                             'PRECISION': 0,
                                                                             'PRIMARY_KEY': False,
                                                                             'SQL_TYPE': 'FLOAT',
                                                                             'WIDTH': 10},
                                              'PDBX_LUZZATI_D_RES_HIGH_OBS': {'NULLABLE': True,
                                                                              'ORDER': 20,
                                                                              'PRECISION': 0,
                                                                              'PRIMARY_KEY': False,
                                                                              'SQL_TYPE': 'FLOAT',
                                                                              'WIDTH': 10},
                                              'PDBX_REFINE_ID': {'NULLABLE': False,
                                                                 'ORDER': 3,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': True,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': '80'},
                                              'RG_D_RES_HIGH': {'NULLABLE': True,
                                                                'ORDER': 15,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                              'RG_D_RES_LOW': {'NULLABLE': True,
                                                               'ORDER': 16,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                              'RG_FREE': {'NULLABLE': True,
                                                          'ORDER': 17,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'FLOAT',
                                                          'WIDTH': 10},
                                              'RG_FREE_WORK_RATIO': {'NULLABLE': True,
                                                                     'ORDER': 19,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'FLOAT',
                                                                     'WIDTH': 10},
                                              'RG_WORK': {'NULLABLE': True,
                                                          'ORDER': 18,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'FLOAT',
                                                          'WIDTH': 10},
                                              'STRUCTURE_ID': {'NULLABLE': False,
                                                               'ORDER': 1,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': '10'}},
                           'ATTRIBUTE_MAP': {'ENTRY_ID': ('refine_analyze', 'entry_id', None, None),
                                             'LUZZATI_COORDINATE_ERROR_FREE': ('refine_analyze',
                                                                               'Luzzati_coordinate_error_free',
                                                                               None,
                                                                               None),
                                             'LUZZATI_COORDINATE_ERROR_OBS': ('refine_analyze',
                                                                              'Luzzati_coordinate_error_obs',
                                                                              None,
                                                                              None),
                                             'LUZZATI_D_RES_LOW_FREE': ('refine_analyze',
                                                                        'Luzzati_d_res_low_free',
                                                                        None,
                                                                        None),
                                             'LUZZATI_D_RES_LOW_OBS': ('refine_analyze',
                                                                       'Luzzati_d_res_low_obs',
                                                                       None,
                                                                       None),
                                             'LUZZATI_SIGMA_A_FREE': ('refine_analyze',
                                                                      'Luzzati_sigma_a_free',
                                                                      None,
                                                                      None),
                                             'LUZZATI_SIGMA_A_FREE_DETAILS': ('refine_analyze',
                                                                              'Luzzati_sigma_a_free_details',
                                                                              None,
                                                                              None),
                                             'LUZZATI_SIGMA_A_OBS': ('refine_analyze',
                                                                     'Luzzati_sigma_a_obs',
                                                                     None,
                                                                     None),
                                             'LUZZATI_SIGMA_A_OBS_DETAILS': ('refine_analyze',
                                                                             'Luzzati_sigma_a_obs_details',
                                                                             None,
                                                                             None),
                                             'NUMBER_DISORDERED_RESIDUES': ('refine_analyze',
                                                                            'number_disordered_residues',
                                                                            None,
                                                                            None),
                                             'OCCUPANCY_SUM_HYDROGEN': ('refine_analyze',
                                                                        'occupancy_sum_hydrogen',
                                                                        None,
                                                                        None),
                                             'OCCUPANCY_SUM_NON_HYDROGEN': ('refine_analyze',
                                                                            'occupancy_sum_non_hydrogen',
                                                                            None,
                                                                            None),
                                             'PDBX_LUZZATI_D_RES_HIGH_OBS': ('refine_analyze',
                                                                             'pdbx_Luzzati_d_res_high_obs',
                                                                             None,
                                                                             None),
                                             'PDBX_REFINE_ID': ('refine_analyze', 'pdbx_refine_id', None, None),
                                             'RG_D_RES_HIGH': ('refine_analyze', 'RG_d_res_high', None, None),
                                             'RG_D_RES_LOW': ('refine_analyze', 'RG_d_res_low', None, None),
                                             'RG_FREE': ('refine_analyze', 'RG_free', None, None),
                                             'RG_FREE_WORK_RATIO': ('refine_analyze',
                                                                    'RG_free_work_ratio',
                                                                    None,
                                                                    None),
                                             'RG_WORK': ('refine_analyze', 'RG_work', None, None),
                                             'STRUCTURE_ID': ('refine_analyze', 'Structure_ID', None, None)},
                           'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTRY_ID', 'PDBX_REFINE_ID'),
                                              'TYPE': 'UNIQUE'}},
                           'MAP_MERGE_INDICES': {'refine_analyze': {'ATTRIBUTES': ('STRUCTURE_ID',
                                                                                   'ENTRY_ID',
                                                                                   'PDBX_REFINE_ID'),
                                                                    'TYPE': 'EQUI-JOIN'}},
                           'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                           'TABLE_ID': 'REFINE_ANALYZE',
                           'TABLE_NAME': 'refine_analyze',
                           'TABLE_TYPE': 'transactional'},
        'REFINE_LS_SHELL': {'ATTRIBUTES': {'D_RES_HIGH': 'd_res_high',
                                           'D_RES_LOW': 'd_res_low',
                                           'NUMBER_REFLNS_ALL': 'number_reflns_all',
                                           'NUMBER_REFLNS_OBS': 'number_reflns_obs',
                                           'NUMBER_REFLNS_R_FREE': 'number_reflns_R_free',
                                           'NUMBER_REFLNS_R_WORK': 'number_reflns_R_work',
                                           'PDBX_TOTAL_NUMBER_OF_BINS_USED': 'pdbx_total_number_of_bins_used',
                                           'PERCENT_REFLNS_OBS': 'percent_reflns_obs',
                                           'PERCENT_REFLNS_R_FREE': 'percent_reflns_R_free',
                                           'R_FACTOR_ALL': 'R_factor_all',
                                           'R_FACTOR_R_FREE': 'R_factor_R_free',
                                           'R_FACTOR_R_FREE_ERROR': 'R_factor_R_free_error',
                                           'R_FACTOR_R_WORK': 'R_factor_R_work',
                                           'STRUCTURE_ID': 'structure_id'},
                            'ATTRIBUTE_INFO': {'D_RES_HIGH': {'NULLABLE': True,
                                                              'ORDER': 2,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'FLOAT',
                                                              'WIDTH': 10},
                                               'D_RES_LOW': {'NULLABLE': True,
                                                             'ORDER': 3,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                               'NUMBER_REFLNS_ALL': {'NULLABLE': True,
                                                                     'ORDER': 11,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'INT',
                                                                     'WIDTH': '11'},
                                               'NUMBER_REFLNS_OBS': {'NULLABLE': True,
                                                                     'ORDER': 12,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'INT',
                                                                     'WIDTH': '11'},
                                               'NUMBER_REFLNS_R_FREE': {'NULLABLE': True,
                                                                        'ORDER': 13,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'INT',
                                                                        'WIDTH': '11'},
                                               'NUMBER_REFLNS_R_WORK': {'NULLABLE': True,
                                                                        'ORDER': 14,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'INT',
                                                                        'WIDTH': '11'},
                                               'PDBX_TOTAL_NUMBER_OF_BINS_USED': {'NULLABLE': True,
                                                                                  'ORDER': 10,
                                                                                  'PRECISION': 0,
                                                                                  'PRIMARY_KEY': False,
                                                                                  'SQL_TYPE': 'FLOAT',
                                                                                  'WIDTH': 10},
                                               'PERCENT_REFLNS_OBS': {'NULLABLE': True,
                                                                      'ORDER': 4,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'FLOAT',
                                                                      'WIDTH': 10},
                                               'PERCENT_REFLNS_R_FREE': {'NULLABLE': True,
                                                                         'ORDER': 5,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'FLOAT',
                                                                         'WIDTH': 10},
                                               'R_FACTOR_ALL': {'NULLABLE': True,
                                                                'ORDER': 6,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                               'R_FACTOR_R_FREE': {'NULLABLE': True,
                                                                   'ORDER': 7,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                               'R_FACTOR_R_FREE_ERROR': {'NULLABLE': True,
                                                                         'ORDER': 8,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'FLOAT',
                                                                         'WIDTH': 10},
                                               'R_FACTOR_R_WORK': {'NULLABLE': True,
                                                                   'ORDER': 9,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                               'STRUCTURE_ID': {'NULLABLE': False,
                                                                'ORDER': 1,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': True,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': '6'}},
                            'ATTRIBUTE_MAP': {'D_RES_HIGH': ('refine_ls_shell', 'd_res_high', None, None),
                                              'D_RES_LOW': ('refine_ls_shell', 'd_res_low', None, None),
                                              'NUMBER_REFLNS_ALL': ('refine_ls_shell',
                                                                    'number_reflns_all',
                                                                    None,
                                                                    None),
                                              'NUMBER_REFLNS_OBS': ('refine_ls_shell',
                                                                    'number_reflns_obs',
                                                                    None,
                                                                    None),
                                              'NUMBER_REFLNS_R_FREE': ('refine_ls_shell',
                                                                       'number_reflns_R_free',
                                                                       None,
                                                                       None),
                                              'NUMBER_REFLNS_R_WORK': ('refine_ls_shell',
                                                                       'number_reflns_R_work',
                                                                       None,
                                                                       None),
                                              'PDBX_TOTAL_NUMBER_OF_BINS_USED': ('refine_ls_shell',
                                                                                 'pdbx_total_number_of_bins_used',
                                                                                 None,
                                                                                 None),
                                              'PERCENT_REFLNS_OBS': ('refine_ls_shell',
                                                                     'percent_reflns_obs',
                                                                     None,
                                                                     None),
                                              'PERCENT_REFLNS_R_FREE': ('refine_ls_shell',
                                                                        'percent_reflns_R_free',
                                                                        None,
                                                                        None),
                                              'R_FACTOR_ALL': ('refine_ls_shell', 'R_factor_all', None, None),
                                              'R_FACTOR_R_FREE': ('refine_ls_shell', 'R_factor_R_free', None, None),
                                              'R_FACTOR_R_FREE_ERROR': ('refine_ls_shell',
                                                                        'R_factor_R_free_error',
                                                                        None,
                                                                        None),
                                              'R_FACTOR_R_WORK': ('refine_ls_shell', 'R_factor_R_work', None, None),
                                              'STRUCTURE_ID': ('refine_ls_shell', 'structure_id', None, None)},
                            'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'UNIQUE'}},
                            'MAP_MERGE_INDICES': {'refine_ls_shell': {'ATTRIBUTES': ('STRUCTURE_ID',),
                                                                      'TYPE': 'EQUI-JOIN'}},
                            'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                            'TABLE_ID': 'REFINE_LS_SHELL',
                            'TABLE_NAME': 'refine_ls_shell',
                            'TABLE_TYPE': 'transactional'},
        'REFLNS': {'ATTRIBUTES': {'B_ISO_WILSON_ESTIMATE': 'B_iso_Wilson_estimate',
                                  'DATA_REDUCTION_DETAILS': 'data_reduction_details',
                                  'DATA_REDUCTION_METHOD': 'data_reduction_method',
                                  'DETAILS': 'details',
                                  'D_RESOLUTION_HIGH': 'd_resolution_high',
                                  'D_RESOLUTION_LOW': 'd_resolution_low',
                                  'ENTRY_ID': 'entry_id',
                                  'FRIEDEL_COVERAGE': 'Friedel_coverage',
                                  'LIMIT_H_MAX': 'limit_h_max',
                                  'LIMIT_H_MIN': 'limit_h_min',
                                  'LIMIT_K_MAX': 'limit_k_max',
                                  'LIMIT_K_MIN': 'limit_k_min',
                                  'LIMIT_L_MAX': 'limit_l_max',
                                  'LIMIT_L_MIN': 'limit_l_min',
                                  'NUMBER_ALL': 'number_all',
                                  'NUMBER_GT': 'number_gt',
                                  'NUMBER_OBS': 'number_obs',
                                  'OBSERVED_CRITERION': 'observed_criterion',
                                  'OBSERVED_CRITERION_F_MAX': 'observed_criterion_F_max',
                                  'OBSERVED_CRITERION_F_MIN': 'observed_criterion_F_min',
                                  'OBSERVED_CRITERION_I_MAX': 'observed_criterion_I_max',
                                  'OBSERVED_CRITERION_I_MIN': 'observed_criterion_I_min',
                                  'OBSERVED_CRITERION_SIGMA_F': 'observed_criterion_sigma_F',
                                  'OBSERVED_CRITERION_SIGMA_I': 'observed_criterion_sigma_I',
                                  'PDBX_CHI_SQUARED': 'pdbx_chi_squared',
                                  'PDBX_DIFFRN_ID': 'pdbx_diffrn_id',
                                  'PDBX_D_OPT': 'pdbx_d_opt',
                                  'PDBX_D_RES_HIGH_OPT': 'pdbx_d_res_high_opt',
                                  'PDBX_D_RES_LOW_OPT': 'pdbx_d_res_low_opt',
                                  'PDBX_D_RES_OPT_METHOD': 'pdbx_d_res_opt_method',
                                  'PDBX_NETI_OVER_AV_SIGMAI': 'pdbx_netI_over_av_sigmaI',
                                  'PDBX_NETI_OVER_SIGMAI': 'pdbx_netI_over_sigmaI',
                                  'PDBX_NUMBER_MEASURED_ALL': 'pdbx_number_measured_all',
                                  'PDBX_ORDINAL': 'pdbx_ordinal',
                                  'PDBX_REDUNDANCY': 'pdbx_redundancy',
                                  'PDBX_RES_NETI_OVER_AV_SIGMAI_2': 'pdbx_res_netI_over_av_sigmaI_2',
                                  'PDBX_RES_NETI_OVER_SIGMAI_2': 'pdbx_res_netI_over_sigmaI_2',
                                  'PDBX_RMERGE_I_ALL': 'pdbx_Rmerge_I_all',
                                  'PDBX_RMERGE_I_OBS': 'pdbx_Rmerge_I_obs',
                                  'PDBX_RPIM_I_ALL': 'pdbx_Rpim_I_all',
                                  'PDBX_RRIM_I_ALL': 'pdbx_Rrim_I_all',
                                  'PDBX_RSYM_VALUE': 'pdbx_Rsym_value',
                                  'PDBX_SCALING_REJECTS': 'pdbx_scaling_rejects',
                                  'PERCENT_POSSIBLE_OBS': 'percent_possible_obs',
                                  'PHASE_CALCULATION_DETAILS': 'phase_calculation_details',
                                  'RMERGE_F_ALL': 'Rmerge_F_all',
                                  'RMERGE_F_OBS': 'Rmerge_F_obs',
                                  'R_FREE_DETAILS': 'R_free_details',
                                  'STRUCTURE_ID': 'Structure_ID',
                                  'THRESHOLD_EXPRESSION': 'threshold_expression'},
                   'ATTRIBUTE_INFO': {'B_ISO_WILSON_ESTIMATE': {'NULLABLE': True,
                                                                'ORDER': 3,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                      'DATA_REDUCTION_DETAILS': {'NULLABLE': True,
                                                                 'ORDER': 4,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': '200'},
                                      'DATA_REDUCTION_METHOD': {'NULLABLE': True,
                                                                'ORDER': 5,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': '200'},
                                      'DETAILS': {'NULLABLE': True,
                                                  'ORDER': 8,
                                                  'PRECISION': 0,
                                                  'PRIMARY_KEY': False,
                                                  'SQL_TYPE': 'VARCHAR',
                                                  'WIDTH': '200'},
                                      'D_RESOLUTION_HIGH': {'NULLABLE': True,
                                                            'ORDER': 6,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'FLOAT',
                                                            'WIDTH': 10},
                                      'D_RESOLUTION_LOW': {'NULLABLE': True,
                                                           'ORDER': 7,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'FLOAT',
                                                           'WIDTH': 10},
                                      'ENTRY_ID': {'NULLABLE': True,
                                                   'ORDER': 2,
                                                   'PRECISION': 0,
                                                   'PRIMARY_KEY': False,
                                                   'SQL_TYPE': 'VARCHAR',
                                                   'WIDTH': '10'},
                                      'FRIEDEL_COVERAGE': {'NULLABLE': True,
                                                           'ORDER': 28,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'FLOAT',
                                                           'WIDTH': 10},
                                      'LIMIT_H_MAX': {'NULLABLE': True,
                                                      'ORDER': 9,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'INT',
                                                      'WIDTH': '11'},
                                      'LIMIT_H_MIN': {'NULLABLE': True,
                                                      'ORDER': 10,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'INT',
                                                      'WIDTH': '11'},
                                      'LIMIT_K_MAX': {'NULLABLE': True,
                                                      'ORDER': 11,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'INT',
                                                      'WIDTH': '11'},
                                      'LIMIT_K_MIN': {'NULLABLE': True,
                                                      'ORDER': 12,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'INT',
                                                      'WIDTH': '11'},
                                      'LIMIT_L_MAX': {'NULLABLE': True,
                                                      'ORDER': 13,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'INT',
                                                      'WIDTH': '11'},
                                      'LIMIT_L_MIN': {'NULLABLE': True,
                                                      'ORDER': 14,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'INT',
                                                      'WIDTH': '11'},
                                      'NUMBER_ALL': {'NULLABLE': True,
                                                     'ORDER': 15,
                                                     'PRECISION': 0,
                                                     'PRIMARY_KEY': False,
                                                     'SQL_TYPE': 'INT',
                                                     'WIDTH': '11'},
                                      'NUMBER_GT': {'NULLABLE': True,
                                                    'ORDER': 29,
                                                    'PRECISION': 0,
                                                    'PRIMARY_KEY': False,
                                                    'SQL_TYPE': 'INT',
                                                    'WIDTH': '11'},
                                      'NUMBER_OBS': {'NULLABLE': True,
                                                     'ORDER': 16,
                                                     'PRECISION': 0,
                                                     'PRIMARY_KEY': False,
                                                     'SQL_TYPE': 'INT',
                                                     'WIDTH': '11'},
                                      'OBSERVED_CRITERION': {'NULLABLE': True,
                                                             'ORDER': 17,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': '200'},
                                      'OBSERVED_CRITERION_F_MAX': {'NULLABLE': True,
                                                                   'ORDER': 18,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                      'OBSERVED_CRITERION_F_MIN': {'NULLABLE': True,
                                                                   'ORDER': 19,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                      'OBSERVED_CRITERION_I_MAX': {'NULLABLE': True,
                                                                   'ORDER': 20,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                      'OBSERVED_CRITERION_I_MIN': {'NULLABLE': True,
                                                                   'ORDER': 21,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                      'OBSERVED_CRITERION_SIGMA_F': {'NULLABLE': True,
                                                                     'ORDER': 22,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'FLOAT',
                                                                     'WIDTH': 10},
                                      'OBSERVED_CRITERION_SIGMA_I': {'NULLABLE': True,
                                                                     'ORDER': 23,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'FLOAT',
                                                                     'WIDTH': 10},
                                      'PDBX_CHI_SQUARED': {'NULLABLE': True,
                                                           'ORDER': 39,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'FLOAT',
                                                           'WIDTH': 10},
                                      'PDBX_DIFFRN_ID': {'NULLABLE': True,
                                                         'ORDER': 49,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': '10'},
                                      'PDBX_D_OPT': {'NULLABLE': True,
                                                     'ORDER': 47,
                                                     'PRECISION': 0,
                                                     'PRIMARY_KEY': False,
                                                     'SQL_TYPE': 'FLOAT',
                                                     'WIDTH': 10},
                                      'PDBX_D_RES_HIGH_OPT': {'NULLABLE': True,
                                                              'ORDER': 41,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'FLOAT',
                                                              'WIDTH': 10},
                                      'PDBX_D_RES_LOW_OPT': {'NULLABLE': True,
                                                             'ORDER': 42,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                      'PDBX_D_RES_OPT_METHOD': {'NULLABLE': True,
                                                                'ORDER': 43,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': '200'},
                                      'PDBX_NETI_OVER_AV_SIGMAI': {'NULLABLE': True,
                                                                   'ORDER': 35,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                      'PDBX_NETI_OVER_SIGMAI': {'NULLABLE': True,
                                                                'ORDER': 36,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                      'PDBX_NUMBER_MEASURED_ALL': {'NULLABLE': True,
                                                                   'ORDER': 48,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'INT',
                                                                   'WIDTH': '11'},
                                      'PDBX_ORDINAL': {'NULLABLE': False,
                                                       'ORDER': 50,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': True,
                                                       'SQL_TYPE': 'INT',
                                                       'WIDTH': '11'},
                                      'PDBX_REDUNDANCY': {'NULLABLE': True,
                                                          'ORDER': 31,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'FLOAT',
                                                          'WIDTH': 10},
                                      'PDBX_RES_NETI_OVER_AV_SIGMAI_2': {'NULLABLE': True,
                                                                         'ORDER': 37,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'FLOAT',
                                                                         'WIDTH': 10},
                                      'PDBX_RES_NETI_OVER_SIGMAI_2': {'NULLABLE': True,
                                                                      'ORDER': 38,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'FLOAT',
                                                                      'WIDTH': 10},
                                      'PDBX_RMERGE_I_ALL': {'NULLABLE': True,
                                                            'ORDER': 33,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'FLOAT',
                                                            'WIDTH': 10},
                                      'PDBX_RMERGE_I_OBS': {'NULLABLE': True,
                                                            'ORDER': 32,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'FLOAT',
                                                            'WIDTH': 10},
                                      'PDBX_RPIM_I_ALL': {'NULLABLE': True,
                                                          'ORDER': 46,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'FLOAT',
                                                          'WIDTH': 10},
                                      'PDBX_RRIM_I_ALL': {'NULLABLE': True,
                                                          'ORDER': 45,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'FLOAT',
                                                          'WIDTH': 10},
                                      'PDBX_RSYM_VALUE': {'NULLABLE': True,
                                                          'ORDER': 34,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'FLOAT',
                                                          'WIDTH': 10},
                                      'PDBX_SCALING_REJECTS': {'NULLABLE': True,
                                                               'ORDER': 40,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'INT',
                                                               'WIDTH': '11'},
                                      'PERCENT_POSSIBLE_OBS': {'NULLABLE': True,
                                                               'ORDER': 24,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                      'PHASE_CALCULATION_DETAILS': {'NULLABLE': True,
                                                                    'ORDER': 44,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': '200'},
                                      'RMERGE_F_ALL': {'NULLABLE': True,
                                                       'ORDER': 26,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': False,
                                                       'SQL_TYPE': 'FLOAT',
                                                       'WIDTH': 10},
                                      'RMERGE_F_OBS': {'NULLABLE': True,
                                                       'ORDER': 27,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': False,
                                                       'SQL_TYPE': 'FLOAT',
                                                       'WIDTH': 10},
                                      'R_FREE_DETAILS': {'NULLABLE': True,
                                                         'ORDER': 25,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': '200'},
                                      'STRUCTURE_ID': {'NULLABLE': False,
                                                       'ORDER': 1,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': True,
                                                       'SQL_TYPE': 'VARCHAR',
                                                       'WIDTH': '10'},
                                      'THRESHOLD_EXPRESSION': {'NULLABLE': True,
                                                               'ORDER': 30,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': '200'}},
                   'ATTRIBUTE_MAP': {'B_ISO_WILSON_ESTIMATE': ('reflns', 'B_iso_Wilson_estimate', None, None),
                                     'DATA_REDUCTION_DETAILS': ('reflns', 'data_reduction_details', None, None),
                                     'DATA_REDUCTION_METHOD': ('reflns', 'data_reduction_method', None, None),
                                     'DETAILS': ('reflns', 'details', None, None),
                                     'D_RESOLUTION_HIGH': ('reflns', 'd_resolution_high', None, None),
                                     'D_RESOLUTION_LOW': ('reflns', 'd_resolution_low', None, None),
                                     'ENTRY_ID': ('reflns', 'entry_id', None, None),
                                     'FRIEDEL_COVERAGE': ('reflns', 'Friedel_coverage', None, None),
                                     'LIMIT_H_MAX': ('reflns', 'limit_h_max', None, None),
                                     'LIMIT_H_MIN': ('reflns', 'limit_h_min', None, None),
                                     'LIMIT_K_MAX': ('reflns', 'limit_k_max', None, None),
                                     'LIMIT_K_MIN': ('reflns', 'limit_k_min', None, None),
                                     'LIMIT_L_MAX': ('reflns', 'limit_l_max', None, None),
                                     'LIMIT_L_MIN': ('reflns', 'limit_l_min', None, None),
                                     'NUMBER_ALL': ('reflns', 'number_all', None, None),
                                     'NUMBER_GT': ('reflns', 'number_gt', None, None),
                                     'NUMBER_OBS': ('reflns', 'number_obs', None, None),
                                     'OBSERVED_CRITERION': ('reflns', 'observed_criterion', None, None),
                                     'OBSERVED_CRITERION_F_MAX': ('reflns', 'observed_criterion_F_max', None, None),
                                     'OBSERVED_CRITERION_F_MIN': ('reflns', 'observed_criterion_F_min', None, None),
                                     'OBSERVED_CRITERION_I_MAX': ('reflns', 'observed_criterion_I_max', None, None),
                                     'OBSERVED_CRITERION_I_MIN': ('reflns', 'observed_criterion_I_min', None, None),
                                     'OBSERVED_CRITERION_SIGMA_F': ('reflns',
                                                                    'observed_criterion_sigma_F',
                                                                    None,
                                                                    None),
                                     'OBSERVED_CRITERION_SIGMA_I': ('reflns',
                                                                    'observed_criterion_sigma_I',
                                                                    None,
                                                                    None),
                                     'PDBX_CHI_SQUARED': ('reflns', 'pdbx_chi_squared', None, None),
                                     'PDBX_DIFFRN_ID': ('reflns', 'pdbx_diffrn_id', None, None),
                                     'PDBX_D_OPT': ('reflns', 'pdbx_d_opt', None, None),
                                     'PDBX_D_RES_HIGH_OPT': ('reflns', 'pdbx_d_res_high_opt', None, None),
                                     'PDBX_D_RES_LOW_OPT': ('reflns', 'pdbx_d_res_low_opt', None, None),
                                     'PDBX_D_RES_OPT_METHOD': ('reflns', 'pdbx_d_res_opt_method', None, None),
                                     'PDBX_NETI_OVER_AV_SIGMAI': ('reflns', 'pdbx_netI_over_av_sigmaI', None, None),
                                     'PDBX_NETI_OVER_SIGMAI': ('reflns', 'pdbx_netI_over_sigmaI', None, None),
                                     'PDBX_NUMBER_MEASURED_ALL': ('reflns', 'pdbx_number_measured_all', None, None),
                                     'PDBX_ORDINAL': ('reflns', 'pdbx_ordinal', None, None),
                                     'PDBX_REDUNDANCY': ('reflns', 'pdbx_redundancy', None, None),
                                     'PDBX_RES_NETI_OVER_AV_SIGMAI_2': ('reflns',
                                                                        'pdbx_res_netI_over_av_sigmaI_2',
                                                                        None,
                                                                        None),
                                     'PDBX_RES_NETI_OVER_SIGMAI_2': ('reflns',
                                                                     'pdbx_res_netI_over_sigmaI_2',
                                                                     None,
                                                                     None),
                                     'PDBX_RMERGE_I_ALL': ('reflns', 'pdbx_Rmerge_I_all', None, None),
                                     'PDBX_RMERGE_I_OBS': ('reflns', 'pdbx_Rmerge_I_obs', None, None),
                                     'PDBX_RPIM_I_ALL': ('reflns', 'pdbx_Rpim_I_all', None, None),
                                     'PDBX_RRIM_I_ALL': ('reflns', 'pdbx_Rrim_I_all', None, None),
                                     'PDBX_RSYM_VALUE': ('reflns', 'pdbx_Rsym_value', None, None),
                                     'PDBX_SCALING_REJECTS': ('reflns', 'pdbx_scaling_rejects', None, None),
                                     'PERCENT_POSSIBLE_OBS': ('reflns', 'percent_possible_obs', None, None),
                                     'PHASE_CALCULATION_DETAILS': ('reflns', 'phase_calculation_details', None, None),
                                     'RMERGE_F_ALL': ('reflns', 'Rmerge_F_all', None, None),
                                     'RMERGE_F_OBS': ('reflns', 'Rmerge_F_obs', None, None),
                                     'R_FREE_DETAILS': ('reflns', 'R_free_details', None, None),
                                     'STRUCTURE_ID': ('reflns', 'Structure_ID', None, None),
                                     'THRESHOLD_EXPRESSION': ('reflns', 'threshold_expression', None, None)},
                   'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'PDBX_ORDINAL'), 'TYPE': 'UNIQUE'}},
                   'MAP_MERGE_INDICES': {'reflns': {'ATTRIBUTES': ('STRUCTURE_ID', 'PDBX_ORDINAL'),
                                                    'TYPE': 'EQUI-JOIN'}},
                   'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                   'TABLE_ID': 'REFLNS',
                   'TABLE_NAME': 'reflns',
                   'TABLE_TYPE': 'transactional'},
        'REFLNS_SHELL': {'ATTRIBUTES': {'D_RES_HIGH': 'd_res_high',
                                        'D_RES_LOW': 'd_res_low',
                                        'MEANI_OVER_SIGI_ALL': 'meanI_over_sigI_all',
                                        'MEANI_OVER_SIGI_OBS': 'meanI_over_sigI_obs',
                                        'NUMBER_MEASURED_ALL': 'number_measured_all',
                                        'NUMBER_MEASURED_OBS': 'number_measured_obs',
                                        'NUMBER_POSSIBLE': 'number_possible',
                                        'NUMBER_UNIQUE_ALL': 'number_unique_all',
                                        'NUMBER_UNIQUE_OBS': 'number_unique_obs',
                                        'PDBX_CHI_SQUARED': 'pdbx_chi_squared',
                                        'PDBX_NETI_OVER_SIGMAI_OBS': 'pdbx_netI_over_sigmaI_obs',
                                        'PDBX_REDUNDANCY': 'pdbx_redundancy',
                                        'PDBX_REJECTS': 'pdbx_rejects',
                                        'PDBX_RPIM_I_ALL': 'pdbx_Rpim_I_all',
                                        'PDBX_RRIM_I_ALL': 'pdbx_Rrim_I_all',
                                        'PDBX_RSYM_VALUE': 'pdbx_Rsym_value',
                                        'PERCENT_POSSIBLE_ALL': 'percent_possible_all',
                                        'PERCENT_POSSIBLE_OBS': 'percent_possible_obs',
                                        'RMERGE_F_OBS': 'Rmerge_F_obs',
                                        'RMERGE_I_ALL': 'Rmerge_I_all',
                                        'RMERGE_I_OBS': 'Rmerge_I_obs',
                                        'STRUCTURE_ID': 'structure_id'},
                         'ATTRIBUTE_INFO': {'D_RES_HIGH': {'NULLABLE': True,
                                                           'ORDER': 2,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'FLOAT',
                                                           'WIDTH': 10},
                                            'D_RES_LOW': {'NULLABLE': True,
                                                          'ORDER': 3,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'FLOAT',
                                                          'WIDTH': 10},
                                            'MEANI_OVER_SIGI_ALL': {'NULLABLE': True,
                                                                    'ORDER': 6,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'FLOAT',
                                                                    'WIDTH': 10},
                                            'MEANI_OVER_SIGI_OBS': {'NULLABLE': True,
                                                                    'ORDER': 7,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'FLOAT',
                                                                    'WIDTH': 10},
                                            'NUMBER_MEASURED_ALL': {'NULLABLE': True,
                                                                    'ORDER': 17,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'INT',
                                                                    'WIDTH': '11'},
                                            'NUMBER_MEASURED_OBS': {'NULLABLE': True,
                                                                    'ORDER': 18,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'INT',
                                                                    'WIDTH': '11'},
                                            'NUMBER_POSSIBLE': {'NULLABLE': True,
                                                                'ORDER': 21,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'INT',
                                                                'WIDTH': '11'},
                                            'NUMBER_UNIQUE_ALL': {'NULLABLE': True,
                                                                  'ORDER': 19,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'INT',
                                                                  'WIDTH': '11'},
                                            'NUMBER_UNIQUE_OBS': {'NULLABLE': True,
                                                                  'ORDER': 20,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'INT',
                                                                  'WIDTH': '11'},
                                            'PDBX_CHI_SQUARED': {'NULLABLE': True,
                                                                 'ORDER': 16,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                            'PDBX_NETI_OVER_SIGMAI_OBS': {'NULLABLE': True,
                                                                          'ORDER': 8,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'FLOAT',
                                                                          'WIDTH': 10},
                                            'PDBX_REDUNDANCY': {'NULLABLE': True,
                                                                'ORDER': 9,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                            'PDBX_REJECTS': {'NULLABLE': True,
                                                             'ORDER': 22,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'INT',
                                                             'WIDTH': '11'},
                                            'PDBX_RPIM_I_ALL': {'NULLABLE': True,
                                                                'ORDER': 15,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                            'PDBX_RRIM_I_ALL': {'NULLABLE': True,
                                                                'ORDER': 14,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                            'PDBX_RSYM_VALUE': {'NULLABLE': True,
                                                                'ORDER': 13,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                            'PERCENT_POSSIBLE_ALL': {'NULLABLE': True,
                                                                     'ORDER': 4,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'FLOAT',
                                                                     'WIDTH': 10},
                                            'PERCENT_POSSIBLE_OBS': {'NULLABLE': True,
                                                                     'ORDER': 5,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'FLOAT',
                                                                     'WIDTH': 10},
                                            'RMERGE_F_OBS': {'NULLABLE': True,
                                                             'ORDER': 10,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                            'RMERGE_I_ALL': {'NULLABLE': True,
                                                             'ORDER': 11,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                            'RMERGE_I_OBS': {'NULLABLE': True,
                                                             'ORDER': 12,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                            'STRUCTURE_ID': {'NULLABLE': False,
                                                             'ORDER': 1,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': '6'}},
                         'ATTRIBUTE_MAP': {'D_RES_HIGH': ('reflns_shell', 'd_res_high', None, None),
                                           'D_RES_LOW': ('reflns_shell', 'd_res_low', None, None),
                                           'MEANI_OVER_SIGI_ALL': ('reflns_shell', 'meanI_over_sigI_all', None, None),
                                           'MEANI_OVER_SIGI_OBS': ('reflns_shell', 'meanI_over_sigI_obs', None, None),
                                           'NUMBER_MEASURED_ALL': ('reflns_shell', 'number_measured_all', None, None),
                                           'NUMBER_MEASURED_OBS': ('reflns_shell', 'number_measured_obs', None, None),
                                           'NUMBER_POSSIBLE': ('reflns_shell', 'number_possible', None, None),
                                           'NUMBER_UNIQUE_ALL': ('reflns_shell', 'number_unique_all', None, None),
                                           'NUMBER_UNIQUE_OBS': ('reflns_shell', 'number_unique_obs', None, None),
                                           'PDBX_CHI_SQUARED': ('reflns_shell', 'pdbx_chi_squared', None, None),
                                           'PDBX_NETI_OVER_SIGMAI_OBS': ('reflns_shell',
                                                                         'pdbx_netI_over_sigmaI_obs',
                                                                         None,
                                                                         None),
                                           'PDBX_REDUNDANCY': ('reflns_shell', 'pdbx_redundancy', None, None),
                                           'PDBX_REJECTS': ('reflns_shell', 'pdbx_rejects', None, None),
                                           'PDBX_RPIM_I_ALL': ('reflns_shell', 'pdbx_Rpim_I_all', None, None),
                                           'PDBX_RRIM_I_ALL': ('reflns_shell', 'pdbx_Rrim_I_all', None, None),
                                           'PDBX_RSYM_VALUE': ('reflns_shell', 'pdbx_Rsym_value', None, None),
                                           'PERCENT_POSSIBLE_ALL': ('reflns_shell',
                                                                    'percent_possible_all',
                                                                    None,
                                                                    None),
                                           'PERCENT_POSSIBLE_OBS': ('reflns_shell',
                                                                    'percent_possible_obs',
                                                                    None,
                                                                    None),
                                           'RMERGE_F_OBS': ('reflns_shell', 'Rmerge_F_obs', None, None),
                                           'RMERGE_I_ALL': ('reflns_shell', 'Rmerge_I_all', None, None),
                                           'RMERGE_I_OBS': ('reflns_shell', 'Rmerge_I_obs', None, None),
                                           'STRUCTURE_ID': ('reflns_shell', 'structure_id', None, None)},
                         'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'UNIQUE'}},
                         'MAP_MERGE_INDICES': {'reflns_shell': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'EQUI-JOIN'}},
                         'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                         'TABLE_ID': 'REFLNS_SHELL',
                         'TABLE_NAME': 'reflns_shell',
                         'TABLE_TYPE': 'transactional'},
        'RSCC': {'ATTRIBUTES': {'LIGAND_BISO': 'ligand_biso',
                                'LIGAND_RSCC': 'ligand_rscc',
                                'LIGAND_RSR': 'ligand_rsr',
                                'LIGAND_ZSCORE_RSR': 'ligand_zscore_rsr',
                                'METAL_BISO': 'metal_biso',
                                'METAL_RSCC': 'metal_rscc',
                                'METAL_RSR': 'metal_rsr',
                                'METAL_ZSCORE_RSR': 'metal_zscore_rsr',
                                'NUCLEIC_ACID_BISO': 'nucleic_acid_biso',
                                'NUCLEIC_ACID_RSCC': 'nucleic_acid_rscc',
                                'NUCLEIC_ACID_RSR': 'nucleic_acid_rsr',
                                'NUCLEIC_ACID_ZSCORE_RSR': 'nucleic_acid_zscore_rsr',
                                'PROTEIN_BISO': 'protein_biso',
                                'PROTEIN_RSCC': 'protein_rscc',
                                'PROTEIN_RSR': 'protein_rsr',
                                'PROTEIN_ZSCORE_RSR': 'protein_zscore_rsr',
                                'STRUCTURE_ID': 'Structure_ID',
                                'WATER_BISO': 'water_biso',
                                'WATER_RSCC': 'water_rscc',
                                'WATER_RSR': 'water_rsr',
                                'WATER_ZSCORE_RSR': 'water_zscore_rsr'},
                 'ATTRIBUTE_INFO': {'LIGAND_BISO': {'NULLABLE': True,
                                                    'ORDER': 2,
                                                    'PRECISION': 0,
                                                    'PRIMARY_KEY': False,
                                                    'SQL_TYPE': 'FLOAT',
                                                    'WIDTH': 10},
                                    'LIGAND_RSCC': {'NULLABLE': True,
                                                    'ORDER': 4,
                                                    'PRECISION': 0,
                                                    'PRIMARY_KEY': False,
                                                    'SQL_TYPE': 'FLOAT',
                                                    'WIDTH': 10},
                                    'LIGAND_RSR': {'NULLABLE': True,
                                                   'ORDER': 3,
                                                   'PRECISION': 0,
                                                   'PRIMARY_KEY': False,
                                                   'SQL_TYPE': 'FLOAT',
                                                   'WIDTH': 10},
                                    'LIGAND_ZSCORE_RSR': {'NULLABLE': True,
                                                          'ORDER': 5,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'FLOAT',
                                                          'WIDTH': 10},
                                    'METAL_BISO': {'NULLABLE': True,
                                                   'ORDER': 6,
                                                   'PRECISION': 0,
                                                   'PRIMARY_KEY': False,
                                                   'SQL_TYPE': 'FLOAT',
                                                   'WIDTH': 10},
                                    'METAL_RSCC': {'NULLABLE': True,
                                                   'ORDER': 8,
                                                   'PRECISION': 0,
                                                   'PRIMARY_KEY': False,
                                                   'SQL_TYPE': 'FLOAT',
                                                   'WIDTH': 10},
                                    'METAL_RSR': {'NULLABLE': True,
                                                  'ORDER': 7,
                                                  'PRECISION': 0,
                                                  'PRIMARY_KEY': False,
                                                  'SQL_TYPE': 'FLOAT',
                                                  'WIDTH': 10},
                                    'METAL_ZSCORE_RSR': {'NULLABLE': True,
                                                         'ORDER': 9,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                    'NUCLEIC_ACID_BISO': {'NULLABLE': True,
                                                          'ORDER': 18,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'FLOAT',
                                                          'WIDTH': 10},
                                    'NUCLEIC_ACID_RSCC': {'NULLABLE': True,
                                                          'ORDER': 20,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'FLOAT',
                                                          'WIDTH': 10},
                                    'NUCLEIC_ACID_RSR': {'NULLABLE': True,
                                                         'ORDER': 19,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                    'NUCLEIC_ACID_ZSCORE_RSR': {'NULLABLE': True,
                                                                'ORDER': 21,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                    'PROTEIN_BISO': {'NULLABLE': True,
                                                     'ORDER': 14,
                                                     'PRECISION': 0,
                                                     'PRIMARY_KEY': False,
                                                     'SQL_TYPE': 'FLOAT',
                                                     'WIDTH': 10},
                                    'PROTEIN_RSCC': {'NULLABLE': True,
                                                     'ORDER': 16,
                                                     'PRECISION': 0,
                                                     'PRIMARY_KEY': False,
                                                     'SQL_TYPE': 'FLOAT',
                                                     'WIDTH': 10},
                                    'PROTEIN_RSR': {'NULLABLE': True,
                                                    'ORDER': 15,
                                                    'PRECISION': 0,
                                                    'PRIMARY_KEY': False,
                                                    'SQL_TYPE': 'FLOAT',
                                                    'WIDTH': 10},
                                    'PROTEIN_ZSCORE_RSR': {'NULLABLE': True,
                                                           'ORDER': 17,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'FLOAT',
                                                           'WIDTH': 10},
                                    'STRUCTURE_ID': {'NULLABLE': False,
                                                     'ORDER': 1,
                                                     'PRECISION': 0,
                                                     'PRIMARY_KEY': True,
                                                     'SQL_TYPE': 'VARCHAR',
                                                     'WIDTH': '6'},
                                    'WATER_BISO': {'NULLABLE': True,
                                                   'ORDER': 10,
                                                   'PRECISION': 0,
                                                   'PRIMARY_KEY': False,
                                                   'SQL_TYPE': 'FLOAT',
                                                   'WIDTH': 10},
                                    'WATER_RSCC': {'NULLABLE': True,
                                                   'ORDER': 12,
                                                   'PRECISION': 0,
                                                   'PRIMARY_KEY': False,
                                                   'SQL_TYPE': 'FLOAT',
                                                   'WIDTH': 10},
                                    'WATER_RSR': {'NULLABLE': True,
                                                  'ORDER': 11,
                                                  'PRECISION': 0,
                                                  'PRIMARY_KEY': False,
                                                  'SQL_TYPE': 'FLOAT',
                                                  'WIDTH': 10},
                                    'WATER_ZSCORE_RSR': {'NULLABLE': True,
                                                         'ORDER': 13,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10}},
                 'ATTRIBUTE_MAP': {'LIGAND_BISO': ('rscc', 'ligand_biso', None, None),
                                   'LIGAND_RSCC': ('rscc', 'ligand_rscc', None, None),
                                   'LIGAND_RSR': ('rscc', 'ligand_rsr', None, None),
                                   'LIGAND_ZSCORE_RSR': ('rscc', 'ligand_zscore_rsr', None, None),
                                   'METAL_BISO': ('rscc', 'metal_biso', None, None),
                                   'METAL_RSCC': ('rscc', 'metal_rscc', None, None),
                                   'METAL_RSR': ('rscc', 'metal_rsr', None, None),
                                   'METAL_ZSCORE_RSR': ('rscc', 'metal_zscore_rsr', None, None),
                                   'NUCLEIC_ACID_BISO': ('rscc', 'nucleic_acid_biso', None, None),
                                   'NUCLEIC_ACID_RSCC': ('rscc', 'nucleic_acid_rscc', None, None),
                                   'NUCLEIC_ACID_RSR': ('rscc', 'nucleic_acid_rsr', None, None),
                                   'NUCLEIC_ACID_ZSCORE_RSR': ('rscc', 'nucleic_acid_zscore_rsr', None, None),
                                   'PROTEIN_BISO': ('rscc', 'protein_biso', None, None),
                                   'PROTEIN_RSCC': ('rscc', 'protein_rscc', None, None),
                                   'PROTEIN_RSR': ('rscc', 'protein_rsr', None, None),
                                   'PROTEIN_ZSCORE_RSR': ('rscc', 'protein_zscore_rsr', None, None),
                                   'STRUCTURE_ID': ('rscc', 'Structure_ID', None, None),
                                   'WATER_BISO': ('rscc', 'water_biso', None, None),
                                   'WATER_RSCC': ('rscc', 'water_rscc', None, None),
                                   'WATER_RSR': ('rscc', 'water_rsr', None, None),
                                   'WATER_ZSCORE_RSR': ('rscc', 'water_zscore_rsr', None, None)},
                 'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'UNIQUE'}},
                 'MAP_MERGE_INDICES': {'rscc': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'EQUI-JOIN'}},
                 'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                 'TABLE_ID': 'RSCC',
                 'TABLE_NAME': 'rscc',
                 'TABLE_TYPE': 'transactional'},
        'STRUCT_CONF': {'ATTRIBUTES': {'BEG_AUTH_ASYM_ID': 'beg_auth_asym_id',
                                       'BEG_AUTH_COMP_ID': 'beg_auth_comp_id',
                                       'BEG_AUTH_SEQ_ID': 'beg_auth_seq_id',
                                       'BEG_LABEL_ASYM_ID': 'beg_label_asym_id',
                                       'BEG_LABEL_COMP_ID': 'beg_label_comp_id',
                                       'BEG_LABEL_SEQ_ID': 'beg_label_seq_id',
                                       'CONF_TYPE_ID': 'conf_type_id',
                                       'DETAILS': 'details',
                                       'END_AUTH_ASYM_ID': 'end_auth_asym_id',
                                       'END_AUTH_COMP_ID': 'end_auth_comp_id',
                                       'END_AUTH_SEQ_ID': 'end_auth_seq_id',
                                       'END_LABEL_ASYM_ID': 'end_label_asym_id',
                                       'END_LABEL_COMP_ID': 'end_label_comp_id',
                                       'END_LABEL_SEQ_ID': 'end_label_seq_id',
                                       'ID': 'id',
                                       'PDBX_BEG_PDB_INS_CODE': 'pdbx_beg_PDB_ins_code',
                                       'PDBX_END_PDB_INS_CODE': 'pdbx_end_PDB_ins_code',
                                       'PDBX_PDB_HELIX_CLASS': 'pdbx_PDB_helix_class',
                                       'PDBX_PDB_HELIX_ID': 'pdbx_PDB_helix_id',
                                       'PDBX_PDB_HELIX_LENGTH': 'pdbx_PDB_helix_length',
                                       'STRUCTURE_ID': 'Structure_ID'},
                        'ATTRIBUTE_INFO': {'BEG_AUTH_ASYM_ID': {'NULLABLE': True,
                                                                'ORDER': 2,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': '10'},
                                           'BEG_AUTH_COMP_ID': {'NULLABLE': True,
                                                                'ORDER': 4,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': '10'},
                                           'BEG_AUTH_SEQ_ID': {'NULLABLE': True,
                                                               'ORDER': 6,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': '10'},
                                           'BEG_LABEL_ASYM_ID': {'NULLABLE': True,
                                                                 'ORDER': 12,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': '10'},
                                           'BEG_LABEL_COMP_ID': {'NULLABLE': True,
                                                                 'ORDER': 8,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': '10'},
                                           'BEG_LABEL_SEQ_ID': {'NULLABLE': True,
                                                                'ORDER': 10,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'INT',
                                                                'WIDTH': '11'},
                                           'CONF_TYPE_ID': {'NULLABLE': True,
                                                            'ORDER': 14,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': '10'},
                                           'DETAILS': {'NULLABLE': True,
                                                       'ORDER': 15,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': False,
                                                       'SQL_TYPE': 'VARCHAR',
                                                       'WIDTH': '200'},
                                           'END_AUTH_ASYM_ID': {'NULLABLE': True,
                                                                'ORDER': 3,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': '10'},
                                           'END_AUTH_COMP_ID': {'NULLABLE': True,
                                                                'ORDER': 5,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': '10'},
                                           'END_AUTH_SEQ_ID': {'NULLABLE': True,
                                                               'ORDER': 7,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': '10'},
                                           'END_LABEL_ASYM_ID': {'NULLABLE': True,
                                                                 'ORDER': 13,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': '10'},
                                           'END_LABEL_COMP_ID': {'NULLABLE': True,
                                                                 'ORDER': 9,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': '10'},
                                           'END_LABEL_SEQ_ID': {'NULLABLE': True,
                                                                'ORDER': 11,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'INT',
                                                                'WIDTH': '11'},
                                           'ID': {'NULLABLE': False,
                                                  'ORDER': 16,
                                                  'PRECISION': 0,
                                                  'PRIMARY_KEY': True,
                                                  'SQL_TYPE': 'VARCHAR',
                                                  'WIDTH': '10'},
                                           'PDBX_BEG_PDB_INS_CODE': {'NULLABLE': True,
                                                                     'ORDER': 17,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': '10'},
                                           'PDBX_END_PDB_INS_CODE': {'NULLABLE': True,
                                                                     'ORDER': 18,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': '10'},
                                           'PDBX_PDB_HELIX_CLASS': {'NULLABLE': True,
                                                                    'ORDER': 19,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': '80'},
                                           'PDBX_PDB_HELIX_ID': {'NULLABLE': True,
                                                                 'ORDER': 21,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': '10'},
                                           'PDBX_PDB_HELIX_LENGTH': {'NULLABLE': True,
                                                                     'ORDER': 20,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'INT',
                                                                     'WIDTH': '11'},
                                           'STRUCTURE_ID': {'NULLABLE': False,
                                                            'ORDER': 1,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': True,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': '10'}},
                        'ATTRIBUTE_MAP': {'BEG_AUTH_ASYM_ID': ('struct_conf', 'beg_auth_asym_id', None, None),
                                          'BEG_AUTH_COMP_ID': ('struct_conf', 'beg_auth_comp_id', None, None),
                                          'BEG_AUTH_SEQ_ID': ('struct_conf', 'beg_auth_seq_id', None, None),
                                          'BEG_LABEL_ASYM_ID': ('struct_conf', 'beg_label_asym_id', None, None),
                                          'BEG_LABEL_COMP_ID': ('struct_conf', 'beg_label_comp_id', None, None),
                                          'BEG_LABEL_SEQ_ID': ('struct_conf', 'beg_label_seq_id', None, None),
                                          'CONF_TYPE_ID': ('struct_conf', 'conf_type_id', None, None),
                                          'DETAILS': ('struct_conf', 'details', None, None),
                                          'END_AUTH_ASYM_ID': ('struct_conf', 'end_auth_asym_id', None, None),
                                          'END_AUTH_COMP_ID': ('struct_conf', 'end_auth_comp_id', None, None),
                                          'END_AUTH_SEQ_ID': ('struct_conf', 'end_auth_seq_id', None, None),
                                          'END_LABEL_ASYM_ID': ('struct_conf', 'end_label_asym_id', None, None),
                                          'END_LABEL_COMP_ID': ('struct_conf', 'end_label_comp_id', None, None),
                                          'END_LABEL_SEQ_ID': ('struct_conf', 'end_label_seq_id', None, None),
                                          'ID': ('struct_conf', 'id', None, None),
                                          'PDBX_BEG_PDB_INS_CODE': ('struct_conf',
                                                                    'pdbx_beg_PDB_ins_code',
                                                                    None,
                                                                    None),
                                          'PDBX_END_PDB_INS_CODE': ('struct_conf',
                                                                    'pdbx_end_PDB_ins_code',
                                                                    None,
                                                                    None),
                                          'PDBX_PDB_HELIX_CLASS': ('struct_conf', 'pdbx_PDB_helix_class', None, None),
                                          'PDBX_PDB_HELIX_ID': ('struct_conf', 'pdbx_PDB_helix_id', None, None),
                                          'PDBX_PDB_HELIX_LENGTH': ('struct_conf',
                                                                    'pdbx_PDB_helix_length',
                                                                    None,
                                                                    None),
                                          'STRUCTURE_ID': ('struct_conf', 'Structure_ID', None, None)},
                        'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ID'), 'TYPE': 'UNIQUE'}},
                        'MAP_MERGE_INDICES': {'struct_conf': {'ATTRIBUTES': ('STRUCTURE_ID', 'ID'),
                                                              'TYPE': 'EQUI-JOIN'}},
                        'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                        'TABLE_ID': 'STRUCT_CONF',
                        'TABLE_NAME': 'struct_conf',
                        'TABLE_TYPE': 'transactional'},
        'STRUCT_SHEET_RANGE': {'ATTRIBUTES': {'BEG_AUTH_ASYM_ID': 'beg_auth_asym_id',
                                              'BEG_AUTH_COMP_ID': 'beg_auth_comp_id',
                                              'BEG_AUTH_SEQ_ID': 'beg_auth_seq_id',
                                              'BEG_LABEL_ASYM_ID': 'beg_label_asym_id',
                                              'BEG_LABEL_COMP_ID': 'beg_label_comp_id',
                                              'BEG_LABEL_SEQ_ID': 'beg_label_seq_id',
                                              'END_AUTH_ASYM_ID': 'end_auth_asym_id',
                                              'END_AUTH_COMP_ID': 'end_auth_comp_id',
                                              'END_AUTH_SEQ_ID': 'end_auth_seq_id',
                                              'END_LABEL_ASYM_ID': 'end_label_asym_id',
                                              'END_LABEL_COMP_ID': 'end_label_comp_id',
                                              'END_LABEL_SEQ_ID': 'end_label_seq_id',
                                              'ID': 'id',
                                              'PDBX_BEG_PDB_INS_CODE': 'pdbx_beg_PDB_ins_code',
                                              'PDBX_END_PDB_INS_CODE': 'pdbx_end_PDB_ins_code',
                                              'SHEET_ID': 'sheet_id',
                                              'STRUCTURE_ID': 'Structure_ID',
                                              'SYMMETRY': 'symmetry'},
                               'ATTRIBUTE_INFO': {'BEG_AUTH_ASYM_ID': {'NULLABLE': True,
                                                                       'ORDER': 2,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': '10'},
                                                  'BEG_AUTH_COMP_ID': {'NULLABLE': True,
                                                                       'ORDER': 4,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': '10'},
                                                  'BEG_AUTH_SEQ_ID': {'NULLABLE': True,
                                                                      'ORDER': 6,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': '10'},
                                                  'BEG_LABEL_ASYM_ID': {'NULLABLE': True,
                                                                        'ORDER': 12,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': '10'},
                                                  'BEG_LABEL_COMP_ID': {'NULLABLE': True,
                                                                        'ORDER': 8,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': '10'},
                                                  'BEG_LABEL_SEQ_ID': {'NULLABLE': True,
                                                                       'ORDER': 10,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'INT',
                                                                       'WIDTH': '11'},
                                                  'END_AUTH_ASYM_ID': {'NULLABLE': True,
                                                                       'ORDER': 3,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': '10'},
                                                  'END_AUTH_COMP_ID': {'NULLABLE': True,
                                                                       'ORDER': 5,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': '10'},
                                                  'END_AUTH_SEQ_ID': {'NULLABLE': True,
                                                                      'ORDER': 7,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': '10'},
                                                  'END_LABEL_ASYM_ID': {'NULLABLE': True,
                                                                        'ORDER': 13,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': '10'},
                                                  'END_LABEL_COMP_ID': {'NULLABLE': True,
                                                                        'ORDER': 9,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': '10'},
                                                  'END_LABEL_SEQ_ID': {'NULLABLE': True,
                                                                       'ORDER': 11,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'INT',
                                                                       'WIDTH': '11'},
                                                  'ID': {'NULLABLE': False,
                                                         'ORDER': 15,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': True,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': '10'},
                                                  'PDBX_BEG_PDB_INS_CODE': {'NULLABLE': True,
                                                                            'ORDER': 17,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': '10'},
                                                  'PDBX_END_PDB_INS_CODE': {'NULLABLE': True,
                                                                            'ORDER': 18,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': '10'},
                                                  'SHEET_ID': {'NULLABLE': False,
                                                               'ORDER': 14,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': '10'},
                                                  'STRUCTURE_ID': {'NULLABLE': False,
                                                                   'ORDER': 1,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': True,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': '10'},
                                                  'SYMMETRY': {'NULLABLE': True,
                                                               'ORDER': 16,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': '10'}},
                               'ATTRIBUTE_MAP': {'BEG_AUTH_ASYM_ID': ('struct_sheet_range',
                                                                      'beg_auth_asym_id',
                                                                      None,
                                                                      None),
                                                 'BEG_AUTH_COMP_ID': ('struct_sheet_range',
                                                                      'beg_auth_comp_id',
                                                                      None,
                                                                      None),
                                                 'BEG_AUTH_SEQ_ID': ('struct_sheet_range',
                                                                     'beg_auth_seq_id',
                                                                     None,
                                                                     None),
                                                 'BEG_LABEL_ASYM_ID': ('struct_sheet_range',
                                                                       'beg_label_asym_id',
                                                                       None,
                                                                       None),
                                                 'BEG_LABEL_COMP_ID': ('struct_sheet_range',
                                                                       'beg_label_comp_id',
                                                                       None,
                                                                       None),
                                                 'BEG_LABEL_SEQ_ID': ('struct_sheet_range',
                                                                      'beg_label_seq_id',
                                                                      None,
                                                                      None),
                                                 'END_AUTH_ASYM_ID': ('struct_sheet_range',
                                                                      'end_auth_asym_id',
                                                                      None,
                                                                      None),
                                                 'END_AUTH_COMP_ID': ('struct_sheet_range',
                                                                      'end_auth_comp_id',
                                                                      None,
                                                                      None),
                                                 'END_AUTH_SEQ_ID': ('struct_sheet_range',
                                                                     'end_auth_seq_id',
                                                                     None,
                                                                     None),
                                                 'END_LABEL_ASYM_ID': ('struct_sheet_range',
                                                                       'end_label_asym_id',
                                                                       None,
                                                                       None),
                                                 'END_LABEL_COMP_ID': ('struct_sheet_range',
                                                                       'end_label_comp_id',
                                                                       None,
                                                                       None),
                                                 'END_LABEL_SEQ_ID': ('struct_sheet_range',
                                                                      'end_label_seq_id',
                                                                      None,
                                                                      None),
                                                 'ID': ('struct_sheet_range', 'id', None, None),
                                                 'PDBX_BEG_PDB_INS_CODE': ('struct_sheet_range',
                                                                           'pdbx_beg_PDB_ins_code',
                                                                           None,
                                                                           None),
                                                 'PDBX_END_PDB_INS_CODE': ('struct_sheet_range',
                                                                           'pdbx_end_PDB_ins_code',
                                                                           None,
                                                                           None),
                                                 'SHEET_ID': ('struct_sheet_range', 'sheet_id', None, None),
                                                 'STRUCTURE_ID': ('struct_sheet_range', 'Structure_ID', None, None),
                                                 'SYMMETRY': ('struct_sheet_range', 'symmetry', None, None)},
                               'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'SHEET_ID', 'ID'), 'TYPE': 'UNIQUE'}},
                               'MAP_MERGE_INDICES': {'struct_sheet_range': {'ATTRIBUTES': ('STRUCTURE_ID',
                                                                                           'SHEET_ID',
                                                                                           'ID'),
                                                                            'TYPE': 'EQUI-JOIN'}},
                               'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                               'TABLE_ID': 'STRUCT_SHEET_RANGE',
                               'TABLE_NAME': 'struct_sheet_range',
                               'TABLE_TYPE': 'transactional'},
        'WEIGHT_IN_ASU': {'ATTRIBUTES': {'NON_POLYMER': 'non_polymer',
                                         'OVERALL': 'overall',
                                         'POLYMER': 'polymer',
                                         'STRUCTURE_ID': 'Structure_id',
                                         'WATER': 'water'},
                          'ATTRIBUTE_INFO': {'NON_POLYMER': {'NULLABLE': True,
                                                             'ORDER': 3,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                             'OVERALL': {'NULLABLE': True,
                                                         'ORDER': 5,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                             'POLYMER': {'NULLABLE': True,
                                                         'ORDER': 2,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                             'STRUCTURE_ID': {'NULLABLE': False,
                                                              'ORDER': 1,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': True,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': '6'},
                                             'WATER': {'NULLABLE': True,
                                                       'ORDER': 4,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': False,
                                                       'SQL_TYPE': 'FLOAT',
                                                       'WIDTH': 10}},
                          'ATTRIBUTE_MAP': {'NON_POLYMER': ('weight_in_asu', 'non_polymer', None, None),
                                            'OVERALL': ('weight_in_asu', 'overall', None, None),
                                            'POLYMER': ('weight_in_asu', 'polymer', None, None),
                                            'STRUCTURE_ID': ('weight_in_asu', 'Structure_id', None, None),
                                            'WATER': ('weight_in_asu', 'water', None, None)},
                          'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'UNIQUE'}},
                          'MAP_MERGE_INDICES': {'weight_in_asu': {'ATTRIBUTES': ('STRUCTURE_ID',),
                                                                  'TYPE': 'EQUI-JOIN'}},
                          'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                          'TABLE_ID': 'WEIGHT_IN_ASU',
                          'TABLE_NAME': 'weight_in_asu',
                          'TABLE_TYPE': 'transactional'},
        'ENTITY': {'ATTRIBUTES': {'DETAILS': 'details',
                                  'FORMULA_WEIGHT': 'formula_weight',
                                  'ID': 'id',
                                  'PDBX_DESCRIPTION': 'pdbx_description',
                                  'PDBX_EC': 'pdbx_ec',
                                  'PDBX_FORMULA_WEIGHT_EXPTL': 'pdbx_formula_weight_exptl',
                                  'PDBX_FORMULA_WEIGHT_EXPTL_METHOD': 'pdbx_formula_weight_exptl_method',
                                  'PDBX_FRAGMENT': 'pdbx_fragment',
                                  'PDBX_MODIFICATION': 'pdbx_modification',
                                  'PDBX_MUTATION': 'pdbx_mutation',
                                  'PDBX_NUMBER_OF_MOLECULES': 'pdbx_number_of_molecules',
                                  'PDBX_PARENT_ENTITY_ID': 'pdbx_parent_entity_id',
                                  'PDBX_TARGET_ID': 'pdbx_target_id',
                                  'SRC_METHOD': 'src_method',
                                  'STRUCTURE_ID': 'Structure_ID',
                                  'TYPE': 'type'},
                   'ATTRIBUTE_INFO': {'DETAILS': {'NULLABLE': True,
                                                  'ORDER': 2,
                                                  'PRECISION': 0,
                                                  'PRIMARY_KEY': False,
                                                  'SQL_TYPE': 'VARCHAR',
                                                  'WIDTH': '1100'},
                                      'FORMULA_WEIGHT': {'NULLABLE': True,
                                                         'ORDER': 3,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                      'ID': {'NULLABLE': False,
                                             'ORDER': 4,
                                             'PRECISION': 0,
                                             'PRIMARY_KEY': True,
                                             'SQL_TYPE': 'VARCHAR',
                                             'WIDTH': '10'},
                                      'PDBX_DESCRIPTION': {'NULLABLE': True,
                                                           'ORDER': 7,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': '1100'},
                                      'PDBX_EC': {'NULLABLE': True,
                                                  'ORDER': 12,
                                                  'PRECISION': 0,
                                                  'PRIMARY_KEY': False,
                                                  'SQL_TYPE': 'VARCHAR',
                                                  'WIDTH': '80'},
                                      'PDBX_FORMULA_WEIGHT_EXPTL': {'NULLABLE': True,
                                                                    'ORDER': 14,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'FLOAT',
                                                                    'WIDTH': 10},
                                      'PDBX_FORMULA_WEIGHT_EXPTL_METHOD': {'NULLABLE': True,
                                                                           'ORDER': 15,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'VARCHAR',
                                                                           'WIDTH': '80'},
                                      'PDBX_FRAGMENT': {'NULLABLE': True,
                                                        'ORDER': 11,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': '300'},
                                      'PDBX_MODIFICATION': {'NULLABLE': True,
                                                            'ORDER': 13,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': '80'},
                                      'PDBX_MUTATION': {'NULLABLE': True,
                                                        'ORDER': 10,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': '300'},
                                      'PDBX_NUMBER_OF_MOLECULES': {'NULLABLE': True,
                                                                   'ORDER': 8,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                      'PDBX_PARENT_ENTITY_ID': {'NULLABLE': True,
                                                                'ORDER': 9,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': '10'},
                                      'PDBX_TARGET_ID': {'NULLABLE': True,
                                                         'ORDER': 16,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': '10'},
                                      'SRC_METHOD': {'NULLABLE': True,
                                                     'ORDER': 5,
                                                     'PRECISION': 0,
                                                     'PRIMARY_KEY': False,
                                                     'SQL_TYPE': 'VARCHAR',
                                                     'WIDTH': '10'},
                                      'STRUCTURE_ID': {'NULLABLE': False,
                                                       'ORDER': 1,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': True,
                                                       'SQL_TYPE': 'VARCHAR',
                                                       'WIDTH': '10'},
                                      'TYPE': {'NULLABLE': True,
                                               'ORDER': 6,
                                               'PRECISION': 0,
                                               'PRIMARY_KEY': False,
                                               'SQL_TYPE': 'VARCHAR',
                                               'WIDTH': '20'}},
                   'ATTRIBUTE_MAP': {'DETAILS': ('entity', 'details', None, None),
                                     'FORMULA_WEIGHT': ('entity', 'formula_weight', None, None),
                                     'ID': ('entity', 'id', None, None),
                                     'PDBX_DESCRIPTION': ('entity', 'pdbx_description', None, None),
                                     'PDBX_EC': ('entity', 'pdbx_ec', None, None),
                                     'PDBX_FORMULA_WEIGHT_EXPTL': ('entity', 'pdbx_formula_weight_exptl', None, None),
                                     'PDBX_FORMULA_WEIGHT_EXPTL_METHOD': ('entity',
                                                                          'pdbx_formula_weight_exptl_method',
                                                                          None,
                                                                          None),
                                     'PDBX_FRAGMENT': ('entity', 'pdbx_fragment', None, None),
                                     'PDBX_MODIFICATION': ('entity', 'pdbx_modification', None, None),
                                     'PDBX_MUTATION': ('entity', 'pdbx_mutation', None, None),
                                     'PDBX_NUMBER_OF_MOLECULES': ('entity', 'pdbx_number_of_molecules', None, None),
                                     'PDBX_PARENT_ENTITY_ID': ('entity', 'pdbx_parent_entity_id', None, None),
                                     'PDBX_TARGET_ID': ('entity', 'pdbx_target_id', None, None),
                                     'SRC_METHOD': ('entity', 'src_method', None, None),
                                     'STRUCTURE_ID': ('entity', 'Structure_ID', None, None),
                                     'TYPE': ('entity', 'type', None, None)},
                   'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ID'), 'TYPE': 'UNIQUE'}},
                   'MAP_MERGE_INDICES': {'entity': {'ATTRIBUTES': ('STRUCTURE_ID', 'ID'), 'TYPE': 'EQUI-JOIN'}},
                   'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                   'TABLE_ID': 'ENTITY',
                   'TABLE_NAME': 'entity',
                   'TABLE_TYPE': 'transactional'},
        'ENTITY_POLY': {'ATTRIBUTES': {'ENTITY_ID': 'entity_id',
                                       'NSTD_CHIRALITY': 'nstd_chirality',
                                       'NSTD_LINKAGE': 'nstd_linkage',
                                       'NSTD_MONOMER': 'nstd_monomer',
                                       'NUMBER_OF_MONOMERS': 'number_of_monomers',
                                       'PDBX_SEQ_ONE_LETTER_CODE': 'pdbx_seq_one_letter_code',
                                       'PDBX_SEQ_ONE_LETTER_CODE_CAN': 'pdbx_seq_one_letter_code_can',
                                       'PDBX_SEQ_ONE_LETTER_CODE_SAMPLE': 'pdbx_seq_one_letter_code_sample',
                                       'PDBX_STRAND_ID': 'pdbx_strand_id',
                                       'PDBX_TARGET_IDENTIFIER': 'pdbx_target_identifier',
                                       'STRUCTURE_ID': 'Structure_ID',
                                       'TYPE': 'type',
                                       'TYPE_DETAILS': 'type_details'},
                        'ATTRIBUTE_INFO': {'ENTITY_ID': {'NULLABLE': False,
                                                         'ORDER': 2,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': True,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': '10'},
                                           'NSTD_CHIRALITY': {'NULLABLE': True,
                                                              'ORDER': 3,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': '10'},
                                           'NSTD_LINKAGE': {'NULLABLE': True,
                                                            'ORDER': 4,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': '10'},
                                           'NSTD_MONOMER': {'NULLABLE': True,
                                                            'ORDER': 5,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': '10'},
                                           'NUMBER_OF_MONOMERS': {'NULLABLE': True,
                                                                  'ORDER': 6,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'INT',
                                                                  'WIDTH': '11'},
                                           'PDBX_SEQ_ONE_LETTER_CODE': {'NULLABLE': True,
                                                                        'ORDER': 10,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'TEXT',
                                                                        'WIDTH': 10},
                                           'PDBX_SEQ_ONE_LETTER_CODE_CAN': {'NULLABLE': True,
                                                                            'ORDER': 11,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'TEXT',
                                                                            'WIDTH': 10},
                                           'PDBX_SEQ_ONE_LETTER_CODE_SAMPLE': {'NULLABLE': True,
                                                                               'ORDER': 13,
                                                                               'PRECISION': 0,
                                                                               'PRIMARY_KEY': False,
                                                                               'SQL_TYPE': 'VARCHAR',
                                                                               'WIDTH': '200'},
                                           'PDBX_STRAND_ID': {'NULLABLE': True,
                                                              'ORDER': 9,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': '5000'},
                                           'PDBX_TARGET_IDENTIFIER': {'NULLABLE': True,
                                                                      'ORDER': 12,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': '150'},
                                           'STRUCTURE_ID': {'NULLABLE': False,
                                                            'ORDER': 1,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': True,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': '10'},
                                           'TYPE': {'NULLABLE': True,
                                                    'ORDER': 7,
                                                    'PRECISION': 0,
                                                    'PRIMARY_KEY': False,
                                                    'SQL_TYPE': 'VARCHAR',
                                                    'WIDTH': '80'},
                                           'TYPE_DETAILS': {'NULLABLE': True,
                                                            'ORDER': 8,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': '200'}},
                        'ATTRIBUTE_MAP': {'ENTITY_ID': ('entity_poly', 'entity_id', None, None),
                                          'NSTD_CHIRALITY': ('entity_poly', 'nstd_chirality', None, None),
                                          'NSTD_LINKAGE': ('entity_poly', 'nstd_linkage', None, None),
                                          'NSTD_MONOMER': ('entity_poly', 'nstd_monomer', None, None),
                                          'NUMBER_OF_MONOMERS': ('entity_poly', 'number_of_monomers', None, None),
                                          'PDBX_SEQ_ONE_LETTER_CODE': ('entity_poly',
                                                                       'pdbx_seq_one_letter_code',
                                                                       None,
                                                                       None),
                                          'PDBX_SEQ_ONE_LETTER_CODE_CAN': ('entity_poly',
                                                                           'pdbx_seq_one_letter_code_can',
                                                                           None,
                                                                           None),
                                          'PDBX_SEQ_ONE_LETTER_CODE_SAMPLE': ('entity_poly',
                                                                              'pdbx_seq_one_letter_code_sample',
                                                                              None,
                                                                              None),
                                          'PDBX_STRAND_ID': ('entity_poly', 'pdbx_strand_id', None, None),
                                          'PDBX_TARGET_IDENTIFIER': ('entity_poly',
                                                                     'pdbx_target_identifier',
                                                                     None,
                                                                     None),
                                          'STRUCTURE_ID': ('entity_poly', 'Structure_ID', None, None),
                                          'TYPE': ('entity_poly', 'type', None, None),
                                          'TYPE_DETAILS': ('entity_poly', 'type_details', None, None)},
                        'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTITY_ID'), 'TYPE': 'UNIQUE'}},
                        'MAP_MERGE_INDICES': {'entity_poly': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTITY_ID'),
                                                              'TYPE': 'EQUI-JOIN'}},
                        'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                        'TABLE_ID': 'ENTITY_POLY',
                        'TABLE_NAME': 'entity_poly',
                        'TABLE_TYPE': 'transactional'},
        'ENTITY_SRC_GEN': {'ATTRIBUTES': {'ENTITY_ID': 'entity_id',
                                          'EXPRESSION_SYSTEM_ID': 'expression_system_id',
                                          'GENE_SRC_COMMON_NAME': 'gene_src_common_name',
                                          'GENE_SRC_DETAILS': 'gene_src_details',
                                          'GENE_SRC_DEV_STAGE': 'gene_src_dev_stage',
                                          'GENE_SRC_GENUS': 'gene_src_genus',
                                          'GENE_SRC_SPECIES': 'gene_src_species',
                                          'GENE_SRC_STRAIN': 'gene_src_strain',
                                          'GENE_SRC_TISSUE': 'gene_src_tissue',
                                          'GENE_SRC_TISSUE_FRACTION': 'gene_src_tissue_fraction',
                                          'HOST_ORG_COMMON_NAME': 'host_org_common_name',
                                          'HOST_ORG_DETAILS': 'host_org_details',
                                          'HOST_ORG_GENUS': 'host_org_genus',
                                          'HOST_ORG_SPECIES': 'host_org_species',
                                          'HOST_ORG_STRAIN': 'host_org_strain',
                                          'PDBX_ALT_SOURCE_FLAG': 'pdbx_alt_source_flag',
                                          'PDBX_BEG_SEQ_NUM': 'pdbx_beg_seq_num',
                                          'PDBX_DESCRIPTION': 'pdbx_description',
                                          'PDBX_END_SEQ_NUM': 'pdbx_end_seq_num',
                                          'PDBX_GENE_SRC_ATCC': 'pdbx_gene_src_atcc',
                                          'PDBX_GENE_SRC_CELL': 'pdbx_gene_src_cell',
                                          'PDBX_GENE_SRC_CELLULAR_LOCATION': 'pdbx_gene_src_cellular_location',
                                          'PDBX_GENE_SRC_CELL_LINE': 'pdbx_gene_src_cell_line',
                                          'PDBX_GENE_SRC_FRAGMENT': 'pdbx_gene_src_fragment',
                                          'PDBX_GENE_SRC_GENE': 'pdbx_gene_src_gene',
                                          'PDBX_GENE_SRC_NCBI_TAXONOMY_ID': 'pdbx_gene_src_ncbi_taxonomy_id',
                                          'PDBX_GENE_SRC_ORGAN': 'pdbx_gene_src_organ',
                                          'PDBX_GENE_SRC_ORGANELLE': 'pdbx_gene_src_organelle',
                                          'PDBX_GENE_SRC_PLASMID': 'pdbx_gene_src_plasmid',
                                          'PDBX_GENE_SRC_PLASMID_NAME': 'pdbx_gene_src_plasmid_name',
                                          'PDBX_GENE_SRC_SCIENTIFIC_NAME': 'pdbx_gene_src_scientific_name',
                                          'PDBX_GENE_SRC_VARIANT': 'pdbx_gene_src_variant',
                                          'PDBX_HOST_ORG_ATCC': 'pdbx_host_org_atcc',
                                          'PDBX_HOST_ORG_CELL': 'pdbx_host_org_cell',
                                          'PDBX_HOST_ORG_CELLULAR_LOCATION': 'pdbx_host_org_cellular_location',
                                          'PDBX_HOST_ORG_CELL_LINE': 'pdbx_host_org_cell_line',
                                          'PDBX_HOST_ORG_CULTURE_COLLECTION': 'pdbx_host_org_culture_collection',
                                          'PDBX_HOST_ORG_GENE': 'pdbx_host_org_gene',
                                          'PDBX_HOST_ORG_NCBI_TAXONOMY_ID': 'pdbx_host_org_ncbi_taxonomy_id',
                                          'PDBX_HOST_ORG_ORGAN': 'pdbx_host_org_organ',
                                          'PDBX_HOST_ORG_ORGANELLE': 'pdbx_host_org_organelle',
                                          'PDBX_HOST_ORG_SCIENTIFIC_NAME': 'pdbx_host_org_scientific_name',
                                          'PDBX_HOST_ORG_STRAIN': 'pdbx_host_org_strain',
                                          'PDBX_HOST_ORG_TISSUE': 'pdbx_host_org_tissue',
                                          'PDBX_HOST_ORG_TISSUE_FRACTION': 'pdbx_host_org_tissue_fraction',
                                          'PDBX_HOST_ORG_VARIANT': 'pdbx_host_org_variant',
                                          'PDBX_HOST_ORG_VECTOR': 'pdbx_host_org_vector',
                                          'PDBX_HOST_ORG_VECTOR_TYPE': 'pdbx_host_org_vector_type',
                                          'PDBX_SRC_ID': 'pdbx_src_id',
                                          'PLASMID_DETAILS': 'plasmid_details',
                                          'PLASMID_NAME': 'plasmid_name',
                                          'START_CONSTRUCT_ID': 'start_construct_id',
                                          'STRUCTURE_ID': 'Structure_ID'},
                           'ATTRIBUTE_INFO': {'ENTITY_ID': {'NULLABLE': False,
                                                            'ORDER': 2,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': True,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': '10'},
                                              'EXPRESSION_SYSTEM_ID': {'NULLABLE': True,
                                                                       'ORDER': 45,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': '80'},
                                              'GENE_SRC_COMMON_NAME': {'NULLABLE': True,
                                                                       'ORDER': 3,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': '200'},
                                              'GENE_SRC_DETAILS': {'NULLABLE': True,
                                                                   'ORDER': 4,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': '550'},
                                              'GENE_SRC_DEV_STAGE': {'NULLABLE': True,
                                                                     'ORDER': 46,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': '200'},
                                              'GENE_SRC_GENUS': {'NULLABLE': True,
                                                                 'ORDER': 5,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': '200'},
                                              'GENE_SRC_SPECIES': {'NULLABLE': True,
                                                                   'ORDER': 6,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': '200'},
                                              'GENE_SRC_STRAIN': {'NULLABLE': True,
                                                                  'ORDER': 7,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': '550'},
                                              'GENE_SRC_TISSUE': {'NULLABLE': True,
                                                                  'ORDER': 8,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': '200'},
                                              'GENE_SRC_TISSUE_FRACTION': {'NULLABLE': True,
                                                                           'ORDER': 9,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'VARCHAR',
                                                                           'WIDTH': '200'},
                                              'HOST_ORG_COMMON_NAME': {'NULLABLE': True,
                                                                       'ORDER': 31,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': '200'},
                                              'HOST_ORG_DETAILS': {'NULLABLE': True,
                                                                   'ORDER': 32,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': '200'},
                                              'HOST_ORG_GENUS': {'NULLABLE': True,
                                                                 'ORDER': 10,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': '200'},
                                              'HOST_ORG_SPECIES': {'NULLABLE': True,
                                                                   'ORDER': 11,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': '200'},
                                              'HOST_ORG_STRAIN': {'NULLABLE': True,
                                                                  'ORDER': 33,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': '200'},
                                              'PDBX_ALT_SOURCE_FLAG': {'NULLABLE': True,
                                                                       'ORDER': 51,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': '10'},
                                              'PDBX_BEG_SEQ_NUM': {'NULLABLE': True,
                                                                   'ORDER': 52,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'INT',
                                                                   'WIDTH': '11'},
                                              'PDBX_DESCRIPTION': {'NULLABLE': True,
                                                                   'ORDER': 30,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': '5000'},
                                              'PDBX_END_SEQ_NUM': {'NULLABLE': True,
                                                                   'ORDER': 53,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'INT',
                                                                   'WIDTH': '11'},
                                              'PDBX_GENE_SRC_ATCC': {'NULLABLE': True,
                                                                     'ORDER': 17,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': '200'},
                                              'PDBX_GENE_SRC_CELL': {'NULLABLE': True,
                                                                     'ORDER': 22,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': '200'},
                                              'PDBX_GENE_SRC_CELLULAR_LOCATION': {'NULLABLE': True,
                                                                                  'ORDER': 23,
                                                                                  'PRECISION': 0,
                                                                                  'PRIMARY_KEY': False,
                                                                                  'SQL_TYPE': 'VARCHAR',
                                                                                  'WIDTH': '200'},
                                              'PDBX_GENE_SRC_CELL_LINE': {'NULLABLE': True,
                                                                          'ORDER': 16,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': '200'},
                                              'PDBX_GENE_SRC_FRAGMENT': {'NULLABLE': True,
                                                                         'ORDER': 12,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': '200'},
                                              'PDBX_GENE_SRC_GENE': {'NULLABLE': True,
                                                                     'ORDER': 13,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': '550'},
                                              'PDBX_GENE_SRC_NCBI_TAXONOMY_ID': {'NULLABLE': True,
                                                                                 'ORDER': 48,
                                                                                 'PRECISION': 0,
                                                                                 'PRIMARY_KEY': False,
                                                                                 'SQL_TYPE': 'VARCHAR',
                                                                                 'WIDTH': '80'},
                                              'PDBX_GENE_SRC_ORGAN': {'NULLABLE': True,
                                                                      'ORDER': 18,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': '200'},
                                              'PDBX_GENE_SRC_ORGANELLE': {'NULLABLE': True,
                                                                          'ORDER': 19,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': '200'},
                                              'PDBX_GENE_SRC_PLASMID': {'NULLABLE': True,
                                                                        'ORDER': 20,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': '200'},
                                              'PDBX_GENE_SRC_PLASMID_NAME': {'NULLABLE': True,
                                                                             'ORDER': 21,
                                                                             'PRECISION': 0,
                                                                             'PRIMARY_KEY': False,
                                                                             'SQL_TYPE': 'VARCHAR',
                                                                             'WIDTH': '200'},
                                              'PDBX_GENE_SRC_SCIENTIFIC_NAME': {'NULLABLE': True,
                                                                                'ORDER': 14,
                                                                                'PRECISION': 0,
                                                                                'PRIMARY_KEY': False,
                                                                                'SQL_TYPE': 'VARCHAR',
                                                                                'WIDTH': '200'},
                                              'PDBX_GENE_SRC_VARIANT': {'NULLABLE': True,
                                                                        'ORDER': 15,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': '200'},
                                              'PDBX_HOST_ORG_ATCC': {'NULLABLE': True,
                                                                     'ORDER': 38,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': '200'},
                                              'PDBX_HOST_ORG_CELL': {'NULLABLE': True,
                                                                     'ORDER': 40,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': '200'},
                                              'PDBX_HOST_ORG_CELLULAR_LOCATION': {'NULLABLE': True,
                                                                                  'ORDER': 27,
                                                                                  'PRECISION': 0,
                                                                                  'PRIMARY_KEY': False,
                                                                                  'SQL_TYPE': 'VARCHAR',
                                                                                  'WIDTH': '200'},
                                              'PDBX_HOST_ORG_CELL_LINE': {'NULLABLE': True,
                                                                          'ORDER': 37,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': '200'},
                                              'PDBX_HOST_ORG_CULTURE_COLLECTION': {'NULLABLE': True,
                                                                                   'ORDER': 39,
                                                                                   'PRECISION': 0,
                                                                                   'PRIMARY_KEY': False,
                                                                                   'SQL_TYPE': 'VARCHAR',
                                                                                   'WIDTH': '200'},
                                              'PDBX_HOST_ORG_GENE': {'NULLABLE': True,
                                                                     'ORDER': 24,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': '200'},
                                              'PDBX_HOST_ORG_NCBI_TAXONOMY_ID': {'NULLABLE': True,
                                                                                 'ORDER': 49,
                                                                                 'PRECISION': 0,
                                                                                 'PRIMARY_KEY': False,
                                                                                 'SQL_TYPE': 'VARCHAR',
                                                                                 'WIDTH': '80'},
                                              'PDBX_HOST_ORG_ORGAN': {'NULLABLE': True,
                                                                      'ORDER': 25,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': '200'},
                                              'PDBX_HOST_ORG_ORGANELLE': {'NULLABLE': True,
                                                                          'ORDER': 26,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': '200'},
                                              'PDBX_HOST_ORG_SCIENTIFIC_NAME': {'NULLABLE': True,
                                                                                'ORDER': 41,
                                                                                'PRECISION': 0,
                                                                                'PRIMARY_KEY': False,
                                                                                'SQL_TYPE': 'VARCHAR',
                                                                                'WIDTH': '200'},
                                              'PDBX_HOST_ORG_STRAIN': {'NULLABLE': True,
                                                                       'ORDER': 28,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': '200'},
                                              'PDBX_HOST_ORG_TISSUE': {'NULLABLE': True,
                                                                       'ORDER': 42,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': '200'},
                                              'PDBX_HOST_ORG_TISSUE_FRACTION': {'NULLABLE': True,
                                                                                'ORDER': 29,
                                                                                'PRECISION': 0,
                                                                                'PRIMARY_KEY': False,
                                                                                'SQL_TYPE': 'VARCHAR',
                                                                                'WIDTH': '200'},
                                              'PDBX_HOST_ORG_VARIANT': {'NULLABLE': True,
                                                                        'ORDER': 36,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': '200'},
                                              'PDBX_HOST_ORG_VECTOR': {'NULLABLE': True,
                                                                       'ORDER': 43,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': '200'},
                                              'PDBX_HOST_ORG_VECTOR_TYPE': {'NULLABLE': True,
                                                                            'ORDER': 44,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': '200'},
                                              'PDBX_SRC_ID': {'NULLABLE': True,
                                                              'ORDER': 50,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'INT',
                                                              'WIDTH': '11'},
                                              'PLASMID_DETAILS': {'NULLABLE': True,
                                                                  'ORDER': 34,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': '550'},
                                              'PLASMID_NAME': {'NULLABLE': True,
                                                               'ORDER': 35,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': '200'},
                                              'START_CONSTRUCT_ID': {'NULLABLE': True,
                                                                     'ORDER': 47,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': '10'},
                                              'STRUCTURE_ID': {'NULLABLE': False,
                                                               'ORDER': 1,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': '10'}},
                           'ATTRIBUTE_MAP': {'ENTITY_ID': ('entity_src_gen', 'entity_id', None, None),
                                             'EXPRESSION_SYSTEM_ID': ('entity_src_gen',
                                                                      'expression_system_id',
                                                                      None,
                                                                      None),
                                             'GENE_SRC_COMMON_NAME': ('entity_src_gen',
                                                                      'gene_src_common_name',
                                                                      None,
                                                                      None),
                                             'GENE_SRC_DETAILS': ('entity_src_gen', 'gene_src_details', None, None),
                                             'GENE_SRC_DEV_STAGE': ('entity_src_gen',
                                                                    'gene_src_dev_stage',
                                                                    None,
                                                                    None),
                                             'GENE_SRC_GENUS': ('entity_src_gen', 'gene_src_genus', None, None),
                                             'GENE_SRC_SPECIES': ('entity_src_gen', 'gene_src_species', None, None),
                                             'GENE_SRC_STRAIN': ('entity_src_gen', 'gene_src_strain', None, None),
                                             'GENE_SRC_TISSUE': ('entity_src_gen', 'gene_src_tissue', None, None),
                                             'GENE_SRC_TISSUE_FRACTION': ('entity_src_gen',
                                                                          'gene_src_tissue_fraction',
                                                                          None,
                                                                          None),
                                             'HOST_ORG_COMMON_NAME': ('entity_src_gen',
                                                                      'host_org_common_name',
                                                                      None,
                                                                      None),
                                             'HOST_ORG_DETAILS': ('entity_src_gen', 'host_org_details', None, None),
                                             'HOST_ORG_GENUS': ('entity_src_gen', 'host_org_genus', None, None),
                                             'HOST_ORG_SPECIES': ('entity_src_gen', 'host_org_species', None, None),
                                             'HOST_ORG_STRAIN': ('entity_src_gen', 'host_org_strain', None, None),
                                             'PDBX_ALT_SOURCE_FLAG': ('entity_src_gen',
                                                                      'pdbx_alt_source_flag',
                                                                      None,
                                                                      None),
                                             'PDBX_BEG_SEQ_NUM': ('entity_src_gen', 'pdbx_beg_seq_num', None, None),
                                             'PDBX_DESCRIPTION': ('entity_src_gen', 'pdbx_description', None, None),
                                             'PDBX_END_SEQ_NUM': ('entity_src_gen', 'pdbx_end_seq_num', None, None),
                                             'PDBX_GENE_SRC_ATCC': ('entity_src_gen',
                                                                    'pdbx_gene_src_atcc',
                                                                    None,
                                                                    None),
                                             'PDBX_GENE_SRC_CELL': ('entity_src_gen',
                                                                    'pdbx_gene_src_cell',
                                                                    None,
                                                                    None),
                                             'PDBX_GENE_SRC_CELLULAR_LOCATION': ('entity_src_gen',
                                                                                 'pdbx_gene_src_cellular_location',
                                                                                 None,
                                                                                 None),
                                             'PDBX_GENE_SRC_CELL_LINE': ('entity_src_gen',
                                                                         'pdbx_gene_src_cell_line',
                                                                         None,
                                                                         None),
                                             'PDBX_GENE_SRC_FRAGMENT': ('entity_src_gen',
                                                                        'pdbx_gene_src_fragment',
                                                                        None,
                                                                        None),
                                             'PDBX_GENE_SRC_GENE': ('entity_src_gen',
                                                                    'pdbx_gene_src_gene',
                                                                    None,
                                                                    None),
                                             'PDBX_GENE_SRC_NCBI_TAXONOMY_ID': ('entity_src_gen',
                                                                                'pdbx_gene_src_ncbi_taxonomy_id',
                                                                                None,
                                                                                None),
                                             'PDBX_GENE_SRC_ORGAN': ('entity_src_gen',
                                                                     'pdbx_gene_src_organ',
                                                                     None,
                                                                     None),
                                             'PDBX_GENE_SRC_ORGANELLE': ('entity_src_gen',
                                                                         'pdbx_gene_src_organelle',
                                                                         None,
                                                                         None),
                                             'PDBX_GENE_SRC_PLASMID': ('entity_src_gen',
                                                                       'pdbx_gene_src_plasmid',
                                                                       None,
                                                                       None),
                                             'PDBX_GENE_SRC_PLASMID_NAME': ('entity_src_gen',
                                                                            'pdbx_gene_src_plasmid_name',
                                                                            None,
                                                                            None),
                                             'PDBX_GENE_SRC_SCIENTIFIC_NAME': ('entity_src_gen',
                                                                               'pdbx_gene_src_scientific_name',
                                                                               None,
                                                                               None),
                                             'PDBX_GENE_SRC_VARIANT': ('entity_src_gen',
                                                                       'pdbx_gene_src_variant',
                                                                       None,
                                                                       None),
                                             'PDBX_HOST_ORG_ATCC': ('entity_src_gen',
                                                                    'pdbx_host_org_atcc',
                                                                    None,
                                                                    None),
                                             'PDBX_HOST_ORG_CELL': ('entity_src_gen',
                                                                    'pdbx_host_org_cell',
                                                                    None,
                                                                    None),
                                             'PDBX_HOST_ORG_CELLULAR_LOCATION': ('entity_src_gen',
                                                                                 'pdbx_host_org_cellular_location',
                                                                                 None,
                                                                                 None),
                                             'PDBX_HOST_ORG_CELL_LINE': ('entity_src_gen',
                                                                         'pdbx_host_org_cell_line',
                                                                         None,
                                                                         None),
                                             'PDBX_HOST_ORG_CULTURE_COLLECTION': ('entity_src_gen',
                                                                                  'pdbx_host_org_culture_collection',
                                                                                  None,
                                                                                  None),
                                             'PDBX_HOST_ORG_GENE': ('entity_src_gen',
                                                                    'pdbx_host_org_gene',
                                                                    None,
                                                                    None),
                                             'PDBX_HOST_ORG_NCBI_TAXONOMY_ID': ('entity_src_gen',
                                                                                'pdbx_host_org_ncbi_taxonomy_id',
                                                                                None,
                                                                                None),
                                             'PDBX_HOST_ORG_ORGAN': ('entity_src_gen',
                                                                     'pdbx_host_org_organ',
                                                                     None,
                                                                     None),
                                             'PDBX_HOST_ORG_ORGANELLE': ('entity_src_gen',
                                                                         'pdbx_host_org_organelle',
                                                                         None,
                                                                         None),
                                             'PDBX_HOST_ORG_SCIENTIFIC_NAME': ('entity_src_gen',
                                                                               'pdbx_host_org_scientific_name',
                                                                               None,
                                                                               None),
                                             'PDBX_HOST_ORG_STRAIN': ('entity_src_gen',
                                                                      'pdbx_host_org_strain',
                                                                      None,
                                                                      None),
                                             'PDBX_HOST_ORG_TISSUE': ('entity_src_gen',
                                                                      'pdbx_host_org_tissue',
                                                                      None,
                                                                      None),
                                             'PDBX_HOST_ORG_TISSUE_FRACTION': ('entity_src_gen',
                                                                               'pdbx_host_org_tissue_fraction',
                                                                               None,
                                                                               None),
                                             'PDBX_HOST_ORG_VARIANT': ('entity_src_gen',
                                                                       'pdbx_host_org_variant',
                                                                       None,
                                                                       None),
                                             'PDBX_HOST_ORG_VECTOR': ('entity_src_gen',
                                                                      'pdbx_host_org_vector',
                                                                      None,
                                                                      None),
                                             'PDBX_HOST_ORG_VECTOR_TYPE': ('entity_src_gen',
                                                                           'pdbx_host_org_vector_type',
                                                                           None,
                                                                           None),
                                             'PDBX_SRC_ID': ('entity_src_gen', 'pdbx_src_id', None, None),
                                             'PLASMID_DETAILS': ('entity_src_gen', 'plasmid_details', None, None),
                                             'PLASMID_NAME': ('entity_src_gen', 'plasmid_name', None, None),
                                             'START_CONSTRUCT_ID': ('entity_src_gen',
                                                                    'start_construct_id',
                                                                    None,
                                                                    None),
                                             'STRUCTURE_ID': ('entity_src_gen', 'Structure_ID', None, None)},
                           'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTITY_ID'), 'TYPE': 'UNIQUE'}},
                           'MAP_MERGE_INDICES': {'entity_src_gen': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTITY_ID'),
                                                                    'TYPE': 'EQUI-JOIN'}},
                           'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                           'TABLE_ID': 'ENTITY_SRC_GEN',
                           'TABLE_NAME': 'entity_src_gen',
                           'TABLE_TYPE': 'transactional'},
        'ENTITY_SRC_NAT': {'ATTRIBUTES': {'COMMON_NAME': 'common_name',
                                          'DETAILS': 'details',
                                          'ENTITY_ID': 'entity_id',
                                          'GENUS': 'genus',
                                          'PDBX_ALT_SOURCE_FLAG': 'pdbx_alt_source_flag',
                                          'PDBX_ATCC': 'pdbx_atcc',
                                          'PDBX_BEG_SEQ_NUM': 'pdbx_beg_seq_num',
                                          'PDBX_CELL': 'pdbx_cell',
                                          'PDBX_CELLULAR_LOCATION': 'pdbx_cellular_location',
                                          'PDBX_CELL_LINE': 'pdbx_cell_line',
                                          'PDBX_END_SEQ_NUM': 'pdbx_end_seq_num',
                                          'PDBX_FRAGMENT': 'pdbx_fragment',
                                          'PDBX_NCBI_TAXONOMY_ID': 'pdbx_ncbi_taxonomy_id',
                                          'PDBX_ORGAN': 'pdbx_organ',
                                          'PDBX_ORGANELLE': 'pdbx_organelle',
                                          'PDBX_ORGANISM_SCIENTIFIC': 'pdbx_organism_scientific',
                                          'PDBX_PLASMID_DETAILS': 'pdbx_plasmid_details',
                                          'PDBX_PLASMID_NAME': 'pdbx_plasmid_name',
                                          'PDBX_SECRETION': 'pdbx_secretion',
                                          'PDBX_SRC_ID': 'pdbx_src_id',
                                          'PDBX_VARIANT': 'pdbx_variant',
                                          'SPECIES': 'species',
                                          'STRAIN': 'strain',
                                          'STRUCTURE_ID': 'Structure_ID',
                                          'TISSUE': 'tissue',
                                          'TISSUE_FRACTION': 'tissue_fraction'},
                           'ATTRIBUTE_INFO': {'COMMON_NAME': {'NULLABLE': True,
                                                              'ORDER': 3,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': '200'},
                                              'DETAILS': {'NULLABLE': True,
                                                          'ORDER': 4,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': '5000'},
                                              'ENTITY_ID': {'NULLABLE': False,
                                                            'ORDER': 2,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': True,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': '10'},
                                              'GENUS': {'NULLABLE': True,
                                                        'ORDER': 5,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': '200'},
                                              'PDBX_ALT_SOURCE_FLAG': {'NULLABLE': True,
                                                                       'ORDER': 24,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': '10'},
                                              'PDBX_ATCC': {'NULLABLE': True,
                                                            'ORDER': 15,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': '200'},
                                              'PDBX_BEG_SEQ_NUM': {'NULLABLE': True,
                                                                   'ORDER': 25,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'INT',
                                                                   'WIDTH': '11'},
                                              'PDBX_CELL': {'NULLABLE': True,
                                                            'ORDER': 19,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': '200'},
                                              'PDBX_CELLULAR_LOCATION': {'NULLABLE': True,
                                                                         'ORDER': 16,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': '200'},
                                              'PDBX_CELL_LINE': {'NULLABLE': True,
                                                                 'ORDER': 14,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': '200'},
                                              'PDBX_END_SEQ_NUM': {'NULLABLE': True,
                                                                   'ORDER': 26,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'INT',
                                                                   'WIDTH': '11'},
                                              'PDBX_FRAGMENT': {'NULLABLE': True,
                                                                'ORDER': 12,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': '200'},
                                              'PDBX_NCBI_TAXONOMY_ID': {'NULLABLE': True,
                                                                        'ORDER': 22,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': '80'},
                                              'PDBX_ORGAN': {'NULLABLE': True,
                                                             'ORDER': 17,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': '200'},
                                              'PDBX_ORGANELLE': {'NULLABLE': True,
                                                                 'ORDER': 18,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': '200'},
                                              'PDBX_ORGANISM_SCIENTIFIC': {'NULLABLE': True,
                                                                           'ORDER': 10,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'VARCHAR',
                                                                           'WIDTH': '200'},
                                              'PDBX_PLASMID_DETAILS': {'NULLABLE': True,
                                                                       'ORDER': 21,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': '200'},
                                              'PDBX_PLASMID_NAME': {'NULLABLE': True,
                                                                    'ORDER': 20,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': '200'},
                                              'PDBX_SECRETION': {'NULLABLE': True,
                                                                 'ORDER': 11,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': '200'},
                                              'PDBX_SRC_ID': {'NULLABLE': True,
                                                              'ORDER': 23,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'INT',
                                                              'WIDTH': '11'},
                                              'PDBX_VARIANT': {'NULLABLE': True,
                                                               'ORDER': 13,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': '200'},
                                              'SPECIES': {'NULLABLE': True,
                                                          'ORDER': 6,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': '200'},
                                              'STRAIN': {'NULLABLE': True,
                                                         'ORDER': 7,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': '1100'},
                                              'STRUCTURE_ID': {'NULLABLE': False,
                                                               'ORDER': 1,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': '10'},
                                              'TISSUE': {'NULLABLE': True,
                                                         'ORDER': 8,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': '200'},
                                              'TISSUE_FRACTION': {'NULLABLE': True,
                                                                  'ORDER': 9,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': '200'}},
                           'ATTRIBUTE_MAP': {'COMMON_NAME': ('entity_src_nat', 'common_name', None, None),
                                             'DETAILS': ('entity_src_nat', 'details', None, None),
                                             'ENTITY_ID': ('entity_src_nat', 'entity_id', None, None),
                                             'GENUS': ('entity_src_nat', 'genus', None, None),
                                             'PDBX_ALT_SOURCE_FLAG': ('entity_src_nat',
                                                                      'pdbx_alt_source_flag',
                                                                      None,
                                                                      None),
                                             'PDBX_ATCC': ('entity_src_nat', 'pdbx_atcc', None, None),
                                             'PDBX_BEG_SEQ_NUM': ('entity_src_nat', 'pdbx_beg_seq_num', None, None),
                                             'PDBX_CELL': ('entity_src_nat', 'pdbx_cell', None, None),
                                             'PDBX_CELLULAR_LOCATION': ('entity_src_nat',
                                                                        'pdbx_cellular_location',
                                                                        None,
                                                                        None),
                                             'PDBX_CELL_LINE': ('entity_src_nat', 'pdbx_cell_line', None, None),
                                             'PDBX_END_SEQ_NUM': ('entity_src_nat', 'pdbx_end_seq_num', None, None),
                                             'PDBX_FRAGMENT': ('entity_src_nat', 'pdbx_fragment', None, None),
                                             'PDBX_NCBI_TAXONOMY_ID': ('entity_src_nat',
                                                                       'pdbx_ncbi_taxonomy_id',
                                                                       None,
                                                                       None),
                                             'PDBX_ORGAN': ('entity_src_nat', 'pdbx_organ', None, None),
                                             'PDBX_ORGANELLE': ('entity_src_nat', 'pdbx_organelle', None, None),
                                             'PDBX_ORGANISM_SCIENTIFIC': ('entity_src_nat',
                                                                          'pdbx_organism_scientific',
                                                                          None,
                                                                          None),
                                             'PDBX_PLASMID_DETAILS': ('entity_src_nat',
                                                                      'pdbx_plasmid_details',
                                                                      None,
                                                                      None),
                                             'PDBX_PLASMID_NAME': ('entity_src_nat', 'pdbx_plasmid_name', None, None),
                                             'PDBX_SECRETION': ('entity_src_nat', 'pdbx_secretion', None, None),
                                             'PDBX_SRC_ID': ('entity_src_nat', 'pdbx_src_id', None, None),
                                             'PDBX_VARIANT': ('entity_src_nat', 'pdbx_variant', None, None),
                                             'SPECIES': ('entity_src_nat', 'species', None, None),
                                             'STRAIN': ('entity_src_nat', 'strain', None, None),
                                             'STRUCTURE_ID': ('entity_src_nat', 'Structure_ID', None, None),
                                             'TISSUE': ('entity_src_nat', 'tissue', None, None),
                                             'TISSUE_FRACTION': ('entity_src_nat', 'tissue_fraction', None, None)},
                           'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTITY_ID'), 'TYPE': 'UNIQUE'}},
                           'MAP_MERGE_INDICES': {'entity_src_nat': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTITY_ID'),
                                                                    'TYPE': 'EQUI-JOIN'}},
                           'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                           'TABLE_ID': 'ENTITY_SRC_NAT',
                           'TABLE_NAME': 'entity_src_nat',
                           'TABLE_TYPE': 'transactional'},
        'PDBX_ENTITY_SRC_SYN': {'ATTRIBUTES': {'DETAILS': 'details',
                                               'ENTITY_ID': 'entity_id',
                                               'NCBI_TAXONOMY_ID': 'ncbi_taxonomy_id',
                                               'ORGANISM_COMMON_NAME': 'organism_common_name',
                                               'ORGANISM_SCIENTIFIC': 'organism_scientific',
                                               'PDBX_ALT_SOURCE_FLAG': 'pdbx_alt_source_flag',
                                               'PDBX_BEG_SEQ_NUM': 'pdbx_beg_seq_num',
                                               'PDBX_END_SEQ_NUM': 'pdbx_end_seq_num',
                                               'PDBX_SRC_ID': 'pdbx_src_id',
                                               'STRAIN': 'strain',
                                               'STRUCTURE_ID': 'Structure_ID'},
                                'ATTRIBUTE_INFO': {'DETAILS': {'NULLABLE': True,
                                                               'ORDER': 2,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': '1100'},
                                                   'ENTITY_ID': {'NULLABLE': False,
                                                                 'ORDER': 7,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': True,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': '10'},
                                                   'NCBI_TAXONOMY_ID': {'NULLABLE': True,
                                                                        'ORDER': 6,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': '80'},
                                                   'ORGANISM_COMMON_NAME': {'NULLABLE': True,
                                                                            'ORDER': 4,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': '200'},
                                                   'ORGANISM_SCIENTIFIC': {'NULLABLE': True,
                                                                           'ORDER': 3,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'VARCHAR',
                                                                           'WIDTH': '200'},
                                                   'PDBX_ALT_SOURCE_FLAG': {'NULLABLE': True,
                                                                            'ORDER': 9,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': '10'},
                                                   'PDBX_BEG_SEQ_NUM': {'NULLABLE': True,
                                                                        'ORDER': 10,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'INT',
                                                                        'WIDTH': '11'},
                                                   'PDBX_END_SEQ_NUM': {'NULLABLE': True,
                                                                        'ORDER': 11,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'INT',
                                                                        'WIDTH': '11'},
                                                   'PDBX_SRC_ID': {'NULLABLE': True,
                                                                   'ORDER': 8,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'INT',
                                                                   'WIDTH': '11'},
                                                   'STRAIN': {'NULLABLE': True,
                                                              'ORDER': 5,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': '200'},
                                                   'STRUCTURE_ID': {'NULLABLE': False,
                                                                    'ORDER': 1,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': True,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': '10'}},
                                'ATTRIBUTE_MAP': {'DETAILS': ('pdbx_entity_src_syn', 'details', None, None),
                                                  'ENTITY_ID': ('pdbx_entity_src_syn', 'entity_id', None, None),
                                                  'NCBI_TAXONOMY_ID': ('pdbx_entity_src_syn',
                                                                       'ncbi_taxonomy_id',
                                                                       None,
                                                                       None),
                                                  'ORGANISM_COMMON_NAME': ('pdbx_entity_src_syn',
                                                                           'organism_common_name',
                                                                           None,
                                                                           None),
                                                  'ORGANISM_SCIENTIFIC': ('pdbx_entity_src_syn',
                                                                          'organism_scientific',
                                                                          None,
                                                                          None),
                                                  'PDBX_ALT_SOURCE_FLAG': ('pdbx_entity_src_syn',
                                                                           'pdbx_alt_source_flag',
                                                                           None,
                                                                           None),
                                                  'PDBX_BEG_SEQ_NUM': ('pdbx_entity_src_syn',
                                                                       'pdbx_beg_seq_num',
                                                                       None,
                                                                       None),
                                                  'PDBX_END_SEQ_NUM': ('pdbx_entity_src_syn',
                                                                       'pdbx_end_seq_num',
                                                                       None,
                                                                       None),
                                                  'PDBX_SRC_ID': ('pdbx_entity_src_syn', 'pdbx_src_id', None, None),
                                                  'STRAIN': ('pdbx_entity_src_syn', 'strain', None, None),
                                                  'STRUCTURE_ID': ('pdbx_entity_src_syn', 'Structure_ID', None, None)},
                                'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTITY_ID'), 'TYPE': 'UNIQUE'}},
                                'MAP_MERGE_INDICES': {'pdbx_entity_src_syn': {'ATTRIBUTES': ('STRUCTURE_ID',
                                                                                             'ENTITY_ID'),
                                                                              'TYPE': 'EQUI-JOIN'}},
                                'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                'TABLE_ID': 'PDBX_ENTITY_SRC_SYN',
                                'TABLE_NAME': 'pdbx_entity_src_syn',
                                'TABLE_TYPE': 'transactional'}
    }
    # fmt: on

    def __init__(self, verbose=True, log=sys.stderr):
        super(PdbDistroSchemaDef, self).__init__(
            databaseName=PdbDistroSchemaDef._databaseName, schemaDefDict=PdbDistroSchemaDef._schemaDefDict, verbose=verbose, log=log
        )


if __name__ == "__main__":
    sd = PdbDistroSchemaDef()
    tableIdList = sd.getTableIdList()

    for tableId in tableIdList:
        aIdL = sd.getAttributeIdList(tableId)
        tObj = sd.getTable(tableId)
        attributeIdList = tObj.getAttributeIdList()
        attributeNameList = tObj.getAttributeNameList()
        sys.stdout.write("Ordered attribute Id   list %s\n" % (str(attributeIdList)))
        sys.stdout.write("Ordered attribute name list %s\n" % (str(attributeNameList)))
        #
        mAL = tObj.getMapAttributeNameList()
        sys.stdout.write("Ordered mapped attribute name list %s\n" % (str(mAL)))

        mAL = tObj.getMapAttributeIdList()
        sys.stdout.write("Ordered mapped attribute id   list %s\n" % (str(mAL)))

        cL = tObj.getMapInstanceCategoryList()
        sys.stdout.write("Mapped category list %s\n" % (str(cL)))
        for c in cL:
            aL = tObj.getMapInstanceAttributeList(c)
            sys.stdout.write("Mapped attribute list in %s :  %s\n" % (c, str(aL)))
