##
# File:    BirdSchemaDef.py
# Author:  J. Westbrook
# Date:    04-Jan-2013
# Version: 0.001 Initial version
#
# Updates:
##
"""
Database schema defintions for Bird PRD/FAMILY reference data.

"""

__docformat__ = "restructuredtext en"
__author__ = "John Westbrook"
__email__ = "jwest@rcsb.rutgers.edu"
__license__ = "Creative Commons Attribution 3.0 Unported"
__version__ = "V0.001"

import sys
from typing import ClassVar

from wwpdb.utils.db.SchemaDefBase import SchemaDefBase, SchemaDictType


class BirdSchemaDef(SchemaDefBase):
    """A data class containing schema definitions for deposition related messages."""

    _databaseName = "prdv4"
    # fmt: off
    _schemaDefDict: ClassVar[SchemaDictType] = {
        'CHEM_COMP': {'ATTRIBUTES': {'DB_ID': 'db_id',
                                     'FORMULA': 'formula',
                                     'FORMULA_WEIGHT': 'formula_weight',
                                     'ID': 'id',
                                     'MODEL_DETAILS': 'model_details',
                                     'MODEL_ERF': 'model_erf',
                                     'MODEL_SOURCE': 'model_source',
                                     'MON_NSTD_CLASS': 'mon_nstd_class',
                                     'MON_NSTD_DETAILS': 'mon_nstd_details',
                                     'MON_NSTD_FLAG': 'mon_nstd_flag',
                                     'MON_NSTD_PARENT': 'mon_nstd_parent',
                                     'MON_NSTD_PARENT_COMP_ID': 'mon_nstd_parent_comp_id',
                                     'NAME': 'name',
                                     'NUMBER_ATOMS_ALL': 'number_atoms_all',
                                     'NUMBER_ATOMS_NH': 'number_atoms_nh',
                                     'ONE_LETTER_CODE': 'one_letter_code',
                                     'PDBX_AMBIGUOUS_FLAG': 'pdbx_ambiguous_flag',
                                     'PDBX_COMPONENT_NO': 'pdbx_component_no',
                                     'PDBX_FORMAL_CHARGE': 'pdbx_formal_charge',
                                     'PDBX_IDEAL_COORDINATES_DETAILS': 'pdbx_ideal_coordinates_details',
                                     'PDBX_IDEAL_COORDINATES_MISSING_FLAG': 'pdbx_ideal_coordinates_missing_flag',
                                     'PDBX_INITIAL_DATE': 'pdbx_initial_date',
                                     'PDBX_MODEL_COORDINATES_DB_CODE': 'pdbx_model_coordinates_db_code',
                                     'PDBX_MODEL_COORDINATES_DETAILS': 'pdbx_model_coordinates_details',
                                     'PDBX_MODEL_COORDINATES_MISSING_FLAG': 'pdbx_model_coordinates_missing_flag',
                                     'PDBX_MODIFICATION_DETAILS': 'pdbx_modification_details',
                                     'PDBX_MODIFIED_DATE': 'pdbx_modified_date',
                                     'PDBX_PROCESSING_SITE': 'pdbx_processing_site',
                                     'PDBX_RELEASE_STATUS': 'pdbx_release_status',
                                     'PDBX_REPLACED_BY': 'pdbx_replaced_by',
                                     'PDBX_REPLACES': 'pdbx_replaces',
                                     'PDBX_SUBCOMPONENT_LIST': 'pdbx_subcomponent_list',
                                     'PDBX_SYNONYMS': 'pdbx_synonyms',
                                     'PDBX_TYPE': 'pdbx_type',
                                     'THREE_LETTER_CODE': 'three_letter_code',
                                     'TYPE': 'type'},
                      'ATTRIBUTE_INFO': {'DB_ID': {'NULLABLE': False,
                                                   'ORDER': 1,
                                                   'PRECISION': 0,
                                                   'PRIMARY_KEY': True,
                                                   'SQL_TYPE': 'VARCHAR',
                                                   'WIDTH': 10},
                                         'FORMULA': {'NULLABLE': True,
                                                     'ORDER': 2,
                                                     'PRECISION': 0,
                                                     'PRIMARY_KEY': False,
                                                     'SQL_TYPE': 'VARCHAR',
                                                     'WIDTH': 200},
                                         'FORMULA_WEIGHT': {'NULLABLE': True,
                                                            'ORDER': 3,
                                                            'PRECISION': 6,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'FLOAT',
                                                            'WIDTH': 10},
                                         'ID': {'NULLABLE': False,
                                                'ORDER': 4,
                                                'PRECISION': 0,
                                                'PRIMARY_KEY': True,
                                                'SQL_TYPE': 'VARCHAR',
                                                'WIDTH': 10},
                                         'MODEL_DETAILS': {'NULLABLE': True,
                                                           'ORDER': 6,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 200},
                                         'MODEL_ERF': {'NULLABLE': True,
                                                       'ORDER': 7,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': False,
                                                       'SQL_TYPE': 'VARCHAR',
                                                       'WIDTH': 80},
                                         'MODEL_SOURCE': {'NULLABLE': True,
                                                          'ORDER': 8,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 200},
                                         'MON_NSTD_CLASS': {'NULLABLE': True,
                                                            'ORDER': 9,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 200},
                                         'MON_NSTD_DETAILS': {'NULLABLE': True,
                                                              'ORDER': 10,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 200},
                                         'MON_NSTD_FLAG': {'NULLABLE': True,
                                                           'ORDER': 11,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 10},
                                         'MON_NSTD_PARENT': {'NULLABLE': True,
                                                             'ORDER': 12,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 10},
                                         'MON_NSTD_PARENT_COMP_ID': {'NULLABLE': True,
                                                                     'ORDER': 5,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10},
                                         'NAME': {'NULLABLE': True,
                                                  'ORDER': 13,
                                                  'PRECISION': 0,
                                                  'PRIMARY_KEY': False,
                                                  'SQL_TYPE': 'VARCHAR',
                                                  'WIDTH': 80},
                                         'NUMBER_ATOMS_ALL': {'NULLABLE': True,
                                                              'ORDER': 14,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'INT',
                                                              'WIDTH': 10},
                                         'NUMBER_ATOMS_NH': {'NULLABLE': True,
                                                             'ORDER': 15,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'INT',
                                                             'WIDTH': 10},
                                         'ONE_LETTER_CODE': {'NULLABLE': True,
                                                             'ORDER': 16,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 2},
                                         'PDBX_AMBIGUOUS_FLAG': {'NULLABLE': True,
                                                                 'ORDER': 23,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                         'PDBX_COMPONENT_NO': {'NULLABLE': True,
                                                               'ORDER': 21,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'INT',
                                                               'WIDTH': 10},
                                         'PDBX_FORMAL_CHARGE': {'NULLABLE': True,
                                                                'ORDER': 26,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'INT',
                                                                'WIDTH': 10},
                                         'PDBX_IDEAL_COORDINATES_DETAILS': {'NULLABLE': True,
                                                                            'ORDER': 28,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 200},
                                         'PDBX_IDEAL_COORDINATES_MISSING_FLAG': {'NULLABLE': True,
                                                                                 'ORDER': 29,
                                                                                 'PRECISION': 0,
                                                                                 'PRIMARY_KEY': False,
                                                                                 'SQL_TYPE': 'VARCHAR',
                                                                                 'WIDTH': 10},
                                         'PDBX_INITIAL_DATE': {'NULLABLE': True,
                                                               'ORDER': 35,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'DATETIME',
                                                               'WIDTH': 15},
                                         'PDBX_MODEL_COORDINATES_DB_CODE': {'NULLABLE': True,
                                                                            'ORDER': 31,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 80},
                                         'PDBX_MODEL_COORDINATES_DETAILS': {'NULLABLE': True,
                                                                            'ORDER': 27,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 200},
                                         'PDBX_MODEL_COORDINATES_MISSING_FLAG': {'NULLABLE': True,
                                                                                 'ORDER': 30,
                                                                                 'PRECISION': 0,
                                                                                 'PRIMARY_KEY': False,
                                                                                 'SQL_TYPE': 'VARCHAR',
                                                                                 'WIDTH': 10},
                                         'PDBX_MODIFICATION_DETAILS': {'NULLABLE': True,
                                                                       'ORDER': 20,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 80},
                                         'PDBX_MODIFIED_DATE': {'NULLABLE': True,
                                                                'ORDER': 36,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'DATETIME',
                                                                'WIDTH': 15},
                                         'PDBX_PROCESSING_SITE': {'NULLABLE': True,
                                                                  'ORDER': 34,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 10},
                                         'PDBX_RELEASE_STATUS': {'NULLABLE': True,
                                                                 'ORDER': 33,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 80},
                                         'PDBX_REPLACED_BY': {'NULLABLE': True,
                                                              'ORDER': 24,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10},
                                         'PDBX_REPLACES': {'NULLABLE': True,
                                                           'ORDER': 25,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 80},
                                         'PDBX_SUBCOMPONENT_LIST': {'NULLABLE': True,
                                                                    'ORDER': 32,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 200},
                                         'PDBX_SYNONYMS': {'NULLABLE': True,
                                                           'ORDER': 19,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 80},
                                         'PDBX_TYPE': {'NULLABLE': True,
                                                       'ORDER': 22,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': False,
                                                       'SQL_TYPE': 'VARCHAR',
                                                       'WIDTH': 80},
                                         'THREE_LETTER_CODE': {'NULLABLE': True,
                                                               'ORDER': 17,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 6},
                                         'TYPE': {'NULLABLE': True,
                                                  'ORDER': 18,
                                                  'PRECISION': 0,
                                                  'PRIMARY_KEY': False,
                                                  'SQL_TYPE': 'VARCHAR',
                                                  'WIDTH': 80}},
                      'ATTRIBUTE_MAP': {'DB_ID': (None, None, 'datablockid()', None),
                                        'FORMULA': ('chem_comp', 'formula', None, None),
                                        'FORMULA_WEIGHT': ('chem_comp', 'formula_weight', None, None),
                                        'ID': ('chem_comp', 'id', None, None),
                                        'MODEL_DETAILS': ('chem_comp', 'model_details', None, None),
                                        'MODEL_ERF': ('chem_comp', 'model_erf', None, None),
                                        'MODEL_SOURCE': ('chem_comp', 'model_source', None, None),
                                        'MON_NSTD_CLASS': ('chem_comp', 'mon_nstd_class', None, None),
                                        'MON_NSTD_DETAILS': ('chem_comp', 'mon_nstd_details', None, None),
                                        'MON_NSTD_FLAG': ('chem_comp', 'mon_nstd_flag', None, None),
                                        'MON_NSTD_PARENT': ('chem_comp', 'mon_nstd_parent', None, None),
                                        'MON_NSTD_PARENT_COMP_ID': ('chem_comp', 'mon_nstd_parent_comp_id', None, None),
                                        'NAME': ('chem_comp', 'name', None, None),
                                        'NUMBER_ATOMS_ALL': ('chem_comp', 'number_atoms_all', None, None),
                                        'NUMBER_ATOMS_NH': ('chem_comp', 'number_atoms_nh', None, None),
                                        'ONE_LETTER_CODE': ('chem_comp', 'one_letter_code', None, None),
                                        'PDBX_AMBIGUOUS_FLAG': ('chem_comp', 'pdbx_ambiguous_flag', None, None),
                                        'PDBX_COMPONENT_NO': ('chem_comp', 'pdbx_component_no', None, None),
                                        'PDBX_FORMAL_CHARGE': ('chem_comp', 'pdbx_formal_charge', None, None),
                                        'PDBX_IDEAL_COORDINATES_DETAILS': ('chem_comp',
                                                                           'pdbx_ideal_coordinates_details',
                                                                           None,
                                                                           None),
                                        'PDBX_IDEAL_COORDINATES_MISSING_FLAG': ('chem_comp',
                                                                                'pdbx_ideal_coordinates_missing_flag',
                                                                                None,
                                                                                None),
                                        'PDBX_INITIAL_DATE': ('chem_comp', 'pdbx_initial_date', None, None),
                                        'PDBX_MODEL_COORDINATES_DB_CODE': ('chem_comp',
                                                                           'pdbx_model_coordinates_db_code',
                                                                           None,
                                                                           None),
                                        'PDBX_MODEL_COORDINATES_DETAILS': ('chem_comp',
                                                                           'pdbx_model_coordinates_details',
                                                                           None,
                                                                           None),
                                        'PDBX_MODEL_COORDINATES_MISSING_FLAG': ('chem_comp',
                                                                                'pdbx_model_coordinates_missing_flag',
                                                                                None,
                                                                                None),
                                        'PDBX_MODIFICATION_DETAILS': ('chem_comp', 'pdbx_modification_details', None, None),
                                        'PDBX_MODIFIED_DATE': ('chem_comp', 'pdbx_modified_date', None, None),
                                        'PDBX_PROCESSING_SITE': ('chem_comp', 'pdbx_processing_site', None, None),
                                        'PDBX_RELEASE_STATUS': ('chem_comp', 'pdbx_release_status', None, None),
                                        'PDBX_REPLACED_BY': ('chem_comp', 'pdbx_replaced_by', None, None),
                                        'PDBX_REPLACES': ('chem_comp', 'pdbx_replaces', None, None),
                                        'PDBX_SUBCOMPONENT_LIST': ('chem_comp', 'pdbx_subcomponent_list', None, None),
                                        'PDBX_SYNONYMS': ('chem_comp', 'pdbx_synonyms', None, None),
                                        'PDBX_TYPE': ('chem_comp', 'pdbx_type', None, None),
                                        'THREE_LETTER_CODE': ('chem_comp', 'three_letter_code', None, None),
                                        'TYPE': ('chem_comp', 'type', None, None)},
                      'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID', 'ID'), 'TYPE': 'UNIQUE'},
                                  's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                      'MAP_MERGE_INDICES': {'chem_comp': {'ATTRIBUTES': ('id',), 'TYPE': 'EQUI-JOIN'}},
                      'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                      'TABLE_ID': 'CHEM_COMP',
                      'TABLE_NAME': 'chem_comp',
                      'TABLE_TYPE': 'transactional'},
        'CHEM_COMP_ATOM': {'ATTRIBUTES': {'ALT_ATOM_ID': 'alt_atom_id',
                                          'ATOM_ID': 'atom_id',
                                          'CHARGE': 'charge',
                                          'COMP_ID': 'comp_id',
                                          'DB_ID': 'db_id',
                                          'MODEL_CARTN_X': 'model_Cartn_x',
                                          'MODEL_CARTN_X_ESD': 'model_Cartn_x_esd',
                                          'MODEL_CARTN_Y': 'model_Cartn_y',
                                          'MODEL_CARTN_Y_ESD': 'model_Cartn_y_esd',
                                          'MODEL_CARTN_Z': 'model_Cartn_z',
                                          'MODEL_CARTN_Z_ESD': 'model_Cartn_z_esd',
                                          'PARTIAL_CHARGE': 'partial_charge',
                                          'PDBX_ALIGN': 'pdbx_align',
                                          'PDBX_ALT_ATOM_ID': 'pdbx_alt_atom_id',
                                          'PDBX_ALT_COMP_ID': 'pdbx_alt_comp_id',
                                          'PDBX_AROMATIC_FLAG': 'pdbx_aromatic_flag',
                                          'PDBX_COMPONENT_ATOM_ID': 'pdbx_component_atom_id',
                                          'PDBX_COMPONENT_COMP_ID': 'pdbx_component_comp_id',
                                          'PDBX_COMPONENT_ID': 'pdbx_component_id',
                                          'PDBX_LEAVING_ATOM_FLAG': 'pdbx_leaving_atom_flag',
                                          'PDBX_MODEL_CARTN_X_IDEAL': 'pdbx_model_Cartn_x_ideal',
                                          'PDBX_MODEL_CARTN_Y_IDEAL': 'pdbx_model_Cartn_y_ideal',
                                          'PDBX_MODEL_CARTN_Z_IDEAL': 'pdbx_model_Cartn_z_ideal',
                                          'PDBX_ORDINAL': 'pdbx_ordinal',
                                          'PDBX_POLYMER_TYPE': 'pdbx_polymer_type',
                                          'PDBX_REF_ID': 'pdbx_ref_id',
                                          'PDBX_RESIDUE_NUMBERING': 'pdbx_residue_numbering',
                                          'PDBX_STEREO_CONFIG': 'pdbx_stereo_config',
                                          'SUBSTRUCT_CODE': 'substruct_code',
                                          'TYPE_SYMBOL': 'type_symbol'},
                           'ATTRIBUTE_INFO': {'ALT_ATOM_ID': {'NULLABLE': True,
                                                              'ORDER': 3,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 80},
                                              'ATOM_ID': {'NULLABLE': False,
                                                          'ORDER': 4,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': True,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 6},
                                              'CHARGE': {'NULLABLE': True,
                                                         'ORDER': 5,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'INT',
                                                         'WIDTH': 10},
                                              'COMP_ID': {'NULLABLE': False,
                                                          'ORDER': 2,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': True,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 10},
                                              'DB_ID': {'NULLABLE': False,
                                                        'ORDER': 1,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': True,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': 10},
                                              'MODEL_CARTN_X': {'NULLABLE': True,
                                                                'ORDER': 6,
                                                                'PRECISION': 6,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                              'MODEL_CARTN_X_ESD': {'NULLABLE': True,
                                                                    'ORDER': 7,
                                                                    'PRECISION': 6,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'FLOAT',
                                                                    'WIDTH': 10},
                                              'MODEL_CARTN_Y': {'NULLABLE': True,
                                                                'ORDER': 8,
                                                                'PRECISION': 6,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                              'MODEL_CARTN_Y_ESD': {'NULLABLE': True,
                                                                    'ORDER': 9,
                                                                    'PRECISION': 6,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'FLOAT',
                                                                    'WIDTH': 10},
                                              'MODEL_CARTN_Z': {'NULLABLE': True,
                                                                'ORDER': 10,
                                                                'PRECISION': 6,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                              'MODEL_CARTN_Z_ESD': {'NULLABLE': True,
                                                                    'ORDER': 11,
                                                                    'PRECISION': 6,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'FLOAT',
                                                                    'WIDTH': 10},
                                              'PARTIAL_CHARGE': {'NULLABLE': True,
                                                                 'ORDER': 12,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                              'PDBX_ALIGN': {'NULLABLE': True,
                                                             'ORDER': 15,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'INT',
                                                             'WIDTH': 10},
                                              'PDBX_ALT_ATOM_ID': {'NULLABLE': True,
                                                                   'ORDER': 17,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 6},
                                              'PDBX_ALT_COMP_ID': {'NULLABLE': True,
                                                                   'ORDER': 18,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 10},
                                              'PDBX_AROMATIC_FLAG': {'NULLABLE': True,
                                                                     'ORDER': 23,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10},
                                              'PDBX_COMPONENT_ATOM_ID': {'NULLABLE': True,
                                                                         'ORDER': 27,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 6},
                                              'PDBX_COMPONENT_COMP_ID': {'NULLABLE': True,
                                                                         'ORDER': 25,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 10},
                                              'PDBX_COMPONENT_ID': {'NULLABLE': True,
                                                                    'ORDER': 30,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'INT',
                                                                    'WIDTH': 10},
                                              'PDBX_LEAVING_ATOM_FLAG': {'NULLABLE': True,
                                                                         'ORDER': 24,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 10},
                                              'PDBX_MODEL_CARTN_X_IDEAL': {'NULLABLE': True,
                                                                           'ORDER': 19,
                                                                           'PRECISION': 6,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'FLOAT',
                                                                           'WIDTH': 10},
                                              'PDBX_MODEL_CARTN_Y_IDEAL': {'NULLABLE': True,
                                                                           'ORDER': 20,
                                                                           'PRECISION': 6,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'FLOAT',
                                                                           'WIDTH': 10},
                                              'PDBX_MODEL_CARTN_Z_IDEAL': {'NULLABLE': True,
                                                                           'ORDER': 21,
                                                                           'PRECISION': 6,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'FLOAT',
                                                                           'WIDTH': 10},
                                              'PDBX_ORDINAL': {'NULLABLE': True,
                                                               'ORDER': 16,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'INT',
                                                               'WIDTH': 10},
                                              'PDBX_POLYMER_TYPE': {'NULLABLE': True,
                                                                    'ORDER': 28,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 80},
                                              'PDBX_REF_ID': {'NULLABLE': True,
                                                              'ORDER': 29,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10},
                                              'PDBX_RESIDUE_NUMBERING': {'NULLABLE': True,
                                                                         'ORDER': 26,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'INT',
                                                                         'WIDTH': 10},
                                              'PDBX_STEREO_CONFIG': {'NULLABLE': True,
                                                                     'ORDER': 22,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10},
                                              'SUBSTRUCT_CODE': {'NULLABLE': True,
                                                                 'ORDER': 13,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                              'TYPE_SYMBOL': {'NULLABLE': True,
                                                              'ORDER': 14,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10}},
                           'ATTRIBUTE_MAP': {'ALT_ATOM_ID': ('chem_comp_atom', 'alt_atom_id', None, None),
                                             'ATOM_ID': ('chem_comp_atom', 'atom_id', None, None),
                                             'CHARGE': ('chem_comp_atom', 'charge', None, None),
                                             'COMP_ID': ('chem_comp_atom', 'comp_id', None, None),
                                             'DB_ID': (None, None, 'datablockid()', None),
                                             'MODEL_CARTN_X': ('chem_comp_atom', 'model_Cartn_x', None, None),
                                             'MODEL_CARTN_X_ESD': ('chem_comp_atom', 'model_Cartn_x_esd', None, None),
                                             'MODEL_CARTN_Y': ('chem_comp_atom', 'model_Cartn_y', None, None),
                                             'MODEL_CARTN_Y_ESD': ('chem_comp_atom', 'model_Cartn_y_esd', None, None),
                                             'MODEL_CARTN_Z': ('chem_comp_atom', 'model_Cartn_z', None, None),
                                             'MODEL_CARTN_Z_ESD': ('chem_comp_atom', 'model_Cartn_z_esd', None, None),
                                             'PARTIAL_CHARGE': ('chem_comp_atom', 'partial_charge', None, None),
                                             'PDBX_ALIGN': ('chem_comp_atom', 'pdbx_align', None, None),
                                             'PDBX_ALT_ATOM_ID': ('chem_comp_atom', 'pdbx_alt_atom_id', None, None),
                                             'PDBX_ALT_COMP_ID': ('chem_comp_atom', 'pdbx_alt_comp_id', None, None),
                                             'PDBX_AROMATIC_FLAG': ('chem_comp_atom', 'pdbx_aromatic_flag', None, None),
                                             'PDBX_COMPONENT_ATOM_ID': ('chem_comp_atom',
                                                                        'pdbx_component_atom_id',
                                                                        None,
                                                                        None),
                                             'PDBX_COMPONENT_COMP_ID': ('chem_comp_atom',
                                                                        'pdbx_component_comp_id',
                                                                        None,
                                                                        None),
                                             'PDBX_COMPONENT_ID': ('chem_comp_atom', 'pdbx_component_id', None, None),
                                             'PDBX_LEAVING_ATOM_FLAG': ('chem_comp_atom',
                                                                        'pdbx_leaving_atom_flag',
                                                                        None,
                                                                        None),
                                             'PDBX_MODEL_CARTN_X_IDEAL': ('chem_comp_atom',
                                                                          'pdbx_model_Cartn_x_ideal',
                                                                          None,
                                                                          None),
                                             'PDBX_MODEL_CARTN_Y_IDEAL': ('chem_comp_atom',
                                                                          'pdbx_model_Cartn_y_ideal',
                                                                          None,
                                                                          None),
                                             'PDBX_MODEL_CARTN_Z_IDEAL': ('chem_comp_atom',
                                                                          'pdbx_model_Cartn_z_ideal',
                                                                          None,
                                                                          None),
                                             'PDBX_ORDINAL': ('chem_comp_atom', 'pdbx_ordinal', None, None),
                                             'PDBX_POLYMER_TYPE': ('chem_comp_atom', 'pdbx_polymer_type', None, None),
                                             'PDBX_REF_ID': ('chem_comp_atom', 'pdbx_ref_id', None, None),
                                             'PDBX_RESIDUE_NUMBERING': ('chem_comp_atom',
                                                                        'pdbx_residue_numbering',
                                                                        None,
                                                                        None),
                                             'PDBX_STEREO_CONFIG': ('chem_comp_atom', 'pdbx_stereo_config', None, None),
                                             'SUBSTRUCT_CODE': ('chem_comp_atom', 'substruct_code', None, None),
                                             'TYPE_SYMBOL': ('chem_comp_atom', 'type_symbol', None, None)},
                           'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID', 'COMP_ID', 'ATOM_ID'), 'TYPE': 'UNIQUE'},
                                       's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                           'MAP_MERGE_INDICES': {'chem_comp_atom': {'ATTRIBUTES': ('comp_id', 'atom_id'),
                                                                    'TYPE': 'EQUI-JOIN'}},
                           'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                           'TABLE_ID': 'CHEM_COMP_ATOM',
                           'TABLE_NAME': 'chem_comp_atom',
                           'TABLE_TYPE': 'transactional'},
        'CHEM_COMP_BOND': {'ATTRIBUTES': {'ATOM_ID_1': 'atom_id_1',
                                          'ATOM_ID_2': 'atom_id_2',
                                          'COMP_ID': 'comp_id',
                                          'DB_ID': 'db_id',
                                          'PDBX_AROMATIC_FLAG': 'pdbx_aromatic_flag',
                                          'PDBX_ORDINAL': 'pdbx_ordinal',
                                          'PDBX_STEREO_CONFIG': 'pdbx_stereo_config',
                                          'VALUE_DIST': 'value_dist',
                                          'VALUE_DIST_ESD': 'value_dist_esd',
                                          'VALUE_ORDER': 'value_order'},
                           'ATTRIBUTE_INFO': {'ATOM_ID_1': {'NULLABLE': False,
                                                            'ORDER': 3,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': True,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 6},
                                              'ATOM_ID_2': {'NULLABLE': False,
                                                            'ORDER': 4,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': True,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 6},
                                              'COMP_ID': {'NULLABLE': False,
                                                          'ORDER': 2,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': True,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 10},
                                              'DB_ID': {'NULLABLE': False,
                                                        'ORDER': 1,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': True,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': 10},
                                              'PDBX_AROMATIC_FLAG': {'NULLABLE': True,
                                                                     'ORDER': 10,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10},
                                              'PDBX_ORDINAL': {'NULLABLE': True,
                                                               'ORDER': 8,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'INT',
                                                               'WIDTH': 10},
                                              'PDBX_STEREO_CONFIG': {'NULLABLE': True,
                                                                     'ORDER': 9,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10},
                                              'VALUE_DIST': {'NULLABLE': True,
                                                             'ORDER': 6,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                              'VALUE_DIST_ESD': {'NULLABLE': True,
                                                                 'ORDER': 7,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                              'VALUE_ORDER': {'NULLABLE': True,
                                                              'ORDER': 5,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10}},
                           'ATTRIBUTE_MAP': {'ATOM_ID_1': ('chem_comp_bond', 'atom_id_1', None, None),
                                             'ATOM_ID_2': ('chem_comp_bond', 'atom_id_2', None, None),
                                             'COMP_ID': ('chem_comp_bond', 'comp_id', None, None),
                                             'DB_ID': (None, None, 'datablockid()', None),
                                             'PDBX_AROMATIC_FLAG': ('chem_comp_bond', 'pdbx_aromatic_flag', None, None),
                                             'PDBX_ORDINAL': ('chem_comp_bond', 'pdbx_ordinal', None, None),
                                             'PDBX_STEREO_CONFIG': ('chem_comp_bond', 'pdbx_stereo_config', None, None),
                                             'VALUE_DIST': ('chem_comp_bond', 'value_dist', None, None),
                                             'VALUE_DIST_ESD': ('chem_comp_bond', 'value_dist_esd', None, None),
                                             'VALUE_ORDER': ('chem_comp_bond', 'value_order', None, None)},
                           'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID', 'COMP_ID', 'ATOM_ID_1', 'ATOM_ID_2'), 'TYPE': 'UNIQUE'},
                                       's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                           'MAP_MERGE_INDICES': {'chem_comp_bond': {'ATTRIBUTES': ('comp_id', 'atom_id_1', 'atom_id_2'),
                                                                    'TYPE': 'EQUI-JOIN'}},
                           'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                           'TABLE_ID': 'CHEM_COMP_BOND',
                           'TABLE_NAME': 'chem_comp_bond',
                           'TABLE_TYPE': 'transactional'},
        'PDBX_CHEM_COMP_DESCRIPTOR': {'ATTRIBUTES': {'COMP_ID': 'comp_id',
                                                     'DB_ID': 'db_id',
                                                     'DESCRIPTOR': 'descriptor',
                                                     'ORDINAL': 'ordinal',
                                                     'PROGRAM': 'program',
                                                     'PROGRAM_VERSION': 'program_version',
                                                     'TYPE': 'type'},
                                      'ATTRIBUTE_INFO': {'COMP_ID': {'NULLABLE': False,
                                                                     'ORDER': 2,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': True,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10},
                                                         'DB_ID': {'NULLABLE': False,
                                                                   'ORDER': 1,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': True,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 10},
                                                         'DESCRIPTOR': {'NULLABLE': True,
                                                                        'ORDER': 3,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 200},
                                                         'ORDINAL': {'NULLABLE': True,
                                                                     'ORDER': 7,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'INT',
                                                                     'WIDTH': 10},
                                                         'PROGRAM': {'NULLABLE': False,
                                                                     'ORDER': 5,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': True,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 80},
                                                         'PROGRAM_VERSION': {'NULLABLE': False,
                                                                             'ORDER': 6,
                                                                             'PRECISION': 0,
                                                                             'PRIMARY_KEY': True,
                                                                             'SQL_TYPE': 'VARCHAR',
                                                                             'WIDTH': 80},
                                                         'TYPE': {'NULLABLE': False,
                                                                  'ORDER': 4,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': True,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 80}},
                                      'ATTRIBUTE_MAP': {'COMP_ID': ('pdbx_chem_comp_descriptor', 'comp_id', None, None),
                                                        'DB_ID': (None, None, 'datablockid()', None),
                                                        'DESCRIPTOR': ('pdbx_chem_comp_descriptor', 'descriptor', None, None),
                                                        'ORDINAL': ('pdbx_chem_comp_descriptor', 'ordinal', None, None),
                                                        'PROGRAM': ('pdbx_chem_comp_descriptor', 'program', None, None),
                                                        'PROGRAM_VERSION': ('pdbx_chem_comp_descriptor',
                                                                            'program_version',
                                                                            None,
                                                                            None),
                                                        'TYPE': ('pdbx_chem_comp_descriptor', 'type', None, None)},
                                      'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID',
                                                                        'COMP_ID',
                                                                        'TYPE',
                                                                        'PROGRAM',
                                                                        'PROGRAM_VERSION'),
                                                         'TYPE': 'UNIQUE'},
                                                  's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                                      'MAP_MERGE_INDICES': {'pdbx_chem_comp_descriptor': {'ATTRIBUTES': ('comp_id',
                                                                                                         'type',
                                                                                                         'program',
                                                                                                         'program_version'),
                                                                                          'TYPE': 'EQUI-JOIN'}},
                                      'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                                      'TABLE_ID': 'PDBX_CHEM_COMP_DESCRIPTOR',
                                      'TABLE_NAME': 'pdbx_chem_comp_descriptor',
                                      'TABLE_TYPE': 'transactional'},
        'PDBX_CHEM_COMP_IDENTIFIER': {'ATTRIBUTES': {'COMP_ID': 'comp_id',
                                                     'DB_ID': 'db_id',
                                                     'IDENTIFIER': 'identifier',
                                                     'ORDINAL': 'ordinal',
                                                     'PROGRAM': 'program',
                                                     'PROGRAM_VERSION': 'program_version',
                                                     'TYPE': 'type'},
                                      'ATTRIBUTE_INFO': {'COMP_ID': {'NULLABLE': False,
                                                                     'ORDER': 2,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': True,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10},
                                                         'DB_ID': {'NULLABLE': False,
                                                                   'ORDER': 1,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': True,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 10},
                                                         'IDENTIFIER': {'NULLABLE': True,
                                                                        'ORDER': 3,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 200},
                                                         'ORDINAL': {'NULLABLE': True,
                                                                     'ORDER': 7,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'INT',
                                                                     'WIDTH': 10},
                                                         'PROGRAM': {'NULLABLE': False,
                                                                     'ORDER': 5,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': True,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 80},
                                                         'PROGRAM_VERSION': {'NULLABLE': False,
                                                                             'ORDER': 6,
                                                                             'PRECISION': 0,
                                                                             'PRIMARY_KEY': True,
                                                                             'SQL_TYPE': 'VARCHAR',
                                                                             'WIDTH': 80},
                                                         'TYPE': {'NULLABLE': False,
                                                                  'ORDER': 4,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': True,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 80}},
                                      'ATTRIBUTE_MAP': {'COMP_ID': ('pdbx_chem_comp_identifier', 'comp_id', None, None),
                                                        'DB_ID': (None, None, 'datablockid()', None),
                                                        'IDENTIFIER': ('pdbx_chem_comp_identifier', 'identifier', None, None),
                                                        'ORDINAL': ('pdbx_chem_comp_identifier', 'ordinal', None, None),
                                                        'PROGRAM': ('pdbx_chem_comp_identifier', 'program', None, None),
                                                        'PROGRAM_VERSION': ('pdbx_chem_comp_identifier',
                                                                            'program_version',
                                                                            None,
                                                                            None),
                                                        'TYPE': ('pdbx_chem_comp_identifier', 'type', None, None)},
                                      'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID',
                                                                        'COMP_ID',
                                                                        'TYPE',
                                                                        'PROGRAM',
                                                                        'PROGRAM_VERSION'),
                                                         'TYPE': 'UNIQUE'},
                                                  's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                                      'MAP_MERGE_INDICES': {'pdbx_chem_comp_identifier': {'ATTRIBUTES': ('comp_id',
                                                                                                         'type',
                                                                                                         'program',
                                                                                                         'program_version'),
                                                                                          'TYPE': 'EQUI-JOIN'}},
                                      'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                                      'TABLE_ID': 'PDBX_CHEM_COMP_IDENTIFIER',
                                      'TABLE_NAME': 'pdbx_chem_comp_identifier',
                                      'TABLE_TYPE': 'transactional'},
        'PDBX_FAMILY_PRD_AUDIT': {'ATTRIBUTES': {'ACTION_TYPE': 'action_type',
                                                 'ANNOTATOR': 'annotator',
                                                 'DATE': 'date',
                                                 'DB_ID': 'db_id',
                                                 'DETAILS': 'details',
                                                 'FAMILY_PRD_ID': 'family_prd_id',
                                                 'PROCESSING_SITE': 'processing_site'},
                                  'ATTRIBUTE_INFO': {'ACTION_TYPE': {'NULLABLE': False,
                                                                     'ORDER': 7,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': True,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 80},
                                                     'ANNOTATOR': {'NULLABLE': True,
                                                                   'ORDER': 4,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 10},
                                                     'DATE': {'NULLABLE': False,
                                                              'ORDER': 3,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': True,
                                                              'SQL_TYPE': 'DATETIME',
                                                              'WIDTH': 15},
                                                     'DB_ID': {'NULLABLE': False,
                                                               'ORDER': 1,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 10},
                                                     'DETAILS': {'NULLABLE': True,
                                                                 'ORDER': 6,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 200},
                                                     'FAMILY_PRD_ID': {'NULLABLE': False,
                                                                       'ORDER': 2,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': True,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 10},
                                                     'PROCESSING_SITE': {'NULLABLE': True,
                                                                         'ORDER': 5,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 10}},
                                  'ATTRIBUTE_MAP': {'ACTION_TYPE': ('pdbx_family_prd_audit', 'action_type', None, None),
                                                    'ANNOTATOR': ('pdbx_family_prd_audit', 'annotator', None, None),
                                                    'DATE': ('pdbx_family_prd_audit', 'date', None, None),
                                                    'DB_ID': (None, None, 'datablockid()', None),
                                                    'DETAILS': ('pdbx_family_prd_audit', 'details', None, None),
                                                    'FAMILY_PRD_ID': ('pdbx_family_prd_audit', 'family_prd_id', None, None),
                                                    'PROCESSING_SITE': ('pdbx_family_prd_audit',
                                                                        'processing_site',
                                                                        None,
                                                                        None)},
                                  'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID', 'FAMILY_PRD_ID', 'DATE', 'ACTION_TYPE'),
                                                     'TYPE': 'UNIQUE'},
                                              's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                                  'MAP_MERGE_INDICES': {'pdbx_family_prd_audit': {'ATTRIBUTES': ('family_prd_id',
                                                                                                 'date',
                                                                                                 'action_type'),
                                                                                  'TYPE': 'EQUI-JOIN'}},
                                  'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                                  'TABLE_ID': 'PDBX_FAMILY_PRD_AUDIT',
                                  'TABLE_NAME': 'pdbx_family_prd_audit',
                                  'TABLE_TYPE': 'transactional'},
        'PDBX_PRD_AUDIT': {'ATTRIBUTES': {'ACTION_TYPE': 'action_type',
                                          'ANNOTATOR': 'annotator',
                                          'DATE': 'date',
                                          'DB_ID': 'db_id',
                                          'DETAILS': 'details',
                                          'PRD_ID': 'prd_id',
                                          'PROCESSING_SITE': 'processing_site'},
                           'ATTRIBUTE_INFO': {'ACTION_TYPE': {'NULLABLE': False,
                                                              'ORDER': 7,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': True,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 80},
                                              'ANNOTATOR': {'NULLABLE': True,
                                                            'ORDER': 4,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 10},
                                              'DATE': {'NULLABLE': False,
                                                       'ORDER': 3,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': True,
                                                       'SQL_TYPE': 'DATETIME',
                                                       'WIDTH': 15},
                                              'DB_ID': {'NULLABLE': False,
                                                        'ORDER': 1,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': True,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': 10},
                                              'DETAILS': {'NULLABLE': True,
                                                          'ORDER': 6,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 200},
                                              'PRD_ID': {'NULLABLE': False,
                                                         'ORDER': 2,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': True,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 10},
                                              'PROCESSING_SITE': {'NULLABLE': True,
                                                                  'ORDER': 5,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 10}},
                           'ATTRIBUTE_MAP': {'ACTION_TYPE': ('pdbx_prd_audit', 'action_type', None, None),
                                             'ANNOTATOR': ('pdbx_prd_audit', 'annotator', None, None),
                                             'DATE': ('pdbx_prd_audit', 'date', None, None),
                                             'DB_ID': (None, None, 'datablockid()', None),
                                             'DETAILS': ('pdbx_prd_audit', 'details', None, None),
                                             'PRD_ID': ('pdbx_prd_audit', 'prd_id', None, None),
                                             'PROCESSING_SITE': ('pdbx_prd_audit', 'processing_site', None, None)},
                           'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID', 'PRD_ID', 'DATE', 'ACTION_TYPE'), 'TYPE': 'UNIQUE'},
                                       's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                           'MAP_MERGE_INDICES': {'pdbx_prd_audit': {'ATTRIBUTES': ('prd_id', 'date', 'action_type'),
                                                                    'TYPE': 'EQUI-JOIN'}},
                           'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                           'TABLE_ID': 'PDBX_PRD_AUDIT',
                           'TABLE_NAME': 'pdbx_prd_audit',
                           'TABLE_TYPE': 'transactional'},
        'PDBX_REFERENCE_ENTITY_LINK': {'ATTRIBUTES': {'ATOM_ID_1': 'atom_id_1',
                                                      'ATOM_ID_2': 'atom_id_2',
                                                      'COMPONENT_1': 'component_1',
                                                      'COMPONENT_2': 'component_2',
                                                      'COMP_ID_1': 'comp_id_1',
                                                      'COMP_ID_2': 'comp_id_2',
                                                      'DB_ID': 'db_id',
                                                      'DETAILS': 'details',
                                                      'ENTITY_SEQ_NUM_1': 'entity_seq_num_1',
                                                      'ENTITY_SEQ_NUM_2': 'entity_seq_num_2',
                                                      'LINK_CLASS': 'link_class',
                                                      'LINK_ID': 'link_id',
                                                      'NONPOLY_RES_NUM_1': 'nonpoly_res_num_1',
                                                      'NONPOLY_RES_NUM_2': 'nonpoly_res_num_2',
                                                      'PRD_ID': 'prd_id',
                                                      'REF_ENTITY_ID_1': 'ref_entity_id_1',
                                                      'REF_ENTITY_ID_2': 'ref_entity_id_2',
                                                      'VALUE_ORDER': 'value_order'},
                                       'ATTRIBUTE_INFO': {'ATOM_ID_1': {'NULLABLE': True,
                                                                        'ORDER': 11,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 6},
                                                          'ATOM_ID_2': {'NULLABLE': True,
                                                                        'ORDER': 12,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 10},
                                                          'COMPONENT_1': {'NULLABLE': True,
                                                                          'ORDER': 14,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'INT',
                                                                          'WIDTH': 10},
                                                          'COMPONENT_2': {'NULLABLE': True,
                                                                          'ORDER': 15,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'INT',
                                                                          'WIDTH': 10},
                                                          'COMP_ID_1': {'NULLABLE': True,
                                                                        'ORDER': 9,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 10},
                                                          'COMP_ID_2': {'NULLABLE': True,
                                                                        'ORDER': 10,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 10},
                                                          'DB_ID': {'NULLABLE': False,
                                                                    'ORDER': 1,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': True,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 10},
                                                          'DETAILS': {'NULLABLE': True,
                                                                      'ORDER': 4,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 200},
                                                          'ENTITY_SEQ_NUM_1': {'NULLABLE': True,
                                                                               'ORDER': 7,
                                                                               'PRECISION': 0,
                                                                               'PRIMARY_KEY': False,
                                                                               'SQL_TYPE': 'INT',
                                                                               'WIDTH': 10},
                                                          'ENTITY_SEQ_NUM_2': {'NULLABLE': True,
                                                                               'ORDER': 8,
                                                                               'PRECISION': 0,
                                                                               'PRIMARY_KEY': False,
                                                                               'SQL_TYPE': 'INT',
                                                                               'WIDTH': 10},
                                                          'LINK_CLASS': {'NULLABLE': True,
                                                                         'ORDER': 18,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 10},
                                                          'LINK_ID': {'NULLABLE': False,
                                                                      'ORDER': 2,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': True,
                                                                      'SQL_TYPE': 'INT',
                                                                      'WIDTH': 10},
                                                          'NONPOLY_RES_NUM_1': {'NULLABLE': True,
                                                                                'ORDER': 16,
                                                                                'PRECISION': 0,
                                                                                'PRIMARY_KEY': False,
                                                                                'SQL_TYPE': 'VARCHAR',
                                                                                'WIDTH': 10},
                                                          'NONPOLY_RES_NUM_2': {'NULLABLE': True,
                                                                                'ORDER': 17,
                                                                                'PRECISION': 0,
                                                                                'PRIMARY_KEY': False,
                                                                                'SQL_TYPE': 'VARCHAR',
                                                                                'WIDTH': 10},
                                                          'PRD_ID': {'NULLABLE': False,
                                                                     'ORDER': 3,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': True,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10},
                                                          'REF_ENTITY_ID_1': {'NULLABLE': True,
                                                                              'ORDER': 5,
                                                                              'PRECISION': 0,
                                                                              'PRIMARY_KEY': False,
                                                                              'SQL_TYPE': 'VARCHAR',
                                                                              'WIDTH': 10},
                                                          'REF_ENTITY_ID_2': {'NULLABLE': True,
                                                                              'ORDER': 6,
                                                                              'PRECISION': 0,
                                                                              'PRIMARY_KEY': False,
                                                                              'SQL_TYPE': 'VARCHAR',
                                                                              'WIDTH': 10},
                                                          'VALUE_ORDER': {'NULLABLE': True,
                                                                          'ORDER': 13,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': 10}},
                                       'ATTRIBUTE_MAP': {'ATOM_ID_1': ('pdbx_reference_entity_link', 'atom_id_1', None, None),
                                                         'ATOM_ID_2': ('pdbx_reference_entity_link', 'atom_id_2', None, None),
                                                         'COMPONENT_1': ('pdbx_reference_entity_link',
                                                                         'component_1',
                                                                         None,
                                                                         None),
                                                         'COMPONENT_2': ('pdbx_reference_entity_link',
                                                                         'component_2',
                                                                         None,
                                                                         None),
                                                         'COMP_ID_1': ('pdbx_reference_entity_link', 'comp_id_1', None, None),
                                                         'COMP_ID_2': ('pdbx_reference_entity_link', 'comp_id_2', None, None),
                                                         'DB_ID': (None, None, 'datablockid()', None),
                                                         'DETAILS': ('pdbx_reference_entity_link', 'details', None, None),
                                                         'ENTITY_SEQ_NUM_1': ('pdbx_reference_entity_link',
                                                                              'entity_seq_num_1',
                                                                              None,
                                                                              None),
                                                         'ENTITY_SEQ_NUM_2': ('pdbx_reference_entity_link',
                                                                              'entity_seq_num_2',
                                                                              None,
                                                                              None),
                                                         'LINK_CLASS': ('pdbx_reference_entity_link',
                                                                        'link_class',
                                                                        None,
                                                                        None),
                                                         'LINK_ID': ('pdbx_reference_entity_link', 'link_id', None, None),
                                                         'NONPOLY_RES_NUM_1': ('pdbx_reference_entity_link',
                                                                               'nonpoly_res_num_1',
                                                                               None,
                                                                               None),
                                                         'NONPOLY_RES_NUM_2': ('pdbx_reference_entity_link',
                                                                               'nonpoly_res_num_2',
                                                                               None,
                                                                               None),
                                                         'PRD_ID': ('pdbx_reference_entity_link', 'prd_id', None, None),
                                                         'REF_ENTITY_ID_1': ('pdbx_reference_entity_link',
                                                                             'ref_entity_id_1',
                                                                             None,
                                                                             None),
                                                         'REF_ENTITY_ID_2': ('pdbx_reference_entity_link',
                                                                             'ref_entity_id_2',
                                                                             None,
                                                                             None),
                                                         'VALUE_ORDER': ('pdbx_reference_entity_link',
                                                                         'value_order',
                                                                         None,
                                                                         None)},
                                       'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID', 'LINK_ID', 'PRD_ID'), 'TYPE': 'UNIQUE'},
                                                   's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                                       'MAP_MERGE_INDICES': {'pdbx_reference_entity_link': {'ATTRIBUTES': ('link_id',
                                                                                                           'prd_id'),
                                                                                            'TYPE': 'EQUI-JOIN'}},
                                       'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                                       'TABLE_ID': 'PDBX_REFERENCE_ENTITY_LINK',
                                       'TABLE_NAME': 'pdbx_reference_entity_link',
                                       'TABLE_TYPE': 'transactional'},
        'PDBX_REFERENCE_ENTITY_LIST': {'ATTRIBUTES': {'COMPONENT_ID': 'component_id',
                                                      'DB_ID': 'db_id',
                                                      'DETAILS': 'details',
                                                      'PRD_ID': 'prd_id',
                                                      'REF_ENTITY_ID': 'ref_entity_id',
                                                      'TYPE': 'type'},
                                       'ATTRIBUTE_INFO': {'COMPONENT_ID': {'NULLABLE': False,
                                                                           'ORDER': 6,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': True,
                                                                           'SQL_TYPE': 'INT',
                                                                           'WIDTH': 10},
                                                          'DB_ID': {'NULLABLE': False,
                                                                    'ORDER': 1,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': True,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 10},
                                                          'DETAILS': {'NULLABLE': True,
                                                                      'ORDER': 5,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 200},
                                                          'PRD_ID': {'NULLABLE': False,
                                                                     'ORDER': 2,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': True,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10},
                                                          'REF_ENTITY_ID': {'NULLABLE': False,
                                                                            'ORDER': 3,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': True,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 10},
                                                          'TYPE': {'NULLABLE': True,
                                                                   'ORDER': 4,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 80}},
                                       'ATTRIBUTE_MAP': {'COMPONENT_ID': ('pdbx_reference_entity_list',
                                                                          'component_id',
                                                                          None,
                                                                          None),
                                                         'DB_ID': (None, None, 'datablockid()', None),
                                                         'DETAILS': ('pdbx_reference_entity_list', 'details', None, None),
                                                         'PRD_ID': ('pdbx_reference_entity_list', 'prd_id', None, None),
                                                         'REF_ENTITY_ID': ('pdbx_reference_entity_list',
                                                                           'ref_entity_id',
                                                                           None,
                                                                           None),
                                                         'TYPE': ('pdbx_reference_entity_list', 'type', None, None)},
                                       'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID', 'PRD_ID', 'REF_ENTITY_ID', 'COMPONENT_ID'),
                                                          'TYPE': 'UNIQUE'},
                                                   's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                                       'MAP_MERGE_INDICES': {'pdbx_reference_entity_list': {'ATTRIBUTES': ('prd_id',
                                                                                                           'ref_entity_id',
                                                                                                           'component_id'),
                                                                                            'TYPE': 'EQUI-JOIN'}},
                                       'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                                       'TABLE_ID': 'PDBX_REFERENCE_ENTITY_LIST',
                                       'TABLE_NAME': 'pdbx_reference_entity_list',
                                       'TABLE_TYPE': 'transactional'},
        'PDBX_REFERENCE_ENTITY_NONPOLY': {'ATTRIBUTES': {'CHEM_COMP_ID': 'chem_comp_id',
                                                         'DB_ID': 'db_id',
                                                         'DETAILS': 'details',
                                                         'NAME': 'name',
                                                         'PRD_ID': 'prd_id',
                                                         'REF_ENTITY_ID': 'ref_entity_id'},
                                          'ATTRIBUTE_INFO': {'CHEM_COMP_ID': {'NULLABLE': True,
                                                                              'ORDER': 6,
                                                                              'PRECISION': 0,
                                                                              'PRIMARY_KEY': False,
                                                                              'SQL_TYPE': 'VARCHAR',
                                                                              'WIDTH': 10},
                                                             'DB_ID': {'NULLABLE': False,
                                                                       'ORDER': 1,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': True,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 10},
                                                             'DETAILS': {'NULLABLE': True,
                                                                         'ORDER': 4,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 200},
                                                             'NAME': {'NULLABLE': True,
                                                                      'ORDER': 5,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 200},
                                                             'PRD_ID': {'NULLABLE': False,
                                                                        'ORDER': 2,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': True,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 10},
                                                             'REF_ENTITY_ID': {'NULLABLE': False,
                                                                               'ORDER': 3,
                                                                               'PRECISION': 0,
                                                                               'PRIMARY_KEY': True,
                                                                               'SQL_TYPE': 'VARCHAR',
                                                                               'WIDTH': 10}},
                                          'ATTRIBUTE_MAP': {'CHEM_COMP_ID': ('pdbx_reference_entity_nonpoly',
                                                                             'chem_comp_id',
                                                                             None,
                                                                             None),
                                                            'DB_ID': (None, None, 'datablockid()', None),
                                                            'DETAILS': ('pdbx_reference_entity_nonpoly',
                                                                        'details',
                                                                        None,
                                                                        None),
                                                            'NAME': ('pdbx_reference_entity_nonpoly', 'name', None, None),
                                                            'PRD_ID': ('pdbx_reference_entity_nonpoly', 'prd_id', None, None),
                                                            'REF_ENTITY_ID': ('pdbx_reference_entity_nonpoly',
                                                                              'ref_entity_id',
                                                                              None,
                                                                              None)},
                                          'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID', 'PRD_ID', 'REF_ENTITY_ID'),
                                                             'TYPE': 'UNIQUE'},
                                                      's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                                          'MAP_MERGE_INDICES': {'pdbx_reference_entity_nonpoly': {'ATTRIBUTES': ('prd_id',
                                                                                                                 'ref_entity_id'),
                                                                                                  'TYPE': 'EQUI-JOIN'}},
                                          'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                                          'TABLE_ID': 'PDBX_REFERENCE_ENTITY_NONPOLY',
                                          'TABLE_NAME': 'pdbx_reference_entity_nonpoly',
                                          'TABLE_TYPE': 'transactional'},
        'PDBX_REFERENCE_ENTITY_POLY': {'ATTRIBUTES': {'DB_CODE': 'db_code',
                                                      'DB_ID': 'db_id',
                                                      'DB_NAME': 'db_name',
                                                      'PRD_ID': 'prd_id',
                                                      'REF_ENTITY_ID': 'ref_entity_id',
                                                      'TYPE': 'type'},
                                       'ATTRIBUTE_INFO': {'DB_CODE': {'NULLABLE': True,
                                                                      'ORDER': 5,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 200},
                                                          'DB_ID': {'NULLABLE': False,
                                                                    'ORDER': 1,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': True,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 10},
                                                          'DB_NAME': {'NULLABLE': True,
                                                                      'ORDER': 6,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 200},
                                                          'PRD_ID': {'NULLABLE': False,
                                                                     'ORDER': 2,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': True,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10},
                                                          'REF_ENTITY_ID': {'NULLABLE': False,
                                                                            'ORDER': 3,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': True,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 10},
                                                          'TYPE': {'NULLABLE': True,
                                                                   'ORDER': 4,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 80}},
                                       'ATTRIBUTE_MAP': {'DB_CODE': ('pdbx_reference_entity_poly', 'db_code', None, None),
                                                         'DB_ID': (None, None, 'datablockid()', None),
                                                         'DB_NAME': ('pdbx_reference_entity_poly', 'db_name', None, None),
                                                         'PRD_ID': ('pdbx_reference_entity_poly', 'prd_id', None, None),
                                                         'REF_ENTITY_ID': ('pdbx_reference_entity_poly',
                                                                           'ref_entity_id',
                                                                           None,
                                                                           None),
                                                         'TYPE': ('pdbx_reference_entity_poly', 'type', None, None)},
                                       'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID', 'PRD_ID', 'REF_ENTITY_ID'),
                                                          'TYPE': 'UNIQUE'},
                                                   's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                                       'MAP_MERGE_INDICES': {'pdbx_reference_entity_poly': {'ATTRIBUTES': ('prd_id',
                                                                                                           'ref_entity_id'),
                                                                                            'TYPE': 'EQUI-JOIN'}},
                                       'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                                       'TABLE_ID': 'PDBX_REFERENCE_ENTITY_POLY',
                                       'TABLE_NAME': 'pdbx_reference_entity_poly',
                                       'TABLE_TYPE': 'transactional'},
        'PDBX_REFERENCE_ENTITY_POLY_LINK': {'ATTRIBUTES': {'ATOM_ID_1': 'atom_id_1',
                                                           'ATOM_ID_2': 'atom_id_2',
                                                           'COMPONENT_ID': 'component_id',
                                                           'COMP_ID_1': 'comp_id_1',
                                                           'COMP_ID_2': 'comp_id_2',
                                                           'DB_ID': 'db_id',
                                                           'DETAILS': 'details',
                                                           'ENTITY_SEQ_NUM_1': 'entity_seq_num_1',
                                                           'ENTITY_SEQ_NUM_2': 'entity_seq_num_2',
                                                           'INSERT_CODE_1': 'insert_code_1',
                                                           'INSERT_CODE_2': 'insert_code_2',
                                                           'LINK_ID': 'link_id',
                                                           'PRD_ID': 'prd_id',
                                                           'REF_ENTITY_ID': 'ref_entity_id',
                                                           'VALUE_ORDER': 'value_order'},
                                            'ATTRIBUTE_INFO': {'ATOM_ID_1': {'NULLABLE': True,
                                                                             'ORDER': 11,
                                                                             'PRECISION': 0,
                                                                             'PRIMARY_KEY': False,
                                                                             'SQL_TYPE': 'VARCHAR',
                                                                             'WIDTH': 6},
                                                               'ATOM_ID_2': {'NULLABLE': True,
                                                                             'ORDER': 12,
                                                                             'PRECISION': 0,
                                                                             'PRIMARY_KEY': False,
                                                                             'SQL_TYPE': 'VARCHAR',
                                                                             'WIDTH': 10},
                                                               'COMPONENT_ID': {'NULLABLE': False,
                                                                                'ORDER': 6,
                                                                                'PRECISION': 0,
                                                                                'PRIMARY_KEY': True,
                                                                                'SQL_TYPE': 'INT',
                                                                                'WIDTH': 10},
                                                               'COMP_ID_1': {'NULLABLE': True,
                                                                             'ORDER': 9,
                                                                             'PRECISION': 0,
                                                                             'PRIMARY_KEY': False,
                                                                             'SQL_TYPE': 'VARCHAR',
                                                                             'WIDTH': 10},
                                                               'COMP_ID_2': {'NULLABLE': True,
                                                                             'ORDER': 10,
                                                                             'PRECISION': 0,
                                                                             'PRIMARY_KEY': False,
                                                                             'SQL_TYPE': 'VARCHAR',
                                                                             'WIDTH': 10},
                                                               'DB_ID': {'NULLABLE': False,
                                                                         'ORDER': 1,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': True,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 10},
                                                               'DETAILS': {'NULLABLE': True,
                                                                           'ORDER': 4,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'VARCHAR',
                                                                           'WIDTH': 200},
                                                               'ENTITY_SEQ_NUM_1': {'NULLABLE': True,
                                                                                    'ORDER': 7,
                                                                                    'PRECISION': 0,
                                                                                    'PRIMARY_KEY': False,
                                                                                    'SQL_TYPE': 'INT',
                                                                                    'WIDTH': 10},
                                                               'ENTITY_SEQ_NUM_2': {'NULLABLE': True,
                                                                                    'ORDER': 8,
                                                                                    'PRECISION': 0,
                                                                                    'PRIMARY_KEY': False,
                                                                                    'SQL_TYPE': 'INT',
                                                                                    'WIDTH': 10},
                                                               'INSERT_CODE_1': {'NULLABLE': True,
                                                                                 'ORDER': 13,
                                                                                 'PRECISION': 0,
                                                                                 'PRIMARY_KEY': False,
                                                                                 'SQL_TYPE': 'VARCHAR',
                                                                                 'WIDTH': 10},
                                                               'INSERT_CODE_2': {'NULLABLE': True,
                                                                                 'ORDER': 14,
                                                                                 'PRECISION': 0,
                                                                                 'PRIMARY_KEY': False,
                                                                                 'SQL_TYPE': 'VARCHAR',
                                                                                 'WIDTH': 10},
                                                               'LINK_ID': {'NULLABLE': False,
                                                                           'ORDER': 2,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': True,
                                                                           'SQL_TYPE': 'INT',
                                                                           'WIDTH': 10},
                                                               'PRD_ID': {'NULLABLE': False,
                                                                          'ORDER': 3,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': True,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': 10},
                                                               'REF_ENTITY_ID': {'NULLABLE': False,
                                                                                 'ORDER': 5,
                                                                                 'PRECISION': 0,
                                                                                 'PRIMARY_KEY': True,
                                                                                 'SQL_TYPE': 'VARCHAR',
                                                                                 'WIDTH': 10},
                                                               'VALUE_ORDER': {'NULLABLE': True,
                                                                               'ORDER': 15,
                                                                               'PRECISION': 0,
                                                                               'PRIMARY_KEY': False,
                                                                               'SQL_TYPE': 'VARCHAR',
                                                                               'WIDTH': 10}},
                                            'ATTRIBUTE_MAP': {'ATOM_ID_1': ('pdbx_reference_entity_poly_link',
                                                                            'atom_id_1',
                                                                            None,
                                                                            None),
                                                              'ATOM_ID_2': ('pdbx_reference_entity_poly_link',
                                                                            'atom_id_2',
                                                                            None,
                                                                            None),
                                                              'COMPONENT_ID': ('pdbx_reference_entity_poly_link',
                                                                               'component_id',
                                                                               None,
                                                                               None),
                                                              'COMP_ID_1': ('pdbx_reference_entity_poly_link',
                                                                            'comp_id_1',
                                                                            None,
                                                                            None),
                                                              'COMP_ID_2': ('pdbx_reference_entity_poly_link',
                                                                            'comp_id_2',
                                                                            None,
                                                                            None),
                                                              'DB_ID': (None, None, 'datablockid()', None),
                                                              'DETAILS': ('pdbx_reference_entity_poly_link',
                                                                          'details',
                                                                          None,
                                                                          None),
                                                              'ENTITY_SEQ_NUM_1': ('pdbx_reference_entity_poly_link',
                                                                                   'entity_seq_num_1',
                                                                                   None,
                                                                                   None),
                                                              'ENTITY_SEQ_NUM_2': ('pdbx_reference_entity_poly_link',
                                                                                   'entity_seq_num_2',
                                                                                   None,
                                                                                   None),
                                                              'INSERT_CODE_1': ('pdbx_reference_entity_poly_link',
                                                                                'insert_code_1',
                                                                                None,
                                                                                None),
                                                              'INSERT_CODE_2': ('pdbx_reference_entity_poly_link',
                                                                                'insert_code_2',
                                                                                None,
                                                                                None),
                                                              'LINK_ID': ('pdbx_reference_entity_poly_link',
                                                                          'link_id',
                                                                          None,
                                                                          None),
                                                              'PRD_ID': ('pdbx_reference_entity_poly_link',
                                                                         'prd_id',
                                                                         None,
                                                                         None),
                                                              'REF_ENTITY_ID': ('pdbx_reference_entity_poly_link',
                                                                                'ref_entity_id',
                                                                                None,
                                                                                None),
                                                              'VALUE_ORDER': ('pdbx_reference_entity_poly_link',
                                                                              'value_order',
                                                                              None,
                                                                              None)},
                                            'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID',
                                                                              'LINK_ID',
                                                                              'PRD_ID',
                                                                              'REF_ENTITY_ID',
                                                                              'COMPONENT_ID'),
                                                               'TYPE': 'UNIQUE'},
                                                        's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                                            'MAP_MERGE_INDICES': {'pdbx_reference_entity_poly_link': {'ATTRIBUTES': ('link_id',
                                                                                                                     'prd_id',
                                                                                                                     'ref_entity_id',
                                                                                                                     'component_id'),
                                                                                                      'TYPE': 'EQUI-JOIN'}},
                                            'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                                            'TABLE_ID': 'PDBX_REFERENCE_ENTITY_POLY_LINK',
                                            'TABLE_NAME': 'pdbx_reference_entity_poly_link',
                                            'TABLE_TYPE': 'transactional'},
        'PDBX_REFERENCE_ENTITY_POLY_SEQ': {'ATTRIBUTES': {'DB_ID': 'db_id',
                                                          'HETERO': 'hetero',
                                                          'MON_ID': 'mon_id',
                                                          'NUM': 'num',
                                                          'OBSERVED': 'observed',
                                                          'PARENT_MON_ID': 'parent_mon_id',
                                                          'PRD_ID': 'prd_id',
                                                          'REF_ENTITY_ID': 'ref_entity_id'},
                                           'ATTRIBUTE_INFO': {'DB_ID': {'NULLABLE': False,
                                                                        'ORDER': 1,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': True,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 10},
                                                              'HETERO': {'NULLABLE': False,
                                                                         'ORDER': 8,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': True,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 10},
                                                              'MON_ID': {'NULLABLE': False,
                                                                         'ORDER': 4,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': True,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 10},
                                                              'NUM': {'NULLABLE': False,
                                                                      'ORDER': 6,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': True,
                                                                      'SQL_TYPE': 'INT',
                                                                      'WIDTH': 10},
                                                              'OBSERVED': {'NULLABLE': True,
                                                                           'ORDER': 7,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'VARCHAR',
                                                                           'WIDTH': 10},
                                                              'PARENT_MON_ID': {'NULLABLE': True,
                                                                                'ORDER': 5,
                                                                                'PRECISION': 0,
                                                                                'PRIMARY_KEY': False,
                                                                                'SQL_TYPE': 'VARCHAR',
                                                                                'WIDTH': 10},
                                                              'PRD_ID': {'NULLABLE': False,
                                                                         'ORDER': 2,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': True,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 10},
                                                              'REF_ENTITY_ID': {'NULLABLE': False,
                                                                                'ORDER': 3,
                                                                                'PRECISION': 0,
                                                                                'PRIMARY_KEY': True,
                                                                                'SQL_TYPE': 'VARCHAR',
                                                                                'WIDTH': 10}},
                                           'ATTRIBUTE_MAP': {'DB_ID': (None, None, 'datablockid()', None),
                                                             'HETERO': ('pdbx_reference_entity_poly_seq',
                                                                        'hetero',
                                                                        None,
                                                                        None),
                                                             'MON_ID': ('pdbx_reference_entity_poly_seq',
                                                                        'mon_id',
                                                                        None,
                                                                        None),
                                                             'NUM': ('pdbx_reference_entity_poly_seq', 'num', None, None),
                                                             'OBSERVED': ('pdbx_reference_entity_poly_seq',
                                                                          'observed',
                                                                          None,
                                                                          None),
                                                             'PARENT_MON_ID': ('pdbx_reference_entity_poly_seq',
                                                                               'parent_mon_id',
                                                                               None,
                                                                               None),
                                                             'PRD_ID': ('pdbx_reference_entity_poly_seq',
                                                                        'prd_id',
                                                                        None,
                                                                        None),
                                                             'REF_ENTITY_ID': ('pdbx_reference_entity_poly_seq',
                                                                               'ref_entity_id',
                                                                               None,
                                                                               None)},
                                           'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID',
                                                                             'PRD_ID',
                                                                             'REF_ENTITY_ID',
                                                                             'MON_ID',
                                                                             'NUM',
                                                                             'HETERO'),
                                                              'TYPE': 'UNIQUE'},
                                                       's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                                           'MAP_MERGE_INDICES': {'pdbx_reference_entity_poly_seq': {'ATTRIBUTES': ('prd_id',
                                                                                                                   'ref_entity_id',
                                                                                                                   'mon_id',
                                                                                                                   'num',
                                                                                                                   'hetero'),
                                                                                                    'TYPE': 'EQUI-JOIN'}},
                                           'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                                           'TABLE_ID': 'PDBX_REFERENCE_ENTITY_POLY_SEQ',
                                           'TABLE_NAME': 'pdbx_reference_entity_poly_seq',
                                           'TABLE_TYPE': 'transactional'},
        'PDBX_REFERENCE_ENTITY_SEQUENCE': {'ATTRIBUTES': {'DB_ID': 'db_id',
                                                          'NRP_FLAG': 'NRP_flag',
                                                          'ONE_LETTER_CODES': 'one_letter_codes',
                                                          'PRD_ID': 'prd_id',
                                                          'REF_ENTITY_ID': 'ref_entity_id',
                                                          'TYPE': 'type'},
                                           'ATTRIBUTE_INFO': {'DB_ID': {'NULLABLE': False,
                                                                        'ORDER': 1,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': True,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 10},
                                                              'NRP_FLAG': {'NULLABLE': True,
                                                                           'ORDER': 5,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'VARCHAR',
                                                                           'WIDTH': 10},
                                                              'ONE_LETTER_CODES': {'NULLABLE': True,
                                                                                   'ORDER': 6,
                                                                                   'PRECISION': 0,
                                                                                   'PRIMARY_KEY': False,
                                                                                   'SQL_TYPE': 'VARCHAR',
                                                                                   'WIDTH': 80},
                                                              'PRD_ID': {'NULLABLE': False,
                                                                         'ORDER': 2,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': True,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 10},
                                                              'REF_ENTITY_ID': {'NULLABLE': False,
                                                                                'ORDER': 3,
                                                                                'PRECISION': 0,
                                                                                'PRIMARY_KEY': True,
                                                                                'SQL_TYPE': 'VARCHAR',
                                                                                'WIDTH': 10},
                                                              'TYPE': {'NULLABLE': True,
                                                                       'ORDER': 4,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 80}},
                                           'ATTRIBUTE_MAP': {'DB_ID': (None, None, 'datablockid()', None),
                                                             'NRP_FLAG': ('pdbx_reference_entity_sequence',
                                                                          'NRP_flag',
                                                                          None,
                                                                          None),
                                                             'ONE_LETTER_CODES': ('pdbx_reference_entity_sequence',
                                                                                  'one_letter_codes',
                                                                                  None,
                                                                                  None),
                                                             'PRD_ID': ('pdbx_reference_entity_sequence',
                                                                        'prd_id',
                                                                        None,
                                                                        None),
                                                             'REF_ENTITY_ID': ('pdbx_reference_entity_sequence',
                                                                               'ref_entity_id',
                                                                               None,
                                                                               None),
                                                             'TYPE': ('pdbx_reference_entity_sequence', 'type', None, None)},
                                           'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID', 'PRD_ID', 'REF_ENTITY_ID'),
                                                              'TYPE': 'UNIQUE'},
                                                       's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                                           'MAP_MERGE_INDICES': {'pdbx_reference_entity_sequence': {'ATTRIBUTES': ('prd_id',
                                                                                                                   'ref_entity_id'),
                                                                                                    'TYPE': 'EQUI-JOIN'}},
                                           'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                                           'TABLE_ID': 'PDBX_REFERENCE_ENTITY_SEQUENCE',
                                           'TABLE_NAME': 'pdbx_reference_entity_sequence',
                                           'TABLE_TYPE': 'transactional'},
        'PDBX_REFERENCE_ENTITY_SRC_NAT': {'ATTRIBUTES': {'ATCC': 'atcc',
                                                         'DB_CODE': 'db_code',
                                                         'DB_ID': 'db_id',
                                                         'DB_NAME': 'db_name',
                                                         'ORDINAL': 'ordinal',
                                                         'ORGANISM_SCIENTIFIC': 'organism_scientific',
                                                         'PRD_ID': 'prd_id',
                                                         'REF_ENTITY_ID': 'ref_entity_id',
                                                         'SOURCE': 'source',
                                                         'SOURCE_ID': 'source_id',
                                                         'STRAIN': 'strain',
                                                         'TAXID': 'taxid'},
                                          'ATTRIBUTE_INFO': {'ATCC': {'NULLABLE': True,
                                                                      'ORDER': 8,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 200},
                                                             'DB_CODE': {'NULLABLE': True,
                                                                         'ORDER': 9,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 200},
                                                             'DB_ID': {'NULLABLE': False,
                                                                       'ORDER': 1,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': True,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 10},
                                                             'DB_NAME': {'NULLABLE': True,
                                                                         'ORDER': 10,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 200},
                                                             'ORDINAL': {'NULLABLE': False,
                                                                         'ORDER': 4,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': True,
                                                                         'SQL_TYPE': 'INT',
                                                                         'WIDTH': 10},
                                                             'ORGANISM_SCIENTIFIC': {'NULLABLE': True,
                                                                                     'ORDER': 5,
                                                                                     'PRECISION': 0,
                                                                                     'PRIMARY_KEY': False,
                                                                                     'SQL_TYPE': 'VARCHAR',
                                                                                     'WIDTH': 200},
                                                             'PRD_ID': {'NULLABLE': False,
                                                                        'ORDER': 2,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': True,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 10},
                                                             'REF_ENTITY_ID': {'NULLABLE': False,
                                                                               'ORDER': 3,
                                                                               'PRECISION': 0,
                                                                               'PRIMARY_KEY': True,
                                                                               'SQL_TYPE': 'VARCHAR',
                                                                               'WIDTH': 10},
                                                             'SOURCE': {'NULLABLE': True,
                                                                        'ORDER': 11,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 200},
                                                             'SOURCE_ID': {'NULLABLE': True,
                                                                           'ORDER': 12,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'VARCHAR',
                                                                           'WIDTH': 200},
                                                             'STRAIN': {'NULLABLE': True,
                                                                        'ORDER': 6,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 200},
                                                             'TAXID': {'NULLABLE': True,
                                                                       'ORDER': 7,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 200}},
                                          'ATTRIBUTE_MAP': {'ATCC': ('pdbx_reference_entity_src_nat', 'atcc', None, None),
                                                            'DB_CODE': ('pdbx_reference_entity_src_nat',
                                                                        'db_code',
                                                                        None,
                                                                        None),
                                                            'DB_ID': (None, None, 'datablockid()', None),
                                                            'DB_NAME': ('pdbx_reference_entity_src_nat',
                                                                        'db_name',
                                                                        None,
                                                                        None),
                                                            'ORDINAL': ('pdbx_reference_entity_src_nat',
                                                                        'ordinal',
                                                                        None,
                                                                        None),
                                                            'ORGANISM_SCIENTIFIC': ('pdbx_reference_entity_src_nat',
                                                                                    'organism_scientific',
                                                                                    None,
                                                                                    None),
                                                            'PRD_ID': ('pdbx_reference_entity_src_nat', 'prd_id', None, None),
                                                            'REF_ENTITY_ID': ('pdbx_reference_entity_src_nat',
                                                                              'ref_entity_id',
                                                                              None,
                                                                              None),
                                                            'SOURCE': ('pdbx_reference_entity_src_nat', 'source', None, None),
                                                            'SOURCE_ID': ('pdbx_reference_entity_src_nat',
                                                                          'source_id',
                                                                          None,
                                                                          None),
                                                            'STRAIN': ('pdbx_reference_entity_src_nat', 'strain', None, None),
                                                            'TAXID': ('pdbx_reference_entity_src_nat', 'taxid', None, None)},
                                          'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID', 'PRD_ID', 'REF_ENTITY_ID', 'ORDINAL'),
                                                             'TYPE': 'UNIQUE'},
                                                      's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                                          'MAP_MERGE_INDICES': {'pdbx_reference_entity_src_nat': {'ATTRIBUTES': ('prd_id',
                                                                                                                 'ref_entity_id',
                                                                                                                 'ordinal'),
                                                                                                  'TYPE': 'EQUI-JOIN'}},
                                          'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                                          'TABLE_ID': 'PDBX_REFERENCE_ENTITY_SRC_NAT',
                                          'TABLE_NAME': 'pdbx_reference_entity_src_nat',
                                          'TABLE_TYPE': 'transactional'},
        'PDBX_REFERENCE_ENTITY_SUBCOMPONENTS': {'ATTRIBUTES': {'CHEM_COMP_ID': 'chem_comp_id',
                                                               'DB_ID': 'db_id',
                                                               'PRD_ID': 'prd_id',
                                                               'SEQ': 'seq'},
                                                'ATTRIBUTE_INFO': {'CHEM_COMP_ID': {'NULLABLE': True,
                                                                                    'ORDER': 4,
                                                                                    'PRECISION': 0,
                                                                                    'PRIMARY_KEY': False,
                                                                                    'SQL_TYPE': 'VARCHAR',
                                                                                    'WIDTH': 10},
                                                                   'DB_ID': {'NULLABLE': False,
                                                                             'ORDER': 1,
                                                                             'PRECISION': 0,
                                                                             'PRIMARY_KEY': True,
                                                                             'SQL_TYPE': 'VARCHAR',
                                                                             'WIDTH': 10},
                                                                   'PRD_ID': {'NULLABLE': False,
                                                                              'ORDER': 2,
                                                                              'PRECISION': 0,
                                                                              'PRIMARY_KEY': True,
                                                                              'SQL_TYPE': 'VARCHAR',
                                                                              'WIDTH': 10},
                                                                   'SEQ': {'NULLABLE': False,
                                                                           'ORDER': 3,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': True,
                                                                           'SQL_TYPE': 'VARCHAR',
                                                                           'WIDTH': 200}},
                                                'ATTRIBUTE_MAP': {'CHEM_COMP_ID': ('pdbx_reference_entity_subcomponents',
                                                                                   'chem_comp_id',
                                                                                   None,
                                                                                   None),
                                                                  'DB_ID': (None, None, 'datablockid()', None),
                                                                  'PRD_ID': ('pdbx_reference_entity_subcomponents',
                                                                             'prd_id',
                                                                             None,
                                                                             None),
                                                                  'SEQ': ('pdbx_reference_entity_subcomponents',
                                                                          'seq',
                                                                          None,
                                                                          None)},
                                                'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID', 'PRD_ID', 'SEQ'), 'TYPE': 'UNIQUE'},
                                                            's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                                                'MAP_MERGE_INDICES': {'pdbx_reference_entity_subcomponents': {'ATTRIBUTES': ('prd_id',
                                                                                                                             'seq'),
                                                                                                              'TYPE': 'EQUI-JOIN'}},
                                                'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                                                'TABLE_ID': 'PDBX_REFERENCE_ENTITY_SUBCOMPONENTS',
                                                'TABLE_NAME': 'pdbx_reference_entity_subcomponents',
                                                'TABLE_TYPE': 'transactional'},
        'PDBX_REFERENCE_MOLECULE': {'ATTRIBUTES': {'CHEM_COMP_ID': 'chem_comp_id',
                                                   'CLASS': 'class',
                                                   'CLASS_EVIDENCE_CODE': 'class_evidence_code',
                                                   'COMPOUND_DETAILS': 'compound_details',
                                                   'DB_ID': 'db_id',
                                                   'DESCRIPTION': 'description',
                                                   'FORMULA': 'formula',
                                                   'FORMULA_WEIGHT': 'formula_weight',
                                                   'NAME': 'name',
                                                   'PRD_ID': 'prd_id',
                                                   'RELEASE_STATUS': 'release_status',
                                                   'REPLACED_BY': 'replaced_by',
                                                   'REPLACES': 'replaces',
                                                   'REPRESENTATIVE_PDB_ID_CODE': 'representative_PDB_id_code',
                                                   'REPRESENT_AS': 'represent_as',
                                                   'TYPE': 'type',
                                                   'TYPE_EVIDENCE_CODE': 'type_evidence_code'},
                                    'ATTRIBUTE_INFO': {'CHEM_COMP_ID': {'NULLABLE': True,
                                                                        'ORDER': 11,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 10},
                                                       'CLASS': {'NULLABLE': True,
                                                                 'ORDER': 7,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 200},
                                                       'CLASS_EVIDENCE_CODE': {'NULLABLE': True,
                                                                               'ORDER': 8,
                                                                               'PRECISION': 0,
                                                                               'PRIMARY_KEY': False,
                                                                               'SQL_TYPE': 'VARCHAR',
                                                                               'WIDTH': 200},
                                                       'COMPOUND_DETAILS': {'NULLABLE': True,
                                                                            'ORDER': 12,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 4095},
                                                       'DB_ID': {'NULLABLE': False,
                                                                 'ORDER': 1,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': True,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                                       'DESCRIPTION': {'NULLABLE': True,
                                                                       'ORDER': 13,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 4095},
                                                       'FORMULA': {'NULLABLE': True,
                                                                   'ORDER': 4,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 200},
                                                       'FORMULA_WEIGHT': {'NULLABLE': True,
                                                                          'ORDER': 3,
                                                                          'PRECISION': 6,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'FLOAT',
                                                                          'WIDTH': 10},
                                                       'NAME': {'NULLABLE': True,
                                                                'ORDER': 9,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 1023},
                                                       'PRD_ID': {'NULLABLE': False,
                                                                  'ORDER': 2,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': True,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 10},
                                                       'RELEASE_STATUS': {'NULLABLE': True,
                                                                          'ORDER': 15,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': 80},
                                                       'REPLACED_BY': {'NULLABLE': True,
                                                                       'ORDER': 17,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 80},
                                                       'REPLACES': {'NULLABLE': True,
                                                                    'ORDER': 16,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 80},
                                                       'REPRESENTATIVE_PDB_ID_CODE': {'NULLABLE': True,
                                                                                      'ORDER': 14,
                                                                                      'PRECISION': 0,
                                                                                      'PRIMARY_KEY': False,
                                                                                      'SQL_TYPE': 'VARCHAR',
                                                                                      'WIDTH': 10},
                                                       'REPRESENT_AS': {'NULLABLE': True,
                                                                        'ORDER': 10,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 80},
                                                       'TYPE': {'NULLABLE': True,
                                                                'ORDER': 5,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 80},
                                                       'TYPE_EVIDENCE_CODE': {'NULLABLE': True,
                                                                              'ORDER': 6,
                                                                              'PRECISION': 0,
                                                                              'PRIMARY_KEY': False,
                                                                              'SQL_TYPE': 'VARCHAR',
                                                                              'WIDTH': 200}},
                                    'ATTRIBUTE_MAP': {'CHEM_COMP_ID': ('pdbx_reference_molecule', 'chem_comp_id', None, None),
                                                      'CLASS': ('pdbx_reference_molecule', 'class', None, None),
                                                      'CLASS_EVIDENCE_CODE': ('pdbx_reference_molecule',
                                                                              'class_evidence_code',
                                                                              None,
                                                                              None),
                                                      'COMPOUND_DETAILS': ('pdbx_reference_molecule',
                                                                           'compound_details',
                                                                           None,
                                                                           None),
                                                      'DB_ID': (None, None, 'datablockid()', None),
                                                      'DESCRIPTION': ('pdbx_reference_molecule', 'description', None, None),
                                                      'FORMULA': ('pdbx_reference_molecule', 'formula', None, None),
                                                      'FORMULA_WEIGHT': ('pdbx_reference_molecule',
                                                                         'formula_weight',
                                                                         None,
                                                                         None),
                                                      'NAME': ('pdbx_reference_molecule', 'name', None, None),
                                                      'PRD_ID': ('pdbx_reference_molecule', 'prd_id', None, None),
                                                      'RELEASE_STATUS': ('pdbx_reference_molecule',
                                                                         'release_status',
                                                                         None,
                                                                         None),
                                                      'REPLACED_BY': ('pdbx_reference_molecule', 'replaced_by', None, None),
                                                      'REPLACES': ('pdbx_reference_molecule', 'replaces', None, None),
                                                      'REPRESENTATIVE_PDB_ID_CODE': ('pdbx_reference_molecule',
                                                                                     'representative_PDB_id_code',
                                                                                     None,
                                                                                     None),
                                                      'REPRESENT_AS': ('pdbx_reference_molecule', 'represent_as', None, None),
                                                      'TYPE': ('pdbx_reference_molecule', 'type', None, None),
                                                      'TYPE_EVIDENCE_CODE': ('pdbx_reference_molecule',
                                                                             'type_evidence_code',
                                                                             None,
                                                                             None)},
                                    'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID', 'PRD_ID'), 'TYPE': 'UNIQUE'},
                                                's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                                    'MAP_MERGE_INDICES': {'pdbx_reference_molecule': {'ATTRIBUTES': ('prd_id',),
                                                                                      'TYPE': 'EQUI-JOIN'}},
                                    'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                                    'TABLE_ID': 'PDBX_REFERENCE_MOLECULE',
                                    'TABLE_NAME': 'pdbx_reference_molecule',
                                    'TABLE_TYPE': 'transactional'},
        'PDBX_REFERENCE_MOLECULE_ANNOTATION': {'ATTRIBUTES': {'CHEM_COMP_ID': 'chem_comp_id',
                                                              'DB_ID': 'db_id',
                                                              'FAMILY_PRD_ID': 'family_prd_id',
                                                              'ORDINAL': 'ordinal',
                                                              'PRD_ID': 'prd_id',
                                                              'SOURCE': 'source',
                                                              'SUPPORT': 'support',
                                                              'TEXT': 'text',
                                                              'TYPE': 'type'},
                                               'ATTRIBUTE_INFO': {'CHEM_COMP_ID': {'NULLABLE': True,
                                                                                   'ORDER': 9,
                                                                                   'PRECISION': 0,
                                                                                   'PRIMARY_KEY': False,
                                                                                   'SQL_TYPE': 'VARCHAR',
                                                                                   'WIDTH': 10},
                                                                  'DB_ID': {'NULLABLE': False,
                                                                            'ORDER': 1,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': True,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 10},
                                                                  'FAMILY_PRD_ID': {'NULLABLE': False,
                                                                                    'ORDER': 2,
                                                                                    'PRECISION': 0,
                                                                                    'PRIMARY_KEY': True,
                                                                                    'SQL_TYPE': 'VARCHAR',
                                                                                    'WIDTH': 10},
                                                                  'ORDINAL': {'NULLABLE': False,
                                                                              'ORDER': 4,
                                                                              'PRECISION': 0,
                                                                              'PRIMARY_KEY': True,
                                                                              'SQL_TYPE': 'INT',
                                                                              'WIDTH': 10},
                                                                  'PRD_ID': {'NULLABLE': True,
                                                                             'ORDER': 3,
                                                                             'PRECISION': 0,
                                                                             'PRIMARY_KEY': False,
                                                                             'SQL_TYPE': 'VARCHAR',
                                                                             'WIDTH': 10},
                                                                  'SOURCE': {'NULLABLE': True,
                                                                             'ORDER': 8,
                                                                             'PRECISION': 0,
                                                                             'PRIMARY_KEY': False,
                                                                             'SQL_TYPE': 'VARCHAR',
                                                                             'WIDTH': 200},
                                                                  'SUPPORT': {'NULLABLE': True,
                                                                              'ORDER': 7,
                                                                              'PRECISION': 0,
                                                                              'PRIMARY_KEY': False,
                                                                              'SQL_TYPE': 'VARCHAR',
                                                                              'WIDTH': 200},
                                                                  'TEXT': {'NULLABLE': True,
                                                                           'ORDER': 5,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'VARCHAR',
                                                                           'WIDTH': 4095},
                                                                  'TYPE': {'NULLABLE': True,
                                                                           'ORDER': 6,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'VARCHAR',
                                                                           'WIDTH': 80}},
                                               'ATTRIBUTE_MAP': {'CHEM_COMP_ID': ('pdbx_reference_molecule_annotation',
                                                                                  'chem_comp_id',
                                                                                  None,
                                                                                  None),
                                                                 'DB_ID': (None, None, 'datablockid()', None),
                                                                 'FAMILY_PRD_ID': ('pdbx_reference_molecule_annotation',
                                                                                   'family_prd_id',
                                                                                   None,
                                                                                   None),
                                                                 'ORDINAL': ('pdbx_reference_molecule_annotation',
                                                                             'ordinal',
                                                                             None,
                                                                             None),
                                                                 'PRD_ID': ('pdbx_reference_molecule_annotation',
                                                                            'prd_id',
                                                                            None,
                                                                            None),
                                                                 'SOURCE': ('pdbx_reference_molecule_annotation',
                                                                            'source',
                                                                            None,
                                                                            None),
                                                                 'SUPPORT': ('pdbx_reference_molecule_annotation',
                                                                             'support',
                                                                             None,
                                                                             None),
                                                                 'TEXT': ('pdbx_reference_molecule_annotation',
                                                                          'text',
                                                                          None,
                                                                          None),
                                                                 'TYPE': ('pdbx_reference_molecule_annotation',
                                                                          'type',
                                                                          None,
                                                                          None)},
                                               'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID', 'FAMILY_PRD_ID', 'ORDINAL'),
                                                                  'TYPE': 'UNIQUE'},
                                                           's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                                               'MAP_MERGE_INDICES': {'pdbx_reference_molecule_annotation': {'ATTRIBUTES': ('family_prd_id',
                                                                                                                           'ordinal'),
                                                                                                            'TYPE': 'EQUI-JOIN'}},
                                               'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                                               'TABLE_ID': 'PDBX_REFERENCE_MOLECULE_ANNOTATION',
                                               'TABLE_NAME': 'pdbx_reference_molecule_annotation',
                                               'TABLE_TYPE': 'transactional'},
        'PDBX_REFERENCE_MOLECULE_DETAILS': {'ATTRIBUTES': {'DB_ID': 'db_id',
                                                           'FAMILY_PRD_ID': 'family_prd_id',
                                                           'ORDINAL': 'ordinal',
                                                           'PRD_ID': 'prd_id',
                                                           'SOURCE': 'source',
                                                           'SOURCE_ID': 'source_id',
                                                           'TEXT': 'text'},
                                            'ATTRIBUTE_INFO': {'DB_ID': {'NULLABLE': False,
                                                                         'ORDER': 1,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': True,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 10},
                                                               'FAMILY_PRD_ID': {'NULLABLE': False,
                                                                                 'ORDER': 2,
                                                                                 'PRECISION': 0,
                                                                                 'PRIMARY_KEY': True,
                                                                                 'SQL_TYPE': 'VARCHAR',
                                                                                 'WIDTH': 10},
                                                               'ORDINAL': {'NULLABLE': False,
                                                                           'ORDER': 4,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': True,
                                                                           'SQL_TYPE': 'INT',
                                                                           'WIDTH': 10},
                                                               'PRD_ID': {'NULLABLE': True,
                                                                          'ORDER': 3,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': 10},
                                                               'SOURCE': {'NULLABLE': True,
                                                                          'ORDER': 5,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': 200},
                                                               'SOURCE_ID': {'NULLABLE': True,
                                                                             'ORDER': 6,
                                                                             'PRECISION': 0,
                                                                             'PRIMARY_KEY': False,
                                                                             'SQL_TYPE': 'VARCHAR',
                                                                             'WIDTH': 200},
                                                               'TEXT': {'NULLABLE': True,
                                                                        'ORDER': 7,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 30000}},
                                            'ATTRIBUTE_MAP': {'DB_ID': (None, None, 'datablockid()', None),
                                                              'FAMILY_PRD_ID': ('pdbx_reference_molecule_details',
                                                                                'family_prd_id',
                                                                                None,
                                                                                None),
                                                              'ORDINAL': ('pdbx_reference_molecule_details',
                                                                          'ordinal',
                                                                          None,
                                                                          None),
                                                              'PRD_ID': ('pdbx_reference_molecule_details',
                                                                         'prd_id',
                                                                         None,
                                                                         None),
                                                              'SOURCE': ('pdbx_reference_molecule_details',
                                                                         'source',
                                                                         None,
                                                                         None),
                                                              'SOURCE_ID': ('pdbx_reference_molecule_details',
                                                                            'source_id',
                                                                            None,
                                                                            None),
                                                              'TEXT': ('pdbx_reference_molecule_details', 'text', None, None)},
                                            'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID', 'FAMILY_PRD_ID', 'ORDINAL'),
                                                               'TYPE': 'UNIQUE'},
                                                        's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                                            'MAP_MERGE_INDICES': {'pdbx_reference_molecule_details': {'ATTRIBUTES': ('family_prd_id',
                                                                                                                     'ordinal'),
                                                                                                      'TYPE': 'EQUI-JOIN'}},
                                            'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                                            'TABLE_ID': 'PDBX_REFERENCE_MOLECULE_DETAILS',
                                            'TABLE_NAME': 'pdbx_reference_molecule_details',
                                            'TABLE_TYPE': 'transactional'},
        'PDBX_REFERENCE_MOLECULE_FAMILY': {'ATTRIBUTES': {'DB_ID': 'db_id',
                                                          'FAMILY_PRD_ID': 'family_prd_id',
                                                          'NAME': 'name',
                                                          'RELEASE_STATUS': 'release_status',
                                                          'REPLACED_BY': 'replaced_by',
                                                          'REPLACES': 'replaces'},
                                           'ATTRIBUTE_INFO': {'DB_ID': {'NULLABLE': False,
                                                                        'ORDER': 1,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': True,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 10},
                                                              'FAMILY_PRD_ID': {'NULLABLE': False,
                                                                                'ORDER': 2,
                                                                                'PRECISION': 0,
                                                                                'PRIMARY_KEY': True,
                                                                                'SQL_TYPE': 'VARCHAR',
                                                                                'WIDTH': 10},
                                                              'NAME': {'NULLABLE': True,
                                                                       'ORDER': 3,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 200},
                                                              'RELEASE_STATUS': {'NULLABLE': True,
                                                                                 'ORDER': 4,
                                                                                 'PRECISION': 0,
                                                                                 'PRIMARY_KEY': False,
                                                                                 'SQL_TYPE': 'VARCHAR',
                                                                                 'WIDTH': 80},
                                                              'REPLACED_BY': {'NULLABLE': True,
                                                                              'ORDER': 6,
                                                                              'PRECISION': 0,
                                                                              'PRIMARY_KEY': False,
                                                                              'SQL_TYPE': 'VARCHAR',
                                                                              'WIDTH': 80},
                                                              'REPLACES': {'NULLABLE': True,
                                                                           'ORDER': 5,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'VARCHAR',
                                                                           'WIDTH': 80}},
                                           'ATTRIBUTE_MAP': {'DB_ID': (None, None, 'datablockid()', None),
                                                             'FAMILY_PRD_ID': ('pdbx_reference_molecule_family',
                                                                               'family_prd_id',
                                                                               None,
                                                                               None),
                                                             'NAME': ('pdbx_reference_molecule_family', 'name', None, None),
                                                             'RELEASE_STATUS': ('pdbx_reference_molecule_family',
                                                                                'release_status',
                                                                                None,
                                                                                None),
                                                             'REPLACED_BY': ('pdbx_reference_molecule_family',
                                                                             'replaced_by',
                                                                             None,
                                                                             None),
                                                             'REPLACES': ('pdbx_reference_molecule_family',
                                                                          'replaces',
                                                                          None,
                                                                          None)},
                                           'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID', 'FAMILY_PRD_ID'), 'TYPE': 'UNIQUE'},
                                                       's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                                           'MAP_MERGE_INDICES': {'pdbx_reference_molecule_family': {'ATTRIBUTES': ('family_prd_id',),
                                                                                                    'TYPE': 'EQUI-JOIN'}},
                                           'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                                           'TABLE_ID': 'PDBX_REFERENCE_MOLECULE_FAMILY',
                                           'TABLE_NAME': 'pdbx_reference_molecule_family',
                                           'TABLE_TYPE': 'transactional'},
        'PDBX_REFERENCE_MOLECULE_FEATURES': {'ATTRIBUTES': {'CHEM_COMP_ID': 'chem_comp_id',
                                                            'DB_ID': 'db_id',
                                                            'FAMILY_PRD_ID': 'family_prd_id',
                                                            'ORDINAL': 'ordinal',
                                                            'PRD_ID': 'prd_id',
                                                            'SOURCE': 'source',
                                                            'SOURCE_ORDINAL': 'source_ordinal',
                                                            'TYPE': 'type',
                                                            'VALUE': 'value'},
                                             'ATTRIBUTE_INFO': {'CHEM_COMP_ID': {'NULLABLE': True,
                                                                                 'ORDER': 9,
                                                                                 'PRECISION': 0,
                                                                                 'PRIMARY_KEY': False,
                                                                                 'SQL_TYPE': 'VARCHAR',
                                                                                 'WIDTH': 10},
                                                                'DB_ID': {'NULLABLE': False,
                                                                          'ORDER': 1,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': True,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': 10},
                                                                'FAMILY_PRD_ID': {'NULLABLE': False,
                                                                                  'ORDER': 2,
                                                                                  'PRECISION': 0,
                                                                                  'PRIMARY_KEY': True,
                                                                                  'SQL_TYPE': 'VARCHAR',
                                                                                  'WIDTH': 10},
                                                                'ORDINAL': {'NULLABLE': False,
                                                                            'ORDER': 4,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': True,
                                                                            'SQL_TYPE': 'INT',
                                                                            'WIDTH': 10},
                                                                'PRD_ID': {'NULLABLE': False,
                                                                           'ORDER': 3,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': True,
                                                                           'SQL_TYPE': 'VARCHAR',
                                                                           'WIDTH': 10},
                                                                'SOURCE': {'NULLABLE': True,
                                                                           'ORDER': 8,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'VARCHAR',
                                                                           'WIDTH': 80},
                                                                'SOURCE_ORDINAL': {'NULLABLE': True,
                                                                                   'ORDER': 5,
                                                                                   'PRECISION': 0,
                                                                                   'PRIMARY_KEY': False,
                                                                                   'SQL_TYPE': 'INT',
                                                                                   'WIDTH': 10},
                                                                'TYPE': {'NULLABLE': True,
                                                                         'ORDER': 6,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 80},
                                                                'VALUE': {'NULLABLE': True,
                                                                          'ORDER': 7,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': 1023}},
                                             'ATTRIBUTE_MAP': {'CHEM_COMP_ID': ('pdbx_reference_molecule_features',
                                                                                'chem_comp_id',
                                                                                None,
                                                                                None),
                                                               'DB_ID': (None, None, 'datablockid()', None),
                                                               'FAMILY_PRD_ID': ('pdbx_reference_molecule_features',
                                                                                 'family_prd_id',
                                                                                 None,
                                                                                 None),
                                                               'ORDINAL': ('pdbx_reference_molecule_features',
                                                                           'ordinal',
                                                                           None,
                                                                           None),
                                                               'PRD_ID': ('pdbx_reference_molecule_features',
                                                                          'prd_id',
                                                                          None,
                                                                          None),
                                                               'SOURCE': ('pdbx_reference_molecule_features',
                                                                          'source',
                                                                          None,
                                                                          None),
                                                               'SOURCE_ORDINAL': ('pdbx_reference_molecule_features',
                                                                                  'source_ordinal',
                                                                                  None,
                                                                                  None),
                                                               'TYPE': ('pdbx_reference_molecule_features',
                                                                        'type',
                                                                        None,
                                                                        None),
                                                               'VALUE': ('pdbx_reference_molecule_features',
                                                                         'value',
                                                                         None,
                                                                         None)},
                                             'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID', 'FAMILY_PRD_ID', 'PRD_ID', 'ORDINAL'),
                                                                'TYPE': 'UNIQUE'},
                                                         's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                                             'MAP_MERGE_INDICES': {'pdbx_reference_molecule_features': {'ATTRIBUTES': ('family_prd_id',
                                                                                                                       'prd_id',
                                                                                                                       'ordinal'),
                                                                                                        'TYPE': 'EQUI-JOIN'}},
                                             'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                                             'TABLE_ID': 'PDBX_REFERENCE_MOLECULE_FEATURES',
                                             'TABLE_NAME': 'pdbx_reference_molecule_features',
                                             'TABLE_TYPE': 'transactional'},
        'PDBX_REFERENCE_MOLECULE_LIST': {'ATTRIBUTES': {'DB_ID': 'db_id',
                                                        'FAMILY_PRD_ID': 'family_prd_id',
                                                        'PRD_ID': 'prd_id'},
                                         'ATTRIBUTE_INFO': {'DB_ID': {'NULLABLE': False,
                                                                      'ORDER': 1,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': True,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 10},
                                                            'FAMILY_PRD_ID': {'NULLABLE': False,
                                                                              'ORDER': 3,
                                                                              'PRECISION': 0,
                                                                              'PRIMARY_KEY': True,
                                                                              'SQL_TYPE': 'VARCHAR',
                                                                              'WIDTH': 10},
                                                            'PRD_ID': {'NULLABLE': False,
                                                                       'ORDER': 2,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': True,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 10}},
                                         'ATTRIBUTE_MAP': {'DB_ID': (None, None, 'datablockid()', None),
                                                           'FAMILY_PRD_ID': ('pdbx_reference_molecule_list',
                                                                             'family_prd_id',
                                                                             None,
                                                                             None),
                                                           'PRD_ID': ('pdbx_reference_molecule_list', 'prd_id', None, None)},
                                         'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID', 'PRD_ID', 'FAMILY_PRD_ID'),
                                                            'TYPE': 'UNIQUE'},
                                                     's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                                         'MAP_MERGE_INDICES': {'pdbx_reference_molecule_list': {'ATTRIBUTES': ('prd_id',
                                                                                                               'family_prd_id'),
                                                                                                'TYPE': 'EQUI-JOIN'}},
                                         'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                                         'TABLE_ID': 'PDBX_REFERENCE_MOLECULE_LIST',
                                         'TABLE_NAME': 'pdbx_reference_molecule_list',
                                         'TABLE_TYPE': 'transactional'},
        'PDBX_REFERENCE_MOLECULE_RELATED_STRUCTURES': {'ATTRIBUTES': {'CITATION_ID': 'citation_id',
                                                                      'DB_ACCESSION': 'db_accession',
                                                                      'DB_CODE': 'db_code',
                                                                      'DB_ID': 'db_id',
                                                                      'DB_NAME': 'db_name',
                                                                      'FAMILY_PRD_ID': 'family_prd_id',
                                                                      'FORMULA': 'formula',
                                                                      'NAME': 'name',
                                                                      'ORDINAL': 'ordinal'},
                                                       'ATTRIBUTE_INFO': {'CITATION_ID': {'NULLABLE': True,
                                                                                          'ORDER': 9,
                                                                                          'PRECISION': 0,
                                                                                          'PRIMARY_KEY': False,
                                                                                          'SQL_TYPE': 'VARCHAR',
                                                                                          'WIDTH': 10},
                                                                          'DB_ACCESSION': {'NULLABLE': True,
                                                                                           'ORDER': 6,
                                                                                           'PRECISION': 0,
                                                                                           'PRIMARY_KEY': False,
                                                                                           'SQL_TYPE': 'VARCHAR',
                                                                                           'WIDTH': 200},
                                                                          'DB_CODE': {'NULLABLE': True,
                                                                                      'ORDER': 5,
                                                                                      'PRECISION': 0,
                                                                                      'PRIMARY_KEY': False,
                                                                                      'SQL_TYPE': 'VARCHAR',
                                                                                      'WIDTH': 200},
                                                                          'DB_ID': {'NULLABLE': False,
                                                                                    'ORDER': 1,
                                                                                    'PRECISION': 0,
                                                                                    'PRIMARY_KEY': True,
                                                                                    'SQL_TYPE': 'VARCHAR',
                                                                                    'WIDTH': 10},
                                                                          'DB_NAME': {'NULLABLE': True,
                                                                                      'ORDER': 4,
                                                                                      'PRECISION': 0,
                                                                                      'PRIMARY_KEY': False,
                                                                                      'SQL_TYPE': 'VARCHAR',
                                                                                      'WIDTH': 200},
                                                                          'FAMILY_PRD_ID': {'NULLABLE': False,
                                                                                            'ORDER': 2,
                                                                                            'PRECISION': 0,
                                                                                            'PRIMARY_KEY': True,
                                                                                            'SQL_TYPE': 'VARCHAR',
                                                                                            'WIDTH': 10},
                                                                          'FORMULA': {'NULLABLE': True,
                                                                                      'ORDER': 8,
                                                                                      'PRECISION': 0,
                                                                                      'PRIMARY_KEY': False,
                                                                                      'SQL_TYPE': 'VARCHAR',
                                                                                      'WIDTH': 200},
                                                                          'NAME': {'NULLABLE': True,
                                                                                   'ORDER': 7,
                                                                                   'PRECISION': 0,
                                                                                   'PRIMARY_KEY': False,
                                                                                   'SQL_TYPE': 'VARCHAR',
                                                                                   'WIDTH': 511},
                                                                          'ORDINAL': {'NULLABLE': False,
                                                                                      'ORDER': 3,
                                                                                      'PRECISION': 0,
                                                                                      'PRIMARY_KEY': True,
                                                                                      'SQL_TYPE': 'INT',
                                                                                      'WIDTH': 10}},
                                                       'ATTRIBUTE_MAP': {'CITATION_ID': ('pdbx_reference_molecule_related_structures',
                                                                                         'citation_id',
                                                                                         None,
                                                                                         None),
                                                                         'DB_ACCESSION': ('pdbx_reference_molecule_related_structures',
                                                                                          'db_accession',
                                                                                          None,
                                                                                          None),
                                                                         'DB_CODE': ('pdbx_reference_molecule_related_structures',
                                                                                     'db_code',
                                                                                     None,
                                                                                     None),
                                                                         'DB_ID': (None, None, 'datablockid()', None),
                                                                         'DB_NAME': ('pdbx_reference_molecule_related_structures',
                                                                                     'db_name',
                                                                                     None,
                                                                                     None),
                                                                         'FAMILY_PRD_ID': ('pdbx_reference_molecule_related_structures',
                                                                                           'family_prd_id',
                                                                                           None,
                                                                                           None),
                                                                         'FORMULA': ('pdbx_reference_molecule_related_structures',
                                                                                     'formula',
                                                                                     None,
                                                                                     None),
                                                                         'NAME': ('pdbx_reference_molecule_related_structures',
                                                                                  'name',
                                                                                  None,
                                                                                  None),
                                                                         'ORDINAL': ('pdbx_reference_molecule_related_structures',
                                                                                     'ordinal',
                                                                                     None,
                                                                                     None)},
                                                       'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID', 'FAMILY_PRD_ID', 'ORDINAL'),
                                                                          'TYPE': 'UNIQUE'},
                                                                   's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                                                       'MAP_MERGE_INDICES': {'pdbx_reference_molecule_related_structures': {'ATTRIBUTES': ('family_prd_id',
                                                                                                                                           'ordinal'),
                                                                                                                            'TYPE': 'EQUI-JOIN'}},
                                                       'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                                                       'TABLE_ID': 'PDBX_REFERENCE_MOLECULE_RELATED_STRUCTURES',
                                                       'TABLE_NAME': 'pdbx_reference_molecule_related_structures',
                                                       'TABLE_TYPE': 'transactional'},
        'PDBX_REFERENCE_MOLECULE_SYNONYMS': {'ATTRIBUTES': {'CHEM_COMP_ID': 'chem_comp_id',
                                                            'DB_ID': 'db_id',
                                                            'FAMILY_PRD_ID': 'family_prd_id',
                                                            'NAME': 'name',
                                                            'ORDINAL': 'ordinal',
                                                            'PRD_ID': 'prd_id',
                                                            'SOURCE': 'source'},
                                             'ATTRIBUTE_INFO': {'CHEM_COMP_ID': {'NULLABLE': True,
                                                                                 'ORDER': 7,
                                                                                 'PRECISION': 0,
                                                                                 'PRIMARY_KEY': False,
                                                                                 'SQL_TYPE': 'VARCHAR',
                                                                                 'WIDTH': 10},
                                                                'DB_ID': {'NULLABLE': False,
                                                                          'ORDER': 1,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': True,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': 10},
                                                                'FAMILY_PRD_ID': {'NULLABLE': False,
                                                                                  'ORDER': 2,
                                                                                  'PRECISION': 0,
                                                                                  'PRIMARY_KEY': True,
                                                                                  'SQL_TYPE': 'VARCHAR',
                                                                                  'WIDTH': 10},
                                                                'NAME': {'NULLABLE': True,
                                                                         'ORDER': 5,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 1023},
                                                                'ORDINAL': {'NULLABLE': False,
                                                                            'ORDER': 4,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': True,
                                                                            'SQL_TYPE': 'INT',
                                                                            'WIDTH': 10},
                                                                'PRD_ID': {'NULLABLE': False,
                                                                           'ORDER': 3,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': True,
                                                                           'SQL_TYPE': 'VARCHAR',
                                                                           'WIDTH': 10},
                                                                'SOURCE': {'NULLABLE': True,
                                                                           'ORDER': 6,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'VARCHAR',
                                                                           'WIDTH': 200}},
                                             'ATTRIBUTE_MAP': {'CHEM_COMP_ID': ('pdbx_reference_molecule_synonyms',
                                                                                'chem_comp_id',
                                                                                None,
                                                                                None),
                                                               'DB_ID': (None, None, 'datablockid()', None),
                                                               'FAMILY_PRD_ID': ('pdbx_reference_molecule_synonyms',
                                                                                 'family_prd_id',
                                                                                 None,
                                                                                 None),
                                                               'NAME': ('pdbx_reference_molecule_synonyms',
                                                                        'name',
                                                                        None,
                                                                        None),
                                                               'ORDINAL': ('pdbx_reference_molecule_synonyms',
                                                                           'ordinal',
                                                                           None,
                                                                           None),
                                                               'PRD_ID': ('pdbx_reference_molecule_synonyms',
                                                                          'prd_id',
                                                                          None,
                                                                          None),
                                                               'SOURCE': ('pdbx_reference_molecule_synonyms',
                                                                          'source',
                                                                          None,
                                                                          None)},
                                             'INDICES': {'p1': {'ATTRIBUTES': ('DB_ID', 'FAMILY_PRD_ID', 'PRD_ID', 'ORDINAL'),
                                                                'TYPE': 'UNIQUE'},
                                                         's1': {'ATTRIBUTES': ('DB_ID',), 'TYPE': 'SEARCH'}},
                                             'MAP_MERGE_INDICES': {'pdbx_reference_molecule_synonyms': {'ATTRIBUTES': ('family_prd_id',
                                                                                                                       'prd_id',
                                                                                                                       'ordinal'),
                                                                                                        'TYPE': 'EQUI-JOIN'}},
                                             'TABLE_DELETE_ATTRIBUTE': 'DB_ID',
                                             'TABLE_ID': 'PDBX_REFERENCE_MOLECULE_SYNONYMS',
                                             'TABLE_NAME': 'pdbx_reference_molecule_synonyms',
                                             'TABLE_TYPE': 'transactional'}}
    # fmt: on

    def __init__(self, verbose=True, log=sys.stderr):
        super(BirdSchemaDef, self).__init__(databaseName=BirdSchemaDef._databaseName, schemaDefDict=BirdSchemaDef._schemaDefDict, verbose=verbose, log=log)


if __name__ == "__main__":
    bsd = BirdSchemaDef()
    tableIdList = bsd.getTableIdList()

    for tableId in tableIdList:
        aIdL = bsd.getAttributeIdList(tableId)
        tObj = bsd.getTable(tableId)
        attributeIdList = tObj.getAttributeIdList()
        attributeNameList = tObj.getAttributeNameList()
        sys.stdout.write("Ordered attribute Id   list %s\n" % (str(attributeIdList)))
        sys.stdout.write("Ordered attribute name list %s\n" % (str(attributeNameList)))
        #
        mAL = tObj.getMapAttributeNameList()
        sys.stdout.write("Ordered mapped attribute name list %s\n" % (str(mAL)))

        mAL = tObj.getMapAttributeIdList()
        sys.stdout.write("Ordered mapped attribute id   list %s\n" % (str(mAL)))

        cL = tObj.getMapInstanceCategoryList()
        sys.stdout.write("Mapped category list %s\n" % (str(cL)))
        for c in cL:
            aL = tObj.getMapInstanceAttributeList(c)
            sys.stdout.write("Mapped attribute list in %s :  %s\n" % (c, str(aL)))
