# coding: utf-8

"""
    Sedaro API

     Allows for consumption of Sedaro services. Read more about Sedaro at [docs.sedaro.com](https://docs.sedaro.com).  ### Clients  **Python:** [sedaro](https://pypi.org/project/sedaro/) - This package provides additional functionality on top of the auto-generated OpenAPI client. See the package docs for more information.  ### API Key  To access the Sedaro service via this API, you will need an API key.  You can generate an API key for your account in the Sedaro [Management Console](https://satellite.sedaro.com/#/account). Once complete, pass the API key in all requests via the `X_API_KEY` HTTP header.  *API keys grant full access to your account and should never be shared. If you think your API key has been compromised, you can revoke it in the [Management Console](https://satellite.sedaro.com/#/account).*  ### Jupyter Notebooks  For additional examples of how to use this API for modeling and simulation, see our [Mod-Sim Notebooks](https://github.com/sedaro/modsim-notebooks).  ### Community, Support, Discussion  If you have any issues or suggestions, please reach out:  1. Join the Sedaro Community [Slack](https://join.slack.com/t/sedaro-community/shared_invite/zt-1jps4i711-mXy88AZQ9AV7YcEXr8x7Ow) 2. Email us at support@sedarotech.com  ### Known Issues  - Error responses are more specific than what is shown throughout the documentation.  A 4xx or 5xx error will be returned in all error cases.  Only a `200` status indicates success.  See a given error response for additional details.   # noqa: E501

    The version of the OpenAPI document: 4.5.2
    Generated by: https://openapi-generator.tech
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from sedaro_base_client import schemas  # noqa: F401


class Spacecraft(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Class to inherit when creating a `Metamodel`
    """


    class MetaOapg:
        required = {
            "inertia",
            "cadScaleFactor",
            "cadSignedUrl",
            "mass",
            "cadKey",
        }
        
        class properties:
            
            
            class cadKey(
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    max_length = 48
            
            
            class cadSignedUrl(
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    max_length = 1024
            cadScaleFactor = schemas.NumberSchema
            mass = schemas.NumberSchema
            
            
            class inertia(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    
                    class items(
                        schemas.ListSchema
                    ):
                    
                    
                        class MetaOapg:
                            max_items = 3
                            min_items = 3
                            items = schemas.NumberSchema
                    
                        def __new__(
                            cls,
                            _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]], typing.List[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]]],
                            _configuration: typing.Optional[schemas.Configuration] = None,
                        ) -> 'items':
                            return super().__new__(
                                cls,
                                _arg,
                                _configuration=_configuration,
                            )
                    
                        def __getitem__(self, i: int) -> MetaOapg.items:
                            return super().__getitem__(i)
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, list, tuple, ]], typing.List[typing.Union[MetaOapg.items, list, tuple, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'inertia':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class blocks(
                schemas.DictSchema
            ):
            
            
                class MetaOapg:
                    additional_properties = schemas.DictSchema
                
                def __getitem__(self, name: typing.Union[str, ]) -> MetaOapg.additional_properties:
                    # dict_instance[name] accessor
                    return super().__getitem__(name)
                
                def get_item_oapg(self, name: typing.Union[str, ]) -> MetaOapg.additional_properties:
                    return super().get_item_oapg(name)
            
                def __new__(
                    cls,
                    *_args: typing.Union[dict, frozendict.frozendict, ],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                    **kwargs: typing.Union[MetaOapg.additional_properties, dict, frozendict.frozendict, ],
                ) -> 'blocks':
                    return super().__new__(
                        cls,
                        *_args,
                        _configuration=_configuration,
                        **kwargs,
                    )
            
            
            class index(
                schemas.DictSchema
            ):
            
            
                class MetaOapg:
                    
                    
                    class additional_properties(
                        schemas.ListSchema
                    ):
                    
                    
                        class MetaOapg:
                            items = schemas.StrSchema
                    
                        def __new__(
                            cls,
                            _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                            _configuration: typing.Optional[schemas.Configuration] = None,
                        ) -> 'additional_properties':
                            return super().__new__(
                                cls,
                                _arg,
                                _configuration=_configuration,
                            )
                    
                        def __getitem__(self, i: int) -> MetaOapg.items:
                            return super().__getitem__(i)
                
                def __getitem__(self, name: typing.Union[str, ]) -> MetaOapg.additional_properties:
                    # dict_instance[name] accessor
                    return super().__getitem__(name)
                
                def get_item_oapg(self, name: typing.Union[str, ]) -> MetaOapg.additional_properties:
                    return super().get_item_oapg(name)
            
                def __new__(
                    cls,
                    *_args: typing.Union[dict, frozendict.frozendict, ],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                    **kwargs: typing.Union[MetaOapg.additional_properties, list, tuple, ],
                ) -> 'index':
                    return super().__new__(
                        cls,
                        *_args,
                        _configuration=_configuration,
                        **kwargs,
                    )
            
            
            class position(
                schemas.ComposedSchema,
            ):
            
            
                class MetaOapg:
                    
                    @classmethod
                    @functools.lru_cache()
                    def all_of(cls):
                        # we need this here to make our import statements work
                        # we must store _composed_schemas in here so the code is only run
                        # when we invoke this method. If we kept this at the class
                        # level we would get an error because the class level
                        # code would be run when this module is imported, and these composed
                        # classes don't exist yet because their module has not finished
                        # loading
                        return [
                            PositionBase306,
                        ]
            
            
                def __new__(
                    cls,
                    *_args: typing.Union[dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, bool, None, list, tuple, bytes, io.FileIO, io.BufferedReader, ],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                    **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
                ) -> 'position':
                    return super().__new__(
                        cls,
                        *_args,
                        _configuration=_configuration,
                        **kwargs,
                    )
            
            
            class velocity(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.NumberSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]], typing.List[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'velocity':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class attitude(
                schemas.ComposedSchema,
            ):
            
            
                class MetaOapg:
                    
                    @classmethod
                    @functools.lru_cache()
                    def all_of(cls):
                        # we need this here to make our import statements work
                        # we must store _composed_schemas in here so the code is only run
                        # when we invoke this method. If we kept this at the class
                        # level we would get an error because the class level
                        # code would be run when this module is imported, and these composed
                        # classes don't exist yet because their module has not finished
                        # loading
                        return [
                            QuaternionBase306,
                        ]
            
            
                def __new__(
                    cls,
                    *_args: typing.Union[dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, bool, None, list, tuple, bytes, io.FileIO, io.BufferedReader, ],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                    **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
                ) -> 'attitude':
                    return super().__new__(
                        cls,
                        *_args,
                        _configuration=_configuration,
                        **kwargs,
                    )
            
            
            class angularVelocity(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.NumberSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]], typing.List[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'angularVelocity':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            selfId = schemas.StrSchema
            
            
            class cadFileName(
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    max_length = 100
            dynamicMass = schemas.NumberSchema
            
            
            class dynamicInertia(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    
                    class items(
                        schemas.ListSchema
                    ):
                    
                    
                        class MetaOapg:
                            max_items = 3
                            min_items = 3
                            items = schemas.NumberSchema
                    
                        def __new__(
                            cls,
                            _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]], typing.List[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]]],
                            _configuration: typing.Optional[schemas.Configuration] = None,
                        ) -> 'items':
                            return super().__new__(
                                cls,
                                _arg,
                                _configuration=_configuration,
                            )
                    
                        def __getitem__(self, i: int) -> MetaOapg.items:
                            return super().__getitem__(i)
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, list, tuple, ]], typing.List[typing.Union[MetaOapg.items, list, tuple, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'dynamicInertia':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class torque(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.NumberSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]], typing.List[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'torque':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class enabledModules(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'enabledModules':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            missionOrbit = schemas.StrSchema
            activeOpMode = schemas.StrSchema
            powerProcessor = schemas.StrSchema
            
            
            class srpTorque(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.NumberSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]], typing.List[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'srpTorque':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class dragTorque(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.NumberSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]], typing.List[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'dragTorque':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class gravityGradientTorque(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.NumberSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]], typing.List[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'gravityGradientTorque':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class positionSolution(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.NumberSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]], typing.List[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'positionSolution':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class positionSolutionError(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.NumberSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]], typing.List[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'positionSolutionError':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class positionCovariance(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    
                    class items(
                        schemas.ListSchema
                    ):
                    
                    
                        class MetaOapg:
                            max_items = 3
                            min_items = 3
                            items = schemas.NumberSchema
                    
                        def __new__(
                            cls,
                            _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]], typing.List[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]]],
                            _configuration: typing.Optional[schemas.Configuration] = None,
                        ) -> 'items':
                            return super().__new__(
                                cls,
                                _arg,
                                _configuration=_configuration,
                            )
                    
                        def __getitem__(self, i: int) -> MetaOapg.items:
                            return super().__getitem__(i)
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, list, tuple, ]], typing.List[typing.Union[MetaOapg.items, list, tuple, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'positionCovariance':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class velocitySolution(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.NumberSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]], typing.List[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'velocitySolution':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class velocitySolutionError(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.NumberSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]], typing.List[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'velocitySolutionError':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class velocityCovariance(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    
                    class items(
                        schemas.ListSchema
                    ):
                    
                    
                        class MetaOapg:
                            max_items = 3
                            min_items = 3
                            items = schemas.NumberSchema
                    
                        def __new__(
                            cls,
                            _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]], typing.List[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]]],
                            _configuration: typing.Optional[schemas.Configuration] = None,
                        ) -> 'items':
                            return super().__new__(
                                cls,
                                _arg,
                                _configuration=_configuration,
                            )
                    
                        def __getitem__(self, i: int) -> MetaOapg.items:
                            return super().__getitem__(i)
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, list, tuple, ]], typing.List[typing.Union[MetaOapg.items, list, tuple, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'velocityCovariance':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class attitudeSolution(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.NumberSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]], typing.List[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'attitudeSolution':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class attitudeSolutionError(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.NumberSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]], typing.List[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'attitudeSolutionError':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class angularVelocitySolution(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.NumberSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]], typing.List[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'angularVelocitySolution':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class angularVelocitySolutionError(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.NumberSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]], typing.List[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'angularVelocitySolutionError':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class commandedAttitude(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.NumberSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]], typing.List[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'commandedAttitude':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class commandedAngularRates(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.NumberSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]], typing.List[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'commandedAngularRates':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class lvlhAxes(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    
                    class items(
                        schemas.ListSchema
                    ):
                    
                    
                        class MetaOapg:
                            max_items = 3
                            min_items = 3
                            items = schemas.NumberSchema
                    
                        def __new__(
                            cls,
                            _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]], typing.List[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]]],
                            _configuration: typing.Optional[schemas.Configuration] = None,
                        ) -> 'items':
                            return super().__new__(
                                cls,
                                _arg,
                                _configuration=_configuration,
                            )
                    
                        def __getitem__(self, i: int) -> MetaOapg.items:
                            return super().__getitem__(i)
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, list, tuple, ]], typing.List[typing.Union[MetaOapg.items, list, tuple, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'lvlhAxes':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class enuAxes(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    
                    class items(
                        schemas.ListSchema
                    ):
                    
                    
                        class MetaOapg:
                            max_items = 3
                            min_items = 3
                            items = schemas.NumberSchema
                    
                        def __new__(
                            cls,
                            _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]], typing.List[typing.Union[MetaOapg.items, decimal.Decimal, int, float, ]]],
                            _configuration: typing.Optional[schemas.Configuration] = None,
                        ) -> 'items':
                            return super().__new__(
                                cls,
                                _arg,
                                _configuration=_configuration,
                            )
                    
                        def __getitem__(self, i: int) -> MetaOapg.items:
                            return super().__getitem__(i)
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, list, tuple, ]], typing.List[typing.Union[MetaOapg.items, list, tuple, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'enuAxes':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            beta = schemas.NumberSchema
            
            
            class orbitalElements(
                schemas.ComposedSchema,
            ):
            
            
                class MetaOapg:
                    
                    @classmethod
                    @functools.lru_cache()
                    def all_of(cls):
                        # we need this here to make our import statements work
                        # we must store _composed_schemas in here so the code is only run
                        # when we invoke this method. If we kept this at the class
                        # level we would get an error because the class level
                        # code would be run when this module is imported, and these composed
                        # classes don't exist yet because their module has not finished
                        # loading
                        return [
                            OrbitalElementsData,
                        ]
            
            
                def __new__(
                    cls,
                    *_args: typing.Union[dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, bool, None, list, tuple, bytes, io.FileIO, io.BufferedReader, ],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                    **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
                ) -> 'orbitalElements':
                    return super().__new__(
                        cls,
                        *_args,
                        _configuration=_configuration,
                        **kwargs,
                    )
            shadow = schemas.BoolSchema
            
            
            class activeCommInterfaces(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    
                    class items(
                        schemas.ListSchema
                    ):
                    
                    
                        class MetaOapg:
                            
                            
                            class items(
                                schemas.ComposedSchema,
                            ):
                            
                            
                                class MetaOapg:
                                    any_of_0 = schemas.BoolSchema
                                    any_of_1 = schemas.StrSchema
                                    any_of_2 = schemas.IntSchema
                                    
                                    @classmethod
                                    @functools.lru_cache()
                                    def any_of(cls):
                                        # we need this here to make our import statements work
                                        # we must store _composed_schemas in here so the code is only run
                                        # when we invoke this method. If we kept this at the class
                                        # level we would get an error because the class level
                                        # code would be run when this module is imported, and these composed
                                        # classes don't exist yet because their module has not finished
                                        # loading
                                        return [
                                            cls.any_of_0,
                                            cls.any_of_1,
                                            cls.any_of_2,
                                        ]
                            
                            
                                def __new__(
                                    cls,
                                    *_args: typing.Union[dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, bool, None, list, tuple, bytes, io.FileIO, io.BufferedReader, ],
                                    _configuration: typing.Optional[schemas.Configuration] = None,
                                    **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
                                ) -> 'items':
                                    return super().__new__(
                                        cls,
                                        *_args,
                                        _configuration=_configuration,
                                        **kwargs,
                                    )
                    
                        def __new__(
                            cls,
                            _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, bool, None, list, tuple, bytes, io.FileIO, io.BufferedReader, ]], typing.List[typing.Union[MetaOapg.items, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, bool, None, list, tuple, bytes, io.FileIO, io.BufferedReader, ]]],
                            _configuration: typing.Optional[schemas.Configuration] = None,
                        ) -> 'items':
                            return super().__new__(
                                cls,
                                _arg,
                                _configuration=_configuration,
                            )
                    
                        def __getitem__(self, i: int) -> MetaOapg.items:
                            return super().__getitem__(i)
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, list, tuple, ]], typing.List[typing.Union[MetaOapg.items, list, tuple, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'activeCommInterfaces':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            __annotations__ = {
                "cadKey": cadKey,
                "cadSignedUrl": cadSignedUrl,
                "cadScaleFactor": cadScaleFactor,
                "mass": mass,
                "inertia": inertia,
                "blocks": blocks,
                "index": index,
                "position": position,
                "velocity": velocity,
                "attitude": attitude,
                "angularVelocity": angularVelocity,
                "selfId": selfId,
                "cadFileName": cadFileName,
                "dynamicMass": dynamicMass,
                "dynamicInertia": dynamicInertia,
                "torque": torque,
                "enabledModules": enabledModules,
                "missionOrbit": missionOrbit,
                "activeOpMode": activeOpMode,
                "powerProcessor": powerProcessor,
                "srpTorque": srpTorque,
                "dragTorque": dragTorque,
                "gravityGradientTorque": gravityGradientTorque,
                "positionSolution": positionSolution,
                "positionSolutionError": positionSolutionError,
                "positionCovariance": positionCovariance,
                "velocitySolution": velocitySolution,
                "velocitySolutionError": velocitySolutionError,
                "velocityCovariance": velocityCovariance,
                "attitudeSolution": attitudeSolution,
                "attitudeSolutionError": attitudeSolutionError,
                "angularVelocitySolution": angularVelocitySolution,
                "angularVelocitySolutionError": angularVelocitySolutionError,
                "commandedAttitude": commandedAttitude,
                "commandedAngularRates": commandedAngularRates,
                "lvlhAxes": lvlhAxes,
                "enuAxes": enuAxes,
                "beta": beta,
                "orbitalElements": orbitalElements,
                "shadow": shadow,
                "activeCommInterfaces": activeCommInterfaces,
            }
        additional_properties = schemas.NotAnyTypeSchema
    
    inertia: MetaOapg.properties.inertia
    cadScaleFactor: MetaOapg.properties.cadScaleFactor
    cadSignedUrl: MetaOapg.properties.cadSignedUrl
    mass: MetaOapg.properties.mass
    cadKey: MetaOapg.properties.cadKey
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["inertia"]) -> MetaOapg.properties.inertia: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["cadScaleFactor"]) -> MetaOapg.properties.cadScaleFactor: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["cadSignedUrl"]) -> MetaOapg.properties.cadSignedUrl: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["mass"]) -> MetaOapg.properties.mass: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["cadKey"]) -> MetaOapg.properties.cadKey: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["blocks"]) -> MetaOapg.properties.blocks: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["index"]) -> MetaOapg.properties.index: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["position"]) -> MetaOapg.properties.position: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["velocity"]) -> MetaOapg.properties.velocity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["attitude"]) -> MetaOapg.properties.attitude: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["angularVelocity"]) -> MetaOapg.properties.angularVelocity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["selfId"]) -> MetaOapg.properties.selfId: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["cadFileName"]) -> MetaOapg.properties.cadFileName: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["dynamicMass"]) -> MetaOapg.properties.dynamicMass: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["dynamicInertia"]) -> MetaOapg.properties.dynamicInertia: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["torque"]) -> MetaOapg.properties.torque: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enabledModules"]) -> MetaOapg.properties.enabledModules: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["missionOrbit"]) -> MetaOapg.properties.missionOrbit: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["activeOpMode"]) -> MetaOapg.properties.activeOpMode: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["powerProcessor"]) -> MetaOapg.properties.powerProcessor: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["srpTorque"]) -> MetaOapg.properties.srpTorque: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["dragTorque"]) -> MetaOapg.properties.dragTorque: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["gravityGradientTorque"]) -> MetaOapg.properties.gravityGradientTorque: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["positionSolution"]) -> MetaOapg.properties.positionSolution: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["positionSolutionError"]) -> MetaOapg.properties.positionSolutionError: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["positionCovariance"]) -> MetaOapg.properties.positionCovariance: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["velocitySolution"]) -> MetaOapg.properties.velocitySolution: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["velocitySolutionError"]) -> MetaOapg.properties.velocitySolutionError: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["velocityCovariance"]) -> MetaOapg.properties.velocityCovariance: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["attitudeSolution"]) -> MetaOapg.properties.attitudeSolution: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["attitudeSolutionError"]) -> MetaOapg.properties.attitudeSolutionError: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["angularVelocitySolution"]) -> MetaOapg.properties.angularVelocitySolution: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["angularVelocitySolutionError"]) -> MetaOapg.properties.angularVelocitySolutionError: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["commandedAttitude"]) -> MetaOapg.properties.commandedAttitude: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["commandedAngularRates"]) -> MetaOapg.properties.commandedAngularRates: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["lvlhAxes"]) -> MetaOapg.properties.lvlhAxes: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enuAxes"]) -> MetaOapg.properties.enuAxes: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["beta"]) -> MetaOapg.properties.beta: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["orbitalElements"]) -> MetaOapg.properties.orbitalElements: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["shadow"]) -> MetaOapg.properties.shadow: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["activeCommInterfaces"]) -> MetaOapg.properties.activeCommInterfaces: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["inertia"], typing_extensions.Literal["cadScaleFactor"], typing_extensions.Literal["cadSignedUrl"], typing_extensions.Literal["mass"], typing_extensions.Literal["cadKey"], typing_extensions.Literal["blocks"], typing_extensions.Literal["index"], typing_extensions.Literal["position"], typing_extensions.Literal["velocity"], typing_extensions.Literal["attitude"], typing_extensions.Literal["angularVelocity"], typing_extensions.Literal["selfId"], typing_extensions.Literal["cadFileName"], typing_extensions.Literal["dynamicMass"], typing_extensions.Literal["dynamicInertia"], typing_extensions.Literal["torque"], typing_extensions.Literal["enabledModules"], typing_extensions.Literal["missionOrbit"], typing_extensions.Literal["activeOpMode"], typing_extensions.Literal["powerProcessor"], typing_extensions.Literal["srpTorque"], typing_extensions.Literal["dragTorque"], typing_extensions.Literal["gravityGradientTorque"], typing_extensions.Literal["positionSolution"], typing_extensions.Literal["positionSolutionError"], typing_extensions.Literal["positionCovariance"], typing_extensions.Literal["velocitySolution"], typing_extensions.Literal["velocitySolutionError"], typing_extensions.Literal["velocityCovariance"], typing_extensions.Literal["attitudeSolution"], typing_extensions.Literal["attitudeSolutionError"], typing_extensions.Literal["angularVelocitySolution"], typing_extensions.Literal["angularVelocitySolutionError"], typing_extensions.Literal["commandedAttitude"], typing_extensions.Literal["commandedAngularRates"], typing_extensions.Literal["lvlhAxes"], typing_extensions.Literal["enuAxes"], typing_extensions.Literal["beta"], typing_extensions.Literal["orbitalElements"], typing_extensions.Literal["shadow"], typing_extensions.Literal["activeCommInterfaces"], ]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["inertia"]) -> MetaOapg.properties.inertia: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["cadScaleFactor"]) -> MetaOapg.properties.cadScaleFactor: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["cadSignedUrl"]) -> MetaOapg.properties.cadSignedUrl: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["mass"]) -> MetaOapg.properties.mass: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["cadKey"]) -> MetaOapg.properties.cadKey: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["blocks"]) -> typing.Union[MetaOapg.properties.blocks, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["index"]) -> typing.Union[MetaOapg.properties.index, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["position"]) -> typing.Union[MetaOapg.properties.position, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["velocity"]) -> typing.Union[MetaOapg.properties.velocity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["attitude"]) -> typing.Union[MetaOapg.properties.attitude, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["angularVelocity"]) -> typing.Union[MetaOapg.properties.angularVelocity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["selfId"]) -> typing.Union[MetaOapg.properties.selfId, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["cadFileName"]) -> typing.Union[MetaOapg.properties.cadFileName, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["dynamicMass"]) -> typing.Union[MetaOapg.properties.dynamicMass, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["dynamicInertia"]) -> typing.Union[MetaOapg.properties.dynamicInertia, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["torque"]) -> typing.Union[MetaOapg.properties.torque, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enabledModules"]) -> typing.Union[MetaOapg.properties.enabledModules, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["missionOrbit"]) -> typing.Union[MetaOapg.properties.missionOrbit, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["activeOpMode"]) -> typing.Union[MetaOapg.properties.activeOpMode, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["powerProcessor"]) -> typing.Union[MetaOapg.properties.powerProcessor, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["srpTorque"]) -> typing.Union[MetaOapg.properties.srpTorque, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["dragTorque"]) -> typing.Union[MetaOapg.properties.dragTorque, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["gravityGradientTorque"]) -> typing.Union[MetaOapg.properties.gravityGradientTorque, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["positionSolution"]) -> typing.Union[MetaOapg.properties.positionSolution, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["positionSolutionError"]) -> typing.Union[MetaOapg.properties.positionSolutionError, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["positionCovariance"]) -> typing.Union[MetaOapg.properties.positionCovariance, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["velocitySolution"]) -> typing.Union[MetaOapg.properties.velocitySolution, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["velocitySolutionError"]) -> typing.Union[MetaOapg.properties.velocitySolutionError, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["velocityCovariance"]) -> typing.Union[MetaOapg.properties.velocityCovariance, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["attitudeSolution"]) -> typing.Union[MetaOapg.properties.attitudeSolution, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["attitudeSolutionError"]) -> typing.Union[MetaOapg.properties.attitudeSolutionError, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["angularVelocitySolution"]) -> typing.Union[MetaOapg.properties.angularVelocitySolution, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["angularVelocitySolutionError"]) -> typing.Union[MetaOapg.properties.angularVelocitySolutionError, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["commandedAttitude"]) -> typing.Union[MetaOapg.properties.commandedAttitude, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["commandedAngularRates"]) -> typing.Union[MetaOapg.properties.commandedAngularRates, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["lvlhAxes"]) -> typing.Union[MetaOapg.properties.lvlhAxes, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enuAxes"]) -> typing.Union[MetaOapg.properties.enuAxes, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["beta"]) -> typing.Union[MetaOapg.properties.beta, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["orbitalElements"]) -> typing.Union[MetaOapg.properties.orbitalElements, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["shadow"]) -> typing.Union[MetaOapg.properties.shadow, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["activeCommInterfaces"]) -> typing.Union[MetaOapg.properties.activeCommInterfaces, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["inertia"], typing_extensions.Literal["cadScaleFactor"], typing_extensions.Literal["cadSignedUrl"], typing_extensions.Literal["mass"], typing_extensions.Literal["cadKey"], typing_extensions.Literal["blocks"], typing_extensions.Literal["index"], typing_extensions.Literal["position"], typing_extensions.Literal["velocity"], typing_extensions.Literal["attitude"], typing_extensions.Literal["angularVelocity"], typing_extensions.Literal["selfId"], typing_extensions.Literal["cadFileName"], typing_extensions.Literal["dynamicMass"], typing_extensions.Literal["dynamicInertia"], typing_extensions.Literal["torque"], typing_extensions.Literal["enabledModules"], typing_extensions.Literal["missionOrbit"], typing_extensions.Literal["activeOpMode"], typing_extensions.Literal["powerProcessor"], typing_extensions.Literal["srpTorque"], typing_extensions.Literal["dragTorque"], typing_extensions.Literal["gravityGradientTorque"], typing_extensions.Literal["positionSolution"], typing_extensions.Literal["positionSolutionError"], typing_extensions.Literal["positionCovariance"], typing_extensions.Literal["velocitySolution"], typing_extensions.Literal["velocitySolutionError"], typing_extensions.Literal["velocityCovariance"], typing_extensions.Literal["attitudeSolution"], typing_extensions.Literal["attitudeSolutionError"], typing_extensions.Literal["angularVelocitySolution"], typing_extensions.Literal["angularVelocitySolutionError"], typing_extensions.Literal["commandedAttitude"], typing_extensions.Literal["commandedAngularRates"], typing_extensions.Literal["lvlhAxes"], typing_extensions.Literal["enuAxes"], typing_extensions.Literal["beta"], typing_extensions.Literal["orbitalElements"], typing_extensions.Literal["shadow"], typing_extensions.Literal["activeCommInterfaces"], ]):
        return super().get_item_oapg(name)

    def __new__(
        cls,
        *_args: typing.Union[dict, frozendict.frozendict, ],
        inertia: typing.Union[MetaOapg.properties.inertia, list, tuple, ],
        cadScaleFactor: typing.Union[MetaOapg.properties.cadScaleFactor, decimal.Decimal, int, float, ],
        cadSignedUrl: typing.Union[MetaOapg.properties.cadSignedUrl, str, ],
        mass: typing.Union[MetaOapg.properties.mass, decimal.Decimal, int, float, ],
        cadKey: typing.Union[MetaOapg.properties.cadKey, str, ],
        blocks: typing.Union[MetaOapg.properties.blocks, dict, frozendict.frozendict, schemas.Unset] = schemas.unset,
        index: typing.Union[MetaOapg.properties.index, dict, frozendict.frozendict, schemas.Unset] = schemas.unset,
        position: typing.Union[MetaOapg.properties.position, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, bool, None, list, tuple, bytes, io.FileIO, io.BufferedReader, schemas.Unset] = schemas.unset,
        velocity: typing.Union[MetaOapg.properties.velocity, list, tuple, schemas.Unset] = schemas.unset,
        attitude: typing.Union[MetaOapg.properties.attitude, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, bool, None, list, tuple, bytes, io.FileIO, io.BufferedReader, schemas.Unset] = schemas.unset,
        angularVelocity: typing.Union[MetaOapg.properties.angularVelocity, list, tuple, schemas.Unset] = schemas.unset,
        selfId: typing.Union[MetaOapg.properties.selfId, str, schemas.Unset] = schemas.unset,
        cadFileName: typing.Union[MetaOapg.properties.cadFileName, str, schemas.Unset] = schemas.unset,
        dynamicMass: typing.Union[MetaOapg.properties.dynamicMass, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        dynamicInertia: typing.Union[MetaOapg.properties.dynamicInertia, list, tuple, schemas.Unset] = schemas.unset,
        torque: typing.Union[MetaOapg.properties.torque, list, tuple, schemas.Unset] = schemas.unset,
        enabledModules: typing.Union[MetaOapg.properties.enabledModules, list, tuple, schemas.Unset] = schemas.unset,
        missionOrbit: typing.Union[MetaOapg.properties.missionOrbit, str, schemas.Unset] = schemas.unset,
        activeOpMode: typing.Union[MetaOapg.properties.activeOpMode, str, schemas.Unset] = schemas.unset,
        powerProcessor: typing.Union[MetaOapg.properties.powerProcessor, str, schemas.Unset] = schemas.unset,
        srpTorque: typing.Union[MetaOapg.properties.srpTorque, list, tuple, schemas.Unset] = schemas.unset,
        dragTorque: typing.Union[MetaOapg.properties.dragTorque, list, tuple, schemas.Unset] = schemas.unset,
        gravityGradientTorque: typing.Union[MetaOapg.properties.gravityGradientTorque, list, tuple, schemas.Unset] = schemas.unset,
        positionSolution: typing.Union[MetaOapg.properties.positionSolution, list, tuple, schemas.Unset] = schemas.unset,
        positionSolutionError: typing.Union[MetaOapg.properties.positionSolutionError, list, tuple, schemas.Unset] = schemas.unset,
        positionCovariance: typing.Union[MetaOapg.properties.positionCovariance, list, tuple, schemas.Unset] = schemas.unset,
        velocitySolution: typing.Union[MetaOapg.properties.velocitySolution, list, tuple, schemas.Unset] = schemas.unset,
        velocitySolutionError: typing.Union[MetaOapg.properties.velocitySolutionError, list, tuple, schemas.Unset] = schemas.unset,
        velocityCovariance: typing.Union[MetaOapg.properties.velocityCovariance, list, tuple, schemas.Unset] = schemas.unset,
        attitudeSolution: typing.Union[MetaOapg.properties.attitudeSolution, list, tuple, schemas.Unset] = schemas.unset,
        attitudeSolutionError: typing.Union[MetaOapg.properties.attitudeSolutionError, list, tuple, schemas.Unset] = schemas.unset,
        angularVelocitySolution: typing.Union[MetaOapg.properties.angularVelocitySolution, list, tuple, schemas.Unset] = schemas.unset,
        angularVelocitySolutionError: typing.Union[MetaOapg.properties.angularVelocitySolutionError, list, tuple, schemas.Unset] = schemas.unset,
        commandedAttitude: typing.Union[MetaOapg.properties.commandedAttitude, list, tuple, schemas.Unset] = schemas.unset,
        commandedAngularRates: typing.Union[MetaOapg.properties.commandedAngularRates, list, tuple, schemas.Unset] = schemas.unset,
        lvlhAxes: typing.Union[MetaOapg.properties.lvlhAxes, list, tuple, schemas.Unset] = schemas.unset,
        enuAxes: typing.Union[MetaOapg.properties.enuAxes, list, tuple, schemas.Unset] = schemas.unset,
        beta: typing.Union[MetaOapg.properties.beta, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        orbitalElements: typing.Union[MetaOapg.properties.orbitalElements, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, bool, None, list, tuple, bytes, io.FileIO, io.BufferedReader, schemas.Unset] = schemas.unset,
        shadow: typing.Union[MetaOapg.properties.shadow, bool, schemas.Unset] = schemas.unset,
        activeCommInterfaces: typing.Union[MetaOapg.properties.activeCommInterfaces, list, tuple, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
    ) -> 'Spacecraft':
        return super().__new__(
            cls,
            *_args,
            inertia=inertia,
            cadScaleFactor=cadScaleFactor,
            cadSignedUrl=cadSignedUrl,
            mass=mass,
            cadKey=cadKey,
            blocks=blocks,
            index=index,
            position=position,
            velocity=velocity,
            attitude=attitude,
            angularVelocity=angularVelocity,
            selfId=selfId,
            cadFileName=cadFileName,
            dynamicMass=dynamicMass,
            dynamicInertia=dynamicInertia,
            torque=torque,
            enabledModules=enabledModules,
            missionOrbit=missionOrbit,
            activeOpMode=activeOpMode,
            powerProcessor=powerProcessor,
            srpTorque=srpTorque,
            dragTorque=dragTorque,
            gravityGradientTorque=gravityGradientTorque,
            positionSolution=positionSolution,
            positionSolutionError=positionSolutionError,
            positionCovariance=positionCovariance,
            velocitySolution=velocitySolution,
            velocitySolutionError=velocitySolutionError,
            velocityCovariance=velocityCovariance,
            attitudeSolution=attitudeSolution,
            attitudeSolutionError=attitudeSolutionError,
            angularVelocitySolution=angularVelocitySolution,
            angularVelocitySolutionError=angularVelocitySolutionError,
            commandedAttitude=commandedAttitude,
            commandedAngularRates=commandedAngularRates,
            lvlhAxes=lvlhAxes,
            enuAxes=enuAxes,
            beta=beta,
            orbitalElements=orbitalElements,
            shadow=shadow,
            activeCommInterfaces=activeCommInterfaces,
            _configuration=_configuration,
        )

from sedaro_base_client.model.orbital_elements_data import OrbitalElementsData
from sedaro_base_client.model.position_base306 import PositionBase306
from sedaro_base_client.model.quaternion_base306 import QuaternionBase306
