# -*- coding: utf-8 -*-
"""
Created on Sat Nov  6 14:47:33 2021

@author: Ravi raj purohit PURUSHOTTAM RAJ PUROHIT (purushot@esrf.fr)
@guide: jean-Sebastien MICHA (micha@esrf.fr)

Functions for lauetoolsneuralnetwork, Lauetools

This file is taken from xrayutilities (https://xrayutilities.sourceforge.io/)

General diffraction rules and wyckofpositions of atoms for all 230 crystal class
International Tables for Crystallography
Volume A: Space-Group Symmetry
Editor Theo Hahn
First Edition 1983, Fifth Edition 2002
Corrected Reprint 2005

###USAGE
from wyckpos import wp, eqhkl_default, eqhkl_custom, sgrp_sym, sgrp_name, sgrp_params


space_group = str(191)
space_group_nr = int(space_group.split(':')[0])
try:
    space_group_suf = ':' + space_group.split(':')[1]
except IndexError:
    space_group_suf = get_default_sgrp_suf(space_group_nr)

if space_group_suf != '':
    space_group = str(space_group_nr) + space_group_suf
name = sgrp_name[str(space_group_nr)] + space_group_suf
crystal_system, nargs = sgrp_sym[space_group_nr]
crystal_system += space_group_suf

# save general Wyckoff position
gplabel = sorted(wp[space_group], key=lambda s: int(s[:-1]))[-1]
gp = wp[space_group][gplabel]

hklcond_group = re.compile(r'([-hkil0-9\(\)]+): ([-+hklnor1-8=\s,]+)(?:, |$)')

# load reflection conditions if needed
if gp[2] == 'n/a':
    return True

if gp[2] is not None:
    hklcond = hklcond_group.findall(gp[2])

ret = testhklcond(hkls, hklcond)

"""
__all__ = ["RangeDict", "eqhkl_default", "eqhkl_custom", "wp"]

class RangeDict(dict):
    def __getitem__(self, item):
        if not isinstance(item, range):
            for key in self:
                if item in key:
                    return self[key]
            return super().__getitem__(item)
        else:
            return super().__getitem__(item)

# space group number to symmetry and number of parameters dictionary
sgrp_sym = RangeDict({range(1, 3): ('triclinic', 6),
                      range(3, 16): ('monoclinic', 4),
                      range(16, 75): ('orthorhombic', 3),
                      range(75, 143): ('tetragonal', 2),
                      range(143, 168): ('trigonal', 2),
                      range(168, 195): ('hexagonal', 2),
                      range(195, 231): ('cubic', 1)})

sgrp_name = {'1': 'P1', '2': 'P-1', '3': 'P2', '4': 'P21', '5': 'C2',
             '6': 'Pm', '7': 'Pc', '8': 'Cm', '9': 'Cc', '10': 'P2/m',
             '11': 'P21/m', '12': 'C2/m', '13': 'P2/c', '14': 'P21/c',
             '15': 'C2/c', '16': 'P222', '17': 'P2221', '18': 'P21212',
             '19': 'P212121', '20': 'C2221', '21': 'C222', '22': 'F222',
             '23': 'I222', '24': 'I212121', '25': 'Pmm2', '26': 'Pmc21',
             '27': 'Pcc2', '28': 'Pma2', '29': 'Pca21', '30': 'Pnc2',
             '31': 'Pmn21', '32': 'Pba2', '33': 'Pna21', '34': 'Pnn2',
             '35': 'Cmm2', '36': 'Cmc21', '37': 'Ccc2', '38': 'Amm2',
             '39': 'Aem2', '40': 'Ama2', '41': 'Aea2', '42': 'Fmm2',
             '43': 'Fdd2', '44': 'Imm2', '45': 'Iba2', '46': 'Ima2',
             '47': 'Pmmm', '48': 'Pnnn', '49': 'Pccm', '50': 'Pban',
             '51': 'Pmma', '52': 'Pnna', '53': 'Pmna', '54': 'Pcca',
             '55': 'Pbam', '56': 'Pccn', '57': 'Pbcm', '58': 'Pnnm',
             '59': 'Pmmn', '60': 'Pbcn', '61': 'Pbca', '62': 'Pnma',
             '63': 'Cmcm', '64': 'Cmce', '65': 'Cmmm', '66': 'Cccm',
             '67': 'Cmme', '68': 'Ccce', '69': 'Fmmm', '70': 'Fddd',
             '71': 'Immm', '72': 'Ibam', '73': 'Ibca', '74': 'Imma',
             '75': 'P4', '76': 'P41', '77': 'P42', '78': 'P43',
             '79': 'I4', '80': 'I41', '81': 'P-4', '82': 'I-4',
             '83': 'P4/m', '84': 'P42/m', '85': 'P4/n', '86': 'P42/n',
             '87': 'I4/m', '88': 'I41/a', '89': 'P422', '90': 'P4212',
             '91': 'P4122', '92': 'P41212', '93': 'P4222', '94': 'P42212',
             '95': 'P4322', '96': 'P43212', '97': 'I422', '98': 'I4122',
             '99': 'P4mm', '100': 'P4bm', '101': 'P42cm', '102': 'P42nm',
             '103': 'P4cc', '104': 'P4nc', '105': 'P42mc', '106': 'P42bc',
             '107': 'I4mm', '108': 'I4cm', '109': 'I41md', '110': 'I41cd',
             '111': 'P-42m', '112': 'P-42c', '113': 'P-421m',
             '114': 'P-421c', '115': 'P-4m2', '116': 'P-4c2',
             '117': 'P-4b2', '118': 'P-4n2', '119': 'I-4m2',
             '120': 'I-4c2', '121': 'I-42m', '122': 'I-42d',
             '123': 'P4/mmm', '124': 'P4/mcc', '125': 'P4/nbm',
             '126': 'P4/nnc', '127': 'P4/mbm', '128': 'P4/mnc',
             '129': 'P4/nmm', '130': 'P4/ncc', '131': 'P42/mmc',
             '132': 'P42/mcm', '133': 'P42/nbc', '134': 'P42/nnm',
             '135': 'P42/mbc', '136': 'P42/mnm', '137': 'P42/nmc',
             '138': 'P42/ncm', '139': 'I4/mmm', '140': 'I4/mcm',
             '141': 'I41/amd', '142': 'I41/acd', '143': 'P3',
             '144': 'P31', '145': 'P32', '146': 'R3', '147': 'P-3',
             '148': 'R-3', '149': 'P312', '150': 'P321', '151': 'P3112',
             '152': 'P3121', '153': 'P3212', '154': 'P3221', '155': 'R32',
             '156': 'P3m1', '157': 'P31m', '158': 'P3c1', '159': 'P31c',
             '160': 'R3m', '161': 'R3c', '162': 'P-31m', '163': 'P-31c',
             '164': 'P-3m1', '165': 'P-3c1', '166': 'R-3m', '167': 'R-3c',
             '168': 'P6', '169': 'P61', '170': 'P65', '171': 'P62',
             '172': 'P64', '173': 'P63', '174': 'P-6', '175': 'P6/m',
             '176': 'P63/m', '177': 'P622', '178': 'P6122',
             '179': 'P6522', '180': 'P6222', '181': 'P6422',
             '182': 'P6322', '183': 'P6mm', '184': 'P6cc', '185': 'P63cm',
             '186': 'P63mc', '187': 'P-6m2', '188': 'P-6c2',
             '189': 'P-62m', '190': 'P-62c', '191': 'P6/mmm',
             '192': 'P6/mcc', '193': 'P63/mcm', '194': 'P63/mmc',
             '195': 'P23', '196': 'F23', '197': 'I23', '198': 'P213',
             '199': 'I213', '200': 'Pm-3', '201': 'Pn-3', '202': 'Fm-3',
             '203': 'Fd-3', '204': 'Im-3', '205': 'Pa-3', '206': 'Ia-3',
             '207': 'P432', '208': 'P4232', '209': 'F432',
             '210': 'F4132', '211': 'I432', '212': 'P4332',
             '213': 'P4132', '214': 'I4132', '215': 'P-43m',
             '216': 'F-43m', '217': 'I-43m', '218': 'P-43n',
             '219': 'F-43c', '220': 'I-43d', '221': 'Pm-3m',
             '222': 'Pn-3n', '223': 'Pm-3n', '224': 'Pn-3m',
             '225': 'Fm-3m', '226': 'Fm-3c', '227': 'Fd-3m',
             '228': 'Fd-3c', '229': 'Im-3m', '230': 'Ia-3d'}

sgrp_params = {'cubic:1': (('a', ), ('a', 'a', 'a', 90, 90, 90)),
               'cubic:2': (('a', ), ('a', 'a', 'a', 90, 90, 90)),
               'cubic': (('a', ), ('a', 'a', 'a', 90, 90, 90)),
               'hexagonal': (('a', 'c'), ('a', 'a', 'c', 90, 90, 120)),
               'trigonal:R': (('a', 'alpha'), ('a', 'a', 'a', 'alpha',
                                               'alpha', 'alpha')),
               'trigonal:H': (('a', 'c'), ('a', 'a', 'c', 90, 90, 120)),
               'trigonal': (('a', 'c'), ('a', 'a', 'c', 90, 90, 120)),
               'tetragonal:1': (('a', 'c'), ('a', 'a', 'c', 90, 90, 90)),
               'tetragonal:2': (('a', 'c'), ('a', 'a', 'c', 90, 90, 90)),
               'tetragonal': (('a', 'c'), ('a', 'a', 'c', 90, 90, 90)),
               'orthorhombic:1': (('a', 'b', 'c'),
                                  ('a', 'b', 'c', 90, 90, 90)),
               'orthorhombic:2': (('a', 'b', 'c'),
                                  ('a', 'b', 'c', 90, 90, 90)),
               'orthorhombic': (('a', 'b', 'c'),
                                ('a', 'b', 'c', 90, 90, 90)),
               'monoclinic:b': (('a', 'b', 'c', 'beta'),
                                ('a', 'b', 'c', 90, 'beta', 90)),
               'monoclinic:c': (('a', 'b', 'c', 'gamma'),
                                ('a', 'b', 'c', 90, 90, 'gamma')),
               'monoclinic': (('a', 'b', 'c', 'beta'),
                              ('a', 'b', 'c', 90, 'beta', 90)),
               'triclinic': (('a', 'b', 'c', 'alpha', 'beta', 'gamma'),
                             ('a', 'b', 'c', 'alpha', 'beta', 'gamma'))}

eqhkl_default = RangeDict({
                            range(1, 2): lambda h, k, l: ((h, k, l), ),
                            range(2, 3): lambda h, k, l: ((-h, -k, -l), (h, k, l)),
                            range(3, 6): lambda h, k, l: ((h, k, l), (-h, k, -l)),
                            range(6, 10): lambda h, k, l: ((h, -k, l), (h, k, l)),
                            range(10, 16):
                                lambda h, k, l: ((-h, -k, -l), (h, k, l), (-h, k, -l), (h, -k, l)),
                            range(16, 25):
                                lambda h, k, l: ((-h, -k, l), (h, k, l), (h, -k, -l), (-h, k, -l)),
                            range(25, 47):
                                lambda h, k, l: ((-h, -k, l), (h, -k, l), (h, k, l), (-h, k, l)),
                            range(47, 75):
                                lambda h, k, l: ((h, k, l), (-h, k, -l), (-h, -k, l), (-h, -k, -l),
                                                 (h, -k, -l), (h, -k, l), (-h, k, l), (h, k, -l)),
                            range(75, 81):
                                lambda h, k, l: ((-h, -k, l), (k, -h, l), (h, k, l), (-k, h, l)),
                            range(81, 83):
                                lambda h, k, l: ((-h, -k, l), (-k, h, -l), (h, k, l), (k, -h, -l)),
                            range(83, 89):
                                lambda h, k, l: ((h, k, l), (k, -h, l), (-k, h, -l), (-h, -k, l),
                                                 (-h, -k, -l), (-k, h, l), (k, -h, -l), (h, k, -l)),
                            range(89, 99):
                                lambda h, k, l: ((h, k, l), (-h, k, -l), (k, -h, l), (-k, -h, -l),
                                                 (k, h, -l), (-h, -k, l), (h, -k, -l), (-k, h, l)),
                            range(99, 111):
                                lambda h, k, l: ((h, k, l), (k, -h, l), (k, h, l), (-h, -k, l),
                                                 (h, -k, l), (-h, k, l), (-k, h, l), (-k, -h, l)),
                            range(115, 121):
                                lambda h, k, l: ((h, k, l), (-k, -h, -l), (-k, h, -l), (k, h, -l),
                                                 (-h, -k, l), (h, -k, l), (-h, k, l), (k, -h, -l)),
                            (111, 112, 113, 114, 121, 122):
                                lambda h, k, l: ((h, k, l), (-h, k, -l), (-k, h, -l), (k, h, l),
                                                 (-h, -k, l), (h, -k, -l), (k, -h, -l), (-k, -h, l)),
                            range(123, 143):
                                lambda h, k, l: ((h, k, l), (-h, k, -l), (k, -h, l), (-k, -h, -l),
                                                 (k, h, -l), (-k, h, -l), (k, h, l), (-h, -k, l),
                                                 (h, -k, -l), (-h, -k, -l), (h, -k, l), (-h, k, l),
                                                 (-k, h, l), (k, -h, -l), (-k, -h, l), (h, k, -l)),
                            range(143, 147): lambda h, k, l: ((h, k, l), (k, -h-k, l), (-h-k, h, l)),
                            range(147, 149):
                                lambda h, k, l: ((h, k, l), (h+k, -h, -l), (k, -h-k, l),
                                                 (-h, -k, -l), (-k, h+k, -l), (-h-k, h, l)),
                            (149, 151, 153):
                                lambda h, k, l: ((h, k, l), (k, -h-k, l), (-k, -h, -l),
                                                 (-h, h+k, -l), (-h-k, h, l), (h+k, -k, -l)),
                            (150, 152, 154, 155):
                                lambda h, k, l: ((h, k, l), (k, -h-k, l), (-h-k, k, -l),
                                                 (h, -h-k, -l), (k, h, -l), (-h-k, h, l)),
                            (157, 159):
                                lambda h, k, l: ((h, k, l), (k, -h-k, l), (k, h, l), (-h-k, k, l),
                                                 (-h-k, h, l), (h, -h-k, l)),
                            (156, 158, 160, 161):
                                lambda h, k, l: ((h, k, l), (k, -h-k, l), (h+k, -k, l),
                                                 (-h, h+k, l), (-h-k, h, l), (-k, -h, l)),
                            range(162, 164):
                                lambda h, k, l: ((h, k, l), (h+k, -h, -l), (k, -h-k, l),
                                                 (-k, -h, -l), (k, h, l), (-h, h+k, -l), (-h, -k, -l),
                                                 (-k, h+k, -l), (-h-k, k, l), (-h-k, h, l),
                                                 (h+k, -k, -l), (h, -h-k, l)),
                            range(164, 168):
                                lambda h, k, l: ((h, k, l), (h+k, -h, -l), (k, -h-k, l),
                                                 (-h-k, k, -l), (h, -h-k, -l), (h+k, -k, l),
                                                 (k, h, -l), (-h, -k, -l), (-k, h+k, -l),
                                                 (-h, h+k, l), (-h-k, h, l), (-k, -h, l)),
                            range(168, 174):
                                lambda h, k, l: ((h, k, l), (k, -h-k, l), (-k, h+k, l),
                                                 (-h, -k, l), (-h-k, h, l), (h+k, -h, l)),
                            range(174, 175):
                                lambda h, k, l: ((h, k, l), (-h-k, h, -l), (k, -h-k, l),
                                                 (k, -h-k, -l), (-h-k, h, l), (h, k, -l)),
                            range(175, 177):
                                lambda h, k, l: ((h, k, l), (h+k, -h, -l), (k, -h-k, l),
                                                 (-h-k, h, -l), (h, k, -l), (-k, h+k, l),
                                                 (-h, -k, l), (-h, -k, -l), (-k, h+k, -l),
                                                 (k, -h-k, -l), (-h-k, h, l), (h+k, -h, l)),
                            range(177, 183):
                                lambda h, k, l: ((h, k, l), (k, -h-k, l), (-h-k, k, -l), (h, -h-k, -l),
                                                 (-k, -h, -l), (k, h, -l), (-k, h+k, l), (-h, -k, l),
                                                 (-h, h+k, -l), (-h-k, h, l), (h+k, -k, -l),
                                                 (h+k, -h, l)),
                            range(183, 187):
                                lambda h, k, l: ((h, k, l), (k, -h-k, l), (h+k, -k, l), (k, h, l),
                                                 (-k, h+k, l), (-h, -k, l), (-h, h+k, l), (-h-k, k, l),
                                                 (-h-k, h, l), (-k, -h, l), (h, -h-k, l),
                                                 (h+k, -h, l)),
                            range(187, 189):
                                lambda h, k, l: ((h, k, l), (-h-k, h, -l), (k, -h-k, l), (h+k, -k, l),
                                                 (-k, -h, -l), (h+k, -k, -l), (-h, h+k, -l),
                                                 (-h, h+k, l), (k, -h-k, -l), (-h-k, h, l),
                                                 (-k, -h, l), (h, k, -l)),
                            range(189, 191):
                                lambda h, k, l: ((h, k, l), (-h-k, h, -l), (k, -h-k, l),
                                                 (-h-k, k, -l), (h, -h-k, -l), (k, h, -l), (k, h, l),
                                                 (-h-k, k, l), (k, -h-k, -l), (-h-k, h, l),
                                                 (h, -h-k, l), (h, k, -l)),
                            range(191, 195):
                                lambda h, k, l: ((h, k, l), (h+k, -h, -l), (k, h, -l), (k, h, l),
                                                 (-k, h+k, l), (-h, h+k, -l), (h+k, -k, -l),
                                                 (h, -h-k, l), (-h-k, h, -l), (k, -h-k, l),
                                                 (-k, -h, -l), (-h, -k, l), (-h, -k, -l), (-k, -h, l),
                                                 (-h-k, k, -l), (h, -h-k, -l), (h+k, -k, l),
                                                 (-h, h+k, l), (-k, h+k, -l), (-h-k, k, l), (h, k, -l),
                                                 (h+k, -h, l), (k, -h-k, -l), (-h-k, h, l)),
                            range(195, 200):
                                lambda h, k, l: ((h, k, l), (-l, -h, k), (-h, k, -l), (k, -l, -h),
                                                 (l, h, k), (-k, l, -h), (-k, -l, h), (-l, h, -k),
                                                 (-h, -k, l), (h, -k, -l), (l, -h, -k), (k, l, h)),
                            range(200, 207):
                                lambda h, k, l: ((h, k, l), (k, -l, -h), (-l, -h, -k), (k, l, -h),
                                                 (-l, h, k), (-l, h, -k), (l, h, -k), (l, -h, k),
                                                 (k, -l, h), (-h, -k, l), (h, -k, -l), (-h, -k, -l),
                                                 (h, -k, l), (-h, k, l), (l, -h, -k), (k, l, h),
                                                 (l, h, k), (-k, -l, h), (-l, -h, k), (-k, l, -h),
                                                 (h, k, -l), (-h, k, -l), (-k, l, h), (-k, -l, -h)),
                            range(207, 215):
                                lambda h, k, l: ((h, k, l), (k, -l, -h), (k, -h, l), (-l, -k, -h),
                                                 (k, h, -l), (-l, h, -k), (-k, h, l), (-k, -h, -l),
                                                 (-l, k, h), (-h, -k, l), (h, -k, -l), (h, l, -k),
                                                 (-h, l, k), (-h, -l, -k), (l, -h, -k), (k, l, h),
                                                 (l, h, k), (-k, -l, h), (-l, -h, k), (-k, l, -h),
                                                 (h, -l, k), (-h, k, -l), (l, -k, h), (l, k, -h)),
                            range(215, 221):
                                lambda h, k, l: ((h, k, l), (h, -l, -k), (k, -l, -h), (-l, k, -h),
                                                 (-l, h, -k), (k, h, l), (-h, -k, l), (h, -k, -l),
                                                 (h, l, k), (-h, l, -k), (l, -h, -k), (-k, -h, l),
                                                 (k, l, h), (-l, -k, h), (l, k, h), (l, h, k),
                                                 (-k, -l, h), (-k, h, -l), (-l, -h, k), (k, -h, -l),
                                                 (-k, l, -h), (l, -k, -h), (-h, k, -l), (-h, -l, k)),
                            range(221, 231):
                                lambda h, k, l: ((h, k, l), (h, -l, -k), (k, -l, -h), (-l, k, -h),
                                                 (k, -h, l), (-l, -k, -h), (k, h, -l), (-l, -h, -k),
                                                 (-l, h, k), (-l, h, -k), (k, l, -h), (k, h, l),
                                                 (-k, h, l), (l, h, -k), (k, -l, h), (-k, -h, -l),
                                                 (l, -h, k), (-l, k, h), (-h, -k, l), (h, -k, -l),
                                                 (h, l, -k), (-h, l, k), (-h, -l, -k), (-h, -k, -l),
                                                 (h, -k, l), (-h, k, l), (l, -h, -k), (-k, -h, l),
                                                 (k, l, h), (-l, -k, h), (l, h, k), (-k, -l, h),
                                                 (-k, h, -l), (l, k, h), (-h, l, -k), (h, l, k),
                                                 (-l, -h, k), (k, -h, -l), (-k, l, -h), (l, -k, -h),
                                                 (h, -l, k), (h, k, -l), (-h, k, -l), (-h, -l, k),
                                                 (l, -k, h), (-k, l, h), (l, k, -h), (-k, -l, -h))
                        })

eqhkl_custom = RangeDict({
                            range(3, 6): lambda h, k, l: ((-h, -k, l), (h, k, l)),
                            range(6, 10): lambda h, k, l: ((h, k, l), (h, k, -l)),
                            range(10, 16):
                                lambda h, k, l: ((-h, -k, l), (-h, -k, -l), (h, k, l), (h, k, -l)),
                            (48, 50, 59, 68, 70): eqhkl_default[range(47, 75)],
                            (85, 86, 88): eqhkl_default[range(83, 89)],
                            (125, 126, 129, 130, 133, 134, 137, 138, 141, 142):
                                eqhkl_default[range(123, 143)],
                            range(146, 147): lambda h, k, l: ((h, k, l), (k, l, h), (l, h, k)),
                            range(148, 149):
                                lambda h, k, l: ((h, k, l), (-l, -h, -k), (l, h, k), (-k, -l, -h),
                                                 (-h, -k, -l), (k, l, h)),
                            range(155, 156):
                                lambda h, k, l: ((h, k, l), (-l, -k, -h), (l, h, k), (-k, -h, -l),
                                                 (-h, -l, -k), (k, l, h)),
                            range(160, 162):
                                lambda h, k, l: ((h, k, l), (l, k, h), (l, h, k), (k, h, l),
                                                 (h, l, k), (k, l, h)),
                            range(166, 168):
                                lambda h, k, l: ((h, k, l), (-l, -k, -h), (l, h, k), (-k, -h, -l),
                                                 (-l, -h, -k), (-k, -l, -h), (l, k, h), (k, h, l),
                                                 (h, l, k), (-h, -k, -l), (-h, -l, -k), (k, l, h)),
                            (201, 203): eqhkl_default[range(200, 207)],
                            (222, 224, 227, 228): eqhkl_default[range(221, 231)]
                        })

wp = {'1': {'1a': (7, ('(x, y, z)', ), None)},
      '2': {'1a': (0, ('(0, 0, 0)', ), None),
            '1b': (0, ('(0, 0, 1/2)', ), None),
            '1c': (0, ('(0, 1/2, 0)', ), None),
            '1d': (0, ('(1/2, 0, 0)', ), None),
            '1e': (0, ('(1/2, 1/2, 0)', ), None),
            '1f': (0, ('(1/2, 0, 1/2)', ), None),
            '1g': (0, ('(0, 1/2, 1/2)', ), None),
            '1h': (0, ('(1/2, 1/2, 1/2)', ), None),
            '2i': (7, ('(x, y, z)', '(-x, -y, -z)'), None)},
      '3:b': {'1a': (2, ('(0, y, 0)', ), None),
              '1b': (2, ('(0, y, 1/2)', ), None),
              '1c': (2, ('(1/2, y, 0)', ), None),
              '1d': (2, ('(1/2, y, 1/2)', ), None),
              '2e': (7, ('(x, y, z)', '(-x, y, -z)'), None)},
      '3:c': {'1a': (4, ('(0, 0, z)', ), 'n/a'),
              '1b': (4, ('(1/2, 0, z)', ), 'n/a'),
              '1c': (4, ('(0, 1/2, z)', ), 'n/a'),
              '1d': (4, ('(1/2, 1/2, z)', ), 'n/a'),
              '2e': (7, ('(x, y, z)', '(-x, -y, z)'), 'n/a')},
      '4:b': {'2a': (7, ('(x, y, z)', '(-x, y+1/2, -z)'), '0k0: k=2n')},
      '4:c': {'2a': (7, ('(x, y, z)', '(-x, -y, z+1/2)'), 'n/a')},
      '5:b': {'2a': (2, ('(0, y, 0)', '(1/2, y+1/2, 0)'), None),
              '2b': (2, ('(0, y, 1/2)', '(1/2, y+1/2, 1/2)'), None),
              '4c': (7, ('(x, y, z)', '(x+1/2, y+1/2, z)', '(-x, y, -z)',
                         '(-x+1/2, y+1/2, -z)'),
                     'hkl: h+k=2n, h0l: h=2n, 0kl: k=2n, hk0: h+k=2n, '
                     '0k0: k=2n, h00: h=2n')},
      '5:c': {'2a': (4, ('(0, 0, z)', '(0, 1/2, z+1/2)'), 'n/a'),
              '2b': (4, ('(1/2, 0, z)', '(1/2, 1/2, z+1/2)'), 'n/a'),
              '4c': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)', '(-x, -y, z)',
                         '(-x, -y+1/2, z+1/2)'), 'n/a')},
      '6:b': {'1a': (5, ('(x, 0, z)', ), None),
              '1b': (5, ('(x, 1/2, z)', ), None),
              '2c': (7, ('(x, y, z)', '(x, -y, z)'), None)},
      '6:c': {'1a': (3, ('(x, y, 0)', ), 'n/a'),
              '1b': (3, ('(x, y, 1/2)', ), 'n/a'),
              '2c': (7, ('(x, y, z)', '(x, y, -z)'), 'n/a')},
      '7:b': {'2a': (7, ('(x, y, z)', '(x, -y, z+1/2)'), 'h0l: l=2n, '
                     '00l: l=2n')},
      '7:c': {'2a': (7, ('(x, y, z)', '(x+1/2, y, -z)'), 'n/a')},
      '8:b': {'2a': (5, ('(x, 0, z)', '(x+1/2, 1/2, z)'), None),
              '4b': (7, ('(x, y, z)', '(x+1/2, y+1/2, z)', '(x, -y, z)',
                         '(x+1/2, -y+1/2, z)'),
                     'hkl: h+k=2n, h0l: h=2n, 0kl: k=2n, hk0: h+k=2n, '
                     '0k0: k=2n, h00: h=2n')},
      '8:c': {'2a': (3, ('(x, y, 0)', '(x, y+1/2, 1/2)'), 'n/a'),
              '4b': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)', '(x, y, -z)',
                         '(x, y+1/2, -z+1/2)'), 'n/a')},
      '9:b': {'4a': (7, ('(x, y, z)', '(x+1/2, y+1/2, z)', '(x, -y, z+1/2)',
                         '(x+1/2, -y+1/2, z+1/2)'),
                     'hkl: h+k=2n, h0l: h,l=2n, 0kl: k=2n, hk0: h+k=2n, '
                     '0k0: k=2n, h00: h=2n, 00l: l=2n')},
      '9:c': {'4a': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)', '(x+1/2, y, -z)',
                         '(x+1/2, y+1/2, -z+1/2)'), 'n/a')},
      '10:b': {'1a': (0, ('(0, 0, 0)', ), None),
               '1b': (0, ('(0, 1/2, 0)', ), None),
               '1c': (0, ('(0, 0, 1/2)', ), None),
               '1d': (0, ('(1/2, 0, 0)', ), None),
               '1e': (0, ('(1/2, 1/2, 0)', ), None),
               '1f': (0, ('(0, 1/2, 1/2)', ), None),
               '1g': (0, ('(1/2, 0, 1/2)', ), None),
               '1h': (0, ('(1/2, 1/2, 1/2)', ), None),
               '2i': (2, ('(0, y, 0)', '(0, -y, 0)'), None),
               '2j': (2, ('(1/2, y, 0)', '(1/2, -y, 0)'), None),
               '2k': (2, ('(0, y, 1/2)', '(0, -y, 1/2)'), None),
               '2l': (2, ('(1/2, y, 1/2)', '(1/2, -y, 1/2)'), None),
               '2m': (5, ('(x, 0, z)', '(-x, 0, -z)'), None),
               '2n': (5, ('(x, 1/2, z)', '(-x, 1/2, -z)'), None),
               '4o': (7, ('(x, y, z)', '(-x, y, -z)', '(-x, -y, -z)',
                          '(x, -y, z)'), None)},
      '10:c': {'1a': (0, ('(0, 0, 0)', ), 'n/a'),
               '1b': (0, ('(0, 0, 1/2)', ), 'n/a'),
               '1c': (0, ('(1/2, 0, 0)', ), 'n/a'),
               '1d': (0, ('(0, 1/2, 0)', ), 'n/a'),
               '1e': (0, ('(0, 1/2, 1/2)', ), 'n/a'),
               '1f': (0, ('(1/2, 0, 1/2)', ), 'n/a'),
               '1g': (0, ('(1/2, 1/2, 0)', ), 'n/a'),
               '1h': (0, ('(1/2, 1/2, 1/2)', ), 'n/a'),
               '2i': (4, ('(0, 0, z)', '(0, 0, -z)'), 'n/a'),
               '2j': (4, ('(0, 1/2, z)', '(0, 1/2, -z)'), 'n/a'),
               '2k': (4, ('(1/2, 0, z)', '(1/2, 0, -z)'), 'n/a'),
               '2l': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, -z)'), 'n/a'),
               '2m': (3, ('(x, y, 0)', '(-x, -y, 0)'), 'n/a'),
               '2n': (3, ('(x, y, 1/2)', '(-x, -y, 1/2)'), 'n/a'),
               '4o': (7, ('(x, y, z)', '(-x, -y, z)', '(-x, -y, -z)',
                          '(x, y, -z)'), 'n/a')},
      '11:b': {'2a': (0, ('(0, 0, 0)', '(0, 1/2, 0)'), 'hkl: k=2n'),
               '2b': (0, ('(1/2, 0, 0)', '(1/2, 1/2, 0)'), 'hkl: k=2n'),
               '2c': (0, ('(0, 0, 1/2)', '(0, 1/2, 1/2)'), 'hkl: k=2n'),
               '2d': (0, ('(1/2, 0, 1/2)', '(1/2, 1/2, 1/2)'), 'hkl: k=2n'),
               '2e': (5, ('(x, 1/4, z)', '(-x, 3/4, -z)'), None),
               '4f': (7, ('(x, y, z)', '(-x, y+1/2, -z)', '(-x, -y, -z)',
                          '(x, -y+1/2, z)'), '0k0: k=2n')},
      '11:c': {'2a': (0, ('(0, 0, 0)', '(0, 0, 1/2)'), 'n/a'),
               '2b': (0, ('(0, 1/2, 0)', '(0, 1/2, 1/2)'), 'n/a'),
               '2c': (0, ('(1/2, 0, 0)', '(1/2, 0, 1/2)'), 'n/a'),
               '2d': (0, ('(1/2, 1/2, 0)', '(1/2, 1/2, 1/2)'), 'n/a'),
               '2e': (3, ('(x, y, 1/4)', '(-x, -y, 3/4)'), 'n/a'),
               '4f': (7, ('(x, y, z)', '(-x, -y, z+1/2)', '(-x, -y, -z)',
                          '(x, y, -z+1/2)'), 'n/a')},
      '12:b': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)'), None),
               '2b': (0, ('(0, 1/2, 0)', '(1/2, 0, 0)'), None),
               '2c': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)'), None),
               '2d': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)'), None),
               '4e': (0, ('(1/4, 1/4, 0)', '(3/4, 3/4, 0)', '(3/4, 1/4, 0)',
                          '(1/4, 3/4, 0)'), 'hkl: h=2n'),
               '4f': (0, ('(1/4, 1/4, 1/2)', '(3/4, 3/4, 1/2)',
                          '(3/4, 1/4, 1/2)', '(1/4, 3/4, 1/2)'), 'hkl: h=2n'),
               '4g': (2, ('(0, y, 0)', '(1/2, y+1/2, 0)', '(0, -y, 0)',
                          '(1/2, -y+1/2, 0)'), None),
               '4h': (2, ('(0, y, 1/2)', '(1/2, y+1/2, 1/2)', '(0, -y, 1/2)',
                          '(1/2, -y+1/2, 1/2)'), None),
               '4i': (5, ('(x, 0, z)', '(x+1/2, 1/2, z)', '(-x, 0, -z)',
                          '(-x+1/2, 1/2, -z)'), None),
               '8j': (7, ('(x, y, z)', '(x+1/2, y+1/2, z)', '(-x, y, -z)',
                          '(-x+1/2, y+1/2, -z)', '(-x, -y, -z)',
                          '(-x+1/2, -y+1/2, -z)', '(x, -y, z)',
                          '(x+1/2, -y+1/2, z)'),
                      'hkl: h+k=2n, h0l: h=2n, 0kl: k=2n, hk0: h+k=2n, '
                      '0k0: k=2n, h00: h=2n')},
      '12:c': {'2a': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)'), 'n/a'),
               '2b': (0, ('(0, 0, 1/2)', '(0, 1/2, 0)'), 'n/a'),
               '2c': (0, ('(1/2, 0, 0)', '(1/2, 1/2, 1/2)'), 'n/a'),
               '2d': (0, ('(1/2, 0, 1/2)', '(1/2, 1/2, 0)'), 'n/a'),
               '4e': (0, ('(0, 1/4, 1/4)', '(0, 3/4, 3/4)', '(0, 3/4, 1/4)',
                          '(0, 1/4, 3/4)'), 'n/a'),
               '4f': (0, ('(1/2, 1/4, 1/4)', '(1/2, 3/4, 3/4)',
                          '(1/2, 3/4, 1/4)', '(1/2, 1/4, 3/4)'), 'n/a'),
               '4g': (4, ('(0, 0, z)', '(0, 1/2, z+1/2)', '(0, 0, -z)',
                          '(0, 1/2, -z+1/2)'), 'n/a'),
               '4h': (4, ('(1/2, 0, z)', '(1/2, 1/2, z+1/2)', '(1/2, 0, -z)',
                          '(1/2, 1/2, -z+1/2)'), 'n/a'),
               '4i': (3, ('(x, y, 0)', '(x, y+1/2, 1/2)', '(-x, -y, 0)',
                          '(-x, -y+1/2, 1/2)'), 'n/a'),
               '8j': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)', '(-x, -y, z)',
                          '(-x, -y+1/2, z+1/2)', '(-x, -y, -z)',
                          '(-x, -y+1/2, -z+1/2)', '(x, y, -z)',
                          '(x, y+1/2, -z+1/2)'), 'n/a')},
      '13:b': {'2a': (0, ('(0, 0, 0)', '(0, 0, 1/2)'), 'hkl: l=2n'),
               '2b': (0, ('(1/2, 1/2, 0)', '(1/2, 1/2, 1/2)'), 'hkl: l=2n'),
               '2c': (0, ('(0, 1/2, 0)', '(0, 1/2, 1/2)'), 'hkl: l=2n'),
               '2d': (0, ('(1/2, 0, 0)', '(1/2, 0, 1/2)'), 'hkl: l=2n'),
               '2e': (2, ('(0, y, 1/4)', '(0, -y, 3/4)'), None),
               '2f': (2, ('(1/2, y, 1/4)', '(1/2, -y, 3/4)'), None),
               '4g': (7, ('(x, y, z)', '(-x, y, -z+1/2)', '(-x, -y, -z)',
                          '(x, -y, z+1/2)'), 'h0l: l=2n, 00l: l=2n')},
      '13:c': {'2a': (0, ('(0, 0, 0)', '(1/2, 0, 0)'), 'n/a'),
               '2b': (0, ('(0, 1/2, 1/2)', '(1/2, 1/2, 1/2)'), 'n/a'),
               '2c': (0, ('(0, 0, 1/2)', '(1/2, 0, 1/2)'), 'n/a'),
               '2d': (0, ('(0, 1/2, 0)', '(1/2, 1/2, 0)'), 'n/a'),
               '2e': (4, ('(1/4, 0, z)', '(3/4, 0, -z)'), 'n/a'),
               '2f': (4, ('(1/4, 1/2, z)', '(3/4, 1/2, -z)'), 'n/a'),
               '4g': (7, ('(x, y, z)', '(-x+1/2, -y, z)', '(-x, -y, -z)',
                          '(x+1/2, y, -z)'), 'n/a')},
      '14:b': {'2a': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)'), 'hkl: k+l=2n'),
               '2b': (0, ('(1/2, 0, 0)', '(1/2, 1/2, 1/2)'), 'hkl: k+l=2n'),
               '2c': (0, ('(0, 0, 1/2)', '(0, 1/2, 0)'), 'hkl: k+l=2n'),
               '2d': (0, ('(1/2, 0, 1/2)', '(1/2, 1/2, 0)'), 'hkl: k+l=2n'),
               '4e': (7, ('(x, y, z)', '(-x, y+1/2, -z+1/2)', '(-x, -y, -z)',
                          '(x, -y+1/2, z+1/2)'),
                      'h0l: l=2n, 0k0: k=2n, 00l: l=2n')},
      '14:c': {'2a': (0, ('(0, 0, 0)', '(1/2, 0, 1/2)'), 'n/a'),
               '2b': (0, ('(0, 1/2, 0)', '(1/2, 1/2, 1/2)'), 'n/a'),
               '2c': (0, ('(1/2, 0, 0)', '(0, 0, 1/2)'), 'n/a'),
               '2d': (0, ('(1/2, 1/2, 0)', '(0, 1/2, 1/2)'), 'n/a'),
               '4e': (7, ('(x, y, z)', '(-x+1/2, -y, z+1/2)', '(-x, -y, -z)',
                          '(x+1/2, y, -z+1/2)'), 'n/a')},
      '15:b': {'4a': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(0, 0, 1/2)',
                          '(1/2, 1/2, 1/2)'), 'hkl: l=2n'),
               '4b': (0, ('(0, 1/2, 0)', '(1/2, 0, 0)', '(0, 1/2, 1/2)',
                          '(1/2, 0, 1/2)'), 'hkl: l=2n'),
               '4c': (0, ('(1/4, 1/4, 0)', '(3/4, 3/4, 0)', '(3/4, 1/4, 1/2)',
                          '(1/4, 3/4, 1/2)'), 'hkl: k+l=2n'),
               '4d': (0, ('(1/4, 1/4, 1/2)', '(3/4, 3/4, 1/2)',
                          '(3/4, 1/4, 0)', '(1/4, 3/4, 0)'), 'hkl: k+l=2n'),
               '4e': (2, ('(0, y, 1/4)', '(1/2, y+1/2, 1/4)', '(0, -y, 3/4)',
                          '(1/2, -y+1/2, 3/4)'), None),
               '8f': (7, ('(x, y, z)', '(x+1/2, y+1/2, z)', '(-x, y, -z+1/2)',
                          '(-x+1/2, y+1/2, -z+1/2)', '(-x, -y, -z)',
                          '(-x+1/2, -y+1/2, -z)', '(x, -y, z+1/2)',
                          '(x+1/2, -y+1/2, z+1/2)'),
                      'hkl: h+k=2n, h0l: h,l=2n, 0kl: k=2n, hk0: h+k=2n, '
                      '0k0: k=2n, h00: h=2n, 00l: l=2n')},
      '15:c': {'4a': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 0)',
                          '(1/2, 1/2, 1/2)'), 'n/a'),
               '4b': (0, ('(0, 0, 1/2)', '(0, 1/2, 0)', '(1/2, 0, 1/2)',
                          '(1/2, 1/2, 0)'), 'n/a'),
               '4c': (0, ('(0, 1/4, 1/4)', '(0, 3/4, 3/4)', '(1/2, 3/4, 1/4)',
                          '(1/2, 1/4, 3/4)'), 'n/a'),
               '4d': (0, ('(1/2, 1/4, 1/4)', '(1/2, 3/4, 3/4)',
                          '(0, 3/4, 1/4)', '(0, 1/4, 3/4)'), 'n/a'),
               '4e': (4, ('(1/4, 0, z)', '(1/4, 1/2, z+1/2)', '(3/4, 0, -z)',
                          '(3/4, 1/2, -z+1/2)'), 'n/a'),
               '8f': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)', '(-x+1/2, -y, z)',
                          '(-x+1/2, -y+1/2, z+1/2)', '(-x, -y, -z)',
                          '(-x, -y+1/2, -z+1/2)', '(x+1/2, y, -z)',
                          '(x+1/2, y+1/2, -z+1/2)'), 'n/a')},
      '16': {'1a': (0, ('(0, 0, 0)', ), None),
             '1b': (0, ('(1/2, 0, 0)', ), None),
             '1c': (0, ('(0, 1/2, 0)', ), None),
             '1d': (0, ('(0, 0, 1/2)', ), None),
             '1e': (0, ('(1/2, 1/2, 0)', ), None),
             '1f': (0, ('(1/2, 0, 1/2)', ), None),
             '1g': (0, ('(0, 1/2, 1/2)', ), None),
             '1h': (0, ('(1/2, 1/2, 1/2)', ), None),
             '2i': (1, ('(x, 0, 0)', '(-x, 0, 0)'), None),
             '2j': (1, ('(x, 0, 1/2)', '(-x, 0, 1/2)'), None),
             '2k': (1, ('(x, 1/2, 0)', '(-x, 1/2, 0)'), None),
             '2l': (1, ('(x, 1/2, 1/2)', '(-x, 1/2, 1/2)'), None),
             '2m': (2, ('(0, y, 0)', '(0, -y, 0)'), None),
             '2n': (2, ('(0, y, 1/2)', '(0, -y, 1/2)'), None),
             '2o': (2, ('(1/2, y, 0)', '(1/2, -y, 0)'), None),
             '2p': (2, ('(1/2, y, 1/2)', '(1/2, -y, 1/2)'), None),
             '2q': (4, ('(0, 0, z)', '(0, 0, -z)'), None),
             '2r': (4, ('(1/2, 0, z)', '(1/2, 0, -z)'), None),
             '2s': (4, ('(0, 1/2, z)', '(0, 1/2, -z)'), None),
             '2t': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, -z)'), None),
             '4u': (7, ('(x, y, z)', '(-x, -y, z)', '(-x, y, -z)',
                        '(x, -y, -z)'), None)},
      '17': {'2a': (1, ('(x, 0, 0)', '(-x, 0, 1/2)'), '0kl: l=2n'),
             '2b': (1, ('(x, 1/2, 0)', '(-x, 1/2, 1/2)'), '0kl: l=2n'),
             '2c': (2, ('(0, y, 1/4)', '(0, -y, 3/4)'), 'h0l: l=2n'),
             '2d': (2, ('(1/2, y, 1/4)', '(1/2, -y, 3/4)'), 'h0l: l=2n'),
             '4e': (7, ('(x, y, z)', '(-x, -y, z+1/2)', '(-x, y, -z+1/2)',
                        '(x, -y, -z)'), '00l: l=2n')},
      '18': {'2a': (4, ('(0, 0, z)', '(1/2, 1/2, -z)'), 'hk0: h+k=2n'),
             '2b': (4, ('(0, 1/2, z)', '(1/2, 0, -z)'), 'hk0: h+k=2n'),
             '4c': (7, ('(x, y, z)', '(-x, -y, z)', '(-x+1/2, y+1/2, -z)',
                        '(x+1/2, -y+1/2, -z)'), 'h00: h=2n, 0k0: k=2n')},
      '19': {'4a': (7, ('(x, y, z)', '(-x+1/2, -y, z+1/2)',
                        '(-x, y+1/2, -z+1/2)', '(x+1/2, -y+1/2, -z)'),
                    'h00: h=2n, 0k0: k=2n, 00l: l=2n')},
      '20': {'4a': (1, ('(x, 0, 0)', '(x+1/2, 1/2, 0)', '(-x, 0, 1/2)',
                        '(-x+1/2, 1/2, 1/2)'), '0kl: l=2n'),
             '4b': (2, ('(0, y, 1/4)', '(1/2, y+1/2, 1/4)', '(0, -y, 3/4)',
                        '(1/2, -y+1/2, 3/4)'), 'h0l: l=2n'),
             '8c': (7, ('(x, y, z)', '(x+1/2, y+1/2, z)', '(-x, -y, z+1/2)',
                        '(-x+1/2, -y+1/2, z+1/2)', '(-x, y, -z+1/2)',
                        '(-x+1/2, y+1/2, -z+1/2)', '(x, -y, -z)',
                        '(x+1/2, -y+1/2, -z)'),
                    'hkl: h+k=2n, 0kl: k=2n, h0l: h=2n, hk0: h+k=2n, '
                    'h00: h=2n, 0k0: k=2n, 00l: l=2n')},
      '21': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)'), None),
             '2b': (0, ('(0, 1/2, 0)', '(1/2, 0, 0)'), None),
             '2c': (0, ('(1/2, 0, 1/2)', '(0, 1/2, 1/2)'), None),
             '2d': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)'), None),
             '4e': (1, ('(x, 0, 0)', '(x+1/2, 1/2, 0)', '(-x, 0, 0)',
                        '(-x+1/2, 1/2, 0)'), None),
             '4f': (1, ('(x, 0, 1/2)', '(x+1/2, 1/2, 1/2)', '(-x, 0, 1/2)',
                        '(-x+1/2, 1/2, 1/2)'), None),
             '4g': (2, ('(0, y, 0)', '(1/2, y+1/2, 0)', '(0, -y, 0)',
                        '(1/2, -y+1/2, 0)'), None),
             '4h': (2, ('(0, y, 1/2)', '(1/2, y+1/2, 1/2)', '(0, -y, 1/2)',
                        '(1/2, -y+1/2, 1/2)'), None),
             '4i': (4, ('(0, 0, z)', '(1/2, 1/2, z)', '(0, 0, -z)',
                        '(1/2, 1/2, -z)'), None),
             '4j': (4, ('(0, 1/2, z)', '(1/2, 0, z)', '(0, 1/2, -z)',
                        '(1/2, 0, -z)'), None),
             '4k': (4, ('(1/4, 1/4, z)', '(3/4, 3/4, z)', '(3/4, 1/4, -z)',
                        '(1/4, 3/4, -z)'), 'hk0: h=2n'),
             '8l': (7, ('(x, y, z)', '(x+1/2, y+1/2, z)', '(-x, -y, z)',
                        '(-x+1/2, -y+1/2, z)', '(-x, y, -z)',
                        '(-x+1/2, y+1/2, -z)', '(x, -y, -z)',
                        '(x+1/2, -y+1/2, -z)'),
                    'hkl: h+k=2n, 0kl: k=2n, h0l: h=2n, hk0: h+k=2n, '
                    'h00: h=2n, 0k0: k=2n')},
      '22': {'4a': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                        '(1/2, 1/2, 0)'), None),
             '4b': (0, ('(0, 0, 1/2)', '(0, 1/2, 0)', '(1/2, 0, 0)',
                        '(1/2, 1/2, 1/2)'), None),
             '4c': (0, ('(1/4, 1/4, 1/4)', '(1/4, 3/4, 3/4)',
                        '(3/4, 1/4, 3/4)', '(3/4, 3/4, 1/4)'), None),
             '4d': (0, ('(1/4, 1/4, 3/4)', '(1/4, 3/4, 1/4)',
                        '(3/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)'), None),
             '8e': (1, ('(x, 0, 0)', '(x, 1/2, 1/2)', '(x+1/2, 0, 1/2)',
                        '(x+1/2, 1/2, 0)', '(-x, 0, 0)', '(-x, 1/2, 1/2)',
                        '(-x+1/2, 0, 1/2)', '(-x+1/2, 1/2, 0)'), None),
             '8f': (2, ('(0, y, 0)', '(0, y+1/2, 1/2)', '(1/2, y, 1/2)',
                        '(1/2, y+1/2, 0)', '(0, -y, 0)', '(0, -y+1/2, 1/2)',
                        '(1/2, -y, 1/2)', '(1/2, -y+1/2, 0)'), None),
             '8g': (4, ('(0, 0, z)', '(0, 1/2, z+1/2)', '(1/2, 0, z+1/2)',
                        '(1/2, 1/2, z)', '(0, 0, -z)', '(0, 1/2, -z+1/2)',
                        '(1/2, 0, -z+1/2)', '(1/2, 1/2, -z)'), None),
             '8h': (4, ('(1/4, 1/4, z)', '(1/4, 3/4, z+1/2)',
                        '(3/4, 1/4, z+1/2)', '(3/4, 3/4, z)',
                        '(3/4, 1/4, -z)', '(3/4, 3/4, -z+1/2)',
                        '(1/4, 1/4, -z+1/2)', '(1/4, 3/4, -z)'), None),
             '8i': (2, ('(1/4, y, 1/4)', '(1/4, y+1/2, 3/4)', '(3/4, y, 3/4)',
                        '(3/4, y+1/2, 1/4)', '(3/4, -y, 1/4)',
                        '(3/4, -y+1/2, 3/4)', '(1/4, -y, 3/4)',
                        '(1/4, -y+1/2, 1/4)'), None),
             '8j': (1, ('(x, 1/4, 1/4)', '(x, 3/4, 3/4)', '(x+1/2, 1/4, 3/4)',
                        '(x+1/2, 3/4, 1/4)', '(-x, 3/4, 1/4)',
                        '(-x, 1/4, 3/4)', '(-x+1/2, 3/4, 3/4)',
                        '(-x+1/2, 1/4, 1/4)'), None),
             '16k': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)',
                         '(x+1/2, y, z+1/2)', '(x+1/2, y+1/2, z)',
                         '(-x, -y, z)', '(-x, -y+1/2, z+1/2)',
                         '(-x+1/2, -y, z+1/2)', '(-x+1/2, -y+1/2, z)',
                         '(-x, y, -z)', '(-x, y+1/2, -z+1/2)',
                         '(-x+1/2, y, -z+1/2)', '(-x+1/2, y+1/2, -z)',
                         '(x, -y, -z)', '(x, -y+1/2, -z+1/2)',
                         '(x+1/2, -y, -z+1/2)', '(x+1/2, -y+1/2, -z)'),
                     'hkl: h+k,h+l,k+l=2n, 0kl: k,l=2n, h0l: h,l=2n, '
                     'hk0: h,k=2n, h00: h=2n, 0k0: k=2n, 00l: l=2n')},
      '23': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)'), None),
             '2b': (0, ('(1/2, 0, 0)', '(0, 1/2, 1/2)'), None),
             '2c': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)'), None),
             '2d': (0, ('(0, 1/2, 0)', '(1/2, 0, 1/2)'), None),
             '4e': (1, ('(x, 0, 0)', '(x+1/2, 1/2, 1/2)', '(-x, 0, 0)',
                        '(-x+1/2, 1/2, 1/2)'), None),
             '4f': (1, ('(x, 0, 1/2)', '(x+1/2, 1/2, 0)', '(-x, 0, 1/2)',
                        '(-x+1/2, 1/2, 0)'), None),
             '4g': (2, ('(0, y, 0)', '(1/2, y+1/2, 1/2)', '(0, -y, 0)',
                        '(1/2, -y+1/2, 1/2)'), None),
             '4h': (2, ('(1/2, y, 0)', '(0, y+1/2, 1/2)', '(1/2, -y, 0)',
                        '(0, -y+1/2, 1/2)'), None),
             '4i': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(0, 0, -z)',
                        '(1/2, 1/2, -z+1/2)'), None),
             '4j': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(0, 1/2, -z)',
                        '(1/2, 0, -z+1/2)'), None),
             '8k': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                        '(-x+1/2, -y+1/2, z+1/2)', '(-x, y, -z)',
                        '(-x+1/2, y+1/2, -z+1/2)', '(x, -y, -z)',
                        '(x+1/2, -y+1/2, -z+1/2)'),
                    'hkl: h+k+l=2n, 0kl: k+l=2n, h0l: h+l=2n, hk0: h+k=2n, '
                    'h00: h=2n, 0k0: k=2n, 00l: l=2n')},
      '24': {'4a': (1, ('(x, 0, 1/4)', '(x+1/2, 1/2, 3/4)',
                        '(-x+1/2, 0, 3/4)', '(-x, 1/2, 1/4)'), '0kl: k=2n'),
             '4b': (2, ('(1/4, y, 0)', '(3/4, y+1/2, 1/2)', '(1/4, -y, 1/2)',
                        '(3/4, -y+1/2, 0)'), 'h0l: h=2n'),
             '4c': (4, ('(0, 1/4, z)', '(1/2, 3/4, z+1/2)',
                        '(0, 3/4, -z+1/2)', '(1/2, 1/4, -z)'), 'hk0: h=2n'),
             '8d': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)',
                        '(-x+1/2, -y, z+1/2)', '(-x, -y+1/2, z)',
                        '(-x, y+1/2, -z+1/2)', '(-x+1/2, y, -z)',
                        '(x+1/2, -y+1/2, -z)', '(x, -y, -z+1/2)'),
                    'hkl: h+k+l=2n, 0kl: k+l=2n, h0l: h+l=2n, hk0: h+k=2n, '
                    'h00: h=2n, 0k0: k=2n, 00l: l=2n')},
      '25': {'1a': (4, ('(0, 0, z)', ), None),
             '1b': (4, ('(0, 1/2, z)', ), None),
             '1c': (4, ('(1/2, 0, z)', ), None),
             '1d': (4, ('(1/2, 1/2, z)', ), None),
             '2e': (5, ('(x, 0, z)', '(-x, 0, z)'), None),
             '2f': (5, ('(x, 1/2, z)', '(-x, 1/2, z)'), None),
             '2g': (6, ('(0, y, z)', '(0, -y, z)'), None),
             '2h': (6, ('(1/2, y, z)', '(1/2, -y, z)'), None),
             '4i': (7, ('(x, y, z)', '(-x, -y, z)', '(x, -y, z)',
                        '(-x, y, z)'), None)},
      '26': {'2a': (6, ('(0, y, z)', '(0, -y, z+1/2)'), None),
             '2b': (6, ('(1/2, y, z)', '(1/2, -y, z+1/2)'), None),
             '4c': (7, ('(x, y, z)', '(-x, -y, z+1/2)', '(x, -y, z+1/2)',
                        '(-x, y, z)'), 'h0l: l=2n, 00l: l=2n')},
      '27': {'2a': (4, ('(0, 0, z)', '(0, 0, z+1/2)'), 'hkl: l=2n'),
             '2b': (4, ('(0, 1/2, z)', '(0, 1/2, z+1/2)'), 'hkl: l=2n'),
             '2c': (4, ('(1/2, 0, z)', '(1/2, 0, z+1/2)'), 'hkl: l=2n'),
             '2d': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, z+1/2)'), 'hkl: l=2n'),
             '4e': (7, ('(x, y, z)', '(-x, -y, z)', '(x, -y, z+1/2)',
                        '(-x, y, z+1/2)'), '0kl: l=2n, h0l: l=2n, 00l: l=2n'
                    )},
      '28': {'2a': (4, ('(0, 0, z)', '(1/2, 0, z)'), 'hkl: h=2n'),
             '2b': (4, ('(0, 1/2, z)', '(1/2, 1/2, z)'), 'hkl: h=2n'),
             '2c': (6, ('(1/4, y, z)', '(3/4, -y, z)'), None),
             '4d': (7, ('(x, y, z)', '(-x, -y, z)', '(x+1/2, -y, z)',
                        '(-x+1/2, y, z)'), 'h0l: h=2n, h00: h=2n')},
      '29': {'4a': (7, ('(x, y, z)', '(-x, -y, z+1/2)', '(x+1/2, -y, z)',
                        '(-x+1/2, y, z+1/2)'),
                    '0kl: l=2n, h0l: h=2n, h00: h=2n, 00l: l=2n')},
      '30': {'2a': (4, ('(0, 0, z)', '(0, 1/2, z+1/2)'), 'hkl: k+l=2n'),
             '2b': (4, ('(1/2, 0, z)', '(1/2, 1/2, z+1/2)'), 'hkl: k+l=2n'),
             '4c': (7, ('(x, y, z)', '(-x, -y, z)', '(x, -y+1/2, z+1/2)',
                        '(-x, y+1/2, z+1/2)'),
                    '0kl: k+l=2n, h0l: l=2n, 0k0: k=2n, 00l: l=2n')},
      '31': {'2a': (6, ('(0, y, z)', '(1/2, -y, z+1/2)'), None),
             '4b': (7, ('(x, y, z)', '(-x+1/2, -y, z+1/2)',
                        '(x+1/2, -y, z+1/2)', '(-x, y, z)'),
                    'h0l: h+l=2n, h00: h=2n, 00l: l=2n')},
      '32': {'2a': (4, ('(0, 0, z)', '(1/2, 1/2, z)'), 'hkl: h+k=2n'),
             '2b': (4, ('(0, 1/2, z)', '(1/2, 0, z)'), 'hkl: h+k=2n'),
             '4c': (7, ('(x, y, z)', '(-x, -y, z)', '(x+1/2, -y+1/2, z)',
                        '(-x+1/2, y+1/2, z)'),
                    '0kl: k=2n, h0l: h=2n, h00: h=2n, 0k0: k=2n')},
      '33': {'4a': (7, ('(x, y, z)', '(-x, -y, z+1/2)', '(x+1/2, -y+1/2, z)',
                        '(-x+1/2, y+1/2, z+1/2)'),
                    '0kl: k+l=2n, h0l: h=2n, h00: h=2n, 0k0: k=2n, 00l: l=2n'
                    )},
      '34': {'2a': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)'), 'hkl: h+k+l=2n'),
             '2b': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)'), 'hkl: h+k+l=2n'),
             '4c': (7, ('(x, y, z)', '(-x, -y, z)', '(x+1/2, -y+1/2, z+1/2)',
                        '(-x+1/2, y+1/2, z+1/2)'),
                    '0kl: k+l=2n, h0l: h+l=2n, h00: h=2n, 0k0: k=2n, '
                    '00l: l=2n')},
      '35': {'2a': (4, ('(0, 0, z)', '(1/2, 1/2, z)'), None),
             '2b': (4, ('(0, 1/2, z)', '(1/2, 0, z)'), None),
             '4c': (4, ('(1/4, 1/4, z)', '(3/4, 3/4, z)', '(1/4, 3/4, z)',
                        '(3/4, 1/4, z)'), 'hkl: h=2n'),
             '4d': (5, ('(x, 0, z)', '(x+1/2, 1/2, z)', '(-x, 0, z)',
                        '(-x+1/2, 1/2, z)'), None),
             '4e': (6, ('(0, y, z)', '(1/2, y+1/2, z)', '(0, -y, z)',
                        '(1/2, -y+1/2, z)'), None),
             '8f': (7, ('(x, y, z)', '(x+1/2, y+1/2, z)', '(-x, -y, z)',
                        '(-x+1/2, -y+1/2, z)', '(x, -y, z)',
                        '(x+1/2, -y+1/2, z)', '(-x, y, z)',
                        '(-x+1/2, y+1/2, z)'),
                    'hkl: h+k=2n, 0kl: k=2n, h0l: h=2n, hk0: h+k=2n, '
                    'h00: h=2n, 0k0: k=2n')},
      '36': {'4a': (6, ('(0, y, z)', '(1/2, y+1/2, z)', '(0, -y, z+1/2)',
                        '(1/2, -y+1/2, z+1/2)'), None),
             '8b': (7, ('(x, y, z)', '(x+1/2, y+1/2, z)', '(-x, -y, z+1/2)',
                        '(-x+1/2, -y+1/2, z+1/2)', '(x, -y, z+1/2)',
                        '(x+1/2, -y+1/2, z+1/2)', '(-x, y, z)',
                        '(-x+1/2, y+1/2, z)'),
                    'hkl: h+k=2n, 0kl: k=2n, h0l: h,l=2n, hk0: h+k=2n, '
                    'h00: h=2n, 0k0: k=2n, 00l: l=2n')},
      '37': {'4a': (4, ('(0, 0, z)', '(1/2, 1/2, z)', '(0, 0, z+1/2)',
                        '(1/2, 1/2, z+1/2)'), 'hkl: l=2n'),
             '4b': (4, ('(0, 1/2, z)', '(1/2, 0, z)', '(0, 1/2, z+1/2)',
                        '(1/2, 0, z+1/2)'), 'hkl: l=2n'),
             '4c': (4, ('(1/4, 1/4, z)', '(3/4, 3/4, z)', '(1/4, 3/4, z+1/2)',
                        '(3/4, 1/4, z+1/2)'), 'hkl: k+l=2n'),
             '8d': (7, ('(x, y, z)', '(x+1/2, y+1/2, z)', '(-x, -y, z)',
                        '(-x+1/2, -y+1/2, z)', '(x, -y, z+1/2)',
                        '(x+1/2, -y+1/2, z+1/2)', '(-x, y, z+1/2)',
                        '(-x+1/2, y+1/2, z+1/2)'),
                    'hkl: h+k=2n, 0kl: k,l=2n, h0l: h,l=2n, hk0: h+k=2n, '
                    'h00: h=2n, 0k0: k=2n, 00l: l=2n')},
      '38': {'2a': (4, ('(0, 0, z)', '(0, 1/2, z+1/2)'), None),
             '2b': (4, ('(1/2, 0, z)', '(1/2, 1/2, z+1/2)'), None),
             '4c': (5, ('(x, 0, z)', '(x, 1/2, z+1/2)', '(-x, 0, z)',
                        '(-x, 1/2, z+1/2)'), None),
             '4d': (6, ('(0, y, z)', '(0, y+1/2, z+1/2)', '(0, -y, z)',
                        '(0, -y+1/2, z+1/2)'), None),
             '4e': (6, ('(1/2, y, z)', '(1/2, y+1/2, z+1/2)', '(1/2, -y, z)',
                        '(1/2, -y+1/2, z+1/2)'), None),
             '8f': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)', '(-x, -y, z)',
                        '(-x, -y+1/2, z+1/2)', '(x, -y, z)',
                        '(x, -y+1/2, z+1/2)', '(-x, y, z)',
                        '(-x, y+1/2, z+1/2)'),
                    'hkl: k+l=2n, 0kl: k+l=2n, h0l: l=2n, hk0: k=2n, '
                    '0k0: k=2n, 00l: l=2n')},
      '39': {'4a': (4, ('(0, 0, z)', '(0, 1/2, z+1/2)', '(0, 1/2, z)',
                        '(0, 0, z+1/2)'), 'hkl: k=2n'),
             '4b': (4, ('(1/2, 0, z)', '(1/2, 1/2, z+1/2)', '(1/2, 1/2, z)',
                        '(1/2, 0, z+1/2)'), 'hkl: k=2n'),
             '4c': (5, ('(x, 1/4, z)', '(x, 3/4, z+1/2)', '(-x, 3/4, z)',
                        '(-x, 1/4, z+1/2)'), None),
             '8d': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)', '(-x, -y, z)',
                        '(-x, -y+1/2, z+1/2)', '(x, -y+1/2, z)',
                        '(x, -y, z+1/2)', '(-x, y+1/2, z)', '(-x, y, z+1/2)'),
                    'hkl: k+l=2n, 0kl: k,l=2n, h0l: l=2n, hk0: k=2n, '
                    '0k0: k=2n, 00l: l=2n')},
      '40': {'4a': (4, ('(0, 0, z)', '(0, 1/2, z+1/2)', '(1/2, 0, z)',
                        '(1/2, 1/2, z+1/2)'), 'hkl: h=2n'),
             '4b': (6, ('(1/4, y, z)', '(1/4, y+1/2, z+1/2)', '(3/4, -y, z)',
                        '(3/4, -y+1/2, z+1/2)'), None),
             '8c': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)', '(-x, -y, z)',
                        '(-x, -y+1/2, z+1/2)', '(x+1/2, -y, z)',
                        '(x+1/2, -y+1/2, z+1/2)', '(-x+1/2, y, z)',
                        '(-x+1/2, y+1/2, z+1/2)'),
                    'hkl: k+l=2n, 0kl: k+l=2n, h0l: h,l=2n, hk0: k=2n, '
                    'h00: h=2n, 0k0: k=2n, 00l: l=2n')},
      '41': {'4a': (4, ('(0, 0, z)', '(0, 1/2, z+1/2)', '(1/2, 1/2, z)',
                        '(1/2, 0, z+1/2)'), 'hkl: h+k=2n'),
             '8b': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)', '(-x, -y, z)',
                        '(-x, -y+1/2, z+1/2)', '(x+1/2, -y+1/2, z)',
                        '(x+1/2, -y, z+1/2)', '(-x+1/2, y+1/2, z)',
                        '(-x+1/2, y, z+1/2)'),
                    'hkl: k+l=2n, 0kl: k,l=2n, h0l: h,l=2n, hk0: k=2n, '
                    'h00: h=2n, 0k0: k=2n, 00l: l=2n')},
      '42': {'4a': (4, ('(0, 0, z)', '(0, 1/2, z+1/2)', '(1/2, 0, z+1/2)',
                        '(1/2, 1/2, z)'), None),
             '8b': (4, ('(1/4, 1/4, z)', '(1/4, 3/4, z+1/2)',
                        '(3/4, 1/4, z+1/2)', '(3/4, 3/4, z)', '(1/4, 3/4, z)',
                        '(1/4, 1/4, z+1/2)', '(3/4, 3/4, z+1/2)',
                        '(3/4, 1/4, z)'), 'hkl: h=2n'),
             '8c': (6, ('(0, y, z)', '(0, y+1/2, z+1/2)', '(1/2, y, z+1/2)',
                        '(1/2, y+1/2, z)', '(0, -y, z)', '(0, -y+1/2, z+1/2)',
                        '(1/2, -y, z+1/2)', '(1/2, -y+1/2, z)'), None),
             '8d': (5, ('(x, 0, z)', '(x, 1/2, z+1/2)', '(x+1/2, 0, z+1/2)',
                        '(x+1/2, 1/2, z)', '(-x, 0, z)', '(-x, 1/2, z+1/2)',
                        '(-x+1/2, 0, z+1/2)', '(-x+1/2, 1/2, z)'), None),
             '16e': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)',
                         '(x+1/2, y, z+1/2)', '(x+1/2, y+1/2, z)',
                         '(-x, -y, z)', '(-x, -y+1/2, z+1/2)',
                         '(-x+1/2, -y, z+1/2)', '(-x+1/2, -y+1/2, z)',
                         '(x, -y, z)', '(x, -y+1/2, z+1/2)',
                         '(x+1/2, -y, z+1/2)', '(x+1/2, -y+1/2, z)',
                         '(-x, y, z)', '(-x, y+1/2, z+1/2)',
                         '(-x+1/2, y, z+1/2)', '(-x+1/2, y+1/2, z)'),
                     'hkl: h+k,h+l,k+l=2n, 0kl: k,l=2n, h0l: h,l=2n, '
                     'hk0: h,k=2n, h00: h=2n, 0k0: k=2n, 00l: l=2n')},
      '43': {'8a': (4, ('(0, 0, z)', '(1/2, 0, z+1/2)', '(0, 1/2, z+1/2)',
                        '(1/2, 1/2, z)', '(1/4, 1/4, z+1/4)',
                        '(3/4, 1/4, z+3/4)', '(1/4, 3/4, z+3/4)',
                        '(3/4, 3/4, z+1/4)'), 'hkl: h=2n+1 or h+k+l=4n'),
             '16b': (7, ('(x, y, z)', '(x+1/2, y, z+1/2)',
                         '(x, y+1/2, z+1/2)', '(x+1/2, y+1/2, z)',
                         '(-x, -y, z)', '(-x+1/2, -y, z+1/2)',
                         '(-x, -y+1/2, z+1/2)', '(-x+1/2, -y+1/2, z)',
                         '(x+1/4, -y+1/4, z+1/4)', '(x+3/4, -y+1/4, z+3/4)',
                         '(x+1/4, -y+3/4, z+3/4)', '(x+3/4, -y+3/4, z+1/4)',
                         '(-x+1/4, y+1/4, z+1/4)', '(-x+3/4, y+1/4, z+3/4)',
                         '(-x+1/4, y+3/4, z+3/4)', '(-x+3/4, y+3/4, z+1/4)'),
                     'hkl: h+k,h+l,k+l=2n, 0kl: k+l=4n, k,l=2n, h0l: h+l=4n, '
                     'h,l=2n, hk0: h,k=2n, h00: h=4n, 0k0: k=4n, 00l: l=4n')},
      '44': {'2a': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)'), None),
             '2b': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)'), None),
             '4c': (5, ('(x, 0, z)', '(x+1/2, 1/2, z+1/2)', '(-x, 0, z)',
                        '(-x+1/2, 1/2, z+1/2)'), None),
             '4d': (6, ('(0, y, z)', '(1/2, y+1/2, z+1/2)', '(0, -y, z)',
                        '(1/2, -y+1/2, z+1/2)'), None),
             '8e': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                        '(-x+1/2, -y+1/2, z+1/2)', '(x, -y, z)',
                        '(x+1/2, -y+1/2, z+1/2)', '(-x, y, z)',
                        '(-x+1/2, y+1/2, z+1/2)'),
                    'hkl: h+k+l=2n, 0kl: k+l=2n, h0l: h+l=2n, hk0: h+k=2n, '
                    'h00: h=2n, 0k0: k=2n, 00l: l=2n')},
      '45': {'4a': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(1/2, 1/2, z)',
                        '(0, 0, z+1/2)'), 'hkl: l=2n'),
             '4b': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(1/2, 0, z)',
                        '(0, 1/2, z+1/2)'), 'hkl: l=2n'),
             '8c': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                        '(-x+1/2, -y+1/2, z+1/2)', '(x+1/2, -y+1/2, z)',
                        '(x, -y, z+1/2)', '(-x+1/2, y+1/2, z)',
                        '(-x, y, z+1/2)'),
                    'hkl: h+k+l=2n, 0kl: k,l=2n, h0l: h,l=2n, hk0: h+k=2n, '
                    'h00: h=2n, 0k0: k=2n, 00l: l=2n')},
      '46': {'4a': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(1/2, 0, z)',
                        '(0, 1/2, z+1/2)'), 'hkl: h=2n'),
             '4b': (6, ('(1/4, y, z)', '(3/4, y+1/2, z+1/2)', '(3/4, -y, z)',
                        '(1/4, -y+1/2, z+1/2)'), None),
             '8c': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                        '(-x+1/2, -y+1/2, z+1/2)', '(x+1/2, -y, z)',
                        '(x, -y+1/2, z+1/2)', '(-x+1/2, y, z)',
                        '(-x, y+1/2, z+1/2)'),
                    'hkl: h+k+l=2n, 0kl: k+l=2n, h0l: h,l=2n, hk0: h+k=2n, '
                    'h00: h=2n, 0k0: k=2n, 00l: l=2n')},
      '47': {'8A': (7, ('(x, y, z)', '(-x, -y, z)', '(-x, y, -z)',
                        '(x, -y, -z)', '(-x, -y, -z)', '(x, y, -z)',
                        '(x, -y, z)', '(-x, y, z)'), None),
             '1a': (0, ('(0, 0, 0)', ), None),
             '1b': (0, ('(1/2, 0, 0)', ), None),
             '1c': (0, ('(0, 0, 1/2)', ), None),
             '1d': (0, ('(1/2, 0, 1/2)', ), None),
             '1e': (0, ('(0, 1/2, 0)', ), None),
             '1f': (0, ('(1/2, 1/2, 0)', ), None),
             '1g': (0, ('(0, 1/2, 1/2)', ), None),
             '1h': (0, ('(1/2, 1/2, 1/2)', ), None),
             '2i': (1, ('(x, 0, 0)', '(-x, 0, 0)'), None),
             '2j': (1, ('(x, 0, 1/2)', '(-x, 0, 1/2)'), None),
             '2k': (1, ('(x, 1/2, 0)', '(-x, 1/2, 0)'), None),
             '2l': (1, ('(x, 1/2, 1/2)', '(-x, 1/2, 1/2)'), None),
             '2m': (2, ('(0, y, 0)', '(0, -y, 0)'), None),
             '2n': (2, ('(0, y, 1/2)', '(0, -y, 1/2)'), None),
             '2o': (2, ('(1/2, y, 0)', '(1/2, -y, 0)'), None),
             '2p': (2, ('(1/2, y, 1/2)', '(1/2, -y, 1/2)'), None),
             '2q': (4, ('(0, 0, z)', '(0, 0, -z)'), None),
             '2r': (4, ('(0, 1/2, z)', '(0, 1/2, -z)'), None),
             '2s': (4, ('(1/2, 0, z)', '(1/2, 0, -z)'), None),
             '2t': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, -z)'), None),
             '4u': (6, ('(0, y, z)', '(0, -y, z)', '(0, y, -z)',
                        '(0, -y, -z)'), None),
             '4v': (6, ('(1/2, y, z)', '(1/2, -y, z)', '(1/2, y, -z)',
                        '(1/2, -y, -z)'), None),
             '4w': (5, ('(x, 0, z)', '(-x, 0, z)', '(-x, 0, -z)',
                        '(x, 0, -z)'), None),
             '4x': (5, ('(x, 1/2, z)', '(-x, 1/2, z)', '(-x, 1/2, -z)',
                        '(x, 1/2, -z)'), None),
             '4y': (3, ('(x, y, 0)', '(-x, -y, 0)', '(-x, y, 0)',
                        '(x, -y, 0)'), None),
             '4z': (3, ('(x, y, 1/2)', '(-x, -y, 1/2)', '(-x, y, 1/2)',
                        '(x, -y, 1/2)'), None)},
      '48:1': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)'), 'hkl: h+k+l=2n'),
               '2b': (0, ('(1/2, 0, 0)', '(0, 1/2, 1/2)'), 'hkl: h+k+l=2n'),
               '2c': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)'), 'hkl: h+k+l=2n'),
               '2d': (0, ('(0, 1/2, 0)', '(1/2, 0, 1/2)'), 'hkl: h+k+l=2n'),
               '4e': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 1/4)',
                          '(3/4, 1/4, 3/4)', '(1/4, 3/4, 3/4)'),
                      'hkl: h+k,h+l,k+l=2n'),
               '4f': (0, ('(3/4, 3/4, 3/4)', '(1/4, 1/4, 3/4)',
                          '(1/4, 3/4, 1/4)', '(3/4, 1/4, 1/4)'),
                      'hkl: h+k,h+l,k+l=2n'),
               '4g': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(-x+1/2, 1/2, 1/2)',
                          '(x+1/2, 1/2, 1/2)'), 'hkl: h+k+l=2n'),
               '4h': (1, ('(x, 0, 1/2)', '(-x, 0, 1/2)', '(-x+1/2, 1/2, 0)',
                          '(x+1/2, 1/2, 0)'), 'hkl: h+k+l=2n'),
               '4i': (2, ('(0, y, 0)', '(0, -y, 0)', '(1/2, -y+1/2, 1/2)',
                          '(1/2, y+1/2, 1/2)'), 'hkl: h+k+l=2n'),
               '4j': (2, ('(1/2, y, 0)', '(1/2, -y, 0)', '(0, -y+1/2, 1/2)',
                          '(0, y+1/2, 1/2)'), 'hkl: h+k+l=2n'),
               '4k': (4, ('(0, 0, z)', '(0, 0, -z)', '(1/2, 1/2, -z+1/2)',
                          '(1/2, 1/2, z+1/2)'), 'hkl: h+k+l=2n'),
               '4l': (4, ('(0, 1/2, z)', '(0, 1/2, -z)', '(1/2, 0, -z+1/2)',
                          '(1/2, 0, z+1/2)'), 'hkl: h+k+l=2n'),
               '8m': (7, ('(x, y, z)', '(-x, -y, z)', '(-x, y, -z)',
                          '(x, -y, -z)', '(-x+1/2, -y+1/2, -z+1/2)',
                          '(x+1/2, y+1/2, -z+1/2)', '(x+1/2, -y+1/2, z+1/2)',
                          '(-x+1/2, y+1/2, z+1/2)'),
                      '0kl: k+l=2n, h0l: h+l=2n, hk0: h+k=2n, h00: h=2n, '
                      '0k0: k=2n, 00l: l=2n')},
      '48:2': {'2a': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)'), 'n/a'),
               '2b': (0, ('(3/4, 1/4, 1/4)', '(1/4, 3/4, 3/4)'), 'n/a'),
               '2c': (0, ('(1/4, 1/4, 3/4)', '(3/4, 3/4, 1/4)'), 'n/a'),
               '2d': (0, ('(1/4, 3/4, 1/4)', '(3/4, 1/4, 3/4)'), 'n/a'),
               '4e': (0, ('(1/2, 1/2, 1/2)', '(0, 0, 1/2)', '(0, 1/2, 0)',
                          '(1/2, 0, 0)'), 'n/a'),
               '4f': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(1/2, 0, 1/2)',
                          '(0, 1/2, 1/2)'), 'n/a'),
               '4g': (1, ('(x, 1/4, 1/4)', '(-x+1/2, 1/4, 1/4)',
                          '(-x, 3/4, 3/4)', '(x+1/2, 3/4, 3/4)'), 'n/a'),
               '4h': (1, ('(x, 1/4, 3/4)', '(-x+1/2, 1/4, 3/4)',
                          '(-x, 3/4, 1/4)', '(x+1/2, 3/4, 1/4)'), 'n/a'),
               '4i': (2, ('(1/4, y, 1/4)', '(1/4, -y+1/2, 1/4)',
                          '(3/4, -y, 3/4)', '(3/4, y+1/2, 3/4)'), 'n/a'),
               '4j': (2, ('(3/4, y, 1/4)', '(3/4, -y+1/2, 1/4)',
                          '(1/4, -y, 3/4)', '(1/4, y+1/2, 3/4)'), 'n/a'),
               '4k': (4, ('(1/4, 1/4, z)', '(1/4, 1/4, -z+1/2)',
                          '(3/4, 3/4, -z)', '(3/4, 3/4, z+1/2)'), 'n/a'),
               '4l': (4, ('(1/4, 3/4, z)', '(1/4, 3/4, -z+1/2)',
                          '(3/4, 1/4, -z)', '(3/4, 1/4, z+1/2)'), 'n/a'),
               '8m': (7, ('(x, y, z)', '(-x+1/2, -y+1/2, z)',
                          '(-x+1/2, y, -z+1/2)', '(x, -y+1/2, -z+1/2)',
                          '(-x, -y, -z)', '(x+1/2, y+1/2, -z)',
                          '(x+1/2, -y, z+1/2)', '(-x, y+1/2, z+1/2)'), 'n/a'
                      )},
      '49': {'2a': (0, ('(0, 0, 0)', '(0, 0, 1/2)'), 'hkl: l=2n'),
             '2b': (0, ('(1/2, 1/2, 0)', '(1/2, 1/2, 1/2)'), 'hkl: l=2n'),
             '2c': (0, ('(0, 1/2, 0)', '(0, 1/2, 1/2)'), 'hkl: l=2n'),
             '2d': (0, ('(1/2, 0, 0)', '(1/2, 0, 1/2)'), 'hkl: l=2n'),
             '2e': (0, ('(0, 0, 1/4)', '(0, 0, 3/4)'), 'hkl: l=2n'),
             '2f': (0, ('(1/2, 0, 1/4)', '(1/2, 0, 3/4)'), 'hkl: l=2n'),
             '2g': (0, ('(0, 1/2, 1/4)', '(0, 1/2, 3/4)'), 'hkl: l=2n'),
             '2h': (0, ('(1/2, 1/2, 1/4)', '(1/2, 1/2, 3/4)'), 'hkl: l=2n'),
             '4i': (1, ('(x, 0, 1/4)', '(-x, 0, 1/4)', '(-x, 0, 3/4)',
                        '(x, 0, 3/4)'), 'hkl: l=2n'),
             '4j': (1, ('(x, 1/2, 1/4)', '(-x, 1/2, 1/4)', '(-x, 1/2, 3/4)',
                        '(x, 1/2, 3/4)'), 'hkl: l=2n'),
             '4k': (2, ('(0, y, 1/4)', '(0, -y, 1/4)', '(0, -y, 3/4)',
                        '(0, y, 3/4)'), 'hkl: l=2n'),
             '4l': (2, ('(1/2, y, 1/4)', '(1/2, -y, 1/4)', '(1/2, -y, 3/4)',
                        '(1/2, y, 3/4)'), 'hkl: l=2n'),
             '4m': (4, ('(0, 0, z)', '(0, 0, -z+1/2)', '(0, 0, -z)',
                        '(0, 0, z+1/2)'), 'hkl: l=2n'),
             '4n': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, -z+1/2)',
                        '(1/2, 1/2, -z)', '(1/2, 1/2, z+1/2)'), 'hkl: l=2n'),
             '4o': (4, ('(0, 1/2, z)', '(0, 1/2, -z+1/2)', '(0, 1/2, -z)',
                        '(0, 1/2, z+1/2)'), 'hkl: l=2n'),
             '4p': (4, ('(1/2, 0, z)', '(1/2, 0, -z+1/2)', '(1/2, 0, -z)',
                        '(1/2, 0, z+1/2)'), 'hkl: l=2n'),
             '4q': (3, ('(x, y, 0)', '(-x, -y, 0)', '(-x, y, 1/2)',
                        '(x, -y, 1/2)'), None),
             '8r': (7, ('(x, y, z)', '(-x, -y, z)', '(-x, y, -z+1/2)',
                        '(x, -y, -z+1/2)', '(-x, -y, -z)', '(x, y, -z)',
                        '(x, -y, z+1/2)', '(-x, y, z+1/2)'),
                    '0kl: l=2n, h0l: l=2n, 00l: l=2n')},
      '50:1': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)'), 'hkl: h+k=2n'),
               '2b': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)'), 'hkl: h+k=2n'),
               '2c': (0, ('(1/2, 0, 1/2)', '(0, 1/2, 1/2)'), 'hkl: h+k=2n'),
               '2d': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)'), 'hkl: h+k=2n'),
               '4e': (0, ('(1/4, 1/4, 0)', '(3/4, 3/4, 0)', '(3/4, 1/4, 0)',
                          '(1/4, 3/4, 0)'), 'hkl: h,k=2n'),
               '4f': (0, ('(1/4, 1/4, 1/2)', '(3/4, 3/4, 1/2)',
                          '(3/4, 1/4, 1/2)', '(1/4, 3/4, 1/2)'), 'hkl: h,k=2n'
                      ),
               '4g': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(-x+1/2, 1/2, 0)',
                          '(x+1/2, 1/2, 0)'), 'hkl: h+k=2n'),
               '4h': (1, ('(x, 0, 1/2)', '(-x, 0, 1/2)', '(-x+1/2, 1/2, 1/2)',
                          '(x+1/2, 1/2, 1/2)'), 'hkl: h+k=2n'),
               '4i': (2, ('(0, y, 0)', '(0, -y, 0)', '(1/2, -y+1/2, 0)',
                          '(1/2, y+1/2, 0)'), 'hkl: h+k=2n'),
               '4j': (2, ('(0, y, 1/2)', '(0, -y, 1/2)', '(1/2, -y+1/2, 1/2)',
                          '(1/2, y+1/2, 1/2)'), 'hkl: h+k=2n'),
               '4k': (4, ('(0, 0, z)', '(0, 0, -z)', '(1/2, 1/2, -z)',
                          '(1/2, 1/2, z)'), 'hkl: h+k=2n'),
               '4l': (4, ('(0, 1/2, z)', '(0, 1/2, -z)', '(1/2, 0, -z)',
                          '(1/2, 0, z)'), 'hkl: h+k=2n'),
               '8m': (7, ('(x, y, z)', '(-x, -y, z)', '(-x, y, -z)',
                          '(x, -y, -z)', '(-x+1/2, -y+1/2, -z)',
                          '(x+1/2, y+1/2, -z)', '(x+1/2, -y+1/2, z)',
                          '(-x+1/2, y+1/2, z)'),
                      '0kl: k=2n, h0l: h=2n, hk0: h+k=2n, h00: h=2n, '
                      '0k0: k=2n')},
      '50:2': {'2a': (0, ('(1/4, 1/4, 0)', '(3/4, 3/4, 0)'), 'n/a'),
               '2b': (0, ('(3/4, 1/4, 0)', '(1/4, 3/4, 0)'), 'n/a'),
               '2c': (0, ('(3/4, 1/4, 1/2)', '(1/4, 3/4, 1/2)'), 'n/a'),
               '2d': (0, ('(1/4, 1/4, 1/2)', '(3/4, 3/4, 1/2)'), 'n/a'),
               '4e': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(1/2, 0, 0)',
                          '(0, 1/2, 0)'), 'n/a'),
               '4f': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)', '(1/2, 0, 1/2)',
                          '(0, 1/2, 1/2)'), 'n/a'),
               '4g': (1, ('(x, 1/4, 0)', '(-x+1/2, 1/4, 0)', '(-x, 3/4, 0)',
                          '(x+1/2, 3/4, 0)'), 'n/a'),
               '4h': (1, ('(x, 1/4, 1/2)', '(-x+1/2, 1/4, 1/2)',
                          '(-x, 3/4, 1/2)', '(x+1/2, 3/4, 1/2)'), 'n/a'),
               '4i': (2, ('(1/4, y, 0)', '(1/4, -y+1/2, 0)', '(3/4, -y, 0)',
                          '(3/4, y+1/2, 0)'), 'n/a'),
               '4j': (2, ('(1/4, y, 1/2)', '(1/4, -y+1/2, 1/2)',
                          '(3/4, -y, 1/2)', '(3/4, y+1/2, 1/2)'), 'n/a'),
               '4k': (4, ('(1/4, 1/4, z)', '(1/4, 1/4, -z)', '(3/4, 3/4, -z)',
                          '(3/4, 3/4, z)'), 'n/a'),
               '4l': (4, ('(1/4, 3/4, z)', '(1/4, 3/4, -z)', '(3/4, 1/4, -z)',
                          '(3/4, 1/4, z)'), 'n/a'),
               '8m': (7, ('(x, y, z)', '(-x+1/2, -y+1/2, z)',
                          '(-x+1/2, y, -z)', '(x, -y+1/2, -z)',
                          '(-x, -y, -z)', '(x+1/2, y+1/2, -z)',
                          '(x+1/2, -y, z)', '(-x, y+1/2, z)'), 'n/a')},
      '51': {'2a': (0, ('(0, 0, 0)', '(1/2, 0, 0)'), 'hkl: h=2n'),
             '2b': (0, ('(0, 1/2, 0)', '(1/2, 1/2, 0)'), 'hkl: h=2n'),
             '2c': (0, ('(0, 0, 1/2)', '(1/2, 0, 1/2)'), 'hkl: h=2n'),
             '2d': (0, ('(0, 1/2, 1/2)', '(1/2, 1/2, 1/2)'), 'hkl: h=2n'),
             '2e': (4, ('(1/4, 0, z)', '(3/4, 0, -z)'), None),
             '2f': (4, ('(1/4, 1/2, z)', '(3/4, 1/2, -z)'), None),
             '4g': (2, ('(0, y, 0)', '(1/2, -y, 0)', '(0, -y, 0)',
                        '(1/2, y, 0)'), 'hkl: h=2n'),
             '4h': (2, ('(0, y, 1/2)', '(1/2, -y, 1/2)', '(0, -y, 1/2)',
                        '(1/2, y, 1/2)'), 'hkl: h=2n'),
             '4i': (5, ('(x, 0, z)', '(-x+1/2, 0, z)', '(-x, 0, -z)',
                        '(x+1/2, 0, -z)'), None),
             '4j': (5, ('(x, 1/2, z)', '(-x+1/2, 1/2, z)', '(-x, 1/2, -z)',
                        '(x+1/2, 1/2, -z)'), None),
             '4k': (6, ('(1/4, y, z)', '(1/4, -y, z)', '(3/4, y, -z)',
                        '(3/4, -y, -z)'), None),
             '8l': (7, ('(x, y, z)', '(-x+1/2, -y, z)', '(-x, y, -z)',
                        '(x+1/2, -y, -z)', '(-x, -y, -z)', '(x+1/2, y, -z)',
                        '(x, -y, z)', '(-x+1/2, y, z)'), 'hk0: h=2n, '
                    'h00: h=2n')},
      '52': {'4a': (0, ('(0, 0, 0)', '(1/2, 0, 0)', '(1/2, 1/2, 1/2)',
                        '(0, 1/2, 1/2)'), 'hkl: h,k+l=2n'),
             '4b': (0, ('(0, 0, 1/2)', '(1/2, 0, 1/2)', '(1/2, 1/2, 0)',
                        '(0, 1/2, 0)'), 'hkl: h,k+l=2n'),
             '4c': (4, ('(1/4, 0, z)', '(1/4, 1/2, -z+1/2)', '(3/4, 0, -z)',
                        '(3/4, 1/2, z+1/2)'), 'hkl: h+k+l=2n'),
             '4d': (1, ('(x, 1/4, 1/4)', '(-x+1/2, 3/4, 1/4)',
                        '(-x, 3/4, 3/4)', '(x+1/2, 1/4, 3/4)'), 'hkl: h+l=2n'
                    ),
             '8e': (7, ('(x, y, z)', '(-x+1/2, -y, z)',
                        '(-x+1/2, y+1/2, -z+1/2)', '(x, -y+1/2, -z+1/2)',
                        '(-x, -y, -z)', '(x+1/2, y, -z)',
                        '(x+1/2, -y+1/2, z+1/2)', '(-x, y+1/2, z+1/2)'),
                    '0kl: k+l=2n, h0l: h+l=2n, hk0: h=2n, h00: h=2n, '
                    '0k0: k=2n, 00l: l=2n')},
      '53': {'2a': (0, ('(0, 0, 0)', '(1/2, 0, 1/2)'), 'hkl: h+l=2n'),
             '2b': (0, ('(1/2, 0, 0)', '(0, 0, 1/2)'), 'hkl: h+l=2n'),
             '2c': (0, ('(1/2, 1/2, 0)', '(0, 1/2, 1/2)'), 'hkl: h+l=2n'),
             '2d': (0, ('(0, 1/2, 0)', '(1/2, 1/2, 1/2)'), 'hkl: h+l=2n'),
             '4e': (1, ('(x, 0, 0)', '(-x+1/2, 0, 1/2)', '(-x, 0, 0)',
                        '(x+1/2, 0, 1/2)'), 'hkl: h+l=2n'),
             '4f': (1, ('(x, 1/2, 0)', '(-x+1/2, 1/2, 1/2)', '(-x, 1/2, 0)',
                        '(x+1/2, 1/2, 1/2)'), 'hkl: h+l=2n'),
             '4g': (2, ('(1/4, y, 1/4)', '(1/4, -y, 3/4)', '(3/4, -y, 3/4)',
                        '(3/4, y, 1/4)'), 'hkl: h=2n'),
             '4h': (6, ('(0, y, z)', '(1/2, -y, z+1/2)', '(1/2, y, -z+1/2)',
                        '(0, -y, -z)'), None),
             '8i': (7, ('(x, y, z)', '(-x+1/2, -y, z+1/2)',
                        '(-x+1/2, y, -z+1/2)', '(x, -y, -z)', '(-x, -y, -z)',
                        '(x+1/2, y, -z+1/2)', '(x+1/2, -y, z+1/2)',
                        '(-x, y, z)'),
                    'h0l: h+l=2n, hk0: h=2n, h00: h=2n, 00l: l=2n')},
      '54': {'4a': (0, ('(0, 0, 0)', '(1/2, 0, 0)', '(0, 0, 1/2)',
                        '(1/2, 0, 1/2)'), 'hkl: h,l=2n'),
             '4b': (0, ('(0, 1/2, 0)', '(1/2, 1/2, 0)', '(0, 1/2, 1/2)',
                        '(1/2, 1/2, 1/2)'), 'hkl: h,l=2n'),
             '4c': (2, ('(0, y, 1/4)', '(1/2, -y, 1/4)', '(0, -y, 3/4)',
                        '(1/2, y, 3/4)'), 'hkl: h+l=2n'),
             '4d': (4, ('(1/4, 0, z)', '(3/4, 0, -z+1/2)', '(3/4, 0, -z)',
                        '(1/4, 0, z+1/2)'), 'hkl: l=2n'),
             '4e': (4, ('(1/4, 1/2, z)', '(3/4, 1/2, -z+1/2)',
                        '(3/4, 1/2, -z)', '(1/4, 1/2, z+1/2)'), 'hkl: l=2n'),
             '8f': (7, ('(x, y, z)', '(-x+1/2, -y, z)', '(-x, y, -z+1/2)',
                        '(x+1/2, -y, -z+1/2)', '(-x, -y, -z)',
                        '(x+1/2, y, -z)', '(x, -y, z+1/2)',
                        '(-x+1/2, y, z+1/2)'),
                    '0kl: l=2n, h0l: l=2n, hk0: h=2n, h00: h=2n, 00l: l=2n')},
      '55': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)'), 'hkl: h+k=2n'),
             '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)'), 'hkl: h+k=2n'),
             '2c': (0, ('(0, 1/2, 0)', '(1/2, 0, 0)'), 'hkl: h+k=2n'),
             '2d': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)'), 'hkl: h+k=2n'),
             '4e': (4, ('(0, 0, z)', '(1/2, 1/2, -z)', '(0, 0, -z)',
                        '(1/2, 1/2, z)'), 'hkl: h+k=2n'),
             '4f': (4, ('(0, 1/2, z)', '(1/2, 0, -z)', '(0, 1/2, -z)',
                        '(1/2, 0, z)'), 'hkl: h+k=2n'),
             '4g': (3, ('(x, y, 0)', '(-x, -y, 0)', '(-x+1/2, y+1/2, 0)',
                        '(x+1/2, -y+1/2, 0)'), None),
             '4h': (3, ('(x, y, 1/2)', '(-x, -y, 1/2)',
                        '(-x+1/2, y+1/2, 1/2)', '(x+1/2, -y+1/2, 1/2)'), None
                    ),
             '8i': (7, ('(x, y, z)', '(-x, -y, z)', '(-x+1/2, y+1/2, -z)',
                        '(x+1/2, -y+1/2, -z)', '(-x, -y, -z)', '(x, y, -z)',
                        '(x+1/2, -y+1/2, z)', '(-x+1/2, y+1/2, z)'),
                    '0kl: k=2n, h0l: h=2n, h00: h=2n, 0k0: k=2n')},
      '56': {'4a': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(0, 1/2, 1/2)',
                        '(1/2, 0, 1/2)'), 'hkl: h+k,h+l,k+l=2n'),
             '4b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)', '(0, 1/2, 0)',
                        '(1/2, 0, 0)'), 'hkl: h+k,h+l,k+l=2n'),
             '4c': (4, ('(1/4, 1/4, z)', '(3/4, 3/4, -z+1/2)',
                        '(3/4, 3/4, -z)', '(1/4, 1/4, z+1/2)'), 'hkl: l=2n'),
             '4d': (4, ('(1/4, 3/4, z)', '(3/4, 1/4, -z+1/2)',
                        '(3/4, 1/4, -z)', '(1/4, 3/4, z+1/2)'), 'hkl: l=2n'),
             '8e': (7, ('(x, y, z)', '(-x+1/2, -y+1/2, z)',
                        '(-x, y+1/2, -z+1/2)', '(x+1/2, -y, -z+1/2)',
                        '(-x, -y, -z)', '(x+1/2, y+1/2, -z)',
                        '(x, -y+1/2, z+1/2)', '(-x+1/2, y, z+1/2)'),
                    '0kl: l=2n, h0l: l=2n, hk0: h+k=2n, h00: h=2n, 0k0: k=2n, '
                    '00l: l=2n')},
      '57': {'4a': (0, ('(0, 0, 0)', '(0, 0, 1/2)', '(0, 1/2, 1/2)',
                        '(0, 1/2, 0)'), 'hkl: k,l=2n'),
             '4b': (0, ('(1/2, 0, 0)', '(1/2, 0, 1/2)', '(1/2, 1/2, 1/2)',
                        '(1/2, 1/2, 0)'), 'hkl: k,l=2n'),
             '4c': (1, ('(x, 1/4, 0)', '(-x, 3/4, 1/2)', '(-x, 3/4, 0)',
                        '(x, 1/4, 1/2)'), 'hkl: l=2n'),
             '4d': (3, ('(x, y, 1/4)', '(-x, -y, 3/4)', '(-x, y+1/2, 1/4)',
                        '(x, -y+1/2, 3/4)'), None),
             '8e': (7, ('(x, y, z)', '(-x, -y, z+1/2)', '(-x, y+1/2, -z+1/2)',
                        '(x, -y+1/2, -z)', '(-x, -y, -z)', '(x, y, -z+1/2)',
                        '(x, -y+1/2, z+1/2)', '(-x, y+1/2, z)'),
                    '0kl: k=2n, h0l: l=2n, 0k0: k=2n, 00l: l=2n')},
      '58': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)'), 'hkl: h+k+l=2n'),
             '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)'), 'hkl: h+k+l=2n'),
             '2c': (0, ('(0, 1/2, 0)', '(1/2, 0, 1/2)'), 'hkl: h+k+l=2n'),
             '2d': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 0)'), 'hkl: h+k+l=2n'),
             '4e': (4, ('(0, 0, z)', '(1/2, 1/2, -z+1/2)', '(0, 0, -z)',
                        '(1/2, 1/2, z+1/2)'), 'hkl: h+k+l=2n'),
             '4f': (4, ('(0, 1/2, z)', '(1/2, 0, -z+1/2)', '(0, 1/2, -z)',
                        '(1/2, 0, z+1/2)'), 'hkl: h+k+l=2n'),
             '4g': (3, ('(x, y, 0)', '(-x, -y, 0)', '(-x+1/2, y+1/2, 1/2)',
                        '(x+1/2, -y+1/2, 1/2)'), None),
             '8h': (7, ('(x, y, z)', '(-x, -y, z)', '(-x+1/2, y+1/2, -z+1/2)',
                        '(x+1/2, -y+1/2, -z+1/2)', '(-x, -y, -z)',
                        '(x, y, -z)', '(x+1/2, -y+1/2, z+1/2)',
                        '(-x+1/2, y+1/2, z+1/2)'),
                    '0kl: k+l=2n, h0l: h+l=2n, h00: h=2n, 0k0: k=2n, '
                    '00l: l=2n')},
      '59:1': {'2a': (4, ('(0, 0, z)', '(1/2, 1/2, -z)'), None),
               '2b': (4, ('(0, 1/2, z)', '(1/2, 0, -z)'), None),
               '4c': (0, ('(1/4, 1/4, 0)', '(3/4, 3/4, 0)', '(1/4, 3/4, 0)',
                          '(3/4, 1/4, 0)'), 'hkl: h,k=2n'),
               '4d': (0, ('(1/4, 1/4, 1/2)', '(3/4, 3/4, 1/2)',
                          '(1/4, 3/4, 1/2)', '(3/4, 1/4, 1/2)'), 'hkl: h,k=2n'
                      ),
               '4e': (6, ('(0, y, z)', '(0, -y, z)', '(1/2, y+1/2, -z)',
                          '(1/2, -y+1/2, -z)'), None),
               '4f': (5, ('(x, 0, z)', '(-x, 0, z)', '(-x+1/2, 1/2, -z)',
                          '(x+1/2, 1/2, -z)'), None),
               '8g': (7, ('(x, y, z)', '(-x, -y, z)', '(-x+1/2, y+1/2, -z)',
                          '(x+1/2, -y+1/2, -z)', '(-x+1/2, -y+1/2, -z)',
                          '(x+1/2, y+1/2, -z)', '(x, -y, z)', '(-x, y, z)'),
                      'hk0: h+k=2n, h00: h=2n, 0k0: k=2n')},
      '59:2': {'2a': (4, ('(1/4, 1/4, z)', '(3/4, 3/4, -z)'), 'n/a'),
               '2b': (4, ('(1/4, 3/4, z)', '(3/4, 1/4, -z)'), 'n/a'),
               '4c': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(0, 1/2, 0)',
                          '(1/2, 0, 0)'), 'n/a'),
               '4d': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)', '(0, 1/2, 1/2)',
                          '(1/2, 0, 1/2)'), 'n/a'),
               '4e': (6, ('(1/4, y, z)', '(1/4, -y+1/2, z)',
                          '(3/4, y+1/2, -z)', '(3/4, -y, -z)'), 'n/a'),
               '4f': (5, ('(x, 1/4, z)', '(-x+1/2, 1/4, z)', '(-x, 3/4, -z)',
                          '(x+1/2, 3/4, -z)'), 'n/a'),
               '8g': (7, ('(x, y, z)', '(-x+1/2, -y+1/2, z)',
                          '(-x, y+1/2, -z)', '(x+1/2, -y, -z)',
                          '(-x, -y, -z)', '(x+1/2, y+1/2, -z)',
                          '(x, -y+1/2, z)', '(-x+1/2, y, z)'), 'n/a')},
      '60': {'4a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)', '(0, 0, 1/2)',
                        '(1/2, 1/2, 0)'), 'hkl: h+k,l=2n'),
             '4b': (0, ('(0, 1/2, 0)', '(1/2, 0, 1/2)', '(0, 1/2, 1/2)',
                        '(1/2, 0, 0)'), 'hkl: h+k,l=2n'),
             '4c': (2, ('(0, y, 1/4)', '(1/2, -y+1/2, 3/4)', '(0, -y, 3/4)',
                        '(1/2, y+1/2, 1/4)'), 'hkl: h+k=2n'),
             '8d': (7, ('(x, y, z)', '(-x+1/2, -y+1/2, z+1/2)',
                        '(-x, y, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                        '(-x, -y, -z)', '(x+1/2, y+1/2, -z+1/2)',
                        '(x, -y, z+1/2)', '(-x+1/2, y+1/2, z)'),
                    '0kl: k=2n, h0l: l=2n, hk0: h+k=2n, h00: h=2n, 0k0: k=2n, '
                    '00l: l=2n')},
      '61': {'4a': (0, ('(0, 0, 0)', '(1/2, 0, 1/2)', '(0, 1/2, 1/2)',
                        '(1/2, 1/2, 0)'), 'hkl: h+k,h+l,k+l=2n'),
             '4b': (0, ('(0, 0, 1/2)', '(1/2, 0, 0)', '(0, 1/2, 0)',
                        '(1/2, 1/2, 1/2)'), 'hkl: h+k,h+l,k+l=2n'),
             '8c': (7, ('(x, y, z)', '(-x+1/2, -y, z+1/2)',
                        '(-x, y+1/2, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                        '(-x, -y, -z)', '(x+1/2, y, -z+1/2)',
                        '(x, -y+1/2, z+1/2)', '(-x+1/2, y+1/2, z)'),
                    '0kl: k=2n, h0l: l=2n, hk0: h=2n, h00: h=2n, 0k0: k=2n, '
                    '00l: l=2n')},
      '62': {'4a': (0, ('(0, 0, 0)', '(1/2, 0, 1/2)', '(0, 1/2, 0)',
                        '(1/2, 1/2, 1/2)'), 'hkl: h+l,k=2n'),
             '4b': (0, ('(0, 0, 1/2)', '(1/2, 0, 0)', '(0, 1/2, 1/2)',
                        '(1/2, 1/2, 0)'), 'hkl: h+l,k=2n'),
             '4c': (5, ('(x, 1/4, z)', '(-x+1/2, 3/4, z+1/2)',
                        '(-x, 3/4, -z)', '(x+1/2, 1/4, -z+1/2)'), None),
             '8d': (7, ('(x, y, z)', '(-x+1/2, -y, z+1/2)', '(-x, y+1/2, -z)',
                        '(x+1/2, -y+1/2, -z+1/2)', '(-x, -y, -z)',
                        '(x+1/2, y, -z+1/2)', '(x, -y+1/2, z)',
                        '(-x+1/2, y+1/2, z+1/2)'),
                    '0kl: k+l=2n, hk0: h=2n, h00: h=2n, 0k0: k=2n, 00l: l=2n'
                    )},
      '63': {'4a': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(0, 0, 1/2)',
                        '(1/2, 1/2, 1/2)'), 'hkl: l=2n'),
             '4b': (0, ('(0, 1/2, 0)', '(1/2, 0, 0)', '(0, 1/2, 1/2)',
                        '(1/2, 0, 1/2)'), 'hkl: l=2n'),
             '4c': (2, ('(0, y, 1/4)', '(1/2, y+1/2, 1/4)', '(0, -y, 3/4)',
                        '(1/2, -y+1/2, 3/4)'), None),
             '8d': (0, ('(1/4, 1/4, 0)', '(3/4, 3/4, 0)', '(3/4, 3/4, 1/2)',
                        '(1/4, 1/4, 1/2)', '(3/4, 1/4, 1/2)',
                        '(1/4, 3/4, 1/2)', '(1/4, 3/4, 0)', '(3/4, 1/4, 0)'),
                    'hkl: k,l=2n'),
             '8e': (1, ('(x, 0, 0)', '(x+1/2, 1/2, 0)', '(-x, 0, 1/2)',
                        '(-x+1/2, 1/2, 1/2)', '(-x, 0, 0)',
                        '(-x+1/2, 1/2, 0)', '(x, 0, 1/2)',
                        '(x+1/2, 1/2, 1/2)'), 'hkl: l=2n'),
             '8f': (6, ('(0, y, z)', '(1/2, y+1/2, z)', '(0, -y, z+1/2)',
                        '(1/2, -y+1/2, z+1/2)', '(0, y, -z+1/2)',
                        '(1/2, y+1/2, -z+1/2)', '(0, -y, -z)',
                        '(1/2, -y+1/2, -z)'), None),
             '8g': (3, ('(x, y, 1/4)', '(x+1/2, y+1/2, 1/4)', '(-x, -y, 3/4)',
                        '(-x+1/2, -y+1/2, 3/4)', '(-x, y, 1/4)',
                        '(-x+1/2, y+1/2, 1/4)', '(x, -y, 3/4)',
                        '(x+1/2, -y+1/2, 3/4)'), None),
             '16h': (7, ('(x, y, z)', '(x+1/2, y+1/2, z)', '(-x, -y, z+1/2)',
                         '(-x+1/2, -y+1/2, z+1/2)', '(-x, y, -z+1/2)',
                         '(-x+1/2, y+1/2, -z+1/2)', '(x, -y, -z)',
                         '(x+1/2, -y+1/2, -z)', '(-x, -y, -z)',
                         '(-x+1/2, -y+1/2, -z)', '(x, y, -z+1/2)',
                         '(x+1/2, y+1/2, -z+1/2)', '(x, -y, z+1/2)',
                         '(x+1/2, -y+1/2, z+1/2)', '(-x, y, z)',
                         '(-x+1/2, y+1/2, z)'),
                     'hkl: h+k=2n, 0kl: k=2n, h0l: h,l=2n, hk0: h+k=2n, '
                     'h00: h=2n, 0k0: k=2n, 00l: l=2n')},
      '64': {'4a': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(0, 1/2, 1/2)',
                        '(1/2, 0, 1/2)'), 'hkl: k+l=2n'),
             '4b': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(1/2, 1/2, 1/2)',
                        '(0, 0, 1/2)'), 'hkl: k+l=2n'),
             '8c': (0, ('(1/4, 1/4, 0)', '(3/4, 3/4, 0)', '(3/4, 1/4, 1/2)',
                        '(1/4, 3/4, 1/2)', '(3/4, 3/4, 1/2)',
                        '(1/4, 1/4, 1/2)', '(1/4, 3/4, 0)', '(3/4, 1/4, 0)'),
                    'hkl: k,l=2n'),
             '8d': (1, ('(x, 0, 0)', '(x+1/2, 1/2, 0)', '(-x, 1/2, 1/2)',
                        '(-x+1/2, 0, 1/2)', '(-x, 0, 0)', '(-x+1/2, 1/2, 0)',
                        '(x, 1/2, 1/2)', '(x+1/2, 0, 1/2)'), 'hkl: k+l=2n'),
             '8e': (2, ('(1/4, y, 1/4)', '(3/4, y+1/2, 1/4)',
                        '(3/4, -y+1/2, 3/4)', '(1/4, -y, 3/4)',
                        '(3/4, -y, 3/4)', '(1/4, -y+1/2, 3/4)',
                        '(1/4, y+1/2, 1/4)', '(3/4, y, 1/4)'), 'hkl: h=2n'),
             '8f': (6, ('(0, y, z)', '(1/2, y+1/2, z)', '(0, -y+1/2, z+1/2)',
                        '(1/2, -y, z+1/2)', '(0, y+1/2, -z+1/2)',
                        '(1/2, y, -z+1/2)', '(0, -y, -z)',
                        '(1/2, -y+1/2, -z)'), None),
             '16g': (7, ('(x, y, z)', '(x+1/2, y+1/2, z)',
                         '(-x, -y+1/2, z+1/2)', '(-x+1/2, -y, z+1/2)',
                         '(-x, y+1/2, -z+1/2)', '(-x+1/2, y, -z+1/2)',
                         '(x, -y, -z)', '(x+1/2, -y+1/2, -z)', '(-x, -y, -z)',
                         '(-x+1/2, -y+1/2, -z)', '(x, y+1/2, -z+1/2)',
                         '(x+1/2, y, -z+1/2)', '(x, -y+1/2, z+1/2)',
                         '(x+1/2, -y, z+1/2)', '(-x, y, z)',
                         '(-x+1/2, y+1/2, z)'),
                     'hkl: h+k=2n, 0kl: k=2n, h0l: h,l=2n, hk0: h,k=2n, '
                     'h00: h=2n, 0k0: k=2n, 00l: l=2n')},
      '65': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)'), None),
             '2b': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)'), None),
             '2c': (0, ('(1/2, 0, 1/2)', '(0, 1/2, 1/2)'), None),
             '2d': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)'), None),
             '4e': (0, ('(1/4, 1/4, 0)', '(3/4, 3/4, 0)', '(3/4, 1/4, 0)',
                        '(1/4, 3/4, 0)'), 'hkl: h=2n'),
             '4f': (0, ('(1/4, 1/4, 1/2)', '(3/4, 3/4, 1/2)',
                        '(3/4, 1/4, 1/2)', '(1/4, 3/4, 1/2)'), 'hkl: h=2n'),
             '4g': (1, ('(x, 0, 0)', '(x+1/2, 1/2, 0)', '(-x, 0, 0)',
                        '(-x+1/2, 1/2, 0)'), None),
             '4h': (1, ('(x, 0, 1/2)', '(x+1/2, 1/2, 1/2)', '(-x, 0, 1/2)',
                        '(-x+1/2, 1/2, 1/2)'), None),
             '4i': (2, ('(0, y, 0)', '(1/2, y+1/2, 0)', '(0, -y, 0)',
                        '(1/2, -y+1/2, 0)'), None),
             '4j': (2, ('(0, y, 1/2)', '(1/2, y+1/2, 1/2)', '(0, -y, 1/2)',
                        '(1/2, -y+1/2, 1/2)'), None),
             '4k': (4, ('(0, 0, z)', '(1/2, 1/2, z)', '(0, 0, -z)',
                        '(1/2, 1/2, -z)'), None),
             '4l': (4, ('(0, 1/2, z)', '(1/2, 0, z)', '(0, 1/2, -z)',
                        '(1/2, 0, -z)'), None),
             '8m': (4, ('(1/4, 1/4, z)', '(3/4, 3/4, z)', '(3/4, 1/4, -z)',
                        '(1/4, 3/4, -z)', '(3/4, 3/4, -z)', '(1/4, 1/4, -z)',
                        '(1/4, 3/4, z)', '(3/4, 1/4, z)'), 'hkl: h=2n'),
             '8n': (6, ('(0, y, z)', '(1/2, y+1/2, z)', '(0, -y, z)',
                        '(1/2, -y+1/2, z)', '(0, y, -z)', '(1/2, y+1/2, -z)',
                        '(0, -y, -z)', '(1/2, -y+1/2, -z)'), None),
             '8o': (5, ('(x, 0, z)', '(x+1/2, 1/2, z)', '(-x, 0, z)',
                        '(-x+1/2, 1/2, z)', '(-x, 0, -z)',
                        '(-x+1/2, 1/2, -z)', '(x, 0, -z)', '(x+1/2, 1/2, -z)'
                        ), None),
             '8p': (3, ('(x, y, 0)', '(x+1/2, y+1/2, 0)', '(-x, -y, 0)',
                        '(-x+1/2, -y+1/2, 0)', '(-x, y, 0)',
                        '(-x+1/2, y+1/2, 0)', '(x, -y, 0)',
                        '(x+1/2, -y+1/2, 0)'), None),
             '8q': (3, ('(x, y, 1/2)', '(x+1/2, y+1/2, 1/2)', '(-x, -y, 1/2)',
                        '(-x+1/2, -y+1/2, 1/2)', '(-x, y, 1/2)',
                        '(-x+1/2, y+1/2, 1/2)', '(x, -y, 1/2)',
                        '(x+1/2, -y+1/2, 1/2)'), None),
             '16r': (7, ('(x, y, z)', '(x+1/2, y+1/2, z)', '(-x, -y, z)',
                         '(-x+1/2, -y+1/2, z)', '(-x, y, -z)',
                         '(-x+1/2, y+1/2, -z)', '(x, -y, -z)',
                         '(x+1/2, -y+1/2, -z)', '(-x, -y, -z)',
                         '(-x+1/2, -y+1/2, -z)', '(x, y, -z)',
                         '(x+1/2, y+1/2, -z)', '(x, -y, z)',
                         '(x+1/2, -y+1/2, z)', '(-x, y, z)',
                         '(-x+1/2, y+1/2, z)'),
                     'hkl: h+k=2n, 0kl: k=2n, h0l: h=2n, hk0: h+k=2n, '
                     'h00: h=2n, 0k0: k=2n')},
      '66': {'4a': (0, ('(0, 0, 1/4)', '(1/2, 1/2, 1/4)', '(0, 0, 3/4)',
                        '(1/2, 1/2, 3/4)'), 'hkl: l=2n'),
             '4b': (0, ('(0, 1/2, 1/4)', '(1/2, 0, 1/4)', '(0, 1/2, 3/4)',
                        '(1/2, 0, 3/4)'), 'hkl: l=2n'),
             '4c': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(0, 0, 1/2)',
                        '(1/2, 1/2, 1/2)'), 'hkl: l=2n'),
             '4d': (0, ('(0, 1/2, 0)', '(1/2, 0, 0)', '(0, 1/2, 1/2)',
                        '(1/2, 0, 1/2)'), 'hkl: l=2n'),
             '4e': (0, ('(1/4, 1/4, 0)', '(3/4, 3/4, 0)', '(3/4, 1/4, 1/2)',
                        '(1/4, 3/4, 1/2)'), 'hkl: k+l=2n'),
             '4f': (0, ('(1/4, 3/4, 0)', '(3/4, 1/4, 0)', '(3/4, 3/4, 1/2)',
                        '(1/4, 1/4, 1/2)'), 'hkl: k+l=2n'),
             '8g': (1, ('(x, 0, 1/4)', '(x+1/2, 1/2, 1/4)', '(-x, 0, 1/4)',
                        '(-x+1/2, 1/2, 1/4)', '(-x, 0, 3/4)',
                        '(-x+1/2, 1/2, 3/4)', '(x, 0, 3/4)',
                        '(x+1/2, 1/2, 3/4)'), 'hkl: l=2n'),
             '8h': (2, ('(0, y, 1/4)', '(1/2, y+1/2, 1/4)', '(0, -y, 1/4)',
                        '(1/2, -y+1/2, 1/4)', '(0, -y, 3/4)',
                        '(1/2, -y+1/2, 3/4)', '(0, y, 3/4)',
                        '(1/2, y+1/2, 3/4)'), 'hkl: l=2n'),
             '8i': (4, ('(0, 0, z)', '(1/2, 1/2, z)', '(0, 0, -z+1/2)',
                        '(1/2, 1/2, -z+1/2)', '(0, 0, -z)', '(1/2, 1/2, -z)',
                        '(0, 0, z+1/2)', '(1/2, 1/2, z+1/2)'), 'hkl: l=2n'),
             '8j': (4, ('(0, 1/2, z)', '(1/2, 0, z)', '(0, 1/2, -z+1/2)',
                        '(1/2, 0, -z+1/2)', '(0, 1/2, -z)', '(1/2, 0, -z)',
                        '(0, 1/2, z+1/2)', '(1/2, 0, z+1/2)'), 'hkl: l=2n'),
             '8k': (4, ('(1/4, 1/4, z)', '(3/4, 3/4, z)',
                        '(3/4, 1/4, -z+1/2)', '(1/4, 3/4, -z+1/2)',
                        '(3/4, 3/4, -z)', '(1/4, 1/4, -z)',
                        '(1/4, 3/4, z+1/2)', '(3/4, 1/4, z+1/2)'),
                    'hkl: k+l=2n'),
             '8l': (3, ('(x, y, 0)', '(x+1/2, y+1/2, 0)', '(-x, -y, 0)',
                        '(-x+1/2, -y+1/2, 0)', '(-x, y, 1/2)',
                        '(-x+1/2, y+1/2, 1/2)', '(x, -y, 1/2)',
                        '(x+1/2, -y+1/2, 1/2)'), None),
             '16m': (7, ('(x, y, z)', '(x+1/2, y+1/2, z)', '(-x, -y, z)',
                         '(-x+1/2, -y+1/2, z)', '(-x, y, -z+1/2)',
                         '(-x+1/2, y+1/2, -z+1/2)', '(x, -y, -z+1/2)',
                         '(x+1/2, -y+1/2, -z+1/2)', '(-x, -y, -z)',
                         '(-x+1/2, -y+1/2, -z)', '(x, y, -z)',
                         '(x+1/2, y+1/2, -z)', '(x, -y, z+1/2)',
                         '(x+1/2, -y+1/2, z+1/2)', '(-x, y, z+1/2)',
                         '(-x+1/2, y+1/2, z+1/2)'),
                     'hkl: h+k=2n, 0kl: k,l=2n, h0l: h,l=2n, hk0: h+k=2n, '
                     'h00: h=2n, 0k0: k=2n, 00l: l=2n')},
      '67': {'4a': (0, ('(1/4, 0, 0)', '(3/4, 1/2, 0)', '(3/4, 0, 0)',
                        '(1/4, 1/2, 0)'), 'hkl: h=2n'),
             '4b': (0, ('(1/4, 0, 1/2)', '(3/4, 1/2, 1/2)', '(3/4, 0, 1/2)',
                        '(1/4, 1/2, 1/2)'), 'hkl: h=2n'),
             '4c': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(0, 1/2, 0)',
                        '(1/2, 0, 0)'), 'hkl: h=2n'),
             '4d': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)', '(0, 1/2, 1/2)',
                        '(1/2, 0, 1/2)'), 'hkl: h=2n'),
             '4e': (0, ('(1/4, 1/4, 0)', '(3/4, 3/4, 0)', '(3/4, 1/4, 0)',
                        '(1/4, 3/4, 0)'), 'hkl: h=2n'),
             '4f': (0, ('(1/4, 1/4, 1/2)', '(3/4, 3/4, 1/2)',
                        '(3/4, 1/4, 1/2)', '(1/4, 3/4, 1/2)'), 'hkl: h=2n'),
             '4g': (4, ('(0, 1/4, z)', '(1/2, 3/4, z)', '(0, 3/4, -z)',
                        '(1/2, 1/4, -z)'), None),
             '8h': (1, ('(x, 0, 0)', '(x+1/2, 1/2, 0)', '(-x, 1/2, 0)',
                        '(-x+1/2, 0, 0)', '(-x, 0, 0)', '(-x+1/2, 1/2, 0)',
                        '(x, 1/2, 0)', '(x+1/2, 0, 0)'), 'hkl: h=2n'),
             '8i': (1, ('(x, 0, 1/2)', '(x+1/2, 1/2, 1/2)', '(-x, 1/2, 1/2)',
                        '(-x+1/2, 0, 1/2)', '(-x, 0, 1/2)',
                        '(-x+1/2, 1/2, 1/2)', '(x, 1/2, 1/2)',
                        '(x+1/2, 0, 1/2)'), 'hkl: h=2n'),
             '8j': (2, ('(1/4, y, 0)', '(3/4, y+1/2, 0)', '(3/4, -y+1/2, 0)',
                        '(1/4, -y, 0)', '(3/4, -y, 0)', '(1/4, -y+1/2, 0)',
                        '(1/4, y+1/2, 0)', '(3/4, y, 0)'), 'hkl: h=2n'),
             '8k': (2, ('(1/4, y, 1/2)', '(3/4, y+1/2, 1/2)',
                        '(3/4, -y+1/2, 1/2)', '(1/4, -y, 1/2)',
                        '(3/4, -y, 1/2)', '(1/4, -y+1/2, 1/2)',
                        '(1/4, y+1/2, 1/2)', '(3/4, y, 1/2)'), 'hkl: h=2n'),
             '8l': (4, ('(1/4, 0, z)', '(3/4, 1/2, z)', '(3/4, 1/2, -z)',
                        '(1/4, 0, -z)', '(3/4, 0, -z)', '(1/4, 1/2, -z)',
                        '(1/4, 1/2, z)', '(3/4, 0, z)'), 'hkl: h=2n'),
             '8m': (6, ('(0, y, z)', '(1/2, y+1/2, z)', '(0, -y+1/2, z)',
                        '(1/2, -y, z)', '(0, y+1/2, -z)', '(1/2, y, -z)',
                        '(0, -y, -z)', '(1/2, -y+1/2, -z)'), None),
             '8n': (5, ('(x, 1/4, z)', '(x+1/2, 3/4, z)', '(-x, 1/4, z)',
                        '(-x+1/2, 3/4, z)', '(-x, 3/4, -z)',
                        '(-x+1/2, 1/4, -z)', '(x, 3/4, -z)',
                        '(x+1/2, 1/4, -z)'), None),
             '16o': (7, ('(x, y, z)', '(x+1/2, y+1/2, z)', '(-x, -y+1/2, z)',
                         '(-x+1/2, -y, z)', '(-x, y+1/2, -z)',
                         '(-x+1/2, y, -z)', '(x, -y, -z)',
                         '(x+1/2, -y+1/2, -z)', '(-x, -y, -z)',
                         '(-x+1/2, -y+1/2, -z)', '(x, y+1/2, -z)',
                         '(x+1/2, y, -z)', '(x, -y+1/2, z)', '(x+1/2, -y, z)',
                         '(-x, y, z)', '(-x+1/2, y+1/2, z)'),
                     'hkl: h+k=2n, 0kl: k=2n, h0l: h=2n, hk0: h,k=2n, '
                     'h00: h=2n, 0k0: k=2n')},
      '68:1': {'4a': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(0, 1/2, 1/2)',
                          '(1/2, 0, 1/2)'), 'hkl: k+l=2n'),
               '4b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)', '(0, 1/2, 0)',
                          '(1/2, 0, 0)'), 'hkl: k+l=2n'),
               '8c': (0, ('(1/4, 0, 1/4)', '(3/4, 1/2, 1/4)',
                          '(1/4, 1/2, 1/4)', '(3/4, 0, 1/4)', '(3/4, 0, 3/4)',
                          '(1/4, 1/2, 3/4)', '(3/4, 1/2, 3/4)',
                          '(1/4, 0, 3/4)'), 'hkl: k,l=2n'),
               '8d': (0, ('(0, 1/4, 1/4)', '(1/2, 3/4, 1/4)',
                          '(1/2, 1/4, 1/4)', '(0, 3/4, 1/4)', '(0, 1/4, 3/4)',
                          '(1/2, 3/4, 3/4)', '(1/2, 1/4, 3/4)',
                          '(0, 3/4, 3/4)'), 'hkl: k,l=2n'),
               '8e': (1, ('(x, 0, 0)', '(x+1/2, 1/2, 0)', '(-x+1/2, 1/2, 0)',
                          '(-x, 0, 0)', '(-x, 1/2, 1/2)', '(-x+1/2, 0, 1/2)',
                          '(x+1/2, 0, 1/2)', '(x, 1/2, 1/2)'), 'hkl: k+l=2n'),
               '8f': (2, ('(0, y, 0)', '(1/2, y+1/2, 0)', '(1/2, -y+1/2, 0)',
                          '(0, -y, 0)', '(0, -y+1/2, 1/2)', '(1/2, -y, 1/2)',
                          '(1/2, y, 1/2)', '(0, y+1/2, 1/2)'), 'hkl: k+l=2n'),
               '8g': (4, ('(0, 0, z)', '(1/2, 1/2, z)', '(0, 0, -z)',
                          '(1/2, 1/2, -z)', '(0, 1/2, -z+1/2)',
                          '(1/2, 0, -z+1/2)', '(0, 1/2, z+1/2)',
                          '(1/2, 0, z+1/2)'), 'hkl: k+l=2n'),
               '8h': (4, ('(1/4, 1/4, z)', '(3/4, 3/4, z)', '(3/4, 1/4, -z)',
                          '(1/4, 3/4, -z)', '(3/4, 1/4, -z+1/2)',
                          '(1/4, 3/4, -z+1/2)', '(1/4, 1/4, z+1/2)',
                          '(3/4, 3/4, z+1/2)'), 'hkl: l=2n'),
               '16i': (7, ('(x, y, z)', '(x+1/2, y+1/2, z)',
                           '(-x+1/2, -y+1/2, z)', '(-x, -y, z)',
                           '(-x, y, -z)', '(-x+1/2, y+1/2, -z)',
                           '(x+1/2, -y+1/2, -z)', '(x, -y, -z)',
                           '(-x, -y+1/2, -z+1/2)', '(-x+1/2, -y, -z+1/2)',
                           '(x+1/2, y, -z+1/2)', '(x, y+1/2, -z+1/2)',
                           '(x, -y+1/2, z+1/2)', '(x+1/2, -y, z+1/2)',
                           '(-x+1/2, y, z+1/2)', '(-x, y+1/2, z+1/2)'),
                       'hkl: h+k=2n, 0kl: k,l=2n, h0l: h,l=2n, hk0: h,k=2n, '
                       'h00: h=2n, 0k0: k=2n, 00l: l=2n')},
      '68:2': {'4a': (0, ('(0, 1/4, 1/4)', '(1/2, 3/4, 1/4)', '(0, 3/4, 3/4)',
                          '(1/2, 1/4, 3/4)'), 'n/a'),
               '4b': (0, ('(0, 1/4, 3/4)', '(1/2, 3/4, 3/4)', '(0, 3/4, 1/4)',
                          '(1/2, 1/4, 1/4)'), 'n/a'),
               '8c': (0, ('(1/4, 3/4, 0)', '(3/4, 1/4, 0)', '(1/4, 1/4, 0)',
                          '(3/4, 3/4, 0)', '(3/4, 3/4, 1/2)',
                          '(1/4, 1/4, 1/2)', '(3/4, 1/4, 1/2)',
                          '(1/4, 3/4, 1/2)'), 'n/a'),
               '8d': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(1/2, 0, 0)',
                          '(0, 1/2, 0)', '(0, 0, 1/2)', '(1/2, 1/2, 1/2)',
                          '(1/2, 0, 1/2)', '(0, 1/2, 1/2)'), 'n/a'),
               '8e': (1, ('(x, 1/4, 1/4)', '(x+1/2, 3/4, 1/4)',
                          '(-x+1/2, 3/4, 1/4)', '(-x, 1/4, 1/4)',
                          '(-x, 3/4, 3/4)', '(-x+1/2, 1/4, 3/4)',
                          '(x+1/2, 1/4, 3/4)', '(x, 3/4, 3/4)'), 'n/a'),
               '8f': (2, ('(0, y, 1/4)', '(1/2, y+1/2, 1/4)',
                          '(1/2, -y, 1/4)', '(0, -y+1/2, 1/4)',
                          '(0, -y, 3/4)', '(1/2, -y+1/2, 3/4)',
                          '(1/2, y, 3/4)', '(0, y+1/2, 3/4)'), 'n/a'),
               '8g': (4, ('(0, 1/4, z)', '(1/2, 3/4, z)', '(0, 1/4, -z+1/2)',
                          '(1/2, 3/4, -z+1/2)', '(0, 3/4, -z)',
                          '(1/2, 1/4, -z)', '(0, 3/4, z+1/2)',
                          '(1/2, 1/4, z+1/2)'), 'n/a'),
               '8h': (4, ('(1/4, 0, z)', '(3/4, 1/2, z)', '(3/4, 0, -z+1/2)',
                          '(1/4, 1/2, -z+1/2)', '(3/4, 0, -z)',
                          '(1/4, 1/2, -z)', '(1/4, 0, z+1/2)',
                          '(3/4, 1/2, z+1/2)'), 'n/a'),
               '16i': (7, ('(x, y, z)', '(x+1/2, y+1/2, z)',
                           '(-x+1/2, -y, z)', '(-x, -y+1/2, z)',
                           '(-x, y, -z+1/2)', '(-x+1/2, y+1/2, -z+1/2)',
                           '(x+1/2, -y, -z+1/2)', '(x, -y+1/2, -z+1/2)',
                           '(-x, -y, -z)', '(-x+1/2, -y+1/2, -z)',
                           '(x+1/2, y, -z)', '(x, y+1/2, -z)',
                           '(x, -y, z+1/2)', '(x+1/2, -y+1/2, z+1/2)',
                           '(-x+1/2, y, z+1/2)', '(-x, y+1/2, z+1/2)'), 'n/a'
                       )},
      '69': {'4a': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                        '(1/2, 1/2, 0)'), None),
             '4b': (0, ('(0, 0, 1/2)', '(0, 1/2, 0)', '(1/2, 0, 0)',
                        '(1/2, 1/2, 1/2)'), None),
             '8c': (0, ('(0, 1/4, 1/4)', '(0, 3/4, 3/4)', '(1/2, 1/4, 3/4)',
                        '(1/2, 3/4, 1/4)', '(0, 3/4, 1/4)', '(0, 1/4, 3/4)',
                        '(1/2, 3/4, 3/4)', '(1/2, 1/4, 1/4)'), 'hkl: h=2n'),
             '8d': (0, ('(1/4, 0, 1/4)', '(1/4, 1/2, 3/4)', '(3/4, 0, 3/4)',
                        '(3/4, 1/2, 1/4)', '(3/4, 0, 1/4)', '(3/4, 1/2, 3/4)',
                        '(1/4, 0, 3/4)', '(1/4, 1/2, 1/4)'), 'hkl: h=2n'),
             '8e': (0, ('(1/4, 1/4, 0)', '(1/4, 3/4, 1/2)', '(3/4, 1/4, 1/2)',
                        '(3/4, 3/4, 0)', '(3/4, 1/4, 0)', '(3/4, 3/4, 1/2)',
                        '(1/4, 1/4, 1/2)', '(1/4, 3/4, 0)'), 'hkl: h=2n'),
             '8f': (0, ('(1/4, 1/4, 1/4)', '(1/4, 3/4, 3/4)',
                        '(3/4, 1/4, 3/4)', '(3/4, 3/4, 1/4)',
                        '(3/4, 3/4, 3/4)', '(3/4, 1/4, 1/4)',
                        '(1/4, 3/4, 1/4)', '(1/4, 1/4, 3/4)'), 'hkl: h=2n'),
             '8g': (1, ('(x, 0, 0)', '(x, 1/2, 1/2)', '(x+1/2, 0, 1/2)',
                        '(x+1/2, 1/2, 0)', '(-x, 0, 0)', '(-x, 1/2, 1/2)',
                        '(-x+1/2, 0, 1/2)', '(-x+1/2, 1/2, 0)'), None),
             '8h': (2, ('(0, y, 0)', '(0, y+1/2, 1/2)', '(1/2, y, 1/2)',
                        '(1/2, y+1/2, 0)', '(0, -y, 0)', '(0, -y+1/2, 1/2)',
                        '(1/2, -y, 1/2)', '(1/2, -y+1/2, 0)'), None),
             '8i': (4, ('(0, 0, z)', '(0, 1/2, z+1/2)', '(1/2, 0, z+1/2)',
                        '(1/2, 1/2, z)', '(0, 0, -z)', '(0, 1/2, -z+1/2)',
                        '(1/2, 0, -z+1/2)', '(1/2, 1/2, -z)'), None),
             '16j': (4, ('(1/4, 1/4, z)', '(1/4, 3/4, z+1/2)',
                         '(3/4, 1/4, z+1/2)', '(3/4, 3/4, z)',
                         '(3/4, 1/4, -z)', '(3/4, 3/4, -z+1/2)',
                         '(1/4, 1/4, -z+1/2)', '(1/4, 3/4, -z)',
                         '(3/4, 3/4, -z)', '(3/4, 1/4, -z+1/2)',
                         '(1/4, 3/4, -z+1/2)', '(1/4, 1/4, -z)',
                         '(1/4, 3/4, z)', '(1/4, 1/4, z+1/2)',
                         '(3/4, 3/4, z+1/2)', '(3/4, 1/4, z)'), 'hkl: h=2n'),
             '16k': (2, ('(1/4, y, 1/4)', '(1/4, y+1/2, 3/4)',
                         '(3/4, y, 3/4)', '(3/4, y+1/2, 1/4)',
                         '(3/4, -y, 1/4)', '(3/4, -y+1/2, 3/4)',
                         '(1/4, -y, 3/4)', '(1/4, -y+1/2, 1/4)',
                         '(3/4, -y, 3/4)', '(3/4, -y+1/2, 1/4)',
                         '(1/4, -y, 1/4)', '(1/4, -y+1/2, 3/4)',
                         '(1/4, y, 3/4)', '(1/4, y+1/2, 1/4)',
                         '(3/4, y, 1/4)', '(3/4, y+1/2, 3/4)'), 'hkl: h=2n'),
             '16l': (1, ('(x, 1/4, 1/4)', '(x, 3/4, 3/4)',
                         '(x+1/2, 1/4, 3/4)', '(x+1/2, 3/4, 1/4)',
                         '(-x, 3/4, 1/4)', '(-x, 1/4, 3/4)',
                         '(-x+1/2, 3/4, 3/4)', '(-x+1/2, 1/4, 1/4)',
                         '(-x, 3/4, 3/4)', '(-x, 1/4, 1/4)',
                         '(-x+1/2, 3/4, 1/4)', '(-x+1/2, 1/4, 3/4)',
                         '(x, 1/4, 3/4)', '(x, 3/4, 1/4)',
                         '(x+1/2, 1/4, 1/4)', '(x+1/2, 3/4, 3/4)'), 'hkl: h=2n'
                     ),
             '16m': (6, ('(0, y, z)', '(0, y+1/2, z+1/2)', '(1/2, y, z+1/2)',
                         '(1/2, y+1/2, z)', '(0, -y, z)',
                         '(0, -y+1/2, z+1/2)', '(1/2, -y, z+1/2)',
                         '(1/2, -y+1/2, z)', '(0, y, -z)',
                         '(0, y+1/2, -z+1/2)', '(1/2, y, -z+1/2)',
                         '(1/2, y+1/2, -z)', '(0, -y, -z)',
                         '(0, -y+1/2, -z+1/2)', '(1/2, -y, -z+1/2)',
                         '(1/2, -y+1/2, -z)'), None),
             '16n': (5, ('(x, 0, z)', '(x, 1/2, z+1/2)', '(x+1/2, 0, z+1/2)',
                         '(x+1/2, 1/2, z)', '(-x, 0, z)', '(-x, 1/2, z+1/2)',
                         '(-x+1/2, 0, z+1/2)', '(-x+1/2, 1/2, z)',
                         '(-x, 0, -z)', '(-x, 1/2, -z+1/2)',
                         '(-x+1/2, 0, -z+1/2)', '(-x+1/2, 1/2, -z)',
                         '(x, 0, -z)', '(x, 1/2, -z+1/2)',
                         '(x+1/2, 0, -z+1/2)', '(x+1/2, 1/2, -z)'), None),
             '16o': (3, ('(x, y, 0)', '(x, y+1/2, 1/2)', '(x+1/2, y, 1/2)',
                         '(x+1/2, y+1/2, 0)', '(-x, -y, 0)',
                         '(-x, -y+1/2, 1/2)', '(-x+1/2, -y, 1/2)',
                         '(-x+1/2, -y+1/2, 0)', '(-x, y, 0)',
                         '(-x, y+1/2, 1/2)', '(-x+1/2, y, 1/2)',
                         '(-x+1/2, y+1/2, 0)', '(x, -y, 0)',
                         '(x, -y+1/2, 1/2)', '(x+1/2, -y, 1/2)',
                         '(x+1/2, -y+1/2, 0)'), None),
             '32p': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)',
                         '(x+1/2, y, z+1/2)', '(x+1/2, y+1/2, z)',
                         '(-x, -y, z)', '(-x, -y+1/2, z+1/2)',
                         '(-x+1/2, -y, z+1/2)', '(-x+1/2, -y+1/2, z)',
                         '(-x, y, -z)', '(-x, y+1/2, -z+1/2)',
                         '(-x+1/2, y, -z+1/2)', '(-x+1/2, y+1/2, -z)',
                         '(x, -y, -z)', '(x, -y+1/2, -z+1/2)',
                         '(x+1/2, -y, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                         '(-x, -y, -z)', '(-x, -y+1/2, -z+1/2)',
                         '(-x+1/2, -y, -z+1/2)', '(-x+1/2, -y+1/2, -z)',
                         '(x, y, -z)', '(x, y+1/2, -z+1/2)',
                         '(x+1/2, y, -z+1/2)', '(x+1/2, y+1/2, -z)',
                         '(x, -y, z)', '(x, -y+1/2, z+1/2)',
                         '(x+1/2, -y, z+1/2)', '(x+1/2, -y+1/2, z)',
                         '(-x, y, z)', '(-x, y+1/2, z+1/2)',
                         '(-x+1/2, y, z+1/2)', '(-x+1/2, y+1/2, z)'),
                     'hkl: h+k,h+l,k+l=2n, 0kl: k,l=2n, h0l: h,l=2n, '
                     'hk0: h,k=2n, h00: h=2n, 0k0: k=2n, 00l: l=2n')},
      '70:1': {'8a': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                          '(1/2, 1/2, 0)', '(1/4, 1/4, 1/4)',
                          '(1/4, 3/4, 3/4)', '(3/4, 1/4, 3/4)',
                          '(3/4, 3/4, 1/4)'), 'hkl: h=2n+1 or h+k+l=4n'),
               '8b': (0, ('(0, 0, 1/2)', '(0, 1/2, 0)', '(1/2, 0, 0)',
                          '(1/2, 1/2, 1/2)', '(1/4, 1/4, 3/4)',
                          '(1/4, 3/4, 1/4)', '(3/4, 1/4, 1/4)',
                          '(3/4, 3/4, 3/4)'), 'hkl: h=2n+1 or h+k+l=4n'),
               '16c': (0, ('(1/8, 1/8, 1/8)', '(1/8, 5/8, 5/8)',
                           '(5/8, 1/8, 5/8)', '(5/8, 5/8, 1/8)',
                           '(7/8, 7/8, 1/8)', '(7/8, 3/8, 5/8)',
                           '(3/8, 7/8, 5/8)', '(3/8, 3/8, 1/8)',
                           '(7/8, 1/8, 7/8)', '(7/8, 5/8, 3/8)',
                           '(3/8, 1/8, 3/8)', '(3/8, 5/8, 7/8)',
                           '(1/8, 7/8, 7/8)', '(1/8, 3/8, 3/8)',
                           '(5/8, 7/8, 3/8)', '(5/8, 3/8, 7/8)'),
                       'hkl: h=2n+1 or h,k,l=4n+2 or h,k,l=4n'),
               '16d': (0, ('(5/8, 5/8, 5/8)', '(5/8, 1/8, 1/8)',
                           '(1/8, 5/8, 1/8)', '(1/8, 1/8, 5/8)',
                           '(3/8, 3/8, 5/8)', '(3/8, 7/8, 1/8)',
                           '(7/8, 3/8, 1/8)', '(7/8, 7/8, 5/8)',
                           '(3/8, 5/8, 3/8)', '(3/8, 1/8, 7/8)',
                           '(7/8, 5/8, 7/8)', '(7/8, 1/8, 3/8)',
                           '(5/8, 3/8, 3/8)', '(5/8, 7/8, 7/8)',
                           '(1/8, 3/8, 7/8)', '(1/8, 7/8, 3/8)'),
                       'hkl: h=2n+1 or h,k,l=4n+2 or h,k,l=4n'),
               '16e': (1, ('(x, 0, 0)', '(x, 1/2, 1/2)', '(x+1/2, 0, 1/2)',
                           '(x+1/2, 1/2, 0)', '(-x, 0, 0)', '(-x, 1/2, 1/2)',
                           '(-x+1/2, 0, 1/2)', '(-x+1/2, 1/2, 0)',
                           '(-x+1/4, 1/4, 1/4)', '(-x+1/4, 3/4, 3/4)',
                           '(-x+3/4, 1/4, 3/4)', '(-x+3/4, 3/4, 1/4)',
                           '(x+1/4, 1/4, 1/4)', '(x+1/4, 3/4, 3/4)',
                           '(x+3/4, 1/4, 3/4)', '(x+3/4, 3/4, 1/4)'),
                       'hkl: h=2n+1 or h+k+l=4n'),
               '16f': (2, ('(0, y, 0)', '(0, y+1/2, 1/2)', '(1/2, y, 1/2)',
                           '(1/2, y+1/2, 0)', '(0, -y, 0)',
                           '(0, -y+1/2, 1/2)', '(1/2, -y, 1/2)',
                           '(1/2, -y+1/2, 0)', '(1/4, -y+1/4, 1/4)',
                           '(1/4, -y+3/4, 3/4)', '(3/4, -y+1/4, 3/4)',
                           '(3/4, -y+3/4, 1/4)', '(1/4, y+1/4, 1/4)',
                           '(1/4, y+3/4, 3/4)', '(3/4, y+1/4, 3/4)',
                           '(3/4, y+3/4, 1/4)'), 'hkl: h=2n+1 or h+k+l=4n'),
               '16g': (4, ('(0, 0, z)', '(0, 1/2, z+1/2)', '(1/2, 0, z+1/2)',
                           '(1/2, 1/2, z)', '(0, 0, -z)', '(0, 1/2, -z+1/2)',
                           '(1/2, 0, -z+1/2)', '(1/2, 1/2, -z)',
                           '(1/4, 1/4, -z+1/4)', '(1/4, 3/4, -z+3/4)',
                           '(3/4, 1/4, -z+3/4)', '(3/4, 3/4, -z+1/4)',
                           '(1/4, 1/4, z+1/4)', '(1/4, 3/4, z+3/4)',
                           '(3/4, 1/4, z+3/4)', '(3/4, 3/4, z+1/4)'),
                       'hkl: h=2n+1 or h+k+l=4n'),
               '32h': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)',
                           '(x+1/2, y, z+1/2)', '(x+1/2, y+1/2, z)',
                           '(-x, -y, z)', '(-x, -y+1/2, z+1/2)',
                           '(-x+1/2, -y, z+1/2)', '(-x+1/2, -y+1/2, z)',
                           '(-x, y, -z)', '(-x, y+1/2, -z+1/2)',
                           '(-x+1/2, y, -z+1/2)', '(-x+1/2, y+1/2, -z)',
                           '(x, -y, -z)', '(x, -y+1/2, -z+1/2)',
                           '(x+1/2, -y, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                           '(-x+1/4, -y+1/4, -z+1/4)',
                           '(-x+1/4, -y+3/4, -z+3/4)',
                           '(-x+3/4, -y+1/4, -z+3/4)',
                           '(-x+3/4, -y+3/4, -z+1/4)',
                           '(x+1/4, y+1/4, -z+1/4)', '(x+1/4, y+3/4, -z+3/4)',
                           '(x+3/4, y+1/4, -z+3/4)', '(x+3/4, y+3/4, -z+1/4)',
                           '(x+1/4, -y+1/4, z+1/4)', '(x+1/4, -y+3/4, z+3/4)',
                           '(x+3/4, -y+1/4, z+3/4)', '(x+3/4, -y+3/4, z+1/4)',
                           '(-x+1/4, y+1/4, z+1/4)', '(-x+1/4, y+3/4, z+3/4)',
                           '(-x+3/4, y+1/4, z+3/4)', '(-x+3/4, y+3/4, z+1/4)'
                           ),
                       'hkl: h+k,h+l,k+l=2n, 0kl: k+l=4n, k,l=2n, '
                       'h0l: h+l=4n, h,l=2n, hk0: h+k=4n, h,k=2n, h00: h=4n, '
                       '0k0: k=4n, 00l: l=4n')},
      '70:2': {'8a': (0, ('(1/8, 1/8, 1/8)', '(1/8, 5/8, 5/8)',
                          '(5/8, 1/8, 5/8)', '(5/8, 5/8, 1/8)',
                          '(7/8, 7/8, 7/8)', '(7/8, 3/8, 3/8)',
                          '(3/8, 7/8, 3/8)', '(3/8, 3/8, 7/8)'), 'n/a'),
               '8b': (0, ('(1/8, 1/8, 5/8)', '(1/8, 5/8, 1/8)',
                          '(5/8, 1/8, 1/8)', '(5/8, 5/8, 5/8)',
                          '(7/8, 7/8, 3/8)', '(7/8, 3/8, 7/8)',
                          '(3/8, 7/8, 7/8)', '(3/8, 3/8, 3/8)'), 'n/a'),
               '16c': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                           '(1/2, 1/2, 0)', '(3/4, 3/4, 0)',
                           '(3/4, 1/4, 1/2)', '(1/4, 3/4, 1/2)',
                           '(1/4, 1/4, 0)', '(3/4, 0, 3/4)',
                           '(3/4, 1/2, 1/4)', '(1/4, 0, 1/4)',
                           '(1/4, 1/2, 3/4)', '(0, 3/4, 3/4)',
                           '(0, 1/4, 1/4)', '(1/2, 3/4, 1/4)',
                           '(1/2, 1/4, 3/4)'), 'n/a'),
               '16d': (0, ('(1/2, 1/2, 1/2)', '(1/2, 0, 0)', '(0, 1/2, 0)',
                           '(0, 0, 1/2)', '(1/4, 1/4, 1/2)', '(1/4, 3/4, 0)',
                           '(3/4, 1/4, 0)', '(3/4, 3/4, 1/2)',
                           '(1/4, 1/2, 1/4)', '(1/4, 0, 3/4)',
                           '(3/4, 1/2, 3/4)', '(3/4, 0, 1/4)',
                           '(1/2, 1/4, 1/4)', '(1/2, 3/4, 3/4)',
                           '(0, 1/4, 3/4)', '(0, 3/4, 1/4)'), 'n/a'),
               '16e': (1, ('(x, 1/8, 1/8)', '(x, 5/8, 5/8)',
                           '(x+1/2, 1/8, 5/8)', '(x+1/2, 5/8, 1/8)',
                           '(-x+3/4, 5/8, 1/8)', '(-x+3/4, 1/8, 5/8)',
                           '(-x+1/4, 5/8, 5/8)', '(-x+1/4, 1/8, 1/8)',
                           '(-x, 7/8, 7/8)', '(-x, 3/8, 3/8)',
                           '(-x+1/2, 7/8, 3/8)', '(-x+1/2, 3/8, 7/8)',
                           '(x+1/4, 3/8, 7/8)', '(x+1/4, 7/8, 3/8)',
                           '(x+3/4, 3/8, 3/8)', '(x+3/4, 7/8, 7/8)'), 'n/a'),
               '16f': (2, ('(1/8, y, 1/8)', '(1/8, y+1/2, 5/8)',
                           '(5/8, y, 5/8)', '(5/8, y+1/2, 1/8)',
                           '(5/8, -y+3/4, 1/8)', '(5/8, -y+1/4, 5/8)',
                           '(1/8, -y+3/4, 5/8)', '(1/8, -y+1/4, 1/8)',
                           '(7/8, -y, 7/8)', '(7/8, -y+1/2, 3/8)',
                           '(3/8, -y, 3/8)', '(3/8, -y+1/2, 7/8)',
                           '(3/8, y+1/4, 7/8)', '(3/8, y+3/4, 3/8)',
                           '(7/8, y+1/4, 3/8)', '(7/8, y+3/4, 7/8)'), 'n/a'),
               '16g': (4, ('(1/8, 1/8, z)', '(1/8, 5/8, z+1/2)',
                           '(5/8, 1/8, z+1/2)', '(5/8, 5/8, z)',
                           '(5/8, 1/8, -z+3/4)', '(5/8, 5/8, -z+1/4)',
                           '(1/8, 1/8, -z+1/4)', '(1/8, 5/8, -z+3/4)',
                           '(7/8, 7/8, -z)', '(7/8, 3/8, -z+1/2)',
                           '(3/8, 7/8, -z+1/2)', '(3/8, 3/8, -z)',
                           '(3/8, 7/8, z+1/4)', '(3/8, 3/8, z+3/4)',
                           '(7/8, 7/8, z+3/4)', '(7/8, 3/8, z+1/4)'), 'n/a'),
               '32h': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)',
                           '(x+1/2, y, z+1/2)', '(x+1/2, y+1/2, z)',
                           '(-x+3/4, -y+3/4, z)', '(-x+3/4, -y+1/4, z+1/2)',
                           '(-x+1/4, -y+3/4, z+1/2)', '(-x+1/4, -y+1/4, z)',
                           '(-x+3/4, y, -z+3/4)', '(-x+3/4, y+1/2, -z+1/4)',
                           '(-x+1/4, y, -z+1/4)', '(-x+1/4, y+1/2, -z+3/4)',
                           '(x, -y+3/4, -z+3/4)', '(x, -y+1/4, -z+1/4)',
                           '(x+1/2, -y+3/4, -z+1/4)',
                           '(x+1/2, -y+1/4, -z+3/4)', '(-x, -y, -z)',
                           '(-x, -y+1/2, -z+1/2)', '(-x+1/2, -y, -z+1/2)',
                           '(-x+1/2, -y+1/2, -z)', '(x+1/4, y+1/4, -z)',
                           '(x+1/4, y+3/4, -z+1/2)', '(x+3/4, y+1/4, -z+1/2)',
                           '(x+3/4, y+3/4, -z)', '(x+1/4, -y, z+1/4)',
                           '(x+1/4, -y+1/2, z+3/4)', '(x+3/4, -y, z+3/4)',
                           '(x+3/4, -y+1/2, z+1/4)', '(-x, y+1/4, z+1/4)',
                           '(-x, y+3/4, z+3/4)', '(-x+1/2, y+1/4, z+3/4)',
                           '(-x+1/2, y+3/4, z+1/4)'), 'n/a')},
      '71': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)'), None),
             '2b': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 0)'), None),
             '2c': (0, ('(1/2, 1/2, 0)', '(0, 0, 1/2)'), None),
             '2d': (0, ('(1/2, 0, 1/2)', '(0, 1/2, 0)'), None),
             '4e': (1, ('(x, 0, 0)', '(x+1/2, 1/2, 1/2)', '(-x, 0, 0)',
                        '(-x+1/2, 1/2, 1/2)'), None),
             '4f': (1, ('(x, 1/2, 0)', '(x+1/2, 0, 1/2)', '(-x, 1/2, 0)',
                        '(-x+1/2, 0, 1/2)'), None),
             '4g': (2, ('(0, y, 0)', '(1/2, y+1/2, 1/2)', '(0, -y, 0)',
                        '(1/2, -y+1/2, 1/2)'), None),
             '4h': (2, ('(0, y, 1/2)', '(1/2, y+1/2, 0)', '(0, -y, 1/2)',
                        '(1/2, -y+1/2, 0)'), None),
             '4i': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(0, 0, -z)',
                        '(1/2, 1/2, -z+1/2)'), None),
             '4j': (4, ('(1/2, 0, z)', '(0, 1/2, z+1/2)', '(1/2, 0, -z)',
                        '(0, 1/2, -z+1/2)'), None),
             '8k': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)',
                        '(3/4, 3/4, 1/4)', '(1/4, 1/4, 3/4)',
                        '(3/4, 1/4, 3/4)', '(1/4, 3/4, 1/4)',
                        '(1/4, 3/4, 3/4)', '(3/4, 1/4, 1/4)'), 'hkl: k,l=2n'),
             '8l': (6, ('(0, y, z)', '(1/2, y+1/2, z+1/2)', '(0, -y, z)',
                        '(1/2, -y+1/2, z+1/2)', '(0, y, -z)',
                        '(1/2, y+1/2, -z+1/2)', '(0, -y, -z)',
                        '(1/2, -y+1/2, -z+1/2)'), None),
             '8m': (5, ('(x, 0, z)', '(x+1/2, 1/2, z+1/2)', '(-x, 0, z)',
                        '(-x+1/2, 1/2, z+1/2)', '(-x, 0, -z)',
                        '(-x+1/2, 1/2, -z+1/2)', '(x, 0, -z)',
                        '(x+1/2, 1/2, -z+1/2)'), None),
             '8n': (3, ('(x, y, 0)', '(x+1/2, y+1/2, 1/2)', '(-x, -y, 0)',
                        '(-x+1/2, -y+1/2, 1/2)', '(-x, y, 0)',
                        '(-x+1/2, y+1/2, 1/2)', '(x, -y, 0)',
                        '(x+1/2, -y+1/2, 1/2)'), None),
             '16o': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                         '(-x+1/2, -y+1/2, z+1/2)', '(-x, y, -z)',
                         '(-x+1/2, y+1/2, -z+1/2)', '(x, -y, -z)',
                         '(x+1/2, -y+1/2, -z+1/2)', '(-x, -y, -z)',
                         '(-x+1/2, -y+1/2, -z+1/2)', '(x, y, -z)',
                         '(x+1/2, y+1/2, -z+1/2)', '(x, -y, z)',
                         '(x+1/2, -y+1/2, z+1/2)', '(-x, y, z)',
                         '(-x+1/2, y+1/2, z+1/2)'),
                     'hkl: h+k+l=2n, 0kl: k+l=2n, h0l: h+l=2n, hk0: h+k=2n, '
                     'h00: h=2n, 0k0: k=2n, 00l: l=2n')},
      '72': {'4a': (0, ('(0, 0, 1/4)', '(1/2, 1/2, 3/4)', '(0, 0, 3/4)',
                        '(1/2, 1/2, 1/4)'), 'hkl: l=2n'),
             '4b': (0, ('(1/2, 0, 1/4)', '(0, 1/2, 3/4)', '(1/2, 0, 3/4)',
                        '(0, 1/2, 1/4)'), 'hkl: l=2n'),
             '4c': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)', '(1/2, 1/2, 0)',
                        '(0, 0, 1/2)'), 'hkl: l=2n'),
             '4d': (0, ('(1/2, 0, 0)', '(0, 1/2, 1/2)', '(0, 1/2, 0)',
                        '(1/2, 0, 1/2)'), 'hkl: l=2n'),
             '8e': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)',
                        '(3/4, 3/4, 1/4)', '(1/4, 1/4, 3/4)',
                        '(1/4, 3/4, 3/4)', '(3/4, 1/4, 1/4)',
                        '(3/4, 1/4, 3/4)', '(1/4, 3/4, 1/4)'), 'hkl: k,l=2n'),
             '8f': (1, ('(x, 0, 1/4)', '(x+1/2, 1/2, 3/4)', '(-x, 0, 1/4)',
                        '(-x+1/2, 1/2, 3/4)', '(-x, 0, 3/4)',
                        '(-x+1/2, 1/2, 1/4)', '(x, 0, 3/4)',
                        '(x+1/2, 1/2, 1/4)'), 'hkl: l=2n'),
             '8g': (2, ('(0, y, 1/4)', '(1/2, y+1/2, 3/4)', '(0, -y, 1/4)',
                        '(1/2, -y+1/2, 3/4)', '(0, -y, 3/4)',
                        '(1/2, -y+1/2, 1/4)', '(0, y, 3/4)',
                        '(1/2, y+1/2, 1/4)'), 'hkl: l=2n'),
             '8h': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(1/2, 1/2, -z)',
                        '(0, 0, -z+1/2)', '(0, 0, -z)', '(1/2, 1/2, -z+1/2)',
                        '(1/2, 1/2, z)', '(0, 0, z+1/2)'), 'hkl: l=2n'),
             '8i': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(1/2, 0, -z)',
                        '(0, 1/2, -z+1/2)', '(0, 1/2, -z)',
                        '(1/2, 0, -z+1/2)', '(1/2, 0, z)', '(0, 1/2, z+1/2)'),
                    'hkl: l=2n'),
             '8j': (3, ('(x, y, 0)', '(x+1/2, y+1/2, 1/2)', '(-x, -y, 0)',
                        '(-x+1/2, -y+1/2, 1/2)', '(-x+1/2, y+1/2, 0)',
                        '(-x, y, 1/2)', '(x+1/2, -y+1/2, 0)', '(x, -y, 1/2)'),
                    None),
             '16k': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                         '(-x+1/2, -y+1/2, z+1/2)', '(-x+1/2, y+1/2, -z)',
                         '(-x, y, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                         '(x, -y, -z+1/2)', '(-x, -y, -z)',
                         '(-x+1/2, -y+1/2, -z+1/2)', '(x, y, -z)',
                         '(x+1/2, y+1/2, -z+1/2)', '(x+1/2, -y+1/2, z)',
                         '(x, -y, z+1/2)', '(-x+1/2, y+1/2, z)',
                         '(-x, y, z+1/2)'),
                     'hkl: h+k+l=2n, 0kl: k,l=2n, h0l: h,l=2n, hk0: h+k=2n, '
                     'h00: h=2n, 0k0: k=2n, 00l: l=2n')},
      '73': {'8a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)', '(1/2, 0, 1/2)',
                        '(0, 1/2, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 0)',
                        '(1/2, 1/2, 0)', '(0, 0, 1/2)'), 'hkl: k,l=2n'),
             '8b': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)',
                        '(1/4, 3/4, 3/4)', '(3/4, 1/4, 1/4)',
                        '(3/4, 3/4, 1/4)', '(1/4, 1/4, 3/4)',
                        '(3/4, 1/4, 3/4)', '(1/4, 3/4, 1/4)'), 'hkl: k,l=2n'),
             '8c': (1, ('(x, 0, 1/4)', '(x+1/2, 1/2, 3/4)',
                        '(-x+1/2, 0, 3/4)', '(-x, 1/2, 1/4)', '(-x, 0, 3/4)',
                        '(-x+1/2, 1/2, 1/4)', '(x+1/2, 0, 1/4)',
                        '(x, 1/2, 3/4)'), 'hkl: h=2n'),
             '8d': (2, ('(1/4, y, 0)', '(3/4, y+1/2, 1/2)', '(1/4, -y, 1/2)',
                        '(3/4, -y+1/2, 0)', '(3/4, -y, 0)',
                        '(1/4, -y+1/2, 1/2)', '(3/4, y, 1/2)',
                        '(1/4, y+1/2, 0)'), 'hkl: k=2n'),
             '8e': (4, ('(0, 1/4, z)', '(1/2, 3/4, z+1/2)',
                        '(0, 3/4, -z+1/2)', '(1/2, 1/4, -z)', '(0, 3/4, -z)',
                        '(1/2, 1/4, -z+1/2)', '(0, 1/4, z+1/2)',
                        '(1/2, 3/4, z)'), 'hkl: l=2n'),
             '16f': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)',
                         '(-x+1/2, -y, z+1/2)', '(-x, -y+1/2, z)',
                         '(-x, y+1/2, -z+1/2)', '(-x+1/2, y, -z)',
                         '(x+1/2, -y+1/2, -z)', '(x, -y, -z+1/2)',
                         '(-x, -y, -z)', '(-x+1/2, -y+1/2, -z+1/2)',
                         '(x+1/2, y, -z+1/2)', '(x, y+1/2, -z)',
                         '(x, -y+1/2, z+1/2)', '(x+1/2, -y, z)',
                         '(-x+1/2, y+1/2, z)', '(-x, y, z+1/2)'),
                     'hkl: h+k+l=2n, 0kl: k,l=2n, h0l: h,l=2n, hk0: h,k=2n, '
                     'h00: h=2n, 0k0: k=2n, 00l: l=2n')},
      '74': {'4a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)', '(0, 1/2, 0)',
                        '(1/2, 0, 1/2)'), 'hkl: k=2n'),  # wrong in ITA?
             '4b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)', '(0, 1/2, 1/2)',
                        '(1/2, 0, 0)'), 'hkl: k=2n'),  # wrong in ITA?
             '4c': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)',
                        '(3/4, 1/4, 1/4)', '(1/4, 3/4, 3/4)'), 'hkl: h=2n'),
             '4d': (0, ('(1/4, 1/4, 3/4)', '(3/4, 3/4, 1/4)',
                        '(3/4, 1/4, 3/4)', '(1/4, 3/4, 1/4)'), 'hkl: h=2n'),
             '4e': (4, ('(0, 1/4, z)', '(1/2, 3/4, z+1/2)', '(0, 3/4, -z)',
                        '(1/2, 1/4, -z+1/2)'), None),
             '8f': (1, ('(x, 0, 0)', '(x+1/2, 1/2, 1/2)', '(-x, 1/2, 0)',
                        '(-x+1/2, 0, 1/2)', '(-x, 0, 0)',
                        '(-x+1/2, 1/2, 1/2)', '(x, 1/2, 0)',
                        '(x+1/2, 0, 1/2)'), 'hkl: k=2n'),
             '8g': (2, ('(1/4, y, 1/4)', '(3/4, y+1/2, 3/4)',
                        '(3/4, -y+1/2, 1/4)', '(1/4, -y, 3/4)',
                        '(3/4, -y, 3/4)', '(1/4, -y+1/2, 1/4)',
                        '(1/4, y+1/2, 3/4)', '(3/4, y, 1/4)'), 'hkl: h=2n'),
             '8h': (6, ('(0, y, z)', '(1/2, y+1/2, z+1/2)', '(0, -y+1/2, z)',
                        '(1/2, -y, z+1/2)', '(0, y+1/2, -z)',
                        '(1/2, y, -z+1/2)', '(0, -y, -z)',
                        '(1/2, -y+1/2, -z+1/2)'), None),
             '8i': (5, ('(x, 1/4, z)', '(x+1/2, 3/4, z+1/2)', '(-x, 1/4, z)',
                        '(-x+1/2, 3/4, z+1/2)', '(-x, 3/4, -z)',
                        '(-x+1/2, 1/4, -z+1/2)', '(x, 3/4, -z)',
                        '(x+1/2, 1/4, -z+1/2)'), None),
             '16j': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)',
                         '(-x, -y+1/2, z)', '(-x+1/2, -y, z+1/2)',
                         '(-x, y+1/2, -z)', '(-x+1/2, y, -z+1/2)',
                         '(x, -y, -z)', '(x+1/2, -y+1/2, -z+1/2)',
                         '(-x, -y, -z)', '(-x+1/2, -y+1/2, -z+1/2)',
                         '(x, y+1/2, -z)', '(x+1/2, y, -z+1/2)',
                         '(x, -y+1/2, z)', '(x+1/2, -y, z+1/2)', '(-x, y, z)',
                         '(-x+1/2, y+1/2, z+1/2)'),
                     'hkl: h+k+l=2n, 0kl: k+l=2n, h0l: h+l=2n, hk0: h,k=2n, '
                     'h00: h=2n, 0k0: k=2n, 00l: l=2n')},
      '75': {'1a': (4, ('(0, 0, z)', ), None),
             '1b': (4, ('(1/2, 1/2, z)', ), None),
             '2c': (4, ('(0, 1/2, z)', '(1/2, 0, z)'), 'hkl: h+k=2n'),
             '4d': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z)',
                        '(y, -x, z)'), None)},
      '76': {'4a': (7, ('(x, y, z)', '(-x, -y, z+1/2)', '(-y, x, z+1/4)',
                        '(y, -x, z+3/4)'), '00l: l=4n')},
      '77': {'2a': (4, ('(0, 0, z)', '(0, 0, z+1/2)'), 'hkl: l=2n'),
             '2b': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, z+1/2)'), 'hkl: l=2n'),
             '2c': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)'), 'hkl: h+k+l=2n'),
             '4d': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z+1/2)',
                        '(y, -x, z+1/2)'), '00l: l=2n')},
      '78': {'4a': (7, ('(x, y, z)', '(-x, -y, z+1/2)', '(-y, x, z+3/4)',
                        '(y, -x, z+1/4)'), '00l: l=4n')},
      '79': {'2a': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)'), None),
             '4b': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(1/2, 0, z)',
                        '(0, 1/2, z+1/2)'), 'hkl: l=2n'),
             '8c': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                        '(-x+1/2, -y+1/2, z+1/2)', '(-y, x, z)',
                        '(-y+1/2, x+1/2, z+1/2)', '(y, -x, z)',
                        '(y+1/2, -x+1/2, z+1/2)'),
                    'hkl: h+k+l=2n, hk0: h+k=2n, 0kl: k+l=2n, hhl: l=2n, '
                    '00l: l=2n, h00: h=2n')},
      '80': {'4a': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(0, 1/2, z+1/4)',
                        '(1/2, 0, z+3/4)'), 'hkl: l=2n+1 or 2h+l=4n'),
             '8b': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)',
                        '(-x+1/2, -y+1/2, z+1/2)', '(-x, -y, z)',
                        '(-y, x+1/2, z+1/4)', '(-y+1/2, x, z+3/4)',
                        '(y+1/2, -x, z+3/4)', '(y, -x+1/2, z+1/4)'),
                    'hkl: h+k+l=2n, hk0: h+k=2n, 0kl: k+l=2n, hhl: l=2n, '
                    '00l: l=4n, h00: h=2n')},
      '81': {'1a': (0, ('(0, 0, 0)', ), None),
             '1b': (0, ('(0, 0, 1/2)', ), None),
             '1c': (0, ('(1/2, 1/2, 0)', ), None),
             '1d': (0, ('(1/2, 1/2, 1/2)', ), None),
             '2e': (4, ('(0, 0, z)', '(0, 0, -z)'), None),
             '2f': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, -z)'), None),
             '2g': (4, ('(0, 1/2, z)', '(1/2, 0, -z)'), 'hk0: h+k=2n'),
             '4h': (7, ('(x, y, z)', '(-x, -y, z)', '(y, -x, -z)',
                        '(-y, x, -z)'), None)},
      '82': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)'), None),
             '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)'), None),
             '2c': (0, ('(0, 1/2, 1/4)', '(1/2, 0, 3/4)'), None),
             '2d': (0, ('(0, 1/2, 3/4)', '(1/2, 0, 1/4)'), None),
             '4e': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(0, 0, -z)',
                        '(1/2, 1/2, -z+1/2)'), None),
             '4f': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(1/2, 0, -z)',
                        '(0, 1/2, -z+1/2)'), None),
             '8g': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                        '(-x+1/2, -y+1/2, z+1/2)', '(y, -x, -z)',
                        '(y+1/2, -x+1/2, -z+1/2)', '(-y, x, -z)',
                        '(-y+1/2, x+1/2, -z+1/2)'),
                    'hkl: h+k+l=2n, hk0: h+k=2n, 0kl: k+l=2n, hhl: l=2n, '
                    '00l: l=2n, h00: h=2n')},
      '83': {'1a': (0, ('(0, 0, 0)', ), None),
             '1b': (0, ('(0, 0, 1/2)', ), None),
             '1c': (0, ('(1/2, 1/2, 0)', ), None),
             '1d': (0, ('(1/2, 1/2, 1/2)', ), None),
             '2e': (0, ('(0, 1/2, 0)', '(1/2, 0, 0)'), 'hkl: h+k=2n'),
             '2f': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)'), 'hkl: h+k=2n'),
             '2g': (4, ('(0, 0, z)', '(0, 0, -z)'), None),
             '2h': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, -z)'), None),
             '4i': (4, ('(0, 1/2, z)', '(1/2, 0, z)', '(0, 1/2, -z)',
                        '(1/2, 0, -z)'), 'hkl: h+k=2n'),
             '4j': (3, ('(x, y, 0)', '(-x, -y, 0)', '(-y, x, 0)',
                        '(y, -x, 0)'), None),
             '4k': (3, ('(x, y, 1/2)', '(-x, -y, 1/2)', '(-y, x, 1/2)',
                        '(y, -x, 1/2)'), None),
             '8l': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z)',
                        '(y, -x, z)', '(-x, -y, -z)', '(x, y, -z)',
                        '(y, -x, -z)', '(-y, x, -z)'), None)},
      '84': {'2a': (0, ('(0, 0, 0)', '(0, 0, 1/2)'), 'hkl: l=2n'),
             '2b': (0, ('(1/2, 1/2, 0)', '(1/2, 1/2, 1/2)'), 'hkl: l=2n'),
             '2c': (0, ('(0, 1/2, 0)', '(1/2, 0, 1/2)'), 'hkl: h+k+l=2n'),
             '2d': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 0)'), 'hkl: h+k+l=2n'),
             '2e': (0, ('(0, 0, 1/4)', '(0, 0, 3/4)'), 'hkl: l=2n'),
             '2f': (0, ('(1/2, 1/2, 1/4)', '(1/2, 1/2, 3/4)'), 'hkl: l=2n'),
             '4g': (4, ('(0, 0, z)', '(0, 0, z+1/2)', '(0, 0, -z)',
                        '(0, 0, -z+1/2)'), 'hkl: l=2n'),
             '4h': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, z+1/2)',
                        '(1/2, 1/2, -z)', '(1/2, 1/2, -z+1/2)'), 'hkl: l=2n'),
             '4i': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(0, 1/2, -z)',
                        '(1/2, 0, -z+1/2)'), 'hkl: h+k+l=2n'),
             '4j': (3, ('(x, y, 0)', '(-x, -y, 0)', '(-y, x, 1/2)',
                        '(y, -x, 1/2)'), None),
             '8k': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z+1/2)',
                        '(y, -x, z+1/2)', '(-x, -y, -z)', '(x, y, -z)',
                        '(y, -x, -z+1/2)', '(-y, x, -z+1/2)'), '00l: l=2n')},
      '85:1': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)'), 'hkl: h+k=2n'),
               '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)'), 'hkl: h+k=2n'),
               '2c': (4, ('(0, 1/2, z)', '(1/2, 0, -z)'), None),
               '4d': (0, ('(1/4, 1/4, 0)', '(3/4, 3/4, 0)', '(1/4, 3/4, 0)',
                          '(3/4, 1/4, 0)'), 'hkl: h,k=2n'),
               '4e': (0, ('(1/4, 1/4, 1/2)', '(3/4, 3/4, 1/2)',
                          '(1/4, 3/4, 1/2)', '(3/4, 1/4, 1/2)'), 'hkl: h,k=2n'
                      ),
               '4f': (4, ('(0, 0, z)', '(1/2, 1/2, z)', '(1/2, 1/2, -z)',
                          '(0, 0, -z)'), 'hkl: h+k=2n'),
               '8g': (7, ('(x, y, z)', '(-x, -y, z)', '(-y+1/2, x+1/2, z)',
                          '(y+1/2, -x+1/2, z)', '(-x+1/2, -y+1/2, -z)',
                          '(x+1/2, y+1/2, -z)', '(y, -x, -z)', '(-y, x, -z)'),
                      'hk0: h+k=2n, h00: h=2n')},
      '85:2': {'2a': (0, ('(1/4, 3/4, 0)', '(3/4, 1/4, 0)'), 'n/a'),
               '2b': (0, ('(1/4, 3/4, 1/2)', '(3/4, 1/4, 1/2)'), 'n/a'),
               '2c': (4, ('(1/4, 1/4, z)', '(3/4, 3/4, -z)'), 'n/a'),
               '4d': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(1/2, 0, 0)',
                          '(0, 1/2, 0)'), 'n/a'),
               '4e': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)', '(1/2, 0, 1/2)',
                          '(0, 1/2, 1/2)'), 'n/a'),
               '4f': (4, ('(1/4, 3/4, z)', '(3/4, 1/4, z)', '(3/4, 1/4, -z)',
                          '(1/4, 3/4, -z)'), 'n/a'),
               '8g': (7, ('(x, y, z)', '(-x+1/2, -y+1/2, z)',
                          '(-y+1/2, x, z)', '(y, -x+1/2, z)', '(-x, -y, -z)',
                          '(x+1/2, y+1/2, -z)', '(y+1/2, -x, -z)',
                          '(-y, x+1/2, -z)'), 'n/a')},
      '86:1': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)'), 'hkl: h+k+l=2n'),
               '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)'), 'hkl: h+k+l=2n'),
               '4c': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 1/4)',
                          '(1/4, 3/4, 3/4)', '(3/4, 1/4, 3/4)'),
                      'hkl: h+k,h+l,k+l=2n'),
               '4d': (0, ('(1/4, 1/4, 3/4)', '(3/4, 3/4, 3/4)',
                          '(1/4, 3/4, 1/4)', '(3/4, 1/4, 1/4)'),
                      'hkl: h+k,h+l,k+l=2n'),
               '4e': (4, ('(0, 1/2, z)', '(0, 1/2, z+1/2)',
                          '(1/2, 0, -z+1/2)', '(1/2, 0, -z)'), 'hkl: l=2n'),
               '4f': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)',
                          '(1/2, 1/2, -z+1/2)', '(0, 0, -z)'), 'hkl: h+k+l=2n'
                      ),
               '8g': (7, ('(x, y, z)', '(-x, -y, z)',
                          '(-y+1/2, x+1/2, z+1/2)', '(y+1/2, -x+1/2, z+1/2)',
                          '(-x+1/2, -y+1/2, -z+1/2)',
                          '(x+1/2, y+1/2, -z+1/2)', '(y, -x, -z)',
                          '(-y, x, -z)'), 'hk0: h+k=2n, 00l: l=2n, h00: h=2n'
                      )},
      '86:2': {'2a': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)'), 'n/a'),
               '2b': (0, ('(1/4, 1/4, 3/4)', '(3/4, 3/4, 1/4)'), 'n/a'),
               '4c': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(0, 1/2, 1/2)',
                          '(1/2, 0, 1/2)'), 'n/a'),
               '4d': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)', '(0, 1/2, 0)',
                          '(1/2, 0, 0)'), 'n/a'),
               '4e': (4, ('(3/4, 1/4, z)', '(3/4, 1/4, z+1/2)',
                          '(1/4, 3/4, -z)', '(1/4, 3/4, -z+1/2)'), 'n/a'),
               '4f': (4, ('(1/4, 1/4, z)', '(3/4, 3/4, z+1/2)',
                          '(3/4, 3/4, -z)', '(1/4, 1/4, -z+1/2)'), 'n/a'),
               '8g': (7, ('(x, y, z)', '(-x+1/2, -y+1/2, z)',
                          '(-y, x+1/2, z+1/2)', '(y+1/2, -x, z+1/2)',
                          '(-x, -y, -z)', '(x+1/2, y+1/2, -z)',
                          '(y, -x+1/2, -z+1/2)', '(-y+1/2, x, -z+1/2)'), 'n/a'
                      )},
      '87': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)'), None),
             '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)'), None),
             '4c': (0, ('(0, 1/2, 0)', '(1/2, 0, 1/2)', '(1/2, 0, 0)',
                        '(0, 1/2, 1/2)'), 'hkl: l=2n'),
             '4d': (0, ('(0, 1/2, 1/4)', '(1/2, 0, 3/4)', '(1/2, 0, 1/4)',
                        '(0, 1/2, 3/4)'), 'hkl: l=2n'),
             '4e': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(0, 0, -z)',
                        '(1/2, 1/2, -z+1/2)'), None),
             '8f': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)',
                        '(3/4, 3/4, 1/4)', '(1/4, 1/4, 3/4)',
                        '(3/4, 1/4, 1/4)', '(1/4, 3/4, 3/4)',
                        '(1/4, 3/4, 1/4)', '(3/4, 1/4, 3/4)'), 'hkl: k,l=2n'),
             '8g': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(1/2, 0, z)',
                        '(0, 1/2, z+1/2)', '(0, 1/2, -z)', '(1/2, 0, -z+1/2)',
                        '(1/2, 0, -z)', '(0, 1/2, -z+1/2)'), 'hkl: l=2n'),
             '8h': (3, ('(x, y, 0)', '(x+1/2, y+1/2, 1/2)', '(-x, -y, 0)',
                        '(-x+1/2, -y+1/2, 1/2)', '(-y, x, 0)',
                        '(-y+1/2, x+1/2, 1/2)', '(y, -x, 0)',
                        '(y+1/2, -x+1/2, 1/2)'), None),
             '16i': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                         '(-x+1/2, -y+1/2, z+1/2)', '(-y, x, z)',
                         '(-y+1/2, x+1/2, z+1/2)', '(y, -x, z)',
                         '(y+1/2, -x+1/2, z+1/2)', '(-x, -y, -z)',
                         '(-x+1/2, -y+1/2, -z+1/2)', '(x, y, -z)',
                         '(x+1/2, y+1/2, -z+1/2)', '(y, -x, -z)',
                         '(y+1/2, -x+1/2, -z+1/2)', '(-y, x, -z)',
                         '(-y+1/2, x+1/2, -z+1/2)'),
                     'hkl: h+k+l=2n, hk0: h+k=2n, 0kl: k+l=2n, hhl: l=2n, '
                     '00l: l=2n, h00: h=2n')},
      '88:1': {'4a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)', '(0, 1/2, 1/4)',
                          '(1/2, 0, 3/4)'), 'hkl: l=2n+1 or 2h+l=4n'),
               '4b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)', '(0, 1/2, 3/4)',
                          '(1/2, 0, 1/4)'), 'hkl: l=2n+1 or 2h+l=4n'),
               '8c': (0, ('(0, 1/4, 1/8)', '(1/2, 3/4, 5/8)',
                          '(1/2, 1/4, 5/8)', '(0, 3/4, 1/8)',
                          '(3/4, 1/2, 3/8)', '(1/4, 0, 7/8)', '(3/4, 0, 7/8)',
                          '(1/4, 1/2, 3/8)'), 'hkl: l=2n+1 or h,k=2n, '
                      'h+k+l=4n'),
               '8d': (0, ('(0, 1/4, 5/8)', '(1/2, 3/4, 1/8)',
                          '(1/2, 1/4, 1/8)', '(0, 3/4, 5/8)',
                          '(3/4, 1/2, 7/8)', '(1/4, 0, 3/8)', '(3/4, 0, 3/8)',
                          '(1/4, 1/2, 7/8)'), 'hkl: l=2n+1 or h,k=2n, '
                      'h+k+l=4n'),
               '8e': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(0, 1/2, z+1/4)',
                          '(1/2, 0, z+3/4)', '(0, 1/2, -z+1/4)',
                          '(1/2, 0, -z+3/4)', '(0, 0, -z)',
                          '(1/2, 1/2, -z+1/2)'), 'hkl: l=2n+1 or 2h+l=4n'),
               '16f': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)',
                           '(-x+1/2, -y+1/2, z+1/2)', '(-x, -y, z)',
                           '(-y, x+1/2, z+1/4)', '(-y+1/2, x, z+3/4)',
                           '(y+1/2, -x, z+3/4)', '(y, -x+1/2, z+1/4)',
                           '(-x, -y+1/2, -z+1/4)', '(-x+1/2, -y, -z+3/4)',
                           '(x+1/2, y, -z+3/4)', '(x, y+1/2, -z+1/4)',
                           '(y, -x, -z)', '(y+1/2, -x+1/2, -z+1/2)',
                           '(-y+1/2, x+1/2, -z+1/2)', '(-y, x, -z)'),
                       'hkl: h+k+l=2n, hk0: h,k=2n, 0kl: k+l=2n, hhl: l=2n, '
                       '00l: l=4n, h00: h=2n, h-h0: h=2n')},
      '88:2': {'4a': (0, ('(0, 1/4, 1/8)', '(1/2, 3/4, 5/8)',
                          '(1/2, 1/4, 3/8)', '(0, 3/4, 7/8)'), 'n/a'),
               '4b': (0, ('(0, 1/4, 5/8)', '(1/2, 3/4, 1/8)',
                          '(1/2, 1/4, 7/8)', '(0, 3/4, 3/8)'), 'n/a'),
               '8c': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)', '(1/2, 0, 1/2)',
                          '(0, 1/2, 0)', '(3/4, 1/4, 1/4)', '(1/4, 3/4, 3/4)',
                          '(3/4, 3/4, 3/4)', '(1/4, 1/4, 1/4)'), 'n/a'),
               '8d': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)', '(1/2, 0, 0)',
                          '(0, 1/2, 1/2)', '(3/4, 1/4, 3/4)',
                          '(1/4, 3/4, 1/4)', '(3/4, 3/4, 1/4)',
                          '(1/4, 1/4, 3/4)'), 'n/a'),
               '8e': (4, ('(0, 1/4, z)', '(1/2, 3/4, z+1/2)',
                          '(1/2, 1/4, z+1/4)', '(0, 3/4, z+3/4)',
                          '(0, 3/4, -z)', '(1/2, 1/4, -z+1/2)',
                          '(1/2, 3/4, -z+3/4)', '(0, 1/4, -z+1/4)'), 'n/a'),
               '16f': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)',
                           '(-x+1/2, -y, z+1/2)', '(-x, -y+1/2, z)',
                           '(-y+3/4, x+1/4, z+1/4)', '(-y+1/4, x+3/4, z+3/4)',
                           '(y+3/4, -x+3/4, z+3/4)', '(y+1/4, -x+1/4, z+1/4)',
                           '(-x, -y, -z)', '(-x+1/2, -y+1/2, -z+1/2)',
                           '(x+1/2, y, -z+1/2)', '(x, y+1/2, -z)',
                           '(y+1/4, -x+3/4, -z+3/4)',
                           '(y+3/4, -x+1/4, -z+1/4)',
                           '(-y+1/4, x+1/4, -z+1/4)',
                           '(-y+3/4, x+3/4, -z+3/4)'), 'n/a')},
      '89': {'1a': (0, ('(0, 0, 0)', ), None),
             '1b': (0, ('(0, 0, 1/2)', ), None),
             '1c': (0, ('(1/2, 1/2, 0)', ), None),
             '1d': (0, ('(1/2, 1/2, 1/2)', ), None),
             '2e': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)'), 'hkl: h+k=2n'),
             '2f': (0, ('(1/2, 0, 1/2)', '(0, 1/2, 1/2)'), 'hkl: h+k=2n'),
             '2g': (4, ('(0, 0, z)', '(0, 0, -z)'), None),
             '2h': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, -z)'), None),
             '4i': (4, ('(0, 1/2, z)', '(1/2, 0, z)', '(0, 1/2, -z)',
                        '(1/2, 0, -z)'), 'hkl: h+k=2n'),
             '4j': (1, ('(x, x, 0)', '(-x, -x, 0)', '(-x, x, 0)',
                        '(x, -x, 0)'), None),
             '4k': (1, ('(x, x, 1/2)', '(-x, -x, 1/2)', '(-x, x, 1/2)',
                        '(x, -x, 1/2)'), None),
             '4l': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(0, x, 0)', '(0, -x, 0)'),
                    None),
             '4m': (1, ('(x, 1/2, 1/2)', '(-x, 1/2, 1/2)', '(1/2, x, 1/2)',
                        '(1/2, -x, 1/2)'), None),
             '4n': (1, ('(x, 0, 1/2)', '(-x, 0, 1/2)', '(0, x, 1/2)',
                        '(0, -x, 1/2)'), None),
             '4o': (1, ('(x, 1/2, 0)', '(-x, 1/2, 0)', '(1/2, x, 0)',
                        '(1/2, -x, 0)'), None),
             '8p': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z)',
                        '(y, -x, z)', '(-x, y, -z)', '(x, -y, -z)',
                        '(y, x, -z)', '(-y, -x, -z)'), None)},
      '90': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)'), 'hkl: h+k=2n'),
             '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)'), 'hkl: h+k=2n'),
             '2c': (4, ('(0, 1/2, z)', '(1/2, 0, -z)'), 'hk0: h+k=2n'),
             '4d': (4, ('(0, 0, z)', '(1/2, 1/2, z)', '(1/2, 1/2, -z)',
                        '(0, 0, -z)'), 'hkl: h+k=2n'),
             '4e': (1, ('(x, x, 0)', '(-x, -x, 0)', '(-x+1/2, x+1/2, 0)',
                        '(x+1/2, -x+1/2, 0)'), '0kl: k=2n'),
             '4f': (1, ('(x, x, 1/2)', '(-x, -x, 1/2)',
                        '(-x+1/2, x+1/2, 1/2)', '(x+1/2, -x+1/2, 1/2)'),
                    '0kl: k=2n'),
             '8g': (7, ('(x, y, z)', '(-x, -y, z)', '(-y+1/2, x+1/2, z)',
                        '(y+1/2, -x+1/2, z)', '(-x+1/2, y+1/2, -z)',
                        '(x+1/2, -y+1/2, -z)', '(y, x, -z)', '(-y, -x, -z)'),
                    'h00: h=2n')},
      '91': {'4a': (2, ('(0, y, 0)', '(0, -y, 1/2)', '(-y, 0, 1/4)',
                        '(y, 0, 3/4)'), 'hhl: l=2n+1 or l=4n'),
             '4b': (2, ('(1/2, y, 0)', '(1/2, -y, 1/2)', '(-y, 1/2, 1/4)',
                        '(y, 1/2, 3/4)'), 'hhl: l=2n+1 or l=4n'),
             '4c': (1, ('(x, x, 3/8)', '(-x, -x, 7/8)', '(-x, x, 5/8)',
                        '(x, -x, 1/8)'), '0kl: l=2n+1 or l=4n'),
             '8d': (7, ('(x, y, z)', '(-x, -y, z+1/2)', '(-y, x, z+1/4)',
                        '(y, -x, z+3/4)', '(-x, y, -z)', '(x, -y, -z+1/2)',
                        '(y, x, -z+3/4)', '(-y, -x, -z+1/4)'), '00l: l=4n')},
      '92': {'4a': (1, ('(x, x, 0)', '(-x, -x, 1/2)', '(-x+1/2, x+1/2, 1/4)',
                        '(x+1/2, -x+1/2, 3/4)'), '0kl: l=2n+1 or 2k+l=4n'),
             '8b': (7, ('(x, y, z)', '(-x, -y, z+1/2)',
                        '(-y+1/2, x+1/2, z+1/4)', '(y+1/2, -x+1/2, z+3/4)',
                        '(-x+1/2, y+1/2, -z+1/4)', '(x+1/2, -y+1/2, -z+3/4)',
                        '(y, x, -z)', '(-y, -x, -z+1/2)'),
                    '00l: l=4n, h00: h=2n')},
      '93': {'2a': (0, ('(0, 0, 0)', '(0, 0, 1/2)'), 'hkl: l=2n'),
             '2b': (0, ('(1/2, 1/2, 0)', '(1/2, 1/2, 1/2)'), 'hkl: l=2n'),
             '2c': (0, ('(0, 1/2, 0)', '(1/2, 0, 1/2)'), 'hkl: h+k+l=2n'),
             '2d': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 0)'), 'hkl: h+k+l=2n'),
             '2e': (0, ('(0, 0, 1/4)', '(0, 0, 3/4)'), 'hkl: l=2n'),
             '2f': (0, ('(1/2, 1/2, 1/4)', '(1/2, 1/2, 3/4)'), 'hkl: l=2n'),
             '4g': (4, ('(0, 0, z)', '(0, 0, z+1/2)', '(0, 0, -z)',
                        '(0, 0, -z+1/2)'), 'hkl: l=2n'),
             '4h': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, z+1/2)',
                        '(1/2, 1/2, -z)', '(1/2, 1/2, -z+1/2)'), 'hkl: l=2n'),
             '4i': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(0, 1/2, -z)',
                        '(1/2, 0, -z+1/2)'), 'hkl: h+k+l=2n'),
             '4j': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(0, x, 1/2)',
                        '(0, -x, 1/2)'), 'hhl: l=2n'),
             '4k': (1, ('(x, 1/2, 1/2)', '(-x, 1/2, 1/2)', '(1/2, x, 0)',
                        '(1/2, -x, 0)'), 'hhl: l=2n'),
             '4l': (1, ('(x, 0, 1/2)', '(-x, 0, 1/2)', '(0, x, 0)',
                        '(0, -x, 0)'), 'hhl: l=2n'),
             '4m': (1, ('(x, 1/2, 0)', '(-x, 1/2, 0)', '(1/2, x, 1/2)',
                        '(1/2, -x, 1/2)'), 'hhl: l=2n'),
             '4n': (1, ('(x, x, 1/4)', '(-x, -x, 1/4)', '(-x, x, 3/4)',
                        '(x, -x, 3/4)'), '0kl: l=2n'),
             '4o': (1, ('(x, x, 3/4)', '(-x, -x, 3/4)', '(-x, x, 1/4)',
                        '(x, -x, 1/4)'), '0kl: l=2n'),
             '8p': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z+1/2)',
                        '(y, -x, z+1/2)', '(-x, y, -z)', '(x, -y, -z)',
                        '(y, x, -z+1/2)', '(-y, -x, -z+1/2)'), '00l: l=2n')},
      '94': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)'), 'hkl: h+k+l=2n'),
             '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)'), 'hkl: h+k+l=2n'),
             '4c': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)',
                        '(1/2, 1/2, -z+1/2)', '(0, 0, -z)'), 'hkl: h+k+l=2n'),
             '4d': (4, ('(0, 1/2, z)', '(0, 1/2, z+1/2)', '(1/2, 0, -z+1/2)',
                        '(1/2, 0, -z)'), 'hkl: l=2n, hk0: h+k=2n'),
             '4e': (1, ('(x, x, 0)', '(-x, -x, 0)', '(-x+1/2, x+1/2, 1/2)',
                        '(x+1/2, -x+1/2, 1/2)'), '0kl: k+l=2n'),
             '4f': (1, ('(x, x, 1/2)', '(-x, -x, 1/2)', '(-x+1/2, x+1/2, 0)',
                        '(x+1/2, -x+1/2, 0)'), '0kl: k+l=2n'),
             '8g': (7, ('(x, y, z)', '(-x, -y, z)', '(-y+1/2, x+1/2, z+1/2)',
                        '(y+1/2, -x+1/2, z+1/2)', '(-x+1/2, y+1/2, -z+1/2)',
                        '(x+1/2, -y+1/2, -z+1/2)', '(y, x, -z)',
                        '(-y, -x, -z)'), '00l: l=2n, h00: h=2n')},
      '95': {'4a': (2, ('(0, y, 0)', '(0, -y, 1/2)', '(-y, 0, 3/4)',
                        '(y, 0, 1/4)'), 'hhl: l=2n+1 or l=4n'),
             '4b': (2, ('(1/2, y, 0)', '(1/2, -y, 1/2)', '(-y, 1/2, 3/4)',
                        '(y, 1/2, 1/4)'), 'hhl: l=2n+1 or l=4n'),
             '4c': (1, ('(x, x, 5/8)', '(-x, -x, 1/8)', '(-x, x, 3/8)',
                        '(x, -x, 7/8)'), '0kl: l=2n+1 or l=4n'),
             '8d': (7, ('(x, y, z)', '(-x, -y, z+1/2)', '(-y, x, z+3/4)',
                        '(y, -x, z+1/4)', '(-x, y, -z)', '(x, -y, -z+1/2)',
                        '(y, x, -z+1/4)', '(-y, -x, -z+3/4)'), '00l: l=4n')},
      '96': {'4a': (1, ('(x, x, 0)', '(-x, -x, 1/2)', '(-x+1/2, x+1/2, 3/4)',
                        '(x+1/2, -x+1/2, 1/4)'), '0kl: l=2n+1 or 2k+l=4n'),
             '8b': (7, ('(x, y, z)', '(-x, -y, z+1/2)',
                        '(-y+1/2, x+1/2, z+3/4)', '(y+1/2, -x+1/2, z+1/4)',
                        '(-x+1/2, y+1/2, -z+3/4)', '(x+1/2, -y+1/2, -z+1/4)',
                        '(y, x, -z)', '(-y, -x, -z+1/2)'),
                    '00l: l=4n, h00: h=2n')},
      '97': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)'), None),
             '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)'), None),
             '4c': (0, ('(0, 1/2, 0)', '(1/2, 0, 1/2)', '(1/2, 0, 0)',
                        '(0, 1/2, 1/2)'), 'hkl: l=2n'),
             '4d': (0, ('(0, 1/2, 1/4)', '(1/2, 0, 3/4)', '(1/2, 0, 1/4)',
                        '(0, 1/2, 3/4)'), 'hkl: l=2n'),
             '4e': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(0, 0, -z)',
                        '(1/2, 1/2, -z+1/2)'), None),
             '8f': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(1/2, 0, z)',
                        '(0, 1/2, z+1/2)', '(0, 1/2, -z)', '(1/2, 0, -z+1/2)',
                        '(1/2, 0, -z)', '(0, 1/2, -z+1/2)'), 'hkl: l=2n'),
             '8g': (1, ('(x, x, 0)', '(x+1/2, x+1/2, 1/2)', '(-x, -x, 0)',
                        '(-x+1/2, -x+1/2, 1/2)', '(-x, x, 0)',
                        '(-x+1/2, x+1/2, 1/2)', '(x, -x, 0)',
                        '(x+1/2, -x+1/2, 1/2)'), None),
             '8h': (1, ('(x, 0, 0)', '(x+1/2, 1/2, 1/2)', '(-x, 0, 0)',
                        '(-x+1/2, 1/2, 1/2)', '(0, x, 0)',
                        '(1/2, x+1/2, 1/2)', '(0, -x, 0)',
                        '(1/2, -x+1/2, 1/2)'), None),
             '8i': (1, ('(x, 0, 1/2)', '(x+1/2, 1/2, 0)', '(-x, 0, 1/2)',
                        '(-x+1/2, 1/2, 0)', '(0, x, 1/2)', '(1/2, x+1/2, 0)',
                        '(0, -x, 1/2)', '(1/2, -x+1/2, 0)'), None),
             '8j': (1, ('(x, x+1/2, 1/4)', '(x+1/2, x, 3/4)',
                        '(-x, -x+1/2, 1/4)', '(-x+1/2, -x, 3/4)',
                        '(-x+1/2, x, 1/4)', '(-x, x+1/2, 3/4)',
                        '(x+1/2, -x, 1/4)', '(x, -x+1/2, 3/4)'), '0kl: k=2n'),
             '16k': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                         '(-x+1/2, -y+1/2, z+1/2)', '(-y, x, z)',
                         '(-y+1/2, x+1/2, z+1/2)', '(y, -x, z)',
                         '(y+1/2, -x+1/2, z+1/2)', '(-x, y, -z)',
                         '(-x+1/2, y+1/2, -z+1/2)', '(x, -y, -z)',
                         '(x+1/2, -y+1/2, -z+1/2)', '(y, x, -z)',
                         '(y+1/2, x+1/2, -z+1/2)', '(-y, -x, -z)',
                         '(-y+1/2, -x+1/2, -z+1/2)'),
                     'hkl: h+k+l=2n, hk0: h+k=2n, 0kl: k+l=2n, hhl: l=2n, '
                     '00l: l=2n, h00: h=2n')},
      '98': {'4a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)', '(0, 1/2, 1/4)',
                        '(1/2, 0, 3/4)'), 'hkl: l=2n+1 or 2h+l=4n'),
             '4b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)', '(0, 1/2, 3/4)',
                        '(1/2, 0, 1/4)'), 'hkl: l=2n+1 or 2h+l=4n'),
             '8c': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(0, 1/2, z+1/4)',
                        '(1/2, 0, z+3/4)', '(1/2, 0, -z+3/4)',
                        '(0, 1/2, -z+1/4)', '(1/2, 1/2, -z+1/2)',
                        '(0, 0, -z)'), 'hkl: l=2n+1 or 2h+l=4n'),
             '8d': (1, ('(x, x, 0)', '(x+1/2, x+1/2, 1/2)',
                        '(-x+1/2, -x+1/2, 1/2)', '(-x, -x, 0)',
                        '(-x, x+1/2, 1/4)', '(-x+1/2, x, 3/4)',
                        '(x+1/2, -x, 3/4)', '(x, -x+1/2, 1/4)'),
                    '0kl: k=2n+1 or l=4n'),
             '8e': (1, ('(-x, x, 0)', '(-x+1/2, x+1/2, 1/2)',
                        '(x+1/2, -x+1/2, 1/2)', '(x, -x, 0)',
                        '(-x, -x+1/2, 1/4)', '(-x+1/2, -x, 3/4)',
                        '(x+1/2, x, 3/4)', '(x, x+1/2, 1/4)'),
                    '0kl: k=2n+1 or l=4n'),
             '8f': (1, ('(x, 1/4, 1/8)', '(x+1/2, 3/4, 5/8)',
                        '(-x+1/2, 1/4, 5/8)', '(-x, 3/4, 1/8)',
                        '(3/4, x+1/2, 3/8)', '(1/4, x, 7/8)',
                        '(3/4, -x, 7/8)', '(1/4, -x+1/2, 3/8)'), 'hhl: l=4n'),
             '16g': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)',
                         '(-x+1/2, -y+1/2, z+1/2)', '(-x, -y, z)',
                         '(-y, x+1/2, z+1/4)', '(-y+1/2, x, z+3/4)',
                         '(y+1/2, -x, z+3/4)', '(y, -x+1/2, z+1/4)',
                         '(-x+1/2, y, -z+3/4)', '(-x, y+1/2, -z+1/4)',
                         '(x, -y+1/2, -z+1/4)', '(x+1/2, -y, -z+3/4)',
                         '(y+1/2, x+1/2, -z+1/2)', '(y, x, -z)',
                         '(-y, -x, -z)', '(-y+1/2, -x+1/2, -z+1/2)'),
                     'hkl: h+k+l=2n, hk0: h+k=2n, 0kl: k+l=2n, hhl: l=2n, '
                     '00l: l=4n, h00: h=2n')},
      '99': {'1a': (4, ('(0, 0, z)', ), None),
             '1b': (4, ('(1/2, 1/2, z)', ), None),
             '2c': (4, ('(1/2, 0, z)', '(0, 1/2, z)'), 'hkl: h+k=2n'),
             '4d': (5, ('(x, x, z)', '(-x, -x, z)', '(-x, x, z)',
                        '(x, -x, z)'), None),
             '4e': (5, ('(x, 0, z)', '(-x, 0, z)', '(0, x, z)', '(0, -x, z)'),
                    None),
             '4f': (5, ('(x, 1/2, z)', '(-x, 1/2, z)', '(1/2, x, z)',
                        '(1/2, -x, z)'), None),
             '8g': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z)',
                        '(y, -x, z)', '(x, -y, z)', '(-x, y, z)',
                        '(-y, -x, z)', '(y, x, z)'), None)},
      '100': {'2a': (4, ('(0, 0, z)', '(1/2, 1/2, z)'), 'hkl: h+k=2n'),
              '2b': (4, ('(1/2, 0, z)', '(0, 1/2, z)'), 'hkl: h+k=2n'),
              '4c': (5, ('(x, x+1/2, z)', '(-x, -x+1/2, z)', '(-x+1/2, x, z)',
                         '(x+1/2, -x, z)'), None),
              '8d': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z)',
                         '(y, -x, z)', '(x+1/2, -y+1/2, z)',
                         '(-x+1/2, y+1/2, z)', '(-y+1/2, -x+1/2, z)',
                         '(y+1/2, x+1/2, z)'), '0kl: k=2n, h00: h=2n')},
      '101': {'2a': (4, ('(0, 0, z)', '(0, 0, z+1/2)'), 'hkl: l=2n'),
              '2b': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, z+1/2)'), 'hkl: l=2n'),
              '4c': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(0, 1/2, z+1/2)',
                         '(1/2, 0, z)'), 'hkl: h+k,l=2n'),
              '4d': (5, ('(x, x, z)', '(-x, -x, z)', '(-x, x, z+1/2)',
                         '(x, -x, z+1/2)'), None),
              '8e': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z+1/2)',
                         '(y, -x, z+1/2)', '(x, -y, z+1/2)', '(-x, y, z+1/2)',
                         '(-y, -x, z)', '(y, x, z)'), '0kl: l=2n, 00l: l=2n'
                     )},
      '102': {'2a': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)'), 'hkl: h+k+l=2n'),
              '4b': (4, ('(0, 1/2, z)', '(0, 1/2, z+1/2)', '(1/2, 0, z+1/2)',
                         '(1/2, 0, z)'), 'hkl: h+k,l=2n'),
              '4c': (5, ('(x, x, z)', '(-x, -x, z)', '(-x+1/2, x+1/2, z+1/2)',
                         '(x+1/2, -x+1/2, z+1/2)'), None),
              '8d': (7, ('(x, y, z)', '(-x, -y, z)', '(-y+1/2, x+1/2, z+1/2)',
                         '(y+1/2, -x+1/2, z+1/2)', '(x+1/2, -y+1/2, z+1/2)',
                         '(-x+1/2, y+1/2, z+1/2)', '(-y, -x, z)', '(y, x, z)'
                         ), '0kl: k+l=2n, 00l: l=2n, h00: h=2n')},
      '103': {'2a': (4, ('(0, 0, z)', '(0, 0, z+1/2)'), 'hkl: l=2n'),
              '2b': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, z+1/2)'), 'hkl: l=2n'),
              '4c': (4, ('(0, 1/2, z)', '(1/2, 0, z)', '(0, 1/2, z+1/2)',
                         '(1/2, 0, z+1/2)'), 'hkl: h+k,l=2n'),
              '8d': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z)',
                         '(y, -x, z)', '(x, -y, z+1/2)', '(-x, y, z+1/2)',
                         '(-y, -x, z+1/2)', '(y, x, z+1/2)'),
                     '0kl: l=2n, hhl: l=2n, 00l: l=2n')},
      '104': {'2a': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)'), 'hkl: h+k+l=2n'),
              '4b': (4, ('(0, 1/2, z)', '(1/2, 0, z)', '(1/2, 0, z+1/2)',
                         '(0, 1/2, z+1/2)'), 'hkl: h+k,l=2n'),
              '8c': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z)',
                         '(y, -x, z)', '(x+1/2, -y+1/2, z+1/2)',
                         '(-x+1/2, y+1/2, z+1/2)', '(-y+1/2, -x+1/2, z+1/2)',
                         '(y+1/2, x+1/2, z+1/2)'),
                     '0kl: k+l=2n, hhl: l=2n, 00l: l=2n, h00: h=2n')},
      '105': {'2a': (4, ('(0, 0, z)', '(0, 0, z+1/2)'), 'hkl: l=2n'),
              '2b': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, z+1/2)'), 'hkl: l=2n'),
              '2c': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)'), 'hkl: h+k+l=2n'),
              '4d': (5, ('(x, 0, z)', '(-x, 0, z)', '(0, x, z+1/2)',
                         '(0, -x, z+1/2)'), None),
              '4e': (5, ('(x, 1/2, z)', '(-x, 1/2, z)', '(1/2, x, z+1/2)',
                         '(1/2, -x, z+1/2)'), None),
              '8f': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z+1/2)',
                         '(y, -x, z+1/2)', '(x, -y, z)', '(-x, y, z)',
                         '(-y, -x, z+1/2)', '(y, x, z+1/2)'),
                     'hhl: l=2n, 00l: l=2n')},
      '106': {'4a': (4, ('(0, 0, z)', '(0, 0, z+1/2)', '(1/2, 1/2, z)',
                         '(1/2, 1/2, z+1/2)'), 'hkl: h+k,l=2n'),
              '4b': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(1/2, 0, z)',
                         '(0, 1/2, z+1/2)'), 'hkl: h+k,l=2n'),
              '8c': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z+1/2)',
                         '(y, -x, z+1/2)', '(x+1/2, -y+1/2, z)',
                         '(-x+1/2, y+1/2, z)', '(-y+1/2, -x+1/2, z+1/2)',
                         '(y+1/2, x+1/2, z+1/2)'),
                     '0kl: k=2n, hhl: l=2n, 00l: l=2n, h00: h=2n')},
      '107': {'2a': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)'), None),
              '4b': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(1/2, 0, z)',
                         '(0, 1/2, z+1/2)'), 'hkl: l=2n'),
              '8c': (5, ('(x, x, z)', '(x+1/2, x+1/2, z+1/2)', '(-x, -x, z)',
                         '(-x+1/2, -x+1/2, z+1/2)', '(-x, x, z)',
                         '(-x+1/2, x+1/2, z+1/2)', '(x, -x, z)',
                         '(x+1/2, -x+1/2, z+1/2)'), None),
              '8d': (5, ('(x, 0, z)', '(x+1/2, 1/2, z+1/2)', '(-x, 0, z)',
                         '(-x+1/2, 1/2, z+1/2)', '(0, x, z)',
                         '(1/2, x+1/2, z+1/2)', '(0, -x, z)',
                         '(1/2, -x+1/2, z+1/2)'), None),
              '16e': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                          '(-x+1/2, -y+1/2, z+1/2)', '(-y, x, z)',
                          '(-y+1/2, x+1/2, z+1/2)', '(y, -x, z)',
                          '(y+1/2, -x+1/2, z+1/2)', '(x, -y, z)',
                          '(x+1/2, -y+1/2, z+1/2)', '(-x, y, z)',
                          '(-x+1/2, y+1/2, z+1/2)', '(-y, -x, z)',
                          '(-y+1/2, -x+1/2, z+1/2)', '(y, x, z)',
                          '(y+1/2, x+1/2, z+1/2)'),
                      'hkl: h+k+l=2n, hk0: h+k=2n, 0kl: k+l=2n, hhl: l=2n, '
                      '00l: l=2n, h00: h=2n')},
      '108': {'4a': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(0, 0, z+1/2)',
                         '(1/2, 1/2, z)'), 'hkl: l=2n'),
              '4b': (4, ('(1/2, 0, z)', '(0, 1/2, z+1/2)', '(0, 1/2, z)',
                         '(1/2, 0, z+1/2)'), 'hkl: l=2n'),
              '8c': (5, ('(x, x+1/2, z)', '(x+1/2, x, z+1/2)',
                         '(-x, -x+1/2, z)', '(-x+1/2, -x, z+1/2)',
                         '(-x+1/2, x, z)', '(-x, x+1/2, z+1/2)',
                         '(x+1/2, -x, z)', '(x, -x+1/2, z+1/2)'), None),
              '16d': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                          '(-x+1/2, -y+1/2, z+1/2)', '(-y, x, z)',
                          '(-y+1/2, x+1/2, z+1/2)', '(y, -x, z)',
                          '(y+1/2, -x+1/2, z+1/2)', '(x, -y, z+1/2)',
                          '(x+1/2, -y+1/2, z)', '(-x, y, z+1/2)',
                          '(-x+1/2, y+1/2, z)', '(-y, -x, z+1/2)',
                          '(-y+1/2, -x+1/2, z)', '(y, x, z+1/2)',
                          '(y+1/2, x+1/2, z)'),
                      'hkl: h+k+l=2n, hk0: h+k=2n, 0kl: k,l=2n, hhl: l=2n, '
                      '00l: l=2n, h00: h=2n')},
      '109': {'4a': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(0, 1/2, z+1/4)',
                         '(1/2, 0, z+3/4)'), 'hkl: l=2n+1 or 2h+l=4n'),
              '8b': (6, ('(0, y, z)', '(1/2, y+1/2, z+1/2)',
                         '(1/2, -y+1/2, z+1/2)', '(0, -y, z)',
                         '(-y, 1/2, z+1/4)', '(-y+1/2, 0, z+3/4)',
                         '(y+1/2, 0, z+3/4)', '(y, 1/2, z+1/4)'), None),
              '16c': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)',
                          '(-x+1/2, -y+1/2, z+1/2)', '(-x, -y, z)',
                          '(-y, x+1/2, z+1/4)', '(-y+1/2, x, z+3/4)',
                          '(y+1/2, -x, z+3/4)', '(y, -x+1/2, z+1/4)',
                          '(x, -y, z)', '(x+1/2, -y+1/2, z+1/2)',
                          '(-x+1/2, y+1/2, z+1/2)', '(-x, y, z)',
                          '(-y, -x+1/2, z+1/4)', '(-y+1/2, -x, z+3/4)',
                          '(y+1/2, x, z+3/4)', '(y, x+1/2, z+1/4)'),
                      'hkl: h+k+l=2n, hk0: h+k=2n, 0kl: k+l=2n, hhl: 2h+l=4n, '
                      '00l: l=4n, h00: h=2n, h-h0: h=2n')},
      '110': {'8a': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(0, 1/2, z+1/4)',
                         '(1/2, 0, z+3/4)', '(0, 0, z+1/2)', '(1/2, 1/2, z)',
                         '(0, 1/2, z+3/4)', '(1/2, 0, z+1/4)'), 'hkl: 2h+l=4n'
                     ),
              '16b': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)',
                          '(-x+1/2, -y+1/2, z+1/2)', '(-x, -y, z)',
                          '(-y, x+1/2, z+1/4)', '(-y+1/2, x, z+3/4)',
                          '(y+1/2, -x, z+3/4)', '(y, -x+1/2, z+1/4)',
                          '(x, -y, z+1/2)', '(x+1/2, -y+1/2, z)',
                          '(-x+1/2, y+1/2, z)', '(-x, y, z+1/2)',
                          '(-y, -x+1/2, z+3/4)', '(-y+1/2, -x, z+1/4)',
                          '(y+1/2, x, z+1/4)', '(y, x+1/2, z+3/4)'),
                      'hkl: h+k+l=2n, hk0: h+k=2n, 0kl: k,l=2n, hhl: 2h+l=4n, '
                      '00l: l=4n, h00: h=2n, h-h0: h=2n')},
      '111': {'1a': (0, ('(0, 0, 0)', ), None),
              '1b': (0, ('(1/2, 1/2, 1/2)', ), None),
              '1c': (0, ('(0, 0, 1/2)', ), None),
              '1d': (0, ('(1/2, 1/2, 0)', ), None),
              '2e': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)'), 'hkl: h+k=2n'),
              '2f': (0, ('(1/2, 0, 1/2)', '(0, 1/2, 1/2)'), 'hkl: h+k=2n'),
              '2g': (4, ('(0, 0, z)', '(0, 0, -z)'), None),
              '2h': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, -z)'), None),
              '4i': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(0, -x, 0)', '(0, x, 0)'
                         ), None),
              '4j': (1, ('(x, 1/2, 1/2)', '(-x, 1/2, 1/2)', '(1/2, -x, 1/2)',
                         '(1/2, x, 1/2)'), None),
              '4k': (1, ('(x, 0, 1/2)', '(-x, 0, 1/2)', '(0, -x, 1/2)',
                         '(0, x, 1/2)'), None),
              '4l': (1, ('(x, 1/2, 0)', '(-x, 1/2, 0)', '(1/2, -x, 0)',
                         '(1/2, x, 0)'), None),
              '4m': (4, ('(0, 1/2, z)', '(1/2, 0, -z)', '(0, 1/2, -z)',
                         '(1/2, 0, z)'), 'hkl: h+k=2n'),
              '4n': (5, ('(x, x, z)', '(-x, -x, z)', '(x, -x, -z)',
                         '(-x, x, -z)'), None),
              '8o': (7, ('(x, y, z)', '(-x, -y, z)', '(y, -x, -z)',
                         '(-y, x, -z)', '(-x, y, -z)', '(x, -y, -z)',
                         '(-y, -x, z)', '(y, x, z)'), None)},
      '112': {'2a': (0, ('(0, 0, 1/4)', '(0, 0, 3/4)'), 'hkl: l=2n'),
              '2b': (0, ('(1/2, 0, 1/4)', '(0, 1/2, 3/4)'), 'hkl: h+k+l=2n'),
              '2c': (0, ('(1/2, 1/2, 1/4)', '(1/2, 1/2, 3/4)'), 'hkl: l=2n'),
              '2d': (0, ('(0, 1/2, 1/4)', '(1/2, 0, 3/4)'), 'hkl: h+k+l=2n'),
              '2e': (0, ('(0, 0, 0)', '(0, 0, 1/2)'), 'hkl: l=2n'),
              '2f': (0, ('(1/2, 1/2, 0)', '(1/2, 1/2, 1/2)'), 'hkl: l=2n'),
              '4g': (1, ('(x, 0, 1/4)', '(-x, 0, 1/4)', '(0, -x, 3/4)',
                         '(0, x, 3/4)'), None),
              '4h': (2, ('(1/2, y, 1/4)', '(1/2, -y, 1/4)', '(y, 1/2, 3/4)',
                         '(-y, 1/2, 3/4)'), None),
              '4i': (1, ('(x, 1/2, 1/4)', '(-x, 1/2, 1/4)', '(1/2, -x, 3/4)',
                         '(1/2, x, 3/4)'), None),
              '4j': (2, ('(0, y, 1/4)', '(0, -y, 1/4)', '(y, 0, 3/4)',
                         '(-y, 0, 3/4)'), None),
              '4k': (4, ('(0, 0, z)', '(0, 0, -z)', '(0, 0, -z+1/2)',
                         '(0, 0, z+1/2)'), 'hkl: l=2n'),
              '4l': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, -z)',
                         '(1/2, 1/2, -z+1/2)', '(1/2, 1/2, z+1/2)'),
                     'hkl: l=2n'),
              '4m': (4, ('(0, 1/2, z)', '(1/2, 0, -z)', '(0, 1/2, -z+1/2)',
                         '(1/2, 0, z+1/2)'), 'hkl: h+k+l=2n'),
              '8n': (7, ('(x, y, z)', '(-x, -y, z)', '(y, -x, -z)',
                         '(-y, x, -z)', '(-x, y, -z+1/2)', '(x, -y, -z+1/2)',
                         '(-y, -x, z+1/2)', '(y, x, z+1/2)'),
                     'hhl: l=2n, 00l: l=2n')},
      '113': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)'), 'hkl: h+k=2n'),
              '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)'), 'hkl: h+k=2n'),
              '2c': (4, ('(0, 1/2, z)', '(1/2, 0, -z)'), 'hk0: h+k=2n'),
              '4d': (4, ('(0, 0, z)', '(0, 0, -z)', '(1/2, 1/2, -z)',
                         '(1/2, 1/2, z)'), 'hkl: h+k=2n'),
              '4e': (5, ('(x, x+1/2, z)', '(-x, -x+1/2, z)',
                         '(x+1/2, -x, -z)', '(-x+1/2, x, -z)'), None),
              '8f': (7, ('(x, y, z)', '(-x, -y, z)', '(y, -x, -z)',
                         '(-y, x, -z)', '(-x+1/2, y+1/2, -z)',
                         '(x+1/2, -y+1/2, -z)', '(-y+1/2, -x+1/2, z)',
                         '(y+1/2, x+1/2, z)'), 'h00: h=2n')},
      '114': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)'), 'hkl: h+k+l=2n'),
              '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)'), 'hkl: h+k+l=2n'),
              '4c': (4, ('(0, 0, z)', '(0, 0, -z)', '(1/2, 1/2, -z+1/2)',
                         '(1/2, 1/2, z+1/2)'), 'hkl: h+k+l=2n'),
              '4d': (4, ('(0, 1/2, z)', '(1/2, 0, -z)', '(1/2, 0, -z+1/2)',
                         '(0, 1/2, z+1/2)'), 'hkl: l=2n, hk0: h+k=2n'),
              '8e': (7, ('(x, y, z)', '(-x, -y, z)', '(y, -x, -z)',
                         '(-y, x, -z)', '(-x+1/2, y+1/2, -z+1/2)',
                         '(x+1/2, -y+1/2, -z+1/2)', '(-y+1/2, -x+1/2, z+1/2)',
                         '(y+1/2, x+1/2, z+1/2)'),
                     'hhl: l=2n, 00l: l=2n, h00: h=2n')},
      '115': {'1a': (0, ('(0, 0, 0)', ), None),
              '1b': (0, ('(1/2, 1/2, 0)', ), None),
              '1c': (0, ('(1/2, 1/2, 1/2)', ), None),
              '1d': (0, ('(0, 0, 1/2)', ), None),
              '2e': (4, ('(0, 0, z)', '(0, 0, -z)'), None),
              '2f': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, -z)'), None),
              '2g': (4, ('(0, 1/2, z)', '(1/2, 0, -z)'), 'hk0: h+k=2n'),
              '4h': (1, ('(x, x, 0)', '(-x, -x, 0)', '(x, -x, 0)',
                         '(-x, x, 0)'), None),
              '4i': (1, ('(x, x, 1/2)', '(-x, -x, 1/2)', '(x, -x, 1/2)',
                         '(-x, x, 1/2)'), None),
              '4j': (5, ('(x, 0, z)', '(-x, 0, z)', '(0, -x, -z)',
                         '(0, x, -z)'), None),
              '4k': (5, ('(x, 1/2, z)', '(-x, 1/2, z)', '(1/2, -x, -z)',
                         '(1/2, x, -z)'), None),
              '8l': (7, ('(x, y, z)', '(-x, -y, z)', '(y, -x, -z)',
                         '(-y, x, -z)', '(x, -y, z)', '(-x, y, z)',
                         '(y, x, -z)', '(-y, -x, -z)'), None)},
      '116': {'2a': (0, ('(0, 0, 1/4)', '(0, 0, 3/4)'), 'hkl: l=2n'),
              '2b': (0, ('(1/2, 1/2, 1/4)', '(1/2, 1/2, 3/4)'), 'hkl: l=2n'),
              '2c': (0, ('(0, 0, 0)', '(0, 0, 1/2)'), 'hkl: l=2n'),
              '2d': (0, ('(1/2, 1/2, 0)', '(1/2, 1/2, 1/2)'), 'hkl: l=2n'),
              '4e': (1, ('(x, x, 1/4)', '(-x, -x, 1/4)', '(x, -x, 3/4)',
                         '(-x, x, 3/4)'), None),
              '4f': (1, ('(x, x, 3/4)', '(-x, -x, 3/4)', '(x, -x, 1/4)',
                         '(-x, x, 1/4)'), None),
              '4g': (4, ('(0, 0, z)', '(0, 0, -z)', '(0, 0, z+1/2)',
                         '(0, 0, -z+1/2)'), 'hkl: l=2n'),
              '4h': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, -z)',
                         '(1/2, 1/2, z+1/2)', '(1/2, 1/2, -z+1/2)'),
                     'hkl: l=2n'),
              '4i': (4, ('(0, 1/2, z)', '(1/2, 0, -z)', '(0, 1/2, z+1/2)',
                         '(1/2, 0, -z+1/2)'), 'hkl: l=2n, hk0: h+k=2n'),
              '8j': (7, ('(x, y, z)', '(-x, -y, z)', '(y, -x, -z)',
                         '(-y, x, -z)', '(x, -y, z+1/2)', '(-x, y, z+1/2)',
                         '(y, x, -z+1/2)', '(-y, -x, -z+1/2)'),
                     '0kl: l=2n, 00l: l=2n')},
      '117': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)'), 'hkl: h+k=2n'),
              '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)'), 'hkl: h+k=2n'),
              '2c': (0, ('(0, 1/2, 0)', '(1/2, 0, 0)'), 'hkl: h+k=2n'),
              '2d': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)'), 'hkl: h+k=2n'),
              '4e': (4, ('(0, 0, z)', '(0, 0, -z)', '(1/2, 1/2, z)',
                         '(1/2, 1/2, -z)'), 'hkl: h+k=2n'),
              '4f': (4, ('(0, 1/2, z)', '(1/2, 0, -z)', '(1/2, 0, z)',
                         '(0, 1/2, -z)'), 'hkl: h+k=2n'),
              '4g': (1, ('(x, x+1/2, 0)', '(-x, -x+1/2, 0)', '(x+1/2, -x, 0)',
                         '(-x+1/2, x, 0)'), None),
              '4h': (1, ('(x, x+1/2, 1/2)', '(-x, -x+1/2, 1/2)',
                         '(x+1/2, -x, 1/2)', '(-x+1/2, x, 1/2)'), None),
              '8i': (7, ('(x, y, z)', '(-x, -y, z)', '(y, -x, -z)',
                         '(-y, x, -z)', '(x+1/2, -y+1/2, z)',
                         '(-x+1/2, y+1/2, z)', '(y+1/2, x+1/2, -z)',
                         '(-y+1/2, -x+1/2, -z)'), '0kl: k=2n, h00: h=2n')},
      '118': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)'), 'hkl: h+k+l=2n'),
              '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)'), 'hkl: h+k+l=2n'),
              '2c': (0, ('(0, 1/2, 1/4)', '(1/2, 0, 3/4)'), 'hkl: h+k+l=2n'),
              '2d': (0, ('(0, 1/2, 3/4)', '(1/2, 0, 1/4)'), 'hkl: h+k+l=2n'),
              '4e': (4, ('(0, 0, z)', '(0, 0, -z)', '(1/2, 1/2, z+1/2)',
                         '(1/2, 1/2, -z+1/2)'), 'hkl: h+k+l=2n'),
              '4f': (1, ('(x, -x+1/2, 1/4)', '(-x, x+1/2, 1/4)',
                         '(-x+1/2, -x, 3/4)', '(x+1/2, x, 3/4)'), None),
              '4g': (1, ('(x, x+1/2, 1/4)', '(-x, -x+1/2, 1/4)',
                         '(x+1/2, -x, 3/4)', '(-x+1/2, x, 3/4)'), None),
              '4h': (4, ('(0, 1/2, z)', '(1/2, 0, -z)', '(1/2, 0, z+1/2)',
                         '(0, 1/2, -z+1/2)'), 'hkl: h+k+l=2n'),
              '8i': (7, ('(x, y, z)', '(-x, -y, z)', '(y, -x, -z)',
                         '(-y, x, -z)', '(x+1/2, -y+1/2, z+1/2)',
                         '(-x+1/2, y+1/2, z+1/2)', '(y+1/2, x+1/2, -z+1/2)',
                         '(-y+1/2, -x+1/2, -z+1/2)'),
                     '0kl: k+l=2n, 00l: l=2n, h00: h=2n')},
      '119': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)'), None),
              '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)'), None),
              '2c': (0, ('(0, 1/2, 1/4)', '(1/2, 0, 3/4)'), None),
              '2d': (0, ('(0, 1/2, 3/4)', '(1/2, 0, 1/4)'), None),
              '4e': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(0, 0, -z)',
                         '(1/2, 1/2, -z+1/2)'), None),
              '4f': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(1/2, 0, -z)',
                         '(0, 1/2, -z+1/2)'), None),
              '8g': (1, ('(x, x, 0)', '(x+1/2, x+1/2, 1/2)', '(-x, -x, 0)',
                         '(-x+1/2, -x+1/2, 1/2)', '(x, -x, 0)',
                         '(x+1/2, -x+1/2, 1/2)', '(-x, x, 0)',
                         '(-x+1/2, x+1/2, 1/2)'), None),
              '8h': (1, ('(x, x+1/2, 1/4)', '(x+1/2, x, 3/4)',
                         '(-x, -x+1/2, 1/4)', '(-x+1/2, -x, 3/4)',
                         '(x+1/2, -x, 3/4)', '(x, -x+1/2, 1/4)',
                         '(-x+1/2, x, 3/4)', '(-x, x+1/2, 1/4)'), None),
              '8i': (5, ('(x, 0, z)', '(x+1/2, 1/2, z+1/2)', '(-x, 0, z)',
                         '(-x+1/2, 1/2, z+1/2)', '(0, -x, -z)',
                         '(1/2, -x+1/2, -z+1/2)', '(0, x, -z)',
                         '(1/2, x+1/2, -z+1/2)'), None),
              '16j': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                          '(-x+1/2, -y+1/2, z+1/2)', '(y, -x, -z)',
                          '(y+1/2, -x+1/2, -z+1/2)', '(-y, x, -z)',
                          '(-y+1/2, x+1/2, -z+1/2)', '(x, -y, z)',
                          '(x+1/2, -y+1/2, z+1/2)', '(-x, y, z)',
                          '(-x+1/2, y+1/2, z+1/2)', '(y, x, -z)',
                          '(y+1/2, x+1/2, -z+1/2)', '(-y, -x, -z)',
                          '(-y+1/2, -x+1/2, -z+1/2)'),
                      'hkl: h+k+l=2n, hk0: h+k=2n, 0kl: k+l=2n, hhl: l=2n, '
                      '00l: l=2n, h00: h=2n')},
      '120': {'4a': (0, ('(0, 0, 1/4)', '(1/2, 1/2, 3/4)', '(0, 0, 3/4)',
                         '(1/2, 1/2, 1/4)'), 'hkl: l=2n'),
              '4b': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)', '(0, 0, 1/2)',
                         '(1/2, 1/2, 0)'), 'hkl: l=2n'),
              '4c': (0, ('(0, 1/2, 1/4)', '(1/2, 0, 3/4)', '(0, 1/2, 3/4)',
                         '(1/2, 0, 1/4)'), 'hkl: l=2n'),
              '4d': (0, ('(0, 1/2, 0)', '(1/2, 0, 1/2)', '(1/2, 0, 0)',
                         '(0, 1/2, 1/2)'), 'hkl: l=2n'),
              '8e': (1, ('(x, x, 1/4)', '(x+1/2, x+1/2, 3/4)',
                         '(-x, -x, 1/4)', '(-x+1/2, -x+1/2, 3/4)',
                         '(x, -x, 3/4)', '(x+1/2, -x+1/2, 1/4)',
                         '(-x, x, 3/4)', '(-x+1/2, x+1/2, 1/4)'), None),
              '8f': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(0, 0, -z)',
                         '(1/2, 1/2, -z+1/2)', '(0, 0, z+1/2)',
                         '(1/2, 1/2, z)', '(0, 0, -z+1/2)', '(1/2, 1/2, -z)'),
                     'hkl: l=2n'),
              '8g': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(1/2, 0, -z)',
                         '(0, 1/2, -z+1/2)', '(0, 1/2, z+1/2)', '(1/2, 0, z)',
                         '(1/2, 0, -z+1/2)', '(0, 1/2, -z)'), 'hkl: l=2n'),
              '8h': (1, ('(x, x+1/2, 0)', '(x+1/2, x, 1/2)',
                         '(-x, -x+1/2, 0)', '(-x+1/2, -x, 1/2)',
                         '(x+1/2, -x, 0)', '(x, -x+1/2, 1/2)',
                         '(-x+1/2, x, 0)', '(-x, x+1/2, 1/2)'), None),
              '16i': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                          '(-x+1/2, -y+1/2, z+1/2)', '(y, -x, -z)',
                          '(y+1/2, -x+1/2, -z+1/2)', '(-y, x, -z)',
                          '(-y+1/2, x+1/2, -z+1/2)', '(x, -y, z+1/2)',
                          '(x+1/2, -y+1/2, z)', '(-x, y, z+1/2)',
                          '(-x+1/2, y+1/2, z)', '(y, x, -z+1/2)',
                          '(y+1/2, x+1/2, -z)', '(-y, -x, -z+1/2)',
                          '(-y+1/2, -x+1/2, -z)'),
                      'hkl: h+k+l=2n, hk0: h+k=2n, 0kl: k,l=2n, hhl: l=2n, '
                      '00l: l=2n, h00: h=2n')},
      '121': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)'), None),
              '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)'), None),
              '4c': (0, ('(0, 1/2, 0)', '(1/2, 0, 1/2)', '(1/2, 0, 0)',
                         '(0, 1/2, 1/2)'), 'hkl: l=2n'),
              '4d': (0, ('(0, 1/2, 1/4)', '(1/2, 0, 3/4)', '(0, 1/2, 3/4)',
                         '(1/2, 0, 1/4)'), 'hkl: l=2n'),
              '4e': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(0, 0, -z)',
                         '(1/2, 1/2, -z+1/2)'), None),
              '8f': (1, ('(x, 0, 0)', '(x+1/2, 1/2, 1/2)', '(-x, 0, 0)',
                         '(-x+1/2, 1/2, 1/2)', '(0, -x, 0)',
                         '(1/2, -x+1/2, 1/2)', '(0, x, 0)',
                         '(1/2, x+1/2, 1/2)'), None),
              '8g': (1, ('(x, 0, 1/2)', '(x+1/2, 1/2, 0)', '(-x, 0, 1/2)',
                         '(-x+1/2, 1/2, 0)', '(0, -x, 1/2)',
                         '(1/2, -x+1/2, 0)', '(0, x, 1/2)', '(1/2, x+1/2, 0)'
                         ), None),
              '8h': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(1/2, 0, -z)',
                         '(0, 1/2, -z+1/2)', '(0, 1/2, -z)',
                         '(1/2, 0, -z+1/2)', '(1/2, 0, z)', '(0, 1/2, z+1/2)'
                         ), 'hkl: l=2n'),
              '8i': (5, ('(x, x, z)', '(x+1/2, x+1/2, z+1/2)', '(-x, -x, z)',
                         '(-x+1/2, -x+1/2, z+1/2)', '(x, -x, -z)',
                         '(x+1/2, -x+1/2, -z+1/2)', '(-x, x, -z)',
                         '(-x+1/2, x+1/2, -z+1/2)'), None),
              '16j': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                          '(-x+1/2, -y+1/2, z+1/2)', '(y, -x, -z)',
                          '(y+1/2, -x+1/2, -z+1/2)', '(-y, x, -z)',
                          '(-y+1/2, x+1/2, -z+1/2)', '(-x, y, -z)',
                          '(-x+1/2, y+1/2, -z+1/2)', '(x, -y, -z)',
                          '(x+1/2, -y+1/2, -z+1/2)', '(-y, -x, z)',
                          '(-y+1/2, -x+1/2, z+1/2)', '(y, x, z)',
                          '(y+1/2, x+1/2, z+1/2)'),
                      'hkl: h+k+l=2n, hk0: h+k=2n, 0kl: k+l=2n, hhl: l=2n, '
                      '00l: l=2n, h00: h=2n')},
      '122': {'4a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)', '(1/2, 0, 3/4)',
                         '(0, 1/2, 1/4)'), 'hkl: l=2n+1 or 2h+l=4n'),
              '4b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)', '(1/2, 0, 1/4)',
                         '(0, 1/2, 3/4)'), 'hkl: l=2n+1 or 2h+l=4n'),
              '8c': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(0, 0, -z)',
                         '(1/2, 1/2, -z+1/2)', '(1/2, 0, -z+3/4)',
                         '(0, 1/2, -z+1/4)', '(1/2, 0, z+3/4)',
                         '(0, 1/2, z+1/4)'), 'hkl: l=2n+1 or 2h+l=4n'),
              '8d': (1, ('(x, 1/4, 1/8)', '(x+1/2, 3/4, 5/8)',
                         '(-x, 3/4, 1/8)', '(-x+1/2, 1/4, 5/8)',
                         '(1/4, -x, 7/8)', '(3/4, -x+1/2, 3/8)',
                         '(3/4, x, 7/8)', '(1/4, x+1/2, 3/8)'), None),
              '16e': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                          '(-x+1/2, -y+1/2, z+1/2)', '(y, -x, -z)',
                          '(y+1/2, -x+1/2, -z+1/2)', '(-y, x, -z)',
                          '(-y+1/2, x+1/2, -z+1/2)', '(-x+1/2, y, -z+3/4)',
                          '(-x, y+1/2, -z+1/4)', '(x+1/2, -y, -z+3/4)',
                          '(x, -y+1/2, -z+1/4)', '(-y+1/2, -x, z+3/4)',
                          '(-y, -x+1/2, z+1/4)', '(y+1/2, x, z+3/4)',
                          '(y, x+1/2, z+1/4)'),
                      'hkl: h+k+l=2n, hk0: h+k=2n, 0kl: k+l=2n, hhl: 2h+l=4n, '
                      '00l: l=4n, h00: h=2n, h-h0: h=2n')},
      '123': {'1a': (0, ('(0, 0, 0)', ), None),
              '1b': (0, ('(0, 0, 1/2)', ), None),
              '1c': (0, ('(1/2, 1/2, 0)', ), None),
              '1d': (0, ('(1/2, 1/2, 1/2)', ), None),
              '2e': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)'), 'hkl: h+k=2n'),
              '2f': (0, ('(0, 1/2, 0)', '(1/2, 0, 0)'), 'hkl: h+k=2n'),
              '2g': (4, ('(0, 0, z)', '(0, 0, -z)'), None),
              '2h': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, -z)'), None),
              '4i': (4, ('(0, 1/2, z)', '(1/2, 0, z)', '(0, 1/2, -z)',
                         '(1/2, 0, -z)'), 'hkl: h+k=2n'),
              '4j': (1, ('(x, x, 0)', '(-x, -x, 0)', '(-x, x, 0)',
                         '(x, -x, 0)'), None),
              '4k': (1, ('(x, x, 1/2)', '(-x, -x, 1/2)', '(-x, x, 1/2)',
                         '(x, -x, 1/2)'), None),
              '4l': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(0, x, 0)', '(0, -x, 0)'
                         ), None),
              '4m': (1, ('(x, 0, 1/2)', '(-x, 0, 1/2)', '(0, x, 1/2)',
                         '(0, -x, 1/2)'), None),
              '4n': (1, ('(x, 1/2, 0)', '(-x, 1/2, 0)', '(1/2, x, 0)',
                         '(1/2, -x, 0)'), None),
              '4o': (1, ('(x, 1/2, 1/2)', '(-x, 1/2, 1/2)', '(1/2, x, 1/2)',
                         '(1/2, -x, 1/2)'), None),
              '8p': (3, ('(x, y, 0)', '(-x, -y, 0)', '(-y, x, 0)',
                         '(y, -x, 0)', '(-x, y, 0)', '(x, -y, 0)',
                         '(y, x, 0)', '(-y, -x, 0)'), None),
              '8q': (3, ('(x, y, 1/2)', '(-x, -y, 1/2)', '(-y, x, 1/2)',
                         '(y, -x, 1/2)', '(-x, y, 1/2)', '(x, -y, 1/2)',
                         '(y, x, 1/2)', '(-y, -x, 1/2)'), None),
              '8r': (5, ('(x, x, z)', '(-x, -x, z)', '(-x, x, z)',
                         '(x, -x, z)', '(-x, x, -z)', '(x, -x, -z)',
                         '(x, x, -z)', '(-x, -x, -z)'), None),
              '8s': (5, ('(x, 0, z)', '(-x, 0, z)', '(0, x, z)', '(0, -x, z)',
                         '(-x, 0, -z)', '(x, 0, -z)', '(0, x, -z)',
                         '(0, -x, -z)'), None),
              '8t': (5, ('(x, 1/2, z)', '(-x, 1/2, z)', '(1/2, x, z)',
                         '(1/2, -x, z)', '(-x, 1/2, -z)', '(x, 1/2, -z)',
                         '(1/2, x, -z)', '(1/2, -x, -z)'), None),
              '16u': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z)',
                          '(y, -x, z)', '(-x, y, -z)', '(x, -y, -z)',
                          '(y, x, -z)', '(-y, -x, -z)', '(-x, -y, -z)',
                          '(x, y, -z)', '(y, -x, -z)', '(-y, x, -z)',
                          '(x, -y, z)', '(-x, y, z)', '(-y, -x, z)',
                          '(y, x, z)'), None)},
      '124': {'2a': (0, ('(0, 0, 1/4)', '(0, 0, 3/4)'), 'hkl: l=2n'),
              '2b': (0, ('(0, 0, 0)', '(0, 0, 1/2)'), 'hkl: l=2n'),
              '2c': (0, ('(1/2, 1/2, 1/4)', '(1/2, 1/2, 3/4)'), 'hkl: l=2n'),
              '2d': (0, ('(1/2, 1/2, 0)', '(1/2, 1/2, 1/2)'), 'hkl: l=2n'),
              '4e': (0, ('(0, 1/2, 0)', '(1/2, 0, 0)', '(0, 1/2, 1/2)',
                         '(1/2, 0, 1/2)'), 'hkl: h+k,l=2n'),
              '4f': (0, ('(0, 1/2, 1/4)', '(1/2, 0, 1/4)', '(0, 1/2, 3/4)',
                         '(1/2, 0, 3/4)'), 'hkl: h+k,l=2n'),
              '4g': (4, ('(0, 0, z)', '(0, 0, -z+1/2)', '(0, 0, -z)',
                         '(0, 0, z+1/2)'), 'hkl: l=2n'),
              '4h': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, -z+1/2)',
                         '(1/2, 1/2, -z)', '(1/2, 1/2, z+1/2)'), 'hkl: l=2n'),
              '8i': (4, ('(0, 1/2, z)', '(1/2, 0, z)', '(0, 1/2, -z+1/2)',
                         '(1/2, 0, -z+1/2)', '(0, 1/2, -z)', '(1/2, 0, -z)',
                         '(0, 1/2, z+1/2)', '(1/2, 0, z+1/2)'), 'hkl: h+k,l=2n'
                     ),
              '8j': (1, ('(x, x, 1/4)', '(-x, -x, 1/4)', '(-x, x, 1/4)',
                         '(x, -x, 1/4)', '(-x, -x, 3/4)', '(x, x, 3/4)',
                         '(x, -x, 3/4)', '(-x, x, 3/4)'), 'hkl: l=2n'),
              '8k': (1, ('(x, 0, 1/4)', '(-x, 0, 1/4)', '(0, x, 1/4)',
                         '(0, -x, 1/4)', '(-x, 0, 3/4)', '(x, 0, 3/4)',
                         '(0, -x, 3/4)', '(0, x, 3/4)'), 'hkl: l=2n'),
              '8l': (1, ('(x, 1/2, 1/4)', '(-x, 1/2, 1/4)', '(1/2, x, 1/4)',
                         '(1/2, -x, 1/4)', '(-x, 1/2, 3/4)', '(x, 1/2, 3/4)',
                         '(1/2, -x, 3/4)', '(1/2, x, 3/4)'), 'hkl: l=2n'),
              '8m': (3, ('(x, y, 0)', '(-x, -y, 0)', '(-y, x, 0)',
                         '(y, -x, 0)', '(-x, y, 1/2)', '(x, -y, 1/2)',
                         '(y, x, 1/2)', '(-y, -x, 1/2)'), None),
              '16n': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z)',
                          '(y, -x, z)', '(-x, y, -z+1/2)', '(x, -y, -z+1/2)',
                          '(y, x, -z+1/2)', '(-y, -x, -z+1/2)',
                          '(-x, -y, -z)', '(x, y, -z)', '(y, -x, -z)',
                          '(-y, x, -z)', '(x, -y, z+1/2)', '(-x, y, z+1/2)',
                          '(-y, -x, z+1/2)', '(y, x, z+1/2)'),
                      '0kl: l=2n, hhl: l=2n, 00l: l=2n')},
      '125:1': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)'), 'hkl: h+k=2n'),
                '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)'), 'hkl: h+k=2n'),
                '2c': (0, ('(0, 1/2, 0)', '(1/2, 0, 0)'), 'hkl: h+k=2n'),
                '2d': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)'), 'hkl: h+k=2n'),
                '4e': (0, ('(1/4, 1/4, 0)', '(3/4, 3/4, 0)', '(3/4, 1/4, 0)',
                           '(1/4, 3/4, 0)'), 'hkl: h,k=2n'),
                '4f': (0, ('(1/4, 1/4, 1/2)', '(3/4, 3/4, 1/2)',
                           '(3/4, 1/4, 1/2)', '(1/4, 3/4, 1/2)'), 'hkl: h,k=2n'
                       ),
                '4g': (4, ('(0, 0, z)', '(0, 0, -z)', '(1/2, 1/2, -z)',
                           '(1/2, 1/2, z)'), 'hkl: h+k=2n'),
                '4h': (4, ('(0, 1/2, z)', '(1/2, 0, z)', '(0, 1/2, -z)',
                           '(1/2, 0, -z)'), 'hkl: h+k=2n'),
                '8i': (1, ('(x, x, 0)', '(-x, -x, 0)', '(-x, x, 0)',
                           '(x, -x, 0)', '(-x+1/2, -x+1/2, 0)',
                           '(x+1/2, x+1/2, 0)', '(x+1/2, -x+1/2, 0)',
                           '(-x+1/2, x+1/2, 0)'), 'hkl: h+k=2n'),
                '8j': (1, ('(x, x, 1/2)', '(-x, -x, 1/2)', '(-x, x, 1/2)',
                           '(x, -x, 1/2)', '(-x+1/2, -x+1/2, 1/2)',
                           '(x+1/2, x+1/2, 1/2)', '(x+1/2, -x+1/2, 1/2)',
                           '(-x+1/2, x+1/2, 1/2)'), 'hkl: h+k=2n'),
                '8k': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(0, x, 0)',
                           '(0, -x, 0)', '(-x+1/2, 1/2, 0)',
                           '(x+1/2, 1/2, 0)', '(1/2, -x+1/2, 0)',
                           '(1/2, x+1/2, 0)'), 'hkl: h+k=2n'),
                '8l': (1, ('(x, 0, 1/2)', '(-x, 0, 1/2)', '(0, x, 1/2)',
                           '(0, -x, 1/2)', '(-x+1/2, 1/2, 1/2)',
                           '(x+1/2, 1/2, 1/2)', '(1/2, -x+1/2, 1/2)',
                           '(1/2, x+1/2, 1/2)'), 'hkl: h+k=2n'),
                '8m': (5, ('(x, x+1/2, z)', '(-x, -x+1/2, z)',
                           '(-x+1/2, x, z)', '(x+1/2, -x, z)',
                           '(-x, x+1/2, -z)', '(x, -x+1/2, -z)',
                           '(x+1/2, x, -z)', '(-x+1/2, -x, -z)'), None),
                '16n': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z)',
                            '(y, -x, z)', '(-x, y, -z)', '(x, -y, -z)',
                            '(y, x, -z)', '(-y, -x, -z)',
                            '(-x+1/2, -y+1/2, -z)', '(x+1/2, y+1/2, -z)',
                            '(y+1/2, -x+1/2, -z)', '(-y+1/2, x+1/2, -z)',
                            '(x+1/2, -y+1/2, z)', '(-x+1/2, y+1/2, z)',
                            '(-y+1/2, -x+1/2, z)', '(y+1/2, x+1/2, z)'),
                        'hk0: h+k=2n, 0kl: k=2n, h00: h=2n')},
      '125:2': {'2a': (0, ('(1/4, 1/4, 0)', '(3/4, 3/4, 0)'), 'n/a'),
                '2b': (0, ('(1/4, 1/4, 1/2)', '(3/4, 3/4, 1/2)'), 'n/a'),
                '2c': (0, ('(3/4, 1/4, 0)', '(1/4, 3/4, 0)'), 'n/a'),
                '2d': (0, ('(3/4, 1/4, 1/2)', '(1/4, 3/4, 1/2)'), 'n/a'),
                '4e': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(1/2, 0, 0)',
                           '(0, 1/2, 0)'), 'n/a'),
                '4f': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)', '(1/2, 0, 1/2)',
                           '(0, 1/2, 1/2)'), 'n/a'),
                '4g': (4, ('(1/4, 1/4, z)', '(1/4, 1/4, -z)',
                           '(3/4, 3/4, -z)', '(3/4, 3/4, z)'), 'n/a'),
                '4h': (4, ('(3/4, 1/4, z)', '(1/4, 3/4, z)', '(3/4, 1/4, -z)',
                           '(1/4, 3/4, -z)'), 'n/a'),
                '8i': (1, ('(x, x, 0)', '(-x+1/2, -x+1/2, 0)',
                           '(-x+1/2, x, 0)', '(x, -x+1/2, 0)', '(-x, -x, 0)',
                           '(x+1/2, x+1/2, 0)', '(x+1/2, -x, 0)',
                           '(-x, x+1/2, 0)'), 'n/a'),
                '8j': (1, ('(x, x, 1/2)', '(-x+1/2, -x+1/2, 1/2)',
                           '(-x+1/2, x, 1/2)', '(x, -x+1/2, 1/2)',
                           '(-x, -x, 1/2)', '(x+1/2, x+1/2, 1/2)',
                           '(x+1/2, -x, 1/2)', '(-x, x+1/2, 1/2)'), 'n/a'),
                '8k': (1, ('(x, 1/4, 0)', '(-x+1/2, 1/4, 0)', '(1/4, x, 0)',
                           '(1/4, -x+1/2, 0)', '(-x, 3/4, 0)',
                           '(x+1/2, 3/4, 0)', '(3/4, -x, 0)',
                           '(3/4, x+1/2, 0)'), 'n/a'),
                '8l': (1, ('(x, 1/4, 1/2)', '(-x+1/2, 1/4, 1/2)',
                           '(1/4, x, 1/2)', '(1/4, -x+1/2, 1/2)',
                           '(-x, 3/4, 1/2)', '(x+1/2, 3/4, 1/2)',
                           '(3/4, -x, 1/2)', '(3/4, x+1/2, 1/2)'), 'n/a'),
                '8m': (5, ('(x, -x, z)', '(-x+1/2, x+1/2, z)',
                           '(x+1/2, x, z)', '(-x, -x+1/2, z)',
                           '(-x+1/2, -x, -z)', '(x, x+1/2, -z)',
                           '(-x, x, -z)', '(x+1/2, -x+1/2, -z)'), 'n/a'),
                '16n': (7, ('(x, y, z)', '(-x+1/2, -y+1/2, z)',
                            '(-y+1/2, x, z)', '(y, -x+1/2, z)',
                            '(-x+1/2, y, -z)', '(x, -y+1/2, -z)',
                            '(y, x, -z)', '(-y+1/2, -x+1/2, -z)',
                            '(-x, -y, -z)', '(x+1/2, y+1/2, -z)',
                            '(y+1/2, -x, -z)', '(-y, x+1/2, -z)',
                            '(x+1/2, -y, z)', '(-x, y+1/2, z)', '(-y, -x, z)',
                            '(y+1/2, x+1/2, z)'), 'n/a')},
      '126:1': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)'), 'hkl: h+k+l=2n'),
                '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)'), 'hkl: h+k+l=2n'),
                '4c': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(0, 1/2, 1/2)',
                           '(1/2, 0, 1/2)'), 'hkl: h+k,l=2n'),
                '4d': (0, ('(1/2, 0, 1/4)', '(0, 1/2, 1/4)', '(1/2, 0, 3/4)',
                           '(0, 1/2, 3/4)'), 'hkl: h+k,l=2n'),
                '4e': (4, ('(0, 0, z)', '(0, 0, -z)', '(1/2, 1/2, -z+1/2)',
                           '(1/2, 1/2, z+1/2)'), 'hkl: h+k+l=2n'),
                '8f': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 1/4)',
                           '(3/4, 1/4, 1/4)', '(1/4, 3/4, 1/4)',
                           '(3/4, 1/4, 3/4)', '(1/4, 3/4, 3/4)',
                           '(1/4, 1/4, 3/4)', '(3/4, 3/4, 3/4)'),
                       'hkl: h,k,l=2n'),
                '8g': (4, ('(1/2, 0, z)', '(0, 1/2, z)', '(1/2, 0, -z)',
                           '(0, 1/2, -z)', '(0, 1/2, -z+1/2)',
                           '(1/2, 0, -z+1/2)', '(0, 1/2, z+1/2)',
                           '(1/2, 0, z+1/2)'), 'hkl: h+k,l=2n'),
                '8h': (1, ('(x, x, 0)', '(-x, -x, 0)', '(-x, x, 0)',
                           '(x, -x, 0)', '(-x+1/2, -x+1/2, 1/2)',
                           '(x+1/2, x+1/2, 1/2)', '(x+1/2, -x+1/2, 1/2)',
                           '(-x+1/2, x+1/2, 1/2)'), 'hkl: h+k+l=2n'),
                '8i': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(0, x, 0)',
                           '(0, -x, 0)', '(-x+1/2, 1/2, 1/2)',
                           '(x+1/2, 1/2, 1/2)', '(1/2, -x+1/2, 1/2)',
                           '(1/2, x+1/2, 1/2)'), 'hkl: h+k+l=2n'),
                '8j': (1, ('(x, 0, 1/2)', '(-x, 0, 1/2)', '(0, x, 1/2)',
                           '(0, -x, 1/2)', '(-x+1/2, 1/2, 0)',
                           '(x+1/2, 1/2, 0)', '(1/2, -x+1/2, 0)',
                           '(1/2, x+1/2, 0)'), 'hkl: h+k+l=2n'),
                '16k': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z)',
                            '(y, -x, z)', '(-x, y, -z)', '(x, -y, -z)',
                            '(y, x, -z)', '(-y, -x, -z)',
                            '(-x+1/2, -y+1/2, -z+1/2)',
                            '(x+1/2, y+1/2, -z+1/2)',
                            '(y+1/2, -x+1/2, -z+1/2)',
                            '(-y+1/2, x+1/2, -z+1/2)',
                            '(x+1/2, -y+1/2, z+1/2)',
                            '(-x+1/2, y+1/2, z+1/2)',
                            '(-y+1/2, -x+1/2, z+1/2)',
                            '(y+1/2, x+1/2, z+1/2)'),
                        'hk0: h+k=2n, 0kl: k+l=2n, hhl: l=2n, 00l: l=2n, '
                        'h00: h=2n')},
      '126:2': {'2a': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)'), 'n/a'),
                '2b': (0, ('(1/4, 1/4, 3/4)', '(3/4, 3/4, 1/4)'), 'n/a'),
                '4c': (0, ('(1/4, 3/4, 3/4)', '(3/4, 1/4, 3/4)',
                           '(3/4, 1/4, 1/4)', '(1/4, 3/4, 1/4)'), 'n/a'),
                '4d': (0, ('(1/4, 3/4, 0)', '(3/4, 1/4, 0)',
                           '(1/4, 3/4, 1/2)', '(3/4, 1/4, 1/2)'), 'n/a'),
                '4e': (4, ('(1/4, 1/4, z)', '(1/4, 1/4, -z+1/2)',
                           '(3/4, 3/4, -z)', '(3/4, 3/4, z+1/2)'), 'n/a'),
                '8f': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(1/2, 0, 0)',
                           '(0, 1/2, 0)', '(1/2, 0, 1/2)', '(0, 1/2, 1/2)',
                           '(0, 0, 1/2)', '(1/2, 1/2, 1/2)'), 'n/a'),
                '8g': (4, ('(1/4, 3/4, z)', '(3/4, 1/4, z)',
                           '(1/4, 3/4, -z+1/2)', '(3/4, 1/4, -z+1/2)',
                           '(3/4, 1/4, -z)', '(1/4, 3/4, -z)',
                           '(3/4, 1/4, z+1/2)', '(1/4, 3/4, z+1/2)'), 'n/a'),
                '8h': (1, ('(x, x, 1/4)', '(-x+1/2, -x+1/2, 1/4)',
                           '(-x+1/2, x, 1/4)', '(x, -x+1/2, 1/4)',
                           '(-x, -x, 3/4)', '(x+1/2, x+1/2, 3/4)',
                           '(x+1/2, -x, 3/4)', '(-x, x+1/2, 3/4)'), 'n/a'),
                '8i': (1, ('(x, 1/4, 1/4)', '(-x+1/2, 1/4, 1/4)',
                           '(1/4, x, 1/4)', '(1/4, -x+1/2, 1/4)',
                           '(-x, 3/4, 3/4)', '(x+1/2, 3/4, 3/4)',
                           '(3/4, -x, 3/4)', '(3/4, x+1/2, 3/4)'), 'n/a'),
                '8j': (1, ('(x, 3/4, 1/4)', '(-x+1/2, 3/4, 1/4)',
                           '(3/4, x, 1/4)', '(3/4, -x+1/2, 1/4)',
                           '(-x, 1/4, 3/4)', '(x+1/2, 1/4, 3/4)',
                           '(1/4, -x, 3/4)', '(1/4, x+1/2, 3/4)'), 'n/a'),
                '16k': (7, ('(x, y, z)', '(-x+1/2, -y+1/2, z)',
                            '(-y+1/2, x, z)', '(y, -x+1/2, z)',
                            '(-x+1/2, y, -z+1/2)', '(x, -y+1/2, -z+1/2)',
                            '(y, x, -z+1/2)', '(-y+1/2, -x+1/2, -z+1/2)',
                            '(-x, -y, -z)', '(x+1/2, y+1/2, -z)',
                            '(y+1/2, -x, -z)', '(-y, x+1/2, -z)',
                            '(x+1/2, -y, z+1/2)', '(-x, y+1/2, z+1/2)',
                            '(-y, -x, z+1/2)', '(y+1/2, x+1/2, z+1/2)'), 'n/a'
                        )},
      '127': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)'), 'hkl: h+k=2n'),
              '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)'), 'hkl: h+k=2n'),
              '2c': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)'), 'hkl: h+k=2n'),
              '2d': (0, ('(0, 1/2, 0)', '(1/2, 0, 0)'), 'hkl: h+k=2n'),
              '4e': (4, ('(0, 0, z)', '(1/2, 1/2, -z)', '(0, 0, -z)',
                         '(1/2, 1/2, z)'), 'hkl: h+k=2n'),
              '4f': (4, ('(0, 1/2, z)', '(1/2, 0, z)', '(1/2, 0, -z)',
                         '(0, 1/2, -z)'), 'hkl: h+k=2n'),
              '4g': (1, ('(x, x+1/2, 0)', '(-x, -x+1/2, 0)', '(-x+1/2, x, 0)',
                         '(x+1/2, -x, 0)'), None),
              '4h': (1, ('(x, x+1/2, 1/2)', '(-x, -x+1/2, 1/2)',
                         '(-x+1/2, x, 1/2)', '(x+1/2, -x, 1/2)'), None),
              '8i': (3, ('(x, y, 0)', '(-x, -y, 0)', '(-y, x, 0)',
                         '(y, -x, 0)', '(-x+1/2, y+1/2, 0)',
                         '(x+1/2, -y+1/2, 0)', '(y+1/2, x+1/2, 0)',
                         '(-y+1/2, -x+1/2, 0)'), None),
              '8j': (3, ('(x, y, 1/2)', '(-x, -y, 1/2)', '(-y, x, 1/2)',
                         '(y, -x, 1/2)', '(-x+1/2, y+1/2, 1/2)',
                         '(x+1/2, -y+1/2, 1/2)', '(y+1/2, x+1/2, 1/2)',
                         '(-y+1/2, -x+1/2, 1/2)'), None),
              '8k': (5, ('(x, x+1/2, z)', '(-x, -x+1/2, z)', '(-x+1/2, x, z)',
                         '(x+1/2, -x, z)', '(-x+1/2, x, -z)',
                         '(x+1/2, -x, -z)', '(x, x+1/2, -z)',
                         '(-x, -x+1/2, -z)'), None),
              '16l': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z)',
                          '(y, -x, z)', '(-x+1/2, y+1/2, -z)',
                          '(x+1/2, -y+1/2, -z)', '(y+1/2, x+1/2, -z)',
                          '(-y+1/2, -x+1/2, -z)', '(-x, -y, -z)',
                          '(x, y, -z)', '(y, -x, -z)', '(-y, x, -z)',
                          '(x+1/2, -y+1/2, z)', '(-x+1/2, y+1/2, z)',
                          '(-y+1/2, -x+1/2, z)', '(y+1/2, x+1/2, z)'),
                      '0kl: k=2n, h00: h=2n')},
      '128': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)'), 'hkl: h+k+l=2n'),
              '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)'), 'hkl: h+k+l=2n'),
              '4c': (0, ('(0, 1/2, 0)', '(1/2, 0, 0)', '(1/2, 0, 1/2)',
                         '(0, 1/2, 1/2)'), 'hkl: h+k,l=2n'),
              '4d': (0, ('(0, 1/2, 1/4)', '(1/2, 0, 1/4)', '(0, 1/2, 3/4)',
                         '(1/2, 0, 3/4)'), 'hkl: h+k,l=2n'),
              '4e': (4, ('(0, 0, z)', '(1/2, 1/2, -z+1/2)', '(0, 0, -z)',
                         '(1/2, 1/2, z+1/2)'), 'hkl: h+k+l=2n'),
              '8f': (4, ('(0, 1/2, z)', '(1/2, 0, z)', '(1/2, 0, -z+1/2)',
                         '(0, 1/2, -z+1/2)', '(0, 1/2, -z)', '(1/2, 0, -z)',
                         '(1/2, 0, z+1/2)', '(0, 1/2, z+1/2)'), 'hkl: h+k,l=2n'
                     ),
              '8g': (1, ('(x, x+1/2, 1/4)', '(-x, -x+1/2, 1/4)',
                         '(-x+1/2, x, 1/4)', '(x+1/2, -x, 1/4)',
                         '(-x, -x+1/2, 3/4)', '(x, x+1/2, 3/4)',
                         '(x+1/2, -x, 3/4)', '(-x+1/2, x, 3/4)'), 'hkl: l=2n'
                     ),
              '8h': (3, ('(x, y, 0)', '(-x, -y, 0)', '(-y, x, 0)',
                         '(y, -x, 0)', '(-x+1/2, y+1/2, 1/2)',
                         '(x+1/2, -y+1/2, 1/2)', '(y+1/2, x+1/2, 1/2)',
                         '(-y+1/2, -x+1/2, 1/2)'), None),
              '16i': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z)',
                          '(y, -x, z)', '(-x+1/2, y+1/2, -z+1/2)',
                          '(x+1/2, -y+1/2, -z+1/2)', '(y+1/2, x+1/2, -z+1/2)',
                          '(-y+1/2, -x+1/2, -z+1/2)', '(-x, -y, -z)',
                          '(x, y, -z)', '(y, -x, -z)', '(-y, x, -z)',
                          '(x+1/2, -y+1/2, z+1/2)', '(-x+1/2, y+1/2, z+1/2)',
                          '(-y+1/2, -x+1/2, z+1/2)', '(y+1/2, x+1/2, z+1/2)'),
                      '0kl: k+l=2n, hhl: l=2n, 00l: l=2n, h00: h=2n')},
      '129:1': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)'), 'hkl: h+k=2n'),
                '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)'), 'hkl: h+k=2n'),
                '2c': (4, ('(0, 1/2, z)', '(1/2, 0, -z)'), None),
                '4d': (0, ('(1/4, 1/4, 0)', '(3/4, 3/4, 0)', '(1/4, 3/4, 0)',
                           '(3/4, 1/4, 0)'), 'hkl: h,k=2n'),
                '4e': (0, ('(1/4, 1/4, 1/2)', '(3/4, 3/4, 1/2)',
                           '(1/4, 3/4, 1/2)', '(3/4, 1/4, 1/2)'), 'hkl: h,k=2n'
                       ),
                '4f': (4, ('(0, 0, z)', '(1/2, 1/2, z)', '(1/2, 1/2, -z)',
                           '(0, 0, -z)'), 'hkl: h+k=2n'),
                '8g': (1, ('(x, x, 0)', '(-x, -x, 0)', '(-x+1/2, x+1/2, 0)',
                           '(x+1/2, -x+1/2, 0)', '(-x+1/2, -x+1/2, 0)',
                           '(x+1/2, x+1/2, 0)', '(x, -x, 0)', '(-x, x, 0)'),
                       'hkl: h+k=2n'),
                '8h': (1, ('(x, x, 1/2)', '(-x, -x, 1/2)',
                           '(-x+1/2, x+1/2, 1/2)', '(x+1/2, -x+1/2, 1/2)',
                           '(-x+1/2, -x+1/2, 1/2)', '(x+1/2, x+1/2, 1/2)',
                           '(x, -x, 1/2)', '(-x, x, 1/2)'), 'hkl: h+k=2n'),
                '8i': (6, ('(0, y, z)', '(0, -y, z)', '(-y+1/2, 1/2, z)',
                           '(y+1/2, 1/2, z)', '(1/2, y+1/2, -z)',
                           '(1/2, -y+1/2, -z)', '(y, 0, -z)', '(-y, 0, -z)'),
                       None),
                '8j': (5, ('(x, x+1/2, z)', '(-x, -x+1/2, z)',
                           '(-x, x+1/2, z)', '(x, -x+1/2, z)',
                           '(-x+1/2, x, -z)', '(x+1/2, -x, -z)',
                           '(x+1/2, x, -z)', '(-x+1/2, -x, -z)'), None),
                '16k': (7, ('(x, y, z)', '(-x, -y, z)', '(-y+1/2, x+1/2, z)',
                            '(y+1/2, -x+1/2, z)', '(-x+1/2, y+1/2, -z)',
                            '(x+1/2, -y+1/2, -z)', '(y, x, -z)',
                            '(-y, -x, -z)', '(-x+1/2, -y+1/2, -z)',
                            '(x+1/2, y+1/2, -z)', '(y, -x, -z)',
                            '(-y, x, -z)', '(x, -y, z)', '(-x, y, z)',
                            '(-y+1/2, -x+1/2, z)', '(y+1/2, x+1/2, z)'),
                        'hk0: h+k=2n, h00: h=2n')},
      '129:2': {'2a': (0, ('(3/4, 1/4, 0)', '(1/4, 3/4, 0)'), 'n/a'),
                '2b': (0, ('(3/4, 1/4, 1/2)', '(1/4, 3/4, 1/2)'), 'n/a'),
                '2c': (4, ('(1/4, 1/4, z)', '(3/4, 3/4, -z)'), 'n/a'),
                '4d': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(1/2, 0, 0)',
                           '(0, 1/2, 0)'), 'n/a'),
                '4e': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)', '(1/2, 0, 1/2)',
                           '(0, 1/2, 1/2)'), 'n/a'),
                '4f': (4, ('(3/4, 1/4, z)', '(1/4, 3/4, z)', '(1/4, 3/4, -z)',
                           '(3/4, 1/4, -z)'), 'n/a'),
                '8g': (1, ('(x, -x, 0)', '(-x+1/2, x+1/2, 0)',
                           '(x+1/2, x, 0)', '(-x, -x+1/2, 0)', '(-x, x, 0)',
                           '(x+1/2, -x+1/2, 0)', '(-x+1/2, -x, 0)',
                           '(x, x+1/2, 0)'), 'n/a'),
                '8h': (1, ('(x, -x, 1/2)', '(-x+1/2, x+1/2, 1/2)',
                           '(x+1/2, x, 1/2)', '(-x, -x+1/2, 1/2)',
                           '(-x, x, 1/2)', '(x+1/2, -x+1/2, 1/2)',
                           '(-x+1/2, -x, 1/2)', '(x, x+1/2, 1/2)'), 'n/a'),
                '8i': (6, ('(1/4, y, z)', '(1/4, -y+1/2, z)',
                           '(-y+1/2, 1/4, z)', '(y, 1/4, z)',
                           '(3/4, y+1/2, -z)', '(3/4, -y, -z)',
                           '(y+1/2, 3/4, -z)', '(-y, 3/4, -z)'), 'n/a'),
                '8j': (5, ('(x, x, z)', '(-x+1/2, -x+1/2, z)',
                           '(-x+1/2, x, z)', '(x, -x+1/2, z)',
                           '(-x, x+1/2, -z)', '(x+1/2, -x, -z)',
                           '(x+1/2, x+1/2, -z)', '(-x, -x, -z)'), 'n/a'),
                '16k': (7, ('(x, y, z)', '(-x+1/2, -y+1/2, z)',
                            '(-y+1/2, x, z)', '(y, -x+1/2, z)',
                            '(-x, y+1/2, -z)', '(x+1/2, -y, -z)',
                            '(y+1/2, x+1/2, -z)', '(-y, -x, -z)',
                            '(-x, -y, -z)', '(x+1/2, y+1/2, -z)',
                            '(y+1/2, -x, -z)', '(-y, x+1/2, -z)',
                            '(x, -y+1/2, z)', '(-x+1/2, y, z)',
                            '(-y+1/2, -x+1/2, z)', '(y, x, z)'), 'n/a')},
      '130:1': {'4a': (0, ('(0, 0, 1/4)', '(1/2, 1/2, 1/4)',
                           '(1/2, 1/2, 3/4)', '(0, 0, 3/4)'), 'hkl: h+k,l=2n'
                       ),
                '4b': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(1/2, 1/2, 1/2)',
                           '(0, 0, 1/2)'), 'hkl: h+k,l=2n'),
                '4c': (4, ('(0, 1/2, z)', '(1/2, 0, -z+1/2)', '(1/2, 0, -z)',
                           '(0, 1/2, z+1/2)'), 'hkl: l=2n'),
                '8d': (0, ('(1/4, 1/4, 0)', '(3/4, 3/4, 0)', '(1/4, 3/4, 0)',
                           '(3/4, 1/4, 0)', '(1/4, 3/4, 1/2)',
                           '(3/4, 1/4, 1/2)', '(1/4, 1/4, 1/2)',
                           '(3/4, 3/4, 1/2)'), 'hkl: h,k,l=2n'),
                '8e': (4, ('(0, 0, z)', '(1/2, 1/2, z)', '(1/2, 1/2, -z+1/2)',
                           '(0, 0, -z+1/2)', '(1/2, 1/2, -z)', '(0, 0, -z)',
                           '(0, 0, z+1/2)', '(1/2, 1/2, z+1/2)'),
                       'hkl: h+k,l=2n'),
                '8f': (1, ('(x, x, 1/4)', '(-x, -x, 1/4)',
                           '(-x+1/2, x+1/2, 1/4)', '(x+1/2, -x+1/2, 1/4)',
                           '(-x+1/2, -x+1/2, 3/4)', '(x+1/2, x+1/2, 3/4)',
                           '(x, -x, 3/4)', '(-x, x, 3/4)'), 'hkl: h+k+l=2n'),
                '16g': (7, ('(x, y, z)', '(-x, -y, z)', '(-y+1/2, x+1/2, z)',
                            '(y+1/2, -x+1/2, z)', '(-x+1/2, y+1/2, -z+1/2)',
                            '(x+1/2, -y+1/2, -z+1/2)', '(y, x, -z+1/2)',
                            '(-y, -x, -z+1/2)', '(-x+1/2, -y+1/2, -z)',
                            '(x+1/2, y+1/2, -z)', '(y, -x, -z)',
                            '(-y, x, -z)', '(x, -y, z+1/2)', '(-x, y, z+1/2)',
                            '(-y+1/2, -x+1/2, z+1/2)',
                            '(y+1/2, x+1/2, z+1/2)'),
                        'hk0: h+k=2n, 0kl: l=2n, hhl: l=2n, 00l: l=2n, '
                        'h00: h=2n')},
      '130:2': {'4a': (0, ('(3/4, 1/4, 1/4)', '(1/4, 3/4, 1/4)',
                           '(1/4, 3/4, 3/4)', '(3/4, 1/4, 3/4)'), 'n/a'),
                '4b': (0, ('(3/4, 1/4, 0)', '(1/4, 3/4, 0)',
                           '(1/4, 3/4, 1/2)', '(3/4, 1/4, 1/2)'), 'n/a'),
                '4c': (4, ('(1/4, 1/4, z)', '(3/4, 3/4, -z+1/2)',
                           '(3/4, 3/4, -z)', '(1/4, 1/4, z+1/2)'), 'n/a'),
                '8d': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(1/2, 0, 0)',
                           '(0, 1/2, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                           '(1/2, 1/2, 1/2)', '(0, 0, 1/2)'), 'n/a'),
                '8e': (4, ('(3/4, 1/4, z)', '(1/4, 3/4, z)',
                           '(1/4, 3/4, -z+1/2)', '(3/4, 1/4, -z+1/2)',
                           '(1/4, 3/4, -z)', '(3/4, 1/4, -z)',
                           '(3/4, 1/4, z+1/2)', '(1/4, 3/4, z+1/2)'), 'n/a'),
                '8f': (1, ('(x, -x, 1/4)', '(-x+1/2, x+1/2, 1/4)',
                           '(x+1/2, x, 1/4)', '(-x, -x+1/2, 1/4)',
                           '(-x, x, 3/4)', '(x+1/2, -x+1/2, 3/4)',
                           '(-x+1/2, -x, 3/4)', '(x, x+1/2, 3/4)'), 'n/a'),
                '16g': (7, ('(x, y, z)', '(-x+1/2, -y+1/2, z)',
                            '(-y+1/2, x, z)', '(y, -x+1/2, z)',
                            '(-x, y+1/2, -z+1/2)', '(x+1/2, -y, -z+1/2)',
                            '(y+1/2, x+1/2, -z+1/2)', '(-y, -x, -z+1/2)',
                            '(-x, -y, -z)', '(x+1/2, y+1/2, -z)',
                            '(y+1/2, -x, -z)', '(-y, x+1/2, -z)',
                            '(x, -y+1/2, z+1/2)', '(-x+1/2, y, z+1/2)',
                            '(-y+1/2, -x+1/2, z+1/2)', '(y, x, z+1/2)'), 'n/a'
                        )},
      '131': {'2a': (0, ('(0, 0, 0)', '(0, 0, 1/2)'), 'hkl: l=2n'),
              '2b': (0, ('(1/2, 1/2, 0)', '(1/2, 1/2, 1/2)'), 'hkl: l=2n'),
              '2c': (0, ('(0, 1/2, 0)', '(1/2, 0, 1/2)'), 'hkl: h+k+l=2n'),
              '2d': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 0)'), 'hkl: h+k+l=2n'),
              '2e': (0, ('(0, 0, 1/4)', '(0, 0, 3/4)'), 'hkl: l=2n'),
              '2f': (0, ('(1/2, 1/2, 1/4)', '(1/2, 1/2, 3/4)'), 'hkl: l=2n'),
              '4g': (4, ('(0, 0, z)', '(0, 0, z+1/2)', '(0, 0, -z)',
                         '(0, 0, -z+1/2)'), 'hkl: l=2n'),
              '4h': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, z+1/2)',
                         '(1/2, 1/2, -z)', '(1/2, 1/2, -z+1/2)'), 'hkl: l=2n'
                     ),
              '4i': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(0, 1/2, -z)',
                         '(1/2, 0, -z+1/2)'), 'hkl: h+k+l=2n'),
              '4j': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(0, x, 1/2)',
                         '(0, -x, 1/2)'), None),
              '4k': (1, ('(x, 1/2, 1/2)', '(-x, 1/2, 1/2)', '(1/2, x, 0)',
                         '(1/2, -x, 0)'), None),
              '4l': (1, ('(x, 0, 1/2)', '(-x, 0, 1/2)', '(0, x, 0)',
                         '(0, -x, 0)'), None),
              '4m': (1, ('(x, 1/2, 0)', '(-x, 1/2, 0)', '(1/2, x, 1/2)',
                         '(1/2, -x, 1/2)'), None),
              '8n': (1, ('(x, x, 1/4)', '(-x, -x, 1/4)', '(-x, x, 3/4)',
                         '(x, -x, 3/4)', '(-x, -x, 3/4)', '(x, x, 3/4)',
                         '(x, -x, 1/4)', '(-x, x, 1/4)'), 'hkl: l=2n'),
              '8o': (6, ('(0, y, z)', '(0, -y, z)', '(-y, 0, z+1/2)',
                         '(y, 0, z+1/2)', '(0, y, -z)', '(0, -y, -z)',
                         '(y, 0, -z+1/2)', '(-y, 0, -z+1/2)'), None),
              '8p': (6, ('(1/2, y, z)', '(1/2, -y, z)', '(-y, 1/2, z+1/2)',
                         '(y, 1/2, z+1/2)', '(1/2, y, -z)', '(1/2, -y, -z)',
                         '(y, 1/2, -z+1/2)', '(-y, 1/2, -z+1/2)'), None),
              '8q': (3, ('(x, y, 0)', '(-x, -y, 0)', '(-y, x, 1/2)',
                         '(y, -x, 1/2)', '(-x, y, 0)', '(x, -y, 0)',
                         '(y, x, 1/2)', '(-y, -x, 1/2)'), None),
              '16r': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z+1/2)',
                          '(y, -x, z+1/2)', '(-x, y, -z)', '(x, -y, -z)',
                          '(y, x, -z+1/2)', '(-y, -x, -z+1/2)',
                          '(-x, -y, -z)', '(x, y, -z)', '(y, -x, -z+1/2)',
                          '(-y, x, -z+1/2)', '(x, -y, z)', '(-x, y, z)',
                          '(-y, -x, z+1/2)', '(y, x, z+1/2)'),
                      'hhl: l=2n, 00l: l=2n')},
      '132': {'2a': (0, ('(0, 0, 0)', '(0, 0, 1/2)'), 'hkl: l=2n'),
              '2b': (0, ('(0, 0, 1/4)', '(0, 0, 3/4)'), 'hkl: l=2n'),
              '2c': (0, ('(1/2, 1/2, 0)', '(1/2, 1/2, 1/2)'), 'hkl: l=2n'),
              '2d': (0, ('(1/2, 1/2, 1/4)', '(1/2, 1/2, 3/4)'), 'hkl: l=2n'),
              '4e': (0, ('(0, 1/2, 1/4)', '(1/2, 0, 3/4)', '(0, 1/2, 3/4)',
                         '(1/2, 0, 1/4)'), 'hkl: h+k,l=2n'),
              '4f': (0, ('(0, 1/2, 0)', '(1/2, 0, 1/2)', '(0, 1/2, 1/2)',
                         '(1/2, 0, 0)'), 'hkl: h+k,l=2n'),
              '4g': (4, ('(0, 0, z)', '(0, 0, z+1/2)', '(0, 0, -z+1/2)',
                         '(0, 0, -z)'), 'hkl: l=2n'),
              '4h': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, z+1/2)',
                         '(1/2, 1/2, -z+1/2)', '(1/2, 1/2, -z)'), 'hkl: l=2n'
                     ),
              '4i': (1, ('(x, x, 0)', '(-x, -x, 0)', '(-x, x, 1/2)',
                         '(x, -x, 1/2)'), None),
              '4j': (1, ('(x, x, 1/2)', '(-x, -x, 1/2)', '(-x, x, 0)',
                         '(x, -x, 0)'), None),
              '8k': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(0, 1/2, -z+1/2)',
                         '(1/2, 0, -z)', '(0, 1/2, -z)', '(1/2, 0, -z+1/2)',
                         '(0, 1/2, z+1/2)', '(1/2, 0, z)'), 'hkl: h+k,l=2n'),
              '8l': (1, ('(x, 0, 1/4)', '(-x, 0, 1/4)', '(0, x, 3/4)',
                         '(0, -x, 3/4)', '(-x, 0, 3/4)', '(x, 0, 3/4)',
                         '(0, -x, 1/4)', '(0, x, 1/4)'), 'hkl: l=2n'),
              '8m': (1, ('(x, 1/2, 1/4)', '(-x, 1/2, 1/4)', '(1/2, x, 3/4)',
                         '(1/2, -x, 3/4)', '(-x, 1/2, 3/4)', '(x, 1/2, 3/4)',
                         '(1/2, -x, 1/4)', '(1/2, x, 1/4)'), 'hkl: l=2n'),
              '8n': (3, ('(x, y, 0)', '(-x, -y, 0)', '(-y, x, 1/2)',
                         '(y, -x, 1/2)', '(-x, y, 1/2)', '(x, -y, 1/2)',
                         '(y, x, 0)', '(-y, -x, 0)'), None),
              '8o': (5, ('(x, x, z)', '(-x, -x, z)', '(-x, x, z+1/2)',
                         '(x, -x, z+1/2)', '(-x, x, -z+1/2)',
                         '(x, -x, -z+1/2)', '(x, x, -z)', '(-x, -x, -z)'), None
                     ),
              '16p': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z+1/2)',
                          '(y, -x, z+1/2)', '(-x, y, -z+1/2)',
                          '(x, -y, -z+1/2)', '(y, x, -z)', '(-y, -x, -z)',
                          '(-x, -y, -z)', '(x, y, -z)', '(y, -x, -z+1/2)',
                          '(-y, x, -z+1/2)', '(x, -y, z+1/2)',
                          '(-x, y, z+1/2)', '(-y, -x, z)', '(y, x, z)'),
                      '0kl: l=2n, 00l: l=2n')},
      '133:1': {'4a': (0, ('(0, 1/2, 1/4)', '(0, 1/2, 3/4)', '(1/2, 0, 1/4)',
                           '(1/2, 0, 3/4)'), 'hkl: h+k,l=2n'),
                '4b': (0, ('(0, 0, 1/4)', '(1/2, 1/2, 3/4)',
                           '(1/2, 1/2, 1/4)', '(0, 0, 3/4)'), 'hkl: h+k,l=2n'
                       ),
                '4c': (0, ('(0, 1/2, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                           '(1/2, 0, 0)'), 'hkl: h+k,l=2n'),
                '4d': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)', '(0, 0, 1/2)',
                           '(1/2, 1/2, 0)'), 'hkl: h+k,l=2n'),
                '8e': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 1/4)',
                           '(1/4, 3/4, 3/4)', '(3/4, 1/4, 3/4)',
                           '(3/4, 1/4, 1/4)', '(1/4, 3/4, 1/4)',
                           '(3/4, 3/4, 3/4)', '(1/4, 1/4, 3/4)'),
                       'hkl: h,k,l=2n'),
                '8f': (4, ('(0, 1/2, z)', '(0, 1/2, z+1/2)',
                           '(0, 1/2, -z+1/2)', '(0, 1/2, -z)',
                           '(1/2, 0, -z+1/2)', '(1/2, 0, -z)', '(1/2, 0, z)',
                           '(1/2, 0, z+1/2)'), 'hkl: h+k,l=2n'),
                '8g': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(0, 0, -z+1/2)',
                           '(1/2, 1/2, -z)', '(1/2, 1/2, -z+1/2)',
                           '(0, 0, -z)', '(1/2, 1/2, z)', '(0, 0, z+1/2)'),
                       'hkl: h+k,l=2n'),
                '8h': (1, ('(x, 0, 1/4)', '(-x, 0, 1/4)', '(1/2, x+1/2, 3/4)',
                           '(1/2, -x+1/2, 3/4)', '(-x+1/2, 1/2, 1/4)',
                           '(x+1/2, 1/2, 1/4)', '(0, -x, 3/4)', '(0, x, 3/4)'
                           ), 'hkl: h+k=2n'),
                '8i': (1, ('(x, 0, 3/4)', '(-x, 0, 3/4)', '(1/2, x+1/2, 1/4)',
                           '(1/2, -x+1/2, 1/4)', '(-x+1/2, 1/2, 3/4)',
                           '(x+1/2, 1/2, 3/4)', '(0, -x, 1/4)', '(0, x, 1/4)'
                           ), 'hkl: h+k=2n'),
                '8j': (1, ('(x, x+1/2, 0)', '(-x, -x+1/2, 0)',
                           '(-x, x+1/2, 1/2)', '(x, -x+1/2, 1/2)',
                           '(-x+1/2, -x, 1/2)', '(x+1/2, x, 1/2)',
                           '(x+1/2, -x, 0)', '(-x+1/2, x, 0)'), 'hkl: h+k+l=2n'
                       ),
                '16k': (7, ('(x, y, z)', '(-x, -y, z)',
                            '(-y+1/2, x+1/2, z+1/2)',
                            '(y+1/2, -x+1/2, z+1/2)', '(-x, y, -z+1/2)',
                            '(x, -y, -z+1/2)', '(y+1/2, x+1/2, -z)',
                            '(-y+1/2, -x+1/2, -z)',
                            '(-x+1/2, -y+1/2, -z+1/2)',
                            '(x+1/2, y+1/2, -z+1/2)', '(y, -x, -z)',
                            '(-y, x, -z)', '(x+1/2, -y+1/2, z)',
                            '(-x+1/2, y+1/2, z)', '(-y, -x, z+1/2)',
                            '(y, x, z+1/2)'),
                        'hk0: h+k=2n, 0kl: k=2n, hhl: l=2n, 00l: l=2n, '
                        'h00: h=2n')},
      '133:2': {'4a': (0, ('(1/4, 1/4, 0)', '(1/4, 1/4, 1/2)',
                           '(3/4, 3/4, 0)', '(3/4, 3/4, 1/2)'), 'n/a'),
                '4b': (0, ('(3/4, 1/4, 0)', '(1/4, 3/4, 1/2)',
                           '(1/4, 3/4, 0)', '(3/4, 1/4, 1/2)'), 'n/a'),
                '4c': (0, ('(1/4, 1/4, 1/4)', '(1/4, 1/4, 3/4)',
                           '(3/4, 3/4, 3/4)', '(3/4, 3/4, 1/4)'), 'n/a'),
                '4d': (0, ('(3/4, 1/4, 3/4)', '(1/4, 3/4, 1/4)',
                           '(3/4, 1/4, 1/4)', '(1/4, 3/4, 3/4)'), 'n/a'),
                '8e': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(1/2, 0, 1/2)',
                           '(0, 1/2, 1/2)', '(1/2, 0, 0)', '(0, 1/2, 0)',
                           '(0, 0, 1/2)', '(1/2, 1/2, 1/2)'), 'n/a'),
                '8f': (4, ('(1/4, 1/4, z)', '(1/4, 1/4, z+1/2)',
                           '(1/4, 1/4, -z)', '(1/4, 1/4, -z+1/2)',
                           '(3/4, 3/4, -z)', '(3/4, 3/4, -z+1/2)',
                           '(3/4, 3/4, z)', '(3/4, 3/4, z+1/2)'), 'n/a'),
                '8g': (4, ('(3/4, 1/4, z)', '(1/4, 3/4, z+1/2)',
                           '(3/4, 1/4, -z)', '(1/4, 3/4, -z+1/2)',
                           '(1/4, 3/4, -z)', '(3/4, 1/4, -z+1/2)',
                           '(1/4, 3/4, z)', '(3/4, 1/4, z+1/2)'), 'n/a'),
                '8h': (1, ('(x, 1/4, 0)', '(-x+1/2, 1/4, 0)', '(1/4, x, 1/2)',
                           '(1/4, -x+1/2, 1/2)', '(-x, 3/4, 0)',
                           '(x+1/2, 3/4, 0)', '(3/4, -x, 1/2)',
                           '(3/4, x+1/2, 1/2)'), 'n/a'),
                '8i': (1, ('(x, 1/4, 1/2)', '(-x+1/2, 1/4, 1/2)',
                           '(1/4, x, 0)', '(1/4, -x+1/2, 0)',
                           '(-x, 3/4, 1/2)', '(x+1/2, 3/4, 1/2)',
                           '(3/4, -x, 0)', '(3/4, x+1/2, 0)'), 'n/a'),
                '8j': (1, ('(x, x, 1/4)', '(-x+1/2, -x+1/2, 1/4)',
                           '(-x+1/2, x, 3/4)', '(x, -x+1/2, 3/4)',
                           '(-x, -x, 3/4)', '(x+1/2, x+1/2, 3/4)',
                           '(x+1/2, -x, 1/4)', '(-x, x+1/2, 1/4)'), 'n/a'),
                '16k': (7, ('(x, y, z)', '(-x+1/2, -y+1/2, z)',
                            '(-y+1/2, x, z+1/2)', '(y, -x+1/2, z+1/2)',
                            '(-x+1/2, y, -z)', '(x, -y+1/2, -z)',
                            '(y, x, -z+1/2)', '(-y+1/2, -x+1/2, -z+1/2)',
                            '(-x, -y, -z)', '(x+1/2, y+1/2, -z)',
                            '(y+1/2, -x, -z+1/2)', '(-y, x+1/2, -z+1/2)',
                            '(x+1/2, -y, z)', '(-x, y+1/2, z)',
                            '(-y, -x, z+1/2)', '(y+1/2, x+1/2, z+1/2)'), 'n/a'
                        )},
      '134:1': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)'), 'hkl: h+k+l=2n'),
                '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)'), 'hkl: h+k+l=2n'),
                '4c': (0, ('(0, 1/2, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                           '(1/2, 0, 0)'), 'hkl: h+k,l=2n'),
                '4d': (0, ('(0, 1/2, 1/4)', '(0, 1/2, 3/4)', '(1/2, 0, 1/4)',
                           '(1/2, 0, 3/4)'), 'hkl: h+k,l=2n'),
                '4e': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 1/4)',
                           '(1/4, 3/4, 3/4)', '(3/4, 1/4, 3/4)'),
                       'hkl: h+k,h+l,k+l=2n'),
                '4f': (0, ('(3/4, 3/4, 3/4)', '(1/4, 1/4, 3/4)',
                           '(3/4, 1/4, 1/4)', '(1/4, 3/4, 1/4)'),
                       'hkl: h+k,h+l,k+l=2n'),
                '4g': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(0, 0, -z)',
                           '(1/2, 1/2, -z+1/2)'), 'hkl: h+k+l=2n'),
                '8h': (4, ('(0, 1/2, z)', '(0, 1/2, z+1/2)', '(0, 1/2, -z)',
                           '(0, 1/2, -z+1/2)', '(1/2, 0, -z+1/2)',
                           '(1/2, 0, -z)', '(1/2, 0, z+1/2)', '(1/2, 0, z)'),
                       'hkl: h+k,l=2n'),
                '8i': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(1/2, x+1/2, 1/2)',
                           '(1/2, -x+1/2, 1/2)', '(-x+1/2, 1/2, 1/2)',
                           '(x+1/2, 1/2, 1/2)', '(0, -x, 0)', '(0, x, 0)'),
                       'hkl: h+k+l=2n'),
                '8j': (1, ('(x, 0, 1/2)', '(-x, 0, 1/2)', '(1/2, x+1/2, 0)',
                           '(1/2, -x+1/2, 0)', '(-x+1/2, 1/2, 0)',
                           '(x+1/2, 1/2, 0)', '(0, -x, 1/2)', '(0, x, 1/2)'),
                       'hkl: h+k+l=2n'),
                '8k': (1, ('(x, x+1/2, 1/4)', '(-x, -x+1/2, 1/4)',
                           '(-x, x+1/2, 3/4)', '(x, -x+1/2, 3/4)',
                           '(-x+1/2, -x, 1/4)', '(x+1/2, x, 1/4)',
                           '(x+1/2, -x, 3/4)', '(-x+1/2, x, 3/4)'),
                       'hkl: h+k=2n'),
                '8l': (1, ('(x, x+1/2, 3/4)', '(-x, -x+1/2, 3/4)',
                           '(-x, x+1/2, 1/4)', '(x, -x+1/2, 1/4)',
                           '(-x+1/2, -x, 3/4)', '(x+1/2, x, 3/4)',
                           '(x+1/2, -x, 1/4)', '(-x+1/2, x, 1/4)'),
                       'hkl: h+k=2n'),
                '8m': (5, ('(x, x, z)', '(-x, -x, z)',
                           '(-x+1/2, x+1/2, z+1/2)', '(x+1/2, -x+1/2, z+1/2)',
                           '(-x, x, -z)', '(x, -x, -z)',
                           '(x+1/2, x+1/2, -z+1/2)',
                           '(-x+1/2, -x+1/2, -z+1/2)'), None),
                '16n': (7, ('(x, y, z)', '(-x, -y, z)',
                            '(-y+1/2, x+1/2, z+1/2)',
                            '(y+1/2, -x+1/2, z+1/2)', '(-x, y, -z)',
                            '(x, -y, -z)', '(y+1/2, x+1/2, -z+1/2)',
                            '(-y+1/2, -x+1/2, -z+1/2)',
                            '(-x+1/2, -y+1/2, -z+1/2)',
                            '(x+1/2, y+1/2, -z+1/2)', '(y, -x, -z)',
                            '(-y, x, -z)', '(x+1/2, -y+1/2, z+1/2)',
                            '(-x+1/2, y+1/2, z+1/2)', '(-y, -x, z)',
                            '(y, x, z)'),
                        'hk0: h+k=2n, 0kl: k+l=2n, 00l: l=2n, h00: h=2n')},
      '134:2': {'2a': (0, ('(1/4, 3/4, 1/4)', '(3/4, 1/4, 3/4)'), 'n/a'),
                '2b': (0, ('(3/4, 1/4, 1/4)', '(1/4, 3/4, 3/4)'), 'n/a'),
                '4c': (0, ('(1/4, 1/4, 1/4)', '(1/4, 1/4, 3/4)',
                           '(3/4, 3/4, 3/4)', '(3/4, 3/4, 1/4)'), 'n/a'),
                '4d': (0, ('(1/4, 1/4, 0)', '(1/4, 1/4, 1/2)',
                           '(3/4, 3/4, 0)', '(3/4, 3/4, 1/2)'), 'n/a'),
                '4e': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)', '(1/2, 0, 0)',
                           '(0, 1/2, 0)'), 'n/a'),
                '4f': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(1/2, 0, 1/2)',
                           '(0, 1/2, 1/2)'), 'n/a'),
                '4g': (4, ('(3/4, 1/4, z)', '(1/4, 3/4, z+1/2)',
                           '(3/4, 1/4, -z+1/2)', '(1/4, 3/4, -z)'), 'n/a'),
                '8h': (4, ('(1/4, 1/4, z)', '(1/4, 1/4, z+1/2)',
                           '(1/4, 1/4, -z+1/2)', '(1/4, 1/4, -z)',
                           '(3/4, 3/4, -z)', '(3/4, 3/4, -z+1/2)',
                           '(3/4, 3/4, z+1/2)', '(3/4, 3/4, z)'), 'n/a'),
                '8i': (1, ('(x, 1/4, 3/4)', '(-x+1/2, 1/4, 3/4)',
                           '(1/4, x, 1/4)', '(1/4, -x+1/2, 1/4)',
                           '(-x, 3/4, 1/4)', '(x+1/2, 3/4, 1/4)',
                           '(3/4, -x, 3/4)', '(3/4, x+1/2, 3/4)'), 'n/a'),
                '8j': (1, ('(x, 1/4, 1/4)', '(-x+1/2, 1/4, 1/4)',
                           '(1/4, x, 3/4)', '(1/4, -x+1/2, 3/4)',
                           '(-x, 3/4, 3/4)', '(x+1/2, 3/4, 3/4)',
                           '(3/4, -x, 1/4)', '(3/4, x+1/2, 1/4)'), 'n/a'),
                '8k': (1, ('(x, x, 0)', '(-x+1/2, -x+1/2, 0)',
                           '(-x+1/2, x, 1/2)', '(x, -x+1/2, 1/2)',
                           '(-x, -x, 0)', '(x+1/2, x+1/2, 0)',
                           '(x+1/2, -x, 1/2)', '(-x, x+1/2, 1/2)'), 'n/a'),
                '8l': (1, ('(x, x, 1/2)', '(-x+1/2, -x+1/2, 1/2)',
                           '(-x+1/2, x, 0)', '(x, -x+1/2, 0)',
                           '(-x, -x, 1/2)', '(x+1/2, x+1/2, 1/2)',
                           '(x+1/2, -x, 0)', '(-x, x+1/2, 0)'), 'n/a'),
                '8m': (5, ('(x, -x, z)', '(-x+1/2, x+1/2, z)',
                           '(x+1/2, x, z+1/2)', '(-x, -x+1/2, z+1/2)',
                           '(-x+1/2, -x, -z+1/2)', '(x, x+1/2, -z+1/2)',
                           '(-x, x, -z)', '(x+1/2, -x+1/2, -z)'), 'n/a'),
                '16n': (7, ('(x, y, z)', '(-x+1/2, -y+1/2, z)',
                            '(-y+1/2, x, z+1/2)', '(y, -x+1/2, z+1/2)',
                            '(-x+1/2, y, -z+1/2)', '(x, -y+1/2, -z+1/2)',
                            '(y, x, -z)', '(-y+1/2, -x+1/2, -z)',
                            '(-x, -y, -z)', '(x+1/2, y+1/2, -z)',
                            '(y+1/2, -x, -z+1/2)', '(-y, x+1/2, -z+1/2)',
                            '(x+1/2, -y, z+1/2)', '(-x, y+1/2, z+1/2)',
                            '(-y, -x, z)', '(y+1/2, x+1/2, z)'), 'n/a')},
      '135': {'4a': (0, ('(0, 0, 0)', '(0, 0, 1/2)', '(1/2, 1/2, 0)',
                         '(1/2, 1/2, 1/2)'), 'hkl: h+k,l=2n'),
              '4b': (0, ('(0, 0, 1/4)', '(0, 0, 3/4)', '(1/2, 1/2, 3/4)',
                         '(1/2, 1/2, 1/4)'), 'hkl: h+k,l=2n'),
              '4c': (0, ('(0, 1/2, 0)', '(1/2, 0, 1/2)', '(1/2, 0, 0)',
                         '(0, 1/2, 1/2)'), 'hkl: h+k,l=2n'),
              '4d': (0, ('(0, 1/2, 1/4)', '(1/2, 0, 3/4)', '(0, 1/2, 3/4)',
                         '(1/2, 0, 1/4)'), 'hkl: h+k,l=2n'),
              '8e': (4, ('(0, 0, z)', '(0, 0, z+1/2)', '(1/2, 1/2, -z)',
                         '(1/2, 1/2, -z+1/2)', '(0, 0, -z)', '(0, 0, -z+1/2)',
                         '(1/2, 1/2, z)', '(1/2, 1/2, z+1/2)'), 'hkl: h+k,l=2n'
                     ),
              '8f': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(1/2, 0, -z)',
                         '(0, 1/2, -z+1/2)', '(0, 1/2, -z)',
                         '(1/2, 0, -z+1/2)', '(1/2, 0, z)', '(0, 1/2, z+1/2)'
                         ), 'hkl: h+k,l=2n'),
              '8g': (1, ('(x, x+1/2, 1/4)', '(-x, -x+1/2, 1/4)',
                         '(-x+1/2, x, 3/4)', '(x+1/2, -x, 3/4)',
                         '(-x, -x+1/2, 3/4)', '(x, x+1/2, 3/4)',
                         '(x+1/2, -x, 1/4)', '(-x+1/2, x, 1/4)'), 'hkl: l=2n'
                     ),
              '8h': (3, ('(x, y, 0)', '(-x, -y, 0)', '(-y, x, 1/2)',
                         '(y, -x, 1/2)', '(-x+1/2, y+1/2, 0)',
                         '(x+1/2, -y+1/2, 0)', '(y+1/2, x+1/2, 1/2)',
                         '(-y+1/2, -x+1/2, 1/2)'), None),
              '16i': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z+1/2)',
                          '(y, -x, z+1/2)', '(-x+1/2, y+1/2, -z)',
                          '(x+1/2, -y+1/2, -z)', '(y+1/2, x+1/2, -z+1/2)',
                          '(-y+1/2, -x+1/2, -z+1/2)', '(-x, -y, -z)',
                          '(x, y, -z)', '(y, -x, -z+1/2)', '(-y, x, -z+1/2)',
                          '(x+1/2, -y+1/2, z)', '(-x+1/2, y+1/2, z)',
                          '(-y+1/2, -x+1/2, z+1/2)', '(y+1/2, x+1/2, z+1/2)'),
                      '0kl: k=2n, hhl: l=2n, 00l: l=2n, h00: h=2n')},
      '136': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)'), 'hkl: h+k+l=2n'),
              '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)'), 'hkl: h+k+l=2n'),
              '4c': (0, ('(0, 1/2, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                         '(1/2, 0, 0)'), 'hkl: h+k,l=2n'),
              '4d': (0, ('(0, 1/2, 1/4)', '(0, 1/2, 3/4)', '(1/2, 0, 1/4)',
                         '(1/2, 0, 3/4)'), 'hkl: h+k,l=2n'),
              '4e': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)',
                         '(1/2, 1/2, -z+1/2)', '(0, 0, -z)'), 'hkl: h+k+l=2n'
                     ),
              '4f': (1, ('(x, x, 0)', '(-x, -x, 0)', '(-x+1/2, x+1/2, 1/2)',
                         '(x+1/2, -x+1/2, 1/2)'), None),
              '4g': (1, ('(x, -x, 0)', '(-x, x, 0)', '(x+1/2, x+1/2, 1/2)',
                         '(-x+1/2, -x+1/2, 1/2)'), None),
              '8h': (4, ('(0, 1/2, z)', '(0, 1/2, z+1/2)', '(1/2, 0, -z+1/2)',
                         '(1/2, 0, -z)', '(0, 1/2, -z)', '(0, 1/2, -z+1/2)',
                         '(1/2, 0, z+1/2)', '(1/2, 0, z)'), 'hkl: h+k,l=2n'),
              '8i': (3, ('(x, y, 0)', '(-x, -y, 0)', '(-y+1/2, x+1/2, 1/2)',
                         '(y+1/2, -x+1/2, 1/2)', '(-x+1/2, y+1/2, 1/2)',
                         '(x+1/2, -y+1/2, 1/2)', '(y, x, 0)', '(-y, -x, 0)'),
                     None),
              '8j': (5, ('(x, x, z)', '(-x, -x, z)', '(-x+1/2, x+1/2, z+1/2)',
                         '(x+1/2, -x+1/2, z+1/2)', '(-x+1/2, x+1/2, -z+1/2)',
                         '(x+1/2, -x+1/2, -z+1/2)', '(x, x, -z)',
                         '(-x, -x, -z)'), None),
              '16k': (7, ('(x, y, z)', '(-x, -y, z)',
                          '(-y+1/2, x+1/2, z+1/2)', '(y+1/2, -x+1/2, z+1/2)',
                          '(-x+1/2, y+1/2, -z+1/2)',
                          '(x+1/2, -y+1/2, -z+1/2)', '(y, x, -z)',
                          '(-y, -x, -z)', '(-x, -y, -z)', '(x, y, -z)',
                          '(y+1/2, -x+1/2, -z+1/2)',
                          '(-y+1/2, x+1/2, -z+1/2)', '(x+1/2, -y+1/2, z+1/2)',
                          '(-x+1/2, y+1/2, z+1/2)', '(-y, -x, z)',
                          '(y, x, z)'), '0kl: k+l=2n, 00l: l=2n, h00: h=2n')},
      '137:1': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)'), 'hkl: h+k+l=2n'),
                '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)'), 'hkl: h+k+l=2n'),
                '4c': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)',
                           '(1/2, 1/2, -z+1/2)', '(0, 0, -z)'), 'hkl: h+k+l=2n'
                       ),
                '4d': (4, ('(0, 1/2, z)', '(0, 1/2, z+1/2)',
                           '(1/2, 0, -z+1/2)', '(1/2, 0, -z)'), 'hkl: l=2n'),
                '8e': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 1/4)',
                           '(1/4, 3/4, 3/4)', '(3/4, 1/4, 3/4)',
                           '(1/4, 3/4, 1/4)', '(3/4, 1/4, 1/4)',
                           '(1/4, 1/4, 3/4)', '(3/4, 3/4, 3/4)'),
                       'hkl: h,k,l=2n'),
                '8f': (1, ('(x, x, 0)', '(-x, -x, 0)', '(-x+1/2, x+1/2, 1/2)',
                           '(x+1/2, -x+1/2, 1/2)', '(-x+1/2, -x+1/2, 1/2)',
                           '(x+1/2, x+1/2, 1/2)', '(x, -x, 0)', '(-x, x, 0)'),
                       'hkl: h+k+l=2n'),
                '8g': (6, ('(0, y, z)', '(0, -y, z)', '(-y+1/2, 1/2, z+1/2)',
                           '(y+1/2, 1/2, z+1/2)', '(1/2, y+1/2, -z+1/2)',
                           '(1/2, -y+1/2, -z+1/2)', '(y, 0, -z)',
                           '(-y, 0, -z)'), None),
                '16h': (7, ('(x, y, z)', '(-x, -y, z)',
                            '(-y+1/2, x+1/2, z+1/2)',
                            '(y+1/2, -x+1/2, z+1/2)',
                            '(-x+1/2, y+1/2, -z+1/2)',
                            '(x+1/2, -y+1/2, -z+1/2)', '(y, x, -z)',
                            '(-y, -x, -z)', '(-x+1/2, -y+1/2, -z+1/2)',
                            '(x+1/2, y+1/2, -z+1/2)', '(y, -x, -z)',
                            '(-y, x, -z)', '(x, -y, z)', '(-x, y, z)',
                            '(-y+1/2, -x+1/2, z+1/2)',
                            '(y+1/2, x+1/2, z+1/2)'),
                        'hk0: h+k=2n, hhl: l=2n, 00l: l=2n, h00: h=2n')},
      '137:2': {'2a': (0, ('(3/4, 1/4, 3/4)', '(1/4, 3/4, 1/4)'), 'n/a'),
                '2b': (0, ('(3/4, 1/4, 1/4)', '(1/4, 3/4, 3/4)'), 'n/a'),
                '4c': (4, ('(3/4, 1/4, z)', '(1/4, 3/4, z+1/2)',
                           '(1/4, 3/4, -z)', '(3/4, 1/4, -z+1/2)'), 'n/a'),
                '4d': (4, ('(1/4, 1/4, z)', '(1/4, 1/4, z+1/2)',
                           '(3/4, 3/4, -z)', '(3/4, 3/4, -z+1/2)'), 'n/a'),
                '8e': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(1/2, 0, 1/2)',
                           '(0, 1/2, 1/2)', '(0, 1/2, 0)', '(1/2, 0, 0)',
                           '(1/2, 1/2, 1/2)', '(0, 0, 1/2)'), 'n/a'),
                '8f': (1, ('(x, -x, 1/4)', '(-x+1/2, x+1/2, 1/4)',
                           '(x+1/2, x, 3/4)', '(-x, -x+1/2, 3/4)',
                           '(-x, x, 3/4)', '(x+1/2, -x+1/2, 3/4)',
                           '(-x+1/2, -x, 1/4)', '(x, x+1/2, 1/4)'), 'n/a'),
                '8g': (6, ('(1/4, y, z)', '(1/4, -y+1/2, z)',
                           '(-y+1/2, 1/4, z+1/2)', '(y, 1/4, z+1/2)',
                           '(3/4, y+1/2, -z)', '(3/4, -y, -z)',
                           '(y+1/2, 3/4, -z+1/2)', '(-y, 3/4, -z+1/2)'), 'n/a'
                       ),
                '16h': (7, ('(x, y, z)', '(-x+1/2, -y+1/2, z)',
                            '(-y+1/2, x, z+1/2)', '(y, -x+1/2, z+1/2)',
                            '(-x, y+1/2, -z)', '(x+1/2, -y, -z)',
                            '(y+1/2, x+1/2, -z+1/2)', '(-y, -x, -z+1/2)',
                            '(-x, -y, -z)', '(x+1/2, y+1/2, -z)',
                            '(y+1/2, -x, -z+1/2)', '(-y, x+1/2, -z+1/2)',
                            '(x, -y+1/2, z)', '(-x+1/2, y, z)',
                            '(-y+1/2, -x+1/2, z+1/2)', '(y, x, z+1/2)'), 'n/a'
                        )},
      '138:1': {'4a': (0, ('(0, 0, 1/4)', '(1/2, 1/2, 3/4)',
                           '(1/2, 1/2, 1/4)', '(0, 0, 3/4)'), 'hkl: h+k,l=2n'
                       ),
                '4b': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)', '(1/2, 1/2, 0)',
                           '(0, 0, 1/2)'), 'hkl: h+k,l=2n'),
                '4c': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 1/4)',
                           '(1/4, 3/4, 3/4)', '(3/4, 1/4, 3/4)'),
                       'hkl: h+k,h+l,k+l=2n'),
                '4d': (0, ('(1/4, 1/4, 3/4)', '(3/4, 3/4, 3/4)',
                           '(1/4, 3/4, 1/4)', '(3/4, 1/4, 1/4)'),
                       'hkl: h+k,h+l,k+l=2n'),
                '4e': (4, ('(0, 1/2, z)', '(0, 1/2, z+1/2)', '(1/2, 0, -z)',
                           '(1/2, 0, -z+1/2)'), 'hkl: l=2n'),
                '8f': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(1/2, 1/2, -z)',
                           '(0, 0, -z+1/2)', '(1/2, 1/2, -z+1/2)',
                           '(0, 0, -z)', '(0, 0, z+1/2)', '(1/2, 1/2, z)'),
                       'hkl: h+k,l=2n'),
                '8g': (1, ('(x, x, 1/4)', '(-x, -x, 1/4)',
                           '(-x+1/2, x+1/2, 3/4)', '(x+1/2, -x+1/2, 3/4)',
                           '(-x+1/2, -x+1/2, 1/4)', '(x+1/2, x+1/2, 1/4)',
                           '(x, -x, 3/4)', '(-x, x, 3/4)'), 'hkl: h+k=2n'),
                '8h': (1, ('(x, x, 3/4)', '(-x, -x, 3/4)',
                           '(-x+1/2, x+1/2, 1/4)', '(x+1/2, -x+1/2, 1/4)',
                           '(-x+1/2, -x+1/2, 3/4)', '(x+1/2, x+1/2, 3/4)',
                           '(x, -x, 1/4)', '(-x, x, 1/4)'), 'hkl: h+k=2n'),
                '8i': (5, ('(x, x+1/2, z)', '(-x, -x+1/2, z)',
                           '(-x, x+1/2, z+1/2)', '(x, -x+1/2, z+1/2)',
                           '(-x+1/2, x, -z)', '(x+1/2, -x, -z)',
                           '(x+1/2, x, -z+1/2)', '(-x+1/2, -x, -z+1/2)'), None
                       ),
                '16j': (7, ('(x, y, z)', '(-x, -y, z)',
                            '(-y+1/2, x+1/2, z+1/2)',
                            '(y+1/2, -x+1/2, z+1/2)', '(-x+1/2, y+1/2, -z)',
                            '(x+1/2, -y+1/2, -z)', '(y, x, -z+1/2)',
                            '(-y, -x, -z+1/2)', '(-x+1/2, -y+1/2, -z+1/2)',
                            '(x+1/2, y+1/2, -z+1/2)', '(y, -x, -z)',
                            '(-y, x, -z)', '(x, -y, z+1/2)', '(-x, y, z+1/2)',
                            '(-y+1/2, -x+1/2, z)', '(y+1/2, x+1/2, z)'),
                        'hk0: h+k=2n, 0kl: l=2n, 00l: l=2n, h00: h=2n')},
      '138:2': {'4a': (0, ('(3/4, 1/4, 0)', '(1/4, 3/4, 1/2)',
                           '(1/4, 3/4, 0)', '(3/4, 1/4, 1/2)'), 'n/a'),
                '4b': (0, ('(3/4, 1/4, 3/4)', '(1/4, 3/4, 1/4)',
                           '(1/4, 3/4, 3/4)', '(3/4, 1/4, 1/4)'), 'n/a'),
                '4c': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)', '(1/2, 0, 0)',
                           '(0, 1/2, 0)'), 'n/a'),
                '4d': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(1/2, 0, 1/2)',
                           '(0, 1/2, 1/2)'), 'n/a'),
                '4e': (4, ('(1/4, 1/4, z)', '(1/4, 1/4, z+1/2)',
                           '(3/4, 3/4, -z+1/2)', '(3/4, 3/4, -z)'), 'n/a'),
                '8f': (4, ('(3/4, 1/4, z)', '(1/4, 3/4, z+1/2)',
                           '(1/4, 3/4, -z+1/2)', '(3/4, 1/4, -z)',
                           '(1/4, 3/4, -z)', '(3/4, 1/4, -z+1/2)',
                           '(3/4, 1/4, z+1/2)', '(1/4, 3/4, z)'), 'n/a'),
                '8g': (1, ('(x, -x, 1/2)', '(-x+1/2, x+1/2, 1/2)',
                           '(x+1/2, x, 0)', '(-x, -x+1/2, 0)', '(-x, x, 1/2)',
                           '(x+1/2, -x+1/2, 1/2)', '(-x+1/2, -x, 0)',
                           '(x, x+1/2, 0)'), 'n/a'),
                '8h': (1, ('(x, -x, 0)', '(-x+1/2, x+1/2, 0)',
                           '(x+1/2, x, 1/2)', '(-x, -x+1/2, 1/2)',
                           '(-x, x, 0)', '(x+1/2, -x+1/2, 0)',
                           '(-x+1/2, -x, 1/2)', '(x, x+1/2, 1/2)'), 'n/a'),
                '8i': (5, ('(x, x, z)', '(-x+1/2, -x+1/2, z)',
                           '(-x+1/2, x, z+1/2)', '(x, -x+1/2, z+1/2)',
                           '(-x, x+1/2, -z+1/2)', '(x+1/2, -x, -z+1/2)',
                           '(x+1/2, x+1/2, -z)', '(-x, -x, -z)'), 'n/a'),
                '16j': (7, ('(x, y, z)', '(-x+1/2, -y+1/2, z)',
                            '(-y+1/2, x, z+1/2)', '(y, -x+1/2, z+1/2)',
                            '(-x, y+1/2, -z+1/2)', '(x+1/2, -y, -z+1/2)',
                            '(y+1/2, x+1/2, -z)', '(-y, -x, -z)',
                            '(-x, -y, -z)', '(x+1/2, y+1/2, -z)',
                            '(y+1/2, -x, -z+1/2)', '(-y, x+1/2, -z+1/2)',
                            '(x, -y+1/2, z+1/2)', '(-x+1/2, y, z+1/2)',
                            '(-y+1/2, -x+1/2, z)', '(y, x, z)'), 'n/a')},
      '139': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)'), None),
              '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)'), None),
              '4c': (0, ('(0, 1/2, 0)', '(1/2, 0, 1/2)', '(1/2, 0, 0)',
                         '(0, 1/2, 1/2)'), 'hkl: l=2n'),
              '4d': (0, ('(0, 1/2, 1/4)', '(1/2, 0, 3/4)', '(1/2, 0, 1/4)',
                         '(0, 1/2, 3/4)'), 'hkl: l=2n'),
              '4e': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(0, 0, -z)',
                         '(1/2, 1/2, -z+1/2)'), None),
              '8f': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)',
                         '(3/4, 3/4, 1/4)', '(1/4, 1/4, 3/4)',
                         '(3/4, 1/4, 1/4)', '(1/4, 3/4, 3/4)',
                         '(1/4, 3/4, 1/4)', '(3/4, 1/4, 3/4)'), 'hkl: k,l=2n'
                     ),
              '8g': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(1/2, 0, z)',
                         '(0, 1/2, z+1/2)', '(0, 1/2, -z)',
                         '(1/2, 0, -z+1/2)', '(1/2, 0, -z)',
                         '(0, 1/2, -z+1/2)'), 'hkl: l=2n'),
              '8h': (1, ('(x, x, 0)', '(x+1/2, x+1/2, 1/2)', '(-x, -x, 0)',
                         '(-x+1/2, -x+1/2, 1/2)', '(-x, x, 0)',
                         '(-x+1/2, x+1/2, 1/2)', '(x, -x, 0)',
                         '(x+1/2, -x+1/2, 1/2)'), None),
              '8i': (1, ('(x, 0, 0)', '(x+1/2, 1/2, 1/2)', '(-x, 0, 0)',
                         '(-x+1/2, 1/2, 1/2)', '(0, x, 0)',
                         '(1/2, x+1/2, 1/2)', '(0, -x, 0)',
                         '(1/2, -x+1/2, 1/2)'), None),
              '8j': (1, ('(x, 1/2, 0)', '(x+1/2, 0, 1/2)', '(-x, 1/2, 0)',
                         '(-x+1/2, 0, 1/2)', '(1/2, x, 0)', '(0, x+1/2, 1/2)',
                         '(1/2, -x, 0)', '(0, -x+1/2, 1/2)'), None),
              '16k': (1, ('(x, x+1/2, 1/4)', '(x+1/2, x, 3/4)',
                          '(-x, -x+1/2, 1/4)', '(-x+1/2, -x, 3/4)',
                          '(-x+1/2, x, 1/4)', '(-x, x+1/2, 3/4)',
                          '(x+1/2, -x, 1/4)', '(x, -x+1/2, 3/4)',
                          '(-x, -x+1/2, 3/4)', '(-x+1/2, -x, 1/4)',
                          '(x, x+1/2, 3/4)', '(x+1/2, x, 1/4)',
                          '(x+1/2, -x, 3/4)', '(x, -x+1/2, 1/4)',
                          '(-x+1/2, x, 3/4)', '(-x, x+1/2, 1/4)'), 'hkl: l=2n'
                      ),
              '16l': (3, ('(x, y, 0)', '(x+1/2, y+1/2, 1/2)', '(-x, -y, 0)',
                          '(-x+1/2, -y+1/2, 1/2)', '(-y, x, 0)',
                          '(-y+1/2, x+1/2, 1/2)', '(y, -x, 0)',
                          '(y+1/2, -x+1/2, 1/2)', '(-x, y, 0)',
                          '(-x+1/2, y+1/2, 1/2)', '(x, -y, 0)',
                          '(x+1/2, -y+1/2, 1/2)', '(y, x, 0)',
                          '(y+1/2, x+1/2, 1/2)', '(-y, -x, 0)',
                          '(-y+1/2, -x+1/2, 1/2)'), None),
              '16m': (5, ('(x, x, z)', '(x+1/2, x+1/2, z+1/2)', '(-x, -x, z)',
                          '(-x+1/2, -x+1/2, z+1/2)', '(-x, x, z)',
                          '(-x+1/2, x+1/2, z+1/2)', '(x, -x, z)',
                          '(x+1/2, -x+1/2, z+1/2)', '(-x, x, -z)',
                          '(-x+1/2, x+1/2, -z+1/2)', '(x, -x, -z)',
                          '(x+1/2, -x+1/2, -z+1/2)', '(x, x, -z)',
                          '(x+1/2, x+1/2, -z+1/2)', '(-x, -x, -z)',
                          '(-x+1/2, -x+1/2, -z+1/2)'), None),
              '16n': (6, ('(0, y, z)', '(1/2, y+1/2, z+1/2)', '(0, -y, z)',
                          '(1/2, -y+1/2, z+1/2)', '(-y, 0, z)',
                          '(-y+1/2, 1/2, z+1/2)', '(y, 0, z)',
                          '(y+1/2, 1/2, z+1/2)', '(0, y, -z)',
                          '(1/2, y+1/2, -z+1/2)', '(0, -y, -z)',
                          '(1/2, -y+1/2, -z+1/2)', '(y, 0, -z)',
                          '(y+1/2, 1/2, -z+1/2)', '(-y, 0, -z)',
                          '(-y+1/2, 1/2, -z+1/2)'), None),
              '32o': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                          '(-x+1/2, -y+1/2, z+1/2)', '(-y, x, z)',
                          '(-y+1/2, x+1/2, z+1/2)', '(y, -x, z)',
                          '(y+1/2, -x+1/2, z+1/2)', '(-x, y, -z)',
                          '(-x+1/2, y+1/2, -z+1/2)', '(x, -y, -z)',
                          '(x+1/2, -y+1/2, -z+1/2)', '(y, x, -z)',
                          '(y+1/2, x+1/2, -z+1/2)', '(-y, -x, -z)',
                          '(-y+1/2, -x+1/2, -z+1/2)', '(-x, -y, -z)',
                          '(-x+1/2, -y+1/2, -z+1/2)', '(x, y, -z)',
                          '(x+1/2, y+1/2, -z+1/2)', '(y, -x, -z)',
                          '(y+1/2, -x+1/2, -z+1/2)', '(-y, x, -z)',
                          '(-y+1/2, x+1/2, -z+1/2)', '(x, -y, z)',
                          '(x+1/2, -y+1/2, z+1/2)', '(-x, y, z)',
                          '(-x+1/2, y+1/2, z+1/2)', '(-y, -x, z)',
                          '(-y+1/2, -x+1/2, z+1/2)', '(y, x, z)',
                          '(y+1/2, x+1/2, z+1/2)'),
                      'hkl: h+k+l=2n, hk0: h+k=2n, 0kl: k+l=2n, hhl: l=2n, '
                      '00l: l=2n, h00: h=2n')},
      '140': {'4a': (0, ('(0, 0, 1/4)', '(1/2, 1/2, 3/4)', '(0, 0, 3/4)',
                         '(1/2, 1/2, 1/4)'), 'hkl: l=2n'),
              '4b': (0, ('(0, 1/2, 1/4)', '(1/2, 0, 3/4)', '(1/2, 0, 1/4)',
                         '(0, 1/2, 3/4)'), 'hkl: l=2n'),
              '4c': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)', '(0, 0, 1/2)',
                         '(1/2, 1/2, 0)'), 'hkl: l=2n'),
              '4d': (0, ('(0, 1/2, 0)', '(1/2, 0, 1/2)', '(1/2, 0, 0)',
                         '(0, 1/2, 1/2)'), 'hkl: l=2n'),
              '8e': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)',
                         '(3/4, 3/4, 1/4)', '(1/4, 1/4, 3/4)',
                         '(3/4, 1/4, 1/4)', '(1/4, 3/4, 3/4)',
                         '(1/4, 3/4, 1/4)', '(3/4, 1/4, 3/4)'), 'hkl: k,l=2n'
                     ),
              '8f': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(0, 0, -z+1/2)',
                         '(1/2, 1/2, -z)', '(0, 0, -z)', '(1/2, 1/2, -z+1/2)',
                         '(0, 0, z+1/2)', '(1/2, 1/2, z)'), 'hkl: l=2n'),
              '8g': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(1/2, 0, z)',
                         '(0, 1/2, z+1/2)', '(0, 1/2, -z+1/2)',
                         '(1/2, 0, -z)', '(1/2, 0, -z+1/2)', '(0, 1/2, -z)'),
                     'hkl: l=2n'),
              '8h': (1, ('(x, x+1/2, 0)', '(x+1/2, x, 1/2)',
                         '(-x, -x+1/2, 0)', '(-x+1/2, -x, 1/2)',
                         '(-x+1/2, x, 0)', '(-x, x+1/2, 1/2)',
                         '(x+1/2, -x, 0)', '(x, -x+1/2, 1/2)'), None),
              '16i': (1, ('(x, x, 1/4)', '(x+1/2, x+1/2, 3/4)',
                          '(-x, -x, 1/4)', '(-x+1/2, -x+1/2, 3/4)',
                          '(-x, x, 1/4)', '(-x+1/2, x+1/2, 3/4)',
                          '(x, -x, 1/4)', '(x+1/2, -x+1/2, 3/4)',
                          '(-x, -x, 3/4)', '(-x+1/2, -x+1/2, 1/4)',
                          '(x, x, 3/4)', '(x+1/2, x+1/2, 1/4)',
                          '(x, -x, 3/4)', '(x+1/2, -x+1/2, 1/4)',
                          '(-x, x, 3/4)', '(-x+1/2, x+1/2, 1/4)'), 'hkl: l=2n'
                      ),
              '16j': (1, ('(x, 0, 1/4)', '(x+1/2, 1/2, 3/4)', '(-x, 0, 1/4)',
                          '(-x+1/2, 1/2, 3/4)', '(0, x, 1/4)',
                          '(1/2, x+1/2, 3/4)', '(0, -x, 1/4)',
                          '(1/2, -x+1/2, 3/4)', '(-x, 0, 3/4)',
                          '(-x+1/2, 1/2, 1/4)', '(x, 0, 3/4)',
                          '(x+1/2, 1/2, 1/4)', '(0, -x, 3/4)',
                          '(1/2, -x+1/2, 1/4)', '(0, x, 3/4)',
                          '(1/2, x+1/2, 1/4)'), 'hkl: l=2n'),
              '16k': (3, ('(x, y, 0)', '(x+1/2, y+1/2, 1/2)', '(-x, -y, 0)',
                          '(-x+1/2, -y+1/2, 1/2)', '(-y, x, 0)',
                          '(-y+1/2, x+1/2, 1/2)', '(y, -x, 0)',
                          '(y+1/2, -x+1/2, 1/2)', '(-x, y, 1/2)',
                          '(-x+1/2, y+1/2, 0)', '(x, -y, 1/2)',
                          '(x+1/2, -y+1/2, 0)', '(y, x, 1/2)',
                          '(y+1/2, x+1/2, 0)', '(-y, -x, 1/2)',
                          '(-y+1/2, -x+1/2, 0)'), None),
              '16l': (5, ('(x, x+1/2, z)', '(x+1/2, x, z+1/2)',
                          '(-x, -x+1/2, z)', '(-x+1/2, -x, z+1/2)',
                          '(-x+1/2, x, z)', '(-x, x+1/2, z+1/2)',
                          '(x+1/2, -x, z)', '(x, -x+1/2, z+1/2)',
                          '(-x, x+1/2, -z+1/2)', '(-x+1/2, x, -z)',
                          '(x, -x+1/2, -z+1/2)', '(x+1/2, -x, -z)',
                          '(x+1/2, x, -z+1/2)', '(x, x+1/2, -z)',
                          '(-x+1/2, -x, -z+1/2)', '(-x, -x+1/2, -z)'), None),
              '32m': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                          '(-x+1/2, -y+1/2, z+1/2)', '(-y, x, z)',
                          '(-y+1/2, x+1/2, z+1/2)', '(y, -x, z)',
                          '(y+1/2, -x+1/2, z+1/2)', '(-x, y, -z+1/2)',
                          '(-x+1/2, y+1/2, -z)', '(x, -y, -z+1/2)',
                          '(x+1/2, -y+1/2, -z)', '(y, x, -z+1/2)',
                          '(y+1/2, x+1/2, -z)', '(-y, -x, -z+1/2)',
                          '(-y+1/2, -x+1/2, -z)', '(-x, -y, -z)',
                          '(-x+1/2, -y+1/2, -z+1/2)', '(x, y, -z)',
                          '(x+1/2, y+1/2, -z+1/2)', '(y, -x, -z)',
                          '(y+1/2, -x+1/2, -z+1/2)', '(-y, x, -z)',
                          '(-y+1/2, x+1/2, -z+1/2)', '(x, -y, z+1/2)',
                          '(x+1/2, -y+1/2, z)', '(-x, y, z+1/2)',
                          '(-x+1/2, y+1/2, z)', '(-y, -x, z+1/2)',
                          '(-y+1/2, -x+1/2, z)', '(y, x, z+1/2)',
                          '(y+1/2, x+1/2, z)'),
                      'hkl: h+k+l=2n, hk0: h+k=2n, 0kl: k,l=2n, hhl: l=2n, '
                      '00l: l=2n, h00: h=2n')},
      '141:1': {'4a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)', '(0, 1/2, 1/4)',
                           '(1/2, 0, 3/4)'), 'hkl: l=2n+1 or 2h+l=4n'),
                '4b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)', '(0, 1/2, 3/4)',
                           '(1/2, 0, 1/4)'), 'hkl: l=2n+1 or 2h+l=4n'),
                '8c': (0, ('(0, 1/4, 1/8)', '(1/2, 3/4, 5/8)',
                           '(1/2, 1/4, 5/8)', '(0, 3/4, 1/8)',
                           '(3/4, 1/2, 3/8)', '(1/4, 0, 7/8)',
                           '(3/4, 0, 7/8)', '(1/4, 1/2, 3/8)'),
                       'hkl: l=2n+1 or h,k=2n, h+k+l=4n'),
                '8d': (0, ('(0, 1/4, 5/8)', '(1/2, 3/4, 1/8)',
                           '(1/2, 1/4, 1/8)', '(0, 3/4, 5/8)',
                           '(3/4, 1/2, 7/8)', '(1/4, 0, 3/8)',
                           '(3/4, 0, 3/8)', '(1/4, 1/2, 7/8)'),
                       'hkl: l=2n+1 or h,k=2n, h+k+l=4n'),
                '8e': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)',
                           '(0, 1/2, z+1/4)', '(1/2, 0, z+3/4)',
                           '(1/2, 0, -z+3/4)', '(0, 1/2, -z+1/4)',
                           '(1/2, 1/2, -z+1/2)', '(0, 0, -z)'),
                       'hkl: l=2n+1 or 2h+l=4n'),
                '16f': (1, ('(x, 1/4, 1/8)', '(x+1/2, 3/4, 5/8)',
                            '(-x+1/2, 1/4, 5/8)', '(-x, 3/4, 1/8)',
                            '(3/4, x+1/2, 3/8)', '(1/4, x, 7/8)',
                            '(3/4, -x, 7/8)', '(1/4, -x+1/2, 3/8)',
                            '(-x, 1/4, 1/8)', '(-x+1/2, 3/4, 5/8)',
                            '(x+1/2, 1/4, 5/8)', '(x, 3/4, 1/8)',
                            '(1/4, -x, 7/8)', '(3/4, -x+1/2, 3/8)',
                            '(1/4, x+1/2, 3/8)', '(3/4, x, 7/8)'),
                        'hkl: l=2n+1 or h=2n'),
                '16g': (1, ('(x, x, 0)', '(x+1/2, x+1/2, 1/2)',
                            '(-x+1/2, -x+1/2, 1/2)', '(-x, -x, 0)',
                            '(-x, x+1/2, 1/4)', '(-x+1/2, x, 3/4)',
                            '(x+1/2, -x, 3/4)', '(x, -x+1/2, 1/4)',
                            '(-x, -x+1/2, 1/4)', '(-x+1/2, -x, 3/4)',
                            '(x+1/2, x, 3/4)', '(x, x+1/2, 1/4)',
                            '(x, -x, 0)', '(x+1/2, -x+1/2, 1/2)',
                            '(-x+1/2, x+1/2, 1/2)', '(-x, x, 0)'),
                        'hkl: l=2n+1 or 2h+l=4n'),
                '16h': (6, ('(0, y, z)', '(1/2, y+1/2, z+1/2)',
                            '(1/2, -y+1/2, z+1/2)', '(0, -y, z)',
                            '(-y, 1/2, z+1/4)', '(-y+1/2, 0, z+3/4)',
                            '(y+1/2, 0, z+3/4)', '(y, 1/2, z+1/4)',
                            '(1/2, y, -z+3/4)', '(0, y+1/2, -z+1/4)',
                            '(0, -y+1/2, -z+1/4)', '(1/2, -y, -z+3/4)',
                            '(y+1/2, 1/2, -z+1/2)', '(y, 0, -z)',
                            '(-y, 0, -z)', '(-y+1/2, 1/2, -z+1/2)'), None),
                '32i': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)',
                            '(-x+1/2, -y+1/2, z+1/2)', '(-x, -y, z)',
                            '(-y, x+1/2, z+1/4)', '(-y+1/2, x, z+3/4)',
                            '(y+1/2, -x, z+3/4)', '(y, -x+1/2, z+1/4)',
                            '(-x+1/2, y, -z+3/4)', '(-x, y+1/2, -z+1/4)',
                            '(x, -y+1/2, -z+1/4)', '(x+1/2, -y, -z+3/4)',
                            '(y+1/2, x+1/2, -z+1/2)', '(y, x, -z)',
                            '(-y, -x, -z)', '(-y+1/2, -x+1/2, -z+1/2)',
                            '(-x, -y+1/2, -z+1/4)', '(-x+1/2, -y, -z+3/4)',
                            '(x+1/2, y, -z+3/4)', '(x, y+1/2, -z+1/4)',
                            '(y, -x, -z)', '(y+1/2, -x+1/2, -z+1/2)',
                            '(-y+1/2, x+1/2, -z+1/2)', '(-y, x, -z)',
                            '(x+1/2, -y+1/2, z+1/2)', '(x, -y, z)',
                            '(-x, y, z)', '(-x+1/2, y+1/2, z+1/2)',
                            '(-y+1/2, -x, z+3/4)', '(-y, -x+1/2, z+1/4)',
                            '(y, x+1/2, z+1/4)', '(y+1/2, x, z+3/4)'),
                        'hkl: h+k+l=2n, hk0: h,k=2n, 0kl: k+l=2n, '
                        'hhl: 2h+l=4n, 00l: l=4n, h00: h=2n, h-h0: h=2n')},
      '141:2': {'4a': (0, ('(0, 3/4, 1/8)', '(1/2, 1/4, 5/8)',
                           '(1/2, 3/4, 3/8)', '(0, 1/4, 7/8)'), 'n/a'),
                '4b': (0, ('(0, 1/4, 3/8)', '(1/2, 3/4, 7/8)',
                           '(0, 3/4, 5/8)', '(1/2, 1/4, 1/8)'), 'n/a'),
                '8c': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)', '(1/2, 0, 1/2)',
                           '(0, 1/2, 0)', '(1/4, 3/4, 1/4)',
                           '(3/4, 1/4, 3/4)', '(1/4, 1/4, 3/4)',
                           '(3/4, 3/4, 1/4)'), 'n/a'),
                '8d': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)', '(1/2, 0, 0)',
                           '(0, 1/2, 1/2)', '(1/4, 3/4, 3/4)',
                           '(3/4, 1/4, 1/4)', '(1/4, 1/4, 1/4)',
                           '(3/4, 3/4, 3/4)'), 'n/a'),
                '8e': (4, ('(0, 1/4, z)', '(1/2, 3/4, z+1/2)',
                           '(0, 3/4, z+1/4)', '(1/2, 1/4, z+3/4)',
                           '(1/2, 1/4, -z+1/2)', '(0, 3/4, -z)',
                           '(1/2, 3/4, -z+1/4)', '(0, 1/4, -z+3/4)'), 'n/a'),
                '16f': (1, ('(x, 0, 0)', '(x+1/2, 1/2, 1/2)',
                            '(-x+1/2, 0, 1/2)', '(-x, 1/2, 0)',
                            '(1/4, x+3/4, 1/4)', '(3/4, x+1/4, 3/4)',
                            '(1/4, -x+1/4, 3/4)', '(3/4, -x+3/4, 1/4)',
                            '(-x, 0, 0)', '(-x+1/2, 1/2, 1/2)',
                            '(x+1/2, 0, 1/2)', '(x, 1/2, 0)',
                            '(3/4, -x+1/4, 3/4)', '(1/4, -x+3/4, 1/4)',
                            '(3/4, x+3/4, 1/4)', '(1/4, x+1/4, 3/4)'), 'n/a'),
                '16g': (1, ('(x, x+1/4, 7/8)', '(x+1/2, x+3/4, 3/8)',
                            '(-x+1/2, -x+3/4, 3/8)', '(-x, -x+1/4, 7/8)',
                            '(-x, x+3/4, 1/8)', '(-x+1/2, x+1/4, 5/8)',
                            '(x+1/2, -x+1/4, 5/8)', '(x, -x+3/4, 1/8)',
                            '(-x, -x+3/4, 1/8)', '(-x+1/2, -x+1/4, 5/8)',
                            '(x+1/2, x+1/4, 5/8)', '(x, x+3/4, 1/8)',
                            '(x, -x+1/4, 7/8)', '(x+1/2, -x+3/4, 3/8)',
                            '(-x+1/2, x+3/4, 3/8)', '(-x, x+1/4, 7/8)'), 'n/a'
                        ),
                '16h': (6, ('(0, y, z)', '(1/2, y+1/2, z+1/2)',
                            '(1/2, -y, z+1/2)', '(0, -y+1/2, z)',
                            '(-y+1/4, 3/4, z+1/4)', '(-y+3/4, 1/4, z+3/4)',
                            '(y+1/4, 1/4, z+3/4)', '(y+3/4, 3/4, z+1/4)',
                            '(1/2, y, -z+1/2)', '(0, y+1/2, -z)',
                            '(0, -y, -z)', '(1/2, -y+1/2, -z+1/2)',
                            '(y+1/4, 3/4, -z+1/4)', '(y+3/4, 1/4, -z+3/4)',
                            '(-y+1/4, 1/4, -z+3/4)', '(-y+3/4, 3/4, -z+1/4)'),
                        'n/a'),
                '32i': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)',
                            '(-x+1/2, -y, z+1/2)', '(-x, -y+1/2, z)',
                            '(-y+1/4, x+3/4, z+1/4)',
                            '(-y+3/4, x+1/4, z+3/4)',
                            '(y+1/4, -x+1/4, z+3/4)',
                            '(y+3/4, -x+3/4, z+1/4)', '(-x+1/2, y, -z+1/2)',
                            '(-x, y+1/2, -z)', '(x, -y, -z)',
                            '(x+1/2, -y+1/2, -z+1/2)',
                            '(y+1/4, x+3/4, -z+1/4)',
                            '(y+3/4, x+1/4, -z+3/4)',
                            '(-y+1/4, -x+1/4, -z+3/4)',
                            '(-y+3/4, -x+3/4, -z+1/4)', '(-x, -y, -z)',
                            '(-x+1/2, -y+1/2, -z+1/2)', '(x+1/2, y, -z+1/2)',
                            '(x, y+1/2, -z)', '(y+3/4, -x+1/4, -z+3/4)',
                            '(y+1/4, -x+3/4, -z+1/4)',
                            '(-y+3/4, x+3/4, -z+1/4)',
                            '(-y+1/4, x+1/4, -z+3/4)', '(x+1/2, -y, z+1/2)',
                            '(x, -y+1/2, z)', '(-x, y, z)',
                            '(-x+1/2, y+1/2, z+1/2)',
                            '(-y+3/4, -x+1/4, z+3/4)',
                            '(-y+1/4, -x+3/4, z+1/4)',
                            '(y+3/4, x+3/4, z+1/4)', '(y+1/4, x+1/4, z+3/4)'),
                        'n/a')},
      '142:1': {'8a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)', '(0, 1/2, 1/4)',
                           '(1/2, 0, 3/4)', '(1/2, 0, 1/4)', '(0, 1/2, 3/4)',
                           '(1/2, 1/2, 0)', '(0, 0, 1/2)'), 'hkl: 2h+l=4n'),
                '8b': (0, ('(0, 0, 1/4)', '(1/2, 1/2, 3/4)', '(0, 1/2, 1/2)',
                           '(1/2, 0, 0)', '(0, 1/2, 0)', '(1/2, 0, 1/2)',
                           '(0, 0, 3/4)', '(1/2, 1/2, 1/4)'), 'hkl: 2h+l=4n'),
                '16c': (0, ('(0, 1/4, 1/8)', '(1/2, 3/4, 5/8)',
                            '(1/2, 1/4, 5/8)', '(0, 3/4, 1/8)',
                            '(3/4, 1/2, 3/8)', '(1/4, 0, 7/8)',
                            '(3/4, 0, 7/8)', '(1/4, 1/2, 3/8)',
                            '(1/2, 1/4, 1/8)', '(0, 3/4, 5/8)',
                            '(0, 1/4, 5/8)', '(1/2, 3/4, 1/8)',
                            '(3/4, 1/2, 7/8)', '(1/4, 0, 3/8)',
                            '(3/4, 0, 3/8)', '(1/4, 1/2, 7/8)'),
                        'hkl: h,k=2n, h+k+l=4n'),
                '16d': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)',
                            '(0, 1/2, z+1/4)', '(1/2, 0, z+3/4)',
                            '(1/2, 0, -z+1/4)', '(0, 1/2, -z+3/4)',
                            '(1/2, 1/2, -z)', '(0, 0, -z+1/2)',
                            '(0, 1/2, -z+1/4)', '(1/2, 0, -z+3/4)',
                            '(0, 0, -z)', '(1/2, 1/2, -z+1/2)',
                            '(1/2, 1/2, z)', '(0, 0, z+1/2)',
                            '(1/2, 0, z+1/4)', '(0, 1/2, z+3/4)'),
                        'hkl: 2h+l=4n'),
                '16e': (2, ('(1/4, y, 1/8)', '(3/4, y+1/2, 5/8)',
                            '(1/4, -y+1/2, 5/8)', '(3/4, -y, 1/8)',
                            '(-y, 3/4, 3/8)', '(-y+1/2, 1/4, 7/8)',
                            '(y+1/2, 3/4, 7/8)', '(y, 1/4, 3/8)',
                            '(3/4, -y+1/2, 1/8)', '(1/4, -y, 5/8)',
                            '(3/4, y, 5/8)', '(1/4, y+1/2, 1/8)',
                            '(y, 3/4, 7/8)', '(y+1/2, 1/4, 3/8)',
                            '(-y+1/2, 3/4, 3/8)', '(-y, 1/4, 7/8)'),
                        'hkl: l=2n+1 or h=2n'),
                '16f': (1, ('(x, x, 1/4)', '(x+1/2, x+1/2, 3/4)',
                            '(-x+1/2, -x+1/2, 3/4)', '(-x, -x, 1/4)',
                            '(-x, x+1/2, 1/2)', '(-x+1/2, x, 0)',
                            '(x+1/2, -x, 0)', '(x, -x+1/2, 1/2)',
                            '(-x, -x+1/2, 0)', '(-x+1/2, -x, 1/2)',
                            '(x+1/2, x, 1/2)', '(x, x+1/2, 0)',
                            '(x, -x, 3/4)', '(x+1/2, -x+1/2, 1/4)',
                            '(-x+1/2, x+1/2, 1/4)', '(-x, x, 3/4)'),
                        'hkl: l=2n+1 or 2h+l=4n'),
                '32g': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)',
                            '(-x+1/2, -y+1/2, z+1/2)', '(-x, -y, z)',
                            '(-y, x+1/2, z+1/4)', '(-y+1/2, x, z+3/4)',
                            '(y+1/2, -x, z+3/4)', '(y, -x+1/2, z+1/4)',
                            '(-x+1/2, y, -z+1/4)', '(-x, y+1/2, -z+3/4)',
                            '(x, -y+1/2, -z+3/4)', '(x+1/2, -y, -z+1/4)',
                            '(y+1/2, x+1/2, -z)', '(y, x, -z+1/2)',
                            '(-y, -x, -z+1/2)', '(-y+1/2, -x+1/2, -z)',
                            '(-x, -y+1/2, -z+1/4)', '(-x+1/2, -y, -z+3/4)',
                            '(x+1/2, y, -z+3/4)', '(x, y+1/2, -z+1/4)',
                            '(y, -x, -z)', '(y+1/2, -x+1/2, -z+1/2)',
                            '(-y+1/2, x+1/2, -z+1/2)', '(-y, x, -z)',
                            '(x+1/2, -y+1/2, z)', '(x, -y, z+1/2)',
                            '(-x, y, z+1/2)', '(-x+1/2, y+1/2, z)',
                            '(-y+1/2, -x, z+1/4)', '(-y, -x+1/2, z+3/4)',
                            '(y, x+1/2, z+3/4)', '(y+1/2, x, z+1/4)'),
                        'hkl: h+k+l=2n, hk0: h,k=2n, 0kl: k,l=2n, '
                        'hhl: 2h+l=4n, 00l: l=4n, h00: h=2n, h-h0: h=2n')},
      '142:2': {'8a': (0, ('(0, 1/4, 3/8)', '(1/2, 3/4, 7/8)',
                           '(0, 3/4, 5/8)', '(1/2, 1/4, 1/8)',
                           '(1/2, 1/4, 5/8)', '(0, 3/4, 1/8)',
                           '(1/2, 3/4, 3/8)', '(0, 1/4, 7/8)'), 'n/a'),
                '8b': (0, ('(0, 1/4, 1/8)', '(1/2, 3/4, 5/8)',
                           '(0, 3/4, 3/8)', '(1/2, 1/4, 7/8)',
                           '(0, 3/4, 7/8)', '(1/2, 1/4, 3/8)',
                           '(0, 1/4, 5/8)', '(1/2, 3/4, 1/8)'), 'n/a'),
                '16c': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)', '(1/2, 0, 1/2)',
                            '(0, 1/2, 0)', '(1/4, 3/4, 1/4)',
                            '(3/4, 1/4, 3/4)', '(1/4, 1/4, 3/4)',
                            '(3/4, 3/4, 1/4)', '(1/2, 0, 0)', '(0, 1/2, 1/2)',
                            '(0, 0, 1/2)', '(1/2, 1/2, 0)', '(1/4, 3/4, 3/4)',
                            '(3/4, 1/4, 1/4)', '(1/4, 1/4, 1/4)',
                            '(3/4, 3/4, 3/4)'), 'n/a'),
                '16d': (4, ('(0, 1/4, z)', '(1/2, 3/4, z+1/2)',
                            '(0, 3/4, z+1/4)', '(1/2, 1/4, z+3/4)',
                            '(1/2, 1/4, -z)', '(0, 3/4, -z+1/2)',
                            '(1/2, 3/4, -z+3/4)', '(0, 1/4, -z+1/4)',
                            '(0, 3/4, -z)', '(1/2, 1/4, -z+1/2)',
                            '(0, 1/4, -z+3/4)', '(1/2, 3/4, -z+1/4)',
                            '(1/2, 3/4, z)', '(0, 1/4, z+1/2)',
                            '(1/2, 1/4, z+1/4)', '(0, 3/4, z+3/4)'), 'n/a'),
                '16e': (1, ('(x, 0, 1/4)', '(x+1/2, 1/2, 3/4)',
                            '(-x+1/2, 0, 3/4)', '(-x, 1/2, 1/4)',
                            '(1/4, x+3/4, 1/2)', '(3/4, x+1/4, 0)',
                            '(1/4, -x+1/4, 0)', '(3/4, -x+3/4, 1/2)',
                            '(-x, 0, 3/4)', '(-x+1/2, 1/2, 1/4)',
                            '(x+1/2, 0, 1/4)', '(x, 1/2, 3/4)',
                            '(3/4, -x+1/4, 1/2)', '(1/4, -x+3/4, 0)',
                            '(3/4, x+3/4, 0)', '(1/4, x+1/4, 1/2)'), 'n/a'),
                '16f': (1, ('(x, x+1/4, 1/8)', '(x+1/2, x+3/4, 5/8)',
                            '(-x+1/2, -x+3/4, 5/8)', '(-x, -x+1/4, 1/8)',
                            '(-x, x+3/4, 3/8)', '(-x+1/2, x+1/4, 7/8)',
                            '(x+1/2, -x+1/4, 7/8)', '(x, -x+3/4, 3/8)',
                            '(-x, -x+3/4, 7/8)', '(-x+1/2, -x+1/4, 3/8)',
                            '(x+1/2, x+1/4, 3/8)', '(x, x+3/4, 7/8)',
                            '(x, -x+1/4, 5/8)', '(x+1/2, -x+3/4, 1/8)',
                            '(-x+1/2, x+3/4, 1/8)', '(-x, x+1/4, 5/8)'), 'n/a'
                        ),
                '32g': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)',
                            '(-x+1/2, -y, z+1/2)', '(-x, -y+1/2, z)',
                            '(-y+1/4, x+3/4, z+1/4)',
                            '(-y+3/4, x+1/4, z+3/4)',
                            '(y+1/4, -x+1/4, z+3/4)',
                            '(y+3/4, -x+3/4, z+1/4)', '(-x+1/2, y, -z)',
                            '(-x, y+1/2, -z+1/2)', '(x, -y, -z+1/2)',
                            '(x+1/2, -y+1/2, -z)', '(y+1/4, x+3/4, -z+3/4)',
                            '(y+3/4, x+1/4, -z+1/4)',
                            '(-y+1/4, -x+1/4, -z+1/4)',
                            '(-y+3/4, -x+3/4, -z+3/4)', '(-x, -y, -z)',
                            '(-x+1/2, -y+1/2, -z+1/2)', '(x+1/2, y, -z+1/2)',
                            '(x, y+1/2, -z)', '(y+3/4, -x+1/4, -z+3/4)',
                            '(y+1/4, -x+3/4, -z+1/4)',
                            '(-y+3/4, x+3/4, -z+1/4)',
                            '(-y+1/4, x+1/4, -z+3/4)', '(x+1/2, -y, z)',
                            '(x, -y+1/2, z+1/2)', '(-x, y, z+1/2)',
                            '(-x+1/2, y+1/2, z)', '(-y+3/4, -x+1/4, z+1/4)',
                            '(-y+1/4, -x+3/4, z+3/4)',
                            '(y+3/4, x+3/4, z+3/4)', '(y+1/4, x+1/4, z+1/4)'),
                        'n/a')},
      '143': {'1a': (4, ('(0, 0, z)', ), None),
              '1b': (4, ('(1/3, 2/3, z)', ), None),
              '1c': (4, ('(2/3, 1/3, z)', ), None),
              '3d': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)'), None
                     )},
      '144': {'3a': (7, ('(x, y, z)', '(-y, x-y, z+1/3)', '(-x+y, -x, z+2/3)'
                         ), '000l: l=3n')},
      '145': {'3a': (7, ('(x, y, z)', '(-y, x-y, z+2/3)', '(-x+y, -x, z+1/3)'
                         ), '000l: l=3n')},
      '146:H': {'3a': (4, ('(0, 0, z)', '(2/3, 1/3, z+1/3)',
                           '(1/3, 2/3, z+2/3)'), None),
                '9b': (7, ('(x, y, z)', '(x+2/3, y+1/3, z+1/3)',
                           '(x+1/3, y+2/3, z+2/3)', '(-y, x-y, z)',
                           '(-y+2/3, x-y+1/3, z+1/3)',
                           '(-y+1/3, x-y+2/3, z+2/3)', '(-x+y, -x, z)',
                           '(-x+y+2/3, -x+1/3, z+1/3)',
                           '(-x+y+1/3, -x+2/3, z+2/3)'),
                       'hkil: -h+k+l=3n, hki0: -h+k=3n, hh(-2h)l: l=3n, '
                       'h-h0l: h+l=3n, 000l: l=3n, h-h00: h=3n')},
      '146:R': {'1a': (1, ('(x, x, x)', ), 'n/a'),
                '3b': (7, ('(x, y, z)', '(z, x, y)', '(y, z, x)'), 'n/a')},
      '147': {'1a': (0, ('(0, 0, 0)', ), None),
              '1b': (0, ('(0, 0, 1/2)', ), None),
              '2c': (4, ('(0, 0, z)', '(0, 0, -z)'), None),
              '2d': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, -z)'), None),
              '3e': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(1/2, 1/2, 0)'), None
                     ),
              '3f': (0, ('(1/2, 0, 1/2)', '(0, 1/2, 1/2)', '(1/2, 1/2, 1/2)'),
                     None),
              '6g': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                         '(-x, -y, -z)', '(y, -x+y, -z)', '(x-y, x, -z)'), None
                     )},
      '148:H': {'3a': (0, ('(0, 0, 0)', '(2/3, 1/3, 1/3)', '(1/3, 2/3, 2/3)'),
                       None),
                '3b': (0, ('(0, 0, 1/2)', '(2/3, 1/3, 5/6)',
                           '(1/3, 2/3, 1/6)'), None),
                '6c': (4, ('(0, 0, z)', '(2/3, 1/3, z+1/3)',
                           '(1/3, 2/3, z+2/3)', '(0, 0, -z)',
                           '(2/3, 1/3, -z+1/3)', '(1/3, 2/3, -z+2/3)'), None),
                '9d': (0, ('(1/2, 0, 1/2)', '(1/6, 1/3, 5/6)',
                           '(5/6, 2/3, 1/6)', '(0, 1/2, 1/2)',
                           '(2/3, 5/6, 5/6)', '(1/3, 1/6, 1/6)',
                           '(1/2, 1/2, 1/2)', '(1/6, 5/6, 5/6)',
                           '(5/6, 1/6, 1/6)'), None),
                '9e': (0, ('(1/2, 0, 0)', '(1/6, 1/3, 1/3)',
                           '(5/6, 2/3, 2/3)', '(0, 1/2, 0)',
                           '(2/3, 5/6, 1/3)', '(1/3, 1/6, 2/3)',
                           '(1/2, 1/2, 0)', '(1/6, 5/6, 1/3)',
                           '(5/6, 1/6, 2/3)'), None),
                '18f': (7, ('(x, y, z)', '(x+2/3, y+1/3, z+1/3)',
                            '(x+1/3, y+2/3, z+2/3)', '(-y, x-y, z)',
                            '(-y+2/3, x-y+1/3, z+1/3)',
                            '(-y+1/3, x-y+2/3, z+2/3)', '(-x+y, -x, z)',
                            '(-x+y+2/3, -x+1/3, z+1/3)',
                            '(-x+y+1/3, -x+2/3, z+2/3)', '(-x, -y, -z)',
                            '(-x+2/3, -y+1/3, -z+1/3)',
                            '(-x+1/3, -y+2/3, -z+2/3)', '(y, -x+y, -z)',
                            '(y+2/3, -x+y+1/3, -z+1/3)',
                            '(y+1/3, -x+y+2/3, -z+2/3)', '(x-y, x, -z)',
                            '(x-y+2/3, x+1/3, -z+1/3)',
                            '(x-y+1/3, x+2/3, -z+2/3)'),
                        'hkil: -h+k+l=3n, hki0: -h+k=3n, hh(-2h)l: l=3n, '
                        'h-h0l: h+l=3n, 000l: l=3n, h-h00: h=3n')},
      '148:R': {'1a': (0, ('(0, 0, 0)', ), 'n/a'),
                '1b': (0, ('(1/2, 1/2, 1/2)', ), 'n/a'),
                '2c': (1, ('(x, x, x)', '(-x, -x, -x)'), 'n/a'),
                '3d': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(0, 0, 1/2)'), 'n/a'
                       ),
                '3e': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)', '(1/2, 1/2, 0)'),
                       'n/a'),
                '6f': (7, ('(x, y, z)', '(z, x, y)', '(y, z, x)',
                           '(-x, -y, -z)', '(-z, -x, -y)', '(-y, -z, -x)'),
                       'n/a')},
      '149': {'1a': (0, ('(0, 0, 0)', ), None),
              '1b': (0, ('(0, 0, 1/2)', ), None),
              '1c': (0, ('(1/3, 2/3, 0)', ), None),
              '1d': (0, ('(1/3, 2/3, 1/2)', ), None),
              '1e': (0, ('(2/3, 1/3, 0)', ), None),
              '1f': (0, ('(2/3, 1/3, 1/2)', ), None),
              '2g': (4, ('(0, 0, z)', '(0, 0, -z)'), None),
              '2h': (4, ('(1/3, 2/3, z)', '(1/3, 2/3, -z)'), None),
              '2i': (4, ('(2/3, 1/3, z)', '(2/3, 1/3, -z)'), None),
              '3j': (1, ('(x, -x, 0)', '(x, 2*x, 0)', '(-2*x, -x, 0)'), None),
              '3k': (1, ('(x, -x, 1/2)', '(x, 2*x, 1/2)', '(-2*x, -x, 1/2)'),
                     None),
              '6l': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                         '(-y, -x, -z)', '(-x+y, y, -z)', '(x, x-y, -z)'), None
                     )},
      '150': {'1a': (0, ('(0, 0, 0)', ), None),
              '1b': (0, ('(0, 0, 1/2)', ), None),
              '2c': (4, ('(0, 0, z)', '(0, 0, -z)'), None),
              '2d': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, -z)'), None),
              '3e': (1, ('(x, 0, 0)', '(0, x, 0)', '(-x, -x, 0)'), None),
              '3f': (1, ('(x, 0, 1/2)', '(0, x, 1/2)', '(-x, -x, 1/2)'), None
                     ),
              '6g': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                         '(y, x, -z)', '(x-y, -y, -z)', '(-x, -x+y, -z)'), None
                     )},
      '151': {'3a': (1, ('(x, -x, 1/3)', '(x, 2*x, 2/3)', '(-2*x, -x, 0)'),
                     None),
              '3b': (1, ('(x, -x, 5/6)', '(x, 2*x, 1/6)', '(-2*x, -x, 1/2)'),
                     None),
              '6c': (7, ('(x, y, z)', '(-y, x-y, z+1/3)', '(-x+y, -x, z+2/3)',
                         '(-y, -x, -z+2/3)', '(-x+y, y, -z+1/3)',
                         '(x, x-y, -z)'), '000l: l=3n')},
      '152': {'3a': (1, ('(x, 0, 1/3)', '(0, x, 2/3)', '(-x, -x, 0)'), None),
              '3b': (1, ('(x, 0, 5/6)', '(0, x, 1/6)', '(-x, -x, 1/2)'), None
                     ),
              '6c': (7, ('(x, y, z)', '(-y, x-y, z+1/3)', '(-x+y, -x, z+2/3)',
                         '(y, x, -z)', '(x-y, -y, -z+2/3)',
                         '(-x, -x+y, -z+1/3)'), '000l: l=3n')},
      '153': {'3a': (1, ('(x, -x, 2/3)', '(x, 2*x, 1/3)', '(-2*x, -x, 0)'),
                     None),
              '3b': (1, ('(x, -x, 1/6)', '(x, 2*x, 5/6)', '(-2*x, -x, 1/2)'),
                     None),
              '6c': (7, ('(x, y, z)', '(-y, x-y, z+2/3)', '(-x+y, -x, z+1/3)',
                         '(-y, -x, -z+1/3)', '(-x+y, y, -z+2/3)',
                         '(x, x-y, -z)'), '000l: l=3n')},
      '154': {'3a': (1, ('(x, 0, 2/3)', '(0, x, 1/3)', '(-x, -x, 0)'), None),
              '3b': (1, ('(x, 0, 1/6)', '(0, x, 5/6)', '(-x, -x, 1/2)'), None
                     ),
              '6c': (7, ('(x, y, z)', '(-y, x-y, z+2/3)', '(-x+y, -x, z+1/3)',
                         '(y, x, -z)', '(x-y, -y, -z+1/3)',
                         '(-x, -x+y, -z+2/3)'), '000l: l=3n')},
      '155:H': {'3a': (0, ('(0, 0, 0)', '(2/3, 1/3, 1/3)', '(1/3, 2/3, 2/3)'),
                       None),
                '3b': (0, ('(0, 0, 1/2)', '(2/3, 1/3, 5/6)',
                           '(1/3, 2/3, 1/6)'), None),
                '6c': (4, ('(0, 0, z)', '(2/3, 1/3, z+1/3)',
                           '(1/3, 2/3, z+2/3)', '(0, 0, -z)',
                           '(2/3, 1/3, -z+1/3)', '(1/3, 2/3, -z+2/3)'), None),
                '9d': (1, ('(x, 0, 0)', '(x+2/3, 1/3, 1/3)',
                           '(x+1/3, 2/3, 2/3)', '(0, x, 0)',
                           '(2/3, x+1/3, 1/3)', '(1/3, x+2/3, 2/3)',
                           '(-x, -x, 0)', '(-x+2/3, -x+1/3, 1/3)',
                           '(-x+1/3, -x+2/3, 2/3)'), None),
                '9e': (1, ('(x, 0, 1/2)', '(x+2/3, 1/3, 5/6)',
                           '(x+1/3, 2/3, 1/6)', '(0, x, 1/2)',
                           '(2/3, x+1/3, 5/6)', '(1/3, x+2/3, 1/6)',
                           '(-x, -x, 1/2)', '(-x+2/3, -x+1/3, 5/6)',
                           '(-x+1/3, -x+2/3, 1/6)'), None),
                '18f': (7, ('(x, y, z)', '(x+2/3, y+1/3, z+1/3)',
                            '(x+1/3, y+2/3, z+2/3)', '(-y, x-y, z)',
                            '(-y+2/3, x-y+1/3, z+1/3)',
                            '(-y+1/3, x-y+2/3, z+2/3)', '(-x+y, -x, z)',
                            '(-x+y+2/3, -x+1/3, z+1/3)',
                            '(-x+y+1/3, -x+2/3, z+2/3)', '(y, x, -z)',
                            '(y+2/3, x+1/3, -z+1/3)',
                            '(y+1/3, x+2/3, -z+2/3)', '(x-y, -y, -z)',
                            '(x-y+2/3, -y+1/3, -z+1/3)',
                            '(x-y+1/3, -y+2/3, -z+2/3)', '(-x, -x+y, -z)',
                            '(-x+2/3, -x+y+1/3, -z+1/3)',
                            '(-x+1/3, -x+y+2/3, -z+2/3)'),
                        'hkil: -h+k+l=3n, hki0: -h+k=3n, hh(-2h)l: l=3n, '
                        'h-h0l: h+l=3n, 000l: l=3n, h-h00: h=3n')},
      '155:R': {'1a': (0, ('(0, 0, 0)', ), 'n/a'),
                '1b': (0, ('(1/2, 1/2, 1/2)', ), 'n/a'),
                '2c': (1, ('(x, x, x)', '(-x, -x, -x)'), 'n/a'),
                '3d': (2, ('(0, y, -y)', '(-y, 0, y)', '(y, -y, 0)'), 'n/a'),
                '3e': (2, ('(1/2, y, -y)', '(-y, 1/2, y)', '(y, -y, 1/2)'),
                       'n/a'),
                '6f': (7, ('(x, y, z)', '(z, x, y)', '(y, z, x)',
                           '(-z, -y, -x)', '(-y, -x, -z)', '(-x, -z, -y)'),
                       'n/a')},
      '156': {'1a': (4, ('(0, 0, z)', ), None),
              '1b': (4, ('(1/3, 2/3, z)', ), None),
              '1c': (4, ('(2/3, 1/3, z)', ), None),
              '3d': (5, ('(x, -x, z)', '(x, 2*x, z)', '(-2*x, -x, z)'), None),
              '6e': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                         '(-y, -x, z)', '(-x+y, y, z)', '(x, x-y, z)'), None
                     )},
      '157': {'1a': (4, ('(0, 0, z)', ), None),
              '2b': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, z)'), None),
              '3c': (5, ('(x, 0, z)', '(0, x, z)', '(-x, -x, z)'), None),
              '6d': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                         '(y, x, z)', '(x-y, -y, z)', '(-x, -x+y, z)'), None
                     )},
      '158': {'2a': (4, ('(0, 0, z)', '(0, 0, z+1/2)'), 'hkil: l=2n'),
              '2b': (4, ('(1/3, 2/3, z)', '(1/3, 2/3, z+1/2)'), 'hkil: l=2n'),
              '2c': (4, ('(2/3, 1/3, z)', '(2/3, 1/3, z+1/2)'), 'hkil: l=2n'),
              '6d': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                         '(-y, -x, z+1/2)', '(-x+y, y, z+1/2)',
                         '(x, x-y, z+1/2)'), 'h-h0l: l=2n, 000l: l=2n')},
      '159': {'2a': (4, ('(0, 0, z)', '(0, 0, z+1/2)'), 'hkil: l=2n'),
              '2b': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, z+1/2)'),
                     'hkil: l=2n or h-k=3n+1 or h-k=3n+2'),
              '6c': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                         '(y, x, z+1/2)', '(x-y, -y, z+1/2)',
                         '(-x, -x+y, z+1/2)'), 'hh(-2h)l: l=2n, 000l: l=2n')},
      '160:H': {'3a': (4, ('(0, 0, z)', '(2/3, 1/3, z+1/3)',
                           '(1/3, 2/3, z+2/3)'), None),
                '9b': (5, ('(x, -x, z)', '(x+2/3, -x+1/3, z+1/3)',
                           '(x+1/3, -x+2/3, z+2/3)', '(x, 2*x, z)',
                           '(x+2/3, 2*x+1/3, z+1/3)',
                           '(x+1/3, 2*x+2/3, z+2/3)', '(-2*x, -x, z)',
                           '(-2*x+2/3, -x+1/3, z+1/3)',
                           '(-2*x+1/3, -x+2/3, z+2/3)'), None),
                '18c': (7, ('(x, y, z)', '(x+2/3, y+1/3, z+1/3)',
                            '(x+1/3, y+2/3, z+2/3)', '(-y, x-y, z)',
                            '(-y+2/3, x-y+1/3, z+1/3)',
                            '(-y+1/3, x-y+2/3, z+2/3)', '(-x+y, -x, z)',
                            '(-x+y+2/3, -x+1/3, z+1/3)',
                            '(-x+y+1/3, -x+2/3, z+2/3)', '(-y, -x, z)',
                            '(-y+2/3, -x+1/3, z+1/3)',
                            '(-y+1/3, -x+2/3, z+2/3)', '(-x+y, y, z)',
                            '(-x+y+2/3, y+1/3, z+1/3)',
                            '(-x+y+1/3, y+2/3, z+2/3)', '(x, x-y, z)',
                            '(x+2/3, x-y+1/3, z+1/3)',
                            '(x+1/3, x-y+2/3, z+2/3)'),
                        'hkil: -h+k+l=3n, hki0: -h+k=3n, hh(-2h)l: l=3n, '
                        'h-h0l: h+l=3n, 000l: l=3n, h-h00: h=3n')},
      '160:R': {'1a': (1, ('(x, x, x)', ), 'n/a'),
                '3b': (5, ('(x, x, z)', '(z, x, x)', '(x, z, x)'), 'n/a'),
                '6c': (7, ('(x, y, z)', '(z, x, y)', '(y, z, x)', '(z, y, x)',
                           '(y, x, z)', '(x, z, y)'), 'n/a')},
      '161:H': {'6a': (4, ('(0, 0, z)', '(2/3, 1/3, z+1/3)',
                           '(1/3, 2/3, z+2/3)', '(0, 0, z+1/2)',
                           '(2/3, 1/3, z+5/6)', '(1/3, 2/3, z+1/6)'),
                       'hkil: l=2n'),
                '18b': (7, ('(x, y, z)', '(x+2/3, y+1/3, z+1/3)',
                            '(x+1/3, y+2/3, z+2/3)', '(-y, x-y, z)',
                            '(-y+2/3, x-y+1/3, z+1/3)',
                            '(-y+1/3, x-y+2/3, z+2/3)', '(-x+y, -x, z)',
                            '(-x+y+2/3, -x+1/3, z+1/3)',
                            '(-x+y+1/3, -x+2/3, z+2/3)', '(-y, -x, z+1/2)',
                            '(-y+2/3, -x+1/3, z+5/6)',
                            '(-y+1/3, -x+2/3, z+1/6)', '(-x+y, y, z+1/2)',
                            '(-x+y+2/3, y+1/3, z+5/6)',
                            '(-x+y+1/3, y+2/3, z+1/6)', '(x, x-y, z+1/2)',
                            '(x+2/3, x-y+1/3, z+5/6)',
                            '(x+1/3, x-y+2/3, z+1/6)'),
                        'hkil: -h+k+l=3n, hki0: -h+k=3n, hh(-2h)l: l=3n, '
                        'h-h0l: h+l=3n, l=2n, 000l: l=6n, h-h00: h=3n')},
      '161:R': {'2a': (1, ('(x, x, x)', '(x+1/2, x+1/2, x+1/2)'), 'n/a'),
                '6b': (7, ('(x, y, z)', '(z, x, y)', '(y, z, x)',
                           '(z+1/2, y+1/2, x+1/2)', '(y+1/2, x+1/2, z+1/2)',
                           '(x+1/2, z+1/2, y+1/2)'), 'n/a')},
      '162': {'1a': (0, ('(0, 0, 0)', ), None),
              '1b': (0, ('(0, 0, 1/2)', ), None),
              '2c': (0, ('(1/3, 2/3, 0)', '(2/3, 1/3, 0)'), None),
              '2d': (0, ('(1/3, 2/3, 1/2)', '(2/3, 1/3, 1/2)'), None),
              '2e': (4, ('(0, 0, z)', '(0, 0, -z)'), None),
              '3f': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(1/2, 1/2, 0)'), None
                     ),
              '3g': (0, ('(1/2, 0, 1/2)', '(0, 1/2, 1/2)', '(1/2, 1/2, 1/2)'),
                     None),
              '4h': (4, ('(1/3, 2/3, z)', '(1/3, 2/3, -z)', '(2/3, 1/3, -z)',
                         '(2/3, 1/3, z)'), None),
              '6i': (1, ('(x, -x, 0)', '(x, 2*x, 0)', '(-2*x, -x, 0)',
                         '(-x, x, 0)', '(-x, -2*x, 0)', '(2*x, x, 0)'), None),
              '6j': (1, ('(x, -x, 1/2)', '(x, 2*x, 1/2)', '(-2*x, -x, 1/2)',
                         '(-x, x, 1/2)', '(-x, -2*x, 1/2)', '(2*x, x, 1/2)'),
                     None),
              '6k': (5, ('(x, 0, z)', '(0, x, z)', '(-x, -x, z)',
                         '(0, -x, -z)', '(-x, 0, -z)', '(x, x, -z)'), None),
              '12l': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(-y, -x, -z)', '(-x+y, y, -z)', '(x, x-y, -z)',
                          '(-x, -y, -z)', '(y, -x+y, -z)', '(x-y, x, -z)',
                          '(y, x, z)', '(x-y, -y, z)', '(-x, -x+y, z)'), None
                      )},
      '163': {'2a': (0, ('(0, 0, 1/4)', '(0, 0, 3/4)'), 'hkil: l=2n'),
              '2b': (0, ('(0, 0, 0)', '(0, 0, 1/2)'), 'hkil: l=2n'),
              '2c': (0, ('(1/3, 2/3, 1/4)', '(2/3, 1/3, 3/4)'),
                     'hkil: l=2n or h-k=3n+1 or h-k=3n+2'),
              '2d': (0, ('(2/3, 1/3, 1/4)', '(1/3, 2/3, 3/4)'),
                     'hkil: l=2n or h-k=3n+1 or h-k=3n+2'),
              '4e': (4, ('(0, 0, z)', '(0, 0, -z+1/2)', '(0, 0, -z)',
                         '(0, 0, z+1/2)'), 'hkil: l=2n'),
              '4f': (4, ('(1/3, 2/3, z)', '(1/3, 2/3, -z+1/2)',
                         '(2/3, 1/3, -z)', '(2/3, 1/3, z+1/2)'),
                     'hkil: l=2n or h-k=3n+1 or h-k=3n+2'),
              '6g': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(1/2, 1/2, 0)',
                         '(0, 1/2, 1/2)', '(1/2, 0, 1/2)', '(1/2, 1/2, 1/2)'),
                     'hkil: l=2n'),
              '6h': (1, ('(x, -x, 1/4)', '(x, 2*x, 1/4)', '(-2*x, -x, 1/4)',
                         '(-x, x, 3/4)', '(-x, -2*x, 3/4)', '(2*x, x, 3/4)'),
                     None),
              '12i': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(-y, -x, -z+1/2)', '(-x+y, y, -z+1/2)',
                          '(x, x-y, -z+1/2)', '(-x, -y, -z)', '(y, -x+y, -z)',
                          '(x-y, x, -z)', '(y, x, z+1/2)', '(x-y, -y, z+1/2)',
                          '(-x, -x+y, z+1/2)'), 'hh(-2h)l: l=2n, 000l: l=2n'
                      )},
      '164': {'1a': (0, ('(0, 0, 0)', ), None),
              '1b': (0, ('(0, 0, 1/2)', ), None),
              '2c': (4, ('(0, 0, z)', '(0, 0, -z)'), None),
              '2d': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, -z)'), None),
              '3e': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(1/2, 1/2, 0)'), None
                     ),
              '3f': (0, ('(1/2, 0, 1/2)', '(0, 1/2, 1/2)', '(1/2, 1/2, 1/2)'),
                     None),
              '6g': (1, ('(x, 0, 0)', '(0, x, 0)', '(-x, -x, 0)',
                         '(-x, 0, 0)', '(0, -x, 0)', '(x, x, 0)'), None),
              '6h': (1, ('(x, 0, 1/2)', '(0, x, 1/2)', '(-x, -x, 1/2)',
                         '(-x, 0, 1/2)', '(0, -x, 1/2)', '(x, x, 1/2)'), None
                     ),
              '6i': (5, ('(x, -x, z)', '(x, 2*x, z)', '(-2*x, -x, z)',
                         '(-x, x, -z)', '(2*x, x, -z)', '(-x, -2*x, -z)'), None
                     ),
              '12j': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(y, x, -z)', '(x-y, -y, -z)', '(-x, -x+y, -z)',
                          '(-x, -y, -z)', '(y, -x+y, -z)', '(x-y, x, -z)',
                          '(-y, -x, z)', '(-x+y, y, z)', '(x, x-y, z)'), None
                      )},
      '165': {'2a': (0, ('(0, 0, 1/4)', '(0, 0, 3/4)'), 'hkil: l=2n'),
              '2b': (0, ('(0, 0, 0)', '(0, 0, 1/2)'), 'hkil: l=2n'),
              '4c': (4, ('(0, 0, z)', '(0, 0, -z+1/2)', '(0, 0, -z)',
                         '(0, 0, z+1/2)'), 'hkil: l=2n'),
              '4d': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, -z+1/2)',
                         '(2/3, 1/3, -z)', '(1/3, 2/3, z+1/2)'), 'hkil: l=2n'
                     ),
              '6e': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(1/2, 1/2, 0)',
                         '(0, 1/2, 1/2)', '(1/2, 0, 1/2)', '(1/2, 1/2, 1/2)'),
                     'hkil: l=2n'),
              '6f': (1, ('(x, 0, 1/4)', '(0, x, 1/4)', '(-x, -x, 1/4)',
                         '(-x, 0, 3/4)', '(0, -x, 3/4)', '(x, x, 3/4)'), None
                     ),
              '12g': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(y, x, -z+1/2)', '(x-y, -y, -z+1/2)',
                          '(-x, -x+y, -z+1/2)', '(-x, -y, -z)',
                          '(y, -x+y, -z)', '(x-y, x, -z)', '(-y, -x, z+1/2)',
                          '(-x+y, y, z+1/2)', '(x, x-y, z+1/2)'),
                      'h-h0l: l=2n, 000l: l=2n')},
      '166:H': {'3a': (0, ('(0, 0, 0)', '(2/3, 1/3, 1/3)', '(1/3, 2/3, 2/3)'),
                       None),
                '3b': (0, ('(0, 0, 1/2)', '(2/3, 1/3, 5/6)',
                           '(1/3, 2/3, 1/6)'), None),
                '6c': (4, ('(0, 0, z)', '(2/3, 1/3, z+1/3)',
                           '(1/3, 2/3, z+2/3)', '(0, 0, -z)',
                           '(2/3, 1/3, -z+1/3)', '(1/3, 2/3, -z+2/3)'), None),
                '9d': (0, ('(1/2, 0, 1/2)', '(1/6, 1/3, 5/6)',
                           '(5/6, 2/3, 1/6)', '(0, 1/2, 1/2)',
                           '(2/3, 5/6, 5/6)', '(1/3, 1/6, 1/6)',
                           '(1/2, 1/2, 1/2)', '(1/6, 5/6, 5/6)',
                           '(5/6, 1/6, 1/6)'), None),
                '9e': (0, ('(1/2, 0, 0)', '(1/6, 1/3, 1/3)',
                           '(5/6, 2/3, 2/3)', '(0, 1/2, 0)',
                           '(2/3, 5/6, 1/3)', '(1/3, 1/6, 2/3)',
                           '(1/2, 1/2, 0)', '(1/6, 5/6, 1/3)',
                           '(5/6, 1/6, 2/3)'), None),
                '18f': (1, ('(x, 0, 0)', '(x+2/3, 1/3, 1/3)',
                            '(x+1/3, 2/3, 2/3)', '(0, x, 0)',
                            '(2/3, x+1/3, 1/3)', '(1/3, x+2/3, 2/3)',
                            '(-x, -x, 0)', '(-x+2/3, -x+1/3, 1/3)',
                            '(-x+1/3, -x+2/3, 2/3)', '(-x, 0, 0)',
                            '(-x+2/3, 1/3, 1/3)', '(-x+1/3, 2/3, 2/3)',
                            '(0, -x, 0)', '(2/3, -x+1/3, 1/3)',
                            '(1/3, -x+2/3, 2/3)', '(x, x, 0)',
                            '(x+2/3, x+1/3, 1/3)', '(x+1/3, x+2/3, 2/3)'), None
                        ),
                '18g': (1, ('(x, 0, 1/2)', '(x+2/3, 1/3, 5/6)',
                            '(x+1/3, 2/3, 1/6)', '(0, x, 1/2)',
                            '(2/3, x+1/3, 5/6)', '(1/3, x+2/3, 1/6)',
                            '(-x, -x, 1/2)', '(-x+2/3, -x+1/3, 5/6)',
                            '(-x+1/3, -x+2/3, 1/6)', '(-x, 0, 1/2)',
                            '(-x+2/3, 1/3, 5/6)', '(-x+1/3, 2/3, 1/6)',
                            '(0, -x, 1/2)', '(2/3, -x+1/3, 5/6)',
                            '(1/3, -x+2/3, 1/6)', '(x, x, 1/2)',
                            '(x+2/3, x+1/3, 5/6)', '(x+1/3, x+2/3, 1/6)'), None
                        ),
                '18h': (5, ('(x, -x, z)', '(x+2/3, -x+1/3, z+1/3)',
                            '(x+1/3, -x+2/3, z+2/3)', '(x, 2*x, z)',
                            '(x+2/3, 2*x+1/3, z+1/3)',
                            '(x+1/3, 2*x+2/3, z+2/3)', '(-2*x, -x, z)',
                            '(-2*x+2/3, -x+1/3, z+1/3)',
                            '(-2*x+1/3, -x+2/3, z+2/3)', '(-x, x, -z)',
                            '(-x+2/3, x+1/3, -z+1/3)',
                            '(-x+1/3, x+2/3, -z+2/3)', '(2*x, x, -z)',
                            '(2*x+2/3, x+1/3, -z+1/3)',
                            '(2*x+1/3, x+2/3, -z+2/3)', '(-x, -2*x, -z)',
                            '(-x+2/3, -2*x+1/3, -z+1/3)',
                            '(-x+1/3, -2*x+2/3, -z+2/3)'), None),
                '36i': (7, ('(x, y, z)', '(x+2/3, y+1/3, z+1/3)',
                            '(x+1/3, y+2/3, z+2/3)', '(-y, x-y, z)',
                            '(-y+2/3, x-y+1/3, z+1/3)',
                            '(-y+1/3, x-y+2/3, z+2/3)', '(-x+y, -x, z)',
                            '(-x+y+2/3, -x+1/3, z+1/3)',
                            '(-x+y+1/3, -x+2/3, z+2/3)', '(y, x, -z)',
                            '(y+2/3, x+1/3, -z+1/3)',
                            '(y+1/3, x+2/3, -z+2/3)', '(x-y, -y, -z)',
                            '(x-y+2/3, -y+1/3, -z+1/3)',
                            '(x-y+1/3, -y+2/3, -z+2/3)', '(-x, -x+y, -z)',
                            '(-x+2/3, -x+y+1/3, -z+1/3)',
                            '(-x+1/3, -x+y+2/3, -z+2/3)', '(-x, -y, -z)',
                            '(-x+2/3, -y+1/3, -z+1/3)',
                            '(-x+1/3, -y+2/3, -z+2/3)', '(y, -x+y, -z)',
                            '(y+2/3, -x+y+1/3, -z+1/3)',
                            '(y+1/3, -x+y+2/3, -z+2/3)', '(x-y, x, -z)',
                            '(x-y+2/3, x+1/3, -z+1/3)',
                            '(x-y+1/3, x+2/3, -z+2/3)', '(-y, -x, z)',
                            '(-y+2/3, -x+1/3, z+1/3)',
                            '(-y+1/3, -x+2/3, z+2/3)', '(-x+y, y, z)',
                            '(-x+y+2/3, y+1/3, z+1/3)',
                            '(-x+y+1/3, y+2/3, z+2/3)', '(x, x-y, z)',
                            '(x+2/3, x-y+1/3, z+1/3)',
                            '(x+1/3, x-y+2/3, z+2/3)'),
                        'hkil: -h+k+l=3n, hki0: -h+k=3n, hh(-2h)l: l=3n, '
                        'h-h0l: h+l=3n, 000l: l=3n, h-h00: h=3n')},
      '166:R': {'1a': (0, ('(0, 0, 0)', ), 'n/a'),
                '1b': (0, ('(1/2, 1/2, 1/2)', ), 'n/a'),
                '2c': (1, ('(x, x, x)', '(-x, -x, -x)'), 'n/a'),
                '3d': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(0, 0, 1/2)'), 'n/a'
                       ),
                '3e': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)', '(1/2, 1/2, 0)'),
                       'n/a'),
                '6f': (1, ('(x, -x, 0)', '(0, x, -x)', '(-x, 0, x)',
                           '(-x, x, 0)', '(0, -x, x)', '(x, 0, -x)'), 'n/a'),
                '6g': (1, ('(x, -x, 1/2)', '(1/2, x, -x)', '(-x, 1/2, x)',
                           '(-x, x, 1/2)', '(1/2, -x, x)', '(x, 1/2, -x)'),
                       'n/a'),
                '6h': (5, ('(x, x, z)', '(z, x, x)', '(x, z, x)',
                           '(-z, -x, -x)', '(-x, -x, -z)', '(-x, -z, -x)'),
                       'n/a'),
                '12i': (7, ('(x, y, z)', '(z, x, y)', '(y, z, x)',
                            '(-z, -y, -x)', '(-y, -x, -z)', '(-x, -z, -y)',
                            '(-x, -y, -z)', '(-z, -x, -y)', '(-y, -z, -x)',
                            '(z, y, x)', '(y, x, z)', '(x, z, y)'), 'n/a')},
      '167:H': {'6a': (0, ('(0, 0, 1/4)', '(2/3, 1/3, 7/12)',
                           '(1/3, 2/3, 11/12)', '(0, 0, 3/4)',
                           '(2/3, 1/3, 1/12)', '(1/3, 2/3, 5/12)'),
                       'hkil: l=2n'),
                '6b': (0, ('(0, 0, 0)', '(2/3, 1/3, 1/3)', '(1/3, 2/3, 2/3)',
                           '(0, 0, 1/2)', '(2/3, 1/3, 5/6)',
                           '(1/3, 2/3, 1/6)'), 'hkil: l=2n'),
                '12c': (4, ('(0, 0, z)', '(2/3, 1/3, z+1/3)',
                            '(1/3, 2/3, z+2/3)', '(0, 0, -z+1/2)',
                            '(2/3, 1/3, -z+5/6)', '(1/3, 2/3, -z+1/6)',
                            '(0, 0, -z)', '(2/3, 1/3, -z+1/3)',
                            '(1/3, 2/3, -z+2/3)', '(0, 0, z+1/2)',
                            '(2/3, 1/3, z+5/6)', '(1/3, 2/3, z+1/6)'),
                        'hkil: l=2n'),
                '18d': (0, ('(1/2, 0, 0)', '(1/6, 1/3, 1/3)',
                            '(5/6, 2/3, 2/3)', '(0, 1/2, 0)',
                            '(2/3, 5/6, 1/3)', '(1/3, 1/6, 2/3)',
                            '(1/2, 1/2, 0)', '(1/6, 5/6, 1/3)',
                            '(5/6, 1/6, 2/3)', '(0, 1/2, 1/2)',
                            '(2/3, 5/6, 5/6)', '(1/3, 1/6, 1/6)',
                            '(1/2, 0, 1/2)', '(1/6, 1/3, 5/6)',
                            '(5/6, 2/3, 1/6)', '(1/2, 1/2, 1/2)',
                            '(1/6, 5/6, 5/6)', '(5/6, 1/6, 1/6)'), 'hkil: l=2n'
                        ),
                '18e': (1, ('(x, 0, 1/4)', '(x+2/3, 1/3, 7/12)',
                            '(x+1/3, 2/3, 11/12)', '(0, x, 1/4)',
                            '(2/3, x+1/3, 7/12)', '(1/3, x+2/3, 11/12)',
                            '(-x, -x, 1/4)', '(-x+2/3, -x+1/3, 7/12)',
                            '(-x+1/3, -x+2/3, 11/12)', '(-x, 0, 3/4)',
                            '(-x+2/3, 1/3, 1/12)', '(-x+1/3, 2/3, 5/12)',
                            '(0, -x, 3/4)', '(2/3, -x+1/3, 1/12)',
                            '(1/3, -x+2/3, 5/12)', '(x, x, 3/4)',
                            '(x+2/3, x+1/3, 1/12)', '(x+1/3, x+2/3, 5/12)'),
                        None),
                '36f': (7, ('(x, y, z)', '(x+2/3, y+1/3, z+1/3)',
                            '(x+1/3, y+2/3, z+2/3)', '(-y, x-y, z)',
                            '(-y+2/3, x-y+1/3, z+1/3)',
                            '(-y+1/3, x-y+2/3, z+2/3)', '(-x+y, -x, z)',
                            '(-x+y+2/3, -x+1/3, z+1/3)',
                            '(-x+y+1/3, -x+2/3, z+2/3)', '(y, x, -z+1/2)',
                            '(y+2/3, x+1/3, -z+5/6)',
                            '(y+1/3, x+2/3, -z+1/6)', '(x-y, -y, -z+1/2)',
                            '(x-y+2/3, -y+1/3, -z+5/6)',
                            '(x-y+1/3, -y+2/3, -z+1/6)', '(-x, -x+y, -z+1/2)',
                            '(-x+2/3, -x+y+1/3, -z+5/6)',
                            '(-x+1/3, -x+y+2/3, -z+1/6)', '(-x, -y, -z)',
                            '(-x+2/3, -y+1/3, -z+1/3)',
                            '(-x+1/3, -y+2/3, -z+2/3)', '(y, -x+y, -z)',
                            '(y+2/3, -x+y+1/3, -z+1/3)',
                            '(y+1/3, -x+y+2/3, -z+2/3)', '(x-y, x, -z)',
                            '(x-y+2/3, x+1/3, -z+1/3)',
                            '(x-y+1/3, x+2/3, -z+2/3)', '(-y, -x, z+1/2)',
                            '(-y+2/3, -x+1/3, z+5/6)',
                            '(-y+1/3, -x+2/3, z+1/6)', '(-x+y, y, z+1/2)',
                            '(-x+y+2/3, y+1/3, z+5/6)',
                            '(-x+y+1/3, y+2/3, z+1/6)', '(x, x-y, z+1/2)',
                            '(x+2/3, x-y+1/3, z+5/6)',
                            '(x+1/3, x-y+2/3, z+1/6)'),
                        'hkil: -h+k+l=3n, hki0: -h+k=3n, hh(-2h)l: l=3n, '
                        'h-h0l: h+l=3n, l=2n, 000l: l=6n, h-h00: h=3n')},
      '167:R': {'2a': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)'), 'n/a'),
                '2b': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)'), 'n/a'),
                '4c': (1, ('(x, x, x)', '(-x+1/2, -x+1/2, -x+1/2)',
                           '(-x, -x, -x)', '(x+1/2, x+1/2, x+1/2)'), 'n/a'),
                '6d': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(0, 0, 1/2)',
                           '(1/2, 1/2, 0)', '(1/2, 0, 1/2)', '(0, 1/2, 1/2)'),
                       'n/a'),
                '6e': (1, ('(x, -x+1/2, 1/4)', '(1/4, x, -x+1/2)',
                           '(-x+1/2, 1/4, x)', '(-x, x+1/2, 3/4)',
                           '(3/4, -x, x+1/2)', '(x+1/2, 3/4, -x)'), 'n/a'),
                '12f': (7, ('(x, y, z)', '(z, x, y)', '(y, z, x)',
                            '(-z+1/2, -y+1/2, -x+1/2)',
                            '(-y+1/2, -x+1/2, -z+1/2)',
                            '(-x+1/2, -z+1/2, -y+1/2)', '(-x, -y, -z)',
                            '(-z, -x, -y)', '(-y, -z, -x)',
                            '(z+1/2, y+1/2, x+1/2)', '(y+1/2, x+1/2, z+1/2)',
                            '(x+1/2, z+1/2, y+1/2)'), 'n/a')},
      '168': {'1a': (4, ('(0, 0, z)', ), None),
              '2b': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, z)'), None),
              '3c': (4, ('(1/2, 0, z)', '(0, 1/2, z)', '(1/2, 1/2, z)'), None
                     ),
              '6d': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                         '(-x, -y, z)', '(y, -x+y, z)', '(x-y, x, z)'), None
                     )},
      '169': {'6a': (7, ('(x, y, z)', '(-y, x-y, z+1/3)', '(-x+y, -x, z+2/3)',
                         '(-x, -y, z+1/2)', '(y, -x+y, z+5/6)',
                         '(x-y, x, z+1/6)'), '000l: l=6n')},
      '170': {'6a': (7, ('(x, y, z)', '(-y, x-y, z+2/3)', '(-x+y, -x, z+1/3)',
                         '(-x, -y, z+1/2)', '(y, -x+y, z+1/6)',
                         '(x-y, x, z+5/6)'), '000l: l=6n')},
      '171': {'3a': (4, ('(0, 0, z)', '(0, 0, z+2/3)', '(0, 0, z+1/3)'),
                     'hkil: l=3n'),
              '3b': (4, ('(1/2, 1/2, z)', '(1/2, 0, z+2/3)',
                         '(0, 1/2, z+1/3)'), 'hkil: h=2n+1 or k=2n+1 or l=3n'
                     ),
              '6c': (7, ('(x, y, z)', '(-y, x-y, z+2/3)', '(-x+y, -x, z+1/3)',
                         '(-x, -y, z)', '(y, -x+y, z+2/3)', '(x-y, x, z+1/3)'
                         ), '000l: l=3n')},
      '172': {'3a': (4, ('(0, 0, z)', '(0, 0, z+1/3)', '(0, 0, z+2/3)'),
                     'hkil: l=3n'),
              '3b': (4, ('(1/2, 1/2, z)', '(1/2, 0, z+1/3)',
                         '(0, 1/2, z+2/3)'), 'hkil: h=2n+1 or k=2n+1 or l=3n'
                     ),
              '6c': (7, ('(x, y, z)', '(-y, x-y, z+1/3)', '(-x+y, -x, z+2/3)',
                         '(-x, -y, z)', '(y, -x+y, z+1/3)', '(x-y, x, z+2/3)'
                         ), '000l: l=3n')},
      '173': {'2a': (4, ('(0, 0, z)', '(0, 0, z+1/2)'), 'hkil: l=2n'),
              '2b': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, z+1/2)'),
                     'hkil: l=2n or h-k=3n+1 or h-k=3n+2'),
              '6c': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                         '(-x, -y, z+1/2)', '(y, -x+y, z+1/2)',
                         '(x-y, x, z+1/2)'), '000l: l=2n')},
      '174': {'1a': (0, ('(0, 0, 0)', ), None),
              '1b': (0, ('(0, 0, 1/2)', ), None),
              '1c': (0, ('(1/3, 2/3, 0)', ), None),
              '1d': (0, ('(1/3, 2/3, 1/2)', ), None),
              '1e': (0, ('(2/3, 1/3, 0)', ), None),
              '1f': (0, ('(2/3, 1/3, 1/2)', ), None),
              '2g': (4, ('(0, 0, z)', '(0, 0, -z)'), None),
              '2h': (4, ('(1/3, 2/3, z)', '(1/3, 2/3, -z)'), None),
              '2i': (4, ('(2/3, 1/3, z)', '(2/3, 1/3, -z)'), None),
              '3j': (3, ('(x, y, 0)', '(-y, x-y, 0)', '(-x+y, -x, 0)'), None),
              '3k': (3, ('(x, y, 1/2)', '(-y, x-y, 1/2)', '(-x+y, -x, 1/2)'),
                     None),
              '6l': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                         '(x, y, -z)', '(-y, x-y, -z)', '(-x+y, -x, -z)'), None
                     )},
      '175': {'1a': (0, ('(0, 0, 0)', ), None),
              '1b': (0, ('(0, 0, 1/2)', ), None),
              '2c': (0, ('(1/3, 2/3, 0)', '(2/3, 1/3, 0)'), None),
              '2d': (0, ('(1/3, 2/3, 1/2)', '(2/3, 1/3, 1/2)'), None),
              '2e': (4, ('(0, 0, z)', '(0, 0, -z)'), None),
              '3f': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(1/2, 1/2, 0)'), None
                     ),
              '3g': (0, ('(1/2, 0, 1/2)', '(0, 1/2, 1/2)', '(1/2, 1/2, 1/2)'),
                     None),
              '4h': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, z)', '(2/3, 1/3, -z)',
                         '(1/3, 2/3, -z)'), None),
              '6i': (4, ('(1/2, 0, z)', '(0, 1/2, z)', '(1/2, 1/2, z)',
                         '(1/2, 0, -z)', '(0, 1/2, -z)', '(1/2, 1/2, -z)'),
                     None),
              '6j': (3, ('(x, y, 0)', '(-y, x-y, 0)', '(-x+y, -x, 0)',
                         '(-x, -y, 0)', '(y, -x+y, 0)', '(x-y, x, 0)'), None),
              '6k': (3, ('(x, y, 1/2)', '(-y, x-y, 1/2)', '(-x+y, -x, 1/2)',
                         '(-x, -y, 1/2)', '(y, -x+y, 1/2)', '(x-y, x, 1/2)'),
                     None),
              '12l': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(-x, -y, z)', '(y, -x+y, z)', '(x-y, x, z)',
                          '(-x, -y, -z)', '(y, -x+y, -z)', '(x-y, x, -z)',
                          '(x, y, -z)', '(-y, x-y, -z)', '(-x+y, -x, -z)'),
                      None)},
      '176': {'2a': (0, ('(0, 0, 1/4)', '(0, 0, 3/4)'), 'hkil: l=2n'),
              '2b': (0, ('(0, 0, 0)', '(0, 0, 1/2)'), 'hkil: l=2n'),
              '2c': (0, ('(1/3, 2/3, 1/4)', '(2/3, 1/3, 3/4)'),
                     'hkil: l=2n or h-k=3n+1 or h-k=3n+2'),
              '2d': (0, ('(2/3, 1/3, 1/4)', '(1/3, 2/3, 3/4)'),
                     'hkil: l=2n or h-k=3n+1 or h-k=3n+2'),
              '4e': (4, ('(0, 0, z)', '(0, 0, z+1/2)', '(0, 0, -z)',
                         '(0, 0, -z+1/2)'), 'hkil: l=2n'),
              '4f': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, z+1/2)',
                         '(2/3, 1/3, -z)', '(1/3, 2/3, -z+1/2)'),
                     'hkil: l=2n or h-k=3n+1 or h-k=3n+2'),
              '6g': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(1/2, 1/2, 0)',
                         '(1/2, 0, 1/2)', '(0, 1/2, 1/2)', '(1/2, 1/2, 1/2)'),
                     'hkil: l=2n'),
              '6h': (3, ('(x, y, 1/4)', '(-y, x-y, 1/4)', '(-x+y, -x, 1/4)',
                         '(-x, -y, 3/4)', '(y, -x+y, 3/4)', '(x-y, x, 3/4)'),
                     None),
              '12i': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(-x, -y, z+1/2)', '(y, -x+y, z+1/2)',
                          '(x-y, x, z+1/2)', '(-x, -y, -z)', '(y, -x+y, -z)',
                          '(x-y, x, -z)', '(x, y, -z+1/2)',
                          '(-y, x-y, -z+1/2)', '(-x+y, -x, -z+1/2)'),
                      '000l: l=2n')},
      '177': {'1a': (0, ('(0, 0, 0)', ), None),
              '1b': (0, ('(0, 0, 1/2)', ), None),
              '2c': (0, ('(1/3, 2/3, 0)', '(2/3, 1/3, 0)'), None),
              '2d': (0, ('(1/3, 2/3, 1/2)', '(2/3, 1/3, 1/2)'), None),
              '2e': (4, ('(0, 0, z)', '(0, 0, -z)'), None),
              '3f': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(1/2, 1/2, 0)'), None
                     ),
              '3g': (0, ('(1/2, 0, 1/2)', '(0, 1/2, 1/2)', '(1/2, 1/2, 1/2)'),
                     None),
              '4h': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, z)', '(2/3, 1/3, -z)',
                         '(1/3, 2/3, -z)'), None),
              '6i': (4, ('(1/2, 0, z)', '(0, 1/2, z)', '(1/2, 1/2, z)',
                         '(0, 1/2, -z)', '(1/2, 0, -z)', '(1/2, 1/2, -z)'),
                     None),
              '6j': (1, ('(x, 0, 0)', '(0, x, 0)', '(-x, -x, 0)',
                         '(-x, 0, 0)', '(0, -x, 0)', '(x, x, 0)'), None),
              '6k': (1, ('(x, 0, 1/2)', '(0, x, 1/2)', '(-x, -x, 1/2)',
                         '(-x, 0, 1/2)', '(0, -x, 1/2)', '(x, x, 1/2)'), None
                     ),
              '6l': (1, ('(x, -x, 0)', '(x, 2*x, 0)', '(-2*x, -x, 0)',
                         '(-x, x, 0)', '(-x, -2*x, 0)', '(2*x, x, 0)'), None),
              '6m': (1, ('(x, -x, 1/2)', '(x, 2*x, 1/2)', '(-2*x, -x, 1/2)',
                         '(-x, x, 1/2)', '(-x, -2*x, 1/2)', '(2*x, x, 1/2)'),
                     None),
              '12n': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(-x, -y, z)', '(y, -x+y, z)', '(x-y, x, z)',
                          '(y, x, -z)', '(x-y, -y, -z)', '(-x, -x+y, -z)',
                          '(-y, -x, -z)', '(-x+y, y, -z)', '(x, x-y, -z)'),
                      None)},
      '178': {'6a': (1, ('(x, 0, 0)', '(0, x, 1/3)', '(-x, -x, 2/3)',
                         '(-x, 0, 1/2)', '(0, -x, 5/6)', '(x, x, 1/6)'),
                     'h-h0l: l=2n or l=3n+1 or l=3n+2'),
              '6b': (1, ('(x, 2*x, 1/4)', '(-2*x, -x, 7/12)',
                         '(x, -x, 11/12)', '(-x, -2*x, 3/4)',
                         '(2*x, x, 1/12)', '(-x, x, 5/12)'),
                     'hh(-2h)l: l=2n or l=3n+1 or l=3n+2'),
              '12c': (7, ('(x, y, z)', '(-y, x-y, z+1/3)',
                          '(-x+y, -x, z+2/3)', '(-x, -y, z+1/2)',
                          '(y, -x+y, z+5/6)', '(x-y, x, z+1/6)',
                          '(y, x, -z+1/3)', '(x-y, -y, -z)',
                          '(-x, -x+y, -z+2/3)', '(-y, -x, -z+5/6)',
                          '(-x+y, y, -z+1/2)', '(x, x-y, -z+1/6)'),
                      '000l: l=6n')},
      '179': {'6a': (1, ('(x, 0, 0)', '(0, x, 2/3)', '(-x, -x, 1/3)',
                         '(-x, 0, 1/2)', '(0, -x, 1/6)', '(x, x, 5/6)'),
                     'h-h0l: l=2n or l=3n+1 or l=3n+2'),
              '6b': (1, ('(x, 2*x, 3/4)', '(-2*x, -x, 5/12)', '(x, -x, 1/12)',
                         '(-x, -2*x, 1/4)', '(2*x, x, 11/12)',
                         '(-x, x, 7/12)'), 'hh(-2h)l: l=2n or l=3n+1 or l=3n+2'
                     ),
              '12c': (7, ('(x, y, z)', '(-y, x-y, z+2/3)',
                          '(-x+y, -x, z+1/3)', '(-x, -y, z+1/2)',
                          '(y, -x+y, z+1/6)', '(x-y, x, z+5/6)',
                          '(y, x, -z+2/3)', '(x-y, -y, -z)',
                          '(-x, -x+y, -z+1/3)', '(-y, -x, -z+1/6)',
                          '(-x+y, y, -z+1/2)', '(x, x-y, -z+5/6)'),
                      '000l: l=6n')},
      '180': {'3a': (0, ('(0, 0, 0)', '(0, 0, 2/3)', '(0, 0, 1/3)'),
                     'hkil: l=3n'),
              '3b': (0, ('(0, 0, 1/2)', '(0, 0, 1/6)', '(0, 0, 5/6)'),
                     'hkil: l=3n'),
              '3c': (0, ('(1/2, 0, 0)', '(0, 1/2, 2/3)', '(1/2, 1/2, 1/3)'),
                     'hkil: h=2n+1 or k=2n+1 or l=3n'),
              '3d': (0, ('(1/2, 0, 1/2)', '(0, 1/2, 1/6)', '(1/2, 1/2, 5/6)'),
                     'hkil: h=2n+1 or k=2n+1 or l=3n'),
              '6e': (4, ('(0, 0, z)', '(0, 0, z+2/3)', '(0, 0, z+1/3)',
                         '(0, 0, -z+2/3)', '(0, 0, -z)', '(0, 0, -z+1/3)'),
                     'hkil: l=3n'),
              '6f': (4, ('(1/2, 0, z)', '(0, 1/2, z+2/3)',
                         '(1/2, 1/2, z+1/3)', '(0, 1/2, -z+2/3)',
                         '(1/2, 0, -z)', '(1/2, 1/2, -z+1/3)'),
                     'hkil: h=2n+1 or k=2n+1 or l=3n'),
              '6g': (1, ('(x, 0, 0)', '(0, x, 2/3)', '(-x, -x, 1/3)',
                         '(-x, 0, 0)', '(0, -x, 2/3)', '(x, x, 1/3)'), None),
              '6h': (1, ('(x, 0, 1/2)', '(0, x, 1/6)', '(-x, -x, 5/6)',
                         '(-x, 0, 1/2)', '(0, -x, 1/6)', '(x, x, 5/6)'), None
                     ),
              '6i': (1, ('(x, 2*x, 0)', '(-2*x, -x, 2/3)', '(x, -x, 1/3)',
                         '(-x, -2*x, 0)', '(2*x, x, 2/3)', '(-x, x, 1/3)'),
                     None),
              '6j': (1, ('(x, 2*x, 1/2)', '(-2*x, -x, 1/6)', '(x, -x, 5/6)',
                         '(-x, -2*x, 1/2)', '(2*x, x, 1/6)', '(-x, x, 5/6)'),
                     None),
              '12k': (7, ('(x, y, z)', '(-y, x-y, z+2/3)',
                          '(-x+y, -x, z+1/3)', '(-x, -y, z)',
                          '(y, -x+y, z+2/3)', '(x-y, x, z+1/3)',
                          '(y, x, -z+2/3)', '(x-y, -y, -z)',
                          '(-x, -x+y, -z+1/3)', '(-y, -x, -z+2/3)',
                          '(-x+y, y, -z)', '(x, x-y, -z+1/3)'), '000l: l=3n'
                      )},
      '181': {'3a': (0, ('(0, 0, 0)', '(0, 0, 1/3)', '(0, 0, 2/3)'),
                     'hkil: l=3n'),
              '3b': (0, ('(0, 0, 1/2)', '(0, 0, 5/6)', '(0, 0, 1/6)'),
                     'hkil: l=3n'),
              '3c': (0, ('(1/2, 0, 0)', '(0, 1/2, 1/3)', '(1/2, 1/2, 2/3)'),
                     'hkil: h=2n+1 or k=2n+1 or l=3n'),
              '3d': (0, ('(1/2, 0, 1/2)', '(0, 1/2, 5/6)', '(1/2, 1/2, 1/6)'),
                     'hkil: h=2n+1 or k=2n+1 or l=3n'),
              '6e': (4, ('(0, 0, z)', '(0, 0, z+1/3)', '(0, 0, z+2/3)',
                         '(0, 0, -z+1/3)', '(0, 0, -z)', '(0, 0, -z+2/3)'),
                     'hkil: l=3n'),
              '6f': (4, ('(1/2, 0, z)', '(0, 1/2, z+1/3)',
                         '(1/2, 1/2, z+2/3)', '(0, 1/2, -z+1/3)',
                         '(1/2, 0, -z)', '(1/2, 1/2, -z+2/3)'),
                     'hkil: h=2n+1 or k=2n+1 or l=3n'),
              '6g': (1, ('(x, 0, 0)', '(0, x, 1/3)', '(-x, -x, 2/3)',
                         '(-x, 0, 0)', '(0, -x, 1/3)', '(x, x, 2/3)'), None),
              '6h': (1, ('(x, 0, 1/2)', '(0, x, 5/6)', '(-x, -x, 1/6)',
                         '(-x, 0, 1/2)', '(0, -x, 5/6)', '(x, x, 1/6)'), None
                     ),
              '6i': (1, ('(x, 2*x, 0)', '(-2*x, -x, 1/3)', '(x, -x, 2/3)',
                         '(-x, -2*x, 0)', '(2*x, x, 1/3)', '(-x, x, 2/3)'),
                     None),
              '6j': (1, ('(x, 2*x, 1/2)', '(-2*x, -x, 5/6)', '(x, -x, 1/6)',
                         '(-x, -2*x, 1/2)', '(2*x, x, 5/6)', '(-x, x, 1/6)'),
                     None),
              '12k': (7, ('(x, y, z)', '(-y, x-y, z+1/3)',
                          '(-x+y, -x, z+2/3)', '(-x, -y, z)',
                          '(y, -x+y, z+1/3)', '(x-y, x, z+2/3)',
                          '(y, x, -z+1/3)', '(x-y, -y, -z)',
                          '(-x, -x+y, -z+2/3)', '(-y, -x, -z+1/3)',
                          '(-x+y, y, -z)', '(x, x-y, -z+2/3)'), '000l: l=3n'
                      )},
      '182': {'2a': (0, ('(0, 0, 0)', '(0, 0, 1/2)'), 'hkil: l=2n'),
              '2b': (0, ('(0, 0, 1/4)', '(0, 0, 3/4)'), 'hkil: l=2n'),
              '2c': (0, ('(1/3, 2/3, 1/4)', '(2/3, 1/3, 3/4)'),
                     'hkil: l=2n or h-k=3n+1 or h-k=3n+2'),
              '2d': (0, ('(1/3, 2/3, 3/4)', '(2/3, 1/3, 1/4)'),
                     'hkil: l=2n or h-k=3n+1 or h-k=3n+2'),
              '4e': (4, ('(0, 0, z)', '(0, 0, z+1/2)', '(0, 0, -z)',
                         '(0, 0, -z+1/2)'), 'hkil: l=2n'),
              '4f': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, z+1/2)',
                         '(2/3, 1/3, -z)', '(1/3, 2/3, -z+1/2)'),
                     'hkil: l=2n or h-k=3n+1 or h-k=3n+2'),
              '6g': (1, ('(x, 0, 0)', '(0, x, 0)', '(-x, -x, 0)',
                         '(-x, 0, 1/2)', '(0, -x, 1/2)', '(x, x, 1/2)'),
                     'h-h0l: l=2n'),
              '6h': (1, ('(x, 2*x, 1/4)', '(-2*x, -x, 1/4)', '(x, -x, 1/4)',
                         '(-x, -2*x, 3/4)', '(2*x, x, 3/4)', '(-x, x, 3/4)'),
                     'hh(-2h)l: l=2n'),
              '12i': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(-x, -y, z+1/2)', '(y, -x+y, z+1/2)',
                          '(x-y, x, z+1/2)', '(y, x, -z)', '(x-y, -y, -z)',
                          '(-x, -x+y, -z)', '(-y, -x, -z+1/2)',
                          '(-x+y, y, -z+1/2)', '(x, x-y, -z+1/2)'),
                      '000l: l=2n')},
      '183': {'1a': (4, ('(0, 0, z)', ), None),
              '2b': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, z)'), None),
              '3c': (4, ('(1/2, 0, z)', '(0, 1/2, z)', '(1/2, 1/2, z)'), None
                     ),
              '6d': (5, ('(x, 0, z)', '(0, x, z)', '(-x, -x, z)',
                         '(-x, 0, z)', '(0, -x, z)', '(x, x, z)'), None),
              '6e': (5, ('(x, -x, z)', '(x, 2*x, z)', '(-2*x, -x, z)',
                         '(-x, x, z)', '(-x, -2*x, z)', '(2*x, x, z)'), None),
              '12f': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(-x, -y, z)', '(y, -x+y, z)', '(x-y, x, z)',
                          '(-y, -x, z)', '(-x+y, y, z)', '(x, x-y, z)',
                          '(y, x, z)', '(x-y, -y, z)', '(-x, -x+y, z)'), None
                      )},
      '184': {'2a': (4, ('(0, 0, z)', '(0, 0, z+1/2)'), 'hkil: l=2n'),
              '4b': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, z)',
                         '(1/3, 2/3, z+1/2)', '(2/3, 1/3, z+1/2)'),
                     'hkil: l=2n'),
              '6c': (4, ('(1/2, 0, z)', '(0, 1/2, z)', '(1/2, 1/2, z)',
                         '(0, 1/2, z+1/2)', '(1/2, 0, z+1/2)',
                         '(1/2, 1/2, z+1/2)'), 'hkil: l=2n'),
              '12d': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(-x, -y, z)', '(y, -x+y, z)', '(x-y, x, z)',
                          '(-y, -x, z+1/2)', '(-x+y, y, z+1/2)',
                          '(x, x-y, z+1/2)', '(y, x, z+1/2)',
                          '(x-y, -y, z+1/2)', '(-x, -x+y, z+1/2)'),
                      'hh(-2h)l: l=2n, h-h0l: l=2n, 000l: l=2n')},
      '185': {'2a': (4, ('(0, 0, z)', '(0, 0, z+1/2)'), 'hkil: l=2n'),
              '4b': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, z+1/2)',
                         '(1/3, 2/3, z+1/2)', '(2/3, 1/3, z)'), 'hkil: l=2n'),
              '6c': (5, ('(x, 0, z)', '(0, x, z)', '(-x, -x, z)',
                         '(-x, 0, z+1/2)', '(0, -x, z+1/2)', '(x, x, z+1/2)'),
                     None),
              '12d': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(-x, -y, z+1/2)', '(y, -x+y, z+1/2)',
                          '(x-y, x, z+1/2)', '(-y, -x, z+1/2)',
                          '(-x+y, y, z+1/2)', '(x, x-y, z+1/2)', '(y, x, z)',
                          '(x-y, -y, z)', '(-x, -x+y, z)'),
                      'h-h0l: l=2n, 000l: l=2n')},
      '186': {'2a': (4, ('(0, 0, z)', '(0, 0, z+1/2)'), 'hkil: l=2n'),
              '2b': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, z+1/2)'),
                     'hkil: l=2n or h-k=3n+1 or h-k=3n+2'),
              '6c': (5, ('(x, -x, z)', '(x, 2*x, z)', '(-2*x, -x, z)',
                         '(-x, x, z+1/2)', '(-x, -2*x, z+1/2)',
                         '(2*x, x, z+1/2)'), None),
              '12d': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(-x, -y, z+1/2)', '(y, -x+y, z+1/2)',
                          '(x-y, x, z+1/2)', '(-y, -x, z)', '(-x+y, y, z)',
                          '(x, x-y, z)', '(y, x, z+1/2)', '(x-y, -y, z+1/2)',
                          '(-x, -x+y, z+1/2)'), 'hh(-2h)l: l=2n, 000l: l=2n'
                      )},
      '187': {'1a': (0, ('(0, 0, 0)', ), None),
              '1b': (0, ('(0, 0, 1/2)', ), None),
              '1c': (0, ('(1/3, 2/3, 0)', ), None),
              '1d': (0, ('(1/3, 2/3, 1/2)', ), None),
              '1e': (0, ('(2/3, 1/3, 0)', ), None),
              '1f': (0, ('(2/3, 1/3, 1/2)', ), None),
              '2g': (4, ('(0, 0, z)', '(0, 0, -z)'), None),
              '2h': (4, ('(1/3, 2/3, z)', '(1/3, 2/3, -z)'), None),
              '2i': (4, ('(2/3, 1/3, z)', '(2/3, 1/3, -z)'), None),
              '3j': (1, ('(x, -x, 0)', '(x, 2*x, 0)', '(-2*x, -x, 0)'), None),
              '3k': (1, ('(x, -x, 1/2)', '(x, 2*x, 1/2)', '(-2*x, -x, 1/2)'),
                     None),
              '6l': (3, ('(x, y, 0)', '(-y, x-y, 0)', '(-x+y, -x, 0)',
                         '(-y, -x, 0)', '(-x+y, y, 0)', '(x, x-y, 0)'), None),
              '6m': (3, ('(x, y, 1/2)', '(-y, x-y, 1/2)', '(-x+y, -x, 1/2)',
                         '(-y, -x, 1/2)', '(-x+y, y, 1/2)', '(x, x-y, 1/2)'),
                     None),
              '6n': (5, ('(x, -x, z)', '(x, 2*x, z)', '(-2*x, -x, z)',
                         '(x, -x, -z)', '(x, 2*x, -z)', '(-2*x, -x, -z)'), None
                     ),
              '12o': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(x, y, -z)', '(-y, x-y, -z)', '(-x+y, -x, -z)',
                          '(-y, -x, z)', '(-x+y, y, z)', '(x, x-y, z)',
                          '(-y, -x, -z)', '(-x+y, y, -z)', '(x, x-y, -z)'),
                      None)},
      '188': {'2a': (0, ('(0, 0, 0)', '(0, 0, 1/2)'), 'hkil: l=2n'),
              '2b': (0, ('(0, 0, 1/4)', '(0, 0, 3/4)'), 'hkil: l=2n'),
              '2c': (0, ('(1/3, 2/3, 0)', '(1/3, 2/3, 1/2)'), 'hkil: l=2n'),
              '2d': (0, ('(1/3, 2/3, 1/4)', '(1/3, 2/3, 3/4)'), 'hkil: l=2n'),
              '2e': (0, ('(2/3, 1/3, 0)', '(2/3, 1/3, 1/2)'), 'hkil: l=2n'),
              '2f': (0, ('(2/3, 1/3, 1/4)', '(2/3, 1/3, 3/4)'), 'hkil: l=2n'),
              '4g': (4, ('(0, 0, z)', '(0, 0, -z+1/2)', '(0, 0, z+1/2)',
                         '(0, 0, -z)'), 'hkil: l=2n'),
              '4h': (4, ('(1/3, 2/3, z)', '(1/3, 2/3, -z+1/2)',
                         '(1/3, 2/3, z+1/2)', '(1/3, 2/3, -z)'), 'hkil: l=2n'
                     ),
              '4i': (4, ('(2/3, 1/3, z)', '(2/3, 1/3, -z+1/2)',
                         '(2/3, 1/3, z+1/2)', '(2/3, 1/3, -z)'), 'hkil: l=2n'
                     ),
              '6j': (1, ('(x, -x, 0)', '(x, 2*x, 0)', '(-2*x, -x, 0)',
                         '(x, -x, 1/2)', '(x, 2*x, 1/2)', '(-2*x, -x, 1/2)'),
                     'hkil: l=2n'),
              '6k': (3, ('(x, y, 1/4)', '(-y, x-y, 1/4)', '(-x+y, -x, 1/4)',
                         '(-y, -x, 3/4)', '(-x+y, y, 3/4)', '(x, x-y, 3/4)'),
                     None),
              '12l': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(x, y, -z+1/2)', '(-y, x-y, -z+1/2)',
                          '(-x+y, -x, -z+1/2)', '(-y, -x, z+1/2)',
                          '(-x+y, y, z+1/2)', '(x, x-y, z+1/2)',
                          '(-y, -x, -z)', '(-x+y, y, -z)', '(x, x-y, -z)'),
                      'h-h0l: l=2n, 000l: l=2n')},
      '189': {'1a': (0, ('(0, 0, 0)', ), None),
              '1b': (0, ('(0, 0, 1/2)', ), None),
              '2c': (0, ('(1/3, 2/3, 0)', '(2/3, 1/3, 0)'), None),
              '2d': (0, ('(1/3, 2/3, 1/2)', '(2/3, 1/3, 1/2)'), None),
              '2e': (4, ('(0, 0, z)', '(0, 0, -z)'), None),
              '3f': (1, ('(x, 0, 0)', '(0, x, 0)', '(-x, -x, 0)'), None),
              '3g': (1, ('(x, 0, 1/2)', '(0, x, 1/2)', '(-x, -x, 1/2)'), None
                     ),
              '4h': (4, ('(1/3, 2/3, z)', '(1/3, 2/3, -z)', '(2/3, 1/3, -z)',
                         '(2/3, 1/3, z)'), None),
              '6i': (5, ('(x, 0, z)', '(0, x, z)', '(-x, -x, z)',
                         '(x, 0, -z)', '(0, x, -z)', '(-x, -x, -z)'), None),
              '6j': (3, ('(x, y, 0)', '(-y, x-y, 0)', '(-x+y, -x, 0)',
                         '(y, x, 0)', '(x-y, -y, 0)', '(-x, -x+y, 0)'), None),
              '6k': (3, ('(x, y, 1/2)', '(-y, x-y, 1/2)', '(-x+y, -x, 1/2)',
                         '(y, x, 1/2)', '(x-y, -y, 1/2)', '(-x, -x+y, 1/2)'),
                     None),
              '12l': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(x, y, -z)', '(-y, x-y, -z)', '(-x+y, -x, -z)',
                          '(y, x, -z)', '(x-y, -y, -z)', '(-x, -x+y, -z)',
                          '(y, x, z)', '(x-y, -y, z)', '(-x, -x+y, z)'), None
                      )},
      '190': {'2a': (0, ('(0, 0, 0)', '(0, 0, 1/2)'), 'hkil: l=2n'),
              '2b': (0, ('(0, 0, 1/4)', '(0, 0, 3/4)'), 'hkil: l=2n'),
              '2c': (0, ('(1/3, 2/3, 1/4)', '(2/3, 1/3, 3/4)'),
                     'hkil: l=2n or h-k=3n+1 or h-k=3n+2'),
              '2d': (0, ('(2/3, 1/3, 1/4)', '(1/3, 2/3, 3/4)'),
                     'hkil: l=2n or h-k=3n+1 or h-k=3n+2'),
              '4e': (4, ('(0, 0, z)', '(0, 0, -z+1/2)', '(0, 0, -z)',
                         '(0, 0, z+1/2)'), 'hkil: l=2n'),
              '4f': (4, ('(1/3, 2/3, z)', '(1/3, 2/3, -z+1/2)',
                         '(2/3, 1/3, -z)', '(2/3, 1/3, z+1/2)'),
                     'hkil: l=2n or h-k=3n+1 or h-k=3n+2'),
              '6g': (1, ('(x, 0, 0)', '(0, x, 0)', '(-x, -x, 0)',
                         '(x, 0, 1/2)', '(0, x, 1/2)', '(-x, -x, 1/2)'),
                     'hkil: l=2n'),
              '6h': (3, ('(x, y, 1/4)', '(-y, x-y, 1/4)', '(-x+y, -x, 1/4)',
                         '(y, x, 3/4)', '(x-y, -y, 3/4)', '(-x, -x+y, 3/4)'),
                     None),
              '12i': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(x, y, -z+1/2)', '(-y, x-y, -z+1/2)',
                          '(-x+y, -x, -z+1/2)', '(y, x, -z)', '(x-y, -y, -z)',
                          '(-x, -x+y, -z)', '(y, x, z+1/2)',
                          '(x-y, -y, z+1/2)', '(-x, -x+y, z+1/2)'),
                      'hh(-2h)l: l=2n, 000l: l=2n')},
      '191': {'1a': (0, ('(0, 0, 0)', ), None),
              '1b': (0, ('(0, 0, 1/2)', ), None),
              '2c': (0, ('(1/3, 2/3, 0)', '(2/3, 1/3, 0)'), None),
              '2d': (0, ('(1/3, 2/3, 1/2)', '(2/3, 1/3, 1/2)'), None),
              '2e': (4, ('(0, 0, z)', '(0, 0, -z)'), None),
              '3f': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(1/2, 1/2, 0)'), None
                     ),
              '3g': (0, ('(1/2, 0, 1/2)', '(0, 1/2, 1/2)', '(1/2, 1/2, 1/2)'),
                     None),
              '4h': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, z)', '(2/3, 1/3, -z)',
                         '(1/3, 2/3, -z)'), None),
              '6i': (4, ('(1/2, 0, z)', '(0, 1/2, z)', '(1/2, 1/2, z)',
                         '(0, 1/2, -z)', '(1/2, 0, -z)', '(1/2, 1/2, -z)'),
                     None),
              '6j': (1, ('(x, 0, 0)', '(0, x, 0)', '(-x, -x, 0)',
                         '(-x, 0, 0)', '(0, -x, 0)', '(x, x, 0)'), None),
              '6k': (1, ('(x, 0, 1/2)', '(0, x, 1/2)', '(-x, -x, 1/2)',
                         '(-x, 0, 1/2)', '(0, -x, 1/2)', '(x, x, 1/2)'), None
                     ),
              '6l': (1, ('(x, 2*x, 0)', '(-2*x, -x, 0)', '(x, -x, 0)',
                         '(-x, -2*x, 0)', '(2*x, x, 0)', '(-x, x, 0)'), None),
              '6m': (1, ('(x, 2*x, 1/2)', '(-2*x, -x, 1/2)', '(x, -x, 1/2)',
                         '(-x, -2*x, 1/2)', '(2*x, x, 1/2)', '(-x, x, 1/2)'),
                     None),
              '12n': (5, ('(x, 0, z)', '(0, x, z)', '(-x, -x, z)',
                          '(-x, 0, z)', '(0, -x, z)', '(x, x, z)',
                          '(0, x, -z)', '(x, 0, -z)', '(-x, -x, -z)',
                          '(0, -x, -z)', '(-x, 0, -z)', '(x, x, -z)'), None),
              '12o': (5, ('(x, 2*x, z)', '(-2*x, -x, z)', '(x, -x, z)',
                          '(-x, -2*x, z)', '(2*x, x, z)', '(-x, x, z)',
                          '(2*x, x, -z)', '(-x, -2*x, -z)', '(-x, x, -z)',
                          '(-2*x, -x, -z)', '(x, 2*x, -z)', '(x, -x, -z)'),
                      None),
              '12p': (3, ('(x, y, 0)', '(-y, x-y, 0)', '(-x+y, -x, 0)',
                          '(-x, -y, 0)', '(y, -x+y, 0)', '(x-y, x, 0)',
                          '(y, x, 0)', '(x-y, -y, 0)', '(-x, -x+y, 0)',
                          '(-y, -x, 0)', '(-x+y, y, 0)', '(x, x-y, 0)'), None
                      ),
              '12q': (3, ('(x, y, 1/2)', '(-y, x-y, 1/2)', '(-x+y, -x, 1/2)',
                          '(-x, -y, 1/2)', '(y, -x+y, 1/2)', '(x-y, x, 1/2)',
                          '(y, x, 1/2)', '(x-y, -y, 1/2)', '(-x, -x+y, 1/2)',
                          '(-y, -x, 1/2)', '(-x+y, y, 1/2)', '(x, x-y, 1/2)'),
                      None),
              '24r': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(-x, -y, z)', '(y, -x+y, z)', '(x-y, x, z)',
                          '(y, x, -z)', '(x-y, -y, -z)', '(-x, -x+y, -z)',
                          '(-y, -x, -z)', '(-x+y, y, -z)', '(x, x-y, -z)',
                          '(-x, -y, -z)', '(y, -x+y, -z)', '(x-y, x, -z)',
                          '(x, y, -z)', '(-y, x-y, -z)', '(-x+y, -x, -z)',
                          '(-y, -x, z)', '(-x+y, y, z)', '(x, x-y, z)',
                          '(y, x, z)', '(x-y, -y, z)', '(-x, -x+y, z)'), None
                      )},
      '192': {'2a': (0, ('(0, 0, 1/4)', '(0, 0, 3/4)'), 'hkil: l=2n'),
              '2b': (0, ('(0, 0, 0)', '(0, 0, 1/2)'), 'hkil: l=2n'),
              '4c': (0, ('(1/3, 2/3, 1/4)', '(2/3, 1/3, 1/4)',
                         '(2/3, 1/3, 3/4)', '(1/3, 2/3, 3/4)'), 'hkil: l=2n'),
              '4d': (0, ('(1/3, 2/3, 0)', '(2/3, 1/3, 0)', '(2/3, 1/3, 1/2)',
                         '(1/3, 2/3, 1/2)'), 'hkil: l=2n'),
              '4e': (4, ('(0, 0, z)', '(0, 0, -z+1/2)', '(0, 0, -z)',
                         '(0, 0, z+1/2)'), 'hkil: l=2n'),
              '6f': (0, ('(1/2, 0, 1/4)', '(0, 1/2, 1/4)', '(1/2, 1/2, 1/4)',
                         '(1/2, 0, 3/4)', '(0, 1/2, 3/4)', '(1/2, 1/2, 3/4)'),
                     'hkil: l=2n'),
              '6g': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(1/2, 1/2, 0)',
                         '(0, 1/2, 1/2)', '(1/2, 0, 1/2)', '(1/2, 1/2, 1/2)'),
                     'hkil: l=2n'),
              '8h': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, z)',
                         '(2/3, 1/3, -z+1/2)', '(1/3, 2/3, -z+1/2)',
                         '(2/3, 1/3, -z)', '(1/3, 2/3, -z)',
                         '(1/3, 2/3, z+1/2)', '(2/3, 1/3, z+1/2)'),
                     'hkil: l=2n'),
              '12i': (4, ('(1/2, 0, z)', '(0, 1/2, z)', '(1/2, 1/2, z)',
                          '(0, 1/2, -z+1/2)', '(1/2, 0, -z+1/2)',
                          '(1/2, 1/2, -z+1/2)', '(1/2, 0, -z)',
                          '(0, 1/2, -z)', '(1/2, 1/2, -z)', '(0, 1/2, z+1/2)',
                          '(1/2, 0, z+1/2)', '(1/2, 1/2, z+1/2)'), 'hkil: l=2n'
                      ),
              '12j': (1, ('(x, 0, 1/4)', '(0, x, 1/4)', '(-x, -x, 1/4)',
                          '(-x, 0, 1/4)', '(0, -x, 1/4)', '(x, x, 1/4)',
                          '(-x, 0, 3/4)', '(0, -x, 3/4)', '(x, x, 3/4)',
                          '(x, 0, 3/4)', '(0, x, 3/4)', '(-x, -x, 3/4)'),
                      'hkil: l=2n'),
              '12k': (1, ('(x, 2*x, 1/4)', '(-2*x, -x, 1/4)', '(x, -x, 1/4)',
                          '(-x, -2*x, 1/4)', '(2*x, x, 1/4)', '(-x, x, 1/4)',
                          '(-x, -2*x, 3/4)', '(2*x, x, 3/4)', '(-x, x, 3/4)',
                          '(x, 2*x, 3/4)', '(-2*x, -x, 3/4)', '(x, -x, 3/4)'),
                      'hkil: l=2n'),
              '12l': (3, ('(x, y, 0)', '(-y, x-y, 0)', '(-x+y, -x, 0)',
                          '(-x, -y, 0)', '(y, -x+y, 0)', '(x-y, x, 0)',
                          '(y, x, 1/2)', '(x-y, -y, 1/2)', '(-x, -x+y, 1/2)',
                          '(-y, -x, 1/2)', '(-x+y, y, 1/2)', '(x, x-y, 1/2)'),
                      None),
              '24m': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(-x, -y, z)', '(y, -x+y, z)', '(x-y, x, z)',
                          '(y, x, -z+1/2)', '(x-y, -y, -z+1/2)',
                          '(-x, -x+y, -z+1/2)', '(-y, -x, -z+1/2)',
                          '(-x+y, y, -z+1/2)', '(x, x-y, -z+1/2)',
                          '(-x, -y, -z)', '(y, -x+y, -z)', '(x-y, x, -z)',
                          '(x, y, -z)', '(-y, x-y, -z)', '(-x+y, -x, -z)',
                          '(-y, -x, z+1/2)', '(-x+y, y, z+1/2)',
                          '(x, x-y, z+1/2)', '(y, x, z+1/2)',
                          '(x-y, -y, z+1/2)', '(-x, -x+y, z+1/2)'),
                      'hh(-2h)l: l=2n, h-h0l: l=2n, 000l: l=2n')},
      '193': {'2a': (0, ('(0, 0, 1/4)', '(0, 0, 3/4)'), 'hkil: l=2n'),
              '2b': (0, ('(0, 0, 0)', '(0, 0, 1/2)'), 'hkil: l=2n'),
              '4c': (0, ('(1/3, 2/3, 1/4)', '(2/3, 1/3, 3/4)',
                         '(2/3, 1/3, 1/4)', '(1/3, 2/3, 3/4)'), 'hkil: l=2n'),
              '4d': (0, ('(1/3, 2/3, 0)', '(2/3, 1/3, 1/2)', '(2/3, 1/3, 0)',
                         '(1/3, 2/3, 1/2)'), 'hkil: l=2n'),
              '4e': (4, ('(0, 0, z)', '(0, 0, z+1/2)', '(0, 0, -z+1/2)',
                         '(0, 0, -z)'), 'hkil: l=2n'),
              '6f': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(1/2, 1/2, 0)',
                         '(1/2, 0, 1/2)', '(0, 1/2, 1/2)', '(1/2, 1/2, 1/2)'),
                     'hkil: l=2n'),
              '6g': (1, ('(x, 0, 1/4)', '(0, x, 1/4)', '(-x, -x, 1/4)',
                         '(-x, 0, 3/4)', '(0, -x, 3/4)', '(x, x, 3/4)'), None
                     ),
              '8h': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, z+1/2)',
                         '(2/3, 1/3, -z+1/2)', '(1/3, 2/3, -z)',
                         '(2/3, 1/3, -z)', '(1/3, 2/3, -z+1/2)',
                         '(1/3, 2/3, z+1/2)', '(2/3, 1/3, z)'), 'hkil: l=2n'),
              '12i': (1, ('(x, 2*x, 0)', '(-2*x, -x, 0)', '(x, -x, 0)',
                          '(-x, -2*x, 1/2)', '(2*x, x, 1/2)', '(-x, x, 1/2)',
                          '(-x, -2*x, 0)', '(2*x, x, 0)', '(-x, x, 0)',
                          '(x, 2*x, 1/2)', '(-2*x, -x, 1/2)', '(x, -x, 1/2)'),
                      'hkil: l=2n'),
              '12j': (3, ('(x, y, 1/4)', '(-y, x-y, 1/4)', '(-x+y, -x, 1/4)',
                          '(-x, -y, 3/4)', '(y, -x+y, 3/4)', '(x-y, x, 3/4)',
                          '(y, x, 1/4)', '(x-y, -y, 1/4)', '(-x, -x+y, 1/4)',
                          '(-y, -x, 3/4)', '(-x+y, y, 3/4)', '(x, x-y, 3/4)'),
                      None),
              '12k': (5, ('(x, 0, z)', '(0, x, z)', '(-x, -x, z)',
                          '(-x, 0, z+1/2)', '(0, -x, z+1/2)', '(x, x, z+1/2)',
                          '(0, x, -z+1/2)', '(x, 0, -z+1/2)',
                          '(-x, -x, -z+1/2)', '(0, -x, -z)', '(-x, 0, -z)',
                          '(x, x, -z)'), None),
              '24l': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(-x, -y, z+1/2)', '(y, -x+y, z+1/2)',
                          '(x-y, x, z+1/2)', '(y, x, -z+1/2)',
                          '(x-y, -y, -z+1/2)', '(-x, -x+y, -z+1/2)',
                          '(-y, -x, -z)', '(-x+y, y, -z)', '(x, x-y, -z)',
                          '(-x, -y, -z)', '(y, -x+y, -z)', '(x-y, x, -z)',
                          '(x, y, -z+1/2)', '(-y, x-y, -z+1/2)',
                          '(-x+y, -x, -z+1/2)', '(-y, -x, z+1/2)',
                          '(-x+y, y, z+1/2)', '(x, x-y, z+1/2)', '(y, x, z)',
                          '(x-y, -y, z)', '(-x, -x+y, z)'),
                      'h-h0l: l=2n, 000l: l=2n')},
      '194': {'2a': (0, ('(0, 0, 0)', '(0, 0, 1/2)'), 'hkil: l=2n'),
              '2b': (0, ('(0, 0, 1/4)', '(0, 0, 3/4)'), 'hkil: l=2n'),
              '2c': (0, ('(1/3, 2/3, 1/4)', '(2/3, 1/3, 3/4)'),
                     'hkil: l=2n or h-k=3n+1 or h-k=3n+2'),
              '2d': (0, ('(1/3, 2/3, 3/4)', '(2/3, 1/3, 1/4)'),
                     'hkil: l=2n or h-k=3n+1 or h-k=3n+2'),
              '4e': (4, ('(0, 0, z)', '(0, 0, z+1/2)', '(0, 0, -z)',
                         '(0, 0, -z+1/2)'), 'hkil: l=2n'),
              '4f': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, z+1/2)',
                         '(2/3, 1/3, -z)', '(1/3, 2/3, -z+1/2)'),
                     'hkil: l=2n or h-k=3n+1 or h-k=3n+2'),
              '6g': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(1/2, 1/2, 0)',
                         '(1/2, 0, 1/2)', '(0, 1/2, 1/2)', '(1/2, 1/2, 1/2)'),
                     'hkil: l=2n'),
              '6h': (1, ('(x, 2*x, 1/4)', '(-2*x, -x, 1/4)', '(x, -x, 1/4)',
                         '(-x, -2*x, 3/4)', '(2*x, x, 3/4)', '(-x, x, 3/4)'),
                     None),
              '12i': (1, ('(x, 0, 0)', '(0, x, 0)', '(-x, -x, 0)',
                          '(-x, 0, 1/2)', '(0, -x, 1/2)', '(x, x, 1/2)',
                          '(-x, 0, 0)', '(0, -x, 0)', '(x, x, 0)',
                          '(x, 0, 1/2)', '(0, x, 1/2)', '(-x, -x, 1/2)'),
                      'hkil: l=2n'),
              '12j': (3, ('(x, y, 1/4)', '(-y, x-y, 1/4)', '(-x+y, -x, 1/4)',
                          '(-x, -y, 3/4)', '(y, -x+y, 3/4)', '(x-y, x, 3/4)',
                          '(y, x, 3/4)', '(x-y, -y, 3/4)', '(-x, -x+y, 3/4)',
                          '(-y, -x, 1/4)', '(-x+y, y, 1/4)', '(x, x-y, 1/4)'),
                      None),
              '12k': (5, ('(x, 2*x, z)', '(-2*x, -x, z)', '(x, -x, z)',
                          '(-x, -2*x, z+1/2)', '(2*x, x, z+1/2)',
                          '(-x, x, z+1/2)', '(2*x, x, -z)', '(-x, -2*x, -z)',
                          '(-x, x, -z)', '(-2*x, -x, -z+1/2)',
                          '(x, 2*x, -z+1/2)', '(x, -x, -z+1/2)'), None),
              '24l': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(-x, -y, z+1/2)', '(y, -x+y, z+1/2)',
                          '(x-y, x, z+1/2)', '(y, x, -z)', '(x-y, -y, -z)',
                          '(-x, -x+y, -z)', '(-y, -x, -z+1/2)',
                          '(-x+y, y, -z+1/2)', '(x, x-y, -z+1/2)',
                          '(-x, -y, -z)', '(y, -x+y, -z)', '(x-y, x, -z)',
                          '(x, y, -z+1/2)', '(-y, x-y, -z+1/2)',
                          '(-x+y, -x, -z+1/2)', '(-y, -x, z)', '(-x+y, y, z)',
                          '(x, x-y, z)', '(y, x, z+1/2)', '(x-y, -y, z+1/2)',
                          '(-x, -x+y, z+1/2)'), 'hh(-2h)l: l=2n, 000l: l=2n'
                      )},
      '195': {'1a': (0, ('(0, 0, 0)', ), None),
              '1b': (0, ('(1/2, 1/2, 1/2)', ), None),
              '3c': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)', '(1/2, 1/2, 0)'),
                     None),
              '3d': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(0, 0, 1/2)'), None),
              '4e': (1, ('(x, x, x)', '(-x, -x, x)', '(-x, x, -x)',
                         '(x, -x, -x)'), None),
              '6f': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(0, x, 0)', '(0, -x, 0)',
                         '(0, 0, x)', '(0, 0, -x)'), None),
              '6g': (1, ('(x, 0, 1/2)', '(-x, 0, 1/2)', '(1/2, x, 0)',
                         '(1/2, -x, 0)', '(0, 1/2, x)', '(0, 1/2, -x)'), None
                     ),
              '6h': (1, ('(x, 1/2, 0)', '(-x, 1/2, 0)', '(0, x, 1/2)',
                         '(0, -x, 1/2)', '(1/2, 0, x)', '(1/2, 0, -x)'), None
                     ),
              '6i': (1, ('(x, 1/2, 1/2)', '(-x, 1/2, 1/2)', '(1/2, x, 1/2)',
                         '(1/2, -x, 1/2)', '(1/2, 1/2, x)', '(1/2, 1/2, -x)'),
                     None),
              '12j': (7, ('(x, y, z)', '(-x, -y, z)', '(-x, y, -z)',
                          '(x, -y, -z)', '(z, x, y)', '(z, -x, -y)',
                          '(-z, -x, y)', '(-z, x, -y)', '(y, z, x)',
                          '(-y, z, -x)', '(y, -z, -x)', '(-y, -z, x)'), None
                      )},
      '196': {'4a': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                         '(1/2, 1/2, 0)'), None),
              '4b': (0, ('(1/2, 1/2, 1/2)', '(1/2, 0, 0)', '(0, 1/2, 0)',
                         '(0, 0, 1/2)'), None),
              '4c': (0, ('(1/4, 1/4, 1/4)', '(1/4, 3/4, 3/4)',
                         '(3/4, 1/4, 3/4)', '(3/4, 3/4, 1/4)'), None),
              '4d': (0, ('(3/4, 3/4, 3/4)', '(3/4, 1/4, 1/4)',
                         '(1/4, 3/4, 1/4)', '(1/4, 1/4, 3/4)'), None),
              '16e': (1, ('(x, x, x)', '(x, x+1/2, x+1/2)',
                          '(x+1/2, x, x+1/2)', '(x+1/2, x+1/2, x)',
                          '(-x, -x, x)', '(-x, -x+1/2, x+1/2)',
                          '(-x+1/2, -x, x+1/2)', '(-x+1/2, -x+1/2, x)',
                          '(-x, x, -x)', '(-x, x+1/2, -x+1/2)',
                          '(-x+1/2, x, -x+1/2)', '(-x+1/2, x+1/2, -x)',
                          '(x, -x, -x)', '(x, -x+1/2, -x+1/2)',
                          '(x+1/2, -x, -x+1/2)', '(x+1/2, -x+1/2, -x)'), None
                      ),
              '24f': (1, ('(x, 0, 0)', '(x, 1/2, 1/2)', '(x+1/2, 0, 1/2)',
                          '(x+1/2, 1/2, 0)', '(-x, 0, 0)', '(-x, 1/2, 1/2)',
                          '(-x+1/2, 0, 1/2)', '(-x+1/2, 1/2, 0)', '(0, x, 0)',
                          '(0, x+1/2, 1/2)', '(1/2, x, 1/2)',
                          '(1/2, x+1/2, 0)', '(0, -x, 0)', '(0, -x+1/2, 1/2)',
                          '(1/2, -x, 1/2)', '(1/2, -x+1/2, 0)', '(0, 0, x)',
                          '(0, 1/2, x+1/2)', '(1/2, 0, x+1/2)',
                          '(1/2, 1/2, x)', '(0, 0, -x)', '(0, 1/2, -x+1/2)',
                          '(1/2, 0, -x+1/2)', '(1/2, 1/2, -x)'), None),
              '24g': (1, ('(x, 1/4, 1/4)', '(x, 3/4, 3/4)',
                          '(x+1/2, 1/4, 3/4)', '(x+1/2, 3/4, 1/4)',
                          '(-x, 3/4, 1/4)', '(-x, 1/4, 3/4)',
                          '(-x+1/2, 3/4, 3/4)', '(-x+1/2, 1/4, 1/4)',
                          '(1/4, x, 1/4)', '(1/4, x+1/2, 3/4)',
                          '(3/4, x, 3/4)', '(3/4, x+1/2, 1/4)',
                          '(1/4, -x, 3/4)', '(1/4, -x+1/2, 1/4)',
                          '(3/4, -x, 1/4)', '(3/4, -x+1/2, 3/4)',
                          '(1/4, 1/4, x)', '(1/4, 3/4, x+1/2)',
                          '(3/4, 1/4, x+1/2)', '(3/4, 3/4, x)',
                          '(3/4, 1/4, -x)', '(3/4, 3/4, -x+1/2)',
                          '(1/4, 1/4, -x+1/2)', '(1/4, 3/4, -x)'), None),
              '48h': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)',
                          '(x+1/2, y, z+1/2)', '(x+1/2, y+1/2, z)',
                          '(-x, -y, z)', '(-x, -y+1/2, z+1/2)',
                          '(-x+1/2, -y, z+1/2)', '(-x+1/2, -y+1/2, z)',
                          '(-x, y, -z)', '(-x, y+1/2, -z+1/2)',
                          '(-x+1/2, y, -z+1/2)', '(-x+1/2, y+1/2, -z)',
                          '(x, -y, -z)', '(x, -y+1/2, -z+1/2)',
                          '(x+1/2, -y, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                          '(z, x, y)', '(z, x+1/2, y+1/2)',
                          '(z+1/2, x, y+1/2)', '(z+1/2, x+1/2, y)',
                          '(z, -x, -y)', '(z, -x+1/2, -y+1/2)',
                          '(z+1/2, -x, -y+1/2)', '(z+1/2, -x+1/2, -y)',
                          '(-z, -x, y)', '(-z, -x+1/2, y+1/2)',
                          '(-z+1/2, -x, y+1/2)', '(-z+1/2, -x+1/2, y)',
                          '(-z, x, -y)', '(-z, x+1/2, -y+1/2)',
                          '(-z+1/2, x, -y+1/2)', '(-z+1/2, x+1/2, -y)',
                          '(y, z, x)', '(y, z+1/2, x+1/2)',
                          '(y+1/2, z, x+1/2)', '(y+1/2, z+1/2, x)',
                          '(-y, z, -x)', '(-y, z+1/2, -x+1/2)',
                          '(-y+1/2, z, -x+1/2)', '(-y+1/2, z+1/2, -x)',
                          '(y, -z, -x)', '(y, -z+1/2, -x+1/2)',
                          '(y+1/2, -z, -x+1/2)', '(y+1/2, -z+1/2, -x)',
                          '(-y, -z, x)', '(-y, -z+1/2, x+1/2)',
                          '(-y+1/2, -z, x+1/2)', '(-y+1/2, -z+1/2, x)'),
                      'hkl: h+k,h+l,k+l=2n, 0kl: k,l=2n, hhl: h+l=2n, '
                      'h00: h=2n')},
      '197': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)'), None),
              '6b': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 0)', '(1/2, 0, 1/2)',
                         '(0, 1/2, 0)', '(1/2, 1/2, 0)', '(0, 0, 1/2)'), None
                     ),
              '8c': (1, ('(x, x, x)', '(x+1/2, x+1/2, x+1/2)', '(-x, -x, x)',
                         '(-x+1/2, -x+1/2, x+1/2)', '(-x, x, -x)',
                         '(-x+1/2, x+1/2, -x+1/2)', '(x, -x, -x)',
                         '(x+1/2, -x+1/2, -x+1/2)'), None),
              '12d': (1, ('(x, 0, 0)', '(x+1/2, 1/2, 1/2)', '(-x, 0, 0)',
                          '(-x+1/2, 1/2, 1/2)', '(0, x, 0)',
                          '(1/2, x+1/2, 1/2)', '(0, -x, 0)',
                          '(1/2, -x+1/2, 1/2)', '(0, 0, x)',
                          '(1/2, 1/2, x+1/2)', '(0, 0, -x)',
                          '(1/2, 1/2, -x+1/2)'), None),
              '12e': (1, ('(x, 1/2, 0)', '(x+1/2, 0, 1/2)', '(-x, 1/2, 0)',
                          '(-x+1/2, 0, 1/2)', '(0, x, 1/2)',
                          '(1/2, x+1/2, 0)', '(0, -x, 1/2)',
                          '(1/2, -x+1/2, 0)', '(1/2, 0, x)',
                          '(0, 1/2, x+1/2)', '(1/2, 0, -x)',
                          '(0, 1/2, -x+1/2)'), None),
              '24f': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                          '(-x+1/2, -y+1/2, z+1/2)', '(-x, y, -z)',
                          '(-x+1/2, y+1/2, -z+1/2)', '(x, -y, -z)',
                          '(x+1/2, -y+1/2, -z+1/2)', '(z, x, y)',
                          '(z+1/2, x+1/2, y+1/2)', '(z, -x, -y)',
                          '(z+1/2, -x+1/2, -y+1/2)', '(-z, -x, y)',
                          '(-z+1/2, -x+1/2, y+1/2)', '(-z, x, -y)',
                          '(-z+1/2, x+1/2, -y+1/2)', '(y, z, x)',
                          '(y+1/2, z+1/2, x+1/2)', '(-y, z, -x)',
                          '(-y+1/2, z+1/2, -x+1/2)', '(y, -z, -x)',
                          '(y+1/2, -z+1/2, -x+1/2)', '(-y, -z, x)',
                          '(-y+1/2, -z+1/2, x+1/2)'),
                      'hkl: h+k+l=2n, 0kl: k+l=2n, hhl: l=2n, h00: h=2n')},
      '198': {'4a': (1, ('(x, x, x)', '(-x+1/2, -x, x+1/2)',
                         '(-x, x+1/2, -x+1/2)', '(x+1/2, -x+1/2, -x)'), None),
              '12b': (7, ('(x, y, z)', '(-x+1/2, -y, z+1/2)',
                          '(-x, y+1/2, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                          '(z, x, y)', '(z+1/2, -x+1/2, -y)',
                          '(-z+1/2, -x, y+1/2)', '(-z, x+1/2, -y+1/2)',
                          '(y, z, x)', '(-y, z+1/2, -x+1/2)',
                          '(y+1/2, -z+1/2, -x)', '(-y+1/2, -z, x+1/2)'),
                      'h00: h=2n')},
      '199': {'8a': (1, ('(x, x, x)', '(x+1/2, x+1/2, x+1/2)',
                         '(-x+1/2, -x, x+1/2)', '(-x, -x+1/2, x)',
                         '(-x, x+1/2, -x+1/2)', '(-x+1/2, x, -x)',
                         '(x+1/2, -x+1/2, -x)', '(x, -x, -x+1/2)'), None),
              '12b': (1, ('(x, 0, 1/4)', '(x+1/2, 1/2, 3/4)',
                          '(-x+1/2, 0, 3/4)', '(-x, 1/2, 1/4)', '(1/4, x, 0)',
                          '(3/4, x+1/2, 1/2)', '(3/4, -x+1/2, 0)',
                          '(1/4, -x, 1/2)', '(0, 1/4, x)',
                          '(1/2, 3/4, x+1/2)', '(0, 3/4, -x+1/2)',
                          '(1/2, 1/4, -x)'), None),
              '24c': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)',
                          '(-x+1/2, -y, z+1/2)', '(-x, -y+1/2, z)',
                          '(-x, y+1/2, -z+1/2)', '(-x+1/2, y, -z)',
                          '(x+1/2, -y+1/2, -z)', '(x, -y, -z+1/2)',
                          '(z, x, y)', '(z+1/2, x+1/2, y+1/2)',
                          '(z+1/2, -x+1/2, -y)', '(z, -x, -y+1/2)',
                          '(-z+1/2, -x, y+1/2)', '(-z, -x+1/2, y)',
                          '(-z, x+1/2, -y+1/2)', '(-z+1/2, x, -y)',
                          '(y, z, x)', '(y+1/2, z+1/2, x+1/2)',
                          '(-y, z+1/2, -x+1/2)', '(-y+1/2, z, -x)',
                          '(y+1/2, -z+1/2, -x)', '(y, -z, -x+1/2)',
                          '(-y+1/2, -z, x+1/2)', '(-y, -z+1/2, x)'),
                      'hkl: h+k+l=2n, 0kl: k+l=2n, hhl: l=2n, h00: h=2n')},
      '200': {'1a': (0, ('(0, 0, 0)', ), None),
              '1b': (0, ('(1/2, 1/2, 1/2)', ), None),
              '3c': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)', '(1/2, 1/2, 0)'),
                     None),
              '3d': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(0, 0, 1/2)'), None),
              '6e': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(0, x, 0)', '(0, -x, 0)',
                         '(0, 0, x)', '(0, 0, -x)'), None),
              '6f': (1, ('(x, 0, 1/2)', '(-x, 0, 1/2)', '(1/2, x, 0)',
                         '(1/2, -x, 0)', '(0, 1/2, x)', '(0, 1/2, -x)'), None
                     ),
              '6g': (1, ('(x, 1/2, 0)', '(-x, 1/2, 0)', '(0, x, 1/2)',
                         '(0, -x, 1/2)', '(1/2, 0, x)', '(1/2, 0, -x)'), None
                     ),
              '6h': (1, ('(x, 1/2, 1/2)', '(-x, 1/2, 1/2)', '(1/2, x, 1/2)',
                         '(1/2, -x, 1/2)', '(1/2, 1/2, x)', '(1/2, 1/2, -x)'),
                     None),
              '8i': (1, ('(x, x, x)', '(-x, -x, x)', '(-x, x, -x)',
                         '(x, -x, -x)', '(-x, -x, -x)', '(x, x, -x)',
                         '(x, -x, x)', '(-x, x, x)'), None),
              '12j': (6, ('(0, y, z)', '(0, -y, z)', '(0, y, -z)',
                          '(0, -y, -z)', '(z, 0, y)', '(z, 0, -y)',
                          '(-z, 0, y)', '(-z, 0, -y)', '(y, z, 0)',
                          '(-y, z, 0)', '(y, -z, 0)', '(-y, -z, 0)'), None),
              '12k': (6, ('(1/2, y, z)', '(1/2, -y, z)', '(1/2, y, -z)',
                          '(1/2, -y, -z)', '(z, 1/2, y)', '(z, 1/2, -y)',
                          '(-z, 1/2, y)', '(-z, 1/2, -y)', '(y, z, 1/2)',
                          '(-y, z, 1/2)', '(y, -z, 1/2)', '(-y, -z, 1/2)'),
                      None),
              '24l': (7, ('(x, y, z)', '(-x, -y, z)', '(-x, y, -z)',
                          '(x, -y, -z)', '(z, x, y)', '(z, -x, -y)',
                          '(-z, -x, y)', '(-z, x, -y)', '(y, z, x)',
                          '(-y, z, -x)', '(y, -z, -x)', '(-y, -z, x)',
                          '(-x, -y, -z)', '(x, y, -z)', '(x, -y, z)',
                          '(-x, y, z)', '(-z, -x, -y)', '(-z, x, y)',
                          '(z, x, -y)', '(z, -x, y)', '(-y, -z, -x)',
                          '(y, -z, x)', '(-y, z, x)', '(y, z, -x)'), None)},
      '201:1': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)'), 'hkl: h+k+l=2n'),
                '4b': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 1/4)',
                           '(3/4, 1/4, 3/4)', '(1/4, 3/4, 3/4)'),
                       'hkl: h+k,h+l,k+l=2n'),
                '4c': (0, ('(3/4, 3/4, 3/4)', '(1/4, 1/4, 3/4)',
                           '(1/4, 3/4, 1/4)', '(3/4, 1/4, 1/4)'),
                       'hkl: h+k,h+l,k+l=2n'),
                '6d': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)', '(1/2, 1/2, 0)',
                           '(1/2, 0, 0)', '(0, 1/2, 0)', '(0, 0, 1/2)'),
                       'hkl: h+k+l=2n'),
                '8e': (1, ('(x, x, x)', '(-x, -x, x)', '(-x, x, -x)',
                           '(x, -x, -x)', '(-x+1/2, -x+1/2, -x+1/2)',
                           '(x+1/2, x+1/2, -x+1/2)', '(x+1/2, -x+1/2, x+1/2)',
                           '(-x+1/2, x+1/2, x+1/2)'), None),
                '12f': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(0, x, 0)',
                            '(0, -x, 0)', '(0, 0, x)', '(0, 0, -x)',
                            '(-x+1/2, 1/2, 1/2)', '(x+1/2, 1/2, 1/2)',
                            '(1/2, -x+1/2, 1/2)', '(1/2, x+1/2, 1/2)',
                            '(1/2, 1/2, -x+1/2)', '(1/2, 1/2, x+1/2)'),
                        'hkl: h+k+l=2n'),
                '12g': (1, ('(x, 1/2, 0)', '(-x, 1/2, 0)', '(0, x, 1/2)',
                            '(0, -x, 1/2)', '(1/2, 0, x)', '(1/2, 0, -x)',
                            '(-x+1/2, 0, 1/2)', '(x+1/2, 0, 1/2)',
                            '(1/2, -x+1/2, 0)', '(1/2, x+1/2, 0)',
                            '(0, 1/2, -x+1/2)', '(0, 1/2, x+1/2)'),
                        'hkl: h+k+l=2n'),
                '24h': (7, ('(x, y, z)', '(-x, -y, z)', '(-x, y, -z)',
                            '(x, -y, -z)', '(z, x, y)', '(z, -x, -y)',
                            '(-z, -x, y)', '(-z, x, -y)', '(y, z, x)',
                            '(-y, z, -x)', '(y, -z, -x)', '(-y, -z, x)',
                            '(-x+1/2, -y+1/2, -z+1/2)',
                            '(x+1/2, y+1/2, -z+1/2)',
                            '(x+1/2, -y+1/2, z+1/2)',
                            '(-x+1/2, y+1/2, z+1/2)',
                            '(-z+1/2, -x+1/2, -y+1/2)',
                            '(-z+1/2, x+1/2, y+1/2)',
                            '(z+1/2, x+1/2, -y+1/2)',
                            '(z+1/2, -x+1/2, y+1/2)',
                            '(-y+1/2, -z+1/2, -x+1/2)',
                            '(y+1/2, -z+1/2, x+1/2)',
                            '(-y+1/2, z+1/2, x+1/2)',
                            '(y+1/2, z+1/2, -x+1/2)'), '0kl: k+l=2n, '
                        'h00: h=2n')},
      '201:2': {'2a': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)'), 'n/a'),
                '4b': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(1/2, 0, 1/2)',
                           '(0, 1/2, 1/2)'), 'n/a'),
                '4c': (0, ('(1/2, 1/2, 1/2)', '(0, 0, 1/2)', '(0, 1/2, 0)',
                           '(1/2, 0, 0)'), 'n/a'),
                '6d': (0, ('(1/4, 3/4, 3/4)', '(3/4, 1/4, 3/4)',
                           '(3/4, 3/4, 1/4)', '(3/4, 1/4, 1/4)',
                           '(1/4, 3/4, 1/4)', '(1/4, 1/4, 3/4)'), 'n/a'),
                '8e': (1, ('(x, x, x)', '(-x+1/2, -x+1/2, x)',
                           '(-x+1/2, x, -x+1/2)', '(x, -x+1/2, -x+1/2)',
                           '(-x, -x, -x)', '(x+1/2, x+1/2, -x)',
                           '(x+1/2, -x, x+1/2)', '(-x, x+1/2, x+1/2)'), 'n/a'
                       ),
                '12f': (1, ('(x, 1/4, 1/4)', '(-x+1/2, 1/4, 1/4)',
                            '(1/4, x, 1/4)', '(1/4, -x+1/2, 1/4)',
                            '(1/4, 1/4, x)', '(1/4, 1/4, -x+1/2)',
                            '(-x, 3/4, 3/4)', '(x+1/2, 3/4, 3/4)',
                            '(3/4, -x, 3/4)', '(3/4, x+1/2, 3/4)',
                            '(3/4, 3/4, -x)', '(3/4, 3/4, x+1/2)'), 'n/a'),
                '12g': (1, ('(x, 3/4, 1/4)', '(-x+1/2, 3/4, 1/4)',
                            '(1/4, x, 3/4)', '(1/4, -x+1/2, 3/4)',
                            '(3/4, 1/4, x)', '(3/4, 1/4, -x+1/2)',
                            '(-x, 1/4, 3/4)', '(x+1/2, 1/4, 3/4)',
                            '(3/4, -x, 1/4)', '(3/4, x+1/2, 1/4)',
                            '(1/4, 3/4, -x)', '(1/4, 3/4, x+1/2)'), 'n/a'),
                '24h': (7, ('(x, y, z)', '(-x+1/2, -y+1/2, z)',
                            '(-x+1/2, y, -z+1/2)', '(x, -y+1/2, -z+1/2)',
                            '(z, x, y)', '(z, -x+1/2, -y+1/2)',
                            '(-z+1/2, -x+1/2, y)', '(-z+1/2, x, -y+1/2)',
                            '(y, z, x)', '(-y+1/2, z, -x+1/2)',
                            '(y, -z+1/2, -x+1/2)', '(-y+1/2, -z+1/2, x)',
                            '(-x, -y, -z)', '(x+1/2, y+1/2, -z)',
                            '(x+1/2, -y, z+1/2)', '(-x, y+1/2, z+1/2)',
                            '(-z, -x, -y)', '(-z, x+1/2, y+1/2)',
                            '(z+1/2, x+1/2, -y)', '(z+1/2, -x, y+1/2)',
                            '(-y, -z, -x)', '(y+1/2, -z, x+1/2)',
                            '(-y, z+1/2, x+1/2)', '(y+1/2, z+1/2, -x)'), 'n/a'
                        )},
      '202': {'4a': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                         '(1/2, 1/2, 0)'), None),
              '4b': (0, ('(1/2, 1/2, 1/2)', '(1/2, 0, 0)', '(0, 1/2, 0)',
                         '(0, 0, 1/2)'), None),
              '8c': (0, ('(1/4, 1/4, 1/4)', '(1/4, 3/4, 3/4)',
                         '(3/4, 1/4, 3/4)', '(3/4, 3/4, 1/4)',
                         '(3/4, 3/4, 3/4)', '(3/4, 1/4, 1/4)',
                         '(1/4, 3/4, 1/4)', '(1/4, 1/4, 3/4)'), 'hkl: h=2n'),
              '24d': (0, ('(0, 1/4, 1/4)', '(0, 3/4, 3/4)', '(1/2, 1/4, 3/4)',
                          '(1/2, 3/4, 1/4)', '(0, 3/4, 1/4)', '(0, 1/4, 3/4)',
                          '(1/2, 3/4, 3/4)', '(1/2, 1/4, 1/4)',
                          '(1/4, 0, 1/4)', '(1/4, 1/2, 3/4)', '(3/4, 0, 3/4)',
                          '(3/4, 1/2, 1/4)', '(1/4, 0, 3/4)',
                          '(1/4, 1/2, 1/4)', '(3/4, 0, 1/4)',
                          '(3/4, 1/2, 3/4)', '(1/4, 1/4, 0)',
                          '(1/4, 3/4, 1/2)', '(3/4, 1/4, 1/2)',
                          '(3/4, 3/4, 0)', '(3/4, 1/4, 0)', '(3/4, 3/4, 1/2)',
                          '(1/4, 1/4, 1/2)', '(1/4, 3/4, 0)'), 'hkl: h=2n'),
              '24e': (1, ('(x, 0, 0)', '(x, 1/2, 1/2)', '(x+1/2, 0, 1/2)',
                          '(x+1/2, 1/2, 0)', '(-x, 0, 0)', '(-x, 1/2, 1/2)',
                          '(-x+1/2, 0, 1/2)', '(-x+1/2, 1/2, 0)', '(0, x, 0)',
                          '(0, x+1/2, 1/2)', '(1/2, x, 1/2)',
                          '(1/2, x+1/2, 0)', '(0, -x, 0)', '(0, -x+1/2, 1/2)',
                          '(1/2, -x, 1/2)', '(1/2, -x+1/2, 0)', '(0, 0, x)',
                          '(0, 1/2, x+1/2)', '(1/2, 0, x+1/2)',
                          '(1/2, 1/2, x)', '(0, 0, -x)', '(0, 1/2, -x+1/2)',
                          '(1/2, 0, -x+1/2)', '(1/2, 1/2, -x)'), None),
              '32f': (1, ('(x, x, x)', '(x, x+1/2, x+1/2)',
                          '(x+1/2, x, x+1/2)', '(x+1/2, x+1/2, x)',
                          '(-x, -x, x)', '(-x, -x+1/2, x+1/2)',
                          '(-x+1/2, -x, x+1/2)', '(-x+1/2, -x+1/2, x)',
                          '(-x, x, -x)', '(-x, x+1/2, -x+1/2)',
                          '(-x+1/2, x, -x+1/2)', '(-x+1/2, x+1/2, -x)',
                          '(x, -x, -x)', '(x, -x+1/2, -x+1/2)',
                          '(x+1/2, -x, -x+1/2)', '(x+1/2, -x+1/2, -x)',
                          '(-x, -x, -x)', '(-x, -x+1/2, -x+1/2)',
                          '(-x+1/2, -x, -x+1/2)', '(-x+1/2, -x+1/2, -x)',
                          '(x, x, -x)', '(x, x+1/2, -x+1/2)',
                          '(x+1/2, x, -x+1/2)', '(x+1/2, x+1/2, -x)',
                          '(x, -x, x)', '(x, -x+1/2, x+1/2)',
                          '(x+1/2, -x, x+1/2)', '(x+1/2, -x+1/2, x)',
                          '(-x, x, x)', '(-x, x+1/2, x+1/2)',
                          '(-x+1/2, x, x+1/2)', '(-x+1/2, x+1/2, x)'), None),
              '48g': (1, ('(x, 1/4, 1/4)', '(x, 3/4, 3/4)',
                          '(x+1/2, 1/4, 3/4)', '(x+1/2, 3/4, 1/4)',
                          '(-x, 3/4, 1/4)', '(-x, 1/4, 3/4)',
                          '(-x+1/2, 3/4, 3/4)', '(-x+1/2, 1/4, 1/4)',
                          '(1/4, x, 1/4)', '(1/4, x+1/2, 3/4)',
                          '(3/4, x, 3/4)', '(3/4, x+1/2, 1/4)',
                          '(1/4, -x, 3/4)', '(1/4, -x+1/2, 1/4)',
                          '(3/4, -x, 1/4)', '(3/4, -x+1/2, 3/4)',
                          '(1/4, 1/4, x)', '(1/4, 3/4, x+1/2)',
                          '(3/4, 1/4, x+1/2)', '(3/4, 3/4, x)',
                          '(3/4, 1/4, -x)', '(3/4, 3/4, -x+1/2)',
                          '(1/4, 1/4, -x+1/2)', '(1/4, 3/4, -x)',
                          '(-x, 3/4, 3/4)', '(-x, 1/4, 1/4)',
                          '(-x+1/2, 3/4, 1/4)', '(-x+1/2, 1/4, 3/4)',
                          '(x, 1/4, 3/4)', '(x, 3/4, 1/4)',
                          '(x+1/2, 1/4, 1/4)', '(x+1/2, 3/4, 3/4)',
                          '(3/4, -x, 3/4)', '(3/4, -x+1/2, 1/4)',
                          '(1/4, -x, 1/4)', '(1/4, -x+1/2, 3/4)',
                          '(3/4, x, 1/4)', '(3/4, x+1/2, 3/4)',
                          '(1/4, x, 3/4)', '(1/4, x+1/2, 1/4)',
                          '(3/4, 3/4, -x)', '(3/4, 1/4, -x+1/2)',
                          '(1/4, 3/4, -x+1/2)', '(1/4, 1/4, -x)',
                          '(1/4, 3/4, x)', '(1/4, 1/4, x+1/2)',
                          '(3/4, 3/4, x+1/2)', '(3/4, 1/4, x)'), 'hkl: h=2n'),
              '48h': (6, ('(0, y, z)', '(0, y+1/2, z+1/2)', '(1/2, y, z+1/2)',
                          '(1/2, y+1/2, z)', '(0, -y, z)',
                          '(0, -y+1/2, z+1/2)', '(1/2, -y, z+1/2)',
                          '(1/2, -y+1/2, z)', '(0, y, -z)',
                          '(0, y+1/2, -z+1/2)', '(1/2, y, -z+1/2)',
                          '(1/2, y+1/2, -z)', '(0, -y, -z)',
                          '(0, -y+1/2, -z+1/2)', '(1/2, -y, -z+1/2)',
                          '(1/2, -y+1/2, -z)', '(z, 0, y)', '(z, 1/2, y+1/2)',
                          '(z+1/2, 0, y+1/2)', '(z+1/2, 1/2, y)',
                          '(z, 0, -y)', '(z, 1/2, -y+1/2)',
                          '(z+1/2, 0, -y+1/2)', '(z+1/2, 1/2, -y)',
                          '(-z, 0, y)', '(-z, 1/2, y+1/2)',
                          '(-z+1/2, 0, y+1/2)', '(-z+1/2, 1/2, y)',
                          '(-z, 0, -y)', '(-z, 1/2, -y+1/2)',
                          '(-z+1/2, 0, -y+1/2)', '(-z+1/2, 1/2, -y)',
                          '(y, z, 0)', '(y, z+1/2, 1/2)', '(y+1/2, z, 1/2)',
                          '(y+1/2, z+1/2, 0)', '(-y, z, 0)',
                          '(-y, z+1/2, 1/2)', '(-y+1/2, z, 1/2)',
                          '(-y+1/2, z+1/2, 0)', '(y, -z, 0)',
                          '(y, -z+1/2, 1/2)', '(y+1/2, -z, 1/2)',
                          '(y+1/2, -z+1/2, 0)', '(-y, -z, 0)',
                          '(-y, -z+1/2, 1/2)', '(-y+1/2, -z, 1/2)',
                          '(-y+1/2, -z+1/2, 0)'), None),
              '96i': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)',
                          '(x+1/2, y, z+1/2)', '(x+1/2, y+1/2, z)',
                          '(-x, -y, z)', '(-x, -y+1/2, z+1/2)',
                          '(-x+1/2, -y, z+1/2)', '(-x+1/2, -y+1/2, z)',
                          '(-x, y, -z)', '(-x, y+1/2, -z+1/2)',
                          '(-x+1/2, y, -z+1/2)', '(-x+1/2, y+1/2, -z)',
                          '(x, -y, -z)', '(x, -y+1/2, -z+1/2)',
                          '(x+1/2, -y, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                          '(z, x, y)', '(z, x+1/2, y+1/2)',
                          '(z+1/2, x, y+1/2)', '(z+1/2, x+1/2, y)',
                          '(z, -x, -y)', '(z, -x+1/2, -y+1/2)',
                          '(z+1/2, -x, -y+1/2)', '(z+1/2, -x+1/2, -y)',
                          '(-z, -x, y)', '(-z, -x+1/2, y+1/2)',
                          '(-z+1/2, -x, y+1/2)', '(-z+1/2, -x+1/2, y)',
                          '(-z, x, -y)', '(-z, x+1/2, -y+1/2)',
                          '(-z+1/2, x, -y+1/2)', '(-z+1/2, x+1/2, -y)',
                          '(y, z, x)', '(y, z+1/2, x+1/2)',
                          '(y+1/2, z, x+1/2)', '(y+1/2, z+1/2, x)',
                          '(-y, z, -x)', '(-y, z+1/2, -x+1/2)',
                          '(-y+1/2, z, -x+1/2)', '(-y+1/2, z+1/2, -x)',
                          '(y, -z, -x)', '(y, -z+1/2, -x+1/2)',
                          '(y+1/2, -z, -x+1/2)', '(y+1/2, -z+1/2, -x)',
                          '(-y, -z, x)', '(-y, -z+1/2, x+1/2)',
                          '(-y+1/2, -z, x+1/2)', '(-y+1/2, -z+1/2, x)',
                          '(-x, -y, -z)', '(-x, -y+1/2, -z+1/2)',
                          '(-x+1/2, -y, -z+1/2)', '(-x+1/2, -y+1/2, -z)',
                          '(x, y, -z)', '(x, y+1/2, -z+1/2)',
                          '(x+1/2, y, -z+1/2)', '(x+1/2, y+1/2, -z)',
                          '(x, -y, z)', '(x, -y+1/2, z+1/2)',
                          '(x+1/2, -y, z+1/2)', '(x+1/2, -y+1/2, z)',
                          '(-x, y, z)', '(-x, y+1/2, z+1/2)',
                          '(-x+1/2, y, z+1/2)', '(-x+1/2, y+1/2, z)',
                          '(-z, -x, -y)', '(-z, -x+1/2, -y+1/2)',
                          '(-z+1/2, -x, -y+1/2)', '(-z+1/2, -x+1/2, -y)',
                          '(-z, x, y)', '(-z, x+1/2, y+1/2)',
                          '(-z+1/2, x, y+1/2)', '(-z+1/2, x+1/2, y)',
                          '(z, x, -y)', '(z, x+1/2, -y+1/2)',
                          '(z+1/2, x, -y+1/2)', '(z+1/2, x+1/2, -y)',
                          '(z, -x, y)', '(z, -x+1/2, y+1/2)',
                          '(z+1/2, -x, y+1/2)', '(z+1/2, -x+1/2, y)',
                          '(-y, -z, -x)', '(-y, -z+1/2, -x+1/2)',
                          '(-y+1/2, -z, -x+1/2)', '(-y+1/2, -z+1/2, -x)',
                          '(y, -z, x)', '(y, -z+1/2, x+1/2)',
                          '(y+1/2, -z, x+1/2)', '(y+1/2, -z+1/2, x)',
                          '(-y, z, x)', '(-y, z+1/2, x+1/2)',
                          '(-y+1/2, z, x+1/2)', '(-y+1/2, z+1/2, x)',
                          '(y, z, -x)', '(y, z+1/2, -x+1/2)',
                          '(y+1/2, z, -x+1/2)', '(y+1/2, z+1/2, -x)'),
                      'hkl: h+k,h+l,k+l=2n, 0kl: k,l=2n, hhl: h+l=2n, '
                      'h00: h=2n')},
      '203:1': {'8a': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                           '(1/2, 1/2, 0)', '(1/4, 1/4, 1/4)',
                           '(1/4, 3/4, 3/4)', '(3/4, 1/4, 3/4)',
                           '(3/4, 3/4, 1/4)'), 'hkl: h=2n+1 or h+k+l=4n'),
                '8b': (0, ('(1/2, 1/2, 1/2)', '(1/2, 0, 0)', '(0, 1/2, 0)',
                           '(0, 0, 1/2)', '(3/4, 3/4, 3/4)',
                           '(3/4, 1/4, 1/4)', '(1/4, 3/4, 1/4)',
                           '(1/4, 1/4, 3/4)'), 'hkl: h=2n+1 or h+k+l=4n'),
                '16c': (0, ('(1/8, 1/8, 1/8)', '(1/8, 5/8, 5/8)',
                            '(5/8, 1/8, 5/8)', '(5/8, 5/8, 1/8)',
                            '(7/8, 7/8, 1/8)', '(7/8, 3/8, 5/8)',
                            '(3/8, 7/8, 5/8)', '(3/8, 3/8, 1/8)',
                            '(7/8, 1/8, 7/8)', '(7/8, 5/8, 3/8)',
                            '(3/8, 1/8, 3/8)', '(3/8, 5/8, 7/8)',
                            '(1/8, 7/8, 7/8)', '(1/8, 3/8, 3/8)',
                            '(5/8, 7/8, 3/8)', '(5/8, 3/8, 7/8)'),
                        'hkl: h=2n+1 or h,k,l=4n+2 or h,k,l=4n'),
                '16d': (0, ('(5/8, 5/8, 5/8)', '(5/8, 1/8, 1/8)',
                            '(1/8, 5/8, 1/8)', '(1/8, 1/8, 5/8)',
                            '(3/8, 3/8, 5/8)', '(3/8, 7/8, 1/8)',
                            '(7/8, 3/8, 1/8)', '(7/8, 7/8, 5/8)',
                            '(3/8, 5/8, 3/8)', '(3/8, 1/8, 7/8)',
                            '(7/8, 5/8, 7/8)', '(7/8, 1/8, 3/8)',
                            '(5/8, 3/8, 3/8)', '(5/8, 7/8, 7/8)',
                            '(1/8, 3/8, 7/8)', '(1/8, 7/8, 3/8)'),
                        'hkl: h=2n+1 or h,k,l=4n+2 or h,k,l=4n'),
                '32e': (1, ('(x, x, x)', '(x, x+1/2, x+1/2)',
                            '(x+1/2, x, x+1/2)', '(x+1/2, x+1/2, x)',
                            '(-x, -x, x)', '(-x, -x+1/2, x+1/2)',
                            '(-x+1/2, -x, x+1/2)', '(-x+1/2, -x+1/2, x)',
                            '(-x, x, -x)', '(-x, x+1/2, -x+1/2)',
                            '(-x+1/2, x, -x+1/2)', '(-x+1/2, x+1/2, -x)',
                            '(x, -x, -x)', '(x, -x+1/2, -x+1/2)',
                            '(x+1/2, -x, -x+1/2)', '(x+1/2, -x+1/2, -x)',
                            '(-x+1/4, -x+1/4, -x+1/4)',
                            '(-x+1/4, -x+3/4, -x+3/4)',
                            '(-x+3/4, -x+1/4, -x+3/4)',
                            '(-x+3/4, -x+3/4, -x+1/4)',
                            '(x+1/4, x+1/4, -x+1/4)',
                            '(x+1/4, x+3/4, -x+3/4)',
                            '(x+3/4, x+1/4, -x+3/4)',
                            '(x+3/4, x+3/4, -x+1/4)',
                            '(x+1/4, -x+1/4, x+1/4)',
                            '(x+1/4, -x+3/4, x+3/4)',
                            '(x+3/4, -x+1/4, x+3/4)',
                            '(x+3/4, -x+3/4, x+1/4)',
                            '(-x+1/4, x+1/4, x+1/4)',
                            '(-x+1/4, x+3/4, x+3/4)',
                            '(-x+3/4, x+1/4, x+3/4)',
                            '(-x+3/4, x+3/4, x+1/4)'), None),
                '48f': (1, ('(x, 0, 0)', '(x, 1/2, 1/2)', '(x+1/2, 0, 1/2)',
                            '(x+1/2, 1/2, 0)', '(-x, 0, 0)', '(-x, 1/2, 1/2)',
                            '(-x+1/2, 0, 1/2)', '(-x+1/2, 1/2, 0)',
                            '(0, x, 0)', '(0, x+1/2, 1/2)', '(1/2, x, 1/2)',
                            '(1/2, x+1/2, 0)', '(0, -x, 0)',
                            '(0, -x+1/2, 1/2)', '(1/2, -x, 1/2)',
                            '(1/2, -x+1/2, 0)', '(0, 0, x)',
                            '(0, 1/2, x+1/2)', '(1/2, 0, x+1/2)',
                            '(1/2, 1/2, x)', '(0, 0, -x)', '(0, 1/2, -x+1/2)',
                            '(1/2, 0, -x+1/2)', '(1/2, 1/2, -x)',
                            '(-x+1/4, 1/4, 1/4)', '(-x+1/4, 3/4, 3/4)',
                            '(-x+3/4, 1/4, 3/4)', '(-x+3/4, 3/4, 1/4)',
                            '(x+1/4, 1/4, 1/4)', '(x+1/4, 3/4, 3/4)',
                            '(x+3/4, 1/4, 3/4)', '(x+3/4, 3/4, 1/4)',
                            '(1/4, -x+1/4, 1/4)', '(1/4, -x+3/4, 3/4)',
                            '(3/4, -x+1/4, 3/4)', '(3/4, -x+3/4, 1/4)',
                            '(1/4, x+1/4, 1/4)', '(1/4, x+3/4, 3/4)',
                            '(3/4, x+1/4, 3/4)', '(3/4, x+3/4, 1/4)',
                            '(1/4, 1/4, -x+1/4)', '(1/4, 3/4, -x+3/4)',
                            '(3/4, 1/4, -x+3/4)', '(3/4, 3/4, -x+1/4)',
                            '(1/4, 1/4, x+1/4)', '(1/4, 3/4, x+3/4)',
                            '(3/4, 1/4, x+3/4)', '(3/4, 3/4, x+1/4)'),
                        'hkl: h=2n+1 or h+k+l=4n'),
                '96g': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)',
                            '(x+1/2, y, z+1/2)', '(x+1/2, y+1/2, z)',
                            '(-x, -y, z)', '(-x, -y+1/2, z+1/2)',
                            '(-x+1/2, -y, z+1/2)', '(-x+1/2, -y+1/2, z)',
                            '(-x, y, -z)', '(-x, y+1/2, -z+1/2)',
                            '(-x+1/2, y, -z+1/2)', '(-x+1/2, y+1/2, -z)',
                            '(x, -y, -z)', '(x, -y+1/2, -z+1/2)',
                            '(x+1/2, -y, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                            '(z, x, y)', '(z, x+1/2, y+1/2)',
                            '(z+1/2, x, y+1/2)', '(z+1/2, x+1/2, y)',
                            '(z, -x, -y)', '(z, -x+1/2, -y+1/2)',
                            '(z+1/2, -x, -y+1/2)', '(z+1/2, -x+1/2, -y)',
                            '(-z, -x, y)', '(-z, -x+1/2, y+1/2)',
                            '(-z+1/2, -x, y+1/2)', '(-z+1/2, -x+1/2, y)',
                            '(-z, x, -y)', '(-z, x+1/2, -y+1/2)',
                            '(-z+1/2, x, -y+1/2)', '(-z+1/2, x+1/2, -y)',
                            '(y, z, x)', '(y, z+1/2, x+1/2)',
                            '(y+1/2, z, x+1/2)', '(y+1/2, z+1/2, x)',
                            '(-y, z, -x)', '(-y, z+1/2, -x+1/2)',
                            '(-y+1/2, z, -x+1/2)', '(-y+1/2, z+1/2, -x)',
                            '(y, -z, -x)', '(y, -z+1/2, -x+1/2)',
                            '(y+1/2, -z, -x+1/2)', '(y+1/2, -z+1/2, -x)',
                            '(-y, -z, x)', '(-y, -z+1/2, x+1/2)',
                            '(-y+1/2, -z, x+1/2)', '(-y+1/2, -z+1/2, x)',
                            '(-x+1/4, -y+1/4, -z+1/4)',
                            '(-x+1/4, -y+3/4, -z+3/4)',
                            '(-x+3/4, -y+1/4, -z+3/4)',
                            '(-x+3/4, -y+3/4, -z+1/4)',
                            '(x+1/4, y+1/4, -z+1/4)',
                            '(x+1/4, y+3/4, -z+3/4)',
                            '(x+3/4, y+1/4, -z+3/4)',
                            '(x+3/4, y+3/4, -z+1/4)',
                            '(x+1/4, -y+1/4, z+1/4)',
                            '(x+1/4, -y+3/4, z+3/4)',
                            '(x+3/4, -y+1/4, z+3/4)',
                            '(x+3/4, -y+3/4, z+1/4)',
                            '(-x+1/4, y+1/4, z+1/4)',
                            '(-x+1/4, y+3/4, z+3/4)',
                            '(-x+3/4, y+1/4, z+3/4)',
                            '(-x+3/4, y+3/4, z+1/4)',
                            '(-z+1/4, -x+1/4, -y+1/4)',
                            '(-z+1/4, -x+3/4, -y+3/4)',
                            '(-z+3/4, -x+1/4, -y+3/4)',
                            '(-z+3/4, -x+3/4, -y+1/4)',
                            '(-z+1/4, x+1/4, y+1/4)',
                            '(-z+1/4, x+3/4, y+3/4)',
                            '(-z+3/4, x+1/4, y+3/4)',
                            '(-z+3/4, x+3/4, y+1/4)',
                            '(z+1/4, x+1/4, -y+1/4)',
                            '(z+1/4, x+3/4, -y+3/4)',
                            '(z+3/4, x+1/4, -y+3/4)',
                            '(z+3/4, x+3/4, -y+1/4)',
                            '(z+1/4, -x+1/4, y+1/4)',
                            '(z+1/4, -x+3/4, y+3/4)',
                            '(z+3/4, -x+1/4, y+3/4)',
                            '(z+3/4, -x+3/4, y+1/4)',
                            '(-y+1/4, -z+1/4, -x+1/4)',
                            '(-y+1/4, -z+3/4, -x+3/4)',
                            '(-y+3/4, -z+1/4, -x+3/4)',
                            '(-y+3/4, -z+3/4, -x+1/4)',
                            '(y+1/4, -z+1/4, x+1/4)',
                            '(y+1/4, -z+3/4, x+3/4)',
                            '(y+3/4, -z+1/4, x+3/4)',
                            '(y+3/4, -z+3/4, x+1/4)',
                            '(-y+1/4, z+1/4, x+1/4)',
                            '(-y+1/4, z+3/4, x+3/4)',
                            '(-y+3/4, z+1/4, x+3/4)',
                            '(-y+3/4, z+3/4, x+1/4)',
                            '(y+1/4, z+1/4, -x+1/4)',
                            '(y+1/4, z+3/4, -x+3/4)',
                            '(y+3/4, z+1/4, -x+3/4)',
                            '(y+3/4, z+3/4, -x+1/4)'),
                        'hkl: h+k,h+l,k+l=2n, 0kl: k+l=4n, k,l=2n, '
                        'hhl: h+l=2n, h00: h=4n')},
      '203:2': {'8a': (0, ('(1/8, 1/8, 1/8)', '(1/8, 5/8, 5/8)',
                           '(5/8, 1/8, 5/8)', '(5/8, 5/8, 1/8)',
                           '(7/8, 7/8, 7/8)', '(7/8, 3/8, 3/8)',
                           '(3/8, 7/8, 3/8)', '(3/8, 3/8, 7/8)'), 'n/a'),
                '8b': (0, ('(5/8, 5/8, 5/8)', '(5/8, 1/8, 1/8)',
                           '(1/8, 5/8, 1/8)', '(1/8, 1/8, 5/8)',
                           '(3/8, 3/8, 3/8)', '(3/8, 7/8, 7/8)',
                           '(7/8, 3/8, 7/8)', '(7/8, 7/8, 3/8)'), 'n/a'),
                '16c': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                            '(1/2, 1/2, 0)', '(3/4, 3/4, 0)',
                            '(3/4, 1/4, 1/2)', '(1/4, 3/4, 1/2)',
                            '(1/4, 1/4, 0)', '(3/4, 0, 3/4)',
                            '(3/4, 1/2, 1/4)', '(1/4, 0, 1/4)',
                            '(1/4, 1/2, 3/4)', '(0, 3/4, 3/4)',
                            '(0, 1/4, 1/4)', '(1/2, 3/4, 1/4)',
                            '(1/2, 1/4, 3/4)'), 'n/a'),
                '16d': (0, ('(1/2, 1/2, 1/2)', '(1/2, 0, 0)', '(0, 1/2, 0)',
                            '(0, 0, 1/2)', '(1/4, 1/4, 1/2)', '(1/4, 3/4, 0)',
                            '(3/4, 1/4, 0)', '(3/4, 3/4, 1/2)',
                            '(1/4, 1/2, 1/4)', '(1/4, 0, 3/4)',
                            '(3/4, 1/2, 3/4)', '(3/4, 0, 1/4)',
                            '(1/2, 1/4, 1/4)', '(1/2, 3/4, 3/4)',
                            '(0, 1/4, 3/4)', '(0, 3/4, 1/4)'), 'n/a'),
                '32e': (1, ('(x, x, x)', '(x, x+1/2, x+1/2)',
                            '(x+1/2, x, x+1/2)', '(x+1/2, x+1/2, x)',
                            '(-x+3/4, -x+3/4, x)', '(-x+3/4, -x+1/4, x+1/2)',
                            '(-x+1/4, -x+3/4, x+1/2)', '(-x+1/4, -x+1/4, x)',
                            '(-x+3/4, x, -x+3/4)', '(-x+3/4, x+1/2, -x+1/4)',
                            '(-x+1/4, x, -x+1/4)', '(-x+1/4, x+1/2, -x+3/4)',
                            '(x, -x+3/4, -x+3/4)', '(x, -x+1/4, -x+1/4)',
                            '(x+1/2, -x+3/4, -x+1/4)',
                            '(x+1/2, -x+1/4, -x+3/4)', '(-x, -x, -x)',
                            '(-x, -x+1/2, -x+1/2)', '(-x+1/2, -x, -x+1/2)',
                            '(-x+1/2, -x+1/2, -x)', '(x+1/4, x+1/4, -x)',
                            '(x+1/4, x+3/4, -x+1/2)',
                            '(x+3/4, x+1/4, -x+1/2)', '(x+3/4, x+3/4, -x)',
                            '(x+1/4, -x, x+1/4)', '(x+1/4, -x+1/2, x+3/4)',
                            '(x+3/4, -x, x+3/4)', '(x+3/4, -x+1/2, x+1/4)',
                            '(-x, x+1/4, x+1/4)', '(-x, x+3/4, x+3/4)',
                            '(-x+1/2, x+1/4, x+3/4)',
                            '(-x+1/2, x+3/4, x+1/4)'), 'n/a'),
                '48f': (1, ('(x, 1/8, 1/8)', '(x, 5/8, 5/8)',
                            '(x+1/2, 1/8, 5/8)', '(x+1/2, 5/8, 1/8)',
                            '(-x+3/4, 5/8, 1/8)', '(-x+3/4, 1/8, 5/8)',
                            '(-x+1/4, 5/8, 5/8)', '(-x+1/4, 1/8, 1/8)',
                            '(1/8, x, 1/8)', '(1/8, x+1/2, 5/8)',
                            '(5/8, x, 5/8)', '(5/8, x+1/2, 1/8)',
                            '(1/8, -x+3/4, 5/8)', '(1/8, -x+1/4, 1/8)',
                            '(5/8, -x+3/4, 1/8)', '(5/8, -x+1/4, 5/8)',
                            '(1/8, 1/8, x)', '(1/8, 5/8, x+1/2)',
                            '(5/8, 1/8, x+1/2)', '(5/8, 5/8, x)',
                            '(5/8, 1/8, -x+3/4)', '(5/8, 5/8, -x+1/4)',
                            '(1/8, 1/8, -x+1/4)', '(1/8, 5/8, -x+3/4)',
                            '(-x, 7/8, 7/8)', '(-x, 3/8, 3/8)',
                            '(-x+1/2, 7/8, 3/8)', '(-x+1/2, 3/8, 7/8)',
                            '(x+1/4, 3/8, 7/8)', '(x+1/4, 7/8, 3/8)',
                            '(x+3/4, 3/8, 3/8)', '(x+3/4, 7/8, 7/8)',
                            '(7/8, -x, 7/8)', '(7/8, -x+1/2, 3/8)',
                            '(3/8, -x, 3/8)', '(3/8, -x+1/2, 7/8)',
                            '(7/8, x+1/4, 3/8)', '(7/8, x+3/4, 7/8)',
                            '(3/8, x+1/4, 7/8)', '(3/8, x+3/4, 3/8)',
                            '(7/8, 7/8, -x)', '(7/8, 3/8, -x+1/2)',
                            '(3/8, 7/8, -x+1/2)', '(3/8, 3/8, -x)',
                            '(3/8, 7/8, x+1/4)', '(3/8, 3/8, x+3/4)',
                            '(7/8, 7/8, x+3/4)', '(7/8, 3/8, x+1/4)'), 'n/a'),
                '96g': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)',
                            '(x+1/2, y, z+1/2)', '(x+1/2, y+1/2, z)',
                            '(-x+3/4, -y+3/4, z)', '(-x+3/4, -y+1/4, z+1/2)',
                            '(-x+1/4, -y+3/4, z+1/2)', '(-x+1/4, -y+1/4, z)',
                            '(-x+3/4, y, -z+3/4)', '(-x+3/4, y+1/2, -z+1/4)',
                            '(-x+1/4, y, -z+1/4)', '(-x+1/4, y+1/2, -z+3/4)',
                            '(x, -y+3/4, -z+3/4)', '(x, -y+1/4, -z+1/4)',
                            '(x+1/2, -y+3/4, -z+1/4)',
                            '(x+1/2, -y+1/4, -z+3/4)', '(z, x, y)',
                            '(z, x+1/2, y+1/2)', '(z+1/2, x, y+1/2)',
                            '(z+1/2, x+1/2, y)', '(z, -x+3/4, -y+3/4)',
                            '(z, -x+1/4, -y+1/4)', '(z+1/2, -x+3/4, -y+1/4)',
                            '(z+1/2, -x+1/4, -y+3/4)', '(-z+3/4, -x+3/4, y)',
                            '(-z+3/4, -x+1/4, y+1/2)',
                            '(-z+1/4, -x+3/4, y+1/2)', '(-z+1/4, -x+1/4, y)',
                            '(-z+3/4, x, -y+3/4)', '(-z+3/4, x+1/2, -y+1/4)',
                            '(-z+1/4, x, -y+1/4)', '(-z+1/4, x+1/2, -y+3/4)',
                            '(y, z, x)', '(y, z+1/2, x+1/2)',
                            '(y+1/2, z, x+1/2)', '(y+1/2, z+1/2, x)',
                            '(-y+3/4, z, -x+3/4)', '(-y+3/4, z+1/2, -x+1/4)',
                            '(-y+1/4, z, -x+1/4)', '(-y+1/4, z+1/2, -x+3/4)',
                            '(y, -z+3/4, -x+3/4)', '(y, -z+1/4, -x+1/4)',
                            '(y+1/2, -z+3/4, -x+1/4)',
                            '(y+1/2, -z+1/4, -x+3/4)', '(-y+3/4, -z+3/4, x)',
                            '(-y+3/4, -z+1/4, x+1/2)',
                            '(-y+1/4, -z+3/4, x+1/2)', '(-y+1/4, -z+1/4, x)',
                            '(-x, -y, -z)', '(-x, -y+1/2, -z+1/2)',
                            '(-x+1/2, -y, -z+1/2)', '(-x+1/2, -y+1/2, -z)',
                            '(x+1/4, y+1/4, -z)', '(x+1/4, y+3/4, -z+1/2)',
                            '(x+3/4, y+1/4, -z+1/2)', '(x+3/4, y+3/4, -z)',
                            '(x+1/4, -y, z+1/4)', '(x+1/4, -y+1/2, z+3/4)',
                            '(x+3/4, -y, z+3/4)', '(x+3/4, -y+1/2, z+1/4)',
                            '(-x, y+1/4, z+1/4)', '(-x, y+3/4, z+3/4)',
                            '(-x+1/2, y+1/4, z+3/4)',
                            '(-x+1/2, y+3/4, z+1/4)', '(-z, -x, -y)',
                            '(-z, -x+1/2, -y+1/2)', '(-z+1/2, -x, -y+1/2)',
                            '(-z+1/2, -x+1/2, -y)', '(-z, x+1/4, y+1/4)',
                            '(-z, x+3/4, y+3/4)', '(-z+1/2, x+1/4, y+3/4)',
                            '(-z+1/2, x+3/4, y+1/4)', '(z+1/4, x+1/4, -y)',
                            '(z+1/4, x+3/4, -y+1/2)',
                            '(z+3/4, x+1/4, -y+1/2)', '(z+3/4, x+3/4, -y)',
                            '(z+1/4, -x, y+1/4)', '(z+1/4, -x+1/2, y+3/4)',
                            '(z+3/4, -x, y+3/4)', '(z+3/4, -x+1/2, y+1/4)',
                            '(-y, -z, -x)', '(-y, -z+1/2, -x+1/2)',
                            '(-y+1/2, -z, -x+1/2)', '(-y+1/2, -z+1/2, -x)',
                            '(y+1/4, -z, x+1/4)', '(y+1/4, -z+1/2, x+3/4)',
                            '(y+3/4, -z, x+3/4)', '(y+3/4, -z+1/2, x+1/4)',
                            '(-y, z+1/4, x+1/4)', '(-y, z+3/4, x+3/4)',
                            '(-y+1/2, z+1/4, x+3/4)',
                            '(-y+1/2, z+3/4, x+1/4)', '(y+1/4, z+1/4, -x)',
                            '(y+1/4, z+3/4, -x+1/2)',
                            '(y+3/4, z+1/4, -x+1/2)', '(y+3/4, z+3/4, -x)'),
                        'n/a')},
      '204': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)'), None),
              '6b': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 0)', '(1/2, 0, 1/2)',
                         '(0, 1/2, 0)', '(1/2, 1/2, 0)', '(0, 0, 1/2)'), None
                     ),
              '8c': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)',
                         '(3/4, 3/4, 1/4)', '(1/4, 1/4, 3/4)',
                         '(3/4, 1/4, 3/4)', '(1/4, 3/4, 1/4)',
                         '(1/4, 3/4, 3/4)', '(3/4, 1/4, 1/4)'), 'hkl: k,l=2n'
                     ),
              '12d': (1, ('(x, 0, 0)', '(x+1/2, 1/2, 1/2)', '(-x, 0, 0)',
                          '(-x+1/2, 1/2, 1/2)', '(0, x, 0)',
                          '(1/2, x+1/2, 1/2)', '(0, -x, 0)',
                          '(1/2, -x+1/2, 1/2)', '(0, 0, x)',
                          '(1/2, 1/2, x+1/2)', '(0, 0, -x)',
                          '(1/2, 1/2, -x+1/2)'), None),
              '12e': (1, ('(x, 0, 1/2)', '(x+1/2, 1/2, 0)', '(-x, 0, 1/2)',
                          '(-x+1/2, 1/2, 0)', '(1/2, x, 0)',
                          '(0, x+1/2, 1/2)', '(1/2, -x, 0)',
                          '(0, -x+1/2, 1/2)', '(0, 1/2, x)',
                          '(1/2, 0, x+1/2)', '(0, 1/2, -x)',
                          '(1/2, 0, -x+1/2)'), None),
              '16f': (1, ('(x, x, x)', '(x+1/2, x+1/2, x+1/2)', '(-x, -x, x)',
                          '(-x+1/2, -x+1/2, x+1/2)', '(-x, x, -x)',
                          '(-x+1/2, x+1/2, -x+1/2)', '(x, -x, -x)',
                          '(x+1/2, -x+1/2, -x+1/2)', '(-x, -x, -x)',
                          '(-x+1/2, -x+1/2, -x+1/2)', '(x, x, -x)',
                          '(x+1/2, x+1/2, -x+1/2)', '(x, -x, x)',
                          '(x+1/2, -x+1/2, x+1/2)', '(-x, x, x)',
                          '(-x+1/2, x+1/2, x+1/2)'), None),
              '24g': (6, ('(0, y, z)', '(1/2, y+1/2, z+1/2)', '(0, -y, z)',
                          '(1/2, -y+1/2, z+1/2)', '(0, y, -z)',
                          '(1/2, y+1/2, -z+1/2)', '(0, -y, -z)',
                          '(1/2, -y+1/2, -z+1/2)', '(z, 0, y)',
                          '(z+1/2, 1/2, y+1/2)', '(z, 0, -y)',
                          '(z+1/2, 1/2, -y+1/2)', '(-z, 0, y)',
                          '(-z+1/2, 1/2, y+1/2)', '(-z, 0, -y)',
                          '(-z+1/2, 1/2, -y+1/2)', '(y, z, 0)',
                          '(y+1/2, z+1/2, 1/2)', '(-y, z, 0)',
                          '(-y+1/2, z+1/2, 1/2)', '(y, -z, 0)',
                          '(y+1/2, -z+1/2, 1/2)', '(-y, -z, 0)',
                          '(-y+1/2, -z+1/2, 1/2)'), None),
              '48h': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                          '(-x+1/2, -y+1/2, z+1/2)', '(-x, y, -z)',
                          '(-x+1/2, y+1/2, -z+1/2)', '(x, -y, -z)',
                          '(x+1/2, -y+1/2, -z+1/2)', '(z, x, y)',
                          '(z+1/2, x+1/2, y+1/2)', '(z, -x, -y)',
                          '(z+1/2, -x+1/2, -y+1/2)', '(-z, -x, y)',
                          '(-z+1/2, -x+1/2, y+1/2)', '(-z, x, -y)',
                          '(-z+1/2, x+1/2, -y+1/2)', '(y, z, x)',
                          '(y+1/2, z+1/2, x+1/2)', '(-y, z, -x)',
                          '(-y+1/2, z+1/2, -x+1/2)', '(y, -z, -x)',
                          '(y+1/2, -z+1/2, -x+1/2)', '(-y, -z, x)',
                          '(-y+1/2, -z+1/2, x+1/2)', '(-x, -y, -z)',
                          '(-x+1/2, -y+1/2, -z+1/2)', '(x, y, -z)',
                          '(x+1/2, y+1/2, -z+1/2)', '(x, -y, z)',
                          '(x+1/2, -y+1/2, z+1/2)', '(-x, y, z)',
                          '(-x+1/2, y+1/2, z+1/2)', '(-z, -x, -y)',
                          '(-z+1/2, -x+1/2, -y+1/2)', '(-z, x, y)',
                          '(-z+1/2, x+1/2, y+1/2)', '(z, x, -y)',
                          '(z+1/2, x+1/2, -y+1/2)', '(z, -x, y)',
                          '(z+1/2, -x+1/2, y+1/2)', '(-y, -z, -x)',
                          '(-y+1/2, -z+1/2, -x+1/2)', '(y, -z, x)',
                          '(y+1/2, -z+1/2, x+1/2)', '(-y, z, x)',
                          '(-y+1/2, z+1/2, x+1/2)', '(y, z, -x)',
                          '(y+1/2, z+1/2, -x+1/2)'),
                      'hkl: h+k+l=2n, 0kl: k+l=2n, hhl: l=2n, h00: h=2n')},
      '205': {'4a': (0, ('(0, 0, 0)', '(1/2, 0, 1/2)', '(0, 1/2, 1/2)',
                         '(1/2, 1/2, 0)'), 'hkl: h+k,h+l,k+l=2n'),
              '4b': (0, ('(1/2, 1/2, 1/2)', '(0, 1/2, 0)', '(1/2, 0, 0)',
                         '(0, 0, 1/2)'), 'hkl: h+k,h+l,k+l=2n'),
              '8c': (1, ('(x, x, x)', '(-x+1/2, -x, x+1/2)',
                         '(-x, x+1/2, -x+1/2)', '(x+1/2, -x+1/2, -x)',
                         '(-x, -x, -x)', '(x+1/2, x, -x+1/2)',
                         '(x, -x+1/2, x+1/2)', '(-x+1/2, x+1/2, x)'), None),
              '24d': (7, ('(x, y, z)', '(-x+1/2, -y, z+1/2)',
                          '(-x, y+1/2, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                          '(z, x, y)', '(z+1/2, -x+1/2, -y)',
                          '(-z+1/2, -x, y+1/2)', '(-z, x+1/2, -y+1/2)',
                          '(y, z, x)', '(-y, z+1/2, -x+1/2)',
                          '(y+1/2, -z+1/2, -x)', '(-y+1/2, -z, x+1/2)',
                          '(-x, -y, -z)', '(x+1/2, y, -z+1/2)',
                          '(x, -y+1/2, z+1/2)', '(-x+1/2, y+1/2, z)',
                          '(-z, -x, -y)', '(-z+1/2, x+1/2, y)',
                          '(z+1/2, x, -y+1/2)', '(z, -x+1/2, y+1/2)',
                          '(-y, -z, -x)', '(y, -z+1/2, x+1/2)',
                          '(-y+1/2, z+1/2, x)', '(y+1/2, z, -x+1/2)'),
                      '0kl: k=2n, h00: h=2n')},
      '206': {'8a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)', '(1/2, 0, 1/2)',
                         '(0, 1/2, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 0)',
                         '(1/2, 1/2, 0)', '(0, 0, 1/2)'), 'hkl: k,l=2n'),
              '8b': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)',
                         '(1/4, 3/4, 3/4)', '(3/4, 1/4, 1/4)',
                         '(3/4, 3/4, 1/4)', '(1/4, 1/4, 3/4)',
                         '(3/4, 1/4, 3/4)', '(1/4, 3/4, 1/4)'), 'hkl: k,l=2n'
                     ),
              '16c': (1, ('(x, x, x)', '(x+1/2, x+1/2, x+1/2)',
                          '(-x+1/2, -x, x+1/2)', '(-x, -x+1/2, x)',
                          '(-x, x+1/2, -x+1/2)', '(-x+1/2, x, -x)',
                          '(x+1/2, -x+1/2, -x)', '(x, -x, -x+1/2)',
                          '(-x, -x, -x)', '(-x+1/2, -x+1/2, -x+1/2)',
                          '(x+1/2, x, -x+1/2)', '(x, x+1/2, -x)',
                          '(x, -x+1/2, x+1/2)', '(x+1/2, -x, x)',
                          '(-x+1/2, x+1/2, x)', '(-x, x, x+1/2)'), None),
              '24d': (1, ('(x, 0, 1/4)', '(x+1/2, 1/2, 3/4)',
                          '(-x+1/2, 0, 3/4)', '(-x, 1/2, 1/4)', '(1/4, x, 0)',
                          '(3/4, x+1/2, 1/2)', '(3/4, -x+1/2, 0)',
                          '(1/4, -x, 1/2)', '(0, 1/4, x)',
                          '(1/2, 3/4, x+1/2)', '(0, 3/4, -x+1/2)',
                          '(1/2, 1/4, -x)', '(-x, 0, 3/4)',
                          '(-x+1/2, 1/2, 1/4)', '(x+1/2, 0, 1/4)',
                          '(x, 1/2, 3/4)', '(3/4, -x, 0)',
                          '(1/4, -x+1/2, 1/2)', '(1/4, x+1/2, 0)',
                          '(3/4, x, 1/2)', '(0, 3/4, -x)',
                          '(1/2, 1/4, -x+1/2)', '(0, 1/4, x+1/2)',
                          '(1/2, 3/4, x)'), None),
              '48e': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)',
                          '(-x+1/2, -y, z+1/2)', '(-x, -y+1/2, z)',
                          '(-x, y+1/2, -z+1/2)', '(-x+1/2, y, -z)',
                          '(x+1/2, -y+1/2, -z)', '(x, -y, -z+1/2)',
                          '(z, x, y)', '(z+1/2, x+1/2, y+1/2)',
                          '(z+1/2, -x+1/2, -y)', '(z, -x, -y+1/2)',
                          '(-z+1/2, -x, y+1/2)', '(-z, -x+1/2, y)',
                          '(-z, x+1/2, -y+1/2)', '(-z+1/2, x, -y)',
                          '(y, z, x)', '(y+1/2, z+1/2, x+1/2)',
                          '(-y, z+1/2, -x+1/2)', '(-y+1/2, z, -x)',
                          '(y+1/2, -z+1/2, -x)', '(y, -z, -x+1/2)',
                          '(-y+1/2, -z, x+1/2)', '(-y, -z+1/2, x)',
                          '(-x, -y, -z)', '(-x+1/2, -y+1/2, -z+1/2)',
                          '(x+1/2, y, -z+1/2)', '(x, y+1/2, -z)',
                          '(x, -y+1/2, z+1/2)', '(x+1/2, -y, z)',
                          '(-x+1/2, y+1/2, z)', '(-x, y, z+1/2)',
                          '(-z, -x, -y)', '(-z+1/2, -x+1/2, -y+1/2)',
                          '(-z+1/2, x+1/2, y)', '(-z, x, y+1/2)',
                          '(z+1/2, x, -y+1/2)', '(z, x+1/2, -y)',
                          '(z, -x+1/2, y+1/2)', '(z+1/2, -x, y)',
                          '(-y, -z, -x)', '(-y+1/2, -z+1/2, -x+1/2)',
                          '(y, -z+1/2, x+1/2)', '(y+1/2, -z, x)',
                          '(-y+1/2, z+1/2, x)', '(-y, z, x+1/2)',
                          '(y+1/2, z, -x+1/2)', '(y, z+1/2, -x)'),
                      'hkl: h+k+l=2n, 0kl: k,l=2n, hhl: l=2n, h00: h=2n')},
      '207': {'1a': (0, ('(0, 0, 0)', ), None),
              '1b': (0, ('(1/2, 1/2, 1/2)', ), None),
              '3c': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)', '(1/2, 1/2, 0)'),
                     None),
              '3d': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(0, 0, 1/2)'), None),
              '6e': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(0, x, 0)', '(0, -x, 0)',
                         '(0, 0, x)', '(0, 0, -x)'), None),
              '6f': (1, ('(x, 1/2, 1/2)', '(-x, 1/2, 1/2)', '(1/2, x, 1/2)',
                         '(1/2, -x, 1/2)', '(1/2, 1/2, x)', '(1/2, 1/2, -x)'),
                     None),
              '8g': (1, ('(x, x, x)', '(-x, -x, x)', '(-x, x, -x)',
                         '(x, -x, -x)', '(x, x, -x)', '(-x, -x, -x)',
                         '(x, -x, x)', '(-x, x, x)'), None),
              '12h': (1, ('(x, 1/2, 0)', '(-x, 1/2, 0)', '(0, x, 1/2)',
                          '(0, -x, 1/2)', '(1/2, 0, x)', '(1/2, 0, -x)',
                          '(1/2, x, 0)', '(1/2, -x, 0)', '(x, 0, 1/2)',
                          '(-x, 0, 1/2)', '(0, 1/2, -x)', '(0, 1/2, x)'), None
                      ),
              '12i': (2, ('(0, y, y)', '(0, -y, y)', '(0, y, -y)',
                          '(0, -y, -y)', '(y, 0, y)', '(y, 0, -y)',
                          '(-y, 0, y)', '(-y, 0, -y)', '(y, y, 0)',
                          '(-y, y, 0)', '(y, -y, 0)', '(-y, -y, 0)'), None),
              '12j': (2, ('(1/2, y, y)', '(1/2, -y, y)', '(1/2, y, -y)',
                          '(1/2, -y, -y)', '(y, 1/2, y)', '(y, 1/2, -y)',
                          '(-y, 1/2, y)', '(-y, 1/2, -y)', '(y, y, 1/2)',
                          '(-y, y, 1/2)', '(y, -y, 1/2)', '(-y, -y, 1/2)'),
                      None),
              '24k': (7, ('(x, y, z)', '(-x, -y, z)', '(-x, y, -z)',
                          '(x, -y, -z)', '(z, x, y)', '(z, -x, -y)',
                          '(-z, -x, y)', '(-z, x, -y)', '(y, z, x)',
                          '(-y, z, -x)', '(y, -z, -x)', '(-y, -z, x)',
                          '(y, x, -z)', '(-y, -x, -z)', '(y, -x, z)',
                          '(-y, x, z)', '(x, z, -y)', '(-x, z, y)',
                          '(-x, -z, -y)', '(x, -z, y)', '(z, y, -x)',
                          '(z, -y, x)', '(-z, y, x)', '(-z, -y, -x)'), None)},
      '208': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)'), 'hkl: h+k+l=2n'),
              '4b': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 1/4)',
                         '(3/4, 1/4, 3/4)', '(1/4, 3/4, 3/4)'),
                     'hkl: h+k,h+l,k+l=2n'),
              '4c': (0, ('(3/4, 3/4, 3/4)', '(1/4, 1/4, 3/4)',
                         '(1/4, 3/4, 1/4)', '(3/4, 1/4, 1/4)'),
                     'hkl: h+k,h+l,k+l=2n'),
              '6d': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)', '(1/2, 1/2, 0)',
                         '(0, 1/2, 0)', '(1/2, 0, 0)', '(0, 0, 1/2)'),
                     'hkl: h+k+l=2n'),
              '6e': (0, ('(1/4, 0, 1/2)', '(3/4, 0, 1/2)', '(1/2, 1/4, 0)',
                         '(1/2, 3/4, 0)', '(0, 1/2, 1/4)', '(0, 1/2, 3/4)'),
                     'hkl: h+k+l=2n or h=2n+1, k=4n, l=4n+2'),
              '6f': (0, ('(1/4, 1/2, 0)', '(3/4, 1/2, 0)', '(0, 1/4, 1/2)',
                         '(0, 3/4, 1/2)', '(1/2, 0, 1/4)', '(1/2, 0, 3/4)'),
                     'hkl: h+k+l=2n or h=2n+1, k=4n, l=4n+2'),
              '8g': (1, ('(x, x, x)', '(-x, -x, x)', '(-x, x, -x)',
                         '(x, -x, -x)', '(x+1/2, x+1/2, -x+1/2)',
                         '(-x+1/2, -x+1/2, -x+1/2)', '(x+1/2, -x+1/2, x+1/2)',
                         '(-x+1/2, x+1/2, x+1/2)'), '0kl: k+l=2n'),
              '12h': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(0, x, 0)',
                          '(0, -x, 0)', '(0, 0, x)', '(0, 0, -x)',
                          '(1/2, x+1/2, 1/2)', '(1/2, -x+1/2, 1/2)',
                          '(x+1/2, 1/2, 1/2)', '(-x+1/2, 1/2, 1/2)',
                          '(1/2, 1/2, -x+1/2)', '(1/2, 1/2, x+1/2)'),
                      'hkl: h+k+l=2n'),
              '12i': (1, ('(x, 0, 1/2)', '(-x, 0, 1/2)', '(1/2, x, 0)',
                          '(1/2, -x, 0)', '(0, 1/2, x)', '(0, 1/2, -x)',
                          '(1/2, x+1/2, 0)', '(1/2, -x+1/2, 0)',
                          '(x+1/2, 0, 1/2)', '(-x+1/2, 0, 1/2)',
                          '(0, 1/2, -x+1/2)', '(0, 1/2, x+1/2)'),
                      'hkl: h=2n, hhl: l=2n'),
              '12j': (1, ('(x, 1/2, 0)', '(-x, 1/2, 0)', '(0, x, 1/2)',
                          '(0, -x, 1/2)', '(1/2, 0, x)', '(1/2, 0, -x)',
                          '(0, x+1/2, 1/2)', '(0, -x+1/2, 1/2)',
                          '(x+1/2, 1/2, 0)', '(-x+1/2, 1/2, 0)',
                          '(1/2, 0, -x+1/2)', '(1/2, 0, x+1/2)'),
                      'hkl: h=2n, hhl: l=2n'),
              '12k': (2, ('(1/4, y, -y+1/2)', '(3/4, -y, -y+1/2)',
                          '(3/4, y, y+1/2)', '(1/4, -y, y+1/2)',
                          '(-y+1/2, 1/4, y)', '(-y+1/2, 3/4, -y)',
                          '(y+1/2, 3/4, y)', '(y+1/2, 1/4, -y)',
                          '(y, -y+1/2, 1/4)', '(-y, -y+1/2, 3/4)',
                          '(y, y+1/2, 3/4)', '(-y, y+1/2, 1/4)'), None),
              '12l': (2, ('(1/4, y, y+1/2)', '(3/4, -y, y+1/2)',
                          '(3/4, y, -y+1/2)', '(1/4, -y, -y+1/2)',
                          '(y+1/2, 1/4, y)', '(y+1/2, 3/4, -y)',
                          '(-y+1/2, 3/4, y)', '(-y+1/2, 1/4, -y)',
                          '(y, y+1/2, 1/4)', '(-y, y+1/2, 3/4)',
                          '(y, -y+1/2, 3/4)', '(-y, -y+1/2, 1/4)'), None),
              '24m': (7, ('(x, y, z)', '(-x, -y, z)', '(-x, y, -z)',
                          '(x, -y, -z)', '(z, x, y)', '(z, -x, -y)',
                          '(-z, -x, y)', '(-z, x, -y)', '(y, z, x)',
                          '(-y, z, -x)', '(y, -z, -x)', '(-y, -z, x)',
                          '(y+1/2, x+1/2, -z+1/2)',
                          '(-y+1/2, -x+1/2, -z+1/2)',
                          '(y+1/2, -x+1/2, z+1/2)', '(-y+1/2, x+1/2, z+1/2)',
                          '(x+1/2, z+1/2, -y+1/2)', '(-x+1/2, z+1/2, y+1/2)',
                          '(-x+1/2, -z+1/2, -y+1/2)',
                          '(x+1/2, -z+1/2, y+1/2)', '(z+1/2, y+1/2, -x+1/2)',
                          '(z+1/2, -y+1/2, x+1/2)', '(-z+1/2, y+1/2, x+1/2)',
                          '(-z+1/2, -y+1/2, -x+1/2)'), 'h00: h=2n')},
      '209': {'4a': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                         '(1/2, 1/2, 0)'), None),
              '4b': (0, ('(1/2, 1/2, 1/2)', '(1/2, 0, 0)', '(0, 1/2, 0)',
                         '(0, 0, 1/2)'), None),
              '8c': (0, ('(1/4, 1/4, 1/4)', '(1/4, 3/4, 3/4)',
                         '(3/4, 1/4, 3/4)', '(3/4, 3/4, 1/4)',
                         '(1/4, 1/4, 3/4)', '(1/4, 3/4, 1/4)',
                         '(3/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)'), 'hkl: h=2n'),
              '24d': (0, ('(0, 1/4, 1/4)', '(0, 3/4, 3/4)', '(1/2, 1/4, 3/4)',
                          '(1/2, 3/4, 1/4)', '(0, 3/4, 1/4)', '(0, 1/4, 3/4)',
                          '(1/2, 3/4, 3/4)', '(1/2, 1/4, 1/4)',
                          '(1/4, 0, 1/4)', '(1/4, 1/2, 3/4)', '(3/4, 0, 3/4)',
                          '(3/4, 1/2, 1/4)', '(1/4, 0, 3/4)',
                          '(1/4, 1/2, 1/4)', '(3/4, 0, 1/4)',
                          '(3/4, 1/2, 3/4)', '(1/4, 1/4, 0)',
                          '(1/4, 3/4, 1/2)', '(3/4, 1/4, 1/2)',
                          '(3/4, 3/4, 0)', '(3/4, 1/4, 0)', '(3/4, 3/4, 1/2)',
                          '(1/4, 1/4, 1/2)', '(1/4, 3/4, 0)'), 'hkl: h=2n'),
              '24e': (1, ('(x, 0, 0)', '(x, 1/2, 1/2)', '(x+1/2, 0, 1/2)',
                          '(x+1/2, 1/2, 0)', '(-x, 0, 0)', '(-x, 1/2, 1/2)',
                          '(-x+1/2, 0, 1/2)', '(-x+1/2, 1/2, 0)', '(0, x, 0)',
                          '(0, x+1/2, 1/2)', '(1/2, x, 1/2)',
                          '(1/2, x+1/2, 0)', '(0, -x, 0)', '(0, -x+1/2, 1/2)',
                          '(1/2, -x, 1/2)', '(1/2, -x+1/2, 0)', '(0, 0, x)',
                          '(0, 1/2, x+1/2)', '(1/2, 0, x+1/2)',
                          '(1/2, 1/2, x)', '(0, 0, -x)', '(0, 1/2, -x+1/2)',
                          '(1/2, 0, -x+1/2)', '(1/2, 1/2, -x)'), None),
              '32f': (1, ('(x, x, x)', '(x, x+1/2, x+1/2)',
                          '(x+1/2, x, x+1/2)', '(x+1/2, x+1/2, x)',
                          '(-x, -x, x)', '(-x, -x+1/2, x+1/2)',
                          '(-x+1/2, -x, x+1/2)', '(-x+1/2, -x+1/2, x)',
                          '(-x, x, -x)', '(-x, x+1/2, -x+1/2)',
                          '(-x+1/2, x, -x+1/2)', '(-x+1/2, x+1/2, -x)',
                          '(x, -x, -x)', '(x, -x+1/2, -x+1/2)',
                          '(x+1/2, -x, -x+1/2)', '(x+1/2, -x+1/2, -x)',
                          '(x, x, -x)', '(x, x+1/2, -x+1/2)',
                          '(x+1/2, x, -x+1/2)', '(x+1/2, x+1/2, -x)',
                          '(-x, -x, -x)', '(-x, -x+1/2, -x+1/2)',
                          '(-x+1/2, -x, -x+1/2)', '(-x+1/2, -x+1/2, -x)',
                          '(x, -x, x)', '(x, -x+1/2, x+1/2)',
                          '(x+1/2, -x, x+1/2)', '(x+1/2, -x+1/2, x)',
                          '(-x, x, x)', '(-x, x+1/2, x+1/2)',
                          '(-x+1/2, x, x+1/2)', '(-x+1/2, x+1/2, x)'), None),
              '48g': (2, ('(0, y, y)', '(0, y+1/2, y+1/2)', '(1/2, y, y+1/2)',
                          '(1/2, y+1/2, y)', '(0, -y, y)',
                          '(0, -y+1/2, y+1/2)', '(1/2, -y, y+1/2)',
                          '(1/2, -y+1/2, y)', '(0, y, -y)',
                          '(0, y+1/2, -y+1/2)', '(1/2, y, -y+1/2)',
                          '(1/2, y+1/2, -y)', '(0, -y, -y)',
                          '(0, -y+1/2, -y+1/2)', '(1/2, -y, -y+1/2)',
                          '(1/2, -y+1/2, -y)', '(y, 0, y)', '(y, 1/2, y+1/2)',
                          '(y+1/2, 0, y+1/2)', '(y+1/2, 1/2, y)',
                          '(y, 0, -y)', '(y, 1/2, -y+1/2)',
                          '(y+1/2, 0, -y+1/2)', '(y+1/2, 1/2, -y)',
                          '(-y, 0, y)', '(-y, 1/2, y+1/2)',
                          '(-y+1/2, 0, y+1/2)', '(-y+1/2, 1/2, y)',
                          '(-y, 0, -y)', '(-y, 1/2, -y+1/2)',
                          '(-y+1/2, 0, -y+1/2)', '(-y+1/2, 1/2, -y)',
                          '(y, y, 0)', '(y, y+1/2, 1/2)', '(y+1/2, y, 1/2)',
                          '(y+1/2, y+1/2, 0)', '(-y, y, 0)',
                          '(-y, y+1/2, 1/2)', '(-y+1/2, y, 1/2)',
                          '(-y+1/2, y+1/2, 0)', '(y, -y, 0)',
                          '(y, -y+1/2, 1/2)', '(y+1/2, -y, 1/2)',
                          '(y+1/2, -y+1/2, 0)', '(-y, -y, 0)',
                          '(-y, -y+1/2, 1/2)', '(-y+1/2, -y, 1/2)',
                          '(-y+1/2, -y+1/2, 0)'), None),
              '48h': (2, ('(1/2, y, y)', '(1/2, y+1/2, y+1/2)',
                          '(0, y, y+1/2)', '(0, y+1/2, y)', '(1/2, -y, y)',
                          '(1/2, -y+1/2, y+1/2)', '(0, -y, y+1/2)',
                          '(0, -y+1/2, y)', '(1/2, y, -y)',
                          '(1/2, y+1/2, -y+1/2)', '(0, y, -y+1/2)',
                          '(0, y+1/2, -y)', '(1/2, -y, -y)',
                          '(1/2, -y+1/2, -y+1/2)', '(0, -y, -y+1/2)',
                          '(0, -y+1/2, -y)', '(y, 1/2, y)', '(y, 0, y+1/2)',
                          '(y+1/2, 1/2, y+1/2)', '(y+1/2, 0, y)',
                          '(y, 1/2, -y)', '(y, 0, -y+1/2)',
                          '(y+1/2, 1/2, -y+1/2)', '(y+1/2, 0, -y)',
                          '(-y, 1/2, y)', '(-y, 0, y+1/2)',
                          '(-y+1/2, 1/2, y+1/2)', '(-y+1/2, 0, y)',
                          '(-y, 1/2, -y)', '(-y, 0, -y+1/2)',
                          '(-y+1/2, 1/2, -y+1/2)', '(-y+1/2, 0, -y)',
                          '(y, y, 1/2)', '(y, y+1/2, 0)', '(y+1/2, y, 0)',
                          '(y+1/2, y+1/2, 1/2)', '(-y, y, 1/2)',
                          '(-y, y+1/2, 0)', '(-y+1/2, y, 0)',
                          '(-y+1/2, y+1/2, 1/2)', '(y, -y, 1/2)',
                          '(y, -y+1/2, 0)', '(y+1/2, -y, 0)',
                          '(y+1/2, -y+1/2, 1/2)', '(-y, -y, 1/2)',
                          '(-y, -y+1/2, 0)', '(-y+1/2, -y, 0)',
                          '(-y+1/2, -y+1/2, 1/2)'), None),
              '48i': (1, ('(x, 1/4, 1/4)', '(x, 3/4, 3/4)',
                          '(x+1/2, 1/4, 3/4)', '(x+1/2, 3/4, 1/4)',
                          '(-x, 3/4, 1/4)', '(-x, 1/4, 3/4)',
                          '(-x+1/2, 3/4, 3/4)', '(-x+1/2, 1/4, 1/4)',
                          '(1/4, x, 1/4)', '(1/4, x+1/2, 3/4)',
                          '(3/4, x, 3/4)', '(3/4, x+1/2, 1/4)',
                          '(1/4, -x, 3/4)', '(1/4, -x+1/2, 1/4)',
                          '(3/4, -x, 1/4)', '(3/4, -x+1/2, 3/4)',
                          '(1/4, 1/4, x)', '(1/4, 3/4, x+1/2)',
                          '(3/4, 1/4, x+1/2)', '(3/4, 3/4, x)',
                          '(3/4, 1/4, -x)', '(3/4, 3/4, -x+1/2)',
                          '(1/4, 1/4, -x+1/2)', '(1/4, 3/4, -x)',
                          '(1/4, x, 3/4)', '(1/4, x+1/2, 1/4)',
                          '(3/4, x, 1/4)', '(3/4, x+1/2, 3/4)',
                          '(3/4, -x, 3/4)', '(3/4, -x+1/2, 1/4)',
                          '(1/4, -x, 1/4)', '(1/4, -x+1/2, 3/4)',
                          '(x, 1/4, 3/4)', '(x, 3/4, 1/4)',
                          '(x+1/2, 1/4, 1/4)', '(x+1/2, 3/4, 3/4)',
                          '(-x, 1/4, 1/4)', '(-x, 3/4, 3/4)',
                          '(-x+1/2, 1/4, 3/4)', '(-x+1/2, 3/4, 1/4)',
                          '(1/4, 1/4, -x)', '(1/4, 3/4, -x+1/2)',
                          '(3/4, 1/4, -x+1/2)', '(3/4, 3/4, -x)',
                          '(1/4, 3/4, x)', '(1/4, 1/4, x+1/2)',
                          '(3/4, 3/4, x+1/2)', '(3/4, 1/4, x)'), 'hkl: h=2n'),
              '96j': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)',
                          '(x+1/2, y, z+1/2)', '(x+1/2, y+1/2, z)',
                          '(-x, -y, z)', '(-x, -y+1/2, z+1/2)',
                          '(-x+1/2, -y, z+1/2)', '(-x+1/2, -y+1/2, z)',
                          '(-x, y, -z)', '(-x, y+1/2, -z+1/2)',
                          '(-x+1/2, y, -z+1/2)', '(-x+1/2, y+1/2, -z)',
                          '(x, -y, -z)', '(x, -y+1/2, -z+1/2)',
                          '(x+1/2, -y, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                          '(z, x, y)', '(z, x+1/2, y+1/2)',
                          '(z+1/2, x, y+1/2)', '(z+1/2, x+1/2, y)',
                          '(z, -x, -y)', '(z, -x+1/2, -y+1/2)',
                          '(z+1/2, -x, -y+1/2)', '(z+1/2, -x+1/2, -y)',
                          '(-z, -x, y)', '(-z, -x+1/2, y+1/2)',
                          '(-z+1/2, -x, y+1/2)', '(-z+1/2, -x+1/2, y)',
                          '(-z, x, -y)', '(-z, x+1/2, -y+1/2)',
                          '(-z+1/2, x, -y+1/2)', '(-z+1/2, x+1/2, -y)',
                          '(y, z, x)', '(y, z+1/2, x+1/2)',
                          '(y+1/2, z, x+1/2)', '(y+1/2, z+1/2, x)',
                          '(-y, z, -x)', '(-y, z+1/2, -x+1/2)',
                          '(-y+1/2, z, -x+1/2)', '(-y+1/2, z+1/2, -x)',
                          '(y, -z, -x)', '(y, -z+1/2, -x+1/2)',
                          '(y+1/2, -z, -x+1/2)', '(y+1/2, -z+1/2, -x)',
                          '(-y, -z, x)', '(-y, -z+1/2, x+1/2)',
                          '(-y+1/2, -z, x+1/2)', '(-y+1/2, -z+1/2, x)',
                          '(y, x, -z)', '(y, x+1/2, -z+1/2)',
                          '(y+1/2, x, -z+1/2)', '(y+1/2, x+1/2, -z)',
                          '(-y, -x, -z)', '(-y, -x+1/2, -z+1/2)',
                          '(-y+1/2, -x, -z+1/2)', '(-y+1/2, -x+1/2, -z)',
                          '(y, -x, z)', '(y, -x+1/2, z+1/2)',
                          '(y+1/2, -x, z+1/2)', '(y+1/2, -x+1/2, z)',
                          '(-y, x, z)', '(-y, x+1/2, z+1/2)',
                          '(-y+1/2, x, z+1/2)', '(-y+1/2, x+1/2, z)',
                          '(x, z, -y)', '(x, z+1/2, -y+1/2)',
                          '(x+1/2, z, -y+1/2)', '(x+1/2, z+1/2, -y)',
                          '(-x, z, y)', '(-x, z+1/2, y+1/2)',
                          '(-x+1/2, z, y+1/2)', '(-x+1/2, z+1/2, y)',
                          '(-x, -z, -y)', '(-x, -z+1/2, -y+1/2)',
                          '(-x+1/2, -z, -y+1/2)', '(-x+1/2, -z+1/2, -y)',
                          '(x, -z, y)', '(x, -z+1/2, y+1/2)',
                          '(x+1/2, -z, y+1/2)', '(x+1/2, -z+1/2, y)',
                          '(z, y, -x)', '(z, y+1/2, -x+1/2)',
                          '(z+1/2, y, -x+1/2)', '(z+1/2, y+1/2, -x)',
                          '(z, -y, x)', '(z, -y+1/2, x+1/2)',
                          '(z+1/2, -y, x+1/2)', '(z+1/2, -y+1/2, x)',
                          '(-z, y, x)', '(-z, y+1/2, x+1/2)',
                          '(-z+1/2, y, x+1/2)', '(-z+1/2, y+1/2, x)',
                          '(-z, -y, -x)', '(-z, -y+1/2, -x+1/2)',
                          '(-z+1/2, -y, -x+1/2)', '(-z+1/2, -y+1/2, -x)'),
                      'hkl: h+k,h+l,k+l=2n, 0kl: k,l=2n, hhl: h+l=2n, '
                      'h00: h=2n')},
      '210': {'8a': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                         '(1/2, 1/2, 0)', '(3/4, 1/4, 3/4)',
                         '(3/4, 3/4, 1/4)', '(1/4, 1/4, 1/4)',
                         '(1/4, 3/4, 3/4)'), 'hkl: h=2n+1 or h+k+l=4n'),
              '8b': (0, ('(1/2, 1/2, 1/2)', '(1/2, 0, 0)', '(0, 1/2, 0)',
                         '(0, 0, 1/2)', '(1/4, 3/4, 1/4)', '(1/4, 1/4, 3/4)',
                         '(3/4, 3/4, 3/4)', '(3/4, 1/4, 1/4)'),
                     'hkl: h=2n+1 or h+k+l=4n'),
              '16c': (0, ('(1/8, 1/8, 1/8)', '(1/8, 5/8, 5/8)',
                          '(5/8, 1/8, 5/8)', '(5/8, 5/8, 1/8)',
                          '(7/8, 3/8, 5/8)', '(7/8, 7/8, 1/8)',
                          '(3/8, 3/8, 1/8)', '(3/8, 7/8, 5/8)',
                          '(3/8, 5/8, 7/8)', '(3/8, 1/8, 3/8)',
                          '(7/8, 5/8, 3/8)', '(7/8, 1/8, 7/8)',
                          '(5/8, 7/8, 3/8)', '(5/8, 3/8, 7/8)',
                          '(1/8, 7/8, 7/8)', '(1/8, 3/8, 3/8)'),
                      'hkl: h=2n+1 or h,k,l=4n+2 or h,k,l=4n'),
              '16d': (0, ('(5/8, 5/8, 5/8)', '(5/8, 1/8, 1/8)',
                          '(1/8, 5/8, 1/8)', '(1/8, 1/8, 5/8)',
                          '(3/8, 7/8, 1/8)', '(3/8, 3/8, 5/8)',
                          '(7/8, 7/8, 5/8)', '(7/8, 3/8, 1/8)',
                          '(7/8, 1/8, 3/8)', '(7/8, 5/8, 7/8)',
                          '(3/8, 1/8, 7/8)', '(3/8, 5/8, 3/8)',
                          '(1/8, 3/8, 7/8)', '(1/8, 7/8, 3/8)',
                          '(5/8, 3/8, 3/8)', '(5/8, 7/8, 7/8)'),
                      'hkl: h=2n+1 or h,k,l=4n+2 or h,k,l=4n'),
              '32e': (1, ('(x, x, x)', '(x, x+1/2, x+1/2)',
                          '(x+1/2, x, x+1/2)', '(x+1/2, x+1/2, x)',
                          '(-x, -x+1/2, x+1/2)', '(-x, -x, x)',
                          '(-x+1/2, -x+1/2, x)', '(-x+1/2, -x, x+1/2)',
                          '(-x+1/2, x+1/2, -x)', '(-x+1/2, x, -x+1/2)',
                          '(-x, x+1/2, -x+1/2)', '(-x, x, -x)',
                          '(x+1/2, -x, -x+1/2)', '(x+1/2, -x+1/2, -x)',
                          '(x, -x, -x)', '(x, -x+1/2, -x+1/2)',
                          '(x+3/4, x+1/4, -x+3/4)', '(x+3/4, x+3/4, -x+1/4)',
                          '(x+1/4, x+1/4, -x+1/4)', '(x+1/4, x+3/4, -x+3/4)',
                          '(-x+1/4, -x+1/4, -x+1/4)',
                          '(-x+1/4, -x+3/4, -x+3/4)',
                          '(-x+3/4, -x+1/4, -x+3/4)',
                          '(-x+3/4, -x+3/4, -x+1/4)',
                          '(x+1/4, -x+3/4, x+3/4)', '(x+1/4, -x+1/4, x+1/4)',
                          '(x+3/4, -x+3/4, x+1/4)', '(x+3/4, -x+1/4, x+3/4)',
                          '(-x+3/4, x+3/4, x+1/4)', '(-x+3/4, x+1/4, x+3/4)',
                          '(-x+1/4, x+3/4, x+3/4)', '(-x+1/4, x+1/4, x+1/4)'),
                      '0kl: k+l=4n'),
              '48f': (1, ('(x, 0, 0)', '(x, 1/2, 1/2)', '(x+1/2, 0, 1/2)',
                          '(x+1/2, 1/2, 0)', '(-x, 1/2, 1/2)', '(-x, 0, 0)',
                          '(-x+1/2, 1/2, 0)', '(-x+1/2, 0, 1/2)', '(0, x, 0)',
                          '(0, x+1/2, 1/2)', '(1/2, x, 1/2)',
                          '(1/2, x+1/2, 0)', '(1/2, -x, 1/2)',
                          '(1/2, -x+1/2, 0)', '(0, -x, 0)',
                          '(0, -x+1/2, 1/2)', '(0, 0, x)', '(0, 1/2, x+1/2)',
                          '(1/2, 0, x+1/2)', '(1/2, 1/2, x)',
                          '(1/2, 1/2, -x)', '(1/2, 0, -x+1/2)',
                          '(0, 1/2, -x+1/2)', '(0, 0, -x)',
                          '(3/4, x+1/4, 3/4)', '(3/4, x+3/4, 1/4)',
                          '(1/4, x+1/4, 1/4)', '(1/4, x+3/4, 3/4)',
                          '(1/4, -x+1/4, 1/4)', '(1/4, -x+3/4, 3/4)',
                          '(3/4, -x+1/4, 3/4)', '(3/4, -x+3/4, 1/4)',
                          '(x+3/4, 1/4, 3/4)', '(x+3/4, 3/4, 1/4)',
                          '(x+1/4, 1/4, 1/4)', '(x+1/4, 3/4, 3/4)',
                          '(-x+3/4, 3/4, 1/4)', '(-x+3/4, 1/4, 3/4)',
                          '(-x+1/4, 3/4, 3/4)', '(-x+1/4, 1/4, 1/4)',
                          '(3/4, 1/4, -x+3/4)', '(3/4, 3/4, -x+1/4)',
                          '(1/4, 1/4, -x+1/4)', '(1/4, 3/4, -x+3/4)',
                          '(1/4, 3/4, x+3/4)', '(1/4, 1/4, x+1/4)',
                          '(3/4, 3/4, x+1/4)', '(3/4, 1/4, x+3/4)'),
                      'hkl: h=2n+1 or h+k+l=4n'),
              '48g': (2, ('(1/8, y, -y+1/4)', '(1/8, y+1/2, -y+3/4)',
                          '(5/8, y, -y+3/4)', '(5/8, y+1/2, -y+1/4)',
                          '(7/8, -y+1/2, -y+3/4)', '(7/8, -y, -y+1/4)',
                          '(3/8, -y+1/2, -y+1/4)', '(3/8, -y, -y+3/4)',
                          '(3/8, y+1/2, y+3/4)', '(3/8, y, y+1/4)',
                          '(7/8, y+1/2, y+1/4)', '(7/8, y, y+3/4)',
                          '(5/8, -y, y+1/4)', '(5/8, -y+1/2, y+3/4)',
                          '(1/8, -y, y+3/4)', '(1/8, -y+1/2, y+1/4)',
                          '(-y+1/4, 1/8, y)', '(-y+1/4, 5/8, y+1/2)',
                          '(-y+3/4, 1/8, y+1/2)', '(-y+3/4, 5/8, y)',
                          '(-y+3/4, 7/8, -y+1/2)', '(-y+3/4, 3/8, -y)',
                          '(-y+1/4, 7/8, -y)', '(-y+1/4, 3/8, -y+1/2)',
                          '(y+3/4, 3/8, y+1/2)', '(y+3/4, 7/8, y)',
                          '(y+1/4, 3/8, y)', '(y+1/4, 7/8, y+1/2)',
                          '(y+1/4, 5/8, -y)', '(y+1/4, 1/8, -y+1/2)',
                          '(y+3/4, 5/8, -y+1/2)', '(y+3/4, 1/8, -y)',
                          '(y, -y+1/4, 1/8)', '(y, -y+3/4, 5/8)',
                          '(y+1/2, -y+1/4, 5/8)', '(y+1/2, -y+3/4, 1/8)',
                          '(-y+1/2, -y+3/4, 7/8)', '(-y+1/2, -y+1/4, 3/8)',
                          '(-y, -y+3/4, 3/8)', '(-y, -y+1/4, 7/8)',
                          '(y+1/2, y+3/4, 3/8)', '(y+1/2, y+1/4, 7/8)',
                          '(y, y+3/4, 7/8)', '(y, y+1/4, 3/8)',
                          '(-y, y+1/4, 5/8)', '(-y, y+3/4, 1/8)',
                          '(-y+1/2, y+1/4, 1/8)', '(-y+1/2, y+3/4, 5/8)'), None
                      ),
              '96h': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)',
                          '(x+1/2, y, z+1/2)', '(x+1/2, y+1/2, z)',
                          '(-x, -y+1/2, z+1/2)', '(-x, -y, z)',
                          '(-x+1/2, -y+1/2, z)', '(-x+1/2, -y, z+1/2)',
                          '(-x+1/2, y+1/2, -z)', '(-x+1/2, y, -z+1/2)',
                          '(-x, y+1/2, -z+1/2)', '(-x, y, -z)',
                          '(x+1/2, -y, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                          '(x, -y, -z)', '(x, -y+1/2, -z+1/2)', '(z, x, y)',
                          '(z, x+1/2, y+1/2)', '(z+1/2, x, y+1/2)',
                          '(z+1/2, x+1/2, y)', '(z+1/2, -x, -y+1/2)',
                          '(z+1/2, -x+1/2, -y)', '(z, -x, -y)',
                          '(z, -x+1/2, -y+1/2)', '(-z, -x+1/2, y+1/2)',
                          '(-z, -x, y)', '(-z+1/2, -x+1/2, y)',
                          '(-z+1/2, -x, y+1/2)', '(-z+1/2, x+1/2, -y)',
                          '(-z+1/2, x, -y+1/2)', '(-z, x+1/2, -y+1/2)',
                          '(-z, x, -y)', '(y, z, x)', '(y, z+1/2, x+1/2)',
                          '(y+1/2, z, x+1/2)', '(y+1/2, z+1/2, x)',
                          '(-y+1/2, z+1/2, -x)', '(-y+1/2, z, -x+1/2)',
                          '(-y, z+1/2, -x+1/2)', '(-y, z, -x)',
                          '(y+1/2, -z, -x+1/2)', '(y+1/2, -z+1/2, -x)',
                          '(y, -z, -x)', '(y, -z+1/2, -x+1/2)',
                          '(-y, -z+1/2, x+1/2)', '(-y, -z, x)',
                          '(-y+1/2, -z+1/2, x)', '(-y+1/2, -z, x+1/2)',
                          '(y+3/4, x+1/4, -z+3/4)', '(y+3/4, x+3/4, -z+1/4)',
                          '(y+1/4, x+1/4, -z+1/4)', '(y+1/4, x+3/4, -z+3/4)',
                          '(-y+1/4, -x+1/4, -z+1/4)',
                          '(-y+1/4, -x+3/4, -z+3/4)',
                          '(-y+3/4, -x+1/4, -z+3/4)',
                          '(-y+3/4, -x+3/4, -z+1/4)',
                          '(y+1/4, -x+3/4, z+3/4)', '(y+1/4, -x+1/4, z+1/4)',
                          '(y+3/4, -x+3/4, z+1/4)', '(y+3/4, -x+1/4, z+3/4)',
                          '(-y+3/4, x+3/4, z+1/4)', '(-y+3/4, x+1/4, z+3/4)',
                          '(-y+1/4, x+3/4, z+3/4)', '(-y+1/4, x+1/4, z+1/4)',
                          '(x+3/4, z+1/4, -y+3/4)', '(x+3/4, z+3/4, -y+1/4)',
                          '(x+1/4, z+1/4, -y+1/4)', '(x+1/4, z+3/4, -y+3/4)',
                          '(-x+3/4, z+3/4, y+1/4)', '(-x+3/4, z+1/4, y+3/4)',
                          '(-x+1/4, z+3/4, y+3/4)', '(-x+1/4, z+1/4, y+1/4)',
                          '(-x+1/4, -z+1/4, -y+1/4)',
                          '(-x+1/4, -z+3/4, -y+3/4)',
                          '(-x+3/4, -z+1/4, -y+3/4)',
                          '(-x+3/4, -z+3/4, -y+1/4)',
                          '(x+1/4, -z+3/4, y+3/4)', '(x+1/4, -z+1/4, y+1/4)',
                          '(x+3/4, -z+3/4, y+1/4)', '(x+3/4, -z+1/4, y+3/4)',
                          '(z+3/4, y+1/4, -x+3/4)', '(z+3/4, y+3/4, -x+1/4)',
                          '(z+1/4, y+1/4, -x+1/4)', '(z+1/4, y+3/4, -x+3/4)',
                          '(z+1/4, -y+3/4, x+3/4)', '(z+1/4, -y+1/4, x+1/4)',
                          '(z+3/4, -y+3/4, x+1/4)', '(z+3/4, -y+1/4, x+3/4)',
                          '(-z+3/4, y+3/4, x+1/4)', '(-z+3/4, y+1/4, x+3/4)',
                          '(-z+1/4, y+3/4, x+3/4)', '(-z+1/4, y+1/4, x+1/4)',
                          '(-z+1/4, -y+1/4, -x+1/4)',
                          '(-z+1/4, -y+3/4, -x+3/4)',
                          '(-z+3/4, -y+1/4, -x+3/4)',
                          '(-z+3/4, -y+3/4, -x+1/4)'),
                      'hkl: h+k=2n, h+l,k+l=2n, 0kl: k,l=2n, hhl: h+l=2n, '
                      'h00: h=4n')},
      '211': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)'), None),
              '6b': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 0)', '(1/2, 0, 1/2)',
                         '(0, 1/2, 0)', '(1/2, 1/2, 0)', '(0, 0, 1/2)'), None
                     ),
              '8c': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)',
                         '(3/4, 3/4, 1/4)', '(1/4, 1/4, 3/4)',
                         '(3/4, 1/4, 3/4)', '(1/4, 3/4, 1/4)',
                         '(1/4, 3/4, 3/4)', '(3/4, 1/4, 1/4)'), 'hkl: k,l=2n'
                     ),
              '12d': (0, ('(1/4, 1/2, 0)', '(3/4, 0, 1/2)', '(3/4, 1/2, 0)',
                          '(1/4, 0, 1/2)', '(0, 1/4, 1/2)', '(1/2, 3/4, 0)',
                          '(0, 3/4, 1/2)', '(1/2, 1/4, 0)', '(1/2, 0, 1/4)',
                          '(0, 1/2, 3/4)', '(1/2, 0, 3/4)', '(0, 1/2, 1/4)'),
                      None),
              '12e': (1, ('(x, 0, 0)', '(x+1/2, 1/2, 1/2)', '(-x, 0, 0)',
                          '(-x+1/2, 1/2, 1/2)', '(0, x, 0)',
                          '(1/2, x+1/2, 1/2)', '(0, -x, 0)',
                          '(1/2, -x+1/2, 1/2)', '(0, 0, x)',
                          '(1/2, 1/2, x+1/2)', '(0, 0, -x)',
                          '(1/2, 1/2, -x+1/2)'), None),
              '16f': (1, ('(x, x, x)', '(x+1/2, x+1/2, x+1/2)', '(-x, -x, x)',
                          '(-x+1/2, -x+1/2, x+1/2)', '(-x, x, -x)',
                          '(-x+1/2, x+1/2, -x+1/2)', '(x, -x, -x)',
                          '(x+1/2, -x+1/2, -x+1/2)', '(x, x, -x)',
                          '(x+1/2, x+1/2, -x+1/2)', '(-x, -x, -x)',
                          '(-x+1/2, -x+1/2, -x+1/2)', '(x, -x, x)',
                          '(x+1/2, -x+1/2, x+1/2)', '(-x, x, x)',
                          '(-x+1/2, x+1/2, x+1/2)'), None),
              '24g': (1, ('(x, 1/2, 0)', '(x+1/2, 0, 1/2)', '(-x, 1/2, 0)',
                          '(-x+1/2, 0, 1/2)', '(0, x, 1/2)',
                          '(1/2, x+1/2, 0)', '(0, -x, 1/2)',
                          '(1/2, -x+1/2, 0)', '(1/2, 0, x)',
                          '(0, 1/2, x+1/2)', '(1/2, 0, -x)',
                          '(0, 1/2, -x+1/2)', '(1/2, x, 0)',
                          '(0, x+1/2, 1/2)', '(1/2, -x, 0)',
                          '(0, -x+1/2, 1/2)', '(x, 0, 1/2)',
                          '(x+1/2, 1/2, 0)', '(-x, 0, 1/2)',
                          '(-x+1/2, 1/2, 0)', '(0, 1/2, -x)',
                          '(1/2, 0, -x+1/2)', '(0, 1/2, x)',
                          '(1/2, 0, x+1/2)'), None),
              '24h': (2, ('(0, y, y)', '(1/2, y+1/2, y+1/2)', '(0, -y, y)',
                          '(1/2, -y+1/2, y+1/2)', '(0, y, -y)',
                          '(1/2, y+1/2, -y+1/2)', '(0, -y, -y)',
                          '(1/2, -y+1/2, -y+1/2)', '(y, 0, y)',
                          '(y+1/2, 1/2, y+1/2)', '(y, 0, -y)',
                          '(y+1/2, 1/2, -y+1/2)', '(-y, 0, y)',
                          '(-y+1/2, 1/2, y+1/2)', '(-y, 0, -y)',
                          '(-y+1/2, 1/2, -y+1/2)', '(y, y, 0)',
                          '(y+1/2, y+1/2, 1/2)', '(-y, y, 0)',
                          '(-y+1/2, y+1/2, 1/2)', '(y, -y, 0)',
                          '(y+1/2, -y+1/2, 1/2)', '(-y, -y, 0)',
                          '(-y+1/2, -y+1/2, 1/2)'), None),
              '24i': (2, ('(1/4, y, -y+1/2)', '(3/4, y+1/2, -y)',
                          '(3/4, -y, -y+1/2)', '(1/4, -y+1/2, -y)',
                          '(3/4, y, y+1/2)', '(1/4, y+1/2, y)',
                          '(1/4, -y, y+1/2)', '(3/4, -y+1/2, y)',
                          '(-y+1/2, 1/4, y)', '(-y, 3/4, y+1/2)',
                          '(-y+1/2, 3/4, -y)', '(-y, 1/4, -y+1/2)',
                          '(y+1/2, 3/4, y)', '(y, 1/4, y+1/2)',
                          '(y+1/2, 1/4, -y)', '(y, 3/4, -y+1/2)',
                          '(y, -y+1/2, 1/4)', '(y+1/2, -y, 3/4)',
                          '(-y, -y+1/2, 3/4)', '(-y+1/2, -y, 1/4)',
                          '(y, y+1/2, 3/4)', '(y+1/2, y, 1/4)',
                          '(-y, y+1/2, 1/4)', '(-y+1/2, y, 3/4)'), None),
              '48j': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                          '(-x+1/2, -y+1/2, z+1/2)', '(-x, y, -z)',
                          '(-x+1/2, y+1/2, -z+1/2)', '(x, -y, -z)',
                          '(x+1/2, -y+1/2, -z+1/2)', '(z, x, y)',
                          '(z+1/2, x+1/2, y+1/2)', '(z, -x, -y)',
                          '(z+1/2, -x+1/2, -y+1/2)', '(-z, -x, y)',
                          '(-z+1/2, -x+1/2, y+1/2)', '(-z, x, -y)',
                          '(-z+1/2, x+1/2, -y+1/2)', '(y, z, x)',
                          '(y+1/2, z+1/2, x+1/2)', '(-y, z, -x)',
                          '(-y+1/2, z+1/2, -x+1/2)', '(y, -z, -x)',
                          '(y+1/2, -z+1/2, -x+1/2)', '(-y, -z, x)',
                          '(-y+1/2, -z+1/2, x+1/2)', '(y, x, -z)',
                          '(y+1/2, x+1/2, -z+1/2)', '(-y, -x, -z)',
                          '(-y+1/2, -x+1/2, -z+1/2)', '(y, -x, z)',
                          '(y+1/2, -x+1/2, z+1/2)', '(-y, x, z)',
                          '(-y+1/2, x+1/2, z+1/2)', '(x, z, -y)',
                          '(x+1/2, z+1/2, -y+1/2)', '(-x, z, y)',
                          '(-x+1/2, z+1/2, y+1/2)', '(-x, -z, -y)',
                          '(-x+1/2, -z+1/2, -y+1/2)', '(x, -z, y)',
                          '(x+1/2, -z+1/2, y+1/2)', '(z, y, -x)',
                          '(z+1/2, y+1/2, -x+1/2)', '(z, -y, x)',
                          '(z+1/2, -y+1/2, x+1/2)', '(-z, y, x)',
                          '(-z+1/2, y+1/2, x+1/2)', '(-z, -y, -x)',
                          '(-z+1/2, -y+1/2, -x+1/2)'),
                      'hkl: h+k+l=2n, 0kl: k+l=2n, hhl: l=2n, h00: h=2n')},
      '212': {'4a': (0, ('(1/8, 1/8, 1/8)', '(3/8, 7/8, 5/8)',
                         '(7/8, 5/8, 3/8)', '(5/8, 3/8, 7/8)'),
                     'hkl: h,k=2n+1 or h=2n+1, k=4n, '
                     'l=4n+2 or h,k,l=4n+2 or h,k,l=4n'),
              '4b': (0, ('(5/8, 5/8, 5/8)', '(7/8, 3/8, 1/8)',
                         '(3/8, 1/8, 7/8)', '(1/8, 7/8, 3/8)'),
                     'hkl: h,k=2n+1 or h=2n+1, k=4n, '
                     'l=4n+2 or h,k,l=4n+2 or h,k,l=4n'),
              '8c': (1, ('(x, x, x)', '(-x+1/2, -x, x+1/2)',
                         '(-x, x+1/2, -x+1/2)', '(x+1/2, -x+1/2, -x)',
                         '(x+1/4, x+3/4, -x+3/4)', '(-x+1/4, -x+1/4, -x+1/4)',
                         '(x+3/4, -x+3/4, x+1/4)', '(-x+3/4, x+1/4, x+3/4)'),
                     '0kl: k=2n+1 or l=2n+1 or k+l=4n'),
              '12d': (2, ('(1/8, y, -y+1/4)', '(3/8, -y, -y+3/4)',
                          '(7/8, y+1/2, y+1/4)', '(5/8, -y+1/2, y+3/4)',
                          '(-y+1/4, 1/8, y)', '(-y+3/4, 3/8, -y)',
                          '(y+1/4, 7/8, y+1/2)', '(y+3/4, 5/8, -y+1/2)',
                          '(y, -y+1/4, 1/8)', '(-y, -y+3/4, 3/8)',
                          '(y+1/2, y+1/4, 7/8)', '(-y+1/2, y+3/4, 5/8)'), None
                      ),
              '24e': (7, ('(x, y, z)', '(-x+1/2, -y, z+1/2)',
                          '(-x, y+1/2, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                          '(z, x, y)', '(z+1/2, -x+1/2, -y)',
                          '(-z+1/2, -x, y+1/2)', '(-z, x+1/2, -y+1/2)',
                          '(y, z, x)', '(-y, z+1/2, -x+1/2)',
                          '(y+1/2, -z+1/2, -x)', '(-y+1/2, -z, x+1/2)',
                          '(y+1/4, x+3/4, -z+3/4)',
                          '(-y+1/4, -x+1/4, -z+1/4)',
                          '(y+3/4, -x+3/4, z+1/4)', '(-y+3/4, x+1/4, z+3/4)',
                          '(x+1/4, z+3/4, -y+3/4)', '(-x+3/4, z+1/4, y+3/4)',
                          '(-x+1/4, -z+1/4, -y+1/4)',
                          '(x+3/4, -z+3/4, y+1/4)', '(z+1/4, y+3/4, -x+3/4)',
                          '(z+3/4, -y+3/4, x+1/4)', '(-z+3/4, y+1/4, x+3/4)',
                          '(-z+1/4, -y+1/4, -x+1/4)'), 'h00: h=4n')},
      '213': {'4a': (0, ('(3/8, 3/8, 3/8)', '(1/8, 5/8, 7/8)',
                         '(5/8, 7/8, 1/8)', '(7/8, 1/8, 5/8)'),
                     'hkl: h,k=2n+1 or h=2n+1, k=4n, '
                     'l=4n+2 or h,k,l=4n+2 or h,k,l=4n'),
              '4b': (0, ('(7/8, 7/8, 7/8)', '(5/8, 1/8, 3/8)',
                         '(1/8, 3/8, 5/8)', '(3/8, 5/8, 1/8)'),
                     'hkl: h,k=2n+1 or h=2n+1, k=4n, '
                     'l=4n+2 or h,k,l=4n+2 or h,k,l=4n'),
              '8c': (1, ('(x, x, x)', '(-x+1/2, -x, x+1/2)',
                         '(-x, x+1/2, -x+1/2)', '(x+1/2, -x+1/2, -x)',
                         '(x+3/4, x+1/4, -x+1/4)', '(-x+3/4, -x+3/4, -x+3/4)',
                         '(x+1/4, -x+1/4, x+3/4)', '(-x+1/4, x+3/4, x+1/4)'),
                     '0kl: k=2n+1 or l=2n+1 or k+l=4n'),
              '12d': (2, ('(1/8, y, y+1/4)', '(3/8, -y, y+3/4)',
                          '(7/8, y+1/2, -y+1/4)', '(5/8, -y+1/2, -y+3/4)',
                          '(y+1/4, 1/8, y)', '(y+3/4, 3/8, -y)',
                          '(-y+1/4, 7/8, y+1/2)', '(-y+3/4, 5/8, -y+1/2)',
                          '(y, y+1/4, 1/8)', '(-y, y+3/4, 3/8)',
                          '(y+1/2, -y+1/4, 7/8)', '(-y+1/2, -y+3/4, 5/8)'),
                      None),
              '24e': (7, ('(x, y, z)', '(-x+1/2, -y, z+1/2)',
                          '(-x, y+1/2, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                          '(z, x, y)', '(z+1/2, -x+1/2, -y)',
                          '(-z+1/2, -x, y+1/2)', '(-z, x+1/2, -y+1/2)',
                          '(y, z, x)', '(-y, z+1/2, -x+1/2)',
                          '(y+1/2, -z+1/2, -x)', '(-y+1/2, -z, x+1/2)',
                          '(y+3/4, x+1/4, -z+1/4)',
                          '(-y+3/4, -x+3/4, -z+3/4)',
                          '(y+1/4, -x+1/4, z+3/4)', '(-y+1/4, x+3/4, z+1/4)',
                          '(x+3/4, z+1/4, -y+1/4)', '(-x+1/4, z+3/4, y+1/4)',
                          '(-x+3/4, -z+3/4, -y+3/4)',
                          '(x+1/4, -z+1/4, y+3/4)', '(z+3/4, y+1/4, -x+1/4)',
                          '(z+1/4, -y+1/4, x+3/4)', '(-z+1/4, y+3/4, x+1/4)',
                          '(-z+3/4, -y+3/4, -x+3/4)'), 'h00: h=4n')},
      '214': {'8a': (0, ('(1/8, 1/8, 1/8)', '(5/8, 5/8, 5/8)',
                         '(3/8, 7/8, 5/8)', '(7/8, 3/8, 1/8)',
                         '(7/8, 5/8, 3/8)', '(3/8, 1/8, 7/8)',
                         '(5/8, 3/8, 7/8)', '(1/8, 7/8, 3/8)'),
                     'hkl: h=2n+1 or h,k,l=4n+2 or h,k,l=4n'),
              '8b': (0, ('(7/8, 7/8, 7/8)', '(3/8, 3/8, 3/8)',
                         '(5/8, 1/8, 3/8)', '(1/8, 5/8, 7/8)',
                         '(1/8, 3/8, 5/8)', '(5/8, 7/8, 1/8)',
                         '(3/8, 5/8, 1/8)', '(7/8, 1/8, 5/8)'),
                     'hkl: h=2n+1 or h,k,l=4n+2 or h,k,l=4n'),
              '12c': (0, ('(1/8, 0, 1/4)', '(5/8, 1/2, 3/4)', '(3/8, 0, 3/4)',
                          '(7/8, 1/2, 1/4)', '(1/4, 1/8, 0)',
                          '(3/4, 5/8, 1/2)', '(3/4, 3/8, 0)',
                          '(1/4, 7/8, 1/2)', '(0, 1/4, 1/8)',
                          '(1/2, 3/4, 5/8)', '(0, 3/4, 3/8)',
                          '(1/2, 1/4, 7/8)'),
                      'hkl: h,k=2n, h+k+l=4n or h,k=2n+1, '
                      'l=4n+2 or h=8n, k=8n+4, '
                      'h+k+l=4n+2 or h,k=8n+1, l=4n or h=8n+1, '
                      'k=8n-1, l=4n or h,k=8n+3, l=4n or '
                      'h=8n+3, k=8n-3, l=4n'),
              '12d': (0, ('(5/8, 0, 1/4)', '(1/8, 1/2, 3/4)', '(7/8, 0, 3/4)',
                          '(3/8, 1/2, 1/4)', '(1/4, 5/8, 0)',
                          '(3/4, 1/8, 1/2)', '(3/4, 7/8, 0)',
                          '(1/4, 3/8, 1/2)', '(0, 1/4, 5/8)',
                          '(1/2, 3/4, 1/8)', '(0, 3/4, 7/8)',
                          '(1/2, 1/4, 3/8)'),
                      'hkl: h,k=2n, h+k+l=4n or h,k=2n+1, '
                      'l=4n+2 or h=8n, k=8n+4, '
                      'h+k+l=4n+2 or h,k=8n+1, l=4n or h=8n+1, '
                      'k=8n-1, l=4n or h,k=8n+3, l=4n or '
                      'h=8n+3, k=8n-3, l=4n'),
              '16e': (1, ('(x, x, x)', '(x+1/2, x+1/2, x+1/2)',
                          '(-x+1/2, -x, x+1/2)', '(-x, -x+1/2, x)',
                          '(-x, x+1/2, -x+1/2)', '(-x+1/2, x, -x)',
                          '(x+1/2, -x+1/2, -x)', '(x, -x, -x+1/2)',
                          '(x+3/4, x+1/4, -x+1/4)', '(x+1/4, x+3/4, -x+3/4)',
                          '(-x+3/4, -x+3/4, -x+3/4)',
                          '(-x+1/4, -x+1/4, -x+1/4)',
                          '(x+1/4, -x+1/4, x+3/4)', '(x+3/4, -x+3/4, x+1/4)',
                          '(-x+1/4, x+3/4, x+1/4)', '(-x+3/4, x+1/4, x+3/4)'),
                      '0kl: k=2n+1 or k+l=4n'),
              '24f': (1, ('(x, 0, 1/4)', '(x+1/2, 1/2, 3/4)',
                          '(-x+1/2, 0, 3/4)', '(-x, 1/2, 1/4)', '(1/4, x, 0)',
                          '(3/4, x+1/2, 1/2)', '(3/4, -x+1/2, 0)',
                          '(1/4, -x, 1/2)', '(0, 1/4, x)',
                          '(1/2, 3/4, x+1/2)', '(0, 3/4, -x+1/2)',
                          '(1/2, 1/4, -x)', '(3/4, x+1/4, 0)',
                          '(1/4, x+3/4, 1/2)', '(3/4, -x+3/4, 1/2)',
                          '(1/4, -x+1/4, 0)', '(x+3/4, 1/2, 1/4)',
                          '(x+1/4, 0, 3/4)', '(-x+1/4, 0, 1/4)',
                          '(-x+3/4, 1/2, 3/4)', '(0, 1/4, -x+1/4)',
                          '(1/2, 3/4, -x+3/4)', '(1/2, 1/4, x+3/4)',
                          '(0, 3/4, x+1/4)'),
                      'hkl: h=2n+1 or h=4n, hhl: h=2n+1 or h+k+l=4n'),
              '24g': (2, ('(1/8, y, y+1/4)', '(5/8, y+1/2, y+3/4)',
                          '(3/8, -y, y+3/4)', '(7/8, -y+1/2, y+1/4)',
                          '(7/8, y+1/2, -y+1/4)', '(3/8, y, -y+3/4)',
                          '(5/8, -y+1/2, -y+3/4)', '(1/8, -y, -y+1/4)',
                          '(y+1/4, 1/8, y)', '(y+3/4, 5/8, y+1/2)',
                          '(y+3/4, 3/8, -y)', '(y+1/4, 7/8, -y+1/2)',
                          '(-y+1/4, 7/8, y+1/2)', '(-y+3/4, 3/8, y)',
                          '(-y+3/4, 5/8, -y+1/2)', '(-y+1/4, 1/8, -y)',
                          '(y, y+1/4, 1/8)', '(y+1/2, y+3/4, 5/8)',
                          '(-y, y+3/4, 3/8)', '(-y+1/2, y+1/4, 7/8)',
                          '(y+1/2, -y+1/4, 7/8)', '(y, -y+3/4, 3/8)',
                          '(-y+1/2, -y+3/4, 5/8)', '(-y, -y+1/4, 1/8)'), None
                      ),
              '24h': (2, ('(1/8, y, -y+1/4)', '(5/8, y+1/2, -y+3/4)',
                          '(3/8, -y, -y+3/4)', '(7/8, -y+1/2, -y+1/4)',
                          '(7/8, y+1/2, y+1/4)', '(3/8, y, y+3/4)',
                          '(5/8, -y+1/2, y+3/4)', '(1/8, -y, y+1/4)',
                          '(-y+1/4, 1/8, y)', '(-y+3/4, 5/8, y+1/2)',
                          '(-y+3/4, 3/8, -y)', '(-y+1/4, 7/8, -y+1/2)',
                          '(y+1/4, 7/8, y+1/2)', '(y+3/4, 3/8, y)',
                          '(y+3/4, 5/8, -y+1/2)', '(y+1/4, 1/8, -y)',
                          '(y, -y+1/4, 1/8)', '(y+1/2, -y+3/4, 5/8)',
                          '(-y, -y+3/4, 3/8)', '(-y+1/2, -y+1/4, 7/8)',
                          '(y+1/2, y+1/4, 7/8)', '(y, y+3/4, 3/8)',
                          '(-y+1/2, y+3/4, 5/8)', '(-y, y+1/4, 1/8)'), None),
              '48i': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)',
                          '(-x+1/2, -y, z+1/2)', '(-x, -y+1/2, z)',
                          '(-x, y+1/2, -z+1/2)', '(-x+1/2, y, -z)',
                          '(x+1/2, -y+1/2, -z)', '(x, -y, -z+1/2)',
                          '(z, x, y)', '(z+1/2, x+1/2, y+1/2)',
                          '(z+1/2, -x+1/2, -y)', '(z, -x, -y+1/2)',
                          '(-z+1/2, -x, y+1/2)', '(-z, -x+1/2, y)',
                          '(-z, x+1/2, -y+1/2)', '(-z+1/2, x, -y)',
                          '(y, z, x)', '(y+1/2, z+1/2, x+1/2)',
                          '(-y, z+1/2, -x+1/2)', '(-y+1/2, z, -x)',
                          '(y+1/2, -z+1/2, -x)', '(y, -z, -x+1/2)',
                          '(-y+1/2, -z, x+1/2)', '(-y, -z+1/2, x)',
                          '(y+3/4, x+1/4, -z+1/4)', '(y+1/4, x+3/4, -z+3/4)',
                          '(-y+3/4, -x+3/4, -z+3/4)',
                          '(-y+1/4, -x+1/4, -z+1/4)',
                          '(y+1/4, -x+1/4, z+3/4)', '(y+3/4, -x+3/4, z+1/4)',
                          '(-y+1/4, x+3/4, z+1/4)', '(-y+3/4, x+1/4, z+3/4)',
                          '(x+3/4, z+1/4, -y+1/4)', '(x+1/4, z+3/4, -y+3/4)',
                          '(-x+1/4, z+3/4, y+1/4)', '(-x+3/4, z+1/4, y+3/4)',
                          '(-x+3/4, -z+3/4, -y+3/4)',
                          '(-x+1/4, -z+1/4, -y+1/4)',
                          '(x+1/4, -z+1/4, y+3/4)', '(x+3/4, -z+3/4, y+1/4)',
                          '(z+3/4, y+1/4, -x+1/4)', '(z+1/4, y+3/4, -x+3/4)',
                          '(z+1/4, -y+1/4, x+3/4)', '(z+3/4, -y+3/4, x+1/4)',
                          '(-z+1/4, y+3/4, x+1/4)', '(-z+3/4, y+1/4, x+3/4)',
                          '(-z+3/4, -y+3/4, -x+3/4)',
                          '(-z+1/4, -y+1/4, -x+1/4)'),
                      'hkl: h+k+l=2n, 0kl: k+l=2n, hhl: l=2n, h00: h=4n')},
      '215': {'1a': (0, ('(0, 0, 0)', ), None),
              '1b': (0, ('(1/2, 1/2, 1/2)', ), None),
              '3c': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)', '(1/2, 1/2, 0)'),
                     None),
              '3d': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(0, 0, 1/2)'), None),
              '4e': (1, ('(x, x, x)', '(-x, -x, x)', '(-x, x, -x)',
                         '(x, -x, -x)'), None),
              '6f': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(0, x, 0)', '(0, -x, 0)',
                         '(0, 0, x)', '(0, 0, -x)'), None),
              '6g': (1, ('(x, 1/2, 1/2)', '(-x, 1/2, 1/2)', '(1/2, x, 1/2)',
                         '(1/2, -x, 1/2)', '(1/2, 1/2, x)', '(1/2, 1/2, -x)'),
                     None),
              '12h': (1, ('(x, 1/2, 0)', '(-x, 1/2, 0)', '(0, x, 1/2)',
                          '(0, -x, 1/2)', '(1/2, 0, x)', '(1/2, 0, -x)',
                          '(1/2, x, 0)', '(1/2, -x, 0)', '(x, 0, 1/2)',
                          '(-x, 0, 1/2)', '(0, 1/2, x)', '(0, 1/2, -x)'), None
                      ),
              '12i': (5, ('(x, x, z)', '(-x, -x, z)', '(-x, x, -z)',
                          '(x, -x, -z)', '(z, x, x)', '(z, -x, -x)',
                          '(-z, -x, x)', '(-z, x, -x)', '(x, z, x)',
                          '(-x, z, -x)', '(x, -z, -x)', '(-x, -z, x)'), None),
              '24j': (7, ('(x, y, z)', '(-x, -y, z)', '(-x, y, -z)',
                          '(x, -y, -z)', '(z, x, y)', '(z, -x, -y)',
                          '(-z, -x, y)', '(-z, x, -y)', '(y, z, x)',
                          '(-y, z, -x)', '(y, -z, -x)', '(-y, -z, x)',
                          '(y, x, z)', '(-y, -x, z)', '(y, -x, -z)',
                          '(-y, x, -z)', '(x, z, y)', '(-x, z, -y)',
                          '(-x, -z, y)', '(x, -z, -y)', '(z, y, x)',
                          '(z, -y, -x)', '(-z, y, -x)', '(-z, -y, x)'), None
                      )},
      '216': {'4a': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                         '(1/2, 1/2, 0)'), None),
              '4b': (0, ('(1/2, 1/2, 1/2)', '(1/2, 0, 0)', '(0, 1/2, 0)',
                         '(0, 0, 1/2)'), None),
              '4c': (0, ('(1/4, 1/4, 1/4)', '(1/4, 3/4, 3/4)',
                         '(3/4, 1/4, 3/4)', '(3/4, 3/4, 1/4)'), None),
              '4d': (0, ('(3/4, 3/4, 3/4)', '(3/4, 1/4, 1/4)',
                         '(1/4, 3/4, 1/4)', '(1/4, 1/4, 3/4)'), None),
              '16e': (1, ('(x, x, x)', '(x, x+1/2, x+1/2)',
                          '(x+1/2, x, x+1/2)', '(x+1/2, x+1/2, x)',
                          '(-x, -x, x)', '(-x, -x+1/2, x+1/2)',
                          '(-x+1/2, -x, x+1/2)', '(-x+1/2, -x+1/2, x)',
                          '(-x, x, -x)', '(-x, x+1/2, -x+1/2)',
                          '(-x+1/2, x, -x+1/2)', '(-x+1/2, x+1/2, -x)',
                          '(x, -x, -x)', '(x, -x+1/2, -x+1/2)',
                          '(x+1/2, -x, -x+1/2)', '(x+1/2, -x+1/2, -x)'), None
                      ),
              '24f': (1, ('(x, 0, 0)', '(x, 1/2, 1/2)', '(x+1/2, 0, 1/2)',
                          '(x+1/2, 1/2, 0)', '(-x, 0, 0)', '(-x, 1/2, 1/2)',
                          '(-x+1/2, 0, 1/2)', '(-x+1/2, 1/2, 0)', '(0, x, 0)',
                          '(0, x+1/2, 1/2)', '(1/2, x, 1/2)',
                          '(1/2, x+1/2, 0)', '(0, -x, 0)', '(0, -x+1/2, 1/2)',
                          '(1/2, -x, 1/2)', '(1/2, -x+1/2, 0)', '(0, 0, x)',
                          '(0, 1/2, x+1/2)', '(1/2, 0, x+1/2)',
                          '(1/2, 1/2, x)', '(0, 0, -x)', '(0, 1/2, -x+1/2)',
                          '(1/2, 0, -x+1/2)', '(1/2, 1/2, -x)'), None),
              '24g': (1, ('(x, 1/4, 1/4)', '(x, 3/4, 3/4)',
                          '(x+1/2, 1/4, 3/4)', '(x+1/2, 3/4, 1/4)',
                          '(-x, 3/4, 1/4)', '(-x, 1/4, 3/4)',
                          '(-x+1/2, 3/4, 3/4)', '(-x+1/2, 1/4, 1/4)',
                          '(1/4, x, 1/4)', '(1/4, x+1/2, 3/4)',
                          '(3/4, x, 3/4)', '(3/4, x+1/2, 1/4)',
                          '(1/4, -x, 3/4)', '(1/4, -x+1/2, 1/4)',
                          '(3/4, -x, 1/4)', '(3/4, -x+1/2, 3/4)',
                          '(1/4, 1/4, x)', '(1/4, 3/4, x+1/2)',
                          '(3/4, 1/4, x+1/2)', '(3/4, 3/4, x)',
                          '(3/4, 1/4, -x)', '(3/4, 3/4, -x+1/2)',
                          '(1/4, 1/4, -x+1/2)', '(1/4, 3/4, -x)'), None),
              '48h': (5, ('(x, x, z)', '(x, x+1/2, z+1/2)',
                          '(x+1/2, x, z+1/2)', '(x+1/2, x+1/2, z)',
                          '(-x, -x, z)', '(-x, -x+1/2, z+1/2)',
                          '(-x+1/2, -x, z+1/2)', '(-x+1/2, -x+1/2, z)',
                          '(-x, x, -z)', '(-x, x+1/2, -z+1/2)',
                          '(-x+1/2, x, -z+1/2)', '(-x+1/2, x+1/2, -z)',
                          '(x, -x, -z)', '(x, -x+1/2, -z+1/2)',
                          '(x+1/2, -x, -z+1/2)', '(x+1/2, -x+1/2, -z)',
                          '(z, x, x)', '(z, x+1/2, x+1/2)',
                          '(z+1/2, x, x+1/2)', '(z+1/2, x+1/2, x)',
                          '(z, -x, -x)', '(z, -x+1/2, -x+1/2)',
                          '(z+1/2, -x, -x+1/2)', '(z+1/2, -x+1/2, -x)',
                          '(-z, -x, x)', '(-z, -x+1/2, x+1/2)',
                          '(-z+1/2, -x, x+1/2)', '(-z+1/2, -x+1/2, x)',
                          '(-z, x, -x)', '(-z, x+1/2, -x+1/2)',
                          '(-z+1/2, x, -x+1/2)', '(-z+1/2, x+1/2, -x)',
                          '(x, z, x)', '(x, z+1/2, x+1/2)',
                          '(x+1/2, z, x+1/2)', '(x+1/2, z+1/2, x)',
                          '(-x, z, -x)', '(-x, z+1/2, -x+1/2)',
                          '(-x+1/2, z, -x+1/2)', '(-x+1/2, z+1/2, -x)',
                          '(x, -z, -x)', '(x, -z+1/2, -x+1/2)',
                          '(x+1/2, -z, -x+1/2)', '(x+1/2, -z+1/2, -x)',
                          '(-x, -z, x)', '(-x, -z+1/2, x+1/2)',
                          '(-x+1/2, -z, x+1/2)', '(-x+1/2, -z+1/2, x)'), None
                      ),
              '96i': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)',
                          '(x+1/2, y, z+1/2)', '(x+1/2, y+1/2, z)',
                          '(-x, -y, z)', '(-x, -y+1/2, z+1/2)',
                          '(-x+1/2, -y, z+1/2)', '(-x+1/2, -y+1/2, z)',
                          '(-x, y, -z)', '(-x, y+1/2, -z+1/2)',
                          '(-x+1/2, y, -z+1/2)', '(-x+1/2, y+1/2, -z)',
                          '(x, -y, -z)', '(x, -y+1/2, -z+1/2)',
                          '(x+1/2, -y, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                          '(z, x, y)', '(z, x+1/2, y+1/2)',
                          '(z+1/2, x, y+1/2)', '(z+1/2, x+1/2, y)',
                          '(z, -x, -y)', '(z, -x+1/2, -y+1/2)',
                          '(z+1/2, -x, -y+1/2)', '(z+1/2, -x+1/2, -y)',
                          '(-z, -x, y)', '(-z, -x+1/2, y+1/2)',
                          '(-z+1/2, -x, y+1/2)', '(-z+1/2, -x+1/2, y)',
                          '(-z, x, -y)', '(-z, x+1/2, -y+1/2)',
                          '(-z+1/2, x, -y+1/2)', '(-z+1/2, x+1/2, -y)',
                          '(y, z, x)', '(y, z+1/2, x+1/2)',
                          '(y+1/2, z, x+1/2)', '(y+1/2, z+1/2, x)',
                          '(-y, z, -x)', '(-y, z+1/2, -x+1/2)',
                          '(-y+1/2, z, -x+1/2)', '(-y+1/2, z+1/2, -x)',
                          '(y, -z, -x)', '(y, -z+1/2, -x+1/2)',
                          '(y+1/2, -z, -x+1/2)', '(y+1/2, -z+1/2, -x)',
                          '(-y, -z, x)', '(-y, -z+1/2, x+1/2)',
                          '(-y+1/2, -z, x+1/2)', '(-y+1/2, -z+1/2, x)',
                          '(y, x, z)', '(y, x+1/2, z+1/2)',
                          '(y+1/2, x, z+1/2)', '(y+1/2, x+1/2, z)',
                          '(-y, -x, z)', '(-y, -x+1/2, z+1/2)',
                          '(-y+1/2, -x, z+1/2)', '(-y+1/2, -x+1/2, z)',
                          '(y, -x, -z)', '(y, -x+1/2, -z+1/2)',
                          '(y+1/2, -x, -z+1/2)', '(y+1/2, -x+1/2, -z)',
                          '(-y, x, -z)', '(-y, x+1/2, -z+1/2)',
                          '(-y+1/2, x, -z+1/2)', '(-y+1/2, x+1/2, -z)',
                          '(x, z, y)', '(x, z+1/2, y+1/2)',
                          '(x+1/2, z, y+1/2)', '(x+1/2, z+1/2, y)',
                          '(-x, z, -y)', '(-x, z+1/2, -y+1/2)',
                          '(-x+1/2, z, -y+1/2)', '(-x+1/2, z+1/2, -y)',
                          '(-x, -z, y)', '(-x, -z+1/2, y+1/2)',
                          '(-x+1/2, -z, y+1/2)', '(-x+1/2, -z+1/2, y)',
                          '(x, -z, -y)', '(x, -z+1/2, -y+1/2)',
                          '(x+1/2, -z, -y+1/2)', '(x+1/2, -z+1/2, -y)',
                          '(z, y, x)', '(z, y+1/2, x+1/2)',
                          '(z+1/2, y, x+1/2)', '(z+1/2, y+1/2, x)',
                          '(z, -y, -x)', '(z, -y+1/2, -x+1/2)',
                          '(z+1/2, -y, -x+1/2)', '(z+1/2, -y+1/2, -x)',
                          '(-z, y, -x)', '(-z, y+1/2, -x+1/2)',
                          '(-z+1/2, y, -x+1/2)', '(-z+1/2, y+1/2, -x)',
                          '(-z, -y, x)', '(-z, -y+1/2, x+1/2)',
                          '(-z+1/2, -y, x+1/2)', '(-z+1/2, -y+1/2, x)'),
                      'hkl: h+k,h+l,k+l=2n, 0kl: k,l=2n, hhl: h+l=2n, '
                      'h00: h=2n')},
      '217': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)'), None),
              '6b': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 0)', '(1/2, 0, 1/2)',
                         '(0, 1/2, 0)', '(1/2, 1/2, 0)', '(0, 0, 1/2)'), None
                     ),
              '8c': (1, ('(x, x, x)', '(x+1/2, x+1/2, x+1/2)', '(-x, -x, x)',
                         '(-x+1/2, -x+1/2, x+1/2)', '(-x, x, -x)',
                         '(-x+1/2, x+1/2, -x+1/2)', '(x, -x, -x)',
                         '(x+1/2, -x+1/2, -x+1/2)'), None),
              '12d': (0, ('(1/4, 1/2, 0)', '(3/4, 0, 1/2)', '(3/4, 1/2, 0)',
                          '(1/4, 0, 1/2)', '(0, 1/4, 1/2)', '(1/2, 3/4, 0)',
                          '(0, 3/4, 1/2)', '(1/2, 1/4, 0)', '(1/2, 0, 1/4)',
                          '(0, 1/2, 3/4)', '(1/2, 0, 3/4)', '(0, 1/2, 1/4)'),
                      None),
              '12e': (1, ('(x, 0, 0)', '(x+1/2, 1/2, 1/2)', '(-x, 0, 0)',
                          '(-x+1/2, 1/2, 1/2)', '(0, x, 0)',
                          '(1/2, x+1/2, 1/2)', '(0, -x, 0)',
                          '(1/2, -x+1/2, 1/2)', '(0, 0, x)',
                          '(1/2, 1/2, x+1/2)', '(0, 0, -x)',
                          '(1/2, 1/2, -x+1/2)'), None),
              '24f': (1, ('(x, 1/2, 0)', '(x+1/2, 0, 1/2)', '(-x, 1/2, 0)',
                          '(-x+1/2, 0, 1/2)', '(0, x, 1/2)',
                          '(1/2, x+1/2, 0)', '(0, -x, 1/2)',
                          '(1/2, -x+1/2, 0)', '(1/2, 0, x)',
                          '(0, 1/2, x+1/2)', '(1/2, 0, -x)',
                          '(0, 1/2, -x+1/2)', '(1/2, x, 0)',
                          '(0, x+1/2, 1/2)', '(1/2, -x, 0)',
                          '(0, -x+1/2, 1/2)', '(x, 0, 1/2)',
                          '(x+1/2, 1/2, 0)', '(-x, 0, 1/2)',
                          '(-x+1/2, 1/2, 0)', '(0, 1/2, x)',
                          '(1/2, 0, x+1/2)', '(0, 1/2, -x)',
                          '(1/2, 0, -x+1/2)'), None),
              '24g': (5, ('(x, x, z)', '(x+1/2, x+1/2, z+1/2)', '(-x, -x, z)',
                          '(-x+1/2, -x+1/2, z+1/2)', '(-x, x, -z)',
                          '(-x+1/2, x+1/2, -z+1/2)', '(x, -x, -z)',
                          '(x+1/2, -x+1/2, -z+1/2)', '(z, x, x)',
                          '(z+1/2, x+1/2, x+1/2)', '(z, -x, -x)',
                          '(z+1/2, -x+1/2, -x+1/2)', '(-z, -x, x)',
                          '(-z+1/2, -x+1/2, x+1/2)', '(-z, x, -x)',
                          '(-z+1/2, x+1/2, -x+1/2)', '(x, z, x)',
                          '(x+1/2, z+1/2, x+1/2)', '(-x, z, -x)',
                          '(-x+1/2, z+1/2, -x+1/2)', '(x, -z, -x)',
                          '(x+1/2, -z+1/2, -x+1/2)', '(-x, -z, x)',
                          '(-x+1/2, -z+1/2, x+1/2)'), None),
              '48h': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                          '(-x+1/2, -y+1/2, z+1/2)', '(-x, y, -z)',
                          '(-x+1/2, y+1/2, -z+1/2)', '(x, -y, -z)',
                          '(x+1/2, -y+1/2, -z+1/2)', '(z, x, y)',
                          '(z+1/2, x+1/2, y+1/2)', '(z, -x, -y)',
                          '(z+1/2, -x+1/2, -y+1/2)', '(-z, -x, y)',
                          '(-z+1/2, -x+1/2, y+1/2)', '(-z, x, -y)',
                          '(-z+1/2, x+1/2, -y+1/2)', '(y, z, x)',
                          '(y+1/2, z+1/2, x+1/2)', '(-y, z, -x)',
                          '(-y+1/2, z+1/2, -x+1/2)', '(y, -z, -x)',
                          '(y+1/2, -z+1/2, -x+1/2)', '(-y, -z, x)',
                          '(-y+1/2, -z+1/2, x+1/2)', '(y, x, z)',
                          '(y+1/2, x+1/2, z+1/2)', '(-y, -x, z)',
                          '(-y+1/2, -x+1/2, z+1/2)', '(y, -x, -z)',
                          '(y+1/2, -x+1/2, -z+1/2)', '(-y, x, -z)',
                          '(-y+1/2, x+1/2, -z+1/2)', '(x, z, y)',
                          '(x+1/2, z+1/2, y+1/2)', '(-x, z, -y)',
                          '(-x+1/2, z+1/2, -y+1/2)', '(-x, -z, y)',
                          '(-x+1/2, -z+1/2, y+1/2)', '(x, -z, -y)',
                          '(x+1/2, -z+1/2, -y+1/2)', '(z, y, x)',
                          '(z+1/2, y+1/2, x+1/2)', '(z, -y, -x)',
                          '(z+1/2, -y+1/2, -x+1/2)', '(-z, y, -x)',
                          '(-z+1/2, y+1/2, -x+1/2)', '(-z, -y, x)',
                          '(-z+1/2, -y+1/2, x+1/2)'),
                      'hkl: h+k+l=2n, 0kl: k+l=2n, hhl: l=2n, h00: h=2n')},
      '218': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)'), 'hkl: h+k+l=2n'),
              '6b': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)', '(1/2, 1/2, 0)',
                         '(0, 1/2, 0)', '(1/2, 0, 0)', '(0, 0, 1/2)'),
                     'hkl: h+k+l=2n'),
              '6c': (0, ('(1/4, 1/2, 0)', '(3/4, 1/2, 0)', '(0, 1/4, 1/2)',
                         '(0, 3/4, 1/2)', '(1/2, 0, 1/4)', '(1/2, 0, 3/4)'),
                     'hkl: h+k+l=2n or h=2n+1, k=4n, l=4n+2'),
              '6d': (0, ('(1/4, 0, 1/2)', '(3/4, 0, 1/2)', '(1/2, 1/4, 0)',
                         '(1/2, 3/4, 0)', '(0, 1/2, 1/4)', '(0, 1/2, 3/4)'),
                     'hkl: h+k+l=2n or h=2n+1, k=4n, l=4n+2'),
              '8e': (1, ('(x, x, x)', '(-x, -x, x)', '(-x, x, -x)',
                         '(x, -x, -x)', '(x+1/2, x+1/2, x+1/2)',
                         '(-x+1/2, -x+1/2, x+1/2)', '(x+1/2, -x+1/2, -x+1/2)',
                         '(-x+1/2, x+1/2, -x+1/2)'), 'hkl: h+k+l=2n'),
              '12f': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(0, x, 0)',
                          '(0, -x, 0)', '(0, 0, x)', '(0, 0, -x)',
                          '(1/2, x+1/2, 1/2)', '(1/2, -x+1/2, 1/2)',
                          '(x+1/2, 1/2, 1/2)', '(-x+1/2, 1/2, 1/2)',
                          '(1/2, 1/2, x+1/2)', '(1/2, 1/2, -x+1/2)'),
                      'hkl: h+k+l=2n'),
              '12g': (1, ('(x, 1/2, 0)', '(-x, 1/2, 0)', '(0, x, 1/2)',
                          '(0, -x, 1/2)', '(1/2, 0, x)', '(1/2, 0, -x)',
                          '(0, x+1/2, 1/2)', '(0, -x+1/2, 1/2)',
                          '(x+1/2, 1/2, 0)', '(-x+1/2, 1/2, 0)',
                          '(1/2, 0, x+1/2)', '(1/2, 0, -x+1/2)'), 'hkl: h=2n'
                      ),
              '12h': (1, ('(x, 0, 1/2)', '(-x, 0, 1/2)', '(1/2, x, 0)',
                          '(1/2, -x, 0)', '(0, 1/2, x)', '(0, 1/2, -x)',
                          '(1/2, x+1/2, 0)', '(1/2, -x+1/2, 0)',
                          '(x+1/2, 0, 1/2)', '(-x+1/2, 0, 1/2)',
                          '(0, 1/2, x+1/2)', '(0, 1/2, -x+1/2)'), 'hkl: h=2n'
                      ),
              '24i': (7, ('(x, y, z)', '(-x, -y, z)', '(-x, y, -z)',
                          '(x, -y, -z)', '(z, x, y)', '(z, -x, -y)',
                          '(-z, -x, y)', '(-z, x, -y)', '(y, z, x)',
                          '(-y, z, -x)', '(y, -z, -x)', '(-y, -z, x)',
                          '(y+1/2, x+1/2, z+1/2)', '(-y+1/2, -x+1/2, z+1/2)',
                          '(y+1/2, -x+1/2, -z+1/2)',
                          '(-y+1/2, x+1/2, -z+1/2)', '(x+1/2, z+1/2, y+1/2)',
                          '(-x+1/2, z+1/2, -y+1/2)',
                          '(-x+1/2, -z+1/2, y+1/2)',
                          '(x+1/2, -z+1/2, -y+1/2)', '(z+1/2, y+1/2, x+1/2)',
                          '(z+1/2, -y+1/2, -x+1/2)',
                          '(-z+1/2, y+1/2, -x+1/2)',
                          '(-z+1/2, -y+1/2, x+1/2)'), 'hhl: l=2n, h00: h=2n'
                      )},
      '219': {'8a': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                         '(1/2, 1/2, 0)', '(1/2, 1/2, 1/2)', '(1/2, 0, 0)',
                         '(0, 1/2, 0)', '(0, 0, 1/2)'), 'hkl: h=2n'),
              '8b': (0, ('(1/4, 1/4, 1/4)', '(1/4, 3/4, 3/4)',
                         '(3/4, 1/4, 3/4)', '(3/4, 3/4, 1/4)',
                         '(3/4, 3/4, 3/4)', '(3/4, 1/4, 1/4)',
                         '(1/4, 3/4, 1/4)', '(1/4, 1/4, 3/4)'), 'hkl: h=2n'),
              '24c': (0, ('(0, 1/4, 1/4)', '(0, 3/4, 3/4)', '(1/2, 1/4, 3/4)',
                          '(1/2, 3/4, 1/4)', '(0, 3/4, 1/4)', '(0, 1/4, 3/4)',
                          '(1/2, 3/4, 3/4)', '(1/2, 1/4, 1/4)',
                          '(1/4, 0, 1/4)', '(1/4, 1/2, 3/4)', '(3/4, 0, 3/4)',
                          '(3/4, 1/2, 1/4)', '(1/4, 0, 3/4)',
                          '(1/4, 1/2, 1/4)', '(3/4, 0, 1/4)',
                          '(3/4, 1/2, 3/4)', '(1/4, 1/4, 0)',
                          '(1/4, 3/4, 1/2)', '(3/4, 1/4, 1/2)',
                          '(3/4, 3/4, 0)', '(3/4, 1/4, 0)', '(3/4, 3/4, 1/2)',
                          '(1/4, 1/4, 1/2)', '(1/4, 3/4, 0)'), 'hkl: h=2n'),
              '24d': (0, ('(1/4, 0, 0)', '(1/4, 1/2, 1/2)', '(3/4, 0, 1/2)',
                          '(3/4, 1/2, 0)', '(3/4, 0, 0)', '(3/4, 1/2, 1/2)',
                          '(1/4, 0, 1/2)', '(1/4, 1/2, 0)', '(0, 1/4, 0)',
                          '(0, 3/4, 1/2)', '(1/2, 1/4, 1/2)', '(1/2, 3/4, 0)',
                          '(0, 3/4, 0)', '(0, 1/4, 1/2)', '(1/2, 3/4, 1/2)',
                          '(1/2, 1/4, 0)', '(0, 0, 1/4)', '(0, 1/2, 3/4)',
                          '(1/2, 0, 3/4)', '(1/2, 1/2, 1/4)', '(0, 0, 3/4)',
                          '(0, 1/2, 1/4)', '(1/2, 0, 1/4)', '(1/2, 1/2, 3/4)'
                          ), 'hkl: h=2n'),
              '32e': (1, ('(x, x, x)', '(x, x+1/2, x+1/2)',
                          '(x+1/2, x, x+1/2)', '(x+1/2, x+1/2, x)',
                          '(-x, -x, x)', '(-x, -x+1/2, x+1/2)',
                          '(-x+1/2, -x, x+1/2)', '(-x+1/2, -x+1/2, x)',
                          '(-x, x, -x)', '(-x, x+1/2, -x+1/2)',
                          '(-x+1/2, x, -x+1/2)', '(-x+1/2, x+1/2, -x)',
                          '(x, -x, -x)', '(x, -x+1/2, -x+1/2)',
                          '(x+1/2, -x, -x+1/2)', '(x+1/2, -x+1/2, -x)',
                          '(x+1/2, x+1/2, x+1/2)', '(x+1/2, x, x)',
                          '(x, x+1/2, x)', '(x, x, x+1/2)',
                          '(-x+1/2, -x+1/2, x+1/2)', '(-x+1/2, -x, x)',
                          '(-x, -x+1/2, x)', '(-x, -x, x+1/2)',
                          '(x+1/2, -x+1/2, -x+1/2)', '(x+1/2, -x, -x)',
                          '(x, -x+1/2, -x)', '(x, -x, -x+1/2)',
                          '(-x+1/2, x+1/2, -x+1/2)', '(-x+1/2, x, -x)',
                          '(-x, x+1/2, -x)', '(-x, x, -x+1/2)'), 'hkl: h=2n'),
              '48f': (1, ('(x, 0, 0)', '(x, 1/2, 1/2)', '(x+1/2, 0, 1/2)',
                          '(x+1/2, 1/2, 0)', '(-x, 0, 0)', '(-x, 1/2, 1/2)',
                          '(-x+1/2, 0, 1/2)', '(-x+1/2, 1/2, 0)', '(0, x, 0)',
                          '(0, x+1/2, 1/2)', '(1/2, x, 1/2)',
                          '(1/2, x+1/2, 0)', '(0, -x, 0)', '(0, -x+1/2, 1/2)',
                          '(1/2, -x, 1/2)', '(1/2, -x+1/2, 0)', '(0, 0, x)',
                          '(0, 1/2, x+1/2)', '(1/2, 0, x+1/2)',
                          '(1/2, 1/2, x)', '(0, 0, -x)', '(0, 1/2, -x+1/2)',
                          '(1/2, 0, -x+1/2)', '(1/2, 1/2, -x)',
                          '(1/2, x+1/2, 1/2)', '(1/2, x, 0)', '(0, x+1/2, 0)',
                          '(0, x, 1/2)', '(1/2, -x+1/2, 1/2)', '(1/2, -x, 0)',
                          '(0, -x+1/2, 0)', '(0, -x, 1/2)',
                          '(x+1/2, 1/2, 1/2)', '(x+1/2, 0, 0)', '(x, 1/2, 0)',
                          '(x, 0, 1/2)', '(-x+1/2, 1/2, 1/2)',
                          '(-x+1/2, 0, 0)', '(-x, 1/2, 0)', '(-x, 0, 1/2)',
                          '(1/2, 1/2, x+1/2)', '(1/2, 0, x)', '(0, 1/2, x)',
                          '(0, 0, x+1/2)', '(1/2, 1/2, -x+1/2)',
                          '(1/2, 0, -x)', '(0, 1/2, -x)', '(0, 0, -x+1/2)'),
                      'hkl: h=2n'),
              '48g': (1, ('(x, 1/4, 1/4)', '(x, 3/4, 3/4)',
                          '(x+1/2, 1/4, 3/4)', '(x+1/2, 3/4, 1/4)',
                          '(-x, 3/4, 1/4)', '(-x, 1/4, 3/4)',
                          '(-x+1/2, 3/4, 3/4)', '(-x+1/2, 1/4, 1/4)',
                          '(1/4, x, 1/4)', '(1/4, x+1/2, 3/4)',
                          '(3/4, x, 3/4)', '(3/4, x+1/2, 1/4)',
                          '(1/4, -x, 3/4)', '(1/4, -x+1/2, 1/4)',
                          '(3/4, -x, 1/4)', '(3/4, -x+1/2, 3/4)',
                          '(1/4, 1/4, x)', '(1/4, 3/4, x+1/2)',
                          '(3/4, 1/4, x+1/2)', '(3/4, 3/4, x)',
                          '(3/4, 1/4, -x)', '(3/4, 3/4, -x+1/2)',
                          '(1/4, 1/4, -x+1/2)', '(1/4, 3/4, -x)',
                          '(3/4, x+1/2, 3/4)', '(3/4, x, 1/4)',
                          '(1/4, x+1/2, 1/4)', '(1/4, x, 3/4)',
                          '(1/4, -x+1/2, 3/4)', '(1/4, -x, 1/4)',
                          '(3/4, -x+1/2, 1/4)', '(3/4, -x, 3/4)',
                          '(x+1/2, 3/4, 3/4)', '(x+1/2, 1/4, 1/4)',
                          '(x, 3/4, 1/4)', '(x, 1/4, 3/4)',
                          '(-x+1/2, 3/4, 1/4)', '(-x+1/2, 1/4, 3/4)',
                          '(-x, 3/4, 3/4)', '(-x, 1/4, 1/4)',
                          '(3/4, 3/4, x+1/2)', '(3/4, 1/4, x)',
                          '(1/4, 3/4, x)', '(1/4, 1/4, x+1/2)',
                          '(3/4, 1/4, -x+1/2)', '(3/4, 3/4, -x)',
                          '(1/4, 1/4, -x)', '(1/4, 3/4, -x+1/2)'), 'hkl: h=2n'
                      ),
              '96h': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)',
                          '(x+1/2, y, z+1/2)', '(x+1/2, y+1/2, z)',
                          '(-x, -y, z)', '(-x, -y+1/2, z+1/2)',
                          '(-x+1/2, -y, z+1/2)', '(-x+1/2, -y+1/2, z)',
                          '(-x, y, -z)', '(-x, y+1/2, -z+1/2)',
                          '(-x+1/2, y, -z+1/2)', '(-x+1/2, y+1/2, -z)',
                          '(x, -y, -z)', '(x, -y+1/2, -z+1/2)',
                          '(x+1/2, -y, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                          '(z, x, y)', '(z, x+1/2, y+1/2)',
                          '(z+1/2, x, y+1/2)', '(z+1/2, x+1/2, y)',
                          '(z, -x, -y)', '(z, -x+1/2, -y+1/2)',
                          '(z+1/2, -x, -y+1/2)', '(z+1/2, -x+1/2, -y)',
                          '(-z, -x, y)', '(-z, -x+1/2, y+1/2)',
                          '(-z+1/2, -x, y+1/2)', '(-z+1/2, -x+1/2, y)',
                          '(-z, x, -y)', '(-z, x+1/2, -y+1/2)',
                          '(-z+1/2, x, -y+1/2)', '(-z+1/2, x+1/2, -y)',
                          '(y, z, x)', '(y, z+1/2, x+1/2)',
                          '(y+1/2, z, x+1/2)', '(y+1/2, z+1/2, x)',
                          '(-y, z, -x)', '(-y, z+1/2, -x+1/2)',
                          '(-y+1/2, z, -x+1/2)', '(-y+1/2, z+1/2, -x)',
                          '(y, -z, -x)', '(y, -z+1/2, -x+1/2)',
                          '(y+1/2, -z, -x+1/2)', '(y+1/2, -z+1/2, -x)',
                          '(-y, -z, x)', '(-y, -z+1/2, x+1/2)',
                          '(-y+1/2, -z, x+1/2)', '(-y+1/2, -z+1/2, x)',
                          '(y+1/2, x+1/2, z+1/2)', '(y+1/2, x, z)',
                          '(y, x+1/2, z)', '(y, x, z+1/2)',
                          '(-y+1/2, -x+1/2, z+1/2)', '(-y+1/2, -x, z)',
                          '(-y, -x+1/2, z)', '(-y, -x, z+1/2)',
                          '(y+1/2, -x+1/2, -z+1/2)', '(y+1/2, -x, -z)',
                          '(y, -x+1/2, -z)', '(y, -x, -z+1/2)',
                          '(-y+1/2, x+1/2, -z+1/2)', '(-y+1/2, x, -z)',
                          '(-y, x+1/2, -z)', '(-y, x, -z+1/2)',
                          '(x+1/2, z+1/2, y+1/2)', '(x+1/2, z, y)',
                          '(x, z+1/2, y)', '(x, z, y+1/2)',
                          '(-x+1/2, z+1/2, -y+1/2)', '(-x+1/2, z, -y)',
                          '(-x, z+1/2, -y)', '(-x, z, -y+1/2)',
                          '(-x+1/2, -z+1/2, y+1/2)', '(-x+1/2, -z, y)',
                          '(-x, -z+1/2, y)', '(-x, -z, y+1/2)',
                          '(x+1/2, -z+1/2, -y+1/2)', '(x+1/2, -z, -y)',
                          '(x, -z+1/2, -y)', '(x, -z, -y+1/2)',
                          '(z+1/2, y+1/2, x+1/2)', '(z+1/2, y, x)',
                          '(z, y+1/2, x)', '(z, y, x+1/2)',
                          '(z+1/2, -y+1/2, -x+1/2)', '(z+1/2, -y, -x)',
                          '(z, -y+1/2, -x)', '(z, -y, -x+1/2)',
                          '(-z+1/2, y+1/2, -x+1/2)', '(-z+1/2, y, -x)',
                          '(-z, y+1/2, -x)', '(-z, y, -x+1/2)',
                          '(-z+1/2, -y+1/2, x+1/2)', '(-z+1/2, -y, x)',
                          '(-z, -y+1/2, x)', '(-z, -y, x+1/2)'),
                      'hkl: h+k=2n, h+l,k+l=2n, 0kl: k,l=2n, hhl: h,l=2n, '
                      'h00: h=2n')},
      '220': {'12a': (0, ('(3/8, 0, 1/4)', '(7/8, 1/2, 3/4)', '(1/8, 0, 3/4)',
                          '(5/8, 1/2, 1/4)', '(1/4, 3/8, 0)',
                          '(3/4, 7/8, 1/2)', '(3/4, 1/8, 0)',
                          '(1/4, 5/8, 1/2)', '(0, 1/4, 3/8)',
                          '(1/2, 3/4, 7/8)', '(0, 3/4, 1/8)',
                          '(1/2, 1/4, 5/8)'),
                      'hkl: h,k=2n, h+k+l=4n or h,k=2n+1, '
                      'l=4n+2 or h=8n, k=8n+4, h+k+l=4n+2 or h=8n+1, '
                      'k=8n+3, l=4n or h=8n+1, k=8n+5, l=4n or h=8n+7, '
                      'k=8n+3, l=4n or h=8n+7, k=8n+5, l=4n'),
              '12b': (0, ('(7/8, 0, 1/4)', '(3/8, 1/2, 3/4)', '(5/8, 0, 3/4)',
                          '(1/8, 1/2, 1/4)', '(1/4, 7/8, 0)',
                          '(3/4, 3/8, 1/2)', '(3/4, 5/8, 0)',
                          '(1/4, 1/8, 1/2)', '(0, 1/4, 7/8)',
                          '(1/2, 3/4, 3/8)', '(0, 3/4, 5/8)',
                          '(1/2, 1/4, 1/8)'),
                      'hkl: h,k=2n, h+k+l=4n or h,k=2n+1, '
                      'l=4n+2 or h=8n, k=8n+4, h+k+l=4n+2 or h=8n+1, '
                      'k=8n+3, l=4n or h=8n+1, k=8n+5, l=4n or h=8n+7, '
                      'k=8n+3, l=4n or h=8n+7, k=8n+5, l=4n'),
              '16c': (1, ('(x, x, x)', '(x+1/2, x+1/2, x+1/2)',
                          '(-x+1/2, -x, x+1/2)', '(-x, -x+1/2, x)',
                          '(-x, x+1/2, -x+1/2)', '(-x+1/2, x, -x)',
                          '(x+1/2, -x+1/2, -x)', '(x, -x, -x+1/2)',
                          '(x+1/4, x+1/4, x+1/4)', '(x+3/4, x+3/4, x+3/4)',
                          '(-x+1/4, -x+3/4, x+3/4)',
                          '(-x+3/4, -x+1/4, x+1/4)',
                          '(x+3/4, -x+1/4, -x+3/4)',
                          '(x+1/4, -x+3/4, -x+1/4)',
                          '(-x+3/4, x+3/4, -x+1/4)',
                          '(-x+1/4, x+1/4, -x+3/4)'), 'hkl: h=2n+1 or h+k+l=4n'
                      ),
              '24d': (1, ('(x, 0, 1/4)', '(x+1/2, 1/2, 3/4)',
                          '(-x+1/2, 0, 3/4)', '(-x, 1/2, 1/4)', '(1/4, x, 0)',
                          '(3/4, x+1/2, 1/2)', '(3/4, -x+1/2, 0)',
                          '(1/4, -x, 1/2)', '(0, 1/4, x)',
                          '(1/2, 3/4, x+1/2)', '(0, 3/4, -x+1/2)',
                          '(1/2, 1/4, -x)', '(1/4, x+1/4, 1/2)',
                          '(3/4, x+3/4, 0)', '(1/4, -x+3/4, 0)',
                          '(3/4, -x+1/4, 1/2)', '(x+1/4, 1/2, 1/4)',
                          '(x+3/4, 0, 3/4)', '(-x+3/4, 0, 1/4)',
                          '(-x+1/4, 1/2, 3/4)', '(1/2, 1/4, x+1/4)',
                          '(0, 3/4, x+3/4)', '(0, 1/4, -x+3/4)',
                          '(1/2, 3/4, -x+1/4)'), 'hkl: h=2n+1 or h=4n'),
              '48e': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)',
                          '(-x+1/2, -y, z+1/2)', '(-x, -y+1/2, z)',
                          '(-x, y+1/2, -z+1/2)', '(-x+1/2, y, -z)',
                          '(x+1/2, -y+1/2, -z)', '(x, -y, -z+1/2)',
                          '(z, x, y)', '(z+1/2, x+1/2, y+1/2)',
                          '(z+1/2, -x+1/2, -y)', '(z, -x, -y+1/2)',
                          '(-z+1/2, -x, y+1/2)', '(-z, -x+1/2, y)',
                          '(-z, x+1/2, -y+1/2)', '(-z+1/2, x, -y)',
                          '(y, z, x)', '(y+1/2, z+1/2, x+1/2)',
                          '(-y, z+1/2, -x+1/2)', '(-y+1/2, z, -x)',
                          '(y+1/2, -z+1/2, -x)', '(y, -z, -x+1/2)',
                          '(-y+1/2, -z, x+1/2)', '(-y, -z+1/2, x)',
                          '(y+1/4, x+1/4, z+1/4)', '(y+3/4, x+3/4, z+3/4)',
                          '(-y+1/4, -x+3/4, z+3/4)',
                          '(-y+3/4, -x+1/4, z+1/4)',
                          '(y+3/4, -x+1/4, -z+3/4)',
                          '(y+1/4, -x+3/4, -z+1/4)',
                          '(-y+3/4, x+3/4, -z+1/4)',
                          '(-y+1/4, x+1/4, -z+3/4)', '(x+1/4, z+1/4, y+1/4)',
                          '(x+3/4, z+3/4, y+3/4)', '(-x+3/4, z+3/4, -y+1/4)',
                          '(-x+1/4, z+1/4, -y+3/4)',
                          '(-x+1/4, -z+3/4, y+3/4)',
                          '(-x+3/4, -z+1/4, y+1/4)',
                          '(x+3/4, -z+1/4, -y+3/4)',
                          '(x+1/4, -z+3/4, -y+1/4)', '(z+1/4, y+1/4, x+1/4)',
                          '(z+3/4, y+3/4, x+3/4)', '(z+3/4, -y+1/4, -x+3/4)',
                          '(z+1/4, -y+3/4, -x+1/4)',
                          '(-z+3/4, y+3/4, -x+1/4)',
                          '(-z+1/4, y+1/4, -x+3/4)',
                          '(-z+1/4, -y+3/4, x+3/4)',
                          '(-z+3/4, -y+1/4, x+1/4)'),
                      'hkl: h+k+l=2n, 0kl: k+l=2n, hhl: 2h+l=4n, h00: h=4n')},
      '221': {'1a': (0, ('(0, 0, 0)', ), None),
              '1b': (0, ('(1/2, 1/2, 1/2)', ), None),
              '3c': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)', '(1/2, 1/2, 0)'),
                     None),
              '3d': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(0, 0, 1/2)'), None),
              '6e': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(0, x, 0)', '(0, -x, 0)',
                         '(0, 0, x)', '(0, 0, -x)'), None),
              '6f': (1, ('(x, 1/2, 1/2)', '(-x, 1/2, 1/2)', '(1/2, x, 1/2)',
                         '(1/2, -x, 1/2)', '(1/2, 1/2, x)', '(1/2, 1/2, -x)'),
                     None),
              '8g': (1, ('(x, x, x)', '(-x, -x, x)', '(-x, x, -x)',
                         '(x, -x, -x)', '(x, x, -x)', '(-x, -x, -x)',
                         '(x, -x, x)', '(-x, x, x)'), None),
              '12h': (1, ('(x, 1/2, 0)', '(-x, 1/2, 0)', '(0, x, 1/2)',
                          '(0, -x, 1/2)', '(1/2, 0, x)', '(1/2, 0, -x)',
                          '(1/2, x, 0)', '(1/2, -x, 0)', '(x, 0, 1/2)',
                          '(-x, 0, 1/2)', '(0, 1/2, -x)', '(0, 1/2, x)'), None
                      ),
              '12i': (2, ('(0, y, y)', '(0, -y, y)', '(0, y, -y)',
                          '(0, -y, -y)', '(y, 0, y)', '(y, 0, -y)',
                          '(-y, 0, y)', '(-y, 0, -y)', '(y, y, 0)',
                          '(-y, y, 0)', '(y, -y, 0)', '(-y, -y, 0)'), None),
              '12j': (2, ('(1/2, y, y)', '(1/2, -y, y)', '(1/2, y, -y)',
                          '(1/2, -y, -y)', '(y, 1/2, y)', '(y, 1/2, -y)',
                          '(-y, 1/2, y)', '(-y, 1/2, -y)', '(y, y, 1/2)',
                          '(-y, y, 1/2)', '(y, -y, 1/2)', '(-y, -y, 1/2)'),
                      None),
              '24k': (6, ('(0, y, z)', '(0, -y, z)', '(0, y, -z)',
                          '(0, -y, -z)', '(z, 0, y)', '(z, 0, -y)',
                          '(-z, 0, y)', '(-z, 0, -y)', '(y, z, 0)',
                          '(-y, z, 0)', '(y, -z, 0)', '(-y, -z, 0)',
                          '(y, 0, -z)', '(-y, 0, -z)', '(y, 0, z)',
                          '(-y, 0, z)', '(0, z, -y)', '(0, z, y)',
                          '(0, -z, -y)', '(0, -z, y)', '(z, y, 0)',
                          '(z, -y, 0)', '(-z, y, 0)', '(-z, -y, 0)'), None),
              '24l': (6, ('(1/2, y, z)', '(1/2, -y, z)', '(1/2, y, -z)',
                          '(1/2, -y, -z)', '(z, 1/2, y)', '(z, 1/2, -y)',
                          '(-z, 1/2, y)', '(-z, 1/2, -y)', '(y, z, 1/2)',
                          '(-y, z, 1/2)', '(y, -z, 1/2)', '(-y, -z, 1/2)',
                          '(y, 1/2, -z)', '(-y, 1/2, -z)', '(y, 1/2, z)',
                          '(-y, 1/2, z)', '(1/2, z, -y)', '(1/2, z, y)',
                          '(1/2, -z, -y)', '(1/2, -z, y)', '(z, y, 1/2)',
                          '(z, -y, 1/2)', '(-z, y, 1/2)', '(-z, -y, 1/2)'),
                      None),
              '24m': (5, ('(x, x, z)', '(-x, -x, z)', '(-x, x, -z)',
                          '(x, -x, -z)', '(z, x, x)', '(z, -x, -x)',
                          '(-z, -x, x)', '(-z, x, -x)', '(x, z, x)',
                          '(-x, z, -x)', '(x, -z, -x)', '(-x, -z, x)',
                          '(x, x, -z)', '(-x, -x, -z)', '(x, -x, z)',
                          '(-x, x, z)', '(x, z, -x)', '(-x, z, x)',
                          '(-x, -z, -x)', '(x, -z, x)', '(z, x, -x)',
                          '(z, -x, x)', '(-z, x, x)', '(-z, -x, -x)'), None),
              '48n': (7, ('(x, y, z)', '(-x, -y, z)', '(-x, y, -z)',
                          '(x, -y, -z)', '(z, x, y)', '(z, -x, -y)',
                          '(-z, -x, y)', '(-z, x, -y)', '(y, z, x)',
                          '(-y, z, -x)', '(y, -z, -x)', '(-y, -z, x)',
                          '(y, x, -z)', '(-y, -x, -z)', '(y, -x, z)',
                          '(-y, x, z)', '(x, z, -y)', '(-x, z, y)',
                          '(-x, -z, -y)', '(x, -z, y)', '(z, y, -x)',
                          '(z, -y, x)', '(-z, y, x)', '(-z, -y, -x)',
                          '(-x, -y, -z)', '(x, y, -z)', '(x, -y, z)',
                          '(-x, y, z)', '(-z, -x, -y)', '(-z, x, y)',
                          '(z, x, -y)', '(z, -x, y)', '(-y, -z, -x)',
                          '(y, -z, x)', '(-y, z, x)', '(y, z, -x)',
                          '(-y, -x, z)', '(y, x, z)', '(-y, x, -z)',
                          '(y, -x, -z)', '(-x, -z, y)', '(x, -z, -y)',
                          '(x, z, y)', '(-x, z, -y)', '(-z, -y, x)',
                          '(-z, y, -x)', '(z, -y, -x)', '(z, y, x)'), None)},
      '222:1': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)'), 'hkl: h+k+l=2n'),
                '6b': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)', '(1/2, 1/2, 0)',
                           '(1/2, 0, 0)', '(0, 1/2, 0)', '(0, 0, 1/2)'),
                       'hkl: h+k+l=2n'),
                '8c': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 1/4)',
                           '(3/4, 1/4, 3/4)', '(1/4, 3/4, 3/4)',
                           '(1/4, 1/4, 3/4)', '(3/4, 3/4, 3/4)',
                           '(1/4, 3/4, 1/4)', '(3/4, 1/4, 1/4)'),
                       'hkl: h,k,l=2n'),
                '12d': (0, ('(1/4, 0, 1/2)', '(3/4, 0, 1/2)', '(1/2, 1/4, 0)',
                            '(1/2, 3/4, 0)', '(0, 1/2, 1/4)', '(0, 1/2, 3/4)',
                            '(0, 1/4, 1/2)', '(0, 3/4, 1/2)', '(1/4, 1/2, 0)',
                            '(3/4, 1/2, 0)', '(1/2, 0, 3/4)', '(1/2, 0, 1/4)'
                            ), 'hkl: h+k+l=2n'),
                '12e': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(0, x, 0)',
                            '(0, -x, 0)', '(0, 0, x)', '(0, 0, -x)',
                            '(-x+1/2, 1/2, 1/2)', '(x+1/2, 1/2, 1/2)',
                            '(1/2, -x+1/2, 1/2)', '(1/2, x+1/2, 1/2)',
                            '(1/2, 1/2, -x+1/2)', '(1/2, 1/2, x+1/2)'),
                        'hkl: h+k+l=2n'),
                '16f': (1, ('(x, x, x)', '(-x, -x, x)', '(-x, x, -x)',
                            '(x, -x, -x)', '(x, x, -x)', '(-x, -x, -x)',
                            '(x, -x, x)', '(-x, x, x)',
                            '(-x+1/2, -x+1/2, -x+1/2)',
                            '(x+1/2, x+1/2, -x+1/2)',
                            '(x+1/2, -x+1/2, x+1/2)',
                            '(-x+1/2, x+1/2, x+1/2)',
                            '(-x+1/2, -x+1/2, x+1/2)',
                            '(x+1/2, x+1/2, x+1/2)',
                            '(-x+1/2, x+1/2, -x+1/2)',
                            '(x+1/2, -x+1/2, -x+1/2)'), 'hkl: h+k+l=2n'),
                '24g': (1, ('(x, 0, 1/2)', '(-x, 0, 1/2)', '(1/2, x, 0)',
                            '(1/2, -x, 0)', '(0, 1/2, x)', '(0, 1/2, -x)',
                            '(0, x, 1/2)', '(0, -x, 1/2)', '(x, 1/2, 0)',
                            '(-x, 1/2, 0)', '(1/2, 0, -x)', '(1/2, 0, x)',
                            '(-x+1/2, 1/2, 0)', '(x+1/2, 1/2, 0)',
                            '(0, -x+1/2, 1/2)', '(0, x+1/2, 1/2)',
                            '(1/2, 0, -x+1/2)', '(1/2, 0, x+1/2)',
                            '(1/2, -x+1/2, 0)', '(1/2, x+1/2, 0)',
                            '(-x+1/2, 0, 1/2)', '(x+1/2, 0, 1/2)',
                            '(0, 1/2, x+1/2)', '(0, 1/2, -x+1/2)'),
                        'hkl: h+k+l=2n'),
                '24h': (2, ('(0, y, y)', '(0, -y, y)', '(0, y, -y)',
                            '(0, -y, -y)', '(y, 0, y)', '(y, 0, -y)',
                            '(-y, 0, y)', '(-y, 0, -y)', '(y, y, 0)',
                            '(-y, y, 0)', '(y, -y, 0)', '(-y, -y, 0)',
                            '(1/2, -y+1/2, -y+1/2)', '(1/2, y+1/2, -y+1/2)',
                            '(1/2, -y+1/2, y+1/2)', '(1/2, y+1/2, y+1/2)',
                            '(-y+1/2, 1/2, -y+1/2)', '(-y+1/2, 1/2, y+1/2)',
                            '(y+1/2, 1/2, -y+1/2)', '(y+1/2, 1/2, y+1/2)',
                            '(-y+1/2, -y+1/2, 1/2)', '(y+1/2, -y+1/2, 1/2)',
                            '(-y+1/2, y+1/2, 1/2)', '(y+1/2, y+1/2, 1/2)'),
                        'hkl: h+k+l=2n'),
                '48i': (7, ('(x, y, z)', '(-x, -y, z)', '(-x, y, -z)',
                            '(x, -y, -z)', '(z, x, y)', '(z, -x, -y)',
                            '(-z, -x, y)', '(-z, x, -y)', '(y, z, x)',
                            '(-y, z, -x)', '(y, -z, -x)', '(-y, -z, x)',
                            '(y, x, -z)', '(-y, -x, -z)', '(y, -x, z)',
                            '(-y, x, z)', '(x, z, -y)', '(-x, z, y)',
                            '(-x, -z, -y)', '(x, -z, y)', '(z, y, -x)',
                            '(z, -y, x)', '(-z, y, x)', '(-z, -y, -x)',
                            '(-x+1/2, -y+1/2, -z+1/2)',
                            '(x+1/2, y+1/2, -z+1/2)',
                            '(x+1/2, -y+1/2, z+1/2)',
                            '(-x+1/2, y+1/2, z+1/2)',
                            '(-z+1/2, -x+1/2, -y+1/2)',
                            '(-z+1/2, x+1/2, y+1/2)',
                            '(z+1/2, x+1/2, -y+1/2)',
                            '(z+1/2, -x+1/2, y+1/2)',
                            '(-y+1/2, -z+1/2, -x+1/2)',
                            '(y+1/2, -z+1/2, x+1/2)',
                            '(-y+1/2, z+1/2, x+1/2)',
                            '(y+1/2, z+1/2, -x+1/2)',
                            '(-y+1/2, -x+1/2, z+1/2)',
                            '(y+1/2, x+1/2, z+1/2)',
                            '(-y+1/2, x+1/2, -z+1/2)',
                            '(y+1/2, -x+1/2, -z+1/2)',
                            '(-x+1/2, -z+1/2, y+1/2)',
                            '(x+1/2, -z+1/2, -y+1/2)',
                            '(x+1/2, z+1/2, y+1/2)',
                            '(-x+1/2, z+1/2, -y+1/2)',
                            '(-z+1/2, -y+1/2, x+1/2)',
                            '(-z+1/2, y+1/2, -x+1/2)',
                            '(z+1/2, -y+1/2, -x+1/2)',
                            '(z+1/2, y+1/2, x+1/2)'),
                        '0kl: k+l=2n, hhl: l=2n, h00: h=2n')},
      '222:2': {'2a': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)'), 'n/a'),
                '6b': (0, ('(3/4, 1/4, 1/4)', '(1/4, 3/4, 1/4)',
                           '(1/4, 1/4, 3/4)', '(1/4, 3/4, 3/4)',
                           '(3/4, 1/4, 3/4)', '(3/4, 3/4, 1/4)'), 'n/a'),
                '8c': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(1/2, 0, 1/2)',
                           '(0, 1/2, 1/2)', '(0, 0, 1/2)', '(1/2, 1/2, 1/2)',
                           '(0, 1/2, 0)', '(1/2, 0, 0)'), 'n/a'),
                '12d': (0, ('(0, 3/4, 1/4)', '(1/2, 3/4, 1/4)',
                            '(1/4, 0, 3/4)', '(1/4, 1/2, 3/4)',
                            '(3/4, 1/4, 0)', '(3/4, 1/4, 1/2)',
                            '(3/4, 0, 1/4)', '(3/4, 1/2, 1/4)',
                            '(0, 1/4, 3/4)', '(1/2, 1/4, 3/4)',
                            '(1/4, 3/4, 1/2)', '(1/4, 3/4, 0)'), 'n/a'),
                '12e': (1, ('(x, 1/4, 1/4)', '(-x+1/2, 1/4, 1/4)',
                            '(1/4, x, 1/4)', '(1/4, -x+1/2, 1/4)',
                            '(1/4, 1/4, x)', '(1/4, 1/4, -x+1/2)',
                            '(-x, 3/4, 3/4)', '(x+1/2, 3/4, 3/4)',
                            '(3/4, -x, 3/4)', '(3/4, x+1/2, 3/4)',
                            '(3/4, 3/4, -x)', '(3/4, 3/4, x+1/2)'), 'n/a'),
                '16f': (1, ('(x, x, x)', '(-x+1/2, -x+1/2, x)',
                            '(-x+1/2, x, -x+1/2)', '(x, -x+1/2, -x+1/2)',
                            '(x, x, -x+1/2)', '(-x+1/2, -x+1/2, -x+1/2)',
                            '(x, -x+1/2, x)', '(-x+1/2, x, x)',
                            '(-x, -x, -x)', '(x+1/2, x+1/2, -x)',
                            '(x+1/2, -x, x+1/2)', '(-x, x+1/2, x+1/2)',
                            '(-x, -x, x+1/2)', '(x+1/2, x+1/2, x+1/2)',
                            '(-x, x+1/2, -x)', '(x+1/2, -x, -x)'), 'n/a'),
                '24g': (1, ('(x, 3/4, 1/4)', '(-x+1/2, 3/4, 1/4)',
                            '(1/4, x, 3/4)', '(1/4, -x+1/2, 3/4)',
                            '(3/4, 1/4, x)', '(3/4, 1/4, -x+1/2)',
                            '(3/4, x, 1/4)', '(3/4, -x+1/2, 1/4)',
                            '(x, 1/4, 3/4)', '(-x+1/2, 1/4, 3/4)',
                            '(1/4, 3/4, -x+1/2)', '(1/4, 3/4, x)',
                            '(-x, 1/4, 3/4)', '(x+1/2, 1/4, 3/4)',
                            '(3/4, -x, 1/4)', '(3/4, x+1/2, 1/4)',
                            '(1/4, 3/4, -x)', '(1/4, 3/4, x+1/2)',
                            '(1/4, -x, 3/4)', '(1/4, x+1/2, 3/4)',
                            '(-x, 3/4, 1/4)', '(x+1/2, 3/4, 1/4)',
                            '(3/4, 1/4, x+1/2)', '(3/4, 1/4, -x)'), 'n/a'),
                '24h': (2, ('(1/4, y, y)', '(1/4, -y+1/2, y)',
                            '(1/4, y, -y+1/2)', '(1/4, -y+1/2, -y+1/2)',
                            '(y, 1/4, y)', '(y, 1/4, -y+1/2)',
                            '(-y+1/2, 1/4, y)', '(-y+1/2, 1/4, -y+1/2)',
                            '(y, y, 1/4)', '(-y+1/2, y, 1/4)',
                            '(y, -y+1/2, 1/4)', '(-y+1/2, -y+1/2, 1/4)',
                            '(3/4, -y, -y)', '(3/4, y+1/2, -y)',
                            '(3/4, -y, y+1/2)', '(3/4, y+1/2, y+1/2)',
                            '(-y, 3/4, -y)', '(-y, 3/4, y+1/2)',
                            '(y+1/2, 3/4, -y)', '(y+1/2, 3/4, y+1/2)',
                            '(-y, -y, 3/4)', '(y+1/2, -y, 3/4)',
                            '(-y, y+1/2, 3/4)', '(y+1/2, y+1/2, 3/4)'), 'n/a'
                        ),
                '48i': (7, ('(x, y, z)', '(-x+1/2, -y+1/2, z)',
                            '(-x+1/2, y, -z+1/2)', '(x, -y+1/2, -z+1/2)',
                            '(z, x, y)', '(z, -x+1/2, -y+1/2)',
                            '(-z+1/2, -x+1/2, y)', '(-z+1/2, x, -y+1/2)',
                            '(y, z, x)', '(-y+1/2, z, -x+1/2)',
                            '(y, -z+1/2, -x+1/2)', '(-y+1/2, -z+1/2, x)',
                            '(y, x, -z+1/2)', '(-y+1/2, -x+1/2, -z+1/2)',
                            '(y, -x+1/2, z)', '(-y+1/2, x, z)',
                            '(x, z, -y+1/2)', '(-x+1/2, z, y)',
                            '(-x+1/2, -z+1/2, -y+1/2)', '(x, -z+1/2, y)',
                            '(z, y, -x+1/2)', '(z, -y+1/2, x)',
                            '(-z+1/2, y, x)', '(-z+1/2, -y+1/2, -x+1/2)',
                            '(-x, -y, -z)', '(x+1/2, y+1/2, -z)',
                            '(x+1/2, -y, z+1/2)', '(-x, y+1/2, z+1/2)',
                            '(-z, -x, -y)', '(-z, x+1/2, y+1/2)',
                            '(z+1/2, x+1/2, -y)', '(z+1/2, -x, y+1/2)',
                            '(-y, -z, -x)', '(y+1/2, -z, x+1/2)',
                            '(-y, z+1/2, x+1/2)', '(y+1/2, z+1/2, -x)',
                            '(-y, -x, z+1/2)', '(y+1/2, x+1/2, z+1/2)',
                            '(-y, x+1/2, -z)', '(y+1/2, -x, -z)',
                            '(-x, -z, y+1/2)', '(x+1/2, -z, -y)',
                            '(x+1/2, z+1/2, y+1/2)', '(-x, z+1/2, -y)',
                            '(-z, -y, x+1/2)', '(-z, y+1/2, -x)',
                            '(z+1/2, -y, -x)', '(z+1/2, y+1/2, x+1/2)'), 'n/a'
                        )},
      '223': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)'), 'hkl: h+k+l=2n'),
              '6b': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)', '(1/2, 1/2, 0)',
                         '(0, 1/2, 0)', '(1/2, 0, 0)', '(0, 0, 1/2)'),
                     'hkl: h+k+l=2n'),
              '6c': (0, ('(1/4, 0, 1/2)', '(3/4, 0, 1/2)', '(1/2, 1/4, 0)',
                         '(1/2, 3/4, 0)', '(0, 1/2, 1/4)', '(0, 1/2, 3/4)'),
                     'hkl: h+k+l=2n or h=2n+1, k=4n, l=4n+2'),
              '6d': (0, ('(1/4, 1/2, 0)', '(3/4, 1/2, 0)', '(0, 1/4, 1/2)',
                         '(0, 3/4, 1/2)', '(1/2, 0, 1/4)', '(1/2, 0, 3/4)'),
                     'hkl: h+k+l=2n or h=2n+1, k=4n, l=4n+2'),
              '8e': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 1/4)',
                         '(3/4, 1/4, 3/4)', '(1/4, 3/4, 3/4)',
                         '(3/4, 3/4, 3/4)', '(1/4, 1/4, 3/4)',
                         '(1/4, 3/4, 1/4)', '(3/4, 1/4, 1/4)'), 'hkl: h,k,l=2n'
                     ),
              '12f': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(0, x, 0)',
                          '(0, -x, 0)', '(0, 0, x)', '(0, 0, -x)',
                          '(1/2, x+1/2, 1/2)', '(1/2, -x+1/2, 1/2)',
                          '(x+1/2, 1/2, 1/2)', '(-x+1/2, 1/2, 1/2)',
                          '(1/2, 1/2, -x+1/2)', '(1/2, 1/2, x+1/2)'),
                      'hkl: h+k+l=2n'),
              '12g': (1, ('(x, 0, 1/2)', '(-x, 0, 1/2)', '(1/2, x, 0)',
                          '(1/2, -x, 0)', '(0, 1/2, x)', '(0, 1/2, -x)',
                          '(1/2, x+1/2, 0)', '(1/2, -x+1/2, 0)',
                          '(x+1/2, 0, 1/2)', '(-x+1/2, 0, 1/2)',
                          '(0, 1/2, -x+1/2)', '(0, 1/2, x+1/2)'), 'hkl: h=2n'
                      ),
              '12h': (1, ('(x, 1/2, 0)', '(-x, 1/2, 0)', '(0, x, 1/2)',
                          '(0, -x, 1/2)', '(1/2, 0, x)', '(1/2, 0, -x)',
                          '(0, x+1/2, 1/2)', '(0, -x+1/2, 1/2)',
                          '(x+1/2, 1/2, 0)', '(-x+1/2, 1/2, 0)',
                          '(1/2, 0, -x+1/2)', '(1/2, 0, x+1/2)'), 'hkl: h=2n'
                      ),
              '16i': (1, ('(x, x, x)', '(-x, -x, x)', '(-x, x, -x)',
                          '(x, -x, -x)', '(x+1/2, x+1/2, -x+1/2)',
                          '(-x+1/2, -x+1/2, -x+1/2)',
                          '(x+1/2, -x+1/2, x+1/2)', '(-x+1/2, x+1/2, x+1/2)',
                          '(-x, -x, -x)', '(x, x, -x)', '(x, -x, x)',
                          '(-x, x, x)', '(-x+1/2, -x+1/2, x+1/2)',
                          '(x+1/2, x+1/2, x+1/2)', '(-x+1/2, x+1/2, -x+1/2)',
                          '(x+1/2, -x+1/2, -x+1/2)'), 'hkl: h+k+l=2n'),
              '24j': (2, ('(1/4, y, y+1/2)', '(3/4, -y, y+1/2)',
                          '(3/4, y, -y+1/2)', '(1/4, -y, -y+1/2)',
                          '(y+1/2, 1/4, y)', '(y+1/2, 3/4, -y)',
                          '(-y+1/2, 3/4, y)', '(-y+1/2, 1/4, -y)',
                          '(y, y+1/2, 1/4)', '(-y, y+1/2, 3/4)',
                          '(y, -y+1/2, 3/4)', '(-y, -y+1/2, 1/4)',
                          '(3/4, -y, -y+1/2)', '(1/4, y, -y+1/2)',
                          '(1/4, -y, y+1/2)', '(3/4, y, y+1/2)',
                          '(-y+1/2, 3/4, -y)', '(-y+1/2, 1/4, y)',
                          '(y+1/2, 1/4, -y)', '(y+1/2, 3/4, y)',
                          '(-y, -y+1/2, 3/4)', '(y, -y+1/2, 1/4)',
                          '(-y, y+1/2, 1/4)', '(y, y+1/2, 3/4)'), 'hkl: h=2n'
                      ),
              '24k': (6, ('(0, y, z)', '(0, -y, z)', '(0, y, -z)',
                          '(0, -y, -z)', '(z, 0, y)', '(z, 0, -y)',
                          '(-z, 0, y)', '(-z, 0, -y)', '(y, z, 0)',
                          '(-y, z, 0)', '(y, -z, 0)', '(-y, -z, 0)',
                          '(y+1/2, 1/2, -z+1/2)', '(-y+1/2, 1/2, -z+1/2)',
                          '(y+1/2, 1/2, z+1/2)', '(-y+1/2, 1/2, z+1/2)',
                          '(1/2, z+1/2, -y+1/2)', '(1/2, z+1/2, y+1/2)',
                          '(1/2, -z+1/2, -y+1/2)', '(1/2, -z+1/2, y+1/2)',
                          '(z+1/2, y+1/2, 1/2)', '(z+1/2, -y+1/2, 1/2)',
                          '(-z+1/2, y+1/2, 1/2)', '(-z+1/2, -y+1/2, 1/2)'),
                      None),
              '48l': (7, ('(x, y, z)', '(-x, -y, z)', '(-x, y, -z)',
                          '(x, -y, -z)', '(z, x, y)', '(z, -x, -y)',
                          '(-z, -x, y)', '(-z, x, -y)', '(y, z, x)',
                          '(-y, z, -x)', '(y, -z, -x)', '(-y, -z, x)',
                          '(y+1/2, x+1/2, -z+1/2)',
                          '(-y+1/2, -x+1/2, -z+1/2)',
                          '(y+1/2, -x+1/2, z+1/2)', '(-y+1/2, x+1/2, z+1/2)',
                          '(x+1/2, z+1/2, -y+1/2)', '(-x+1/2, z+1/2, y+1/2)',
                          '(-x+1/2, -z+1/2, -y+1/2)',
                          '(x+1/2, -z+1/2, y+1/2)', '(z+1/2, y+1/2, -x+1/2)',
                          '(z+1/2, -y+1/2, x+1/2)', '(-z+1/2, y+1/2, x+1/2)',
                          '(-z+1/2, -y+1/2, -x+1/2)', '(-x, -y, -z)',
                          '(x, y, -z)', '(x, -y, z)', '(-x, y, z)',
                          '(-z, -x, -y)', '(-z, x, y)', '(z, x, -y)',
                          '(z, -x, y)', '(-y, -z, -x)', '(y, -z, x)',
                          '(-y, z, x)', '(y, z, -x)',
                          '(-y+1/2, -x+1/2, z+1/2)', '(y+1/2, x+1/2, z+1/2)',
                          '(-y+1/2, x+1/2, -z+1/2)',
                          '(y+1/2, -x+1/2, -z+1/2)',
                          '(-x+1/2, -z+1/2, y+1/2)',
                          '(x+1/2, -z+1/2, -y+1/2)', '(x+1/2, z+1/2, y+1/2)',
                          '(-x+1/2, z+1/2, -y+1/2)',
                          '(-z+1/2, -y+1/2, x+1/2)',
                          '(-z+1/2, y+1/2, -x+1/2)',
                          '(z+1/2, -y+1/2, -x+1/2)', '(z+1/2, y+1/2, x+1/2)'),
                      'hhl: l=2n, h00: h=2n')},
      '224:1': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)'), 'hkl: h+k+l=2n'),
                '4b': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 1/4)',
                           '(3/4, 1/4, 3/4)', '(1/4, 3/4, 3/4)'),
                       'hkl: h+k,h+l,k+l=2n'),
                '4c': (0, ('(3/4, 3/4, 3/4)', '(1/4, 1/4, 3/4)',
                           '(1/4, 3/4, 1/4)', '(3/4, 1/4, 1/4)'),
                       'hkl: h+k,h+l,k+l=2n'),
                '6d': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)', '(1/2, 1/2, 0)',
                           '(0, 1/2, 0)', '(1/2, 0, 0)', '(0, 0, 1/2)'),
                       'hkl: h+k+l=2n'),
                '8e': (1, ('(x, x, x)', '(-x, -x, x)', '(-x, x, -x)',
                           '(x, -x, -x)', '(x+1/2, x+1/2, -x+1/2)',
                           '(-x+1/2, -x+1/2, -x+1/2)',
                           '(x+1/2, -x+1/2, x+1/2)', '(-x+1/2, x+1/2, x+1/2)'
                           ), None),
                '12f': (0, ('(1/4, 0, 1/2)', '(3/4, 0, 1/2)', '(1/2, 1/4, 0)',
                            '(1/2, 3/4, 0)', '(0, 1/2, 1/4)', '(0, 1/2, 3/4)',
                            '(1/4, 1/2, 0)', '(3/4, 1/2, 0)', '(0, 1/4, 1/2)',
                            '(0, 3/4, 1/2)', '(1/2, 0, 1/4)', '(1/2, 0, 3/4)'
                            ), 'hkl: h+k+l=2n'),
                '12g': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(0, x, 0)',
                            '(0, -x, 0)', '(0, 0, x)', '(0, 0, -x)',
                            '(1/2, x+1/2, 1/2)', '(1/2, -x+1/2, 1/2)',
                            '(x+1/2, 1/2, 1/2)', '(-x+1/2, 1/2, 1/2)',
                            '(1/2, 1/2, -x+1/2)', '(1/2, 1/2, x+1/2)'),
                        'hkl: h+k+l=2n'),
                '24h': (1, ('(x, 0, 1/2)', '(-x, 0, 1/2)', '(1/2, x, 0)',
                            '(1/2, -x, 0)', '(0, 1/2, x)', '(0, 1/2, -x)',
                            '(1/2, x+1/2, 0)', '(1/2, -x+1/2, 0)',
                            '(x+1/2, 0, 1/2)', '(-x+1/2, 0, 1/2)',
                            '(0, 1/2, -x+1/2)', '(0, 1/2, x+1/2)',
                            '(-x+1/2, 1/2, 0)', '(x+1/2, 1/2, 0)',
                            '(0, -x+1/2, 1/2)', '(0, x+1/2, 1/2)',
                            '(1/2, 0, -x+1/2)', '(1/2, 0, x+1/2)',
                            '(0, -x, 1/2)', '(0, x, 1/2)', '(-x, 1/2, 0)',
                            '(x, 1/2, 0)', '(1/2, 0, x)', '(1/2, 0, -x)'),
                        'hkl: h+k+l=2n'),
                '24i': (2, ('(1/4, y, -y+1/2)', '(3/4, -y, -y+1/2)',
                            '(3/4, y, y+1/2)', '(1/4, -y, y+1/2)',
                            '(-y+1/2, 1/4, y)', '(-y+1/2, 3/4, -y)',
                            '(y+1/2, 3/4, y)', '(y+1/2, 1/4, -y)',
                            '(y, -y+1/2, 1/4)', '(-y, -y+1/2, 3/4)',
                            '(y, y+1/2, 3/4)', '(-y, y+1/2, 1/4)',
                            '(1/4, -y+1/2, y)', '(3/4, y+1/2, y)',
                            '(3/4, -y+1/2, -y)', '(1/4, y+1/2, -y)',
                            '(y, 1/4, -y+1/2)', '(y, 3/4, y+1/2)',
                            '(-y, 3/4, -y+1/2)', '(-y, 1/4, y+1/2)',
                            '(-y+1/2, y, 1/4)', '(y+1/2, y, 3/4)',
                            '(-y+1/2, -y, 3/4)', '(y+1/2, -y, 1/4)'), None),
                '24j': (2, ('(1/4, y, y+1/2)', '(3/4, -y, y+1/2)',
                            '(3/4, y, -y+1/2)', '(1/4, -y, -y+1/2)',
                            '(y+1/2, 1/4, y)', '(y+1/2, 3/4, -y)',
                            '(-y+1/2, 3/4, y)', '(-y+1/2, 1/4, -y)',
                            '(y, y+1/2, 1/4)', '(-y, y+1/2, 3/4)',
                            '(y, -y+1/2, 3/4)', '(-y, -y+1/2, 1/4)',
                            '(1/4, -y+1/2, -y)', '(3/4, y+1/2, -y)',
                            '(3/4, -y+1/2, y)', '(1/4, y+1/2, y)',
                            '(-y, 1/4, -y+1/2)', '(-y, 3/4, y+1/2)',
                            '(y, 3/4, -y+1/2)', '(y, 1/4, y+1/2)',
                            '(-y+1/2, -y, 1/4)', '(y+1/2, -y, 3/4)',
                            '(-y+1/2, y, 3/4)', '(y+1/2, y, 1/4)'), None),
                '24k': (5, ('(x, x, z)', '(-x, -x, z)', '(-x, x, -z)',
                            '(x, -x, -z)', '(z, x, x)', '(z, -x, -x)',
                            '(-z, -x, x)', '(-z, x, -x)', '(x, z, x)',
                            '(-x, z, -x)', '(x, -z, -x)', '(-x, -z, x)',
                            '(x+1/2, x+1/2, -z+1/2)',
                            '(-x+1/2, -x+1/2, -z+1/2)',
                            '(x+1/2, -x+1/2, z+1/2)',
                            '(-x+1/2, x+1/2, z+1/2)',
                            '(x+1/2, z+1/2, -x+1/2)',
                            '(-x+1/2, z+1/2, x+1/2)',
                            '(-x+1/2, -z+1/2, -x+1/2)',
                            '(x+1/2, -z+1/2, x+1/2)',
                            '(z+1/2, x+1/2, -x+1/2)',
                            '(z+1/2, -x+1/2, x+1/2)',
                            '(-z+1/2, x+1/2, x+1/2)',
                            '(-z+1/2, -x+1/2, -x+1/2)'), None),
                '48l': (7, ('(x, y, z)', '(-x, -y, z)', '(-x, y, -z)',
                            '(x, -y, -z)', '(z, x, y)', '(z, -x, -y)',
                            '(-z, -x, y)', '(-z, x, -y)', '(y, z, x)',
                            '(-y, z, -x)', '(y, -z, -x)', '(-y, -z, x)',
                            '(y+1/2, x+1/2, -z+1/2)',
                            '(-y+1/2, -x+1/2, -z+1/2)',
                            '(y+1/2, -x+1/2, z+1/2)',
                            '(-y+1/2, x+1/2, z+1/2)',
                            '(x+1/2, z+1/2, -y+1/2)',
                            '(-x+1/2, z+1/2, y+1/2)',
                            '(-x+1/2, -z+1/2, -y+1/2)',
                            '(x+1/2, -z+1/2, y+1/2)',
                            '(z+1/2, y+1/2, -x+1/2)',
                            '(z+1/2, -y+1/2, x+1/2)',
                            '(-z+1/2, y+1/2, x+1/2)',
                            '(-z+1/2, -y+1/2, -x+1/2)',
                            '(-x+1/2, -y+1/2, -z+1/2)',
                            '(x+1/2, y+1/2, -z+1/2)',
                            '(x+1/2, -y+1/2, z+1/2)',
                            '(-x+1/2, y+1/2, z+1/2)',
                            '(-z+1/2, -x+1/2, -y+1/2)',
                            '(-z+1/2, x+1/2, y+1/2)',
                            '(z+1/2, x+1/2, -y+1/2)',
                            '(z+1/2, -x+1/2, y+1/2)',
                            '(-y+1/2, -z+1/2, -x+1/2)',
                            '(y+1/2, -z+1/2, x+1/2)',
                            '(-y+1/2, z+1/2, x+1/2)',
                            '(y+1/2, z+1/2, -x+1/2)', '(-y, -x, z)',
                            '(y, x, z)', '(-y, x, -z)', '(y, -x, -z)',
                            '(-x, -z, y)', '(x, -z, -y)', '(x, z, y)',
                            '(-x, z, -y)', '(-z, -y, x)', '(-z, y, -x)',
                            '(z, -y, -x)', '(z, y, x)'),
                        '0kl: k+l=2n, h00: h=2n')},
      '224:2': {'2a': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)'), 'n/a'),
                '4b': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(1/2, 0, 1/2)',
                           '(0, 1/2, 1/2)'), 'n/a'),
                '4c': (0, ('(1/2, 1/2, 1/2)', '(0, 0, 1/2)', '(0, 1/2, 0)',
                           '(1/2, 0, 0)'), 'n/a'),
                '6d': (0, ('(1/4, 3/4, 3/4)', '(3/4, 1/4, 3/4)',
                           '(3/4, 3/4, 1/4)', '(1/4, 3/4, 1/4)',
                           '(3/4, 1/4, 1/4)', '(1/4, 1/4, 3/4)'), 'n/a'),
                '8e': (1, ('(x, x, x)', '(-x+1/2, -x+1/2, x)',
                           '(-x+1/2, x, -x+1/2)', '(x, -x+1/2, -x+1/2)',
                           '(x+1/2, x+1/2, -x)', '(-x, -x, -x)',
                           '(x+1/2, -x, x+1/2)', '(-x, x+1/2, x+1/2)'), 'n/a'
                       ),
                '12f': (0, ('(1/2, 1/4, 3/4)', '(0, 1/4, 3/4)',
                            '(3/4, 1/2, 1/4)', '(3/4, 0, 1/4)',
                            '(1/4, 3/4, 1/2)', '(1/4, 3/4, 0)',
                            '(1/2, 3/4, 1/4)', '(0, 3/4, 1/4)',
                            '(1/4, 1/2, 3/4)', '(1/4, 0, 3/4)',
                            '(3/4, 1/4, 1/2)', '(3/4, 1/4, 0)'), 'n/a'),
                '12g': (1, ('(x, 1/4, 1/4)', '(-x+1/2, 1/4, 1/4)',
                            '(1/4, x, 1/4)', '(1/4, -x+1/2, 1/4)',
                            '(1/4, 1/4, x)', '(1/4, 1/4, -x+1/2)',
                            '(3/4, x+1/2, 3/4)', '(3/4, -x, 3/4)',
                            '(x+1/2, 3/4, 3/4)', '(-x, 3/4, 3/4)',
                            '(3/4, 3/4, -x)', '(3/4, 3/4, x+1/2)'), 'n/a'),
                '24h': (1, ('(x, 1/4, 3/4)', '(-x+1/2, 1/4, 3/4)',
                            '(3/4, x, 1/4)', '(3/4, -x+1/2, 1/4)',
                            '(1/4, 3/4, x)', '(1/4, 3/4, -x+1/2)',
                            '(3/4, x+1/2, 1/4)', '(3/4, -x, 1/4)',
                            '(x+1/2, 1/4, 3/4)', '(-x, 1/4, 3/4)',
                            '(1/4, 3/4, -x)', '(1/4, 3/4, x+1/2)',
                            '(-x, 3/4, 1/4)', '(x+1/2, 3/4, 1/4)',
                            '(1/4, -x, 3/4)', '(1/4, x+1/2, 3/4)',
                            '(3/4, 1/4, -x)', '(3/4, 1/4, x+1/2)',
                            '(1/4, -x+1/2, 3/4)', '(1/4, x, 3/4)',
                            '(-x+1/2, 3/4, 1/4)', '(x, 3/4, 1/4)',
                            '(3/4, 1/4, x)', '(3/4, 1/4, -x+1/2)'), 'n/a'),
                '24i': (2, ('(1/2, y, y+1/2)', '(0, -y+1/2, y+1/2)',
                            '(0, y, -y)', '(1/2, -y+1/2, -y)',
                            '(y+1/2, 1/2, y)', '(y+1/2, 0, -y+1/2)',
                            '(-y, 0, y)', '(-y, 1/2, -y+1/2)',
                            '(y, y+1/2, 1/2)', '(-y+1/2, y+1/2, 0)',
                            '(y, -y, 0)', '(-y+1/2, -y, 1/2)',
                            '(1/2, -y, -y+1/2)', '(0, y+1/2, -y+1/2)',
                            '(0, -y, y)', '(1/2, y+1/2, y)',
                            '(-y+1/2, 1/2, -y)', '(-y+1/2, 0, y+1/2)',
                            '(y, 0, -y)', '(y, 1/2, y+1/2)',
                            '(-y, -y+1/2, 1/2)', '(y+1/2, -y+1/2, 0)',
                            '(-y, y, 0)', '(y+1/2, y, 1/2)'), 'n/a'),
                '24j': (2, ('(1/2, y, -y)', '(0, -y+1/2, -y)',
                            '(0, y, y+1/2)', '(1/2, -y+1/2, y+1/2)',
                            '(-y, 1/2, y)', '(-y, 0, -y+1/2)',
                            '(y+1/2, 0, y)', '(y+1/2, 1/2, -y+1/2)',
                            '(y, -y, 1/2)', '(-y+1/2, -y, 0)',
                            '(y, y+1/2, 0)', '(-y+1/2, y+1/2, 1/2)',
                            '(1/2, -y, y)', '(0, y+1/2, y)',
                            '(0, -y, -y+1/2)', '(1/2, y+1/2, -y+1/2)',
                            '(y, 1/2, -y)', '(y, 0, y+1/2)',
                            '(-y+1/2, 0, -y)', '(-y+1/2, 1/2, y+1/2)',
                            '(-y, y, 1/2)', '(y+1/2, y, 0)',
                            '(-y, -y+1/2, 0)', '(y+1/2, -y+1/2, 1/2)'), 'n/a'
                        ),
                '24k': (5, ('(x, x, z)', '(-x+1/2, -x+1/2, z)',
                            '(-x+1/2, x, -z+1/2)', '(x, -x+1/2, -z+1/2)',
                            '(z, x, x)', '(z, -x+1/2, -x+1/2)',
                            '(-z+1/2, -x+1/2, x)', '(-z+1/2, x, -x+1/2)',
                            '(x, z, x)', '(-x+1/2, z, -x+1/2)',
                            '(x, -z+1/2, -x+1/2)', '(-x+1/2, -z+1/2, x)',
                            '(x+1/2, x+1/2, -z)', '(-x, -x, -z)',
                            '(x+1/2, -x, z+1/2)', '(-x, x+1/2, z+1/2)',
                            '(x+1/2, z+1/2, -x)', '(-x, z+1/2, x+1/2)',
                            '(-x, -z, -x)', '(x+1/2, -z, x+1/2)',
                            '(z+1/2, x+1/2, -x)', '(z+1/2, -x, x+1/2)',
                            '(-z, x+1/2, x+1/2)', '(-z, -x, -x)'), 'n/a'),
                '48l': (7, ('(x, y, z)', '(-x+1/2, -y+1/2, z)',
                            '(-x+1/2, y, -z+1/2)', '(x, -y+1/2, -z+1/2)',
                            '(z, x, y)', '(z, -x+1/2, -y+1/2)',
                            '(-z+1/2, -x+1/2, y)', '(-z+1/2, x, -y+1/2)',
                            '(y, z, x)', '(-y+1/2, z, -x+1/2)',
                            '(y, -z+1/2, -x+1/2)', '(-y+1/2, -z+1/2, x)',
                            '(y+1/2, x+1/2, -z)', '(-y, -x, -z)',
                            '(y+1/2, -x, z+1/2)', '(-y, x+1/2, z+1/2)',
                            '(x+1/2, z+1/2, -y)', '(-x, z+1/2, y+1/2)',
                            '(-x, -z, -y)', '(x+1/2, -z, y+1/2)',
                            '(z+1/2, y+1/2, -x)', '(z+1/2, -y, x+1/2)',
                            '(-z, y+1/2, x+1/2)', '(-z, -y, -x)',
                            '(-x, -y, -z)', '(x+1/2, y+1/2, -z)',
                            '(x+1/2, -y, z+1/2)', '(-x, y+1/2, z+1/2)',
                            '(-z, -x, -y)', '(-z, x+1/2, y+1/2)',
                            '(z+1/2, x+1/2, -y)', '(z+1/2, -x, y+1/2)',
                            '(-y, -z, -x)', '(y+1/2, -z, x+1/2)',
                            '(-y, z+1/2, x+1/2)', '(y+1/2, z+1/2, -x)',
                            '(-y+1/2, -x+1/2, z)', '(y, x, z)',
                            '(-y+1/2, x, -z+1/2)', '(y, -x+1/2, -z+1/2)',
                            '(-x+1/2, -z+1/2, y)', '(x, -z+1/2, -y+1/2)',
                            '(x, z, y)', '(-x+1/2, z, -y+1/2)',
                            '(-z+1/2, -y+1/2, x)', '(-z+1/2, y, -x+1/2)',
                            '(z, -y+1/2, -x+1/2)', '(z, y, x)'), 'n/a')},
      '225': {'4a': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                         '(1/2, 1/2, 0)'), None),
              '4b': (0, ('(1/2, 1/2, 1/2)', '(1/2, 0, 0)', '(0, 1/2, 0)',
                         '(0, 0, 1/2)'), None),
              '8c': (0, ('(1/4, 1/4, 1/4)', '(1/4, 3/4, 3/4)',
                         '(3/4, 1/4, 3/4)', '(3/4, 3/4, 1/4)',
                         '(1/4, 1/4, 3/4)', '(1/4, 3/4, 1/4)',
                         '(3/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)'), 'hkl: h=2n'),
              '24d': (0, ('(0, 1/4, 1/4)', '(0, 3/4, 3/4)', '(1/2, 1/4, 3/4)',
                          '(1/2, 3/4, 1/4)', '(0, 3/4, 1/4)', '(0, 1/4, 3/4)',
                          '(1/2, 3/4, 3/4)', '(1/2, 1/4, 1/4)',
                          '(1/4, 0, 1/4)', '(1/4, 1/2, 3/4)', '(3/4, 0, 3/4)',
                          '(3/4, 1/2, 1/4)', '(1/4, 0, 3/4)',
                          '(1/4, 1/2, 1/4)', '(3/4, 0, 1/4)',
                          '(3/4, 1/2, 3/4)', '(1/4, 1/4, 0)',
                          '(1/4, 3/4, 1/2)', '(3/4, 1/4, 1/2)',
                          '(3/4, 3/4, 0)', '(3/4, 1/4, 0)', '(3/4, 3/4, 1/2)',
                          '(1/4, 1/4, 1/2)', '(1/4, 3/4, 0)'), 'hkl: h=2n'),
              '24e': (1, ('(x, 0, 0)', '(x, 1/2, 1/2)', '(x+1/2, 0, 1/2)',
                          '(x+1/2, 1/2, 0)', '(-x, 0, 0)', '(-x, 1/2, 1/2)',
                          '(-x+1/2, 0, 1/2)', '(-x+1/2, 1/2, 0)', '(0, x, 0)',
                          '(0, x+1/2, 1/2)', '(1/2, x, 1/2)',
                          '(1/2, x+1/2, 0)', '(0, -x, 0)', '(0, -x+1/2, 1/2)',
                          '(1/2, -x, 1/2)', '(1/2, -x+1/2, 0)', '(0, 0, x)',
                          '(0, 1/2, x+1/2)', '(1/2, 0, x+1/2)',
                          '(1/2, 1/2, x)', '(0, 0, -x)', '(0, 1/2, -x+1/2)',
                          '(1/2, 0, -x+1/2)', '(1/2, 1/2, -x)'), None),
              '32f': (1, ('(x, x, x)', '(x, x+1/2, x+1/2)',
                          '(x+1/2, x, x+1/2)', '(x+1/2, x+1/2, x)',
                          '(-x, -x, x)', '(-x, -x+1/2, x+1/2)',
                          '(-x+1/2, -x, x+1/2)', '(-x+1/2, -x+1/2, x)',
                          '(-x, x, -x)', '(-x, x+1/2, -x+1/2)',
                          '(-x+1/2, x, -x+1/2)', '(-x+1/2, x+1/2, -x)',
                          '(x, -x, -x)', '(x, -x+1/2, -x+1/2)',
                          '(x+1/2, -x, -x+1/2)', '(x+1/2, -x+1/2, -x)',
                          '(x, x, -x)', '(x, x+1/2, -x+1/2)',
                          '(x+1/2, x, -x+1/2)', '(x+1/2, x+1/2, -x)',
                          '(-x, -x, -x)', '(-x, -x+1/2, -x+1/2)',
                          '(-x+1/2, -x, -x+1/2)', '(-x+1/2, -x+1/2, -x)',
                          '(x, -x, x)', '(x, -x+1/2, x+1/2)',
                          '(x+1/2, -x, x+1/2)', '(x+1/2, -x+1/2, x)',
                          '(-x, x, x)', '(-x, x+1/2, x+1/2)',
                          '(-x+1/2, x, x+1/2)', '(-x+1/2, x+1/2, x)'), None),
              '48g': (1, ('(x, 1/4, 1/4)', '(x, 3/4, 3/4)',
                          '(x+1/2, 1/4, 3/4)', '(x+1/2, 3/4, 1/4)',
                          '(-x, 3/4, 1/4)', '(-x, 1/4, 3/4)',
                          '(-x+1/2, 3/4, 3/4)', '(-x+1/2, 1/4, 1/4)',
                          '(1/4, x, 1/4)', '(1/4, x+1/2, 3/4)',
                          '(3/4, x, 3/4)', '(3/4, x+1/2, 1/4)',
                          '(1/4, -x, 3/4)', '(1/4, -x+1/2, 1/4)',
                          '(3/4, -x, 1/4)', '(3/4, -x+1/2, 3/4)',
                          '(1/4, 1/4, x)', '(1/4, 3/4, x+1/2)',
                          '(3/4, 1/4, x+1/2)', '(3/4, 3/4, x)',
                          '(3/4, 1/4, -x)', '(3/4, 3/4, -x+1/2)',
                          '(1/4, 1/4, -x+1/2)', '(1/4, 3/4, -x)',
                          '(1/4, x, 3/4)', '(1/4, x+1/2, 1/4)',
                          '(3/4, x, 1/4)', '(3/4, x+1/2, 3/4)',
                          '(3/4, -x, 3/4)', '(3/4, -x+1/2, 1/4)',
                          '(1/4, -x, 1/4)', '(1/4, -x+1/2, 3/4)',
                          '(x, 1/4, 3/4)', '(x, 3/4, 1/4)',
                          '(x+1/2, 1/4, 1/4)', '(x+1/2, 3/4, 3/4)',
                          '(-x, 1/4, 1/4)', '(-x, 3/4, 3/4)',
                          '(-x+1/2, 1/4, 3/4)', '(-x+1/2, 3/4, 1/4)',
                          '(1/4, 1/4, -x)', '(1/4, 3/4, -x+1/2)',
                          '(3/4, 1/4, -x+1/2)', '(3/4, 3/4, -x)',
                          '(1/4, 3/4, x)', '(1/4, 1/4, x+1/2)',
                          '(3/4, 3/4, x+1/2)', '(3/4, 1/4, x)'), 'hkl: h=2n'),
              '48h': (2, ('(0, y, y)', '(0, y+1/2, y+1/2)', '(1/2, y, y+1/2)',
                          '(1/2, y+1/2, y)', '(0, -y, y)',
                          '(0, -y+1/2, y+1/2)', '(1/2, -y, y+1/2)',
                          '(1/2, -y+1/2, y)', '(0, y, -y)',
                          '(0, y+1/2, -y+1/2)', '(1/2, y, -y+1/2)',
                          '(1/2, y+1/2, -y)', '(0, -y, -y)',
                          '(0, -y+1/2, -y+1/2)', '(1/2, -y, -y+1/2)',
                          '(1/2, -y+1/2, -y)', '(y, 0, y)', '(y, 1/2, y+1/2)',
                          '(y+1/2, 0, y+1/2)', '(y+1/2, 1/2, y)',
                          '(y, 0, -y)', '(y, 1/2, -y+1/2)',
                          '(y+1/2, 0, -y+1/2)', '(y+1/2, 1/2, -y)',
                          '(-y, 0, y)', '(-y, 1/2, y+1/2)',
                          '(-y+1/2, 0, y+1/2)', '(-y+1/2, 1/2, y)',
                          '(-y, 0, -y)', '(-y, 1/2, -y+1/2)',
                          '(-y+1/2, 0, -y+1/2)', '(-y+1/2, 1/2, -y)',
                          '(y, y, 0)', '(y, y+1/2, 1/2)', '(y+1/2, y, 1/2)',
                          '(y+1/2, y+1/2, 0)', '(-y, y, 0)',
                          '(-y, y+1/2, 1/2)', '(-y+1/2, y, 1/2)',
                          '(-y+1/2, y+1/2, 0)', '(y, -y, 0)',
                          '(y, -y+1/2, 1/2)', '(y+1/2, -y, 1/2)',
                          '(y+1/2, -y+1/2, 0)', '(-y, -y, 0)',
                          '(-y, -y+1/2, 1/2)', '(-y+1/2, -y, 1/2)',
                          '(-y+1/2, -y+1/2, 0)'), None),
              '48i': (2, ('(1/2, y, y)', '(1/2, y+1/2, y+1/2)',
                          '(0, y, y+1/2)', '(0, y+1/2, y)', '(1/2, -y, y)',
                          '(1/2, -y+1/2, y+1/2)', '(0, -y, y+1/2)',
                          '(0, -y+1/2, y)', '(1/2, y, -y)',
                          '(1/2, y+1/2, -y+1/2)', '(0, y, -y+1/2)',
                          '(0, y+1/2, -y)', '(1/2, -y, -y)',
                          '(1/2, -y+1/2, -y+1/2)', '(0, -y, -y+1/2)',
                          '(0, -y+1/2, -y)', '(y, 1/2, y)', '(y, 0, y+1/2)',
                          '(y+1/2, 1/2, y+1/2)', '(y+1/2, 0, y)',
                          '(y, 1/2, -y)', '(y, 0, -y+1/2)',
                          '(y+1/2, 1/2, -y+1/2)', '(y+1/2, 0, -y)',
                          '(-y, 1/2, y)', '(-y, 0, y+1/2)',
                          '(-y+1/2, 1/2, y+1/2)', '(-y+1/2, 0, y)',
                          '(-y, 1/2, -y)', '(-y, 0, -y+1/2)',
                          '(-y+1/2, 1/2, -y+1/2)', '(-y+1/2, 0, -y)',
                          '(y, y, 1/2)', '(y, y+1/2, 0)', '(y+1/2, y, 0)',
                          '(y+1/2, y+1/2, 1/2)', '(-y, y, 1/2)',
                          '(-y, y+1/2, 0)', '(-y+1/2, y, 0)',
                          '(-y+1/2, y+1/2, 1/2)', '(y, -y, 1/2)',
                          '(y, -y+1/2, 0)', '(y+1/2, -y, 0)',
                          '(y+1/2, -y+1/2, 1/2)', '(-y, -y, 1/2)',
                          '(-y, -y+1/2, 0)', '(-y+1/2, -y, 0)',
                          '(-y+1/2, -y+1/2, 1/2)'), None),
              '96j': (6, ('(0, y, z)', '(0, y+1/2, z+1/2)', '(1/2, y, z+1/2)',
                          '(1/2, y+1/2, z)', '(0, -y, z)',
                          '(0, -y+1/2, z+1/2)', '(1/2, -y, z+1/2)',
                          '(1/2, -y+1/2, z)', '(0, y, -z)',
                          '(0, y+1/2, -z+1/2)', '(1/2, y, -z+1/2)',
                          '(1/2, y+1/2, -z)', '(0, -y, -z)',
                          '(0, -y+1/2, -z+1/2)', '(1/2, -y, -z+1/2)',
                          '(1/2, -y+1/2, -z)', '(z, 0, y)', '(z, 1/2, y+1/2)',
                          '(z+1/2, 0, y+1/2)', '(z+1/2, 1/2, y)',
                          '(z, 0, -y)', '(z, 1/2, -y+1/2)',
                          '(z+1/2, 0, -y+1/2)', '(z+1/2, 1/2, -y)',
                          '(-z, 0, y)', '(-z, 1/2, y+1/2)',
                          '(-z+1/2, 0, y+1/2)', '(-z+1/2, 1/2, y)',
                          '(-z, 0, -y)', '(-z, 1/2, -y+1/2)',
                          '(-z+1/2, 0, -y+1/2)', '(-z+1/2, 1/2, -y)',
                          '(y, z, 0)', '(y, z+1/2, 1/2)', '(y+1/2, z, 1/2)',
                          '(y+1/2, z+1/2, 0)', '(-y, z, 0)',
                          '(-y, z+1/2, 1/2)', '(-y+1/2, z, 1/2)',
                          '(-y+1/2, z+1/2, 0)', '(y, -z, 0)',
                          '(y, -z+1/2, 1/2)', '(y+1/2, -z, 1/2)',
                          '(y+1/2, -z+1/2, 0)', '(-y, -z, 0)',
                          '(-y, -z+1/2, 1/2)', '(-y+1/2, -z, 1/2)',
                          '(-y+1/2, -z+1/2, 0)', '(y, 0, -z)',
                          '(y, 1/2, -z+1/2)', '(y+1/2, 0, -z+1/2)',
                          '(y+1/2, 1/2, -z)', '(-y, 0, -z)',
                          '(-y, 1/2, -z+1/2)', '(-y+1/2, 0, -z+1/2)',
                          '(-y+1/2, 1/2, -z)', '(y, 0, z)', '(y, 1/2, z+1/2)',
                          '(y+1/2, 0, z+1/2)', '(y+1/2, 1/2, z)',
                          '(-y, 0, z)', '(-y, 1/2, z+1/2)',
                          '(-y+1/2, 0, z+1/2)', '(-y+1/2, 1/2, z)',
                          '(0, z, -y)', '(0, z+1/2, -y+1/2)',
                          '(1/2, z, -y+1/2)', '(1/2, z+1/2, -y)', '(0, z, y)',
                          '(0, z+1/2, y+1/2)', '(1/2, z, y+1/2)',
                          '(1/2, z+1/2, y)', '(0, -z, -y)',
                          '(0, -z+1/2, -y+1/2)', '(1/2, -z, -y+1/2)',
                          '(1/2, -z+1/2, -y)', '(0, -z, y)',
                          '(0, -z+1/2, y+1/2)', '(1/2, -z, y+1/2)',
                          '(1/2, -z+1/2, y)', '(z, y, 0)', '(z, y+1/2, 1/2)',
                          '(z+1/2, y, 1/2)', '(z+1/2, y+1/2, 0)',
                          '(z, -y, 0)', '(z, -y+1/2, 1/2)',
                          '(z+1/2, -y, 1/2)', '(z+1/2, -y+1/2, 0)',
                          '(-z, y, 0)', '(-z, y+1/2, 1/2)',
                          '(-z+1/2, y, 1/2)', '(-z+1/2, y+1/2, 0)',
                          '(-z, -y, 0)', '(-z, -y+1/2, 1/2)',
                          '(-z+1/2, -y, 1/2)', '(-z+1/2, -y+1/2, 0)'), None),
              '96k': (5, ('(x, x, z)', '(x, x+1/2, z+1/2)',
                          '(x+1/2, x, z+1/2)', '(x+1/2, x+1/2, z)',
                          '(-x, -x, z)', '(-x, -x+1/2, z+1/2)',
                          '(-x+1/2, -x, z+1/2)', '(-x+1/2, -x+1/2, z)',
                          '(-x, x, -z)', '(-x, x+1/2, -z+1/2)',
                          '(-x+1/2, x, -z+1/2)', '(-x+1/2, x+1/2, -z)',
                          '(x, -x, -z)', '(x, -x+1/2, -z+1/2)',
                          '(x+1/2, -x, -z+1/2)', '(x+1/2, -x+1/2, -z)',
                          '(z, x, x)', '(z, x+1/2, x+1/2)',
                          '(z+1/2, x, x+1/2)', '(z+1/2, x+1/2, x)',
                          '(z, -x, -x)', '(z, -x+1/2, -x+1/2)',
                          '(z+1/2, -x, -x+1/2)', '(z+1/2, -x+1/2, -x)',
                          '(-z, -x, x)', '(-z, -x+1/2, x+1/2)',
                          '(-z+1/2, -x, x+1/2)', '(-z+1/2, -x+1/2, x)',
                          '(-z, x, -x)', '(-z, x+1/2, -x+1/2)',
                          '(-z+1/2, x, -x+1/2)', '(-z+1/2, x+1/2, -x)',
                          '(x, z, x)', '(x, z+1/2, x+1/2)',
                          '(x+1/2, z, x+1/2)', '(x+1/2, z+1/2, x)',
                          '(-x, z, -x)', '(-x, z+1/2, -x+1/2)',
                          '(-x+1/2, z, -x+1/2)', '(-x+1/2, z+1/2, -x)',
                          '(x, -z, -x)', '(x, -z+1/2, -x+1/2)',
                          '(x+1/2, -z, -x+1/2)', '(x+1/2, -z+1/2, -x)',
                          '(-x, -z, x)', '(-x, -z+1/2, x+1/2)',
                          '(-x+1/2, -z, x+1/2)', '(-x+1/2, -z+1/2, x)',
                          '(x, x, -z)', '(x, x+1/2, -z+1/2)',
                          '(x+1/2, x, -z+1/2)', '(x+1/2, x+1/2, -z)',
                          '(-x, -x, -z)', '(-x, -x+1/2, -z+1/2)',
                          '(-x+1/2, -x, -z+1/2)', '(-x+1/2, -x+1/2, -z)',
                          '(x, -x, z)', '(x, -x+1/2, z+1/2)',
                          '(x+1/2, -x, z+1/2)', '(x+1/2, -x+1/2, z)',
                          '(-x, x, z)', '(-x, x+1/2, z+1/2)',
                          '(-x+1/2, x, z+1/2)', '(-x+1/2, x+1/2, z)',
                          '(x, z, -x)', '(x, z+1/2, -x+1/2)',
                          '(x+1/2, z, -x+1/2)', '(x+1/2, z+1/2, -x)',
                          '(-x, z, x)', '(-x, z+1/2, x+1/2)',
                          '(-x+1/2, z, x+1/2)', '(-x+1/2, z+1/2, x)',
                          '(-x, -z, -x)', '(-x, -z+1/2, -x+1/2)',
                          '(-x+1/2, -z, -x+1/2)', '(-x+1/2, -z+1/2, -x)',
                          '(x, -z, x)', '(x, -z+1/2, x+1/2)',
                          '(x+1/2, -z, x+1/2)', '(x+1/2, -z+1/2, x)',
                          '(z, x, -x)', '(z, x+1/2, -x+1/2)',
                          '(z+1/2, x, -x+1/2)', '(z+1/2, x+1/2, -x)',
                          '(z, -x, x)', '(z, -x+1/2, x+1/2)',
                          '(z+1/2, -x, x+1/2)', '(z+1/2, -x+1/2, x)',
                          '(-z, x, x)', '(-z, x+1/2, x+1/2)',
                          '(-z+1/2, x, x+1/2)', '(-z+1/2, x+1/2, x)',
                          '(-z, -x, -x)', '(-z, -x+1/2, -x+1/2)',
                          '(-z+1/2, -x, -x+1/2)', '(-z+1/2, -x+1/2, -x)'), None
                      ),
              '192l': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)',
                           '(x+1/2, y, z+1/2)', '(x+1/2, y+1/2, z)',
                           '(-x, -y, z)', '(-x, -y+1/2, z+1/2)',
                           '(-x+1/2, -y, z+1/2)', '(-x+1/2, -y+1/2, z)',
                           '(-x, y, -z)', '(-x, y+1/2, -z+1/2)',
                           '(-x+1/2, y, -z+1/2)', '(-x+1/2, y+1/2, -z)',
                           '(x, -y, -z)', '(x, -y+1/2, -z+1/2)',
                           '(x+1/2, -y, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                           '(z, x, y)', '(z, x+1/2, y+1/2)',
                           '(z+1/2, x, y+1/2)', '(z+1/2, x+1/2, y)',
                           '(z, -x, -y)', '(z, -x+1/2, -y+1/2)',
                           '(z+1/2, -x, -y+1/2)', '(z+1/2, -x+1/2, -y)',
                           '(-z, -x, y)', '(-z, -x+1/2, y+1/2)',
                           '(-z+1/2, -x, y+1/2)', '(-z+1/2, -x+1/2, y)',
                           '(-z, x, -y)', '(-z, x+1/2, -y+1/2)',
                           '(-z+1/2, x, -y+1/2)', '(-z+1/2, x+1/2, -y)',
                           '(y, z, x)', '(y, z+1/2, x+1/2)',
                           '(y+1/2, z, x+1/2)', '(y+1/2, z+1/2, x)',
                           '(-y, z, -x)', '(-y, z+1/2, -x+1/2)',
                           '(-y+1/2, z, -x+1/2)', '(-y+1/2, z+1/2, -x)',
                           '(y, -z, -x)', '(y, -z+1/2, -x+1/2)',
                           '(y+1/2, -z, -x+1/2)', '(y+1/2, -z+1/2, -x)',
                           '(-y, -z, x)', '(-y, -z+1/2, x+1/2)',
                           '(-y+1/2, -z, x+1/2)', '(-y+1/2, -z+1/2, x)',
                           '(y, x, -z)', '(y, x+1/2, -z+1/2)',
                           '(y+1/2, x, -z+1/2)', '(y+1/2, x+1/2, -z)',
                           '(-y, -x, -z)', '(-y, -x+1/2, -z+1/2)',
                           '(-y+1/2, -x, -z+1/2)', '(-y+1/2, -x+1/2, -z)',
                           '(y, -x, z)', '(y, -x+1/2, z+1/2)',
                           '(y+1/2, -x, z+1/2)', '(y+1/2, -x+1/2, z)',
                           '(-y, x, z)', '(-y, x+1/2, z+1/2)',
                           '(-y+1/2, x, z+1/2)', '(-y+1/2, x+1/2, z)',
                           '(x, z, -y)', '(x, z+1/2, -y+1/2)',
                           '(x+1/2, z, -y+1/2)', '(x+1/2, z+1/2, -y)',
                           '(-x, z, y)', '(-x, z+1/2, y+1/2)',
                           '(-x+1/2, z, y+1/2)', '(-x+1/2, z+1/2, y)',
                           '(-x, -z, -y)', '(-x, -z+1/2, -y+1/2)',
                           '(-x+1/2, -z, -y+1/2)', '(-x+1/2, -z+1/2, -y)',
                           '(x, -z, y)', '(x, -z+1/2, y+1/2)',
                           '(x+1/2, -z, y+1/2)', '(x+1/2, -z+1/2, y)',
                           '(z, y, -x)', '(z, y+1/2, -x+1/2)',
                           '(z+1/2, y, -x+1/2)', '(z+1/2, y+1/2, -x)',
                           '(z, -y, x)', '(z, -y+1/2, x+1/2)',
                           '(z+1/2, -y, x+1/2)', '(z+1/2, -y+1/2, x)',
                           '(-z, y, x)', '(-z, y+1/2, x+1/2)',
                           '(-z+1/2, y, x+1/2)', '(-z+1/2, y+1/2, x)',
                           '(-z, -y, -x)', '(-z, -y+1/2, -x+1/2)',
                           '(-z+1/2, -y, -x+1/2)', '(-z+1/2, -y+1/2, -x)',
                           '(-x, -y, -z)', '(-x, -y+1/2, -z+1/2)',
                           '(-x+1/2, -y, -z+1/2)', '(-x+1/2, -y+1/2, -z)',
                           '(x, y, -z)', '(x, y+1/2, -z+1/2)',
                           '(x+1/2, y, -z+1/2)', '(x+1/2, y+1/2, -z)',
                           '(x, -y, z)', '(x, -y+1/2, z+1/2)',
                           '(x+1/2, -y, z+1/2)', '(x+1/2, -y+1/2, z)',
                           '(-x, y, z)', '(-x, y+1/2, z+1/2)',
                           '(-x+1/2, y, z+1/2)', '(-x+1/2, y+1/2, z)',
                           '(-z, -x, -y)', '(-z, -x+1/2, -y+1/2)',
                           '(-z+1/2, -x, -y+1/2)', '(-z+1/2, -x+1/2, -y)',
                           '(-z, x, y)', '(-z, x+1/2, y+1/2)',
                           '(-z+1/2, x, y+1/2)', '(-z+1/2, x+1/2, y)',
                           '(z, x, -y)', '(z, x+1/2, -y+1/2)',
                           '(z+1/2, x, -y+1/2)', '(z+1/2, x+1/2, -y)',
                           '(z, -x, y)', '(z, -x+1/2, y+1/2)',
                           '(z+1/2, -x, y+1/2)', '(z+1/2, -x+1/2, y)',
                           '(-y, -z, -x)', '(-y, -z+1/2, -x+1/2)',
                           '(-y+1/2, -z, -x+1/2)', '(-y+1/2, -z+1/2, -x)',
                           '(y, -z, x)', '(y, -z+1/2, x+1/2)',
                           '(y+1/2, -z, x+1/2)', '(y+1/2, -z+1/2, x)',
                           '(-y, z, x)', '(-y, z+1/2, x+1/2)',
                           '(-y+1/2, z, x+1/2)', '(-y+1/2, z+1/2, x)',
                           '(y, z, -x)', '(y, z+1/2, -x+1/2)',
                           '(y+1/2, z, -x+1/2)', '(y+1/2, z+1/2, -x)',
                           '(-y, -x, z)', '(-y, -x+1/2, z+1/2)',
                           '(-y+1/2, -x, z+1/2)', '(-y+1/2, -x+1/2, z)',
                           '(y, x, z)', '(y, x+1/2, z+1/2)',
                           '(y+1/2, x, z+1/2)', '(y+1/2, x+1/2, z)',
                           '(-y, x, -z)', '(-y, x+1/2, -z+1/2)',
                           '(-y+1/2, x, -z+1/2)', '(-y+1/2, x+1/2, -z)',
                           '(y, -x, -z)', '(y, -x+1/2, -z+1/2)',
                           '(y+1/2, -x, -z+1/2)', '(y+1/2, -x+1/2, -z)',
                           '(-x, -z, y)', '(-x, -z+1/2, y+1/2)',
                           '(-x+1/2, -z, y+1/2)', '(-x+1/2, -z+1/2, y)',
                           '(x, -z, -y)', '(x, -z+1/2, -y+1/2)',
                           '(x+1/2, -z, -y+1/2)', '(x+1/2, -z+1/2, -y)',
                           '(x, z, y)', '(x, z+1/2, y+1/2)',
                           '(x+1/2, z, y+1/2)', '(x+1/2, z+1/2, y)',
                           '(-x, z, -y)', '(-x, z+1/2, -y+1/2)',
                           '(-x+1/2, z, -y+1/2)', '(-x+1/2, z+1/2, -y)',
                           '(-z, -y, x)', '(-z, -y+1/2, x+1/2)',
                           '(-z+1/2, -y, x+1/2)', '(-z+1/2, -y+1/2, x)',
                           '(-z, y, -x)', '(-z, y+1/2, -x+1/2)',
                           '(-z+1/2, y, -x+1/2)', '(-z+1/2, y+1/2, -x)',
                           '(z, -y, -x)', '(z, -y+1/2, -x+1/2)',
                           '(z+1/2, -y, -x+1/2)', '(z+1/2, -y+1/2, -x)',
                           '(z, y, x)', '(z, y+1/2, x+1/2)',
                           '(z+1/2, y, x+1/2)', '(z+1/2, y+1/2, x)'),
                       'hkl: h+k,h+l,k+l=2n, 0kl: k,l=2n, hhl: h+l=2n, '
                       'h00: h=2n')},
      '226': {'8a': (0, ('(1/4, 1/4, 1/4)', '(1/4, 3/4, 3/4)',
                         '(3/4, 1/4, 3/4)', '(3/4, 3/4, 1/4)',
                         '(3/4, 3/4, 3/4)', '(3/4, 1/4, 1/4)',
                         '(1/4, 3/4, 1/4)', '(1/4, 1/4, 3/4)'), 'hkl: h=2n'),
              '8b': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                         '(1/2, 1/2, 0)', '(1/2, 1/2, 1/2)', '(1/2, 0, 0)',
                         '(0, 1/2, 0)', '(0, 0, 1/2)'), 'hkl: h=2n'),
              '24c': (0, ('(1/4, 0, 0)', '(1/4, 1/2, 1/2)', '(3/4, 0, 1/2)',
                          '(3/4, 1/2, 0)', '(3/4, 0, 0)', '(3/4, 1/2, 1/2)',
                          '(1/4, 0, 1/2)', '(1/4, 1/2, 0)', '(0, 1/4, 0)',
                          '(0, 3/4, 1/2)', '(1/2, 1/4, 1/2)', '(1/2, 3/4, 0)',
                          '(0, 3/4, 0)', '(0, 1/4, 1/2)', '(1/2, 3/4, 1/2)',
                          '(1/2, 1/4, 0)', '(0, 0, 1/4)', '(0, 1/2, 3/4)',
                          '(1/2, 0, 3/4)', '(1/2, 1/2, 1/4)', '(0, 0, 3/4)',
                          '(0, 1/2, 1/4)', '(1/2, 0, 1/4)', '(1/2, 1/2, 3/4)'
                          ), 'hkl: h=2n'),
              '24d': (0, ('(0, 1/4, 1/4)', '(0, 3/4, 3/4)', '(1/2, 1/4, 3/4)',
                          '(1/2, 3/4, 1/4)', '(0, 3/4, 1/4)', '(0, 1/4, 3/4)',
                          '(1/2, 3/4, 3/4)', '(1/2, 1/4, 1/4)',
                          '(1/4, 0, 1/4)', '(1/4, 1/2, 3/4)', '(3/4, 0, 3/4)',
                          '(3/4, 1/2, 1/4)', '(1/4, 0, 3/4)',
                          '(1/4, 1/2, 1/4)', '(3/4, 0, 1/4)',
                          '(3/4, 1/2, 3/4)', '(1/4, 1/4, 0)',
                          '(1/4, 3/4, 1/2)', '(3/4, 1/4, 1/2)',
                          '(3/4, 3/4, 0)', '(3/4, 1/4, 0)', '(3/4, 3/4, 1/2)',
                          '(1/4, 1/4, 1/2)', '(1/4, 3/4, 0)'), 'hkl: h=2n'),
              '48e': (1, ('(x, 0, 0)', '(x, 1/2, 1/2)', '(x+1/2, 0, 1/2)',
                          '(x+1/2, 1/2, 0)', '(-x, 0, 0)', '(-x, 1/2, 1/2)',
                          '(-x+1/2, 0, 1/2)', '(-x+1/2, 1/2, 0)', '(0, x, 0)',
                          '(0, x+1/2, 1/2)', '(1/2, x, 1/2)',
                          '(1/2, x+1/2, 0)', '(0, -x, 0)', '(0, -x+1/2, 1/2)',
                          '(1/2, -x, 1/2)', '(1/2, -x+1/2, 0)', '(0, 0, x)',
                          '(0, 1/2, x+1/2)', '(1/2, 0, x+1/2)',
                          '(1/2, 1/2, x)', '(0, 0, -x)', '(0, 1/2, -x+1/2)',
                          '(1/2, 0, -x+1/2)', '(1/2, 1/2, -x)',
                          '(1/2, x+1/2, 1/2)', '(1/2, x, 0)', '(0, x+1/2, 0)',
                          '(0, x, 1/2)', '(1/2, -x+1/2, 1/2)', '(1/2, -x, 0)',
                          '(0, -x+1/2, 0)', '(0, -x, 1/2)',
                          '(x+1/2, 1/2, 1/2)', '(x+1/2, 0, 0)', '(x, 1/2, 0)',
                          '(x, 0, 1/2)', '(-x+1/2, 1/2, 1/2)',
                          '(-x+1/2, 0, 0)', '(-x, 1/2, 0)', '(-x, 0, 1/2)',
                          '(1/2, 1/2, -x+1/2)', '(1/2, 0, -x)',
                          '(0, 1/2, -x)', '(0, 0, -x+1/2)',
                          '(1/2, 1/2, x+1/2)', '(1/2, 0, x)', '(0, 1/2, x)',
                          '(0, 0, x+1/2)'), 'hkl: h=2n'),
              '48f': (1, ('(x, 1/4, 1/4)', '(x, 3/4, 3/4)',
                          '(x+1/2, 1/4, 3/4)', '(x+1/2, 3/4, 1/4)',
                          '(-x, 3/4, 1/4)', '(-x, 1/4, 3/4)',
                          '(-x+1/2, 3/4, 3/4)', '(-x+1/2, 1/4, 1/4)',
                          '(1/4, x, 1/4)', '(1/4, x+1/2, 3/4)',
                          '(3/4, x, 3/4)', '(3/4, x+1/2, 1/4)',
                          '(1/4, -x, 3/4)', '(1/4, -x+1/2, 1/4)',
                          '(3/4, -x, 1/4)', '(3/4, -x+1/2, 3/4)',
                          '(1/4, 1/4, x)', '(1/4, 3/4, x+1/2)',
                          '(3/4, 1/4, x+1/2)', '(3/4, 3/4, x)',
                          '(3/4, 1/4, -x)', '(3/4, 3/4, -x+1/2)',
                          '(1/4, 1/4, -x+1/2)', '(1/4, 3/4, -x)',
                          '(-x, 3/4, 3/4)', '(-x, 1/4, 1/4)',
                          '(-x+1/2, 3/4, 1/4)', '(-x+1/2, 1/4, 3/4)',
                          '(x, 1/4, 3/4)', '(x, 3/4, 1/4)',
                          '(x+1/2, 1/4, 1/4)', '(x+1/2, 3/4, 3/4)',
                          '(3/4, -x, 3/4)', '(3/4, -x+1/2, 1/4)',
                          '(1/4, -x, 1/4)', '(1/4, -x+1/2, 3/4)',
                          '(3/4, x, 1/4)', '(3/4, x+1/2, 3/4)',
                          '(1/4, x, 3/4)', '(1/4, x+1/2, 1/4)',
                          '(3/4, 3/4, -x)', '(3/4, 1/4, -x+1/2)',
                          '(1/4, 3/4, -x+1/2)', '(1/4, 1/4, -x)',
                          '(1/4, 3/4, x)', '(1/4, 1/4, x+1/2)',
                          '(3/4, 3/4, x+1/2)', '(3/4, 1/4, x)'), 'hkl: h=2n'),
              '64g': (1, ('(x, x, x)', '(x, x+1/2, x+1/2)',
                          '(x+1/2, x, x+1/2)', '(x+1/2, x+1/2, x)',
                          '(-x, -x, x)', '(-x, -x+1/2, x+1/2)',
                          '(-x+1/2, -x, x+1/2)', '(-x+1/2, -x+1/2, x)',
                          '(-x, x, -x)', '(-x, x+1/2, -x+1/2)',
                          '(-x+1/2, x, -x+1/2)', '(-x+1/2, x+1/2, -x)',
                          '(x, -x, -x)', '(x, -x+1/2, -x+1/2)',
                          '(x+1/2, -x, -x+1/2)', '(x+1/2, -x+1/2, -x)',
                          '(x+1/2, x+1/2, -x+1/2)', '(x+1/2, x, -x)',
                          '(x, x+1/2, -x)', '(x, x, -x+1/2)',
                          '(-x+1/2, -x+1/2, -x+1/2)', '(-x+1/2, -x, -x)',
                          '(-x, -x+1/2, -x)', '(-x, -x, -x+1/2)',
                          '(x+1/2, -x+1/2, x+1/2)', '(x+1/2, -x, x)',
                          '(x, -x+1/2, x)', '(x, -x, x+1/2)',
                          '(-x+1/2, x+1/2, x+1/2)', '(-x+1/2, x, x)',
                          '(-x, x+1/2, x)', '(-x, x, x+1/2)', '(-x, -x, -x)',
                          '(-x, -x+1/2, -x+1/2)', '(-x+1/2, -x, -x+1/2)',
                          '(-x+1/2, -x+1/2, -x)', '(x, x, -x)',
                          '(x, x+1/2, -x+1/2)', '(x+1/2, x, -x+1/2)',
                          '(x+1/2, x+1/2, -x)', '(x, -x, x)',
                          '(x, -x+1/2, x+1/2)', '(x+1/2, -x, x+1/2)',
                          '(x+1/2, -x+1/2, x)', '(-x, x, x)',
                          '(-x, x+1/2, x+1/2)', '(-x+1/2, x, x+1/2)',
                          '(-x+1/2, x+1/2, x)', '(-x+1/2, -x+1/2, x+1/2)',
                          '(-x+1/2, -x, x)', '(-x, -x+1/2, x)',
                          '(-x, -x, x+1/2)', '(x+1/2, x+1/2, x+1/2)',
                          '(x+1/2, x, x)', '(x, x+1/2, x)', '(x, x, x+1/2)',
                          '(-x+1/2, x+1/2, -x+1/2)', '(-x+1/2, x, -x)',
                          '(-x, x+1/2, -x)', '(-x, x, -x+1/2)',
                          '(x+1/2, -x+1/2, -x+1/2)', '(x+1/2, -x, -x)',
                          '(x, -x+1/2, -x)', '(x, -x, -x+1/2)'), 'hkl: h=2n'),
              '96h': (2, ('(1/4, y, y)', '(1/4, y+1/2, y+1/2)',
                          '(3/4, y, y+1/2)', '(3/4, y+1/2, y)',
                          '(3/4, -y, y)', '(3/4, -y+1/2, y+1/2)',
                          '(1/4, -y, y+1/2)', '(1/4, -y+1/2, y)',
                          '(3/4, y, -y)', '(3/4, y+1/2, -y+1/2)',
                          '(1/4, y, -y+1/2)', '(1/4, y+1/2, -y)',
                          '(1/4, -y, -y)', '(1/4, -y+1/2, -y+1/2)',
                          '(3/4, -y, -y+1/2)', '(3/4, -y+1/2, -y)',
                          '(y, 1/4, y)', '(y, 3/4, y+1/2)',
                          '(y+1/2, 1/4, y+1/2)', '(y+1/2, 3/4, y)',
                          '(y, 3/4, -y)', '(y, 1/4, -y+1/2)',
                          '(y+1/2, 3/4, -y+1/2)', '(y+1/2, 1/4, -y)',
                          '(-y, 3/4, y)', '(-y, 1/4, y+1/2)',
                          '(-y+1/2, 3/4, y+1/2)', '(-y+1/2, 1/4, y)',
                          '(-y, 1/4, -y)', '(-y, 3/4, -y+1/2)',
                          '(-y+1/2, 1/4, -y+1/2)', '(-y+1/2, 3/4, -y)',
                          '(y, y, 1/4)', '(y, y+1/2, 3/4)', '(y+1/2, y, 3/4)',
                          '(y+1/2, y+1/2, 1/4)', '(-y, y, 3/4)',
                          '(-y, y+1/2, 1/4)', '(-y+1/2, y, 1/4)',
                          '(-y+1/2, y+1/2, 3/4)', '(y, -y, 3/4)',
                          '(y, -y+1/2, 1/4)', '(y+1/2, -y, 1/4)',
                          '(y+1/2, -y+1/2, 3/4)', '(-y, -y, 1/4)',
                          '(-y, -y+1/2, 3/4)', '(-y+1/2, -y, 3/4)',
                          '(-y+1/2, -y+1/2, 1/4)', '(3/4, -y, -y)',
                          '(3/4, -y+1/2, -y+1/2)', '(1/4, -y, -y+1/2)',
                          '(1/4, -y+1/2, -y)', '(1/4, y, -y)',
                          '(1/4, y+1/2, -y+1/2)', '(3/4, y, -y+1/2)',
                          '(3/4, y+1/2, -y)', '(1/4, -y, y)',
                          '(1/4, -y+1/2, y+1/2)', '(3/4, -y, y+1/2)',
                          '(3/4, -y+1/2, y)', '(3/4, y, y)',
                          '(3/4, y+1/2, y+1/2)', '(1/4, y, y+1/2)',
                          '(1/4, y+1/2, y)', '(-y, 3/4, -y)',
                          '(-y, 1/4, -y+1/2)', '(-y+1/2, 3/4, -y+1/2)',
                          '(-y+1/2, 1/4, -y)', '(-y, 1/4, y)',
                          '(-y, 3/4, y+1/2)', '(-y+1/2, 1/4, y+1/2)',
                          '(-y+1/2, 3/4, y)', '(y, 1/4, -y)',
                          '(y, 3/4, -y+1/2)', '(y+1/2, 1/4, -y+1/2)',
                          '(y+1/2, 3/4, -y)', '(y, 3/4, y)',
                          '(y, 1/4, y+1/2)', '(y+1/2, 3/4, y+1/2)',
                          '(y+1/2, 1/4, y)', '(-y, -y, 3/4)',
                          '(-y, -y+1/2, 1/4)', '(-y+1/2, -y, 1/4)',
                          '(-y+1/2, -y+1/2, 3/4)', '(y, -y, 1/4)',
                          '(y, -y+1/2, 3/4)', '(y+1/2, -y, 3/4)',
                          '(y+1/2, -y+1/2, 1/4)', '(-y, y, 1/4)',
                          '(-y, y+1/2, 3/4)', '(-y+1/2, y, 3/4)',
                          '(-y+1/2, y+1/2, 1/4)', '(y, y, 3/4)',
                          '(y, y+1/2, 1/4)', '(y+1/2, y, 1/4)',
                          '(y+1/2, y+1/2, 3/4)'), 'hkl: h=2n'),
              '96i': (6, ('(0, y, z)', '(0, y+1/2, z+1/2)', '(1/2, y, z+1/2)',
                          '(1/2, y+1/2, z)', '(0, -y, z)',
                          '(0, -y+1/2, z+1/2)', '(1/2, -y, z+1/2)',
                          '(1/2, -y+1/2, z)', '(0, y, -z)',
                          '(0, y+1/2, -z+1/2)', '(1/2, y, -z+1/2)',
                          '(1/2, y+1/2, -z)', '(0, -y, -z)',
                          '(0, -y+1/2, -z+1/2)', '(1/2, -y, -z+1/2)',
                          '(1/2, -y+1/2, -z)', '(z, 0, y)', '(z, 1/2, y+1/2)',
                          '(z+1/2, 0, y+1/2)', '(z+1/2, 1/2, y)',
                          '(z, 0, -y)', '(z, 1/2, -y+1/2)',
                          '(z+1/2, 0, -y+1/2)', '(z+1/2, 1/2, -y)',
                          '(-z, 0, y)', '(-z, 1/2, y+1/2)',
                          '(-z+1/2, 0, y+1/2)', '(-z+1/2, 1/2, y)',
                          '(-z, 0, -y)', '(-z, 1/2, -y+1/2)',
                          '(-z+1/2, 0, -y+1/2)', '(-z+1/2, 1/2, -y)',
                          '(y, z, 0)', '(y, z+1/2, 1/2)', '(y+1/2, z, 1/2)',
                          '(y+1/2, z+1/2, 0)', '(-y, z, 0)',
                          '(-y, z+1/2, 1/2)', '(-y+1/2, z, 1/2)',
                          '(-y+1/2, z+1/2, 0)', '(y, -z, 0)',
                          '(y, -z+1/2, 1/2)', '(y+1/2, -z, 1/2)',
                          '(y+1/2, -z+1/2, 0)', '(-y, -z, 0)',
                          '(-y, -z+1/2, 1/2)', '(-y+1/2, -z, 1/2)',
                          '(-y+1/2, -z+1/2, 0)', '(y+1/2, 1/2, -z+1/2)',
                          '(y+1/2, 0, -z)', '(y, 1/2, -z)', '(y, 0, -z+1/2)',
                          '(-y+1/2, 1/2, -z+1/2)', '(-y+1/2, 0, -z)',
                          '(-y, 1/2, -z)', '(-y, 0, -z+1/2)',
                          '(y+1/2, 1/2, z+1/2)', '(y+1/2, 0, z)',
                          '(y, 1/2, z)', '(y, 0, z+1/2)',
                          '(-y+1/2, 1/2, z+1/2)', '(-y+1/2, 0, z)',
                          '(-y, 1/2, z)', '(-y, 0, z+1/2)',
                          '(1/2, z+1/2, -y+1/2)', '(1/2, z, -y)',
                          '(0, z+1/2, -y)', '(0, z, -y+1/2)',
                          '(1/2, z+1/2, y+1/2)', '(1/2, z, y)',
                          '(0, z+1/2, y)', '(0, z, y+1/2)',
                          '(1/2, -z+1/2, -y+1/2)', '(1/2, -z, -y)',
                          '(0, -z+1/2, -y)', '(0, -z, -y+1/2)',
                          '(1/2, -z+1/2, y+1/2)', '(1/2, -z, y)',
                          '(0, -z+1/2, y)', '(0, -z, y+1/2)',
                          '(z+1/2, y+1/2, 1/2)', '(z+1/2, y, 0)',
                          '(z, y+1/2, 0)', '(z, y, 1/2)',
                          '(z+1/2, -y+1/2, 1/2)', '(z+1/2, -y, 0)',
                          '(z, -y+1/2, 0)', '(z, -y, 1/2)',
                          '(-z+1/2, y+1/2, 1/2)', '(-z+1/2, y, 0)',
                          '(-z, y+1/2, 0)', '(-z, y, 1/2)',
                          '(-z+1/2, -y+1/2, 1/2)', '(-z+1/2, -y, 0)',
                          '(-z, -y+1/2, 0)', '(-z, -y, 1/2)'), None),
              '192j': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)',
                           '(x+1/2, y, z+1/2)', '(x+1/2, y+1/2, z)',
                           '(-x, -y, z)', '(-x, -y+1/2, z+1/2)',
                           '(-x+1/2, -y, z+1/2)', '(-x+1/2, -y+1/2, z)',
                           '(-x, y, -z)', '(-x, y+1/2, -z+1/2)',
                           '(-x+1/2, y, -z+1/2)', '(-x+1/2, y+1/2, -z)',
                           '(x, -y, -z)', '(x, -y+1/2, -z+1/2)',
                           '(x+1/2, -y, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                           '(z, x, y)', '(z, x+1/2, y+1/2)',
                           '(z+1/2, x, y+1/2)', '(z+1/2, x+1/2, y)',
                           '(z, -x, -y)', '(z, -x+1/2, -y+1/2)',
                           '(z+1/2, -x, -y+1/2)', '(z+1/2, -x+1/2, -y)',
                           '(-z, -x, y)', '(-z, -x+1/2, y+1/2)',
                           '(-z+1/2, -x, y+1/2)', '(-z+1/2, -x+1/2, y)',
                           '(-z, x, -y)', '(-z, x+1/2, -y+1/2)',
                           '(-z+1/2, x, -y+1/2)', '(-z+1/2, x+1/2, -y)',
                           '(y, z, x)', '(y, z+1/2, x+1/2)',
                           '(y+1/2, z, x+1/2)', '(y+1/2, z+1/2, x)',
                           '(-y, z, -x)', '(-y, z+1/2, -x+1/2)',
                           '(-y+1/2, z, -x+1/2)', '(-y+1/2, z+1/2, -x)',
                           '(y, -z, -x)', '(y, -z+1/2, -x+1/2)',
                           '(y+1/2, -z, -x+1/2)', '(y+1/2, -z+1/2, -x)',
                           '(-y, -z, x)', '(-y, -z+1/2, x+1/2)',
                           '(-y+1/2, -z, x+1/2)', '(-y+1/2, -z+1/2, x)',
                           '(y+1/2, x+1/2, -z+1/2)', '(y+1/2, x, -z)',
                           '(y, x+1/2, -z)', '(y, x, -z+1/2)',
                           '(-y+1/2, -x+1/2, -z+1/2)', '(-y+1/2, -x, -z)',
                           '(-y, -x+1/2, -z)', '(-y, -x, -z+1/2)',
                           '(y+1/2, -x+1/2, z+1/2)', '(y+1/2, -x, z)',
                           '(y, -x+1/2, z)', '(y, -x, z+1/2)',
                           '(-y+1/2, x+1/2, z+1/2)', '(-y+1/2, x, z)',
                           '(-y, x+1/2, z)', '(-y, x, z+1/2)',
                           '(x+1/2, z+1/2, -y+1/2)', '(x+1/2, z, -y)',
                           '(x, z+1/2, -y)', '(x, z, -y+1/2)',
                           '(-x+1/2, z+1/2, y+1/2)', '(-x+1/2, z, y)',
                           '(-x, z+1/2, y)', '(-x, z, y+1/2)',
                           '(-x+1/2, -z+1/2, -y+1/2)', '(-x+1/2, -z, -y)',
                           '(-x, -z+1/2, -y)', '(-x, -z, -y+1/2)',
                           '(x+1/2, -z+1/2, y+1/2)', '(x+1/2, -z, y)',
                           '(x, -z+1/2, y)', '(x, -z, y+1/2)',
                           '(z+1/2, y+1/2, -x+1/2)', '(z+1/2, y, -x)',
                           '(z, y+1/2, -x)', '(z, y, -x+1/2)',
                           '(z+1/2, -y+1/2, x+1/2)', '(z+1/2, -y, x)',
                           '(z, -y+1/2, x)', '(z, -y, x+1/2)',
                           '(-z+1/2, y+1/2, x+1/2)', '(-z+1/2, y, x)',
                           '(-z, y+1/2, x)', '(-z, y, x+1/2)',
                           '(-z+1/2, -y+1/2, -x+1/2)', '(-z+1/2, -y, -x)',
                           '(-z, -y+1/2, -x)', '(-z, -y, -x+1/2)',
                           '(-x, -y, -z)', '(-x, -y+1/2, -z+1/2)',
                           '(-x+1/2, -y, -z+1/2)', '(-x+1/2, -y+1/2, -z)',
                           '(x, y, -z)', '(x, y+1/2, -z+1/2)',
                           '(x+1/2, y, -z+1/2)', '(x+1/2, y+1/2, -z)',
                           '(x, -y, z)', '(x, -y+1/2, z+1/2)',
                           '(x+1/2, -y, z+1/2)', '(x+1/2, -y+1/2, z)',
                           '(-x, y, z)', '(-x, y+1/2, z+1/2)',
                           '(-x+1/2, y, z+1/2)', '(-x+1/2, y+1/2, z)',
                           '(-z, -x, -y)', '(-z, -x+1/2, -y+1/2)',
                           '(-z+1/2, -x, -y+1/2)', '(-z+1/2, -x+1/2, -y)',
                           '(-z, x, y)', '(-z, x+1/2, y+1/2)',
                           '(-z+1/2, x, y+1/2)', '(-z+1/2, x+1/2, y)',
                           '(z, x, -y)', '(z, x+1/2, -y+1/2)',
                           '(z+1/2, x, -y+1/2)', '(z+1/2, x+1/2, -y)',
                           '(z, -x, y)', '(z, -x+1/2, y+1/2)',
                           '(z+1/2, -x, y+1/2)', '(z+1/2, -x+1/2, y)',
                           '(-y, -z, -x)', '(-y, -z+1/2, -x+1/2)',
                           '(-y+1/2, -z, -x+1/2)', '(-y+1/2, -z+1/2, -x)',
                           '(y, -z, x)', '(y, -z+1/2, x+1/2)',
                           '(y+1/2, -z, x+1/2)', '(y+1/2, -z+1/2, x)',
                           '(-y, z, x)', '(-y, z+1/2, x+1/2)',
                           '(-y+1/2, z, x+1/2)', '(-y+1/2, z+1/2, x)',
                           '(y, z, -x)', '(y, z+1/2, -x+1/2)',
                           '(y+1/2, z, -x+1/2)', '(y+1/2, z+1/2, -x)',
                           '(-y+1/2, -x+1/2, z+1/2)', '(-y+1/2, -x, z)',
                           '(-y, -x+1/2, z)', '(-y, -x, z+1/2)',
                           '(y+1/2, x+1/2, z+1/2)', '(y+1/2, x, z)',
                           '(y, x+1/2, z)', '(y, x, z+1/2)',
                           '(-y+1/2, x+1/2, -z+1/2)', '(-y+1/2, x, -z)',
                           '(-y, x+1/2, -z)', '(-y, x, -z+1/2)',
                           '(y+1/2, -x+1/2, -z+1/2)', '(y+1/2, -x, -z)',
                           '(y, -x+1/2, -z)', '(y, -x, -z+1/2)',
                           '(-x+1/2, -z+1/2, y+1/2)', '(-x+1/2, -z, y)',
                           '(-x, -z+1/2, y)', '(-x, -z, y+1/2)',
                           '(x+1/2, -z+1/2, -y+1/2)', '(x+1/2, -z, -y)',
                           '(x, -z+1/2, -y)', '(x, -z, -y+1/2)',
                           '(x+1/2, z+1/2, y+1/2)', '(x+1/2, z, y)',
                           '(x, z+1/2, y)', '(x, z, y+1/2)',
                           '(-x+1/2, z+1/2, -y+1/2)', '(-x+1/2, z, -y)',
                           '(-x, z+1/2, -y)', '(-x, z, -y+1/2)',
                           '(-z+1/2, -y+1/2, x+1/2)', '(-z+1/2, -y, x)',
                           '(-z, -y+1/2, x)', '(-z, -y, x+1/2)',
                           '(-z+1/2, y+1/2, -x+1/2)', '(-z+1/2, y, -x)',
                           '(-z, y+1/2, -x)', '(-z, y, -x+1/2)',
                           '(z+1/2, -y+1/2, -x+1/2)', '(z+1/2, -y, -x)',
                           '(z, -y+1/2, -x)', '(z, -y, -x+1/2)',
                           '(z+1/2, y+1/2, x+1/2)', '(z+1/2, y, x)',
                           '(z, y+1/2, x)', '(z, y, x+1/2)'),
                       'hkl: h+k=2n, h+l,k+l=2n, 0kl: k,l=2n, hhl: h,l=2n, '
                       'h00: h=2n')},
      '227:1': {'8a': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                           '(1/2, 1/2, 0)', '(3/4, 1/4, 3/4)',
                           '(3/4, 3/4, 1/4)', '(1/4, 1/4, 1/4)',
                           '(1/4, 3/4, 3/4)'), 'hkl: h=2n+1 or h+k+l=4n'),
                '8b': (0, ('(1/2, 1/2, 1/2)', '(1/2, 0, 0)', '(0, 1/2, 0)',
                           '(0, 0, 1/2)', '(1/4, 3/4, 1/4)',
                           '(1/4, 1/4, 3/4)', '(3/4, 3/4, 3/4)',
                           '(3/4, 1/4, 1/4)'), 'hkl: h=2n+1 or h+k+l=4n'),
                '16c': (0, ('(1/8, 1/8, 1/8)', '(1/8, 5/8, 5/8)',
                            '(5/8, 1/8, 5/8)', '(5/8, 5/8, 1/8)',
                            '(7/8, 3/8, 5/8)', '(7/8, 7/8, 1/8)',
                            '(3/8, 3/8, 1/8)', '(3/8, 7/8, 5/8)',
                            '(3/8, 5/8, 7/8)', '(3/8, 1/8, 3/8)',
                            '(7/8, 5/8, 3/8)', '(7/8, 1/8, 7/8)',
                            '(5/8, 7/8, 3/8)', '(5/8, 3/8, 7/8)',
                            '(1/8, 7/8, 7/8)', '(1/8, 3/8, 3/8)'),
                        'hkl: h=2n+1 or h,k,l=4n+2 or h,k,l=4n'),
                '16d': (0, ('(5/8, 5/8, 5/8)', '(5/8, 1/8, 1/8)',
                            '(1/8, 5/8, 1/8)', '(1/8, 1/8, 5/8)',
                            '(3/8, 7/8, 1/8)', '(3/8, 3/8, 5/8)',
                            '(7/8, 7/8, 5/8)', '(7/8, 3/8, 1/8)',
                            '(7/8, 1/8, 3/8)', '(7/8, 5/8, 7/8)',
                            '(3/8, 1/8, 7/8)', '(3/8, 5/8, 3/8)',
                            '(1/8, 3/8, 7/8)', '(1/8, 7/8, 3/8)',
                            '(5/8, 3/8, 3/8)', '(5/8, 7/8, 7/8)'),
                        'hkl: h=2n+1 or h,k,l=4n+2 or h,k,l=4n'),
                '32e': (1, ('(x, x, x)', '(x, x+1/2, x+1/2)',
                            '(x+1/2, x, x+1/2)', '(x+1/2, x+1/2, x)',
                            '(-x, -x+1/2, x+1/2)', '(-x, -x, x)',
                            '(-x+1/2, -x+1/2, x)', '(-x+1/2, -x, x+1/2)',
                            '(-x+1/2, x+1/2, -x)', '(-x+1/2, x, -x+1/2)',
                            '(-x, x+1/2, -x+1/2)', '(-x, x, -x)',
                            '(x+1/2, -x, -x+1/2)', '(x+1/2, -x+1/2, -x)',
                            '(x, -x, -x)', '(x, -x+1/2, -x+1/2)',
                            '(x+3/4, x+1/4, -x+3/4)',
                            '(x+3/4, x+3/4, -x+1/4)',
                            '(x+1/4, x+1/4, -x+1/4)',
                            '(x+1/4, x+3/4, -x+3/4)',
                            '(-x+1/4, -x+1/4, -x+1/4)',
                            '(-x+1/4, -x+3/4, -x+3/4)',
                            '(-x+3/4, -x+1/4, -x+3/4)',
                            '(-x+3/4, -x+3/4, -x+1/4)',
                            '(x+1/4, -x+3/4, x+3/4)',
                            '(x+1/4, -x+1/4, x+1/4)',
                            '(x+3/4, -x+3/4, x+1/4)',
                            '(x+3/4, -x+1/4, x+3/4)',
                            '(-x+3/4, x+3/4, x+1/4)',
                            '(-x+3/4, x+1/4, x+3/4)',
                            '(-x+1/4, x+3/4, x+3/4)',
                            '(-x+1/4, x+1/4, x+1/4)'),
                        'no extra conditions, no extra conditions'),
                '48f': (1, ('(x, 0, 0)', '(x, 1/2, 1/2)', '(x+1/2, 0, 1/2)',
                            '(x+1/2, 1/2, 0)', '(-x, 1/2, 1/2)', '(-x, 0, 0)',
                            '(-x+1/2, 1/2, 0)', '(-x+1/2, 0, 1/2)',
                            '(0, x, 0)', '(0, x+1/2, 1/2)', '(1/2, x, 1/2)',
                            '(1/2, x+1/2, 0)', '(1/2, -x, 1/2)',
                            '(1/2, -x+1/2, 0)', '(0, -x, 0)',
                            '(0, -x+1/2, 1/2)', '(0, 0, x)',
                            '(0, 1/2, x+1/2)', '(1/2, 0, x+1/2)',
                            '(1/2, 1/2, x)', '(1/2, 1/2, -x)',
                            '(1/2, 0, -x+1/2)', '(0, 1/2, -x+1/2)',
                            '(0, 0, -x)', '(3/4, x+1/4, 3/4)',
                            '(3/4, x+3/4, 1/4)', '(1/4, x+1/4, 1/4)',
                            '(1/4, x+3/4, 3/4)', '(1/4, -x+1/4, 1/4)',
                            '(1/4, -x+3/4, 3/4)', '(3/4, -x+1/4, 3/4)',
                            '(3/4, -x+3/4, 1/4)', '(x+3/4, 1/4, 3/4)',
                            '(x+3/4, 3/4, 1/4)', '(x+1/4, 1/4, 1/4)',
                            '(x+1/4, 3/4, 3/4)', '(-x+3/4, 3/4, 1/4)',
                            '(-x+3/4, 1/4, 3/4)', '(-x+1/4, 3/4, 3/4)',
                            '(-x+1/4, 1/4, 1/4)', '(3/4, 1/4, -x+3/4)',
                            '(3/4, 3/4, -x+1/4)', '(1/4, 1/4, -x+1/4)',
                            '(1/4, 3/4, -x+3/4)', '(1/4, 3/4, x+3/4)',
                            '(1/4, 1/4, x+1/4)', '(3/4, 3/4, x+1/4)',
                            '(3/4, 1/4, x+3/4)'), 'hkl: h=2n+1 or h+k+l=4n'),
                '96g': (5, ('(x, x, z)', '(x, x+1/2, z+1/2)',
                            '(x+1/2, x, z+1/2)', '(x+1/2, x+1/2, z)',
                            '(-x, -x+1/2, z+1/2)', '(-x, -x, z)',
                            '(-x+1/2, -x+1/2, z)', '(-x+1/2, -x, z+1/2)',
                            '(-x+1/2, x+1/2, -z)', '(-x+1/2, x, -z+1/2)',
                            '(-x, x+1/2, -z+1/2)', '(-x, x, -z)',
                            '(x+1/2, -x, -z+1/2)', '(x+1/2, -x+1/2, -z)',
                            '(x, -x, -z)', '(x, -x+1/2, -z+1/2)', '(z, x, x)',
                            '(z, x+1/2, x+1/2)', '(z+1/2, x, x+1/2)',
                            '(z+1/2, x+1/2, x)', '(z+1/2, -x, -x+1/2)',
                            '(z+1/2, -x+1/2, -x)', '(z, -x, -x)',
                            '(z, -x+1/2, -x+1/2)', '(-z, -x+1/2, x+1/2)',
                            '(-z, -x, x)', '(-z+1/2, -x+1/2, x)',
                            '(-z+1/2, -x, x+1/2)', '(-z+1/2, x+1/2, -x)',
                            '(-z+1/2, x, -x+1/2)', '(-z, x+1/2, -x+1/2)',
                            '(-z, x, -x)', '(x, z, x)', '(x, z+1/2, x+1/2)',
                            '(x+1/2, z, x+1/2)', '(x+1/2, z+1/2, x)',
                            '(-x+1/2, z+1/2, -x)', '(-x+1/2, z, -x+1/2)',
                            '(-x, z+1/2, -x+1/2)', '(-x, z, -x)',
                            '(x+1/2, -z, -x+1/2)', '(x+1/2, -z+1/2, -x)',
                            '(x, -z, -x)', '(x, -z+1/2, -x+1/2)',
                            '(-x, -z+1/2, x+1/2)', '(-x, -z, x)',
                            '(-x+1/2, -z+1/2, x)', '(-x+1/2, -z, x+1/2)',
                            '(x+3/4, x+1/4, -z+3/4)',
                            '(x+3/4, x+3/4, -z+1/4)',
                            '(x+1/4, x+1/4, -z+1/4)',
                            '(x+1/4, x+3/4, -z+3/4)',
                            '(-x+1/4, -x+1/4, -z+1/4)',
                            '(-x+1/4, -x+3/4, -z+3/4)',
                            '(-x+3/4, -x+1/4, -z+3/4)',
                            '(-x+3/4, -x+3/4, -z+1/4)',
                            '(x+1/4, -x+3/4, z+3/4)',
                            '(x+1/4, -x+1/4, z+1/4)',
                            '(x+3/4, -x+3/4, z+1/4)',
                            '(x+3/4, -x+1/4, z+3/4)',
                            '(-x+3/4, x+3/4, z+1/4)',
                            '(-x+3/4, x+1/4, z+3/4)',
                            '(-x+1/4, x+3/4, z+3/4)',
                            '(-x+1/4, x+1/4, z+1/4)',
                            '(x+3/4, z+1/4, -x+3/4)',
                            '(x+3/4, z+3/4, -x+1/4)',
                            '(x+1/4, z+1/4, -x+1/4)',
                            '(x+1/4, z+3/4, -x+3/4)',
                            '(-x+3/4, z+3/4, x+1/4)',
                            '(-x+3/4, z+1/4, x+3/4)',
                            '(-x+1/4, z+3/4, x+3/4)',
                            '(-x+1/4, z+1/4, x+1/4)',
                            '(-x+1/4, -z+1/4, -x+1/4)',
                            '(-x+1/4, -z+3/4, -x+3/4)',
                            '(-x+3/4, -z+1/4, -x+3/4)',
                            '(-x+3/4, -z+3/4, -x+1/4)',
                            '(x+1/4, -z+3/4, x+3/4)',
                            '(x+1/4, -z+1/4, x+1/4)',
                            '(x+3/4, -z+3/4, x+1/4)',
                            '(x+3/4, -z+1/4, x+3/4)',
                            '(z+3/4, x+1/4, -x+3/4)',
                            '(z+3/4, x+3/4, -x+1/4)',
                            '(z+1/4, x+1/4, -x+1/4)',
                            '(z+1/4, x+3/4, -x+3/4)',
                            '(z+1/4, -x+3/4, x+3/4)',
                            '(z+1/4, -x+1/4, x+1/4)',
                            '(z+3/4, -x+3/4, x+1/4)',
                            '(z+3/4, -x+1/4, x+3/4)',
                            '(-z+3/4, x+3/4, x+1/4)',
                            '(-z+3/4, x+1/4, x+3/4)',
                            '(-z+1/4, x+3/4, x+3/4)',
                            '(-z+1/4, x+1/4, x+1/4)',
                            '(-z+1/4, -x+1/4, -x+1/4)',
                            '(-z+1/4, -x+3/4, -x+3/4)',
                            '(-z+3/4, -x+1/4, -x+3/4)',
                            '(-z+3/4, -x+3/4, -x+1/4)'), None),
                '96h': (2, ('(1/8, y, -y+1/4)', '(1/8, y+1/2, -y+3/4)',
                            '(5/8, y, -y+3/4)', '(5/8, y+1/2, -y+1/4)',
                            '(7/8, -y+1/2, -y+3/4)', '(7/8, -y, -y+1/4)',
                            '(3/8, -y+1/2, -y+1/4)', '(3/8, -y, -y+3/4)',
                            '(3/8, y+1/2, y+3/4)', '(3/8, y, y+1/4)',
                            '(7/8, y+1/2, y+1/4)', '(7/8, y, y+3/4)',
                            '(5/8, -y, y+1/4)', '(5/8, -y+1/2, y+3/4)',
                            '(1/8, -y, y+3/4)', '(1/8, -y+1/2, y+1/4)',
                            '(-y+1/4, 1/8, y)', '(-y+1/4, 5/8, y+1/2)',
                            '(-y+3/4, 1/8, y+1/2)', '(-y+3/4, 5/8, y)',
                            '(-y+3/4, 7/8, -y+1/2)', '(-y+3/4, 3/8, -y)',
                            '(-y+1/4, 7/8, -y)', '(-y+1/4, 3/8, -y+1/2)',
                            '(y+3/4, 3/8, y+1/2)', '(y+3/4, 7/8, y)',
                            '(y+1/4, 3/8, y)', '(y+1/4, 7/8, y+1/2)',
                            '(y+1/4, 5/8, -y)', '(y+1/4, 1/8, -y+1/2)',
                            '(y+3/4, 5/8, -y+1/2)', '(y+3/4, 1/8, -y)',
                            '(y, -y+1/4, 1/8)', '(y, -y+3/4, 5/8)',
                            '(y+1/2, -y+1/4, 5/8)', '(y+1/2, -y+3/4, 1/8)',
                            '(-y+1/2, -y+3/4, 7/8)', '(-y+1/2, -y+1/4, 3/8)',
                            '(-y, -y+3/4, 3/8)', '(-y, -y+1/4, 7/8)',
                            '(y+1/2, y+3/4, 3/8)', '(y+1/2, y+1/4, 7/8)',
                            '(y, y+3/4, 7/8)', '(y, y+1/4, 3/8)',
                            '(-y, y+1/4, 5/8)', '(-y, y+3/4, 1/8)',
                            '(-y+1/2, y+1/4, 1/8)', '(-y+1/2, y+3/4, 5/8)',
                            '(1/8, -y+1/4, y)', '(1/8, -y+3/4, y+1/2)',
                            '(5/8, -y+1/4, y+1/2)', '(5/8, -y+3/4, y)',
                            '(3/8, y+3/4, y+1/2)', '(3/8, y+1/4, y)',
                            '(7/8, y+3/4, y)', '(7/8, y+1/4, y+1/2)',
                            '(7/8, -y+3/4, -y+1/2)', '(7/8, -y+1/4, -y)',
                            '(3/8, -y+3/4, -y)', '(3/8, -y+1/4, -y+1/2)',
                            '(5/8, y+1/4, -y)', '(5/8, y+3/4, -y+1/2)',
                            '(1/8, y+1/4, -y+1/2)', '(1/8, y+3/4, -y)',
                            '(y, 1/8, -y+1/4)', '(y, 5/8, -y+3/4)',
                            '(y+1/2, 1/8, -y+3/4)', '(y+1/2, 5/8, -y+1/4)',
                            '(y+1/2, 3/8, y+3/4)', '(y+1/2, 7/8, y+1/4)',
                            '(y, 3/8, y+1/4)', '(y, 7/8, y+3/4)',
                            '(-y+1/2, 7/8, -y+3/4)', '(-y+1/2, 3/8, -y+1/4)',
                            '(-y, 7/8, -y+1/4)', '(-y, 3/8, -y+3/4)',
                            '(-y, 5/8, y+1/4)', '(-y, 1/8, y+3/4)',
                            '(-y+1/2, 5/8, y+3/4)', '(-y+1/2, 1/8, y+1/4)',
                            '(-y+1/4, y, 1/8)', '(-y+1/4, y+1/2, 5/8)',
                            '(-y+3/4, y, 5/8)', '(-y+3/4, y+1/2, 1/8)',
                            '(y+3/4, y+1/2, 3/8)', '(y+3/4, y, 7/8)',
                            '(y+1/4, y+1/2, 7/8)', '(y+1/4, y, 3/8)',
                            '(-y+3/4, -y+1/2, 7/8)', '(-y+3/4, -y, 3/8)',
                            '(-y+1/4, -y+1/2, 3/8)', '(-y+1/4, -y, 7/8)',
                            '(y+1/4, -y, 5/8)', '(y+1/4, -y+1/2, 1/8)',
                            '(y+3/4, -y, 1/8)', '(y+3/4, -y+1/2, 5/8)'), None
                        ),
                '192i': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)',
                             '(x+1/2, y, z+1/2)', '(x+1/2, y+1/2, z)',
                             '(-x, -y+1/2, z+1/2)', '(-x, -y, z)',
                             '(-x+1/2, -y+1/2, z)', '(-x+1/2, -y, z+1/2)',
                             '(-x+1/2, y+1/2, -z)', '(-x+1/2, y, -z+1/2)',
                             '(-x, y+1/2, -z+1/2)', '(-x, y, -z)',
                             '(x+1/2, -y, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                             '(x, -y, -z)', '(x, -y+1/2, -z+1/2)',
                             '(z, x, y)', '(z, x+1/2, y+1/2)',
                             '(z+1/2, x, y+1/2)', '(z+1/2, x+1/2, y)',
                             '(z+1/2, -x, -y+1/2)', '(z+1/2, -x+1/2, -y)',
                             '(z, -x, -y)', '(z, -x+1/2, -y+1/2)',
                             '(-z, -x+1/2, y+1/2)', '(-z, -x, y)',
                             '(-z+1/2, -x+1/2, y)', '(-z+1/2, -x, y+1/2)',
                             '(-z+1/2, x+1/2, -y)', '(-z+1/2, x, -y+1/2)',
                             '(-z, x+1/2, -y+1/2)', '(-z, x, -y)',
                             '(y, z, x)', '(y, z+1/2, x+1/2)',
                             '(y+1/2, z, x+1/2)', '(y+1/2, z+1/2, x)',
                             '(-y+1/2, z+1/2, -x)', '(-y+1/2, z, -x+1/2)',
                             '(-y, z+1/2, -x+1/2)', '(-y, z, -x)',
                             '(y+1/2, -z, -x+1/2)', '(y+1/2, -z+1/2, -x)',
                             '(y, -z, -x)', '(y, -z+1/2, -x+1/2)',
                             '(-y, -z+1/2, x+1/2)', '(-y, -z, x)',
                             '(-y+1/2, -z+1/2, x)', '(-y+1/2, -z, x+1/2)',
                             '(y+3/4, x+1/4, -z+3/4)',
                             '(y+3/4, x+3/4, -z+1/4)',
                             '(y+1/4, x+1/4, -z+1/4)',
                             '(y+1/4, x+3/4, -z+3/4)',
                             '(-y+1/4, -x+1/4, -z+1/4)',
                             '(-y+1/4, -x+3/4, -z+3/4)',
                             '(-y+3/4, -x+1/4, -z+3/4)',
                             '(-y+3/4, -x+3/4, -z+1/4)',
                             '(y+1/4, -x+3/4, z+3/4)',
                             '(y+1/4, -x+1/4, z+1/4)',
                             '(y+3/4, -x+3/4, z+1/4)',
                             '(y+3/4, -x+1/4, z+3/4)',
                             '(-y+3/4, x+3/4, z+1/4)',
                             '(-y+3/4, x+1/4, z+3/4)',
                             '(-y+1/4, x+3/4, z+3/4)',
                             '(-y+1/4, x+1/4, z+1/4)',
                             '(x+3/4, z+1/4, -y+3/4)',
                             '(x+3/4, z+3/4, -y+1/4)',
                             '(x+1/4, z+1/4, -y+1/4)',
                             '(x+1/4, z+3/4, -y+3/4)',
                             '(-x+3/4, z+3/4, y+1/4)',
                             '(-x+3/4, z+1/4, y+3/4)',
                             '(-x+1/4, z+3/4, y+3/4)',
                             '(-x+1/4, z+1/4, y+1/4)',
                             '(-x+1/4, -z+1/4, -y+1/4)',
                             '(-x+1/4, -z+3/4, -y+3/4)',
                             '(-x+3/4, -z+1/4, -y+3/4)',
                             '(-x+3/4, -z+3/4, -y+1/4)',
                             '(x+1/4, -z+3/4, y+3/4)',
                             '(x+1/4, -z+1/4, y+1/4)',
                             '(x+3/4, -z+3/4, y+1/4)',
                             '(x+3/4, -z+1/4, y+3/4)',
                             '(z+3/4, y+1/4, -x+3/4)',
                             '(z+3/4, y+3/4, -x+1/4)',
                             '(z+1/4, y+1/4, -x+1/4)',
                             '(z+1/4, y+3/4, -x+3/4)',
                             '(z+1/4, -y+3/4, x+3/4)',
                             '(z+1/4, -y+1/4, x+1/4)',
                             '(z+3/4, -y+3/4, x+1/4)',
                             '(z+3/4, -y+1/4, x+3/4)',
                             '(-z+3/4, y+3/4, x+1/4)',
                             '(-z+3/4, y+1/4, x+3/4)',
                             '(-z+1/4, y+3/4, x+3/4)',
                             '(-z+1/4, y+1/4, x+1/4)',
                             '(-z+1/4, -y+1/4, -x+1/4)',
                             '(-z+1/4, -y+3/4, -x+3/4)',
                             '(-z+3/4, -y+1/4, -x+3/4)',
                             '(-z+3/4, -y+3/4, -x+1/4)',
                             '(-x+1/4, -y+1/4, -z+1/4)',
                             '(-x+1/4, -y+3/4, -z+3/4)',
                             '(-x+3/4, -y+1/4, -z+3/4)',
                             '(-x+3/4, -y+3/4, -z+1/4)',
                             '(x+1/4, y+3/4, -z+3/4)',
                             '(x+1/4, y+1/4, -z+1/4)',
                             '(x+3/4, y+3/4, -z+1/4)',
                             '(x+3/4, y+1/4, -z+3/4)',
                             '(x+3/4, -y+3/4, z+1/4)',
                             '(x+3/4, -y+1/4, z+3/4)',
                             '(x+1/4, -y+3/4, z+3/4)',
                             '(x+1/4, -y+1/4, z+1/4)',
                             '(-x+3/4, y+1/4, z+3/4)',
                             '(-x+3/4, y+3/4, z+1/4)',
                             '(-x+1/4, y+1/4, z+1/4)',
                             '(-x+1/4, y+3/4, z+3/4)',
                             '(-z+1/4, -x+1/4, -y+1/4)',
                             '(-z+1/4, -x+3/4, -y+3/4)',
                             '(-z+3/4, -x+1/4, -y+3/4)',
                             '(-z+3/4, -x+3/4, -y+1/4)',
                             '(-z+3/4, x+1/4, y+3/4)',
                             '(-z+3/4, x+3/4, y+1/4)',
                             '(-z+1/4, x+1/4, y+1/4)',
                             '(-z+1/4, x+3/4, y+3/4)',
                             '(z+1/4, x+3/4, -y+3/4)',
                             '(z+1/4, x+1/4, -y+1/4)',
                             '(z+3/4, x+3/4, -y+1/4)',
                             '(z+3/4, x+1/4, -y+3/4)',
                             '(z+3/4, -x+3/4, y+1/4)',
                             '(z+3/4, -x+1/4, y+3/4)',
                             '(z+1/4, -x+3/4, y+3/4)',
                             '(z+1/4, -x+1/4, y+1/4)',
                             '(-y+1/4, -z+1/4, -x+1/4)',
                             '(-y+1/4, -z+3/4, -x+3/4)',
                             '(-y+3/4, -z+1/4, -x+3/4)',
                             '(-y+3/4, -z+3/4, -x+1/4)',
                             '(y+3/4, -z+3/4, x+1/4)',
                             '(y+3/4, -z+1/4, x+3/4)',
                             '(y+1/4, -z+3/4, x+3/4)',
                             '(y+1/4, -z+1/4, x+1/4)',
                             '(-y+3/4, z+1/4, x+3/4)',
                             '(-y+3/4, z+3/4, x+1/4)',
                             '(-y+1/4, z+1/4, x+1/4)',
                             '(-y+1/4, z+3/4, x+3/4)',
                             '(y+1/4, z+3/4, -x+3/4)',
                             '(y+1/4, z+1/4, -x+1/4)',
                             '(y+3/4, z+3/4, -x+1/4)',
                             '(y+3/4, z+1/4, -x+3/4)', '(-y+1/2, -x, z+1/2)',
                             '(-y+1/2, -x+1/2, z)', '(-y, -x, z)',
                             '(-y, -x+1/2, z+1/2)', '(y, x, z)',
                             '(y, x+1/2, z+1/2)', '(y+1/2, x, z+1/2)',
                             '(y+1/2, x+1/2, z)', '(-y, x+1/2, -z+1/2)',
                             '(-y, x, -z)', '(-y+1/2, x+1/2, -z)',
                             '(-y+1/2, x, -z+1/2)', '(y+1/2, -x+1/2, -z)',
                             '(y+1/2, -x, -z+1/2)', '(y, -x+1/2, -z+1/2)',
                             '(y, -x, -z)', '(-x+1/2, -z, y+1/2)',
                             '(-x+1/2, -z+1/2, y)', '(-x, -z, y)',
                             '(-x, -z+1/2, y+1/2)', '(x+1/2, -z+1/2, -y)',
                             '(x+1/2, -z, -y+1/2)', '(x, -z+1/2, -y+1/2)',
                             '(x, -z, -y)', '(x, z, y)', '(x, z+1/2, y+1/2)',
                             '(x+1/2, z, y+1/2)', '(x+1/2, z+1/2, y)',
                             '(-x, z+1/2, -y+1/2)', '(-x, z, -y)',
                             '(-x+1/2, z+1/2, -y)', '(-x+1/2, z, -y+1/2)',
                             '(-z+1/2, -y, x+1/2)', '(-z+1/2, -y+1/2, x)',
                             '(-z, -y, x)', '(-z, -y+1/2, x+1/2)',
                             '(-z, y+1/2, -x+1/2)', '(-z, y, -x)',
                             '(-z+1/2, y+1/2, -x)', '(-z+1/2, y, -x+1/2)',
                             '(z+1/2, -y+1/2, -x)', '(z+1/2, -y, -x+1/2)',
                             '(z, -y+1/2, -x+1/2)', '(z, -y, -x)',
                             '(z, y, x)', '(z, y+1/2, x+1/2)',
                             '(z+1/2, y, x+1/2)', '(z+1/2, y+1/2, x)'),
                         'hkl: h+k=2n, h+l,k+l=2n, 0kl: k+l=4n, k,l=2n, '
                         'hhl: h+l=2n, h00: h=4n')},
      '227:2': {'8a': (0, ('(1/8, 1/8, 1/8)', '(1/8, 5/8, 5/8)',
                           '(5/8, 1/8, 5/8)', '(5/8, 5/8, 1/8)',
                           '(7/8, 3/8, 3/8)', '(7/8, 7/8, 7/8)',
                           '(3/8, 3/8, 7/8)', '(3/8, 7/8, 3/8)'), 'n/a'),
                '8b': (0, ('(3/8, 3/8, 3/8)', '(3/8, 7/8, 7/8)',
                           '(7/8, 3/8, 7/8)', '(7/8, 7/8, 3/8)',
                           '(1/8, 5/8, 1/8)', '(1/8, 1/8, 5/8)',
                           '(5/8, 5/8, 5/8)', '(5/8, 1/8, 1/8)'), 'n/a'),
                '16c': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                            '(1/2, 1/2, 0)', '(3/4, 1/4, 1/2)',
                            '(3/4, 3/4, 0)', '(1/4, 1/4, 0)',
                            '(1/4, 3/4, 1/2)', '(1/4, 1/2, 3/4)',
                            '(1/4, 0, 1/4)', '(3/4, 1/2, 1/4)',
                            '(3/4, 0, 3/4)', '(1/2, 3/4, 1/4)',
                            '(1/2, 1/4, 3/4)', '(0, 3/4, 3/4)',
                            '(0, 1/4, 1/4)'), 'n/a'),
                '16d': (0, ('(1/2, 1/2, 1/2)', '(1/2, 0, 0)', '(0, 1/2, 0)',
                            '(0, 0, 1/2)', '(1/4, 3/4, 0)', '(1/4, 1/4, 1/2)',
                            '(3/4, 3/4, 1/2)', '(3/4, 1/4, 0)',
                            '(3/4, 0, 1/4)', '(3/4, 1/2, 3/4)',
                            '(1/4, 0, 3/4)', '(1/4, 1/2, 1/4)',
                            '(0, 1/4, 3/4)', '(0, 3/4, 1/4)',
                            '(1/2, 1/4, 1/4)', '(1/2, 3/4, 3/4)'), 'n/a'),
                '32e': (1, ('(x, x, x)', '(x, x+1/2, x+1/2)',
                            '(x+1/2, x, x+1/2)', '(x+1/2, x+1/2, x)',
                            '(-x+3/4, -x+1/4, x+1/2)', '(-x+3/4, -x+3/4, x)',
                            '(-x+1/4, -x+1/4, x)', '(-x+1/4, -x+3/4, x+1/2)',
                            '(-x+1/4, x+1/2, -x+3/4)', '(-x+1/4, x, -x+1/4)',
                            '(-x+3/4, x+1/2, -x+1/4)', '(-x+3/4, x, -x+3/4)',
                            '(x+1/2, -x+3/4, -x+1/4)',
                            '(x+1/2, -x+1/4, -x+3/4)', '(x, -x+3/4, -x+3/4)',
                            '(x, -x+1/4, -x+1/4)', '(x+3/4, x+1/4, -x+1/2)',
                            '(x+3/4, x+3/4, -x)', '(x+1/4, x+1/4, -x)',
                            '(x+1/4, x+3/4, -x+1/2)', '(-x, -x, -x)',
                            '(-x, -x+1/2, -x+1/2)', '(-x+1/2, -x, -x+1/2)',
                            '(-x+1/2, -x+1/2, -x)', '(x+1/4, -x+1/2, x+3/4)',
                            '(x+1/4, -x, x+1/4)', '(x+3/4, -x+1/2, x+1/4)',
                            '(x+3/4, -x, x+3/4)', '(-x+1/2, x+3/4, x+1/4)',
                            '(-x+1/2, x+1/4, x+3/4)', '(-x, x+3/4, x+3/4)',
                            '(-x, x+1/4, x+1/4)'), 'n/a'),
                '48f': (1, ('(x, 1/8, 1/8)', '(x, 5/8, 5/8)',
                            '(x+1/2, 1/8, 5/8)', '(x+1/2, 5/8, 1/8)',
                            '(-x+3/4, 1/8, 5/8)', '(-x+3/4, 5/8, 1/8)',
                            '(-x+1/4, 1/8, 1/8)', '(-x+1/4, 5/8, 5/8)',
                            '(1/8, x, 1/8)', '(1/8, x+1/2, 5/8)',
                            '(5/8, x, 5/8)', '(5/8, x+1/2, 1/8)',
                            '(5/8, -x+3/4, 1/8)', '(5/8, -x+1/4, 5/8)',
                            '(1/8, -x+3/4, 5/8)', '(1/8, -x+1/4, 1/8)',
                            '(1/8, 1/8, x)', '(1/8, 5/8, x+1/2)',
                            '(5/8, 1/8, x+1/2)', '(5/8, 5/8, x)',
                            '(1/8, 5/8, -x+3/4)', '(1/8, 1/8, -x+1/4)',
                            '(5/8, 5/8, -x+1/4)', '(5/8, 1/8, -x+3/4)',
                            '(7/8, x+1/4, 3/8)', '(7/8, x+3/4, 7/8)',
                            '(3/8, x+1/4, 7/8)', '(3/8, x+3/4, 3/8)',
                            '(7/8, -x, 7/8)', '(7/8, -x+1/2, 3/8)',
                            '(3/8, -x, 3/8)', '(3/8, -x+1/2, 7/8)',
                            '(x+3/4, 3/8, 3/8)', '(x+3/4, 7/8, 7/8)',
                            '(x+1/4, 3/8, 7/8)', '(x+1/4, 7/8, 3/8)',
                            '(-x+1/2, 7/8, 3/8)', '(-x+1/2, 3/8, 7/8)',
                            '(-x, 7/8, 7/8)', '(-x, 3/8, 3/8)',
                            '(7/8, 3/8, -x+1/2)', '(7/8, 7/8, -x)',
                            '(3/8, 3/8, -x)', '(3/8, 7/8, -x+1/2)',
                            '(3/8, 3/8, x+3/4)', '(3/8, 7/8, x+1/4)',
                            '(7/8, 3/8, x+1/4)', '(7/8, 7/8, x+3/4)'), 'n/a'),
                '96g': (5, ('(x, x, z)', '(x, x+1/2, z+1/2)',
                            '(x+1/2, x, z+1/2)', '(x+1/2, x+1/2, z)',
                            '(-x+3/4, -x+1/4, z+1/2)', '(-x+3/4, -x+3/4, z)',
                            '(-x+1/4, -x+1/4, z)', '(-x+1/4, -x+3/4, z+1/2)',
                            '(-x+1/4, x+1/2, -z+3/4)', '(-x+1/4, x, -z+1/4)',
                            '(-x+3/4, x+1/2, -z+1/4)', '(-x+3/4, x, -z+3/4)',
                            '(x+1/2, -x+3/4, -z+1/4)',
                            '(x+1/2, -x+1/4, -z+3/4)', '(x, -x+3/4, -z+3/4)',
                            '(x, -x+1/4, -z+1/4)', '(z, x, x)',
                            '(z, x+1/2, x+1/2)', '(z+1/2, x, x+1/2)',
                            '(z+1/2, x+1/2, x)', '(z+1/2, -x+3/4, -x+1/4)',
                            '(z+1/2, -x+1/4, -x+3/4)', '(z, -x+3/4, -x+3/4)',
                            '(z, -x+1/4, -x+1/4)', '(-z+3/4, -x+1/4, x+1/2)',
                            '(-z+3/4, -x+3/4, x)', '(-z+1/4, -x+1/4, x)',
                            '(-z+1/4, -x+3/4, x+1/2)',
                            '(-z+1/4, x+1/2, -x+3/4)', '(-z+1/4, x, -x+1/4)',
                            '(-z+3/4, x+1/2, -x+1/4)', '(-z+3/4, x, -x+3/4)',
                            '(x, z, x)', '(x, z+1/2, x+1/2)',
                            '(x+1/2, z, x+1/2)', '(x+1/2, z+1/2, x)',
                            '(-x+1/4, z+1/2, -x+3/4)', '(-x+1/4, z, -x+1/4)',
                            '(-x+3/4, z+1/2, -x+1/4)', '(-x+3/4, z, -x+3/4)',
                            '(x+1/2, -z+3/4, -x+1/4)',
                            '(x+1/2, -z+1/4, -x+3/4)', '(x, -z+3/4, -x+3/4)',
                            '(x, -z+1/4, -x+1/4)', '(-x+3/4, -z+1/4, x+1/2)',
                            '(-x+3/4, -z+3/4, x)', '(-x+1/4, -z+1/4, x)',
                            '(-x+1/4, -z+3/4, x+1/2)',
                            '(x+3/4, x+1/4, -z+1/2)', '(x+3/4, x+3/4, -z)',
                            '(x+1/4, x+1/4, -z)', '(x+1/4, x+3/4, -z+1/2)',
                            '(-x, -x, -z)', '(-x, -x+1/2, -z+1/2)',
                            '(-x+1/2, -x, -z+1/2)', '(-x+1/2, -x+1/2, -z)',
                            '(x+1/4, -x+1/2, z+3/4)', '(x+1/4, -x, z+1/4)',
                            '(x+3/4, -x+1/2, z+1/4)', '(x+3/4, -x, z+3/4)',
                            '(-x+1/2, x+3/4, z+1/4)',
                            '(-x+1/2, x+1/4, z+3/4)', '(-x, x+3/4, z+3/4)',
                            '(-x, x+1/4, z+1/4)', '(x+3/4, z+1/4, -x+1/2)',
                            '(x+3/4, z+3/4, -x)', '(x+1/4, z+1/4, -x)',
                            '(x+1/4, z+3/4, -x+1/2)',
                            '(-x+1/2, z+3/4, x+1/4)',
                            '(-x+1/2, z+1/4, x+3/4)', '(-x, z+3/4, x+3/4)',
                            '(-x, z+1/4, x+1/4)', '(-x, -z, -x)',
                            '(-x, -z+1/2, -x+1/2)', '(-x+1/2, -z, -x+1/2)',
                            '(-x+1/2, -z+1/2, -x)', '(x+1/4, -z+1/2, x+3/4)',
                            '(x+1/4, -z, x+1/4)', '(x+3/4, -z+1/2, x+1/4)',
                            '(x+3/4, -z, x+3/4)', '(z+3/4, x+1/4, -x+1/2)',
                            '(z+3/4, x+3/4, -x)', '(z+1/4, x+1/4, -x)',
                            '(z+1/4, x+3/4, -x+1/2)',
                            '(z+1/4, -x+1/2, x+3/4)', '(z+1/4, -x, x+1/4)',
                            '(z+3/4, -x+1/2, x+1/4)', '(z+3/4, -x, x+3/4)',
                            '(-z+1/2, x+3/4, x+1/4)',
                            '(-z+1/2, x+1/4, x+3/4)', '(-z, x+3/4, x+3/4)',
                            '(-z, x+1/4, x+1/4)', '(-z, -x, -x)',
                            '(-z, -x+1/2, -x+1/2)', '(-z+1/2, -x, -x+1/2)',
                            '(-z+1/2, -x+1/2, -x)'), 'n/a'),
                '96h': (2, ('(0, y, -y)', '(0, y+1/2, -y+1/2)',
                            '(1/2, y, -y+1/2)', '(1/2, y+1/2, -y)',
                            '(3/4, -y+1/4, -y+1/2)', '(3/4, -y+3/4, -y)',
                            '(1/4, -y+1/4, -y)', '(1/4, -y+3/4, -y+1/2)',
                            '(1/4, y+1/2, y+3/4)', '(1/4, y, y+1/4)',
                            '(3/4, y+1/2, y+1/4)', '(3/4, y, y+3/4)',
                            '(1/2, -y+3/4, y+1/4)', '(1/2, -y+1/4, y+3/4)',
                            '(0, -y+3/4, y+3/4)', '(0, -y+1/4, y+1/4)',
                            '(-y, 0, y)', '(-y, 1/2, y+1/2)',
                            '(-y+1/2, 0, y+1/2)', '(-y+1/2, 1/2, y)',
                            '(-y+1/2, 3/4, -y+1/4)', '(-y+1/2, 1/4, -y+3/4)',
                            '(-y, 3/4, -y+3/4)', '(-y, 1/4, -y+1/4)',
                            '(y+3/4, 1/4, y+1/2)', '(y+3/4, 3/4, y)',
                            '(y+1/4, 1/4, y)', '(y+1/4, 3/4, y+1/2)',
                            '(y+1/4, 1/2, -y+3/4)', '(y+1/4, 0, -y+1/4)',
                            '(y+3/4, 1/2, -y+1/4)', '(y+3/4, 0, -y+3/4)',
                            '(y, -y, 0)', '(y, -y+1/2, 1/2)',
                            '(y+1/2, -y, 1/2)', '(y+1/2, -y+1/2, 0)',
                            '(-y+1/4, -y+1/2, 3/4)', '(-y+1/4, -y, 1/4)',
                            '(-y+3/4, -y+1/2, 1/4)', '(-y+3/4, -y, 3/4)',
                            '(y+1/2, y+3/4, 1/4)', '(y+1/2, y+1/4, 3/4)',
                            '(y, y+3/4, 3/4)', '(y, y+1/4, 1/4)',
                            '(-y+3/4, y+1/4, 1/2)', '(-y+3/4, y+3/4, 0)',
                            '(-y+1/4, y+1/4, 0)', '(-y+1/4, y+3/4, 1/2)',
                            '(0, -y, y)', '(0, -y+1/2, y+1/2)',
                            '(1/2, -y, y+1/2)', '(1/2, -y+1/2, y)',
                            '(1/4, y+3/4, y+1/2)', '(1/4, y+1/4, y)',
                            '(3/4, y+3/4, y)', '(3/4, y+1/4, y+1/2)',
                            '(3/4, -y+1/2, -y+1/4)', '(3/4, -y, -y+3/4)',
                            '(1/4, -y+1/2, -y+3/4)', '(1/4, -y, -y+1/4)',
                            '(1/2, y+1/4, -y+3/4)', '(1/2, y+3/4, -y+1/4)',
                            '(0, y+1/4, -y+1/4)', '(0, y+3/4, -y+3/4)',
                            '(y, 0, -y)', '(y, 1/2, -y+1/2)',
                            '(y+1/2, 0, -y+1/2)', '(y+1/2, 1/2, -y)',
                            '(y+1/2, 1/4, y+3/4)', '(y+1/2, 3/4, y+1/4)',
                            '(y, 1/4, y+1/4)', '(y, 3/4, y+3/4)',
                            '(-y+1/4, 3/4, -y+1/2)', '(-y+1/4, 1/4, -y)',
                            '(-y+3/4, 3/4, -y)', '(-y+3/4, 1/4, -y+1/2)',
                            '(-y+3/4, 1/2, y+1/4)', '(-y+3/4, 0, y+3/4)',
                            '(-y+1/4, 1/2, y+3/4)', '(-y+1/4, 0, y+1/4)',
                            '(-y, y, 0)', '(-y, y+1/2, 1/2)',
                            '(-y+1/2, y, 1/2)', '(-y+1/2, y+1/2, 0)',
                            '(y+3/4, y+1/2, 1/4)', '(y+3/4, y, 3/4)',
                            '(y+1/4, y+1/2, 3/4)', '(y+1/4, y, 1/4)',
                            '(-y+1/2, -y+1/4, 3/4)', '(-y+1/2, -y+3/4, 1/4)',
                            '(-y, -y+1/4, 1/4)', '(-y, -y+3/4, 3/4)',
                            '(y+1/4, -y+3/4, 1/2)', '(y+1/4, -y+1/4, 0)',
                            '(y+3/4, -y+3/4, 0)', '(y+3/4, -y+1/4, 1/2)'),
                        'n/a'),
                '192i': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)',
                             '(x+1/2, y, z+1/2)', '(x+1/2, y+1/2, z)',
                             '(-x+3/4, -y+1/4, z+1/2)', '(-x+3/4, -y+3/4, z)',
                             '(-x+1/4, -y+1/4, z)', '(-x+1/4, -y+3/4, z+1/2)',
                             '(-x+1/4, y+1/2, -z+3/4)', '(-x+1/4, y, -z+1/4)',
                             '(-x+3/4, y+1/2, -z+1/4)', '(-x+3/4, y, -z+3/4)',
                             '(x+1/2, -y+3/4, -z+1/4)',
                             '(x+1/2, -y+1/4, -z+3/4)', '(x, -y+3/4, -z+3/4)',
                             '(x, -y+1/4, -z+1/4)', '(z, x, y)',
                             '(z, x+1/2, y+1/2)', '(z+1/2, x, y+1/2)',
                             '(z+1/2, x+1/2, y)', '(z+1/2, -x+3/4, -y+1/4)',
                             '(z+1/2, -x+1/4, -y+3/4)', '(z, -x+3/4, -y+3/4)',
                             '(z, -x+1/4, -y+1/4)', '(-z+3/4, -x+1/4, y+1/2)',
                             '(-z+3/4, -x+3/4, y)', '(-z+1/4, -x+1/4, y)',
                             '(-z+1/4, -x+3/4, y+1/2)',
                             '(-z+1/4, x+1/2, -y+3/4)', '(-z+1/4, x, -y+1/4)',
                             '(-z+3/4, x+1/2, -y+1/4)', '(-z+3/4, x, -y+3/4)',
                             '(y, z, x)', '(y, z+1/2, x+1/2)',
                             '(y+1/2, z, x+1/2)', '(y+1/2, z+1/2, x)',
                             '(-y+1/4, z+1/2, -x+3/4)', '(-y+1/4, z, -x+1/4)',
                             '(-y+3/4, z+1/2, -x+1/4)', '(-y+3/4, z, -x+3/4)',
                             '(y+1/2, -z+3/4, -x+1/4)',
                             '(y+1/2, -z+1/4, -x+3/4)', '(y, -z+3/4, -x+3/4)',
                             '(y, -z+1/4, -x+1/4)', '(-y+3/4, -z+1/4, x+1/2)',
                             '(-y+3/4, -z+3/4, x)', '(-y+1/4, -z+1/4, x)',
                             '(-y+1/4, -z+3/4, x+1/2)',
                             '(y+3/4, x+1/4, -z+1/2)', '(y+3/4, x+3/4, -z)',
                             '(y+1/4, x+1/4, -z)', '(y+1/4, x+3/4, -z+1/2)',
                             '(-y, -x, -z)', '(-y, -x+1/2, -z+1/2)',
                             '(-y+1/2, -x, -z+1/2)', '(-y+1/2, -x+1/2, -z)',
                             '(y+1/4, -x+1/2, z+3/4)', '(y+1/4, -x, z+1/4)',
                             '(y+3/4, -x+1/2, z+1/4)', '(y+3/4, -x, z+3/4)',
                             '(-y+1/2, x+3/4, z+1/4)',
                             '(-y+1/2, x+1/4, z+3/4)', '(-y, x+3/4, z+3/4)',
                             '(-y, x+1/4, z+1/4)', '(x+3/4, z+1/4, -y+1/2)',
                             '(x+3/4, z+3/4, -y)', '(x+1/4, z+1/4, -y)',
                             '(x+1/4, z+3/4, -y+1/2)',
                             '(-x+1/2, z+3/4, y+1/4)',
                             '(-x+1/2, z+1/4, y+3/4)', '(-x, z+3/4, y+3/4)',
                             '(-x, z+1/4, y+1/4)', '(-x, -z, -y)',
                             '(-x, -z+1/2, -y+1/2)', '(-x+1/2, -z, -y+1/2)',
                             '(-x+1/2, -z+1/2, -y)', '(x+1/4, -z+1/2, y+3/4)',
                             '(x+1/4, -z, y+1/4)', '(x+3/4, -z+1/2, y+1/4)',
                             '(x+3/4, -z, y+3/4)', '(z+3/4, y+1/4, -x+1/2)',
                             '(z+3/4, y+3/4, -x)', '(z+1/4, y+1/4, -x)',
                             '(z+1/4, y+3/4, -x+1/2)',
                             '(z+1/4, -y+1/2, x+3/4)', '(z+1/4, -y, x+1/4)',
                             '(z+3/4, -y+1/2, x+1/4)', '(z+3/4, -y, x+3/4)',
                             '(-z+1/2, y+3/4, x+1/4)',
                             '(-z+1/2, y+1/4, x+3/4)', '(-z, y+3/4, x+3/4)',
                             '(-z, y+1/4, x+1/4)', '(-z, -y, -x)',
                             '(-z, -y+1/2, -x+1/2)', '(-z+1/2, -y, -x+1/2)',
                             '(-z+1/2, -y+1/2, -x)', '(-x, -y, -z)',
                             '(-x, -y+1/2, -z+1/2)', '(-x+1/2, -y, -z+1/2)',
                             '(-x+1/2, -y+1/2, -z)', '(x+1/4, y+3/4, -z+1/2)',
                             '(x+1/4, y+1/4, -z)', '(x+3/4, y+3/4, -z)',
                             '(x+3/4, y+1/4, -z+1/2)',
                             '(x+3/4, -y+1/2, z+1/4)', '(x+3/4, -y, z+3/4)',
                             '(x+1/4, -y+1/2, z+3/4)', '(x+1/4, -y, z+1/4)',
                             '(-x+1/2, y+1/4, z+3/4)',
                             '(-x+1/2, y+3/4, z+1/4)', '(-x, y+1/4, z+1/4)',
                             '(-x, y+3/4, z+3/4)', '(-z, -x, -y)',
                             '(-z, -x+1/2, -y+1/2)', '(-z+1/2, -x, -y+1/2)',
                             '(-z+1/2, -x+1/2, -y)', '(-z+1/2, x+1/4, y+3/4)',
                             '(-z+1/2, x+3/4, y+1/4)', '(-z, x+1/4, y+1/4)',
                             '(-z, x+3/4, y+3/4)', '(z+1/4, x+3/4, -y+1/2)',
                             '(z+1/4, x+1/4, -y)', '(z+3/4, x+3/4, -y)',
                             '(z+3/4, x+1/4, -y+1/2)',
                             '(z+3/4, -x+1/2, y+1/4)', '(z+3/4, -x, y+3/4)',
                             '(z+1/4, -x+1/2, y+3/4)', '(z+1/4, -x, y+1/4)',
                             '(-y, -z, -x)', '(-y, -z+1/2, -x+1/2)',
                             '(-y+1/2, -z, -x+1/2)', '(-y+1/2, -z+1/2, -x)',
                             '(y+3/4, -z+1/2, x+1/4)', '(y+3/4, -z, x+3/4)',
                             '(y+1/4, -z+1/2, x+3/4)', '(y+1/4, -z, x+1/4)',
                             '(-y+1/2, z+1/4, x+3/4)',
                             '(-y+1/2, z+3/4, x+1/4)', '(-y, z+1/4, x+1/4)',
                             '(-y, z+3/4, x+3/4)', '(y+1/4, z+3/4, -x+1/2)',
                             '(y+1/4, z+1/4, -x)', '(y+3/4, z+3/4, -x)',
                             '(y+3/4, z+1/4, -x+1/2)',
                             '(-y+1/4, -x+3/4, z+1/2)', '(-y+1/4, -x+1/4, z)',
                             '(-y+3/4, -x+3/4, z)', '(-y+3/4, -x+1/4, z+1/2)',
                             '(y, x, z)', '(y, x+1/2, z+1/2)',
                             '(y+1/2, x, z+1/2)', '(y+1/2, x+1/2, z)',
                             '(-y+3/4, x+1/2, -z+1/4)', '(-y+3/4, x, -z+3/4)',
                             '(-y+1/4, x+1/2, -z+3/4)', '(-y+1/4, x, -z+1/4)',
                             '(y+1/2, -x+1/4, -z+3/4)',
                             '(y+1/2, -x+3/4, -z+1/4)', '(y, -x+1/4, -z+1/4)',
                             '(y, -x+3/4, -z+3/4)', '(-x+1/4, -z+3/4, y+1/2)',
                             '(-x+1/4, -z+1/4, y)', '(-x+3/4, -z+3/4, y)',
                             '(-x+3/4, -z+1/4, y+1/2)',
                             '(x+1/2, -z+1/4, -y+3/4)',
                             '(x+1/2, -z+3/4, -y+1/4)', '(x, -z+1/4, -y+1/4)',
                             '(x, -z+3/4, -y+3/4)', '(x, z, y)',
                             '(x, z+1/2, y+1/2)', '(x+1/2, z, y+1/2)',
                             '(x+1/2, z+1/2, y)', '(-x+3/4, z+1/2, -y+1/4)',
                             '(-x+3/4, z, -y+3/4)', '(-x+1/4, z+1/2, -y+3/4)',
                             '(-x+1/4, z, -y+1/4)', '(-z+1/4, -y+3/4, x+1/2)',
                             '(-z+1/4, -y+1/4, x)', '(-z+3/4, -y+3/4, x)',
                             '(-z+3/4, -y+1/4, x+1/2)',
                             '(-z+3/4, y+1/2, -x+1/4)', '(-z+3/4, y, -x+3/4)',
                             '(-z+1/4, y+1/2, -x+3/4)', '(-z+1/4, y, -x+1/4)',
                             '(z+1/2, -y+1/4, -x+3/4)',
                             '(z+1/2, -y+3/4, -x+1/4)', '(z, -y+1/4, -x+1/4)',
                             '(z, -y+3/4, -x+3/4)', '(z, y, x)',
                             '(z, y+1/2, x+1/2)', '(z+1/2, y, x+1/2)',
                             '(z+1/2, y+1/2, x)'), 'n/a')},
      '228:1': {'16a': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                            '(1/2, 1/2, 0)', '(3/4, 1/4, 3/4)',
                            '(3/4, 3/4, 1/4)', '(1/4, 1/4, 1/4)',
                            '(1/4, 3/4, 3/4)', '(3/4, 3/4, 3/4)',
                            '(3/4, 1/4, 1/4)', '(1/4, 3/4, 1/4)',
                            '(1/4, 1/4, 3/4)', '(0, 1/2, 0)', '(0, 0, 1/2)',
                            '(1/2, 1/2, 1/2)', '(1/2, 0, 0)'), 'hkl: h+k+l=4n'
                        ),
                '32b': (0, ('(1/8, 1/8, 1/8)', '(1/8, 5/8, 5/8)',
                            '(5/8, 1/8, 5/8)', '(5/8, 5/8, 1/8)',
                            '(7/8, 3/8, 5/8)', '(7/8, 7/8, 1/8)',
                            '(3/8, 3/8, 1/8)', '(3/8, 7/8, 5/8)',
                            '(3/8, 5/8, 7/8)', '(3/8, 1/8, 3/8)',
                            '(7/8, 5/8, 3/8)', '(7/8, 1/8, 7/8)',
                            '(5/8, 7/8, 3/8)', '(5/8, 3/8, 7/8)',
                            '(1/8, 7/8, 7/8)', '(1/8, 3/8, 3/8)',
                            '(5/8, 5/8, 5/8)', '(5/8, 1/8, 1/8)',
                            '(1/8, 5/8, 1/8)', '(1/8, 1/8, 5/8)',
                            '(7/8, 3/8, 1/8)', '(7/8, 7/8, 5/8)',
                            '(3/8, 3/8, 5/8)', '(3/8, 7/8, 1/8)',
                            '(3/8, 1/8, 7/8)', '(3/8, 5/8, 3/8)',
                            '(7/8, 1/8, 3/8)', '(7/8, 5/8, 7/8)',
                            '(1/8, 7/8, 3/8)', '(1/8, 3/8, 7/8)',
                            '(5/8, 7/8, 7/8)', '(5/8, 3/8, 3/8)'),
                        'hkl: h,k,l=4n+2 or h,k,l=4n'),
                '32c': (0, ('(3/8, 3/8, 3/8)', '(3/8, 7/8, 7/8)',
                            '(7/8, 3/8, 7/8)', '(7/8, 7/8, 3/8)',
                            '(5/8, 1/8, 7/8)', '(5/8, 5/8, 3/8)',
                            '(1/8, 1/8, 3/8)', '(1/8, 5/8, 7/8)',
                            '(1/8, 7/8, 5/8)', '(1/8, 3/8, 1/8)',
                            '(5/8, 7/8, 1/8)', '(5/8, 3/8, 5/8)',
                            '(7/8, 5/8, 1/8)', '(7/8, 1/8, 5/8)',
                            '(3/8, 5/8, 5/8)', '(3/8, 1/8, 1/8)',
                            '(1/8, 5/8, 3/8)', '(1/8, 1/8, 7/8)',
                            '(5/8, 5/8, 7/8)', '(5/8, 1/8, 3/8)',
                            '(7/8, 7/8, 7/8)', '(7/8, 3/8, 3/8)',
                            '(3/8, 7/8, 3/8)', '(3/8, 3/8, 7/8)',
                            '(5/8, 3/8, 1/8)', '(5/8, 7/8, 5/8)',
                            '(1/8, 3/8, 5/8)', '(1/8, 7/8, 1/8)',
                            '(3/8, 1/8, 5/8)', '(3/8, 5/8, 1/8)',
                            '(7/8, 1/8, 1/8)', '(7/8, 5/8, 5/8)'),
                        'hkl: h,k,l=4n+2 or h,k,l=4n'),
                '48d': (0, ('(1/4, 0, 0)', '(1/4, 1/2, 1/2)', '(3/4, 0, 1/2)',
                            '(3/4, 1/2, 0)', '(3/4, 1/2, 1/2)', '(3/4, 0, 0)',
                            '(1/4, 1/2, 0)', '(1/4, 0, 1/2)', '(0, 1/4, 0)',
                            '(0, 3/4, 1/2)', '(1/2, 1/4, 1/2)',
                            '(1/2, 3/4, 0)', '(1/2, 3/4, 1/2)',
                            '(1/2, 1/4, 0)', '(0, 3/4, 0)', '(0, 1/4, 1/2)',
                            '(0, 0, 1/4)', '(0, 1/2, 3/4)', '(1/2, 0, 3/4)',
                            '(1/2, 1/2, 1/4)', '(1/2, 1/2, 3/4)',
                            '(1/2, 0, 1/4)', '(0, 1/2, 1/4)', '(0, 0, 3/4)',
                            '(3/4, 1/2, 3/4)', '(3/4, 0, 1/4)',
                            '(1/4, 1/2, 1/4)', '(1/4, 0, 3/4)',
                            '(1/4, 0, 1/4)', '(1/4, 1/2, 3/4)',
                            '(3/4, 0, 3/4)', '(3/4, 1/2, 1/4)',
                            '(0, 1/4, 3/4)', '(0, 3/4, 1/4)',
                            '(1/2, 1/4, 1/4)', '(1/2, 3/4, 3/4)',
                            '(1/2, 3/4, 1/4)', '(1/2, 1/4, 3/4)',
                            '(0, 3/4, 3/4)', '(0, 1/4, 1/4)',
                            '(3/4, 1/4, 1/2)', '(3/4, 3/4, 0)',
                            '(1/4, 1/4, 0)', '(1/4, 3/4, 1/2)',
                            '(1/4, 3/4, 0)', '(1/4, 1/4, 1/2)',
                            '(3/4, 3/4, 1/2)', '(3/4, 1/4, 0)'),
                        'hkl: h+k+l=4n'),
                '64e': (1, ('(x, x, x)', '(x, x+1/2, x+1/2)',
                            '(x+1/2, x, x+1/2)', '(x+1/2, x+1/2, x)',
                            '(-x, -x+1/2, x+1/2)', '(-x, -x, x)',
                            '(-x+1/2, -x+1/2, x)', '(-x+1/2, -x, x+1/2)',
                            '(-x+1/2, x+1/2, -x)', '(-x+1/2, x, -x+1/2)',
                            '(-x, x+1/2, -x+1/2)', '(-x, x, -x)',
                            '(x+1/2, -x, -x+1/2)', '(x+1/2, -x+1/2, -x)',
                            '(x, -x, -x)', '(x, -x+1/2, -x+1/2)',
                            '(x+3/4, x+1/4, -x+3/4)',
                            '(x+3/4, x+3/4, -x+1/4)',
                            '(x+1/4, x+1/4, -x+1/4)',
                            '(x+1/4, x+3/4, -x+3/4)',
                            '(-x+1/4, -x+1/4, -x+1/4)',
                            '(-x+1/4, -x+3/4, -x+3/4)',
                            '(-x+3/4, -x+1/4, -x+3/4)',
                            '(-x+3/4, -x+3/4, -x+1/4)',
                            '(x+1/4, -x+3/4, x+3/4)',
                            '(x+1/4, -x+1/4, x+1/4)',
                            '(x+3/4, -x+3/4, x+1/4)',
                            '(x+3/4, -x+1/4, x+3/4)',
                            '(-x+3/4, x+3/4, x+1/4)',
                            '(-x+3/4, x+1/4, x+3/4)',
                            '(-x+1/4, x+3/4, x+3/4)',
                            '(-x+1/4, x+1/4, x+1/4)',
                            '(-x+3/4, -x+3/4, -x+3/4)',
                            '(-x+3/4, -x+1/4, -x+1/4)',
                            '(-x+1/4, -x+3/4, -x+1/4)',
                            '(-x+1/4, -x+1/4, -x+3/4)',
                            '(x+3/4, x+1/4, -x+1/4)',
                            '(x+3/4, x+3/4, -x+3/4)',
                            '(x+1/4, x+1/4, -x+3/4)',
                            '(x+1/4, x+3/4, -x+1/4)',
                            '(x+1/4, -x+1/4, x+3/4)',
                            '(x+1/4, -x+3/4, x+1/4)',
                            '(x+3/4, -x+1/4, x+1/4)',
                            '(x+3/4, -x+3/4, x+3/4)',
                            '(-x+1/4, x+3/4, x+1/4)',
                            '(-x+1/4, x+1/4, x+3/4)',
                            '(-x+3/4, x+3/4, x+3/4)',
                            '(-x+3/4, x+1/4, x+1/4)', '(-x, -x+1/2, x)',
                            '(-x, -x, x+1/2)', '(-x+1/2, -x+1/2, x+1/2)',
                            '(-x+1/2, -x, x)', '(x+1/2, x+1/2, x+1/2)',
                            '(x+1/2, x, x)', '(x, x+1/2, x)', '(x, x, x+1/2)',
                            '(-x+1/2, x, -x)', '(-x+1/2, x+1/2, -x+1/2)',
                            '(-x, x, -x+1/2)', '(-x, x+1/2, -x)',
                            '(x, -x, -x+1/2)', '(x, -x+1/2, -x)',
                            '(x+1/2, -x, -x)', '(x+1/2, -x+1/2, -x+1/2)'),
                        'hkl: h=2n'),
                '96f': (1, ('(x, 0, 0)', '(x, 1/2, 1/2)', '(x+1/2, 0, 1/2)',
                            '(x+1/2, 1/2, 0)', '(-x, 1/2, 1/2)', '(-x, 0, 0)',
                            '(-x+1/2, 1/2, 0)', '(-x+1/2, 0, 1/2)',
                            '(0, x, 0)', '(0, x+1/2, 1/2)', '(1/2, x, 1/2)',
                            '(1/2, x+1/2, 0)', '(1/2, -x, 1/2)',
                            '(1/2, -x+1/2, 0)', '(0, -x, 0)',
                            '(0, -x+1/2, 1/2)', '(0, 0, x)',
                            '(0, 1/2, x+1/2)', '(1/2, 0, x+1/2)',
                            '(1/2, 1/2, x)', '(1/2, 1/2, -x)',
                            '(1/2, 0, -x+1/2)', '(0, 1/2, -x+1/2)',
                            '(0, 0, -x)', '(3/4, x+1/4, 3/4)',
                            '(3/4, x+3/4, 1/4)', '(1/4, x+1/4, 1/4)',
                            '(1/4, x+3/4, 3/4)', '(1/4, -x+1/4, 1/4)',
                            '(1/4, -x+3/4, 3/4)', '(3/4, -x+1/4, 3/4)',
                            '(3/4, -x+3/4, 1/4)', '(x+3/4, 1/4, 3/4)',
                            '(x+3/4, 3/4, 1/4)', '(x+1/4, 1/4, 1/4)',
                            '(x+1/4, 3/4, 3/4)', '(-x+3/4, 3/4, 1/4)',
                            '(-x+3/4, 1/4, 3/4)', '(-x+1/4, 3/4, 3/4)',
                            '(-x+1/4, 1/4, 1/4)', '(3/4, 1/4, -x+3/4)',
                            '(3/4, 3/4, -x+1/4)', '(1/4, 1/4, -x+1/4)',
                            '(1/4, 3/4, -x+3/4)', '(1/4, 3/4, x+3/4)',
                            '(1/4, 1/4, x+1/4)', '(3/4, 3/4, x+1/4)',
                            '(3/4, 1/4, x+3/4)', '(-x+3/4, 3/4, 3/4)',
                            '(-x+3/4, 1/4, 1/4)', '(-x+1/4, 3/4, 1/4)',
                            '(-x+1/4, 1/4, 3/4)', '(x+3/4, 1/4, 1/4)',
                            '(x+3/4, 3/4, 3/4)', '(x+1/4, 1/4, 3/4)',
                            '(x+1/4, 3/4, 1/4)', '(3/4, -x+3/4, 3/4)',
                            '(3/4, -x+1/4, 1/4)', '(1/4, -x+3/4, 1/4)',
                            '(1/4, -x+1/4, 3/4)', '(1/4, x+3/4, 1/4)',
                            '(1/4, x+1/4, 3/4)', '(3/4, x+3/4, 3/4)',
                            '(3/4, x+1/4, 1/4)', '(3/4, 3/4, -x+3/4)',
                            '(3/4, 1/4, -x+1/4)', '(1/4, 3/4, -x+1/4)',
                            '(1/4, 1/4, -x+3/4)', '(1/4, 1/4, x+3/4)',
                            '(1/4, 3/4, x+1/4)', '(3/4, 1/4, x+1/4)',
                            '(3/4, 3/4, x+3/4)', '(0, -x+1/2, 0)',
                            '(0, -x, 1/2)', '(1/2, -x+1/2, 1/2)',
                            '(1/2, -x, 0)', '(1/2, x+1/2, 1/2)',
                            '(1/2, x, 0)', '(0, x+1/2, 0)', '(0, x, 1/2)',
                            '(-x, 1/2, 0)', '(-x, 0, 1/2)',
                            '(-x+1/2, 1/2, 1/2)', '(-x+1/2, 0, 0)',
                            '(x, 0, 1/2)', '(x, 1/2, 0)', '(x+1/2, 0, 0)',
                            '(x+1/2, 1/2, 1/2)', '(0, 1/2, x)',
                            '(0, 0, x+1/2)', '(1/2, 1/2, x+1/2)',
                            '(1/2, 0, x)', '(1/2, 0, -x)',
                            '(1/2, 1/2, -x+1/2)', '(0, 0, -x+1/2)',
                            '(0, 1/2, -x)'), 'hkl: h+k+l=4n'),
                '96g': (2, ('(1/8, y, -y+1/4)', '(1/8, y+1/2, -y+3/4)',
                            '(5/8, y, -y+3/4)', '(5/8, y+1/2, -y+1/4)',
                            '(7/8, -y+1/2, -y+3/4)', '(7/8, -y, -y+1/4)',
                            '(3/8, -y+1/2, -y+1/4)', '(3/8, -y, -y+3/4)',
                            '(3/8, y+1/2, y+3/4)', '(3/8, y, y+1/4)',
                            '(7/8, y+1/2, y+1/4)', '(7/8, y, y+3/4)',
                            '(5/8, -y, y+1/4)', '(5/8, -y+1/2, y+3/4)',
                            '(1/8, -y, y+3/4)', '(1/8, -y+1/2, y+1/4)',
                            '(-y+1/4, 1/8, y)', '(-y+1/4, 5/8, y+1/2)',
                            '(-y+3/4, 1/8, y+1/2)', '(-y+3/4, 5/8, y)',
                            '(-y+3/4, 7/8, -y+1/2)', '(-y+3/4, 3/8, -y)',
                            '(-y+1/4, 7/8, -y)', '(-y+1/4, 3/8, -y+1/2)',
                            '(y+3/4, 3/8, y+1/2)', '(y+3/4, 7/8, y)',
                            '(y+1/4, 3/8, y)', '(y+1/4, 7/8, y+1/2)',
                            '(y+1/4, 5/8, -y)', '(y+1/4, 1/8, -y+1/2)',
                            '(y+3/4, 5/8, -y+1/2)', '(y+3/4, 1/8, -y)',
                            '(y, -y+1/4, 1/8)', '(y, -y+3/4, 5/8)',
                            '(y+1/2, -y+1/4, 5/8)', '(y+1/2, -y+3/4, 1/8)',
                            '(-y+1/2, -y+3/4, 7/8)', '(-y+1/2, -y+1/4, 3/8)',
                            '(-y, -y+3/4, 3/8)', '(-y, -y+1/4, 7/8)',
                            '(y+1/2, y+3/4, 3/8)', '(y+1/2, y+1/4, 7/8)',
                            '(y, y+3/4, 7/8)', '(y, y+1/4, 3/8)',
                            '(-y, y+1/4, 5/8)', '(-y, y+3/4, 1/8)',
                            '(-y+1/2, y+1/4, 1/8)', '(-y+1/2, y+3/4, 5/8)',
                            '(5/8, -y+3/4, y+1/2)', '(5/8, -y+1/4, y)',
                            '(1/8, -y+3/4, y)', '(1/8, -y+1/4, y+1/2)',
                            '(7/8, y+1/4, y)', '(7/8, y+3/4, y+1/2)',
                            '(3/8, y+1/4, y+1/2)', '(3/8, y+3/4, y)',
                            '(3/8, -y+1/4, -y)', '(3/8, -y+3/4, -y+1/2)',
                            '(7/8, -y+1/4, -y+1/2)', '(7/8, -y+3/4, -y)',
                            '(1/8, y+3/4, -y+1/2)', '(1/8, y+1/4, -y)',
                            '(5/8, y+3/4, -y)', '(5/8, y+1/4, -y+1/2)',
                            '(y+1/2, 5/8, -y+3/4)', '(y+1/2, 1/8, -y+1/4)',
                            '(y, 5/8, -y+1/4)', '(y, 1/8, -y+3/4)',
                            '(y, 7/8, y+1/4)', '(y, 3/8, y+3/4)',
                            '(y+1/2, 7/8, y+3/4)', '(y+1/2, 3/8, y+1/4)',
                            '(-y, 3/8, -y+1/4)', '(-y, 7/8, -y+3/4)',
                            '(-y+1/2, 3/8, -y+3/4)', '(-y+1/2, 7/8, -y+1/4)',
                            '(-y+1/2, 1/8, y+3/4)', '(-y+1/2, 5/8, y+1/4)',
                            '(-y, 1/8, y+1/4)', '(-y, 5/8, y+3/4)',
                            '(-y+3/4, y+1/2, 5/8)', '(-y+3/4, y, 1/8)',
                            '(-y+1/4, y+1/2, 1/8)', '(-y+1/4, y, 5/8)',
                            '(y+1/4, y, 7/8)', '(y+1/4, y+1/2, 3/8)',
                            '(y+3/4, y, 3/8)', '(y+3/4, y+1/2, 7/8)',
                            '(-y+1/4, -y, 3/8)', '(-y+1/4, -y+1/2, 7/8)',
                            '(-y+3/4, -y, 7/8)', '(-y+3/4, -y+1/2, 3/8)',
                            '(y+3/4, -y+1/2, 1/8)', '(y+3/4, -y, 5/8)',
                            '(y+1/4, -y+1/2, 5/8)', '(y+1/4, -y, 1/8)'), None
                        ),
                '192h': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)',
                             '(x+1/2, y, z+1/2)', '(x+1/2, y+1/2, z)',
                             '(-x, -y+1/2, z+1/2)', '(-x, -y, z)',
                             '(-x+1/2, -y+1/2, z)', '(-x+1/2, -y, z+1/2)',
                             '(-x+1/2, y+1/2, -z)', '(-x+1/2, y, -z+1/2)',
                             '(-x, y+1/2, -z+1/2)', '(-x, y, -z)',
                             '(x+1/2, -y, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                             '(x, -y, -z)', '(x, -y+1/2, -z+1/2)',
                             '(z, x, y)', '(z, x+1/2, y+1/2)',
                             '(z+1/2, x, y+1/2)', '(z+1/2, x+1/2, y)',
                             '(z+1/2, -x, -y+1/2)', '(z+1/2, -x+1/2, -y)',
                             '(z, -x, -y)', '(z, -x+1/2, -y+1/2)',
                             '(-z, -x+1/2, y+1/2)', '(-z, -x, y)',
                             '(-z+1/2, -x+1/2, y)', '(-z+1/2, -x, y+1/2)',
                             '(-z+1/2, x+1/2, -y)', '(-z+1/2, x, -y+1/2)',
                             '(-z, x+1/2, -y+1/2)', '(-z, x, -y)',
                             '(y, z, x)', '(y, z+1/2, x+1/2)',
                             '(y+1/2, z, x+1/2)', '(y+1/2, z+1/2, x)',
                             '(-y+1/2, z+1/2, -x)', '(-y+1/2, z, -x+1/2)',
                             '(-y, z+1/2, -x+1/2)', '(-y, z, -x)',
                             '(y+1/2, -z, -x+1/2)', '(y+1/2, -z+1/2, -x)',
                             '(y, -z, -x)', '(y, -z+1/2, -x+1/2)',
                             '(-y, -z+1/2, x+1/2)', '(-y, -z, x)',
                             '(-y+1/2, -z+1/2, x)', '(-y+1/2, -z, x+1/2)',
                             '(y+3/4, x+1/4, -z+3/4)',
                             '(y+3/4, x+3/4, -z+1/4)',
                             '(y+1/4, x+1/4, -z+1/4)',
                             '(y+1/4, x+3/4, -z+3/4)',
                             '(-y+1/4, -x+1/4, -z+1/4)',
                             '(-y+1/4, -x+3/4, -z+3/4)',
                             '(-y+3/4, -x+1/4, -z+3/4)',
                             '(-y+3/4, -x+3/4, -z+1/4)',
                             '(y+1/4, -x+3/4, z+3/4)',
                             '(y+1/4, -x+1/4, z+1/4)',
                             '(y+3/4, -x+3/4, z+1/4)',
                             '(y+3/4, -x+1/4, z+3/4)',
                             '(-y+3/4, x+3/4, z+1/4)',
                             '(-y+3/4, x+1/4, z+3/4)',
                             '(-y+1/4, x+3/4, z+3/4)',
                             '(-y+1/4, x+1/4, z+1/4)',
                             '(x+3/4, z+1/4, -y+3/4)',
                             '(x+3/4, z+3/4, -y+1/4)',
                             '(x+1/4, z+1/4, -y+1/4)',
                             '(x+1/4, z+3/4, -y+3/4)',
                             '(-x+3/4, z+3/4, y+1/4)',
                             '(-x+3/4, z+1/4, y+3/4)',
                             '(-x+1/4, z+3/4, y+3/4)',
                             '(-x+1/4, z+1/4, y+1/4)',
                             '(-x+1/4, -z+1/4, -y+1/4)',
                             '(-x+1/4, -z+3/4, -y+3/4)',
                             '(-x+3/4, -z+1/4, -y+3/4)',
                             '(-x+3/4, -z+3/4, -y+1/4)',
                             '(x+1/4, -z+3/4, y+3/4)',
                             '(x+1/4, -z+1/4, y+1/4)',
                             '(x+3/4, -z+3/4, y+1/4)',
                             '(x+3/4, -z+1/4, y+3/4)',
                             '(z+3/4, y+1/4, -x+3/4)',
                             '(z+3/4, y+3/4, -x+1/4)',
                             '(z+1/4, y+1/4, -x+1/4)',
                             '(z+1/4, y+3/4, -x+3/4)',
                             '(z+1/4, -y+3/4, x+3/4)',
                             '(z+1/4, -y+1/4, x+1/4)',
                             '(z+3/4, -y+3/4, x+1/4)',
                             '(z+3/4, -y+1/4, x+3/4)',
                             '(-z+3/4, y+3/4, x+1/4)',
                             '(-z+3/4, y+1/4, x+3/4)',
                             '(-z+1/4, y+3/4, x+3/4)',
                             '(-z+1/4, y+1/4, x+1/4)',
                             '(-z+1/4, -y+1/4, -x+1/4)',
                             '(-z+1/4, -y+3/4, -x+3/4)',
                             '(-z+3/4, -y+1/4, -x+3/4)',
                             '(-z+3/4, -y+3/4, -x+1/4)',
                             '(-x+3/4, -y+3/4, -z+3/4)',
                             '(-x+3/4, -y+1/4, -z+1/4)',
                             '(-x+1/4, -y+3/4, -z+1/4)',
                             '(-x+1/4, -y+1/4, -z+3/4)',
                             '(x+3/4, y+1/4, -z+1/4)',
                             '(x+3/4, y+3/4, -z+3/4)',
                             '(x+1/4, y+1/4, -z+3/4)',
                             '(x+1/4, y+3/4, -z+1/4)',
                             '(x+1/4, -y+1/4, z+3/4)',
                             '(x+1/4, -y+3/4, z+1/4)',
                             '(x+3/4, -y+1/4, z+1/4)',
                             '(x+3/4, -y+3/4, z+3/4)',
                             '(-x+1/4, y+3/4, z+1/4)',
                             '(-x+1/4, y+1/4, z+3/4)',
                             '(-x+3/4, y+3/4, z+3/4)',
                             '(-x+3/4, y+1/4, z+1/4)',
                             '(-z+3/4, -x+3/4, -y+3/4)',
                             '(-z+3/4, -x+1/4, -y+1/4)',
                             '(-z+1/4, -x+3/4, -y+1/4)',
                             '(-z+1/4, -x+1/4, -y+3/4)',
                             '(-z+1/4, x+3/4, y+1/4)',
                             '(-z+1/4, x+1/4, y+3/4)',
                             '(-z+3/4, x+3/4, y+3/4)',
                             '(-z+3/4, x+1/4, y+1/4)',
                             '(z+3/4, x+1/4, -y+1/4)',
                             '(z+3/4, x+3/4, -y+3/4)',
                             '(z+1/4, x+1/4, -y+3/4)',
                             '(z+1/4, x+3/4, -y+1/4)',
                             '(z+1/4, -x+1/4, y+3/4)',
                             '(z+1/4, -x+3/4, y+1/4)',
                             '(z+3/4, -x+1/4, y+1/4)',
                             '(z+3/4, -x+3/4, y+3/4)',
                             '(-y+3/4, -z+3/4, -x+3/4)',
                             '(-y+3/4, -z+1/4, -x+1/4)',
                             '(-y+1/4, -z+3/4, -x+1/4)',
                             '(-y+1/4, -z+1/4, -x+3/4)',
                             '(y+1/4, -z+1/4, x+3/4)',
                             '(y+1/4, -z+3/4, x+1/4)',
                             '(y+3/4, -z+1/4, x+1/4)',
                             '(y+3/4, -z+3/4, x+3/4)',
                             '(-y+1/4, z+3/4, x+1/4)',
                             '(-y+1/4, z+1/4, x+3/4)',
                             '(-y+3/4, z+3/4, x+3/4)',
                             '(-y+3/4, z+1/4, x+1/4)',
                             '(y+3/4, z+1/4, -x+1/4)',
                             '(y+3/4, z+3/4, -x+3/4)',
                             '(y+1/4, z+1/4, -x+3/4)',
                             '(y+1/4, z+3/4, -x+1/4)', '(-y, -x+1/2, z)',
                             '(-y, -x, z+1/2)', '(-y+1/2, -x+1/2, z+1/2)',
                             '(-y+1/2, -x, z)', '(y+1/2, x+1/2, z+1/2)',
                             '(y+1/2, x, z)', '(y, x+1/2, z)',
                             '(y, x, z+1/2)', '(-y+1/2, x, -z)',
                             '(-y+1/2, x+1/2, -z+1/2)', '(-y, x, -z+1/2)',
                             '(-y, x+1/2, -z)', '(y, -x, -z+1/2)',
                             '(y, -x+1/2, -z)', '(y+1/2, -x, -z)',
                             '(y+1/2, -x+1/2, -z+1/2)', '(-x, -z+1/2, y)',
                             '(-x, -z, y+1/2)', '(-x+1/2, -z+1/2, y+1/2)',
                             '(-x+1/2, -z, y)', '(x, -z, -y+1/2)',
                             '(x, -z+1/2, -y)', '(x+1/2, -z, -y)',
                             '(x+1/2, -z+1/2, -y+1/2)',
                             '(x+1/2, z+1/2, y+1/2)', '(x+1/2, z, y)',
                             '(x, z+1/2, y)', '(x, z, y+1/2)',
                             '(-x+1/2, z, -y)', '(-x+1/2, z+1/2, -y+1/2)',
                             '(-x, z, -y+1/2)', '(-x, z+1/2, -y)',
                             '(-z, -y+1/2, x)', '(-z, -y, x+1/2)',
                             '(-z+1/2, -y+1/2, x+1/2)', '(-z+1/2, -y, x)',
                             '(-z+1/2, y, -x)', '(-z+1/2, y+1/2, -x+1/2)',
                             '(-z, y, -x+1/2)', '(-z, y+1/2, -x)',
                             '(z, -y, -x+1/2)', '(z, -y+1/2, -x)',
                             '(z+1/2, -y, -x)', '(z+1/2, -y+1/2, -x+1/2)',
                             '(z+1/2, y+1/2, x+1/2)', '(z+1/2, y, x)',
                             '(z, y+1/2, x)', '(z, y, x+1/2)'),
                         'hkl: h+k=2n, h+l,k+l=2n, 0kl: k+l=4n, k,l=2n, '
                         'hhl: h,l=2n, h00: h=4n')},
      '228:2': {'16a': (0, ('(1/8, 1/8, 1/8)', '(1/8, 5/8, 5/8)',
                            '(5/8, 1/8, 5/8)', '(5/8, 5/8, 1/8)',
                            '(7/8, 3/8, 7/8)', '(7/8, 7/8, 3/8)',
                            '(3/8, 3/8, 3/8)', '(3/8, 7/8, 7/8)',
                            '(7/8, 7/8, 7/8)', '(7/8, 3/8, 3/8)',
                            '(3/8, 7/8, 3/8)', '(3/8, 3/8, 7/8)',
                            '(1/8, 5/8, 1/8)', '(1/8, 1/8, 5/8)',
                            '(5/8, 5/8, 5/8)', '(5/8, 1/8, 1/8)'), 'n/a'),
                '32b': (0, ('(1/4, 1/4, 1/4)', '(1/4, 3/4, 3/4)',
                            '(3/4, 1/4, 3/4)', '(3/4, 3/4, 1/4)',
                            '(0, 1/2, 3/4)', '(0, 0, 1/4)', '(1/2, 1/2, 1/4)',
                            '(1/2, 0, 3/4)', '(1/2, 3/4, 0)',
                            '(1/2, 1/4, 1/2)', '(0, 3/4, 1/2)', '(0, 1/4, 0)',
                            '(3/4, 0, 1/2)', '(3/4, 1/2, 0)', '(1/4, 0, 0)',
                            '(1/4, 1/2, 1/2)', '(3/4, 3/4, 3/4)',
                            '(3/4, 1/4, 1/4)', '(1/4, 3/4, 1/4)',
                            '(1/4, 1/4, 3/4)', '(0, 1/2, 1/4)', '(0, 0, 3/4)',
                            '(1/2, 1/2, 3/4)', '(1/2, 0, 1/4)',
                            '(1/2, 1/4, 0)', '(1/2, 3/4, 1/2)',
                            '(0, 1/4, 1/2)', '(0, 3/4, 0)', '(1/4, 0, 1/2)',
                            '(1/4, 1/2, 0)', '(3/4, 0, 0)', '(3/4, 1/2, 1/2)'
                            ), 'n/a'),
                '32c': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                            '(1/2, 1/2, 0)', '(1/4, 3/4, 1/2)',
                            '(1/4, 1/4, 0)', '(3/4, 3/4, 0)',
                            '(3/4, 1/4, 1/2)', '(3/4, 1/2, 1/4)',
                            '(3/4, 0, 3/4)', '(1/4, 1/2, 3/4)',
                            '(1/4, 0, 1/4)', '(1/2, 1/4, 3/4)',
                            '(1/2, 3/4, 1/4)', '(0, 1/4, 1/4)',
                            '(0, 3/4, 3/4)', '(3/4, 1/4, 0)',
                            '(3/4, 3/4, 1/2)', '(1/4, 1/4, 1/2)',
                            '(1/4, 3/4, 0)', '(1/2, 1/2, 1/2)', '(1/2, 0, 0)',
                            '(0, 1/2, 0)', '(0, 0, 1/2)', '(1/4, 0, 3/4)',
                            '(1/4, 1/2, 1/4)', '(3/4, 0, 1/4)',
                            '(3/4, 1/2, 3/4)', '(0, 3/4, 1/4)',
                            '(0, 1/4, 3/4)', '(1/2, 3/4, 3/4)',
                            '(1/2, 1/4, 1/4)'), 'n/a'),
                '48d': (0, ('(7/8, 1/8, 1/8)', '(7/8, 5/8, 5/8)',
                            '(3/8, 1/8, 5/8)', '(3/8, 5/8, 1/8)',
                            '(3/8, 5/8, 5/8)', '(3/8, 1/8, 1/8)',
                            '(7/8, 5/8, 1/8)', '(7/8, 1/8, 5/8)',
                            '(1/8, 7/8, 1/8)', '(1/8, 3/8, 5/8)',
                            '(5/8, 7/8, 5/8)', '(5/8, 3/8, 1/8)',
                            '(5/8, 3/8, 5/8)', '(5/8, 7/8, 1/8)',
                            '(1/8, 3/8, 1/8)', '(1/8, 7/8, 5/8)',
                            '(1/8, 1/8, 7/8)', '(1/8, 5/8, 3/8)',
                            '(5/8, 1/8, 3/8)', '(5/8, 5/8, 7/8)',
                            '(5/8, 5/8, 3/8)', '(5/8, 1/8, 7/8)',
                            '(1/8, 5/8, 7/8)', '(1/8, 1/8, 3/8)',
                            '(7/8, 1/8, 7/8)', '(7/8, 5/8, 3/8)',
                            '(3/8, 1/8, 3/8)', '(3/8, 5/8, 7/8)',
                            '(3/8, 5/8, 3/8)', '(3/8, 1/8, 7/8)',
                            '(7/8, 5/8, 7/8)', '(7/8, 1/8, 3/8)',
                            '(5/8, 3/8, 7/8)', '(5/8, 7/8, 3/8)',
                            '(1/8, 3/8, 3/8)', '(1/8, 7/8, 7/8)',
                            '(1/8, 7/8, 3/8)', '(1/8, 3/8, 7/8)',
                            '(5/8, 7/8, 7/8)', '(5/8, 3/8, 3/8)',
                            '(7/8, 3/8, 1/8)', '(7/8, 7/8, 5/8)',
                            '(3/8, 3/8, 5/8)', '(3/8, 7/8, 1/8)',
                            '(3/8, 7/8, 5/8)', '(3/8, 3/8, 1/8)',
                            '(7/8, 7/8, 1/8)', '(7/8, 3/8, 5/8)'), 'n/a'),
                '64e': (1, ('(x, x, x)', '(x, x+1/2, x+1/2)',
                            '(x+1/2, x, x+1/2)', '(x+1/2, x+1/2, x)',
                            '(-x+1/4, -x+3/4, x+1/2)', '(-x+1/4, -x+1/4, x)',
                            '(-x+3/4, -x+3/4, x)', '(-x+3/4, -x+1/4, x+1/2)',
                            '(-x+3/4, x+1/2, -x+1/4)', '(-x+3/4, x, -x+3/4)',
                            '(-x+1/4, x+1/2, -x+3/4)', '(-x+1/4, x, -x+1/4)',
                            '(x+1/2, -x+1/4, -x+3/4)',
                            '(x+1/2, -x+3/4, -x+1/4)', '(x, -x+1/4, -x+1/4)',
                            '(x, -x+3/4, -x+3/4)', '(x+3/4, x+1/4, -x)',
                            '(x+3/4, x+3/4, -x+1/2)',
                            '(x+1/4, x+1/4, -x+1/2)', '(x+1/4, x+3/4, -x)',
                            '(-x+1/2, -x+1/2, -x+1/2)', '(-x+1/2, -x, -x)',
                            '(-x, -x+1/2, -x)', '(-x, -x, -x+1/2)',
                            '(x+1/4, -x, x+3/4)', '(x+1/4, -x+1/2, x+1/4)',
                            '(x+3/4, -x, x+1/4)', '(x+3/4, -x+1/2, x+3/4)',
                            '(-x, x+3/4, x+1/4)', '(-x, x+1/4, x+3/4)',
                            '(-x+1/2, x+3/4, x+3/4)',
                            '(-x+1/2, x+1/4, x+1/4)', '(-x, -x, -x)',
                            '(-x, -x+1/2, -x+1/2)', '(-x+1/2, -x, -x+1/2)',
                            '(-x+1/2, -x+1/2, -x)', '(x+3/4, x+1/4, -x+1/2)',
                            '(x+3/4, x+3/4, -x)', '(x+1/4, x+1/4, -x)',
                            '(x+1/4, x+3/4, -x+1/2)',
                            '(x+1/4, -x+1/2, x+3/4)', '(x+1/4, -x, x+1/4)',
                            '(x+3/4, -x+1/2, x+1/4)', '(x+3/4, -x, x+3/4)',
                            '(-x+1/2, x+3/4, x+1/4)',
                            '(-x+1/2, x+1/4, x+3/4)', '(-x, x+3/4, x+3/4)',
                            '(-x, x+1/4, x+1/4)', '(-x+1/4, -x+3/4, x)',
                            '(-x+1/4, -x+1/4, x+1/2)',
                            '(-x+3/4, -x+3/4, x+1/2)', '(-x+3/4, -x+1/4, x)',
                            '(x+1/2, x+1/2, x+1/2)', '(x+1/2, x, x)',
                            '(x, x+1/2, x)', '(x, x, x+1/2)',
                            '(-x+3/4, x, -x+1/4)', '(-x+3/4, x+1/2, -x+3/4)',
                            '(-x+1/4, x, -x+3/4)', '(-x+1/4, x+1/2, -x+1/4)',
                            '(x, -x+1/4, -x+3/4)', '(x, -x+3/4, -x+1/4)',
                            '(x+1/2, -x+1/4, -x+1/4)',
                            '(x+1/2, -x+3/4, -x+3/4)'), 'n/a'),
                '96f': (1, ('(x, 1/8, 1/8)', '(x, 5/8, 5/8)',
                            '(x+1/2, 1/8, 5/8)', '(x+1/2, 5/8, 1/8)',
                            '(-x+1/4, 5/8, 5/8)', '(-x+1/4, 1/8, 1/8)',
                            '(-x+3/4, 5/8, 1/8)', '(-x+3/4, 1/8, 5/8)',
                            '(1/8, x, 1/8)', '(1/8, x+1/2, 5/8)',
                            '(5/8, x, 5/8)', '(5/8, x+1/2, 1/8)',
                            '(5/8, -x+1/4, 5/8)', '(5/8, -x+3/4, 1/8)',
                            '(1/8, -x+1/4, 1/8)', '(1/8, -x+3/4, 5/8)',
                            '(1/8, 1/8, x)', '(1/8, 5/8, x+1/2)',
                            '(5/8, 1/8, x+1/2)', '(5/8, 5/8, x)',
                            '(5/8, 5/8, -x+1/4)', '(5/8, 1/8, -x+3/4)',
                            '(1/8, 5/8, -x+3/4)', '(1/8, 1/8, -x+1/4)',
                            '(7/8, x+1/4, 7/8)', '(7/8, x+3/4, 3/8)',
                            '(3/8, x+1/4, 3/8)', '(3/8, x+3/4, 7/8)',
                            '(3/8, -x+1/2, 3/8)', '(3/8, -x, 7/8)',
                            '(7/8, -x+1/2, 7/8)', '(7/8, -x, 3/8)',
                            '(x+3/4, 3/8, 7/8)', '(x+3/4, 7/8, 3/8)',
                            '(x+1/4, 3/8, 3/8)', '(x+1/4, 7/8, 7/8)',
                            '(-x, 7/8, 3/8)', '(-x, 3/8, 7/8)',
                            '(-x+1/2, 7/8, 7/8)', '(-x+1/2, 3/8, 3/8)',
                            '(7/8, 3/8, -x)', '(7/8, 7/8, -x+1/2)',
                            '(3/8, 3/8, -x+1/2)', '(3/8, 7/8, -x)',
                            '(3/8, 7/8, x+3/4)', '(3/8, 3/8, x+1/4)',
                            '(7/8, 7/8, x+1/4)', '(7/8, 3/8, x+3/4)',
                            '(-x, 7/8, 7/8)', '(-x, 3/8, 3/8)',
                            '(-x+1/2, 7/8, 3/8)', '(-x+1/2, 3/8, 7/8)',
                            '(x+3/4, 3/8, 3/8)', '(x+3/4, 7/8, 7/8)',
                            '(x+1/4, 3/8, 7/8)', '(x+1/4, 7/8, 3/8)',
                            '(7/8, -x, 7/8)', '(7/8, -x+1/2, 3/8)',
                            '(3/8, -x, 3/8)', '(3/8, -x+1/2, 7/8)',
                            '(3/8, x+3/4, 3/8)', '(3/8, x+1/4, 7/8)',
                            '(7/8, x+3/4, 7/8)', '(7/8, x+1/4, 3/8)',
                            '(7/8, 7/8, -x)', '(7/8, 3/8, -x+1/2)',
                            '(3/8, 7/8, -x+1/2)', '(3/8, 3/8, -x)',
                            '(3/8, 3/8, x+3/4)', '(3/8, 7/8, x+1/4)',
                            '(7/8, 3/8, x+1/4)', '(7/8, 7/8, x+3/4)',
                            '(1/8, -x+3/4, 1/8)', '(1/8, -x+1/4, 5/8)',
                            '(5/8, -x+3/4, 5/8)', '(5/8, -x+1/4, 1/8)',
                            '(5/8, x+1/2, 5/8)', '(5/8, x, 1/8)',
                            '(1/8, x+1/2, 1/8)', '(1/8, x, 5/8)',
                            '(-x+1/4, 5/8, 1/8)', '(-x+1/4, 1/8, 5/8)',
                            '(-x+3/4, 5/8, 5/8)', '(-x+3/4, 1/8, 1/8)',
                            '(x, 1/8, 5/8)', '(x, 5/8, 1/8)',
                            '(x+1/2, 1/8, 1/8)', '(x+1/2, 5/8, 5/8)',
                            '(1/8, 5/8, x)', '(1/8, 1/8, x+1/2)',
                            '(5/8, 5/8, x+1/2)', '(5/8, 1/8, x)',
                            '(5/8, 1/8, -x+1/4)', '(5/8, 5/8, -x+3/4)',
                            '(1/8, 1/8, -x+3/4)', '(1/8, 5/8, -x+1/4)'), 'n/a'
                        ),
                '96g': (2, ('(1/4, y, -y)', '(1/4, y+1/2, -y+1/2)',
                            '(3/4, y, -y+1/2)', '(3/4, y+1/2, -y)',
                            '(0, -y+3/4, -y+1/2)', '(0, -y+1/4, -y)',
                            '(1/2, -y+3/4, -y)', '(1/2, -y+1/4, -y+1/2)',
                            '(1/2, y+1/2, y+1/4)', '(1/2, y, y+3/4)',
                            '(0, y+1/2, y+3/4)', '(0, y, y+1/4)',
                            '(3/4, -y+1/4, y+3/4)', '(3/4, -y+3/4, y+1/4)',
                            '(1/4, -y+1/4, y+1/4)', '(1/4, -y+3/4, y+3/4)',
                            '(-y, 1/4, y)', '(-y, 3/4, y+1/2)',
                            '(-y+1/2, 1/4, y+1/2)', '(-y+1/2, 3/4, y)',
                            '(-y+1/2, 0, -y+3/4)', '(-y+1/2, 1/2, -y+1/4)',
                            '(-y, 0, -y+1/4)', '(-y, 1/2, -y+3/4)',
                            '(y+1/4, 1/2, y+1/2)', '(y+1/4, 0, y)',
                            '(y+3/4, 1/2, y)', '(y+3/4, 0, y+1/2)',
                            '(y+3/4, 3/4, -y+1/4)', '(y+3/4, 1/4, -y+3/4)',
                            '(y+1/4, 3/4, -y+3/4)', '(y+1/4, 1/4, -y+1/4)',
                            '(y, -y, 1/4)', '(y, -y+1/2, 3/4)',
                            '(y+1/2, -y, 3/4)', '(y+1/2, -y+1/2, 1/4)',
                            '(-y+3/4, -y+1/2, 0)', '(-y+3/4, -y, 1/2)',
                            '(-y+1/4, -y+1/2, 1/2)', '(-y+1/4, -y, 0)',
                            '(y+1/2, y+1/4, 1/2)', '(y+1/2, y+3/4, 0)',
                            '(y, y+1/4, 0)', '(y, y+3/4, 1/2)',
                            '(-y+1/4, y+3/4, 3/4)', '(-y+1/4, y+1/4, 1/4)',
                            '(-y+3/4, y+3/4, 1/4)', '(-y+3/4, y+1/4, 3/4)',
                            '(3/4, -y, y)', '(3/4, -y+1/2, y+1/2)',
                            '(1/4, -y, y+1/2)', '(1/4, -y+1/2, y)',
                            '(0, y+1/4, y+1/2)', '(0, y+3/4, y)',
                            '(1/2, y+1/4, y)', '(1/2, y+3/4, y+1/2)',
                            '(1/2, -y+1/2, -y+3/4)', '(1/2, -y, -y+1/4)',
                            '(0, -y+1/2, -y+1/4)', '(0, -y, -y+3/4)',
                            '(1/4, y+3/4, -y+1/4)', '(1/4, y+1/4, -y+3/4)',
                            '(3/4, y+3/4, -y+3/4)', '(3/4, y+1/4, -y+1/4)',
                            '(y, 3/4, -y)', '(y, 1/4, -y+1/2)',
                            '(y+1/2, 3/4, -y+1/2)', '(y+1/2, 1/4, -y)',
                            '(y+1/2, 0, y+1/4)', '(y+1/2, 1/2, y+3/4)',
                            '(y, 0, y+3/4)', '(y, 1/2, y+1/4)',
                            '(-y+3/4, 1/2, -y+1/2)', '(-y+3/4, 0, -y)',
                            '(-y+1/4, 1/2, -y)', '(-y+1/4, 0, -y+1/2)',
                            '(-y+1/4, 1/4, y+3/4)', '(-y+1/4, 3/4, y+1/4)',
                            '(-y+3/4, 1/4, y+1/4)', '(-y+3/4, 3/4, y+3/4)',
                            '(-y, y, 3/4)', '(-y, y+1/2, 1/4)',
                            '(-y+1/2, y, 1/4)', '(-y+1/2, y+1/2, 3/4)',
                            '(y+1/4, y+1/2, 0)', '(y+1/4, y, 1/2)',
                            '(y+3/4, y+1/2, 1/2)', '(y+3/4, y, 0)',
                            '(-y+1/2, -y+3/4, 1/2)', '(-y+1/2, -y+1/4, 0)',
                            '(-y, -y+3/4, 0)', '(-y, -y+1/4, 1/2)',
                            '(y+3/4, -y+1/4, 1/4)', '(y+3/4, -y+3/4, 3/4)',
                            '(y+1/4, -y+1/4, 3/4)', '(y+1/4, -y+3/4, 1/4)'),
                        'n/a'),
                '192h': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)',
                             '(x+1/2, y, z+1/2)', '(x+1/2, y+1/2, z)',
                             '(-x+1/4, -y+3/4, z+1/2)', '(-x+1/4, -y+1/4, z)',
                             '(-x+3/4, -y+3/4, z)', '(-x+3/4, -y+1/4, z+1/2)',
                             '(-x+3/4, y+1/2, -z+1/4)', '(-x+3/4, y, -z+3/4)',
                             '(-x+1/4, y+1/2, -z+3/4)', '(-x+1/4, y, -z+1/4)',
                             '(x+1/2, -y+1/4, -z+3/4)',
                             '(x+1/2, -y+3/4, -z+1/4)', '(x, -y+1/4, -z+1/4)',
                             '(x, -y+3/4, -z+3/4)', '(z, x, y)',
                             '(z, x+1/2, y+1/2)', '(z+1/2, x, y+1/2)',
                             '(z+1/2, x+1/2, y)', '(z+1/2, -x+1/4, -y+3/4)',
                             '(z+1/2, -x+3/4, -y+1/4)', '(z, -x+1/4, -y+1/4)',
                             '(z, -x+3/4, -y+3/4)', '(-z+1/4, -x+3/4, y+1/2)',
                             '(-z+1/4, -x+1/4, y)', '(-z+3/4, -x+3/4, y)',
                             '(-z+3/4, -x+1/4, y+1/2)',
                             '(-z+3/4, x+1/2, -y+1/4)', '(-z+3/4, x, -y+3/4)',
                             '(-z+1/4, x+1/2, -y+3/4)', '(-z+1/4, x, -y+1/4)',
                             '(y, z, x)', '(y, z+1/2, x+1/2)',
                             '(y+1/2, z, x+1/2)', '(y+1/2, z+1/2, x)',
                             '(-y+3/4, z+1/2, -x+1/4)', '(-y+3/4, z, -x+3/4)',
                             '(-y+1/4, z+1/2, -x+3/4)', '(-y+1/4, z, -x+1/4)',
                             '(y+1/2, -z+1/4, -x+3/4)',
                             '(y+1/2, -z+3/4, -x+1/4)', '(y, -z+1/4, -x+1/4)',
                             '(y, -z+3/4, -x+3/4)', '(-y+1/4, -z+3/4, x+1/2)',
                             '(-y+1/4, -z+1/4, x)', '(-y+3/4, -z+3/4, x)',
                             '(-y+3/4, -z+1/4, x+1/2)', '(y+3/4, x+1/4, -z)',
                             '(y+3/4, x+3/4, -z+1/2)',
                             '(y+1/4, x+1/4, -z+1/2)', '(y+1/4, x+3/4, -z)',
                             '(-y+1/2, -x+1/2, -z+1/2)', '(-y+1/2, -x, -z)',
                             '(-y, -x+1/2, -z)', '(-y, -x, -z+1/2)',
                             '(y+1/4, -x, z+3/4)', '(y+1/4, -x+1/2, z+1/4)',
                             '(y+3/4, -x, z+1/4)', '(y+3/4, -x+1/2, z+3/4)',
                             '(-y, x+3/4, z+1/4)', '(-y, x+1/4, z+3/4)',
                             '(-y+1/2, x+3/4, z+3/4)',
                             '(-y+1/2, x+1/4, z+1/4)', '(x+3/4, z+1/4, -y)',
                             '(x+3/4, z+3/4, -y+1/2)',
                             '(x+1/4, z+1/4, -y+1/2)', '(x+1/4, z+3/4, -y)',
                             '(-x, z+3/4, y+1/4)', '(-x, z+1/4, y+3/4)',
                             '(-x+1/2, z+3/4, y+3/4)',
                             '(-x+1/2, z+1/4, y+1/4)',
                             '(-x+1/2, -z+1/2, -y+1/2)', '(-x+1/2, -z, -y)',
                             '(-x, -z+1/2, -y)', '(-x, -z, -y+1/2)',
                             '(x+1/4, -z, y+3/4)', '(x+1/4, -z+1/2, y+1/4)',
                             '(x+3/4, -z, y+1/4)', '(x+3/4, -z+1/2, y+3/4)',
                             '(z+3/4, y+1/4, -x)', '(z+3/4, y+3/4, -x+1/2)',
                             '(z+1/4, y+1/4, -x+1/2)', '(z+1/4, y+3/4, -x)',
                             '(z+1/4, -y, x+3/4)', '(z+1/4, -y+1/2, x+1/4)',
                             '(z+3/4, -y, x+1/4)', '(z+3/4, -y+1/2, x+3/4)',
                             '(-z, y+3/4, x+1/4)', '(-z, y+1/4, x+3/4)',
                             '(-z+1/2, y+3/4, x+3/4)',
                             '(-z+1/2, y+1/4, x+1/4)',
                             '(-z+1/2, -y+1/2, -x+1/2)', '(-z+1/2, -y, -x)',
                             '(-z, -y+1/2, -x)', '(-z, -y, -x+1/2)',
                             '(-x, -y, -z)', '(-x, -y+1/2, -z+1/2)',
                             '(-x+1/2, -y, -z+1/2)', '(-x+1/2, -y+1/2, -z)',
                             '(x+3/4, y+1/4, -z+1/2)', '(x+3/4, y+3/4, -z)',
                             '(x+1/4, y+1/4, -z)', '(x+1/4, y+3/4, -z+1/2)',
                             '(x+1/4, -y+1/2, z+3/4)', '(x+1/4, -y, z+1/4)',
                             '(x+3/4, -y+1/2, z+1/4)', '(x+3/4, -y, z+3/4)',
                             '(-x+1/2, y+3/4, z+1/4)',
                             '(-x+1/2, y+1/4, z+3/4)', '(-x, y+3/4, z+3/4)',
                             '(-x, y+1/4, z+1/4)', '(-z, -x, -y)',
                             '(-z, -x+1/2, -y+1/2)', '(-z+1/2, -x, -y+1/2)',
                             '(-z+1/2, -x+1/2, -y)', '(-z+1/2, x+3/4, y+1/4)',
                             '(-z+1/2, x+1/4, y+3/4)', '(-z, x+3/4, y+3/4)',
                             '(-z, x+1/4, y+1/4)', '(z+3/4, x+1/4, -y+1/2)',
                             '(z+3/4, x+3/4, -y)', '(z+1/4, x+1/4, -y)',
                             '(z+1/4, x+3/4, -y+1/2)',
                             '(z+1/4, -x+1/2, y+3/4)', '(z+1/4, -x, y+1/4)',
                             '(z+3/4, -x+1/2, y+1/4)', '(z+3/4, -x, y+3/4)',
                             '(-y, -z, -x)', '(-y, -z+1/2, -x+1/2)',
                             '(-y+1/2, -z, -x+1/2)', '(-y+1/2, -z+1/2, -x)',
                             '(y+1/4, -z+1/2, x+3/4)', '(y+1/4, -z, x+1/4)',
                             '(y+3/4, -z+1/2, x+1/4)', '(y+3/4, -z, x+3/4)',
                             '(-y+1/2, z+3/4, x+1/4)',
                             '(-y+1/2, z+1/4, x+3/4)', '(-y, z+3/4, x+3/4)',
                             '(-y, z+1/4, x+1/4)', '(y+3/4, z+1/4, -x+1/2)',
                             '(y+3/4, z+3/4, -x)', '(y+1/4, z+1/4, -x)',
                             '(y+1/4, z+3/4, -x+1/2)', '(-y+1/4, -x+3/4, z)',
                             '(-y+1/4, -x+1/4, z+1/2)',
                             '(-y+3/4, -x+3/4, z+1/2)', '(-y+3/4, -x+1/4, z)',
                             '(y+1/2, x+1/2, z+1/2)', '(y+1/2, x, z)',
                             '(y, x+1/2, z)', '(y, x, z+1/2)',
                             '(-y+3/4, x, -z+1/4)', '(-y+3/4, x+1/2, -z+3/4)',
                             '(-y+1/4, x, -z+3/4)', '(-y+1/4, x+1/2, -z+1/4)',
                             '(y, -x+1/4, -z+3/4)', '(y, -x+3/4, -z+1/4)',
                             '(y+1/2, -x+1/4, -z+1/4)',
                             '(y+1/2, -x+3/4, -z+3/4)', '(-x+1/4, -z+3/4, y)',
                             '(-x+1/4, -z+1/4, y+1/2)',
                             '(-x+3/4, -z+3/4, y+1/2)', '(-x+3/4, -z+1/4, y)',
                             '(x, -z+1/4, -y+3/4)', '(x, -z+3/4, -y+1/4)',
                             '(x+1/2, -z+1/4, -y+1/4)',
                             '(x+1/2, -z+3/4, -y+3/4)',
                             '(x+1/2, z+1/2, y+1/2)', '(x+1/2, z, y)',
                             '(x, z+1/2, y)', '(x, z, y+1/2)',
                             '(-x+3/4, z, -y+1/4)', '(-x+3/4, z+1/2, -y+3/4)',
                             '(-x+1/4, z, -y+3/4)', '(-x+1/4, z+1/2, -y+1/4)',
                             '(-z+1/4, -y+3/4, x)', '(-z+1/4, -y+1/4, x+1/2)',
                             '(-z+3/4, -y+3/4, x+1/2)', '(-z+3/4, -y+1/4, x)',
                             '(-z+3/4, y, -x+1/4)', '(-z+3/4, y+1/2, -x+3/4)',
                             '(-z+1/4, y, -x+3/4)', '(-z+1/4, y+1/2, -x+1/4)',
                             '(z, -y+1/4, -x+3/4)', '(z, -y+3/4, -x+1/4)',
                             '(z+1/2, -y+1/4, -x+1/4)',
                             '(z+1/2, -y+3/4, -x+3/4)',
                             '(z+1/2, y+1/2, x+1/2)', '(z+1/2, y, x)',
                             '(z, y+1/2, x)', '(z, y, x+1/2)'), 'n/a')},
      '229': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)'), None),
              '6b': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 0)', '(1/2, 0, 1/2)',
                         '(0, 1/2, 0)', '(1/2, 1/2, 0)', '(0, 0, 1/2)'), None
                     ),
              '8c': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)',
                         '(3/4, 3/4, 1/4)', '(1/4, 1/4, 3/4)',
                         '(3/4, 1/4, 3/4)', '(1/4, 3/4, 1/4)',
                         '(1/4, 3/4, 3/4)', '(3/4, 1/4, 1/4)'), 'hkl: k,l=2n'
                     ),
              '12d': (0, ('(1/4, 0, 1/2)', '(3/4, 1/2, 0)', '(3/4, 0, 1/2)',
                          '(1/4, 1/2, 0)', '(1/2, 1/4, 0)', '(0, 3/4, 1/2)',
                          '(1/2, 3/4, 0)', '(0, 1/4, 1/2)', '(0, 1/2, 1/4)',
                          '(1/2, 0, 3/4)', '(0, 1/2, 3/4)', '(1/2, 0, 1/4)'),
                      None),
              '12e': (1, ('(x, 0, 0)', '(x+1/2, 1/2, 1/2)', '(-x, 0, 0)',
                          '(-x+1/2, 1/2, 1/2)', '(0, x, 0)',
                          '(1/2, x+1/2, 1/2)', '(0, -x, 0)',
                          '(1/2, -x+1/2, 1/2)', '(0, 0, x)',
                          '(1/2, 1/2, x+1/2)', '(0, 0, -x)',
                          '(1/2, 1/2, -x+1/2)'), None),
              '16f': (1, ('(x, x, x)', '(x+1/2, x+1/2, x+1/2)', '(-x, -x, x)',
                          '(-x+1/2, -x+1/2, x+1/2)', '(-x, x, -x)',
                          '(-x+1/2, x+1/2, -x+1/2)', '(x, -x, -x)',
                          '(x+1/2, -x+1/2, -x+1/2)', '(x, x, -x)',
                          '(x+1/2, x+1/2, -x+1/2)', '(-x, -x, -x)',
                          '(-x+1/2, -x+1/2, -x+1/2)', '(x, -x, x)',
                          '(x+1/2, -x+1/2, x+1/2)', '(-x, x, x)',
                          '(-x+1/2, x+1/2, x+1/2)'), None),
              '24g': (1, ('(x, 0, 1/2)', '(x+1/2, 1/2, 0)', '(-x, 0, 1/2)',
                          '(-x+1/2, 1/2, 0)', '(1/2, x, 0)',
                          '(0, x+1/2, 1/2)', '(1/2, -x, 0)',
                          '(0, -x+1/2, 1/2)', '(0, 1/2, x)',
                          '(1/2, 0, x+1/2)', '(0, 1/2, -x)',
                          '(1/2, 0, -x+1/2)', '(0, x, 1/2)',
                          '(1/2, x+1/2, 0)', '(0, -x, 1/2)',
                          '(1/2, -x+1/2, 0)', '(x, 1/2, 0)',
                          '(x+1/2, 0, 1/2)', '(-x, 1/2, 0)',
                          '(-x+1/2, 0, 1/2)', '(1/2, 0, -x)',
                          '(0, 1/2, -x+1/2)', '(1/2, 0, x)',
                          '(0, 1/2, x+1/2)'), None),
              '24h': (2, ('(0, y, y)', '(1/2, y+1/2, y+1/2)', '(0, -y, y)',
                          '(1/2, -y+1/2, y+1/2)', '(0, y, -y)',
                          '(1/2, y+1/2, -y+1/2)', '(0, -y, -y)',
                          '(1/2, -y+1/2, -y+1/2)', '(y, 0, y)',
                          '(y+1/2, 1/2, y+1/2)', '(y, 0, -y)',
                          '(y+1/2, 1/2, -y+1/2)', '(-y, 0, y)',
                          '(-y+1/2, 1/2, y+1/2)', '(-y, 0, -y)',
                          '(-y+1/2, 1/2, -y+1/2)', '(y, y, 0)',
                          '(y+1/2, y+1/2, 1/2)', '(-y, y, 0)',
                          '(-y+1/2, y+1/2, 1/2)', '(y, -y, 0)',
                          '(y+1/2, -y+1/2, 1/2)', '(-y, -y, 0)',
                          '(-y+1/2, -y+1/2, 1/2)'), None),
              '48i': (2, ('(1/4, y, -y+1/2)', '(3/4, y+1/2, -y)',
                          '(3/4, -y, -y+1/2)', '(1/4, -y+1/2, -y)',
                          '(3/4, y, y+1/2)', '(1/4, y+1/2, y)',
                          '(1/4, -y, y+1/2)', '(3/4, -y+1/2, y)',
                          '(-y+1/2, 1/4, y)', '(-y, 3/4, y+1/2)',
                          '(-y+1/2, 3/4, -y)', '(-y, 1/4, -y+1/2)',
                          '(y+1/2, 3/4, y)', '(y, 1/4, y+1/2)',
                          '(y+1/2, 1/4, -y)', '(y, 3/4, -y+1/2)',
                          '(y, -y+1/2, 1/4)', '(y+1/2, -y, 3/4)',
                          '(-y, -y+1/2, 3/4)', '(-y+1/2, -y, 1/4)',
                          '(y, y+1/2, 3/4)', '(y+1/2, y, 1/4)',
                          '(-y, y+1/2, 1/4)', '(-y+1/2, y, 3/4)',
                          '(3/4, -y, y+1/2)', '(1/4, -y+1/2, y)',
                          '(1/4, y, y+1/2)', '(3/4, y+1/2, y)',
                          '(1/4, -y, -y+1/2)', '(3/4, -y+1/2, -y)',
                          '(3/4, y, -y+1/2)', '(1/4, y+1/2, -y)',
                          '(y+1/2, 3/4, -y)', '(y, 1/4, -y+1/2)',
                          '(y+1/2, 1/4, y)', '(y, 3/4, y+1/2)',
                          '(-y+1/2, 1/4, -y)', '(-y, 3/4, -y+1/2)',
                          '(-y+1/2, 3/4, y)', '(-y, 1/4, y+1/2)',
                          '(-y, y+1/2, 3/4)', '(-y+1/2, y, 1/4)',
                          '(y, y+1/2, 1/4)', '(y+1/2, y, 3/4)',
                          '(-y, -y+1/2, 1/4)', '(-y+1/2, -y, 3/4)',
                          '(y, -y+1/2, 3/4)', '(y+1/2, -y, 1/4)'), None),
              '48j': (6, ('(0, y, z)', '(1/2, y+1/2, z+1/2)', '(0, -y, z)',
                          '(1/2, -y+1/2, z+1/2)', '(0, y, -z)',
                          '(1/2, y+1/2, -z+1/2)', '(0, -y, -z)',
                          '(1/2, -y+1/2, -z+1/2)', '(z, 0, y)',
                          '(z+1/2, 1/2, y+1/2)', '(z, 0, -y)',
                          '(z+1/2, 1/2, -y+1/2)', '(-z, 0, y)',
                          '(-z+1/2, 1/2, y+1/2)', '(-z, 0, -y)',
                          '(-z+1/2, 1/2, -y+1/2)', '(y, z, 0)',
                          '(y+1/2, z+1/2, 1/2)', '(-y, z, 0)',
                          '(-y+1/2, z+1/2, 1/2)', '(y, -z, 0)',
                          '(y+1/2, -z+1/2, 1/2)', '(-y, -z, 0)',
                          '(-y+1/2, -z+1/2, 1/2)', '(y, 0, -z)',
                          '(y+1/2, 1/2, -z+1/2)', '(-y, 0, -z)',
                          '(-y+1/2, 1/2, -z+1/2)', '(y, 0, z)',
                          '(y+1/2, 1/2, z+1/2)', '(-y, 0, z)',
                          '(-y+1/2, 1/2, z+1/2)', '(0, z, -y)',
                          '(1/2, z+1/2, -y+1/2)', '(0, z, y)',
                          '(1/2, z+1/2, y+1/2)', '(0, -z, -y)',
                          '(1/2, -z+1/2, -y+1/2)', '(0, -z, y)',
                          '(1/2, -z+1/2, y+1/2)', '(z, y, 0)',
                          '(z+1/2, y+1/2, 1/2)', '(z, -y, 0)',
                          '(z+1/2, -y+1/2, 1/2)', '(-z, y, 0)',
                          '(-z+1/2, y+1/2, 1/2)', '(-z, -y, 0)',
                          '(-z+1/2, -y+1/2, 1/2)'), None),
              '48k': (5, ('(x, x, z)', '(x+1/2, x+1/2, z+1/2)', '(-x, -x, z)',
                          '(-x+1/2, -x+1/2, z+1/2)', '(-x, x, -z)',
                          '(-x+1/2, x+1/2, -z+1/2)', '(x, -x, -z)',
                          '(x+1/2, -x+1/2, -z+1/2)', '(z, x, x)',
                          '(z+1/2, x+1/2, x+1/2)', '(z, -x, -x)',
                          '(z+1/2, -x+1/2, -x+1/2)', '(-z, -x, x)',
                          '(-z+1/2, -x+1/2, x+1/2)', '(-z, x, -x)',
                          '(-z+1/2, x+1/2, -x+1/2)', '(x, z, x)',
                          '(x+1/2, z+1/2, x+1/2)', '(-x, z, -x)',
                          '(-x+1/2, z+1/2, -x+1/2)', '(x, -z, -x)',
                          '(x+1/2, -z+1/2, -x+1/2)', '(-x, -z, x)',
                          '(-x+1/2, -z+1/2, x+1/2)', '(x, x, -z)',
                          '(x+1/2, x+1/2, -z+1/2)', '(-x, -x, -z)',
                          '(-x+1/2, -x+1/2, -z+1/2)', '(x, -x, z)',
                          '(x+1/2, -x+1/2, z+1/2)', '(-x, x, z)',
                          '(-x+1/2, x+1/2, z+1/2)', '(x, z, -x)',
                          '(x+1/2, z+1/2, -x+1/2)', '(-x, z, x)',
                          '(-x+1/2, z+1/2, x+1/2)', '(-x, -z, -x)',
                          '(-x+1/2, -z+1/2, -x+1/2)', '(x, -z, x)',
                          '(x+1/2, -z+1/2, x+1/2)', '(z, x, -x)',
                          '(z+1/2, x+1/2, -x+1/2)', '(z, -x, x)',
                          '(z+1/2, -x+1/2, x+1/2)', '(-z, x, x)',
                          '(-z+1/2, x+1/2, x+1/2)', '(-z, -x, -x)',
                          '(-z+1/2, -x+1/2, -x+1/2)'), None),
              '96l': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                          '(-x+1/2, -y+1/2, z+1/2)', '(-x, y, -z)',
                          '(-x+1/2, y+1/2, -z+1/2)', '(x, -y, -z)',
                          '(x+1/2, -y+1/2, -z+1/2)', '(z, x, y)',
                          '(z+1/2, x+1/2, y+1/2)', '(z, -x, -y)',
                          '(z+1/2, -x+1/2, -y+1/2)', '(-z, -x, y)',
                          '(-z+1/2, -x+1/2, y+1/2)', '(-z, x, -y)',
                          '(-z+1/2, x+1/2, -y+1/2)', '(y, z, x)',
                          '(y+1/2, z+1/2, x+1/2)', '(-y, z, -x)',
                          '(-y+1/2, z+1/2, -x+1/2)', '(y, -z, -x)',
                          '(y+1/2, -z+1/2, -x+1/2)', '(-y, -z, x)',
                          '(-y+1/2, -z+1/2, x+1/2)', '(y, x, -z)',
                          '(y+1/2, x+1/2, -z+1/2)', '(-y, -x, -z)',
                          '(-y+1/2, -x+1/2, -z+1/2)', '(y, -x, z)',
                          '(y+1/2, -x+1/2, z+1/2)', '(-y, x, z)',
                          '(-y+1/2, x+1/2, z+1/2)', '(x, z, -y)',
                          '(x+1/2, z+1/2, -y+1/2)', '(-x, z, y)',
                          '(-x+1/2, z+1/2, y+1/2)', '(-x, -z, -y)',
                          '(-x+1/2, -z+1/2, -y+1/2)', '(x, -z, y)',
                          '(x+1/2, -z+1/2, y+1/2)', '(z, y, -x)',
                          '(z+1/2, y+1/2, -x+1/2)', '(z, -y, x)',
                          '(z+1/2, -y+1/2, x+1/2)', '(-z, y, x)',
                          '(-z+1/2, y+1/2, x+1/2)', '(-z, -y, -x)',
                          '(-z+1/2, -y+1/2, -x+1/2)', '(-x, -y, -z)',
                          '(-x+1/2, -y+1/2, -z+1/2)', '(x, y, -z)',
                          '(x+1/2, y+1/2, -z+1/2)', '(x, -y, z)',
                          '(x+1/2, -y+1/2, z+1/2)', '(-x, y, z)',
                          '(-x+1/2, y+1/2, z+1/2)', '(-z, -x, -y)',
                          '(-z+1/2, -x+1/2, -y+1/2)', '(-z, x, y)',
                          '(-z+1/2, x+1/2, y+1/2)', '(z, x, -y)',
                          '(z+1/2, x+1/2, -y+1/2)', '(z, -x, y)',
                          '(z+1/2, -x+1/2, y+1/2)', '(-y, -z, -x)',
                          '(-y+1/2, -z+1/2, -x+1/2)', '(y, -z, x)',
                          '(y+1/2, -z+1/2, x+1/2)', '(-y, z, x)',
                          '(-y+1/2, z+1/2, x+1/2)', '(y, z, -x)',
                          '(y+1/2, z+1/2, -x+1/2)', '(-y, -x, z)',
                          '(-y+1/2, -x+1/2, z+1/2)', '(y, x, z)',
                          '(y+1/2, x+1/2, z+1/2)', '(-y, x, -z)',
                          '(-y+1/2, x+1/2, -z+1/2)', '(y, -x, -z)',
                          '(y+1/2, -x+1/2, -z+1/2)', '(-x, -z, y)',
                          '(-x+1/2, -z+1/2, y+1/2)', '(x, -z, -y)',
                          '(x+1/2, -z+1/2, -y+1/2)', '(x, z, y)',
                          '(x+1/2, z+1/2, y+1/2)', '(-x, z, -y)',
                          '(-x+1/2, z+1/2, -y+1/2)', '(-z, -y, x)',
                          '(-z+1/2, -y+1/2, x+1/2)', '(-z, y, -x)',
                          '(-z+1/2, y+1/2, -x+1/2)', '(z, -y, -x)',
                          '(z+1/2, -y+1/2, -x+1/2)', '(z, y, x)',
                          '(z+1/2, y+1/2, x+1/2)'),
                      'hkl: h+k+l=2n, 0kl: k+l=2n, hhl: l=2n, h00: h=2n')},
      '230': {'16a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)', '(1/2, 0, 1/2)',
                          '(0, 1/2, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 0)',
                          '(1/2, 1/2, 0)', '(0, 0, 1/2)', '(3/4, 1/4, 1/4)',
                          '(1/4, 3/4, 3/4)', '(3/4, 3/4, 3/4)',
                          '(1/4, 1/4, 1/4)', '(1/4, 1/4, 3/4)',
                          '(3/4, 3/4, 1/4)', '(1/4, 3/4, 1/4)',
                          '(3/4, 1/4, 3/4)'), 'hkl: h,k=2n, h+k+l=4n'),
              '16b': (0, ('(1/8, 1/8, 1/8)', '(5/8, 5/8, 5/8)',
                          '(3/8, 7/8, 5/8)', '(7/8, 3/8, 1/8)',
                          '(7/8, 5/8, 3/8)', '(3/8, 1/8, 7/8)',
                          '(5/8, 3/8, 7/8)', '(1/8, 7/8, 3/8)',
                          '(7/8, 7/8, 7/8)', '(3/8, 3/8, 3/8)',
                          '(5/8, 1/8, 3/8)', '(1/8, 5/8, 7/8)',
                          '(1/8, 3/8, 5/8)', '(5/8, 7/8, 1/8)',
                          '(3/8, 5/8, 1/8)', '(7/8, 1/8, 5/8)'),
                      'hkl: h,k=2n+1, l=4n+2 or h,k,l=4n'),
              '24c': (0, ('(1/8, 0, 1/4)', '(5/8, 1/2, 3/4)', '(3/8, 0, 3/4)',
                          '(7/8, 1/2, 1/4)', '(1/4, 1/8, 0)',
                          '(3/4, 5/8, 1/2)', '(3/4, 3/8, 0)',
                          '(1/4, 7/8, 1/2)', '(0, 1/4, 1/8)',
                          '(1/2, 3/4, 5/8)', '(0, 3/4, 3/8)',
                          '(1/2, 1/4, 7/8)', '(7/8, 0, 3/4)',
                          '(3/8, 1/2, 1/4)', '(5/8, 0, 1/4)',
                          '(1/8, 1/2, 3/4)', '(3/4, 7/8, 0)',
                          '(1/4, 3/8, 1/2)', '(1/4, 5/8, 0)',
                          '(3/4, 1/8, 1/2)', '(0, 3/4, 7/8)',
                          '(1/2, 1/4, 3/8)', '(0, 1/4, 5/8)',
                          '(1/2, 3/4, 1/8)'),
                      'hkl: h,k=2n, h+k+l=4n or h,k=2n+1, '
                      'l=4n+2 or h=8n, k=8n+4, h+k+l=4n+2'),
              '24d': (0, ('(3/8, 0, 1/4)', '(7/8, 1/2, 3/4)', '(1/8, 0, 3/4)',
                          '(5/8, 1/2, 1/4)', '(1/4, 3/8, 0)',
                          '(3/4, 7/8, 1/2)', '(3/4, 1/8, 0)',
                          '(1/4, 5/8, 1/2)', '(0, 1/4, 3/8)',
                          '(1/2, 3/4, 7/8)', '(0, 3/4, 1/8)',
                          '(1/2, 1/4, 5/8)', '(3/4, 5/8, 0)',
                          '(1/4, 1/8, 1/2)', '(3/4, 3/8, 1/2)',
                          '(1/4, 7/8, 0)', '(1/8, 1/2, 1/4)', '(5/8, 0, 3/4)',
                          '(7/8, 0, 1/4)', '(3/8, 1/2, 3/4)', '(0, 1/4, 7/8)',
                          '(1/2, 3/4, 3/8)', '(1/2, 1/4, 1/8)',
                          '(0, 3/4, 5/8)'),
                      'hkl: h,k=2n, h+k+l=4n or h,k=2n+1, '
                      'l=4n+2 or h=8n, k=8n+4, h+k+l=4n+2'),
              '32e': (1, ('(x, x, x)', '(x+1/2, x+1/2, x+1/2)',
                          '(-x+1/2, -x, x+1/2)', '(-x, -x+1/2, x)',
                          '(-x, x+1/2, -x+1/2)', '(-x+1/2, x, -x)',
                          '(x+1/2, -x+1/2, -x)', '(x, -x, -x+1/2)',
                          '(x+3/4, x+1/4, -x+1/4)', '(x+1/4, x+3/4, -x+3/4)',
                          '(-x+3/4, -x+3/4, -x+3/4)',
                          '(-x+1/4, -x+1/4, -x+1/4)',
                          '(x+1/4, -x+1/4, x+3/4)', '(x+3/4, -x+3/4, x+1/4)',
                          '(-x+1/4, x+3/4, x+1/4)', '(-x+3/4, x+1/4, x+3/4)',
                          '(-x, -x, -x)', '(-x+1/2, -x+1/2, -x+1/2)',
                          '(x+1/2, x, -x+1/2)', '(x, x+1/2, -x)',
                          '(x, -x+1/2, x+1/2)', '(x+1/2, -x, x)',
                          '(-x+1/2, x+1/2, x)', '(-x, x, x+1/2)',
                          '(-x+1/4, -x+3/4, x+3/4)',
                          '(-x+3/4, -x+1/4, x+1/4)', '(x+1/4, x+1/4, x+1/4)',
                          '(x+3/4, x+3/4, x+3/4)', '(-x+3/4, x+3/4, -x+1/4)',
                          '(-x+1/4, x+1/4, -x+3/4)',
                          '(x+3/4, -x+1/4, -x+3/4)',
                          '(x+1/4, -x+3/4, -x+1/4)'), 'hkl: h=2n+1 or h+k+l=4n'
                      ),
              '48f': (1, ('(x, 0, 1/4)', '(x+1/2, 1/2, 3/4)',
                          '(-x+1/2, 0, 3/4)', '(-x, 1/2, 1/4)', '(1/4, x, 0)',
                          '(3/4, x+1/2, 1/2)', '(3/4, -x+1/2, 0)',
                          '(1/4, -x, 1/2)', '(0, 1/4, x)',
                          '(1/2, 3/4, x+1/2)', '(0, 3/4, -x+1/2)',
                          '(1/2, 1/4, -x)', '(3/4, x+1/4, 0)',
                          '(1/4, x+3/4, 1/2)', '(3/4, -x+3/4, 1/2)',
                          '(1/4, -x+1/4, 0)', '(x+3/4, 1/2, 1/4)',
                          '(x+1/4, 0, 3/4)', '(-x+1/4, 0, 1/4)',
                          '(-x+3/4, 1/2, 3/4)', '(0, 1/4, -x+1/4)',
                          '(1/2, 3/4, -x+3/4)', '(1/2, 1/4, x+3/4)',
                          '(0, 3/4, x+1/4)', '(-x, 0, 3/4)',
                          '(-x+1/2, 1/2, 1/4)', '(x+1/2, 0, 1/4)',
                          '(x, 1/2, 3/4)', '(3/4, -x, 0)',
                          '(1/4, -x+1/2, 1/2)', '(1/4, x+1/2, 0)',
                          '(3/4, x, 1/2)', '(0, 3/4, -x)',
                          '(1/2, 1/4, -x+1/2)', '(0, 1/4, x+1/2)',
                          '(1/2, 3/4, x)', '(1/4, -x+3/4, 0)',
                          '(3/4, -x+1/4, 1/2)', '(1/4, x+1/4, 1/2)',
                          '(3/4, x+3/4, 0)', '(-x+1/4, 1/2, 3/4)',
                          '(-x+3/4, 0, 1/4)', '(x+3/4, 0, 3/4)',
                          '(x+1/4, 1/2, 1/4)', '(0, 3/4, x+3/4)',
                          '(1/2, 1/4, x+1/4)', '(1/2, 3/4, -x+1/4)',
                          '(0, 1/4, -x+3/4)'), 'hkl: 2h+l=4n'),
              '48g': (2, ('(1/8, y, -y+1/4)', '(5/8, y+1/2, -y+3/4)',
                          '(3/8, -y, -y+3/4)', '(7/8, -y+1/2, -y+1/4)',
                          '(7/8, y+1/2, y+1/4)', '(3/8, y, y+3/4)',
                          '(5/8, -y+1/2, y+3/4)', '(1/8, -y, y+1/4)',
                          '(-y+1/4, 1/8, y)', '(-y+3/4, 5/8, y+1/2)',
                          '(-y+3/4, 3/8, -y)', '(-y+1/4, 7/8, -y+1/2)',
                          '(y+1/4, 7/8, y+1/2)', '(y+3/4, 3/8, y)',
                          '(y+3/4, 5/8, -y+1/2)', '(y+1/4, 1/8, -y)',
                          '(y, -y+1/4, 1/8)', '(y+1/2, -y+3/4, 5/8)',
                          '(-y, -y+3/4, 3/8)', '(-y+1/2, -y+1/4, 7/8)',
                          '(y+1/2, y+1/4, 7/8)', '(y, y+3/4, 3/8)',
                          '(-y+1/2, y+3/4, 5/8)', '(-y, y+1/4, 1/8)',
                          '(7/8, -y, y+3/4)', '(3/8, -y+1/2, y+1/4)',
                          '(5/8, y, y+1/4)', '(1/8, y+1/2, y+3/4)',
                          '(1/8, -y+1/2, -y+3/4)', '(5/8, -y, -y+1/4)',
                          '(3/8, y+1/2, -y+1/4)', '(7/8, y, -y+3/4)',
                          '(y+3/4, 7/8, -y)', '(y+1/4, 3/8, -y+1/2)',
                          '(y+1/4, 5/8, y)', '(y+3/4, 1/8, y+1/2)',
                          '(-y+3/4, 1/8, -y+1/2)', '(-y+1/4, 5/8, -y)',
                          '(-y+1/4, 3/8, y+1/2)', '(-y+3/4, 7/8, y)',
                          '(-y, y+3/4, 7/8)', '(-y+1/2, y+1/4, 3/8)',
                          '(y, y+1/4, 5/8)', '(y+1/2, y+3/4, 1/8)',
                          '(-y+1/2, -y+3/4, 1/8)', '(-y, -y+1/4, 5/8)',
                          '(y+1/2, -y+1/4, 3/8)', '(y, -y+3/4, 7/8)'),
                      'hkl: h=2n+1 or h=4n'),
              '96h': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)',
                          '(-x+1/2, -y, z+1/2)', '(-x, -y+1/2, z)',
                          '(-x, y+1/2, -z+1/2)', '(-x+1/2, y, -z)',
                          '(x+1/2, -y+1/2, -z)', '(x, -y, -z+1/2)',
                          '(z, x, y)', '(z+1/2, x+1/2, y+1/2)',
                          '(z+1/2, -x+1/2, -y)', '(z, -x, -y+1/2)',
                          '(-z+1/2, -x, y+1/2)', '(-z, -x+1/2, y)',
                          '(-z, x+1/2, -y+1/2)', '(-z+1/2, x, -y)',
                          '(y, z, x)', '(y+1/2, z+1/2, x+1/2)',
                          '(-y, z+1/2, -x+1/2)', '(-y+1/2, z, -x)',
                          '(y+1/2, -z+1/2, -x)', '(y, -z, -x+1/2)',
                          '(-y+1/2, -z, x+1/2)', '(-y, -z+1/2, x)',
                          '(y+3/4, x+1/4, -z+1/4)', '(y+1/4, x+3/4, -z+3/4)',
                          '(-y+3/4, -x+3/4, -z+3/4)',
                          '(-y+1/4, -x+1/4, -z+1/4)',
                          '(y+1/4, -x+1/4, z+3/4)', '(y+3/4, -x+3/4, z+1/4)',
                          '(-y+1/4, x+3/4, z+1/4)', '(-y+3/4, x+1/4, z+3/4)',
                          '(x+3/4, z+1/4, -y+1/4)', '(x+1/4, z+3/4, -y+3/4)',
                          '(-x+1/4, z+3/4, y+1/4)', '(-x+3/4, z+1/4, y+3/4)',
                          '(-x+3/4, -z+3/4, -y+3/4)',
                          '(-x+1/4, -z+1/4, -y+1/4)',
                          '(x+1/4, -z+1/4, y+3/4)', '(x+3/4, -z+3/4, y+1/4)',
                          '(z+3/4, y+1/4, -x+1/4)', '(z+1/4, y+3/4, -x+3/4)',
                          '(z+1/4, -y+1/4, x+3/4)', '(z+3/4, -y+3/4, x+1/4)',
                          '(-z+1/4, y+3/4, x+1/4)', '(-z+3/4, y+1/4, x+3/4)',
                          '(-z+3/4, -y+3/4, -x+3/4)',
                          '(-z+1/4, -y+1/4, -x+1/4)', '(-x, -y, -z)',
                          '(-x+1/2, -y+1/2, -z+1/2)', '(x+1/2, y, -z+1/2)',
                          '(x, y+1/2, -z)', '(x, -y+1/2, z+1/2)',
                          '(x+1/2, -y, z)', '(-x+1/2, y+1/2, z)',
                          '(-x, y, z+1/2)', '(-z, -x, -y)',
                          '(-z+1/2, -x+1/2, -y+1/2)', '(-z+1/2, x+1/2, y)',
                          '(-z, x, y+1/2)', '(z+1/2, x, -y+1/2)',
                          '(z, x+1/2, -y)', '(z, -x+1/2, y+1/2)',
                          '(z+1/2, -x, y)', '(-y, -z, -x)',
                          '(-y+1/2, -z+1/2, -x+1/2)', '(y, -z+1/2, x+1/2)',
                          '(y+1/2, -z, x)', '(-y+1/2, z+1/2, x)',
                          '(-y, z, x+1/2)', '(y+1/2, z, -x+1/2)',
                          '(y, z+1/2, -x)', '(-y+1/4, -x+3/4, z+3/4)',
                          '(-y+3/4, -x+1/4, z+1/4)', '(y+1/4, x+1/4, z+1/4)',
                          '(y+3/4, x+3/4, z+3/4)', '(-y+3/4, x+3/4, -z+1/4)',
                          '(-y+1/4, x+1/4, -z+3/4)',
                          '(y+3/4, -x+1/4, -z+3/4)',
                          '(y+1/4, -x+3/4, -z+1/4)',
                          '(-x+1/4, -z+3/4, y+3/4)',
                          '(-x+3/4, -z+1/4, y+1/4)',
                          '(x+3/4, -z+1/4, -y+3/4)',
                          '(x+1/4, -z+3/4, -y+1/4)', '(x+1/4, z+1/4, y+1/4)',
                          '(x+3/4, z+3/4, y+3/4)', '(-x+3/4, z+3/4, -y+1/4)',
                          '(-x+1/4, z+1/4, -y+3/4)',
                          '(-z+1/4, -y+3/4, x+3/4)',
                          '(-z+3/4, -y+1/4, x+1/4)',
                          '(-z+3/4, y+3/4, -x+1/4)',
                          '(-z+1/4, y+1/4, -x+3/4)',
                          '(z+3/4, -y+1/4, -x+3/4)',
                          '(z+1/4, -y+3/4, -x+1/4)', '(z+1/4, y+1/4, x+1/4)',
                          '(z+3/4, y+3/4, x+3/4)'),
                      'hkl: h+k+l=2n, 0kl: k,l=2n, hhl: 2h+l=4n, h00: h=4n')},
      }
