import requests
from .error_handling import NoResultFound
from bs4 import BeautifulSoup
from googlesearch import search

class Lyricspedia:
    def __init__(self, title: str):
        anu = search('site:animesonglyrics.com {}'.format(title), num_results=0)
        abu = ''.join(anu)

        url = requests.get(abu)
        if not url:
            raise NoResultFound(f'{url} Not Found')
        
        soup = BeautifulSoup(url.content, 'html.parser')
        for a in soup.findAll("br"):
            a.replace_with("\n")
        try:
            lyrics_romaji = soup.find('div', {'id': 'tab1'}).text
        except AttributeError:
            raise AttributeError('Can\' find a anime song')
        lyrics_romaji0 = lyrics_romaji.split('[')[0]
        lyrics_romaji1 = lyrics_romaji.split('[')[1]
        lyrics_romaji = '  {} [{}'.format(lyrics_romaji0, lyrics_romaji1)
        lyrics_romaji = lyrics_romaji.replace('                                                            ', '')
        self.lyrics_romaji = lyrics_romaji or None
        try:
            lyrics_en = soup.find('div', {'id': 'tab2'}).text
        except AttributeError:
            raise AttributeError('Can\' find a anime song')
        lyrics_en0 = lyrics_en.split('[')[0]
        lyrics_en1 = lyrics_en.split('[')[1]
        lyrics_en = ' {} [{}'.format(lyrics_en0, lyrics_en1)
        self.lyrics_en = lyrics_en or None
        name = soup.find('div', {'id': 'wrapper'})
        name = name.h1.text
        name = name.replace('                ','')
        self.name = name