# Contributing to kagglehub

First off, thanks for taking the time to contribute!

All types of contributions are encouraged and valued.

## Issues

We use GitHub issues to track **public** bugs and feature requests. Please ensure your description is clear and has sufficient instructions to be able to reproduce the issue.

If you found a bug or have a feature request, follow these instructions:

* Open an [Issue](/issues/new).
* Provide as much context as you can about what you're running into.
* Provide project and platform versions (python, pip, kagglehub), depending on what seems relevant.

## Pull Requests (PRs)

We encourage everyone to open an issue first to discuss the general approach before opening a PR to reduce churns. If your solution to a bug you found is trivial, we also accept PRs directly.

Please follow these best practices when opening a PR:

* Use a **clear and descriptive title**.
* If your PR adds a user-facing feature or fixes a bug, make sure to add an entry under the "Next Release" section in the [CHANGELOG.md](CHANGELOG.md)
* If your PR fixes a specific issue, add `Fixes #<ISSUE_NUMBER>` to your PR's description.
* Include screenshots/console output of the behavior before and after the fix.
* Include instructions on how to reproduce the issue and test the fixes.