/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:58 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Surfaceroughness" CASCADE
;

/* Create Tables */

CREATE TABLE "Surfaceroughness"
(
	"Surfaceroughness" varchar NULL,	-- 4-06 surface roughness at the facility. From the SurfaceRoughnessType codelist.
	"Validperiod" varchar NULL,	-- The time period for which the specified surfaceRoughness is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next surfaceRoughness on record. If only one surfaceRoughness is specified for an observing facility, the time stamp is optional.
	"SurfaceroughnessID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Surfaceroughness" ADD CONSTRAINT "PK_Surfaceroughness"
	PRIMARY KEY ("SurfaceroughnessID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Surfaceroughness"
	IS 'A SurfaceRoughness is a specification of surfaceRoughness accompanied by a timestamp indicating the time from which that surfaceRoughness is considered to be valid. If known, an end time may also be provided. In WIGOS, an ObservingFacility may carry multiple surfaceRoughness specifications which are valid over different consecutive periods of time. If only a single surfaceRoughness is specified, the timestamp is optional.'
;

COMMENT ON COLUMN "Surfaceroughness"."Surfaceroughness"
	IS '4-06 surface roughness at the facility. From the SurfaceRoughnessType codelist.'
;

COMMENT ON COLUMN "Surfaceroughness"."Validperiod"
	IS 'The time period for which the specified surfaceRoughness is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next surfaceRoughness on record. If only one surfaceRoughness is specified for an observing facility, the time stamp is optional.'
;