/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Responsibleparty" CASCADE
;

/* Create Tables */

CREATE TABLE "Responsibleparty"
(
	"Responsibleparty" varchar NULL,	-- 10-01 Party (organization or individual) responsible for the observing facility or equipment.
	"Validperiod" varchar NULL,	-- The time period for which this responsibleParty is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next responsibleParty on record.
	"ResponsiblepartyID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Responsibleparty" ADD CONSTRAINT "PK_Responsibleparty"
	PRIMARY KEY ("ResponsiblepartyID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Responsibleparty"
	IS 'A ResponsibleParty is an individual or organization accompanied by a timestamp indicating the time from which that responsibleParty is considered to be valid. If known, an end time may also be provided. In WIGOS, an ObservingFacility or Equipment may carry multiple responsibleParty which are valid over different periods of time.'
;

COMMENT ON COLUMN "Responsibleparty"."Responsibleparty"
	IS '10-01 Party (organization or individual) responsible for the observing facility or equipment.'
;

COMMENT ON COLUMN "Responsibleparty"."Validperiod"
	IS 'The time period for which this responsibleParty is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next responsibleParty on record.'
;