/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:57 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Processing" CASCADE
;

/* Create Tables */

CREATE TABLE "Processing"
(
	"Aggregationperiod" varchar NULL,	-- 7-09 Time period over which individual samples/observations are aggregated
	"Dataprocessing" varchar NULL,	-- 7-01 A description of the data processing used to generate observations including, if relevant, algorithms used to derive the result.
	"Processingcentre" varchar NULL,	-- 7-02 Center at which the observation is processed. Although this is a free text string, it is expected that in practice this value should be from a controlled list of known centers.
	"Softwaredetails" varchar NULL,	-- 7-05 Name and version of the software or processor used to derive the values
	"Softwareurl" varchar NULL,	-- 7-05 URL for the software or processor used to derive the values
	"ProcessingID" varchar NOT NULL,
	"DatagenerationID" varchar NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Processing" ADD CONSTRAINT "PK_Processing"
	PRIMARY KEY ("ProcessingID")
;

/* Create Foreign Key Constraints */

ALTER TABLE "Processing" ADD CONSTRAINT "FK_Processing_processing"
	FOREIGN KEY ("DatagenerationID") REFERENCES "Datageneration" ("DatagenerationID") ON DELETE No Action ON UPDATE No Action
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Processing"
	IS '[WMDS Category 7] Details of the processing procedures including analysis and post-processing.'
;

COMMENT ON COLUMN "Processing"."Aggregationperiod"
	IS '7-09 Time period over which individual samples/observations are aggregated'
;

COMMENT ON COLUMN "Processing"."Dataprocessing"
	IS '7-01 A description of the data processing used to generate observations including, if relevant, algorithms used to derive the result.'
;

COMMENT ON COLUMN "Processing"."Processingcentre"
	IS '7-02 Center at which the observation is processed. Although this is a free text string, it is expected that in practice this value should be from a controlled list of known centers.'
;

COMMENT ON COLUMN "Processing"."Softwaredetails"
	IS '7-05 Name and version of the software or processor used to derive the values'
;

COMMENT ON COLUMN "Processing"."Softwareurl"
	IS '7-05 URL for the software or processor used to derive the values'
;