/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 04-May-2022 21:43:55 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Description" CASCADE
;

/* Create Tables */

CREATE TABLE "Description"
(
	"Description" varchar NULL,	-- 4-05 Non-formalized information about the location and surroundings at which an observation is made and that may influence it. In WIGOS, description is used to describe an observingFacility or Equipment. 
	"Validperiod" varchar NULL,	-- Specifies at least the begin date of the indicated description. If omitted, the dateEstablished of the facility or deployedEquipment.validPeriod will be assumed.
	"DescriptionID" varchar NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Description" ADD CONSTRAINT "PK_Description"
	PRIMARY KEY ("DescriptionID")
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Description"
	IS 'A Description is a description accompanied by a timestamp indicating the time from which that description is considered to be valid. If known, an end time may also be provided. In WIGOS, an ObservingFacility or Equipment may carry multiple descriptions which are valid over different periods of time.'
;

COMMENT ON COLUMN "Description"."Description"
	IS '4-05 Non-formalized information about the location and surroundings at which an observation is made and that may influence it. In WIGOS, description is used to describe an observingFacility or Equipment. '
;

COMMENT ON COLUMN "Description"."Validperiod"
	IS 'Specifies at least the begin date of the indicated description. If omitted, the dateEstablished of the facility or deployedEquipment.validPeriod will be assumed.'
;