/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 15.2 		*/
/*  Created On : 27-Jun-2022 09:29:27 				*/
/*  DBMS       : PostgreSQL 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

DROP TABLE IF EXISTS "Abstractenvironmentalmonitoringfacility" CASCADE
;

DROP TABLE IF EXISTS "Altitude-or-depth" CASCADE
;

DROP TABLE IF EXISTS "Altitudeordepthtype" CASCADE
;

DROP TABLE IF EXISTS "Application-area" CASCADE
;

DROP TABLE IF EXISTS "Applicationareatype" CASCADE
;

DROP TABLE IF EXISTS "Attribution" CASCADE
;

DROP TABLE IF EXISTS "Climatezone" CASCADE
;

DROP TABLE IF EXISTS "Climate-zone" CASCADE
;

DROP TABLE IF EXISTS "Climatezonetype" CASCADE
;

DROP TABLE IF EXISTS "Communication-method" CASCADE
;

DROP TABLE IF EXISTS "Controlchecklocationtype" CASCADE
;

DROP TABLE IF EXISTS "Controlcheckreport" CASCADE
;

DROP TABLE IF EXISTS "Controlstandardtype" CASCADE
;

DROP TABLE IF EXISTS "Coordinatereferencesystemtype" CASCADE
;

DROP TABLE IF EXISTS "Coordinatesreferencesystemtype" CASCADE
;

DROP TABLE IF EXISTS "Datacommunicationmethodtype" CASCADE
;

DROP TABLE IF EXISTS "Data-format" CASCADE
;

DROP TABLE IF EXISTS "Dataformattype" CASCADE
;

DROP TABLE IF EXISTS "Datageneration" CASCADE
;

DROP TABLE IF EXISTS "Datapolicy" CASCADE
;

DROP TABLE IF EXISTS "Datapolicytype" CASCADE
;

DROP TABLE IF EXISTS "Data-use-constraints" CASCADE
;

DROP TABLE IF EXISTS "Deployment" CASCADE
;

DROP TABLE IF EXISTS "Deployment" CASCADE
;

DROP TABLE IF EXISTS "Deployment-valid" CASCADE
;

DROP TABLE IF EXISTS "Description" CASCADE
;

DROP TABLE IF EXISTS "Equipment" CASCADE
;

DROP TABLE IF EXISTS "Equipment" CASCADE
;

DROP TABLE IF EXISTS "EquipmentEquipment" CASCADE
;

DROP TABLE IF EXISTS "Equipmentlog" CASCADE
;

DROP TABLE IF EXISTS "Equipment-log" CASCADE
;

DROP TABLE IF EXISTS "Equipment-log-entries" CASCADE
;

DROP TABLE IF EXISTS "Equipment-log-entries-control-location" CASCADE
;

DROP TABLE IF EXISTS "Equipment-log-entries-control-result" CASCADE
;

DROP TABLE IF EXISTS "Equipment-log-entries-control-standard" CASCADE
;

DROP TABLE IF EXISTS "Equipment-log-valid" CASCADE
;

DROP TABLE IF EXISTS "Equipment-valid" CASCADE
;

DROP TABLE IF EXISTS "Eventreport" CASCADE
;

DROP TABLE IF EXISTS "Eventtype" CASCADE
;

DROP TABLE IF EXISTS "Exposure" CASCADE
;

DROP TABLE IF EXISTS "Exposuretype" CASCADE
;

DROP TABLE IF EXISTS "Facilitylog" CASCADE
;

DROP TABLE IF EXISTS "Facility-log" CASCADE
;

DROP TABLE IF EXISTS "Facility-log-entries" CASCADE
;

DROP TABLE IF EXISTS "Facility-log-entries-event-type" CASCADE
;

DROP TABLE IF EXISTS "Facility-log-valid" CASCADE
;

DROP TABLE IF EXISTS "Facilityset" CASCADE
;

DROP TABLE IF EXISTS "FacilitySetObservingFacility" CASCADE
;

DROP TABLE IF EXISTS "Facility-type" CASCADE
;

DROP TABLE IF EXISTS "Facility-valid" CASCADE
;

DROP TABLE IF EXISTS "Frequencies" CASCADE
;

DROP TABLE IF EXISTS "Frequencyusetype" CASCADE
;

DROP TABLE IF EXISTS "Geopositioning-method" CASCADE
;

DROP TABLE IF EXISTS "Geopositioning-method" CASCADE
;

DROP TABLE IF EXISTS "Geopositioningmethodtype" CASCADE
;

DROP TABLE IF EXISTS "Geospatiallocation" CASCADE
;

DROP TABLE IF EXISTS "Header" CASCADE
;

DROP TABLE IF EXISTS "Instrumentcontrolresulttype" CASCADE
;

DROP TABLE IF EXISTS "Instrumentcontrolscheduletype" CASCADE
;

DROP TABLE IF EXISTS "Instrumentoperatingstatus" CASCADE
;

DROP TABLE IF EXISTS "Instrument-operating-status" CASCADE
;

DROP TABLE IF EXISTS "Instrumentoperatingstatustype" CASCADE
;

DROP TABLE IF EXISTS "Level-of-data" CASCADE
;

DROP TABLE IF EXISTS "Levelofdatatype" CASCADE
;

DROP TABLE IF EXISTS "Localreferencesurfacetype" CASCADE
;

DROP TABLE IF EXISTS "Local-topography" CASCADE
;

DROP TABLE IF EXISTS "Localtopographytype" CASCADE
;

DROP TABLE IF EXISTS "Log" CASCADE
;

DROP TABLE IF EXISTS "Logentry" CASCADE
;

DROP TABLE IF EXISTS "Maintenancereport" CASCADE
;

DROP TABLE IF EXISTS "Measurementunittype" CASCADE
;

DROP TABLE IF EXISTS "Metadata-record" CASCADE
;

DROP TABLE IF EXISTS "Observation" CASCADE
;

DROP TABLE IF EXISTS "Observation-feature-of-interest" CASCADE
;

DROP TABLE IF EXISTS "Observation-observed-property" CASCADE
;

DROP TABLE IF EXISTS "Observation-process" CASCADE
;

DROP TABLE IF EXISTS "Observation-result" CASCADE
;

DROP TABLE IF EXISTS "Observation-valid" CASCADE
;

DROP TABLE IF EXISTS "Observedvariabletype" CASCADE
;

DROP TABLE IF EXISTS "Observingcapability" CASCADE
;

DROP TABLE IF EXISTS "Observingfacility" CASCADE
;

DROP TABLE IF EXISTS "Observing-facility" CASCADE
;

DROP TABLE IF EXISTS "Observingfacilitytype" CASCADE
;

DROP TABLE IF EXISTS "Observing-method" CASCADE
;

DROP TABLE IF EXISTS "Observingmethodtype" CASCADE
;

DROP TABLE IF EXISTS "Polarizationtype" CASCADE
;

DROP TABLE IF EXISTS "Population" CASCADE
;

DROP TABLE IF EXISTS "Process" CASCADE
;

DROP TABLE IF EXISTS "Process" CASCADE
;

DROP TABLE IF EXISTS "Processing" CASCADE
;

DROP TABLE IF EXISTS "Processing" CASCADE
;

DROP TABLE IF EXISTS "Processing-valid" CASCADE
;

DROP TABLE IF EXISTS "Process-valid" CASCADE
;

DROP TABLE IF EXISTS "Programaffiliation" CASCADE
;

DROP TABLE IF EXISTS "Program-affiliation" CASCADE
;

DROP TABLE IF EXISTS "Programornetworkaffiliationtype" CASCADE
;

DROP TABLE IF EXISTS "Purposeoffrequencyusetype" CASCADE
;

DROP TABLE IF EXISTS "Qualityflagtype" CASCADE
;

DROP TABLE IF EXISTS "Record-valid" CASCADE
;

DROP TABLE IF EXISTS "Reference-time" CASCADE
;

DROP TABLE IF EXISTS "Referencetimetype" CASCADE
;

DROP TABLE IF EXISTS "Relative-elevation" CASCADE
;

DROP TABLE IF EXISTS "Relativeelevationtype" CASCADE
;

DROP TABLE IF EXISTS "Reporting" CASCADE
;

DROP TABLE IF EXISTS "Reporting" CASCADE
;

DROP TABLE IF EXISTS "Reportingstatus" CASCADE
;

DROP TABLE IF EXISTS "Reporting-status" CASCADE
;

DROP TABLE IF EXISTS "Reportingstatustype" CASCADE
;

DROP TABLE IF EXISTS "Reporting-valid" CASCADE
;

DROP TABLE IF EXISTS "Representativeness" CASCADE
;

DROP TABLE IF EXISTS "Representativenesstype" CASCADE
;

DROP TABLE IF EXISTS "Responsibleparty" CASCADE
;

DROP TABLE IF EXISTS "Resultset" CASCADE
;

DROP TABLE IF EXISTS "Sampletreatmenttype" CASCADE
;

DROP TABLE IF EXISTS "Sampling" CASCADE
;

DROP TABLE IF EXISTS "Sampling" CASCADE
;

DROP TABLE IF EXISTS "Samplingproceduretype" CASCADE
;

DROP TABLE IF EXISTS "Sampling-strategy" CASCADE
;

DROP TABLE IF EXISTS "Samplingstrategytype" CASCADE
;

DROP TABLE IF EXISTS "Sampling-valid" CASCADE
;

DROP TABLE IF EXISTS "Schedule" CASCADE
;

DROP TABLE IF EXISTS "Source-of-observation" CASCADE
;

DROP TABLE IF EXISTS "Sourceofobservationtype" CASCADE
;

DROP TABLE IF EXISTS "Surfacecover" CASCADE
;

DROP TABLE IF EXISTS "Surface-cover" CASCADE
;

DROP TABLE IF EXISTS "Surface-cover-classification" CASCADE
;

DROP TABLE IF EXISTS "Surfacecoverclassificationtype" CASCADE
;

DROP TABLE IF EXISTS "Surfacecovertype" CASCADE
;

DROP TABLE IF EXISTS "Surfaceroughness" CASCADE
;

DROP TABLE IF EXISTS "Surface-roughness" CASCADE
;

DROP TABLE IF EXISTS "Surfaceroughnesstype" CASCADE
;

DROP TABLE IF EXISTS "Territory" CASCADE
;

DROP TABLE IF EXISTS "Territory-name" CASCADE
;

DROP TABLE IF EXISTS "Territorytype" CASCADE
;

DROP TABLE IF EXISTS "Time-encoding" CASCADE
;

DROP TABLE IF EXISTS "Time-stamp-meaning" CASCADE
;

DROP TABLE IF EXISTS "Timestampmeaningtype" CASCADE
;

DROP TABLE IF EXISTS "Timezone" CASCADE
;

DROP TABLE IF EXISTS "Time-zone-explicit" CASCADE
;

DROP TABLE IF EXISTS "Timezonetype" CASCADE
;

DROP TABLE IF EXISTS "Topographic-context" CASCADE
;

DROP TABLE IF EXISTS "Topographiccontexttype" CASCADE
;

DROP TABLE IF EXISTS "Topographybathymetry" CASCADE
;

DROP TABLE IF EXISTS "Traceabilitytype" CASCADE
;

DROP TABLE IF EXISTS "Transmissionmodetype" CASCADE
;

DROP TABLE IF EXISTS "Uncertaintyevalproctype" CASCADE
;

DROP TABLE IF EXISTS "Unique-observed-variable" CASCADE
;

DROP TABLE IF EXISTS "Unit-of-measure" CASCADE
;

DROP TABLE IF EXISTS "Valid-local-references" CASCADE
;

DROP TABLE IF EXISTS "Well-formed" CASCADE
;

DROP TABLE IF EXISTS "Wigosmetadatarecord" CASCADE
;

DROP TABLE IF EXISTS "Wmo-region" CASCADE
;

DROP TABLE IF EXISTS "Wmoregiontype" CASCADE
;

DROP TABLE IF EXISTS "Xml-rules" CASCADE
;

DROP TABLE IF EXISTS "Xsd-valid" CASCADE
;

/* Create Tables */

CREATE TABLE "Abstractenvironmentalmonitoringfacility"
(
	"Description" varchar(50) NULL,	-- 4-05 Non-formalized information about the location and surroundings at which an observation is made and that may influence it. In WIGOS, description is used to describe an observingFacility or Equipment. 
	"Extension" varchar(50) NULL,	-- This extension point is to facilitate the encoding of any other information for complimentary or local purposes such as complying with legislative frameworks. However it should not be expected that any extension information will be appropriately processed, stored or made retrievable from any WIGOS systems or services. 
	"Geospatiallocation" varchar(50) NULL,	-- 3-07 Position in space defining the location of the environmental monitoring station/platform at the time of observation.  5-12 Geospatial location of instrument/sensor
	"Onlineresource" varchar(50) NULL,	-- An online resource containing additional information about the facility or equipment
	"Responsibleparty" varchar(50) NULL,	-- The organisation responsible.
	"AbstractenvironmentalmonitoringfacilityID" integer NOT NULL
)
;

CREATE TABLE "Altitude-or-depth"
(
	"Altitude-or-depthID" integer NOT NULL
)
;

CREATE TABLE "Altitudeordepthtype"
(
	"AltitudeordepthtypeID" integer NOT NULL
)
;

CREATE TABLE "Application-area"
(
	"Application-areaID" integer NOT NULL
)
;

CREATE TABLE "Applicationareatype"
(
	"ApplicationareatypeID" integer NOT NULL
)
;

CREATE TABLE "Attribution"
(
	"Originator" varchar(50) NULL,	-- Identifies the individual and/or organization at the origin of the resource. This is typically the owner of the ressource, e.g., a data set.
	"Originatorurl" varchar(50) NULL,
	"Source" varchar(50) NULL,
	"Title" varchar(50) NULL,	-- The title of the attributed work.
	"AttributionID" integer NOT NULL
)
;

CREATE TABLE "Climatezone"
(
	"Climatezone" varchar(50) NULL,	-- 4-07 type of climate zone at the facility. From the ClimateZoneType codelist.
	"Validperiod" varchar(50) NULL,	-- The time period for which the specified climateZone is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next climateZone on record. If only one climateZone is specified for an observing facility, the time stamp is optional.
	"ClimatezoneID" integer NOT NULL
)
;

CREATE TABLE "Climate-zone"
(
	"Climate-zoneID" integer NOT NULL
)
;

CREATE TABLE "Climatezonetype"
(
	"ClimatezonetypeID" integer NOT NULL
)
;

CREATE TABLE "Communication-method"
(
	"Communication-methodID" integer NOT NULL
)
;

CREATE TABLE "Controlchecklocationtype"
(
	"ControlchecklocationtypeID" integer NOT NULL
)
;

CREATE TABLE "Controlcheckreport"
(
	"Alternateuri" varchar(50) NULL,	-- 5-08 Alternatively the summary of the control check may be provided via a URI that resolves to a document containing this information.
	"Checklocation" varchar(50) NULL,	-- 5-08 Location of sensor when check was performed (e.g. in-situ, offsite etc.) From codelist ControlCheckLocationType.
	"Controlcheckresult" varchar(50) NULL,	-- 5-08 Result of the control check, from InstrumentControlResultType codelist
	"Periodofvalidity" varchar(50) NULL,	-- 5-08 period of validity of the control check (e.g. 4 years)
	"Standardname" varchar(50) NULL,	-- 5-08 Nameof the Standard used.
	"Standardserialnumber" varchar(50) NULL,	-- 5-08 Serial Number of the standard used.
	"Standardtype" varchar(50) NULL,	-- 5-08 Type of the Standard used. From the StandardType code list.
	"Withinverificationlimit" boolean NULL,	-- 5-08 Was the instrument found to be within verification limits (True if yes, False if no)
	"ControlcheckreportID" integer NOT NULL
)
;

CREATE TABLE "Controlstandardtype"
(
	"ControlstandardtypeID" integer NOT NULL
)
;

CREATE TABLE "Coordinatereferencesystemtype"
(
	"CoordinatereferencesystemtypeID" integer NOT NULL
)
;

CREATE TABLE "Coordinatesreferencesystemtype"
(
	"CoordinatesreferencesystemtypeID" integer NOT NULL
)
;

CREATE TABLE "Datacommunicationmethodtype"
(
	"DatacommunicationmethodtypeID" integer NOT NULL
)
;

CREATE TABLE "Data-format"
(
	"Data-formatID" integer NOT NULL
)
;

CREATE TABLE "Dataformattype"
(
	"DataformattypeID" integer NOT NULL
)
;

CREATE TABLE "Datageneration"
(
	"Validperiod" varchar(50) NULL,	-- The period of time for which this processing arrangement was/is in place. (Note: this time period must fall within the time period specified in the Deployment).
	"DatagenerationID" integer NOT NULL,
	"DeploymentID" integer NULL
)
;

CREATE TABLE "Datapolicy"
(
	"Attribution" varchar(50) NULL,	-- Describes the attribution details pertinent to dataPolicy
	"Datapolicy" varchar(50) NULL,	-- 9-02 Details relating to the use and limitations surrounding data imposed by the supervising organization.
	"DatapolicyID" integer NOT NULL
)
;

CREATE TABLE "Datapolicytype"
(
	"DatapolicytypeID" integer NOT NULL
)
;

CREATE TABLE "Data-use-constraints"
(
	"Data-use-constraintsID" integer NOT NULL
)
;

CREATE TABLE "Deployment"
(
	"Applicationarea" varchar(50) NULL,	-- 2-01 The context within, or intended application(s) for which the observation is primarily made or which has/have the most stringent requirements.
	"Communicationmethod" varchar(50) NULL,	-- 3-08 The primary data communication method, from the DataCommunicationMethodType codelist.
	"Configuration" varchar(50) NULL,	-- 5-06 Description of any shielding or configuration/setup of the instrumentation.
	"Controlschedule" varchar(50) NULL,	-- 5-07 Description of schedule for calibrations or verification of instrument.
	"Exposure" varchar(50) NULL,	-- 5-15 The degree to which an instrument is affected by external influences according to the CIMO classification. Value from ExposureType codelist.
	"Heightabovelocalreferencesurface" varchar(50) NULL,	-- 5-05 Vertical distance of sensor from specified reference surface, in the direction away from the earth's center. Positive values indicate above reference surface, negative values indicate below references surface (e.g., below ocean surface).
	"Instrumentoperatingstatus" varchar(50) NULL,	-- 5-04 The operational status of the instrument when deployed (Operational, testing etc.).
	"Localreferencesurface" varchar(50) NULL,	-- 5-05 Description of the specified reference surface taken from the codelist LocalReferenceSurfaceType
	"Maintenanceschedule" varchar(50) NULL,	-- 5-10 A description (and schedule) of maintenance that is routinely performed on an instrument
	"Representativeness" varchar(50) NULL,	-- 1-05 An assessment of the representativeness of the observations from the RepresentativenessType codelist.
	"Sourceofobservation" varchar(50) NULL,	-- 5-01 The source of the observation (manual, automatic, visual etc.) from the SourceOfObservationType codelist.
	"Validperiod" varchar(50) NULL,	-- The period of time for which this deployment configuration was/is in place. (Note: this time period must fall within the time period specified in the OM_Observation phenomenonTime)
	"DeploymentID" integer NOT NULL,
	"ProcessID" integer NULL
)
;

CREATE TABLE "Deployment"
(
	"Deployment" varchar(50) NULL,
	"DeploymentID" integer NOT NULL
)
;

CREATE TABLE "Deployment-valid"
(
	"Deployment-validID" integer NOT NULL
)
;

CREATE TABLE "Description"
(
	"Description" varchar(50) NULL,	-- 4-05 Non-formalized information about the location and surroundings at which an observation is made and that may influence it. In WIGOS, description is used to describe an observingFacility or Equipment. 
	"Validperiod" varchar(50) NULL,	-- Specifies at least the begin date of the indicated description. If omitted, the dateEstablished of the facility or deployedEquipment.validPeriod will be assumed.
	"DescriptionID" integer NOT NULL
)
;

CREATE TABLE "Equipment"
(
	"Driftperunittime" varchar(50) NULL,	-- 5-03 Intrinsic capability of the measurement/observing method - drift per unit time. Typically a percentage per unit time but could be absolute e.g. 1 deg per year.
	"Firmwareversion" varchar(50) NULL,	-- 5-09 Firmware version of the equipment
	"Manufacturer" varchar(50) NULL,	-- 5-09 Manufacturer of the equipment
	"Model" varchar(50) NULL,	-- 5-09 Model number of the equipment
	"Observablerange" varchar(50) NULL,	-- 5-03 Intrinsic capability of the measurement/observing method - range
	"Observingmethod" varchar(50) NULL,	-- 5-02 The method of measurement/observation used from the ObservingMethodType codelist.
	"Observingmethoddetails" varchar(50) NULL,	-- 5-02 A description of the method of measurement/observation used from the ObservingMethodType codelist. 
	"Serialnumber" varchar(50) NULL,	-- 5-09 Serial number of the equipment 
	"Specificationlink" varchar(50) NULL,	-- 5-03 Link to manufacturers (or other) specification describing the equipment.
	"Specifiedabsoluteuncertainty" varchar(50) NULL,	-- 5-03 Intrinsic capability of the measurement/observing method - specified absolute uncertainty e.g. 0.2 deg C (k=2).
	"Specifiedrelativeuncertainty" varchar(50) NULL,	-- 5-03 Intrinsic capability of the measurement/observing method - specified relative uncertainty. Typically a percentage.
	"Subequipment" varchar(50) NULL,
	"Uncertaintyevalproc" varchar(50) NULL,
	"EquipmentID" integer NOT NULL,
	"DeploymentID" integer NULL,
	facility integer NULL
)
;

CREATE TABLE "Equipment"
(
	"Equipment" varchar(50) NULL,
	"EquipmentID" integer NOT NULL
)
;

CREATE TABLE "EquipmentEquipment"
(
	"subEquipment" integer NULL,
	"EquipmentID" integer NULL
)
;

CREATE TABLE "Equipmentlog"
(
	"EquipmentlogID" integer NOT NULL,
	equipment integer NULL
)
;

CREATE TABLE "Equipment-log"
(
	"Equipment-log" varchar(50) NULL,
	"Equipment-logID" integer NOT NULL
)
;

CREATE TABLE "Equipment-log-entries"
(
	"Equipment-log-entriesID" integer NOT NULL
)
;

CREATE TABLE "Equipment-log-entries-control-location"
(
	"Equipment-log-entries-control-locationID" integer NOT NULL
)
;

CREATE TABLE "Equipment-log-entries-control-result"
(
	"Equipment-log-entries-control-resultID" integer NOT NULL
)
;

CREATE TABLE "Equipment-log-entries-control-standard"
(
	"Equipment-log-entries-control-standardID" integer NOT NULL
)
;

CREATE TABLE "Equipment-log-valid"
(
	"Equipment-log-validID" integer NOT NULL
)
;

CREATE TABLE "Equipment-valid"
(
	"Equipment-validID" integer NOT NULL
)
;

CREATE TABLE "Eventreport"
(
	"Typeofevent" varchar(50) NULL,	-- The type of event, taken from the EventType codelist (e.g. tree removal, storm damage etc).
	"Validperiod" varchar(50) NULL,
	"EventreportID" integer NOT NULL
)
;

CREATE TABLE "Eventtype"
(
	"EventtypeID" integer NOT NULL
)
;

CREATE TABLE "Exposure"
(
	"ExposureID" integer NOT NULL
)
;

CREATE TABLE "Exposuretype"
(
	"ExposuretypeID" integer NOT NULL
)
;

CREATE TABLE "Facilitylog"
(
	"FacilitylogID" integer NOT NULL,
	facility integer NULL
)
;

CREATE TABLE "Facility-log"
(
	"Facility-log" varchar(50) NULL,
	"Facility-logID" integer NOT NULL
)
;

CREATE TABLE "Facility-log-entries"
(
	"Facility-log-entriesID" integer NOT NULL
)
;

CREATE TABLE "Facility-log-entries-event-type"
(
	"Facility-log-entries-event-typeID" integer NOT NULL
)
;

CREATE TABLE "Facility-log-valid"
(
	"Facility-log-validID" integer NOT NULL
)
;

CREATE TABLE "Facilityset"
(
	"FacilitysetID" integer NOT NULL
)
;

CREATE TABLE "FacilitySetObservingFacility"
(
	facility integer NULL,
	"facilitySet" integer NULL
)
;

CREATE TABLE "Facility-type"
(
	"Facility-typeID" integer NOT NULL
)
;

CREATE TABLE "Facility-valid"
(
	"Facility-validID" integer NOT NULL
)
;

CREATE TABLE "Frequencies"
(
	"Bandwidth" varchar(50) NULL,	-- The difference of the highest and the lowest frequency, expressed as a number with a unit of measure (uom). Expected values for gml attribute uom are: Hz, kHz, MHz, GHz, THz
	"Channel" varchar(50) NULL,	-- A name describing the frequency used
	"Frequency" varchar(50) NULL,	-- The nominal frequency used, expressed as a number with a unit of measure (uom). Expected values for gml attribute uom are: Hz, kHz, MHz, GHz, THz
	"Frequencyuse" varchar(50) NULL,	-- expected values are: Transmit, Receive, TransmitReceive
	"Polarization" varchar(50) NULL,
	"Purposeoffrequencyuse" varchar(50) NULL,	-- expected values are: observation, telecomms
	"Transmissionmode" varchar(50) NULL,	-- expected values are: pulsed, continuous use conditional on frequencyUse = Transmit
	"FrequenciesID" integer NOT NULL,
	"EquipmentID" integer NULL
)
;

CREATE TABLE "Frequencyusetype"
(
	"FrequencyusetypeID" integer NOT NULL
)
;

CREATE TABLE "Geopositioning-method"
(
	"Geopositioning-methodID" integer NOT NULL
)
;

CREATE TABLE "Geopositioning-method"
(
	"Geopositioning-methodID" integer NOT NULL
)
;

CREATE TABLE "Geopositioningmethodtype"
(
	"GeopositioningmethodtypeID" integer NOT NULL
)
;

CREATE TABLE "Geospatiallocation"
(
	"Coordinatereferencesystem" varchar(50) NULL,
	"Geolocation" varchar(50) NULL,	-- 3-07 Representative or conventional geospatial location of observing facility, the reference location. This will always be a point location, but this location can change with time.  5-12 Geospatial location of instrument or observing equipment, typically the location of the sensing element or sample inlet. This will always be a point location, but this location can change with time. 
	"Geopositioningmethod" varchar(50) NULL,	-- Element describes the method used to establish the specified geoLocation. [Codelist 11-01]
	"Validperiod" varchar(50) NULL,	-- The time period for which this geoLocation is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next geoLocation on record.
	"GeospatiallocationID" integer NOT NULL
)
;

CREATE TABLE "Header"
(
	"Filedatetime" timestamp without time zone NULL,	-- Date and time this file was last updated.
	"Recordowner" varchar(50) NULL,	-- The organisation responsible for the metadata.
	"Version" integer NULL,
	"HeaderID" integer NOT NULL
)
;

CREATE TABLE "Instrumentcontrolresulttype"
(
	"InstrumentcontrolresulttypeID" integer NOT NULL
)
;

CREATE TABLE "Instrumentcontrolscheduletype"
(
	"InstrumentcontrolscheduletypeID" integer NOT NULL
)
;

CREATE TABLE "Instrumentoperatingstatus"
(
	"Instrumentoperatingstatus" varchar(50) NULL,
	"Validperiod" varchar(50) NULL,	-- The time period for which the specified instrumentOperatingStatus is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next instrumentOperatingStatus on record. If only one instrumentOperatingStatus is specified for an equipment, the time stamp is optional.
	"InstrumentoperatingstatusID" integer NOT NULL
)
;

CREATE TABLE "Instrument-operating-status"
(
	"Instrument-operating-statusID" integer NOT NULL
)
;

CREATE TABLE "Instrumentoperatingstatustype"
(
	"InstrumentoperatingstatustypeID" integer NOT NULL
)
;

CREATE TABLE "Level-of-data"
(
	"Level-of-dataID" integer NOT NULL
)
;

CREATE TABLE "Levelofdatatype"
(
	"LevelofdatatypeID" integer NOT NULL
)
;

CREATE TABLE "Localreferencesurfacetype"
(
	"LocalreferencesurfacetypeID" integer NOT NULL
)
;

CREATE TABLE "Local-topography"
(
	"Local-topographyID" integer NOT NULL
)
;

CREATE TABLE "Localtopographytype"
(
	"LocaltopographytypeID" integer NOT NULL
)
;

CREATE TABLE "Log"
(
	"Logentry" varchar(50) NULL,	-- An entry in a Log. 
	"LogID" integer NOT NULL
)
;

CREATE TABLE "Logentry"
(
	"Author" varchar(50) NULL,	-- Author of the log entry.
	"Datetime" timestamp without time zone NULL,	-- Date and time of the event being logged
	"Description" varchar(50) NULL,	-- Description of the log entry
	"Documentationurl" varchar(50) NULL,	-- Link to additional documents, photos etc. about the event being logged.
	"LogentryID" integer NOT NULL
)
;

CREATE TABLE "Maintenancereport"
(
	"Maintenanceparty" varchar(50) NULL,	-- 5-11 Details of who performed the maintenance (individual or organisation).
	"MaintenancereportID" integer NOT NULL
)
;

CREATE TABLE "Measurementunittype"
(
	"MeasurementunittypeID" integer NOT NULL
)
;

CREATE TABLE "Metadata-record"
(
	"Metadata-record" varchar(50) NULL,
	"Metadata-recordID" integer NOT NULL
)
;

CREATE TABLE "Observation"
(
	"Observation-segment" varchar(50) NULL,
	"ObservationID" integer NOT NULL
)
;

CREATE TABLE "Observation-feature-of-interest"
(
	"Observation-feature-of-interestID" integer NOT NULL
)
;

CREATE TABLE "Observation-observed-property"
(
	"Observation-observed-propertyID" integer NOT NULL
)
;

CREATE TABLE "Observation-process"
(
	"Observation-processID" integer NOT NULL
)
;

CREATE TABLE "Observation-result"
(
	"Observation-resultID" integer NOT NULL
)
;

CREATE TABLE "Observation-valid"
(
	"Observation-validID" integer NOT NULL
)
;

CREATE TABLE "Observedvariabletype"
(
	"ObservedvariabletypeID" integer NOT NULL
)
;

CREATE TABLE "Observingcapability"
(
	"Observation" varchar(50) NULL,
	"Programaffiliation" varchar(50) NULL,
	"ObservingcapabilityID" integer NOT NULL,
	facility integer NULL
)
;

CREATE TABLE "Observingfacility"
(
	"Climatezone" varchar(50) NULL,	-- 4-07 type of climate zone at the facility. From the ClimateZoneType codelist.
	"Dateclosed" date NULL,
	"Dateestablished" date NULL,
	"Facilitytype" varchar(50) NULL,	-- 3-04 The type of the observing facility from the MonitoringFacilityType codelist.
	"Population" varchar(50) NULL,
	"Programaffiliation" varchar(50) NULL,	-- 2-02 The global, regional or national programme(s)/network(s) that the ObservingFacility is associated with. programAffiliation also enables the specification of a program-specific identifier of the ObservingFacility, an alias name,  the validPeriod of the programAffiliation, as well as the reportingStatus of an ObservingFacility under the respective program.
	"Surfacecover" varchar(50) NULL,	-- 4-01 The (bio)physical cover on the earth's surface in the vicinity of the observations from the LandCoverType codelist .  NOTE: Only applies for surface-based (fixed) observing facilities.
	"Surfaceroughness" varchar(50) NULL,	-- 4-06 surface roughness at the facility. From the SurfaceRoughnessType codelist.
	"Territory" varchar(50) NULL,	-- 3-02 The territory the observing facility is located in, from the TerritoryType codelist.
	"Timezone" varchar(50) NULL,	-- Time zone the observing facility is located in, from the timeZoneTypeType codelist.
	"Topographybathymetry" varchar(50) NULL,	-- 4-03 Topography or bathymetry characterizes the shape or configuration of a geographical feature, represented on a map by contour lines. It is implemented as a timestamped composite of four elements.
	"Wmoregion" varchar(50) NULL,	-- 3-01 The WMO region the observing facility is located in, from the WMORegionType codelist.
	"ObservingfacilityID" integer NOT NULL
)
;

CREATE TABLE "Observing-facility"
(
	"Observing-facility" varchar(50) NULL,
	"Observing-facilityID" integer NOT NULL
)
;

CREATE TABLE "Observingfacilitytype"
(
	"ObservingfacilitytypeID" integer NOT NULL
)
;

CREATE TABLE "Observing-method"
(
	"Observing-methodID" integer NOT NULL
)
;

CREATE TABLE "Observingmethodtype"
(
	"ObservingmethodtypeID" integer NOT NULL
)
;

CREATE TABLE "Polarizationtype"
(
	"PolarizationtypeID" integer NOT NULL
)
;

CREATE TABLE "Population"
(
	"Population10km" integer NULL,	-- Population in a 10 km radius around the observing facility, specified in 1000s.
	"Population50km" integer NULL,	-- Population in a 50 km radius around the observing facility, specified in 1000s.
	"Validperiod" varchar(50) NULL,	-- The time period for which the specified climateZone is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next climateZone on record. If only one climateZone is specified for an observing facility, the time stamp is optional.
	"PopulationID" integer NOT NULL
)
;

CREATE TABLE "Process"
(
	"Process" varchar(50) NULL,
	"ProcessID" integer NOT NULL
)
;

CREATE TABLE "Process"
(
	"Extension" varchar(50) NULL,	-- This extension point is to facilitate the encoding of any other information for complimentary or local purposes such as complying with legislative frameworks. However it should not be expected that any extension information will be appropriately processed, stored or made retrievable from any WIGOS systems or services. 
	"ProcessID" integer NOT NULL
)
;

CREATE TABLE "Processing"
(
	"Processing" varchar(50) NULL,
	"ProcessingID" integer NOT NULL
)
;

CREATE TABLE "Processing"
(
	"Aggregationperiod" varchar(50) NULL,	-- 7-09 Time period over which individual samples/observations are aggregated
	"Dataprocessing" varchar(50) NULL,	-- 7-01 A description of the data processing used to generate observations including, if relevant, algorithms used to derive the result.
	"Processingcentre" varchar(50) NULL,	-- 7-02 Center at which the observation is processed. Although this is a free text string, it is expected that in practice this value should be from a controlled list of known centers.
	"Softwaredetails" varchar(50) NULL,	-- 7-05 Name and version of the software or processor used to derive the values
	"Softwareurl" varchar(50) NULL,	-- 7-05 URL for the software or processor used to derive the values
	"ProcessingID" integer NOT NULL,
	"DatagenerationID" integer NULL
)
;

CREATE TABLE "Processing-valid"
(
	"Processing-validID" integer NOT NULL
)
;

CREATE TABLE "Process-valid"
(
	"Process-validID" integer NOT NULL
)
;

CREATE TABLE "Programaffiliation"
(
	"Programaffiliation" varchar(50) NULL,
	"Programspecificfacilityid" varchar(50) NULL,
	"Reportingstatus" varchar(50) NULL,
	"ProgramaffiliationID" integer NOT NULL
)
;

CREATE TABLE "Program-affiliation"
(
	"Program-affiliationID" integer NOT NULL
)
;

CREATE TABLE "Programornetworkaffiliationtype"
(
	"ProgramornetworkaffiliationtypeID" integer NOT NULL
)
;

CREATE TABLE "Purposeoffrequencyusetype"
(
	"PurposeoffrequencyusetypeID" integer NOT NULL
)
;

CREATE TABLE "Qualityflagtype"
(
	"QualityflagtypeID" integer NOT NULL
)
;

CREATE TABLE "Record-valid"
(
	"Record-validID" integer NOT NULL
)
;

CREATE TABLE "Reference-time"
(
	"Reference-timeID" integer NOT NULL
)
;

CREATE TABLE "Referencetimetype"
(
	"ReferencetimetypeID" integer NOT NULL
)
;

CREATE TABLE "Relative-elevation"
(
	"Relative-elevationID" integer NOT NULL
)
;

CREATE TABLE "Relativeelevationtype"
(
	"RelativeelevationtypeID" integer NOT NULL
)
;

CREATE TABLE "Reporting"
(
	"Reporting" varchar(50) NULL,
	"ReportingID" integer NOT NULL
)
;

CREATE TABLE "Reporting"
(
	"Dataformat" varchar(50) NULL,	-- 7-07 Description of the format in which the observed variable is primarily being provided, from the DataFormatType codelist. 
	"Dataformatversion" varchar(50) NULL,	-- 7-08 Version of the data format.
	"Datapolicy" varchar(50) NULL,	-- 9-02 Details relating to the use and limitations surrounding data imposed by the supervising organization.
	"Internationalexchange" boolean NULL,
	"Levelofdata" varchar(50) NULL,	-- 7-06 Level of data processing
	"Numberofobservationsinreportinginterval" integer NULL,	-- Specifies how many aggregated observations are reported on average in each temporal reporting interval. For full temporal coverage, the number of observations reported = temporal reporting interval / aggregation period.
	"Numericalresolution" integer NULL,	-- 7-12 Numerical resolution is a measure of the detail to which a numerical quantity is expressed. This is synonymous to numerical precision of the reporting, but can be different than the numerical precision of the observed value.
	"Officialstatus" boolean NULL,	-- 5-14 Official status of observation.
	"Referencedatum" varchar(50) NULL,	-- 7-11 Reference datum used to convert observed quantity to reported quantity
	"Referencetimesource" varchar(50) NULL,	-- 7-10 Time reference used for observations.
	"Spatialreportinginterval" varchar(50) NULL,	-- 7-03 Spatial interval over which the observed variable is reported. Note that this is expressed as length, without geo-referencing. 
	"Temporalreportinginterval" varchar(50) NULL,	-- 7-03 Time interval over which the observed variable is reported. Note that this is a temporal distance, e.g., (every) 1 hour. 
	"Timeliness" varchar(50) NULL,	-- 7-13 Timeliness of reporting is the typical time taken between completion of the observation and when it becomes available to users.
	"Timestampmeaning" varchar(50) NULL,	-- 7-03 Meaning of the time stamp in the temporalReportingInterval taken from the TimeStampMeaning codelist.
	"Uom" varchar(50) NULL,	-- 1-02 Measurement Unit (unit of measure)
	"ReportingID" integer NOT NULL,
	"DatagenerationID" integer NULL
)
;

CREATE TABLE "Reportingstatus"
(
	"Reportingstatus" varchar(50) NULL,	-- 3-09 Declared reporting status of an observing facility [under a certain network/program affiliation]. 
	"Validperiod" varchar(50) NULL,	-- The time period for which the specified reporting status is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next territory on record. If only one reporting status is specified for an observing facility, the time stamp is optional.
	"ReportingstatusID" integer NOT NULL
)
;

CREATE TABLE "Reporting-status"
(
	"Reporting-statusID" integer NOT NULL
)
;

CREATE TABLE "Reportingstatustype"
(
	"ReportingstatustypeID" integer NOT NULL
)
;

CREATE TABLE "Reporting-valid"
(
	"Reporting-validID" integer NOT NULL
)
;

CREATE TABLE "Representativeness"
(
	"RepresentativenessID" integer NOT NULL
)
;

CREATE TABLE "Representativenesstype"
(
	"RepresentativenesstypeID" integer NOT NULL
)
;

CREATE TABLE "Responsibleparty"
(
	"Responsibleparty" varchar(50) NULL,	-- 10-01 Party (organization or individual) responsible for the observing facility or equipment.
	"Validperiod" varchar(50) NULL,	-- The time period for which this responsibleParty is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next responsibleParty on record.
	"ResponsiblepartyID" integer NOT NULL
)
;

CREATE TABLE "Resultset"
(
	"Distributioninfo" varchar(50) NULL,	-- The distributionInfo provides information about how to source the data, described using MD_Distribution from ISO 19115.
	"ResultsetID" integer NOT NULL
)
;

CREATE TABLE "Sampletreatmenttype"
(
	"SampletreatmenttypeID" integer NOT NULL
)
;

CREATE TABLE "Sampling"
(
	"Samplespertimeperiod" integer NULL,
	"Sampletreatment" varchar(50) NULL,	-- 6-02 Description of chemical or physical treatment of the sample prior to analysis from the SampleTreatmentType codelist.
	"Samplingprocedure" varchar(50) NULL,	-- 6-01 The procedure(s) involved in obtaining a sample/making an observation. Taken from the SamplingProcedureType codelist
	"Samplingproceduredescription" varchar(50) NULL,	-- 6-01 Description of the procedure(s) involved in obtaining a sample/making an observation.
	"Samplingstrategy" varchar(50) NULL,	-- 6-03 The strategy used to generate the observed variable.
	"Samplingtimeperiod" varchar(50) NULL,	-- 6-04 The period of time over which a measurement is taken. This value is a duration, e.g. 1 hour, not specific times and dates. 
	"Spatialsamplingresolution" varchar(50) NULL,	-- 6-05 The spatial sampling resolution is the size of the smallest observable object. The value of this property may be supported by explanatory information in spatialSamplingResolutionDescription.
	"Spatialsamplingresolutiondetails" varchar(50) NULL,	-- 6-05 Explanatory information about the exact meaning of the value of samplingResolution. Note: not currently supported.
	"Temporalsamplinginterval" varchar(50) NULL,	-- 6-06 Time period (as a duration) between the beginning of consecutive sampling periods.
	"SamplingID" integer NOT NULL,
	"DatagenerationID" integer NULL
)
;

CREATE TABLE "Sampling"
(
	"Sampling" varchar(50) NULL,
	"SamplingID" integer NOT NULL
)
;

CREATE TABLE "Samplingproceduretype"
(
	"SamplingproceduretypeID" integer NOT NULL
)
;

CREATE TABLE "Sampling-strategy"
(
	"Sampling-strategyID" integer NOT NULL
)
;

CREATE TABLE "Samplingstrategytype"
(
	"SamplingstrategytypeID" integer NOT NULL
)
;

CREATE TABLE "Sampling-valid"
(
	"Sampling-validID" integer NOT NULL
)
;

CREATE TABLE "Schedule"
(
	"Diurnalbasetime" time without time zone NULL,
	"Endhour" integer NULL,	-- End hour of schedule (0 to 23)
	"Endminute" integer NULL,	-- End minute of schedule (0 to 59)
	"Endmonth" integer NULL,	-- End month of schedule (January = 1, December = 12)
	"Endweekday" integer NULL,	-- End day of schedule (Monday = 1, Sunday = 7)
	"Starthour" integer NULL,	-- Start hour of schedule (0 to 23)
	"Startminute" integer NULL,	-- Start minute of schedule (0 to 59)
	"Startmonth" integer NULL,	-- Start month of schedule (January = 1, December = 12)
	"Startweekday" integer NULL,	-- Start day of schedule (Monday = 1, Sunday = 7)
	"ScheduleID" integer NOT NULL,
	"DatagenerationID" integer NULL
)
;

CREATE TABLE "Source-of-observation"
(
	"Source-of-observationID" integer NOT NULL
)
;

CREATE TABLE "Sourceofobservationtype"
(
	"SourceofobservationtypeID" integer NOT NULL
)
;

CREATE TABLE "Surfacecover"
(
	"Surfacecover" varchar(50) NULL,	-- 4-01 The (bio)physical cover on the earth's surface in the vicinity of the observations from the LandCoverType codelist .  NOTE: Only applies for surface-based (fixed) observing facilities.
	"Surfacecoverclassification" varchar(50) NULL,	-- 4-02 Reference to a surface cover classification type from the SurfaceCoverClassificationType codelist. NOTE: only if 4-01 is specified
	"Validperiod" varchar(50) NULL,	-- The time period for which the specified surfaceCover is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next surfaceCover on record. If only one surfaceCover is specified for an observing facility, the time stamp is optional.
	"SurfacecoverID" integer NOT NULL
)
;

CREATE TABLE "Surface-cover"
(
	"Surface-coverID" integer NOT NULL
)
;

CREATE TABLE "Surface-cover-classification"
(
	"Surface-cover-classificationID" integer NOT NULL
)
;

CREATE TABLE "Surfacecoverclassificationtype"
(
	"SurfacecoverclassificationtypeID" integer NOT NULL
)
;

CREATE TABLE "Surfacecovertype"
(
	"SurfacecovertypeID" integer NOT NULL
)
;

CREATE TABLE "Surfaceroughness"
(
	"Surfaceroughness" varchar(50) NULL,	-- 4-06 surface roughness at the facility. From the SurfaceRoughnessType codelist.
	"Validperiod" varchar(50) NULL,	-- The time period for which the specified surfaceRoughness is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next surfaceRoughness on record. If only one surfaceRoughness is specified for an observing facility, the time stamp is optional.
	"SurfaceroughnessID" integer NOT NULL
)
;

CREATE TABLE "Surface-roughness"
(
	"Surface-roughnessID" integer NOT NULL
)
;

CREATE TABLE "Surfaceroughnesstype"
(
	"SurfaceroughnesstypeID" integer NOT NULL
)
;

CREATE TABLE "Territory"
(
	"Territoryname" varchar(50) NULL,	-- 3-02 The territory the observing facility is located in, from the TerritoryType codelist.
	"Validperiod" varchar(50) NULL,	-- The time period for which the specified territory is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next territory on record. If only one territory is specified for an observing facility, the time stamp is optional.
	"TerritoryID" integer NOT NULL
)
;

CREATE TABLE "Territory-name"
(
	"Territory-nameID" integer NOT NULL
)
;

CREATE TABLE "Territorytype"
(
	"TerritorytypeID" integer NOT NULL
)
;

CREATE TABLE "Time-encoding"
(
	"Time-encoding" varchar(50) NULL,
	"Time-encodingID" integer NOT NULL
)
;

CREATE TABLE "Time-stamp-meaning"
(
	"Time-stamp-meaningID" integer NOT NULL
)
;

CREATE TABLE "Timestampmeaningtype"
(
	"TimestampmeaningtypeID" integer NOT NULL
)
;

CREATE TABLE "Timezone"
(
	"Timezone" varchar(50) NULL,	-- Time zone of the observing facility
	"Validperiod" varchar(50) NULL,	-- The time period for which the specified climateZone is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next climateZone on record. If only one climateZone is specified for an observing facility, the time stamp is optional.
	"TimezoneID" integer NOT NULL
)
;

CREATE TABLE "Time-zone-explicit"
(
	"Time-zone-explicitID" integer NOT NULL
)
;

CREATE TABLE "Timezonetype"
(
	"TimezonetypeID" integer NOT NULL
)
;

CREATE TABLE "Topographic-context"
(
	"Topographic-contextID" integer NOT NULL
)
;

CREATE TABLE "Topographiccontexttype"
(
	"TopographiccontexttypeID" integer NOT NULL
)
;

CREATE TABLE "Topographybathymetry"
(
	"Altitudeordepth" varchar(50) NULL,	-- 4-03 The altitude/depth with respect to mean sea level from the AltitudeOrDepthTypeCodelist
	"Localtopography" varchar(50) NULL,	-- 4-03 The local topography from the LocalTopographyType codelist
	"Relativeelevation" varchar(50) NULL,	-- 4-03 The relative elevation from the RelativeElevationType codelist
	"Topographiccontext" varchar(50) NULL,	-- 4-03 The topographic context from the TopographicContextType codelist
	"Validperiod" varchar(50) NULL,	-- The time period for which the specified topographyBathymetry is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next topographyBathymetry on record. If only one topographyBathymetry is specified for an observing facility, the time stamp is optional.
	"TopographybathymetryID" integer NOT NULL
)
;

CREATE TABLE "Traceabilitytype"
(
	"TraceabilitytypeID" integer NOT NULL
)
;

CREATE TABLE "Transmissionmodetype"
(
	"TransmissionmodetypeID" integer NOT NULL
)
;

CREATE TABLE "Uncertaintyevalproctype"
(
	"UncertaintyevalproctypeID" integer NOT NULL
)
;

CREATE TABLE "Unique-observed-variable"
(
	"Unique-observed-variableID" integer NOT NULL
)
;

CREATE TABLE "Unit-of-measure"
(
	"Unit-of-measureID" integer NOT NULL
)
;

CREATE TABLE "Valid-local-references"
(
	"Valid-local-referencesID" integer NOT NULL
)
;

CREATE TABLE "Well-formed"
(
	"Well-formedID" integer NOT NULL
)
;

CREATE TABLE "Wigosmetadatarecord"
(
	"Deployment" varchar(50) NULL,	-- A Deployment instance in this record. Note that Deployments may also be encoded inline with the OM_Observation (as part of the Process).
	"Equipment" varchar(50) NULL,	-- An Equipment instance in this metadata record.
	"Equipmentlog" varchar(50) NULL,	-- An EquipmentLog instance in this metadata record. Note that an EquipmentLog may also be encoded inline with the Equipment instance.
	"Extension" varchar(50) NULL,	-- This extension point is to facilitate the encoding of any other information for complimentary or local purposes such as complying with legislative frameworks. However it should not be expected that any extension information will be appropriately processed, stored or made retrievable from any WIGOS systems or services. 
	"Facility" varchar(50) NULL,	-- An ObservingFacility instance in this metadata record.
	"Facilitylog" varchar(50) NULL,	-- A FacilityLog instance in this metadata record. Note that an FacilityLog may also be encoded inline with the ObservingFacility instance.
	"Facilityset" varchar(50) NULL,	-- A FacilitySet instance in this metadata record. The FacilitySet will simply consist of links to ObservingFacilities belonging to the set.
	"Headerinformation" varchar(50) NULL,	-- A header section must be included with every WIGOS MetadataRecord.
	"Observation" varchar(50) NULL,
	"WigosmetadatarecordID" integer NOT NULL
)
;

CREATE TABLE "Wmo-region"
(
	"Wmo-regionID" integer NOT NULL
)
;

CREATE TABLE "Wmoregiontype"
(
	"WmoregiontypeID" integer NOT NULL
)
;

CREATE TABLE "Xml-rules"
(
	"Xml-rules" varchar(50) NULL,
	"Xml-rulesID" integer NOT NULL
)
;

CREATE TABLE "Xsd-valid"
(
	"Xsd-validID" integer NOT NULL
)
;

/* Create Primary Keys, Indexes, Uniques, Checks */

ALTER TABLE "Abstractenvironmentalmonitoringfacility" ADD CONSTRAINT "PK_Abstractenvironmentalmonitoringfacility"
	PRIMARY KEY ("AbstractenvironmentalmonitoringfacilityID")
;

ALTER TABLE "Altitude-or-depth" ADD CONSTRAINT "PK_Altitude-or-depth"
	PRIMARY KEY ("Altitude-or-depthID")
;

ALTER TABLE "Altitudeordepthtype" ADD CONSTRAINT "PK_Altitudeordepthtype"
	PRIMARY KEY ("AltitudeordepthtypeID")
;

ALTER TABLE "Application-area" ADD CONSTRAINT "PK_Application-area"
	PRIMARY KEY ("Application-areaID")
;

ALTER TABLE "Applicationareatype" ADD CONSTRAINT "PK_Applicationareatype"
	PRIMARY KEY ("ApplicationareatypeID")
;

ALTER TABLE "Attribution" ADD CONSTRAINT "PK_Attribution"
	PRIMARY KEY ("AttributionID")
;

ALTER TABLE "Climatezone" ADD CONSTRAINT "PK_Climatezone"
	PRIMARY KEY ("ClimatezoneID")
;

ALTER TABLE "Climate-zone" ADD CONSTRAINT "PK_Climate-zone"
	PRIMARY KEY ("Climate-zoneID")
;

ALTER TABLE "Climatezonetype" ADD CONSTRAINT "PK_Climatezonetype"
	PRIMARY KEY ("ClimatezonetypeID")
;

ALTER TABLE "Communication-method" ADD CONSTRAINT "PK_Communication-method"
	PRIMARY KEY ("Communication-methodID")
;

ALTER TABLE "Controlchecklocationtype" ADD CONSTRAINT "PK_Controlchecklocationtype"
	PRIMARY KEY ("ControlchecklocationtypeID")
;

ALTER TABLE "Controlcheckreport" ADD CONSTRAINT "PK_Controlcheckreport"
	PRIMARY KEY ("ControlcheckreportID")
;

ALTER TABLE "Controlstandardtype" ADD CONSTRAINT "PK_Controlstandardtype"
	PRIMARY KEY ("ControlstandardtypeID")
;

ALTER TABLE "Coordinatereferencesystemtype" ADD CONSTRAINT "PK_Coordinatereferencesystemtype"
	PRIMARY KEY ("CoordinatereferencesystemtypeID")
;

ALTER TABLE "Coordinatesreferencesystemtype" ADD CONSTRAINT "PK_Coordinatesreferencesystemtype"
	PRIMARY KEY ("CoordinatesreferencesystemtypeID")
;

ALTER TABLE "Datacommunicationmethodtype" ADD CONSTRAINT "PK_Datacommunicationmethodtype"
	PRIMARY KEY ("DatacommunicationmethodtypeID")
;

ALTER TABLE "Data-format" ADD CONSTRAINT "PK_Data-format"
	PRIMARY KEY ("Data-formatID")
;

ALTER TABLE "Dataformattype" ADD CONSTRAINT "PK_Dataformattype"
	PRIMARY KEY ("DataformattypeID")
;

ALTER TABLE "Datageneration" ADD CONSTRAINT "PK_Datageneration"
	PRIMARY KEY ("DatagenerationID")
;

ALTER TABLE "Datapolicy" ADD CONSTRAINT "PK_Datapolicy"
	PRIMARY KEY ("DatapolicyID")
;

ALTER TABLE "Datapolicytype" ADD CONSTRAINT "PK_Datapolicytype"
	PRIMARY KEY ("DatapolicytypeID")
;

ALTER TABLE "Data-use-constraints" ADD CONSTRAINT "PK_Data-use-constraints"
	PRIMARY KEY ("Data-use-constraintsID")
;

ALTER TABLE "Deployment" ADD CONSTRAINT "PK_Deployment"
	PRIMARY KEY ("DeploymentID")
;

ALTER TABLE "Deployment" ADD CONSTRAINT "PK_Deployment"
	PRIMARY KEY ("DeploymentID")
;

ALTER TABLE "Deployment-valid" ADD CONSTRAINT "PK_Deployment-valid"
	PRIMARY KEY ("Deployment-validID")
;

ALTER TABLE "Description" ADD CONSTRAINT "PK_Description"
	PRIMARY KEY ("DescriptionID")
;

ALTER TABLE "Equipment" ADD CONSTRAINT "PK_Equipment"
	PRIMARY KEY ("EquipmentID")
;

ALTER TABLE "Equipment" ADD CONSTRAINT "PK_Equipment"
	PRIMARY KEY ("EquipmentID")
;

ALTER TABLE "Equipmentlog" ADD CONSTRAINT "PK_Equipmentlog"
	PRIMARY KEY ("EquipmentlogID")
;

ALTER TABLE "Equipment-log" ADD CONSTRAINT "PK_Equipment-log"
	PRIMARY KEY ("Equipment-logID")
;

ALTER TABLE "Equipment-log-entries" ADD CONSTRAINT "PK_Equipment-log-entries"
	PRIMARY KEY ("Equipment-log-entriesID")
;

ALTER TABLE "Equipment-log-entries-control-location" ADD CONSTRAINT "PK_Equipment-log-entries-control-location"
	PRIMARY KEY ("Equipment-log-entries-control-locationID")
;

ALTER TABLE "Equipment-log-entries-control-result" ADD CONSTRAINT "PK_Equipment-log-entries-control-result"
	PRIMARY KEY ("Equipment-log-entries-control-resultID")
;

ALTER TABLE "Equipment-log-entries-control-standard" ADD CONSTRAINT "PK_Equipment-log-entries-control-standard"
	PRIMARY KEY ("Equipment-log-entries-control-standardID")
;

ALTER TABLE "Equipment-log-valid" ADD CONSTRAINT "PK_Equipment-log-valid"
	PRIMARY KEY ("Equipment-log-validID")
;

ALTER TABLE "Equipment-valid" ADD CONSTRAINT "PK_Equipment-valid"
	PRIMARY KEY ("Equipment-validID")
;

ALTER TABLE "Eventreport" ADD CONSTRAINT "PK_Eventreport"
	PRIMARY KEY ("EventreportID")
;

ALTER TABLE "Eventtype" ADD CONSTRAINT "PK_Eventtype"
	PRIMARY KEY ("EventtypeID")
;

ALTER TABLE "Exposure" ADD CONSTRAINT "PK_Exposure"
	PRIMARY KEY ("ExposureID")
;

ALTER TABLE "Exposuretype" ADD CONSTRAINT "PK_Exposuretype"
	PRIMARY KEY ("ExposuretypeID")
;

ALTER TABLE "Facilitylog" ADD CONSTRAINT "PK_Facilitylog"
	PRIMARY KEY ("FacilitylogID")
;

ALTER TABLE "Facility-log" ADD CONSTRAINT "PK_Facility-log"
	PRIMARY KEY ("Facility-logID")
;

ALTER TABLE "Facility-log-entries" ADD CONSTRAINT "PK_Facility-log-entries"
	PRIMARY KEY ("Facility-log-entriesID")
;

ALTER TABLE "Facility-log-entries-event-type" ADD CONSTRAINT "PK_Facility-log-entries-event-type"
	PRIMARY KEY ("Facility-log-entries-event-typeID")
;

ALTER TABLE "Facility-log-valid" ADD CONSTRAINT "PK_Facility-log-valid"
	PRIMARY KEY ("Facility-log-validID")
;

ALTER TABLE "Facilityset" ADD CONSTRAINT "PK_Facilityset"
	PRIMARY KEY ("FacilitysetID")
;

ALTER TABLE "Facility-type" ADD CONSTRAINT "PK_Facility-type"
	PRIMARY KEY ("Facility-typeID")
;

ALTER TABLE "Facility-valid" ADD CONSTRAINT "PK_Facility-valid"
	PRIMARY KEY ("Facility-validID")
;

ALTER TABLE "Frequencies" ADD CONSTRAINT "PK_Frequencies"
	PRIMARY KEY ("FrequenciesID")
;

ALTER TABLE "Frequencyusetype" ADD CONSTRAINT "PK_Frequencyusetype"
	PRIMARY KEY ("FrequencyusetypeID")
;

ALTER TABLE "Geopositioning-method" ADD CONSTRAINT "PK_Geopositioning-method"
	PRIMARY KEY ("Geopositioning-methodID")
;

ALTER TABLE "Geopositioning-method" ADD CONSTRAINT "PK_Geopositioning-method"
	PRIMARY KEY ("Geopositioning-methodID")
;

ALTER TABLE "Geopositioningmethodtype" ADD CONSTRAINT "PK_Geopositioningmethodtype"
	PRIMARY KEY ("GeopositioningmethodtypeID")
;

ALTER TABLE "Geospatiallocation" ADD CONSTRAINT "PK_Geospatiallocation"
	PRIMARY KEY ("GeospatiallocationID")
;

ALTER TABLE "Header" ADD CONSTRAINT "PK_Header"
	PRIMARY KEY ("HeaderID")
;

ALTER TABLE "Instrumentcontrolresulttype" ADD CONSTRAINT "PK_Instrumentcontrolresulttype"
	PRIMARY KEY ("InstrumentcontrolresulttypeID")
;

ALTER TABLE "Instrumentcontrolscheduletype" ADD CONSTRAINT "PK_Instrumentcontrolscheduletype"
	PRIMARY KEY ("InstrumentcontrolscheduletypeID")
;

ALTER TABLE "Instrumentoperatingstatus" ADD CONSTRAINT "PK_Instrumentoperatingstatus"
	PRIMARY KEY ("InstrumentoperatingstatusID")
;

ALTER TABLE "Instrument-operating-status" ADD CONSTRAINT "PK_Instrument-operating-status"
	PRIMARY KEY ("Instrument-operating-statusID")
;

ALTER TABLE "Instrumentoperatingstatustype" ADD CONSTRAINT "PK_Instrumentoperatingstatustype"
	PRIMARY KEY ("InstrumentoperatingstatustypeID")
;

ALTER TABLE "Level-of-data" ADD CONSTRAINT "PK_Level-of-data"
	PRIMARY KEY ("Level-of-dataID")
;

ALTER TABLE "Levelofdatatype" ADD CONSTRAINT "PK_Levelofdatatype"
	PRIMARY KEY ("LevelofdatatypeID")
;

ALTER TABLE "Localreferencesurfacetype" ADD CONSTRAINT "PK_Localreferencesurfacetype"
	PRIMARY KEY ("LocalreferencesurfacetypeID")
;

ALTER TABLE "Local-topography" ADD CONSTRAINT "PK_Local-topography"
	PRIMARY KEY ("Local-topographyID")
;

ALTER TABLE "Localtopographytype" ADD CONSTRAINT "PK_Localtopographytype"
	PRIMARY KEY ("LocaltopographytypeID")
;

ALTER TABLE "Log" ADD CONSTRAINT "PK_Log"
	PRIMARY KEY ("LogID")
;

ALTER TABLE "Logentry" ADD CONSTRAINT "PK_Logentry"
	PRIMARY KEY ("LogentryID")
;

ALTER TABLE "Maintenancereport" ADD CONSTRAINT "PK_Maintenancereport"
	PRIMARY KEY ("MaintenancereportID")
;

ALTER TABLE "Measurementunittype" ADD CONSTRAINT "PK_Measurementunittype"
	PRIMARY KEY ("MeasurementunittypeID")
;

ALTER TABLE "Metadata-record" ADD CONSTRAINT "PK_Metadata-record"
	PRIMARY KEY ("Metadata-recordID")
;

ALTER TABLE "Observation" ADD CONSTRAINT "PK_Observation"
	PRIMARY KEY ("ObservationID")
;

ALTER TABLE "Observation-feature-of-interest" ADD CONSTRAINT "PK_Observation-feature-of-interest"
	PRIMARY KEY ("Observation-feature-of-interestID")
;

ALTER TABLE "Observation-observed-property" ADD CONSTRAINT "PK_Observation-observed-property"
	PRIMARY KEY ("Observation-observed-propertyID")
;

ALTER TABLE "Observation-process" ADD CONSTRAINT "PK_Observation-process"
	PRIMARY KEY ("Observation-processID")
;

ALTER TABLE "Observation-result" ADD CONSTRAINT "PK_Observation-result"
	PRIMARY KEY ("Observation-resultID")
;

ALTER TABLE "Observation-valid" ADD CONSTRAINT "PK_Observation-valid"
	PRIMARY KEY ("Observation-validID")
;

ALTER TABLE "Observedvariabletype" ADD CONSTRAINT "PK_Observedvariabletype"
	PRIMARY KEY ("ObservedvariabletypeID")
;

ALTER TABLE "Observingcapability" ADD CONSTRAINT "PK_Observingcapability"
	PRIMARY KEY ("ObservingcapabilityID")
;

ALTER TABLE "Observingfacility" ADD CONSTRAINT "PK_Observingfacility"
	PRIMARY KEY ("ObservingfacilityID")
;

ALTER TABLE "Observing-facility" ADD CONSTRAINT "PK_Observing-facility"
	PRIMARY KEY ("Observing-facilityID")
;

ALTER TABLE "Observingfacilitytype" ADD CONSTRAINT "PK_Observingfacilitytype"
	PRIMARY KEY ("ObservingfacilitytypeID")
;

ALTER TABLE "Observing-method" ADD CONSTRAINT "PK_Observing-method"
	PRIMARY KEY ("Observing-methodID")
;

ALTER TABLE "Observingmethodtype" ADD CONSTRAINT "PK_Observingmethodtype"
	PRIMARY KEY ("ObservingmethodtypeID")
;

ALTER TABLE "Polarizationtype" ADD CONSTRAINT "PK_Polarizationtype"
	PRIMARY KEY ("PolarizationtypeID")
;

ALTER TABLE "Population" ADD CONSTRAINT "PK_Population"
	PRIMARY KEY ("PopulationID")
;

ALTER TABLE "Process" ADD CONSTRAINT "PK_Process"
	PRIMARY KEY ("ProcessID")
;

ALTER TABLE "Process" ADD CONSTRAINT "PK_Process"
	PRIMARY KEY ("ProcessID")
;

ALTER TABLE "Processing" ADD CONSTRAINT "PK_Processing"
	PRIMARY KEY ("ProcessingID")
;

ALTER TABLE "Processing" ADD CONSTRAINT "PK_Processing"
	PRIMARY KEY ("ProcessingID")
;

ALTER TABLE "Processing-valid" ADD CONSTRAINT "PK_Processing-valid"
	PRIMARY KEY ("Processing-validID")
;

ALTER TABLE "Process-valid" ADD CONSTRAINT "PK_Process-valid"
	PRIMARY KEY ("Process-validID")
;

ALTER TABLE "Programaffiliation" ADD CONSTRAINT "PK_Programaffiliation"
	PRIMARY KEY ("ProgramaffiliationID")
;

ALTER TABLE "Program-affiliation" ADD CONSTRAINT "PK_Program-affiliation"
	PRIMARY KEY ("Program-affiliationID")
;

ALTER TABLE "Programornetworkaffiliationtype" ADD CONSTRAINT "PK_Programornetworkaffiliationtype"
	PRIMARY KEY ("ProgramornetworkaffiliationtypeID")
;

ALTER TABLE "Purposeoffrequencyusetype" ADD CONSTRAINT "PK_Purposeoffrequencyusetype"
	PRIMARY KEY ("PurposeoffrequencyusetypeID")
;

ALTER TABLE "Qualityflagtype" ADD CONSTRAINT "PK_Qualityflagtype"
	PRIMARY KEY ("QualityflagtypeID")
;

ALTER TABLE "Record-valid" ADD CONSTRAINT "PK_Record-valid"
	PRIMARY KEY ("Record-validID")
;

ALTER TABLE "Reference-time" ADD CONSTRAINT "PK_Reference-time"
	PRIMARY KEY ("Reference-timeID")
;

ALTER TABLE "Referencetimetype" ADD CONSTRAINT "PK_Referencetimetype"
	PRIMARY KEY ("ReferencetimetypeID")
;

ALTER TABLE "Relative-elevation" ADD CONSTRAINT "PK_Relative-elevation"
	PRIMARY KEY ("Relative-elevationID")
;

ALTER TABLE "Relativeelevationtype" ADD CONSTRAINT "PK_Relativeelevationtype"
	PRIMARY KEY ("RelativeelevationtypeID")
;

ALTER TABLE "Reporting" ADD CONSTRAINT "PK_Reporting"
	PRIMARY KEY ("ReportingID")
;

ALTER TABLE "Reporting" ADD CONSTRAINT "PK_Reporting"
	PRIMARY KEY ("ReportingID")
;

ALTER TABLE "Reportingstatus" ADD CONSTRAINT "PK_Reportingstatus"
	PRIMARY KEY ("ReportingstatusID")
;

ALTER TABLE "Reporting-status" ADD CONSTRAINT "PK_Reporting-status"
	PRIMARY KEY ("Reporting-statusID")
;

ALTER TABLE "Reportingstatustype" ADD CONSTRAINT "PK_Reportingstatustype"
	PRIMARY KEY ("ReportingstatustypeID")
;

ALTER TABLE "Reporting-valid" ADD CONSTRAINT "PK_Reporting-valid"
	PRIMARY KEY ("Reporting-validID")
;

ALTER TABLE "Representativeness" ADD CONSTRAINT "PK_Representativeness"
	PRIMARY KEY ("RepresentativenessID")
;

ALTER TABLE "Representativenesstype" ADD CONSTRAINT "PK_Representativenesstype"
	PRIMARY KEY ("RepresentativenesstypeID")
;

ALTER TABLE "Responsibleparty" ADD CONSTRAINT "PK_Responsibleparty"
	PRIMARY KEY ("ResponsiblepartyID")
;

ALTER TABLE "Resultset" ADD CONSTRAINT "PK_Resultset"
	PRIMARY KEY ("ResultsetID")
;

ALTER TABLE "Sampletreatmenttype" ADD CONSTRAINT "PK_Sampletreatmenttype"
	PRIMARY KEY ("SampletreatmenttypeID")
;

ALTER TABLE "Sampling" ADD CONSTRAINT "PK_Sampling"
	PRIMARY KEY ("SamplingID")
;

ALTER TABLE "Sampling" ADD CONSTRAINT "PK_Sampling"
	PRIMARY KEY ("SamplingID")
;

ALTER TABLE "Samplingproceduretype" ADD CONSTRAINT "PK_Samplingproceduretype"
	PRIMARY KEY ("SamplingproceduretypeID")
;

ALTER TABLE "Sampling-strategy" ADD CONSTRAINT "PK_Sampling-strategy"
	PRIMARY KEY ("Sampling-strategyID")
;

ALTER TABLE "Samplingstrategytype" ADD CONSTRAINT "PK_Samplingstrategytype"
	PRIMARY KEY ("SamplingstrategytypeID")
;

ALTER TABLE "Sampling-valid" ADD CONSTRAINT "PK_Sampling-valid"
	PRIMARY KEY ("Sampling-validID")
;

ALTER TABLE "Schedule" ADD CONSTRAINT "PK_Schedule"
	PRIMARY KEY ("ScheduleID")
;

ALTER TABLE "Source-of-observation" ADD CONSTRAINT "PK_Source-of-observation"
	PRIMARY KEY ("Source-of-observationID")
;

ALTER TABLE "Sourceofobservationtype" ADD CONSTRAINT "PK_Sourceofobservationtype"
	PRIMARY KEY ("SourceofobservationtypeID")
;

ALTER TABLE "Surfacecover" ADD CONSTRAINT "PK_Surfacecover"
	PRIMARY KEY ("SurfacecoverID")
;

ALTER TABLE "Surface-cover" ADD CONSTRAINT "PK_Surface-cover"
	PRIMARY KEY ("Surface-coverID")
;

ALTER TABLE "Surface-cover-classification" ADD CONSTRAINT "PK_Surface-cover-classification"
	PRIMARY KEY ("Surface-cover-classificationID")
;

ALTER TABLE "Surfacecoverclassificationtype" ADD CONSTRAINT "PK_Surfacecoverclassificationtype"
	PRIMARY KEY ("SurfacecoverclassificationtypeID")
;

ALTER TABLE "Surfacecovertype" ADD CONSTRAINT "PK_Surfacecovertype"
	PRIMARY KEY ("SurfacecovertypeID")
;

ALTER TABLE "Surfaceroughness" ADD CONSTRAINT "PK_Surfaceroughness"
	PRIMARY KEY ("SurfaceroughnessID")
;

ALTER TABLE "Surface-roughness" ADD CONSTRAINT "PK_Surface-roughness"
	PRIMARY KEY ("Surface-roughnessID")
;

ALTER TABLE "Surfaceroughnesstype" ADD CONSTRAINT "PK_Surfaceroughnesstype"
	PRIMARY KEY ("SurfaceroughnesstypeID")
;

ALTER TABLE "Territory" ADD CONSTRAINT "PK_Territory"
	PRIMARY KEY ("TerritoryID")
;

ALTER TABLE "Territory-name" ADD CONSTRAINT "PK_Territory-name"
	PRIMARY KEY ("Territory-nameID")
;

ALTER TABLE "Territorytype" ADD CONSTRAINT "PK_Territorytype"
	PRIMARY KEY ("TerritorytypeID")
;

ALTER TABLE "Time-encoding" ADD CONSTRAINT "PK_Time-encoding"
	PRIMARY KEY ("Time-encodingID")
;

ALTER TABLE "Time-stamp-meaning" ADD CONSTRAINT "PK_Time-stamp-meaning"
	PRIMARY KEY ("Time-stamp-meaningID")
;

ALTER TABLE "Timestampmeaningtype" ADD CONSTRAINT "PK_Timestampmeaningtype"
	PRIMARY KEY ("TimestampmeaningtypeID")
;

ALTER TABLE "Timezone" ADD CONSTRAINT "PK_Timezone"
	PRIMARY KEY ("TimezoneID")
;

ALTER TABLE "Time-zone-explicit" ADD CONSTRAINT "PK_Time-zone-explicit"
	PRIMARY KEY ("Time-zone-explicitID")
;

ALTER TABLE "Timezonetype" ADD CONSTRAINT "PK_Timezonetype"
	PRIMARY KEY ("TimezonetypeID")
;

ALTER TABLE "Topographic-context" ADD CONSTRAINT "PK_Topographic-context"
	PRIMARY KEY ("Topographic-contextID")
;

ALTER TABLE "Topographiccontexttype" ADD CONSTRAINT "PK_Topographiccontexttype"
	PRIMARY KEY ("TopographiccontexttypeID")
;

ALTER TABLE "Topographybathymetry" ADD CONSTRAINT "PK_Topographybathymetry"
	PRIMARY KEY ("TopographybathymetryID")
;

ALTER TABLE "Traceabilitytype" ADD CONSTRAINT "PK_Traceabilitytype"
	PRIMARY KEY ("TraceabilitytypeID")
;

ALTER TABLE "Transmissionmodetype" ADD CONSTRAINT "PK_Transmissionmodetype"
	PRIMARY KEY ("TransmissionmodetypeID")
;

ALTER TABLE "Uncertaintyevalproctype" ADD CONSTRAINT "PK_Uncertaintyevalproctype"
	PRIMARY KEY ("UncertaintyevalproctypeID")
;

ALTER TABLE "Unique-observed-variable" ADD CONSTRAINT "PK_Unique-observed-variable"
	PRIMARY KEY ("Unique-observed-variableID")
;

ALTER TABLE "Unit-of-measure" ADD CONSTRAINT "PK_Unit-of-measure"
	PRIMARY KEY ("Unit-of-measureID")
;

ALTER TABLE "Valid-local-references" ADD CONSTRAINT "PK_Valid-local-references"
	PRIMARY KEY ("Valid-local-referencesID")
;

ALTER TABLE "Well-formed" ADD CONSTRAINT "PK_Well-formed"
	PRIMARY KEY ("Well-formedID")
;

ALTER TABLE "Wigosmetadatarecord" ADD CONSTRAINT "PK_Wigosmetadatarecord"
	PRIMARY KEY ("WigosmetadatarecordID")
;

ALTER TABLE "Wmo-region" ADD CONSTRAINT "PK_Wmo-region"
	PRIMARY KEY ("Wmo-regionID")
;

ALTER TABLE "Wmoregiontype" ADD CONSTRAINT "PK_Wmoregiontype"
	PRIMARY KEY ("WmoregiontypeID")
;

ALTER TABLE "Xml-rules" ADD CONSTRAINT "PK_Xml-rules"
	PRIMARY KEY ("Xml-rulesID")
;

ALTER TABLE "Xsd-valid" ADD CONSTRAINT "PK_Xsd-valid"
	PRIMARY KEY ("Xsd-validID")
;

/* Create Foreign Key Constraints */

ALTER TABLE "Controlcheckreport" ADD CONSTRAINT "FK_ControlCheckReport_LogEntry"
	FOREIGN KEY ("ControlcheckreportID") REFERENCES "Logentry" ("LogentryID") ON DELETE No Action ON UPDATE No Action
;

ALTER TABLE "Datageneration" ADD CONSTRAINT "FK_DataGeneration_dataGeneration"
	FOREIGN KEY ("DeploymentID") REFERENCES "Deployment" ("DeploymentID") ON DELETE No Action ON UPDATE No Action
;

ALTER TABLE "Deployment" ADD CONSTRAINT "FK_Deployment_deployment"
	FOREIGN KEY ("ProcessID") REFERENCES "Process" ("ProcessID") ON DELETE No Action ON UPDATE No Action
;

ALTER TABLE "Equipment" ADD CONSTRAINT "FK_Equipment_AbstractEnvironmentalMonitoringFacility"
	FOREIGN KEY ("EquipmentID") REFERENCES "Abstractenvironmentalmonitoringfacility" ("AbstractenvironmentalmonitoringfacilityID") ON DELETE No Action ON UPDATE No Action
;

ALTER TABLE "Equipment" ADD CONSTRAINT "FK_Equipment_deployedEquipment"
	FOREIGN KEY ("DeploymentID") REFERENCES "Deployment" ("DeploymentID") ON DELETE No Action ON UPDATE No Action
;

ALTER TABLE "Equipment" ADD CONSTRAINT "FK_Equipment_equipment"
	FOREIGN KEY (facility) REFERENCES "Observingfacility" ("ObservingfacilityID") ON DELETE No Action ON UPDATE No Action
;

ALTER TABLE "EquipmentEquipment" ADD CONSTRAINT "FK_EquipmentEquipment_subEquipment"
	FOREIGN KEY ("subEquipment") REFERENCES "Equipment" ("EquipmentID") ON DELETE No Action ON UPDATE No Action
;

ALTER TABLE "EquipmentEquipment" ADD CONSTRAINT "FK_EquipmentEquipment_Equipment"
	FOREIGN KEY ("EquipmentID") REFERENCES "Equipment" ("EquipmentID") ON DELETE No Action ON UPDATE No Action
;

ALTER TABLE "Equipmentlog" ADD CONSTRAINT "FK_EquipmentLog_equipmentLog"
	FOREIGN KEY (equipment) REFERENCES "Equipment" ("EquipmentID") ON DELETE No Action ON UPDATE No Action
;

ALTER TABLE "Equipmentlog" ADD CONSTRAINT "FK_EquipmentLog_Log"
	FOREIGN KEY ("EquipmentlogID") REFERENCES "Log" ("LogID") ON DELETE No Action ON UPDATE No Action
;

ALTER TABLE "Eventreport" ADD CONSTRAINT "FK_EventReport_LogEntry"
	FOREIGN KEY ("EventreportID") REFERENCES "Logentry" ("LogentryID") ON DELETE No Action ON UPDATE No Action
;

ALTER TABLE "Facilitylog" ADD CONSTRAINT "FK_FacilityLog_Log"
	FOREIGN KEY ("FacilitylogID") REFERENCES "Log" ("LogID") ON DELETE No Action ON UPDATE No Action
;

ALTER TABLE "Facilitylog" ADD CONSTRAINT "FK_FacilityLog_facilityLog"
	FOREIGN KEY (facility) REFERENCES "Observingfacility" ("ObservingfacilityID") ON DELETE No Action ON UPDATE No Action
;

ALTER TABLE "FacilitySetObservingFacility" ADD CONSTRAINT "FK_FacilitySetObservingFacility_facility"
	FOREIGN KEY (facility) REFERENCES "Observingfacility" ("ObservingfacilityID") ON DELETE No Action ON UPDATE No Action
;

ALTER TABLE "FacilitySetObservingFacility" ADD CONSTRAINT "FK_FacilitySetObservingFacility_facilitySet"
	FOREIGN KEY ("facilitySet") REFERENCES "Facilityset" ("FacilitysetID") ON DELETE No Action ON UPDATE No Action
;

ALTER TABLE "Frequencies" ADD CONSTRAINT "FK_Frequencies_Equipment"
	FOREIGN KEY ("EquipmentID") REFERENCES "Equipment" ("EquipmentID") ON DELETE No Action ON UPDATE No Action
;

ALTER TABLE "Maintenancereport" ADD CONSTRAINT "FK_MaintenanceReport_LogEntry"
	FOREIGN KEY ("MaintenancereportID") REFERENCES "Logentry" ("LogentryID") ON DELETE No Action ON UPDATE No Action
;

ALTER TABLE "Observingcapability" ADD CONSTRAINT "FK_ObservingCapability_facility"
	FOREIGN KEY (facility) REFERENCES "Observingfacility" ("ObservingfacilityID") ON DELETE No Action ON UPDATE No Action
;

ALTER TABLE "Observingfacility" ADD CONSTRAINT "FK_ObservingFacility_AbstractEnvironmentalMonitoringFacility"
	FOREIGN KEY ("ObservingfacilityID") REFERENCES "Abstractenvironmentalmonitoringfacility" ("AbstractenvironmentalmonitoringfacilityID") ON DELETE No Action ON UPDATE No Action
;

ALTER TABLE "Processing" ADD CONSTRAINT "FK_Processing_processing"
	FOREIGN KEY ("DatagenerationID") REFERENCES "Datageneration" ("DatagenerationID") ON DELETE No Action ON UPDATE No Action
;

ALTER TABLE "Reporting" ADD CONSTRAINT "FK_Reporting_reporting"
	FOREIGN KEY ("DatagenerationID") REFERENCES "Datageneration" ("DatagenerationID") ON DELETE No Action ON UPDATE No Action
;

ALTER TABLE "Sampling" ADD CONSTRAINT "FK_Sampling_sampling"
	FOREIGN KEY ("DatagenerationID") REFERENCES "Datageneration" ("DatagenerationID") ON DELETE No Action ON UPDATE No Action
;

ALTER TABLE "Schedule" ADD CONSTRAINT "FK_Schedule_schedule"
	FOREIGN KEY ("DatagenerationID") REFERENCES "Datageneration" ("DatagenerationID") ON DELETE No Action ON UPDATE No Action
;

/* Create Table Comments, Sequences for Autonumber Columns */

COMMENT ON TABLE "Abstractenvironmentalmonitoringfacility"
	IS 'An abstract class for environmental monitoring facilities. An environmental monitoring facility may be a station, a platform (moving or stationary), or it may be a sensor or an instrument. WIGOS defines two concrete specialisations: ObservingFacility (to represent stations/platforms) and Equipment (to represent sensors/instruments). NOTE: The WIGOS specialisations of AbstractEnvironmentalMonitoringFacility (ObservingFacility, Equipment) can both be mapped conceptually to the INSPIRE EF EnvironmentalMonitoringFacility.'
;

COMMENT ON COLUMN "Abstractenvironmentalmonitoringfacility"."Description"
	IS '4-05 Non-formalized information about the location and surroundings at which an observation is made and that may influence it. In WIGOS, description is used to describe an observingFacility or Equipment. '
;

COMMENT ON COLUMN "Abstractenvironmentalmonitoringfacility"."Extension"
	IS 'This extension point is to facilitate the encoding of any other information for complimentary or local purposes such as complying with legislative frameworks.
However it should not be expected that any extension information will be appropriately processed, stored or made retrievable from any WIGOS systems or services. '
;

COMMENT ON COLUMN "Abstractenvironmentalmonitoringfacility"."Geospatiallocation"
	IS '3-07 Position in space defining the location of the environmental monitoring station/platform at the time of observation.

5-12 Geospatial location of instrument/sensor'
;

COMMENT ON COLUMN "Abstractenvironmentalmonitoringfacility"."Onlineresource"
	IS 'An online resource containing additional information about the facility or equipment'
;

COMMENT ON COLUMN "Abstractenvironmentalmonitoringfacility"."Responsibleparty"
	IS 'The organisation responsible.'
;

COMMENT ON TABLE "Altitude-or-depth"
	IS 'The value for altitudeOrDepth, if supplied, shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/AltitudeOrDepth.

This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;

COMMENT ON TABLE "Altitudeordepthtype"
	IS 'Codelist for altitude/depth classifications'
;

COMMENT ON TABLE "Application-area"
	IS 'The value(s) for applicationArea shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/ApplicationArea.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;

COMMENT ON TABLE "Applicationareatype"
	IS 'Application Area codelist

note to group:
14 application areas in WMO Core Metadata profile
Also comparable list in WIGOS - to review.'
;

COMMENT ON COLUMN "Attribution"."Originator"
	IS 'Identifies the individual and/or organization at the origin of the resource. This is typically the owner of the ressource, e.g., a data set.'
;

COMMENT ON COLUMN "Attribution"."Title"
	IS 'The title of the attributed work.'
;

COMMENT ON TABLE "Climatezone"
	IS 'A ClimateZone is a climateZone specification accompanied by a timestamp indicating the time from which that climateZone is considered to be valid. If known, an end time may also be provided. In WIGOS, an ObservingFacility may carry multiple climateZone which are valid over different consecutive periods of time. If only a single climateZone is specified, the timestamp is optional.'
;

COMMENT ON COLUMN "Climatezone"."Climatezone"
	IS '4-07 type of climate zone at the facility. From the ClimateZoneType codelist.'
;

COMMENT ON COLUMN "Climatezone"."Validperiod"
	IS 'The time period for which the specified climateZone is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next climateZone on record. If only one climateZone is specified for an observing facility, the time stamp is optional.'
;

COMMENT ON TABLE "Climate-zone"
	IS 'The value for climateZone shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/ClimateZone.'
;

COMMENT ON TABLE "Climatezonetype"
	IS '4-07 Climate Zone '
;

COMMENT ON TABLE "Communication-method"
	IS 'The value for communicationMethod, if supplied, shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/DataCommunicationMethod.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;

COMMENT ON TABLE "Controlchecklocationtype"
	IS '5-08  - Types of location used in control checks'
;

COMMENT ON TABLE "Controlcheckreport"
	IS 'A ControlCheckReport describes a calibration type event. E.g. instrument was re-calibrated.'
;

COMMENT ON COLUMN "Controlcheckreport"."Alternateuri"
	IS '5-08 Alternatively the summary of the control check may be provided via a URI that resolves to a document containing this information.'
;

COMMENT ON COLUMN "Controlcheckreport"."Checklocation"
	IS '5-08 Location of sensor when check was performed (e.g. in-situ, offsite etc.) From codelist ControlCheckLocationType.'
;

COMMENT ON COLUMN "Controlcheckreport"."Controlcheckresult"
	IS '5-08 Result of the control check, from InstrumentControlResultType codelist'
;

COMMENT ON COLUMN "Controlcheckreport"."Periodofvalidity"
	IS '5-08 period of validity of the control check (e.g. 4 years)'
;

COMMENT ON COLUMN "Controlcheckreport"."Standardname"
	IS '5-08 Nameof the Standard used.'
;

COMMENT ON COLUMN "Controlcheckreport"."Standardserialnumber"
	IS '5-08 Serial Number of the standard used.'
;

COMMENT ON COLUMN "Controlcheckreport"."Standardtype"
	IS '5-08 Type of the Standard used. From the StandardType code list.'
;

COMMENT ON COLUMN "Controlcheckreport"."Withinverificationlimit"
	IS '5-08 Was the instrument found to be within verification limits (True if yes, False if no)'
;

COMMENT ON TABLE "Controlstandardtype"
	IS '5-08 Codelist for types of Control Standards'
;

COMMENT ON TABLE "Coordinatesreferencesystemtype"
	IS 'Coordinate reference system codelist'
;

COMMENT ON TABLE "Datacommunicationmethodtype"
	IS 'Data Communication method'
;

COMMENT ON TABLE "Data-format"
	IS 'The value for dataFormat, if supplied, shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/DataFormat.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;

COMMENT ON TABLE "Dataformattype"
	IS 'Data format codelist'
;

COMMENT ON COLUMN "Datageneration"."Validperiod"
	IS 'The period of time for which this processing arrangement was/is in place. (Note: this time period must fall within the time period specified in the Deployment).'
;

COMMENT ON COLUMN "Datapolicy"."Attribution"
	IS 'Describes the attribution details pertinent to dataPolicy'
;

COMMENT ON COLUMN "Datapolicy"."Datapolicy"
	IS '9-02 Details relating to the use and limitations surrounding data imposed by the supervising organization.'
;

COMMENT ON TABLE "Datapolicytype"
	IS 'Data Policy / use constraints codelist'
;

COMMENT ON TABLE "Data-use-constraints"
	IS 'The value for dataUseConstraints, if supplied, shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/DataPolicy.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;

COMMENT ON TABLE "Deployment"
	IS 'The deployment(s) describe which equipment is deployed, during which time period, and in which configuration in the course of generating observations. A Deployment can describe any period of time (equipment could be deployed for less than a day, e.g. a mobile sensor deployed in the field, or it could be deployed for many years.) A defining characteristic of the Deployment is that the configuration described in the Deployment remains, by-and-large, unchanged for the duration of the deployment. If the configuration changes, then a new Deployment must be recorded.'
;

COMMENT ON COLUMN "Deployment"."Applicationarea"
	IS '2-01 The context within, or intended application(s) for which the observation is primarily made or which has/have the most stringent requirements.'
;

COMMENT ON COLUMN "Deployment"."Communicationmethod"
	IS '3-08 The primary data communication method, from the DataCommunicationMethodType codelist.'
;

COMMENT ON COLUMN "Deployment"."Configuration"
	IS '5-06 Description of any shielding or configuration/setup of the instrumentation.'
;

COMMENT ON COLUMN "Deployment"."Controlschedule"
	IS '5-07 Description of schedule for calibrations or verification of instrument.'
;

COMMENT ON COLUMN "Deployment"."Exposure"
	IS '5-15 The degree to which an instrument is affected by external influences according to the CIMO classification. Value from ExposureType codelist.'
;

COMMENT ON COLUMN "Deployment"."Heightabovelocalreferencesurface"
	IS '5-05 Vertical distance of sensor from specified reference surface, in the direction away from the earth''s center. Positive values indicate above reference surface, negative values indicate below references surface (e.g., below ocean surface).'
;

COMMENT ON COLUMN "Deployment"."Instrumentoperatingstatus"
	IS '5-04 The operational status of the instrument when deployed (Operational, testing etc.).'
;

COMMENT ON COLUMN "Deployment"."Localreferencesurface"
	IS '5-05 Description of the specified reference surface taken from the codelist LocalReferenceSurfaceType'
;

COMMENT ON COLUMN "Deployment"."Maintenanceschedule"
	IS '5-10 A description (and schedule) of maintenance that is routinely performed on an instrument'
;

COMMENT ON COLUMN "Deployment"."Representativeness"
	IS '1-05 An assessment of the representativeness of the observations from the RepresentativenessType codelist.'
;

COMMENT ON COLUMN "Deployment"."Sourceofobservation"
	IS '5-01 The source of the observation (manual, automatic, visual etc.) from the SourceOfObservationType codelist.'
;

COMMENT ON COLUMN "Deployment"."Validperiod"
	IS 'The period of time for which this deployment configuration was/is in place. (Note: this time period must fall within the time period specified in the OM_Observation phenomenonTime)'
;

COMMENT ON TABLE "Deployment-valid"
	IS 'XML encodings of Deployment shall conform to the XML form for Deployment specified in the WMDR XML Schema.'
;

COMMENT ON TABLE "Description"
	IS 'A Description is a description accompanied by a timestamp indicating the time from which that description is considered to be valid. If known, an end time may also be provided. In WIGOS, an ObservingFacility or Equipment may carry multiple descriptions which are valid over different periods of time.'
;

COMMENT ON COLUMN "Description"."Description"
	IS '4-05 Non-formalized information about the location and surroundings at which an observation is made and that may influence it. In WIGOS, description is used to describe an observingFacility or Equipment. '
;

COMMENT ON COLUMN "Description"."Validperiod"
	IS 'Specifies at least the begin date of the indicated description. If omitted, the dateEstablished of the facility or deployedEquipment.validPeriod will be assumed.'
;

COMMENT ON TABLE "Equipment"
	IS 'Equipment or instrument used to make observations.'
;

COMMENT ON COLUMN "Equipment"."Driftperunittime"
	IS '5-03 Intrinsic capability of the measurement/observing method - drift per unit time. Typically a percentage per unit time but could be absolute e.g. 1 deg per year.'
;

COMMENT ON COLUMN "Equipment"."Firmwareversion"
	IS '5-09 Firmware version of the equipment'
;

COMMENT ON COLUMN "Equipment"."Manufacturer"
	IS '5-09 Manufacturer of the equipment'
;

COMMENT ON COLUMN "Equipment"."Model"
	IS '5-09 Model number of the equipment'
;

COMMENT ON COLUMN "Equipment"."Observablerange"
	IS '5-03 Intrinsic capability of the measurement/observing method - range'
;

COMMENT ON COLUMN "Equipment"."Observingmethod"
	IS '5-02 The method of measurement/observation used from the ObservingMethodType codelist.'
;

COMMENT ON COLUMN "Equipment"."Observingmethoddetails"
	IS '5-02 A description of the method of measurement/observation used from the ObservingMethodType codelist. '
;

COMMENT ON COLUMN "Equipment"."Serialnumber"
	IS '5-09 Serial number of the equipment '
;

COMMENT ON COLUMN "Equipment"."Specificationlink"
	IS '5-03 Link to manufacturers (or other) specification describing the equipment.'
;

COMMENT ON COLUMN "Equipment"."Specifiedabsoluteuncertainty"
	IS '5-03 Intrinsic capability of the measurement/observing method - specified absolute uncertainty e.g. 0.2 deg C (k=2).'
;

COMMENT ON COLUMN "Equipment"."Specifiedrelativeuncertainty"
	IS '5-03 Intrinsic capability of the measurement/observing method - specified relative uncertainty. Typically a percentage.'
;

COMMENT ON TABLE "Equipmentlog"
	IS '5-13 The EquipmentLog is used to capture notable events and extra information about the equipment used to obtain the observations, such as actual maintenance performed on the instrument.'
;

COMMENT ON TABLE "Equipment-log-entries"
	IS 'Log entries in a EquipmentLog shall describe control checks or maintenance of the Equipment and shall conform to the XML forms for ControlCheckReport or MaintenanceReport in the WMDR XML Schema.'
;

COMMENT ON TABLE "Equipment-log-entries-control-location"
	IS 'Where a log entry is a ControlCheckReport, the value of checkLocation shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/ControlLocation. '
;

COMMENT ON TABLE "Equipment-log-entries-control-result"
	IS 'http://def.wmo.int/wmdr/2017/req/equipment/equipment-log-entries-control-result
Where a log entry is a ControlCheckReport, the value of controlCheckResult shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/ControlResult. '
;

COMMENT ON TABLE "Equipment-log-entries-control-standard"
	IS 'Where a log entry is a ControlCheckReport, the value of standardType shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/ControlStandardType. '
;

COMMENT ON TABLE "Equipment-log-valid"
	IS 'XML encodings of EquipmentLog shall conform to the XML form for EquipmentLog specified in the WMDR XML Schema.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;

COMMENT ON TABLE "Equipment-valid"
	IS 'XML encodings of Equipment shall conform to the XML form for Equipment specified in the WMDR XML Schema.'
;

COMMENT ON COLUMN "Eventreport"."Typeofevent"
	IS 'The type of event, taken from the EventType codelist (e.g. tree removal, storm damage etc).'
;

COMMENT ON TABLE "Eventtype"
	IS 'Codelist for events at station/platform'
;

COMMENT ON TABLE "Exposure"
	IS 'The value for exposure, if supplied, shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/Exposure.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;

COMMENT ON TABLE "Exposuretype"
	IS 'Codelist for exposure of instrument'
;

COMMENT ON TABLE "Facilitylog"
	IS '4-04 The FacilityLog is used to capture notable events and extra information about the observing facility or its surroundings. '
;

COMMENT ON TABLE "Facility-log-entries"
	IS 'Log entries in a FacilityLog shall describe events at the facility and shall conform to the XML form for EventReport in the WMDR XML Schema. '
;

COMMENT ON TABLE "Facility-log-entries-event-type"
	IS 'The value for typeOfEvent in a EventReport shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/EventAtFacility.'
;

COMMENT ON TABLE "Facility-log-valid"
	IS 'XML encodings of FacilityLog shall conform to the XML form for FacilityLog specified in the WMDR XML Schema.'
;

COMMENT ON TABLE "Facilityset"
	IS 'A set of associated ObservingFacilities. Association (grouping) criteria can vary and maybe program/network specific. Examples: In GAW, some Global stations consist of several distinct observing facilities; The NASA A-Train may be considered a FacilitySet comprised of several individual satellites.'
;

COMMENT ON TABLE "Facility-type"
	IS 'The value for facilityType, if supplied, shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/FacilityType.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;

COMMENT ON TABLE "Facility-valid"
	IS 'XML encodings of ObservingFacility shall conform to the XML form for ObservingFacility specified in the WMDR XML Schema.'
;

COMMENT ON COLUMN "Frequencies"."Bandwidth"
	IS 'The difference of the highest and the lowest frequency, expressed as a number with a unit of measure (uom). Expected values for gml attribute uom are: Hz, kHz, MHz, GHz, THz'
;

COMMENT ON COLUMN "Frequencies"."Channel"
	IS 'A name describing the frequency used'
;

COMMENT ON COLUMN "Frequencies"."Frequency"
	IS 'The nominal frequency used, expressed as a number with a unit of measure (uom). Expected values for gml attribute uom are: Hz, kHz, MHz, GHz, THz'
;

COMMENT ON COLUMN "Frequencies"."Frequencyuse"
	IS 'expected values are: Transmit, Receive, TransmitReceive'
;

COMMENT ON COLUMN "Frequencies"."Purposeoffrequencyuse"
	IS 'expected values are: observation, telecomms'
;

COMMENT ON COLUMN "Frequencies"."Transmissionmode"
	IS 'expected values are: pulsed, continuous
use conditional on frequencyUse = Transmit'
;

COMMENT ON TABLE "Frequencyusetype"
	IS '5-03 Instrument specifications. This is a proxy for several more specific elements, her used for FeatureType "Frequencies". Frequency use type (transmit, receive, telecoms)'
;

COMMENT ON TABLE "Geopositioning-method"
	IS 'The value for geopositioningMethod, if supplied, shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/GeopositioningMethod.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;

COMMENT ON TABLE "Geopositioning-method"
	IS 'The value for geopositioningMethod, if supplied, shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/GeopoistioningMethod.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;

COMMENT ON TABLE "Geopositioningmethodtype"
	IS 'Geopositiong Method / Coordinate Source codelist'
;

COMMENT ON TABLE "Geospatiallocation"
	IS 'A GeospatialLocation is a geospatial location accompanied by a timestamp indicating the time from which that location is considered to be valid. If known, an end time may also be provided. In WIGOS, an ObservingFacility or Equipment may carry multiple locations which are valid over different periods of time.'
;

COMMENT ON COLUMN "Geospatiallocation"."Geolocation"
	IS '3-07 Representative or conventional geospatial location of observing facility, the reference location. This will always be a point location, but this location can change with time.

5-12 Geospatial location of instrument or observing equipment, typically the location of the sensing element or sample inlet. This will always be a point location, but this location can change with time. '
;

COMMENT ON COLUMN "Geospatiallocation"."Geopositioningmethod"
	IS 'Element describes the method used to establish the specified geoLocation. [Codelist 11-01]'
;

COMMENT ON COLUMN "Geospatiallocation"."Validperiod"
	IS 'The time period for which this geoLocation is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next geoLocation on record.'
;

COMMENT ON TABLE "Header"
	IS 'Header contains header information about a WIGOSMetadataRecord. This is metadata about the record used to facilitate transport or ingestion into a system such as OSCAR.'
;

COMMENT ON COLUMN "Header"."Filedatetime"
	IS 'Date and time this file was last updated.'
;

COMMENT ON COLUMN "Header"."Recordowner"
	IS 'The organisation responsible for the metadata.'
;

COMMENT ON TABLE "Instrumentcontrolresulttype"
	IS 'Result of an instrument control check'
;

COMMENT ON TABLE "Instrumentcontrolscheduletype"
	IS '5-07 Instrument control schedule'
;

COMMENT ON COLUMN "Instrumentoperatingstatus"."Validperiod"
	IS 'The time period for which the specified instrumentOperatingStatus is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next instrumentOperatingStatus on record. If only one instrumentOperatingStatus is specified for an equipment, the time stamp is optional.'
;

COMMENT ON TABLE "Instrument-operating-status"
	IS 'The value for instrumentOperatingStatus shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/InstrumentOperatingStatus.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;

COMMENT ON TABLE "Instrumentoperatingstatustype"
	IS '5-04 Instrument operating status'
;

COMMENT ON TABLE "Level-of-data"
	IS 'The value for levelOfData, if supplied, shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/LevelOfData.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;

COMMENT ON TABLE "Levelofdatatype"
	IS 'Level of data codelist'
;

COMMENT ON TABLE "Localreferencesurfacetype"
	IS '5-05 Local Reference Surface type.'
;

COMMENT ON TABLE "Local-topography"
	IS 'The value for localTopography, if supplied, shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/LocalTopography.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;

COMMENT ON TABLE "Localtopographytype"
	IS 'Local topography codelist (based on Speight 2009)'
;

COMMENT ON TABLE "Log"
	IS 'At the abstract level a log is simply a record of log entries. The requirements for a log may depend on the type of log it is therefore specialized logs exist for specific types of log (such as ControlCheckReports, MaintenanceReports and EventReports).'
;

COMMENT ON COLUMN "Log"."Logentry"
	IS 'An entry in a Log. '
;

COMMENT ON TABLE "Logentry"
	IS 'At the abstract level a log entry contains the time, author and descriptions of the activity or event being logged. This class is specialized further to provide more specific log entry types where needed. '
;

COMMENT ON COLUMN "Logentry"."Author"
	IS 'Author of the log entry.'
;

COMMENT ON COLUMN "Logentry"."Datetime"
	IS 'Date and time of the event being logged'
;

COMMENT ON COLUMN "Logentry"."Description"
	IS 'Description of the log entry'
;

COMMENT ON COLUMN "Logentry"."Documentationurl"
	IS 'Link to additional documents, photos etc. about the event being logged.'
;

COMMENT ON TABLE "Maintenancereport"
	IS '5-13 Description of maintenance (actual) performed on instrument.'
;

COMMENT ON COLUMN "Maintenancereport"."Maintenanceparty"
	IS '5-11 Details of who performed the maintenance (individual or organisation).'
;

COMMENT ON TABLE "Measurementunittype"
	IS 'Codelist for Measurement Unit [according to common code table C-6 (WMO, 2013)]'
;

COMMENT ON TABLE "Observation-feature-of-interest"
	IS 'XML encodings of OM_Observation in WIGOS shall use O&M Spatial Sampling Features to describe the om:featureOfInterest as a feature with geometry describing the geometric location or range of the observations.'
;

COMMENT ON TABLE "Observation-observed-property"
	IS 'The value for om:observedProperty (observed variable) shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/ObservedVariable'
;

COMMENT ON TABLE "Observation-process"
	IS 'XML encodings of OM_Observation in WIGOS shall use the WIGOS Process type to describe the om:procedure.'
;

COMMENT ON TABLE "Observation-result"
	IS 'XML encodings of OM_Observation in WIGOS shall use the WIGOS ResultSet type to describe the om:result.'
;

COMMENT ON TABLE "Observation-valid"
	IS 'XML encodings of OM_Observation shall conform to the XML form for OM_Observation specified in ISO 19156 O&M XML schema. '
;

COMMENT ON TABLE "Observedvariabletype"
	IS 'Observed variable - measurand'
;

COMMENT ON TABLE "Observingfacility"
	IS '[WMDS Category 3] An observing facility (station/platform) can be anything that supports making observations, e.g., a fixed station, moving equipment or a remote sensing platform. In abstract terms, an observing facility groups a near colocation of observing equipment managed by a single entity or several entities.'
;

COMMENT ON COLUMN "Observingfacility"."Climatezone"
	IS '4-07 type of climate zone at the facility. From the ClimateZoneType codelist.'
;

COMMENT ON COLUMN "Observingfacility"."Facilitytype"
	IS '3-04 The type of the observing facility from the MonitoringFacilityType codelist.'
;

COMMENT ON COLUMN "Observingfacility"."Programaffiliation"
	IS '2-02 The global, regional or national programme(s)/network(s) that the ObservingFacility is associated with. programAffiliation also enables the specification of a program-specific identifier of the ObservingFacility, an alias name,  the validPeriod of the programAffiliation, as well as the reportingStatus of an ObservingFacility under the respective program.'
;

COMMENT ON COLUMN "Observingfacility"."Surfacecover"
	IS '4-01 The (bio)physical cover on the earth''s surface in the vicinity of the observations from the LandCoverType codelist . 
NOTE: Only applies for surface-based (fixed) observing facilities.'
;

COMMENT ON COLUMN "Observingfacility"."Surfaceroughness"
	IS '4-06 surface roughness at the facility. From the SurfaceRoughnessType codelist.'
;

COMMENT ON COLUMN "Observingfacility"."Territory"
	IS '3-02 The territory the observing facility is located in, from the TerritoryType codelist.'
;

COMMENT ON COLUMN "Observingfacility"."Timezone"
	IS 'Time zone the observing facility is located in, from the timeZoneTypeType codelist.'
;

COMMENT ON COLUMN "Observingfacility"."Topographybathymetry"
	IS '4-03 Topography or bathymetry characterizes the shape or configuration of a geographical feature, represented on a map by contour lines. It is implemented as a timestamped composite of four elements.'
;

COMMENT ON COLUMN "Observingfacility"."Wmoregion"
	IS '3-01 The WMO region the observing facility is located in, from the WMORegionType codelist.'
;

COMMENT ON TABLE "Observingfacilitytype"
	IS 'Codelist for classifications of Observing Facilities (Stations, Platforms)'
;

COMMENT ON TABLE "Observing-method"
	IS 'The value(s) for observingMethod shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/ObservingMethod.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;

COMMENT ON TABLE "Observingmethodtype"
	IS '5-02 Measurement/observing method type'
;

COMMENT ON TABLE "Polarizationtype"
	IS '5-03 Instrument specifications. This is a proxy for several more specific elements, her used for FeatureType "Frequencies". Polarization type (LHCP, RHCP, linear, LHCD&RHCP, single, dual)'
;

COMMENT ON TABLE "Population"
	IS 'A Population is a population specification accompanied by a timestamp indicating the time from which that population is considered to be valid. If known, an end time may also be provided. In WIGOS, an ObservingFacility may carry multiple population specifications which are valid over different consecutive periods of time. If only a single population is specified, the timestamp is optional.'
;

COMMENT ON COLUMN "Population"."Population10km"
	IS 'Population in a 10 km radius around the observing facility, specified in 1000s.'
;

COMMENT ON COLUMN "Population"."Population50km"
	IS 'Population in a 50 km radius around the observing facility, specified in 1000s.'
;

COMMENT ON COLUMN "Population"."Validperiod"
	IS 'The time period for which the specified climateZone is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next climateZone on record. If only one climateZone is specified for an observing facility, the time stamp is optional.'
;

COMMENT ON TABLE "Process"
	IS 'Details of the process used in the observation'
;

COMMENT ON COLUMN "Process"."Extension"
	IS 'This extension point is to facilitate the encoding of any other information for complimentary or local purposes such as complying with legislative frameworks.
However it should not be expected that any extension information will be appropriately processed, stored or made retrievable from any WIGOS systems or services. '
;

COMMENT ON TABLE "Processing"
	IS '[WMDS Category 7] Details of the processing procedures including analysis and post-processing.'
;

COMMENT ON COLUMN "Processing"."Aggregationperiod"
	IS '7-09 Time period over which individual samples/observations are aggregated'
;

COMMENT ON COLUMN "Processing"."Dataprocessing"
	IS '7-01 A description of the data processing used to generate observations including, if relevant, algorithms used to derive the result.'
;

COMMENT ON COLUMN "Processing"."Processingcentre"
	IS '7-02 Center at which the observation is processed. Although this is a free text string, it is expected that in practice this value should be from a controlled list of known centers.'
;

COMMENT ON COLUMN "Processing"."Softwaredetails"
	IS '7-05 Name and version of the software or processor used to derive the values'
;

COMMENT ON COLUMN "Processing"."Softwareurl"
	IS '7-05 URL for the software or processor used to derive the values'
;

COMMENT ON TABLE "Processing-valid"
	IS 'XML encodings of Processing shall conform to the XML form for Processing specified in the WMDR XML Schema.'
;

COMMENT ON TABLE "Process-valid"
	IS 'XML encodings of Process shall conform to the XML form for Process specified in the WMDR XML Schema.'
;

COMMENT ON TABLE "Program-affiliation"
	IS 'The value(s) for programAffiliation shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/ProgramAffiliation.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;

COMMENT ON TABLE "Programornetworkaffiliationtype"
	IS 'Codelist of Programme or Network Affiliations'
;

COMMENT ON TABLE "Purposeoffrequencyusetype"
	IS '5-03 Instrument specifications. This is a proxy for several more specific elements, here used for Type "PurposeOfFrequencyUseType". PurposeOfFrequencyUseType uses values (observation, telecomms)'
;

COMMENT ON TABLE "Qualityflagtype"
	IS 'Quality Flag codelist. '
;

COMMENT ON TABLE "Record-valid"
	IS 'XML encodings of WIGOSMetadataRecord shall conform to the XML form for WIGOSMetadataRecord specified in the WMDR XML Schema.'
;

COMMENT ON TABLE "Reference-time"
	IS 'The value for referenceTime, if supplied, shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/ReferenceTime.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;

COMMENT ON TABLE "Referencetimetype"
	IS '710 Reference time codelist'
;

COMMENT ON TABLE "Relative-elevation"
	IS 'The value for relativeElevation, if supplied, shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/RelativeElevation.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;

COMMENT ON TABLE "Relativeelevationtype"
	IS 'Relative elevation codelist'
;

COMMENT ON TABLE "Reporting"
	IS '[WMDS Category 7] Details of the reporting procedures.'
;

COMMENT ON COLUMN "Reporting"."Dataformat"
	IS '7-07 Description of the format in which the observed variable is primarily being provided, from the DataFormatType codelist. '
;

COMMENT ON COLUMN "Reporting"."Dataformatversion"
	IS '7-08 Version of the data format.'
;

COMMENT ON COLUMN "Reporting"."Datapolicy"
	IS '9-02 Details relating to the use and limitations surrounding data imposed by the supervising organization.'
;

COMMENT ON COLUMN "Reporting"."Levelofdata"
	IS '7-06 Level of data processing'
;

COMMENT ON COLUMN "Reporting"."Numberofobservationsinreportinginterval"
	IS 'Specifies how many aggregated observations are reported on average in each temporal reporting interval. For full temporal coverage, the number of observations reported = temporal reporting interval / aggregation period.'
;

COMMENT ON COLUMN "Reporting"."Numericalresolution"
	IS '7-12 Numerical resolution is a measure of the detail to which a numerical quantity is expressed. This is synonymous to numerical precision of the reporting, but can be different than the numerical precision of the observed value.'
;

COMMENT ON COLUMN "Reporting"."Officialstatus"
	IS '5-14 Official status of observation.'
;

COMMENT ON COLUMN "Reporting"."Referencedatum"
	IS '7-11 Reference datum used to convert observed quantity to reported quantity'
;

COMMENT ON COLUMN "Reporting"."Referencetimesource"
	IS '7-10 Time reference used for observations.'
;

COMMENT ON COLUMN "Reporting"."Spatialreportinginterval"
	IS '7-03 Spatial interval over which the observed variable is reported. Note that this is expressed as length, without geo-referencing. '
;

COMMENT ON COLUMN "Reporting"."Temporalreportinginterval"
	IS '7-03 Time interval over which the observed variable is reported. Note that this is a temporal distance, e.g., (every) 1 hour. '
;

COMMENT ON COLUMN "Reporting"."Timeliness"
	IS '7-13 Timeliness of reporting is the typical time taken between completion of the observation and when it becomes available to users.'
;

COMMENT ON COLUMN "Reporting"."Timestampmeaning"
	IS '7-03 Meaning of the time stamp in the temporalReportingInterval taken from the TimeStampMeaning codelist.'
;

COMMENT ON COLUMN "Reporting"."Uom"
	IS '1-02 Measurement Unit (unit of measure)'
;

COMMENT ON TABLE "Reportingstatus"
	IS 'A ReportingStatus is a reporting / operational status of an observing facility accompanied by a timestamp indicating the time from which that status is considered to be valid. If known, an end time may also be provided. In WIGOS, an ObservingFacility may carry multiple reporting statuses which are valid over different consecutive periods of time. If only a single reporting status is specified, the timestamp is optional and is inferred from the dateEstablished.'
;

COMMENT ON COLUMN "Reportingstatus"."Reportingstatus"
	IS '3-09 Declared reporting status of an observing facility [under a certain network/program affiliation]. '
;

COMMENT ON COLUMN "Reportingstatus"."Validperiod"
	IS 'The time period for which the specified reporting status is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next territory on record. If only one reporting status is specified for an observing facility, the time stamp is optional.'
;

COMMENT ON TABLE "Reporting-status"
	IS 'The value for reportingStatus shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/ReportingStatus.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;

COMMENT ON TABLE "Reportingstatustype"
	IS 'Station reporting status'
;

COMMENT ON TABLE "Reporting-valid"
	IS 'XML encodings of Reporting shall conform to the XML form for Reporting specified in the WMDR XML Schema.'
;

COMMENT ON TABLE "Representativeness"
	IS 'The value for representativeness, if supplied, shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/Representativeness


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;

COMMENT ON TABLE "Representativenesstype"
	IS 'Representativeness codelist.'
;

COMMENT ON TABLE "Responsibleparty"
	IS 'A ResponsibleParty is an individual or organization accompanied by a timestamp indicating the time from which that responsibleParty is considered to be valid. If known, an end time may also be provided. In WIGOS, an ObservingFacility or Equipment may carry multiple responsibleParty which are valid over different periods of time.'
;

COMMENT ON COLUMN "Responsibleparty"."Responsibleparty"
	IS '10-01 Party (organization or individual) responsible for the observing facility or equipment.'
;

COMMENT ON COLUMN "Responsibleparty"."Validperiod"
	IS 'The time period for which this responsibleParty is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next responsibleParty on record.'
;

COMMENT ON TABLE "Resultset"
	IS 'The ResultSet contains distribution information for the observation result(s). This may contain direct links to the data or to services or websites where the data can be sourced. Each MD_Distribution shall use CI_OnlineResource to point to URLs where data can be found. In order to distinguish the different URLs in a ResultSet. the description property of each MD_Distribution shall be used do describe what the URL resolves to (near real time data, archive etc.)'
;

COMMENT ON COLUMN "Resultset"."Distributioninfo"
	IS 'The distributionInfo provides information about how to source the data, described using MD_Distribution from ISO 19115.'
;

COMMENT ON TABLE "Sampletreatmenttype"
	IS 'Sample Treatment codelist'
;

COMMENT ON TABLE "Sampling"
	IS '6-01 Description of the procedure(s) involved in obtaining a sample/making an observation.'
;

COMMENT ON COLUMN "Sampling"."Sampletreatment"
	IS '6-02 Description of chemical or physical treatment of the sample prior to analysis from the SampleTreatmentType codelist.'
;

COMMENT ON COLUMN "Sampling"."Samplingprocedure"
	IS '6-01 The procedure(s) involved in obtaining a sample/making an observation. Taken from the SamplingProcedureType codelist'
;

COMMENT ON COLUMN "Sampling"."Samplingproceduredescription"
	IS '6-01 Description of the procedure(s) involved in obtaining a sample/making an observation.'
;

COMMENT ON COLUMN "Sampling"."Samplingstrategy"
	IS '6-03 The strategy used to generate the observed variable.'
;

COMMENT ON COLUMN "Sampling"."Samplingtimeperiod"
	IS '6-04 The period of time over which a measurement is taken. This value is a duration, e.g. 1 hour, not specific times and dates. '
;

COMMENT ON COLUMN "Sampling"."Spatialsamplingresolution"
	IS '6-05 The spatial sampling resolution is the size of the smallest observable object. The value of this property may be supported by explanatory information in spatialSamplingResolutionDescription.'
;

COMMENT ON COLUMN "Sampling"."Spatialsamplingresolutiondetails"
	IS '6-05 Explanatory information about the exact meaning of the value of samplingResolution. Note: not currently supported.'
;

COMMENT ON COLUMN "Sampling"."Temporalsamplinginterval"
	IS '6-06 Time period (as a duration) between the beginning of consecutive sampling periods.'
;

COMMENT ON TABLE "Samplingproceduretype"
	IS 'Sampling Procedure codelist'
;

COMMENT ON TABLE "Sampling-strategy"
	IS 'The value for samplingStrategy, if supplied, shall be taken from the code table published online at http://codes.wmo.int/common/wmdsSamplingStrategy.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;

COMMENT ON TABLE "Samplingstrategytype"
	IS 'Sampling Strategy codelist'
;

COMMENT ON TABLE "Sampling-valid"
	IS 'XML encodings of Sampling shall conform to the XML form for Sampling specified in the WMDR XML Schema.'
;

COMMENT ON TABLE "Schedule"
	IS '6-08 Description of the schedule of observation. Note: Schedules are defined in terms of months covered, weekdays covered, hours and minutes covered during each day. A complete definition of a schedule requires specification of the temporalReportingInterval, and may require the specification of diurnalBaseTime.'
;

COMMENT ON COLUMN "Schedule"."Endhour"
	IS 'End hour of schedule (0 to 23)'
;

COMMENT ON COLUMN "Schedule"."Endminute"
	IS 'End minute of schedule (0 to 59)'
;

COMMENT ON COLUMN "Schedule"."Endmonth"
	IS 'End month of schedule (January = 1, December = 12)'
;

COMMENT ON COLUMN "Schedule"."Endweekday"
	IS 'End day of schedule (Monday = 1, Sunday = 7)'
;

COMMENT ON COLUMN "Schedule"."Starthour"
	IS 'Start hour of schedule (0 to 23)'
;

COMMENT ON COLUMN "Schedule"."Startminute"
	IS 'Start minute of schedule (0 to 59)'
;

COMMENT ON COLUMN "Schedule"."Startmonth"
	IS 'Start month of schedule (January = 1, December = 12)'
;

COMMENT ON COLUMN "Schedule"."Startweekday"
	IS 'Start day of schedule (Monday = 1, Sunday = 7)'
;

COMMENT ON TABLE "Source-of-observation"
	IS 'The value(s) for sourceOfObservation shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/SourceOfObservation.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;

COMMENT ON TABLE "Sourceofobservationtype"
	IS '5-01 Source of observations in dataset (e.g. manual, automatic, visual)'
;

COMMENT ON TABLE "Surfacecover"
	IS 'A SurfaceCover is a climate zone accompanied by a timestamp indicating the time from which that surface cover class is considered to be valid. If known, an end time may also be provided. In WIGOS, an ObservingFacility may carry multiple surface cover classes which are valid over different consecutive periods of time. If only a single surface cover class is specified, the timestamp is optional.'
;

COMMENT ON COLUMN "Surfacecover"."Surfacecover"
	IS '4-01 The (bio)physical cover on the earth''s surface in the vicinity of the observations from the LandCoverType codelist . 
NOTE: Only applies for surface-based (fixed) observing facilities.'
;

COMMENT ON COLUMN "Surfacecover"."Surfacecoverclassification"
	IS '4-02 Reference to a surface cover classification type from the SurfaceCoverClassificationType codelist. NOTE: only if 4-01 is specified'
;

COMMENT ON COLUMN "Surfacecover"."Validperiod"
	IS 'The time period for which the specified surfaceCover is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next surfaceCover on record. If only one surfaceCover is specified for an observing facility, the time stamp is optional.'
;

COMMENT ON TABLE "Surface-cover"
	IS 'The value for surfaceCover, if supplied, shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/SurfaceCover.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;

COMMENT ON TABLE "Surface-cover-classification"
	IS 'The value for surfaceCoverClassification shall be taken from one of the SurfaceCoverClassificationType codelists at http://codes.wmo.int.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;

COMMENT ON TABLE "Surfacecoverclassificationtype"
	IS 'Surface Cover Classification Type'
;

COMMENT ON TABLE "Surfacecovertype"
	IS 'Surface cover types'
;

COMMENT ON TABLE "Surfaceroughness"
	IS 'A SurfaceRoughness is a specification of surfaceRoughness accompanied by a timestamp indicating the time from which that surfaceRoughness is considered to be valid. If known, an end time may also be provided. In WIGOS, an ObservingFacility may carry multiple surfaceRoughness specifications which are valid over different consecutive periods of time. If only a single surfaceRoughness is specified, the timestamp is optional.'
;

COMMENT ON COLUMN "Surfaceroughness"."Surfaceroughness"
	IS '4-06 surface roughness at the facility. From the SurfaceRoughnessType codelist.'
;

COMMENT ON COLUMN "Surfaceroughness"."Validperiod"
	IS 'The time period for which the specified surfaceRoughness is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next surfaceRoughness on record. If only one surfaceRoughness is specified for an observing facility, the time stamp is optional.'
;

COMMENT ON TABLE "Surface-roughness"
	IS 'The value for surfaceRoughness shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/SurfaceRoughnessDavenport.'
;

COMMENT ON TABLE "Surfaceroughnesstype"
	IS '4-06'
;

COMMENT ON TABLE "Territory"
	IS 'A Territory is a territory specification accompanied by a timestamp indicating the time from which that territory is considered to be valid. If known, an end time may also be provided. In WIGOS, an ObservingFacility may carry multiple territories which are valid over different consecutive periods of time. If only a single territory is specified, the timestamp is optional.'
;

COMMENT ON COLUMN "Territory"."Territoryname"
	IS '3-02 The territory the observing facility is located in, from the TerritoryType codelist.'
;

COMMENT ON COLUMN "Territory"."Validperiod"
	IS 'The time period for which the specified territory is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next territory on record. If only one territory is specified for an observing facility, the time stamp is optional.'
;

COMMENT ON TABLE "Territory-name"
	IS 'The value for territoryName shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/TerritoryName.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;

COMMENT ON TABLE "Territorytype"
	IS 'WMO Territories (territory of origin of the data)'
;

COMMENT ON TABLE "Time-stamp-meaning"
	IS 'The value for temporalReportingTimeStampMeaning, if supplied, shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/TimeStampMeaning.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;

COMMENT ON TABLE "Timestampmeaningtype"
	IS 'Time stamp meaning codelist'
;

COMMENT ON TABLE "Timezone"
	IS 'A TmeZone is a timeZone specification accompanied by a timestamp indicating the time from which that timeZone is considered to be valid. If known, an end time may also be provided. In WIGOS, an ObservingFacility may carry multiple timeZone specifications which are valid over different consecutive periods of time. If only a single timeZone is specified, the timestamp is optional.'
;

COMMENT ON COLUMN "Timezone"."Timezone"
	IS 'Time zone of the observing facility'
;

COMMENT ON COLUMN "Timezone"."Validperiod"
	IS 'The time period for which the specified climateZone is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next climateZone on record. If only one climateZone is specified for an observing facility, the time stamp is optional.'
;

COMMENT ON TABLE "Time-zone-explicit"
	IS 'All times shall be encoded using ISO 8601 time format. A time-zone designator must be supplied for all times. If the time is given as UTC then the time zone designator is ''Z'' e.g.

2016-12-25T12:00Z

For times given in a local (non UTC) time the time zone designator shall be expressed as an offset from UTC using plus or minus offsets.

For example, the following date times are all the same moment in time:

2016-12-25T10:00Z (10am, timezone is  UTC)

2016-12-25T14:00+04:00  (2pm, timezone is UTC + 4 hours)

2016-12-25T06:00-04:00   (6am, timezone is UTC -4 hours)'
;

COMMENT ON TABLE "Topographic-context"
	IS 'The value for topographicContext, if supplied, shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/TopographicContext.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;

COMMENT ON TABLE "Topographiccontexttype"
	IS 'Topographic Context codelist (based on Hammond 1954)'
;

COMMENT ON TABLE "Topographybathymetry"
	IS 'A TopographyBathymetry is a specification of topography / bathymetry accompanied by a timestamp indicating the time from which that topographyBathymetry specification is considered to be valid. If known, an end time may also be provided. In WIGOS, an ObservingFacility may carry multiple topographyBathymetry specifications which are valid over different consecutive periods of time. If only a single topographyBathymetry is specified, the timestamp is optional.'
;

COMMENT ON COLUMN "Topographybathymetry"."Altitudeordepth"
	IS '4-03 The altitude/depth with respect to mean sea level from the AltitudeOrDepthTypeCodelist'
;

COMMENT ON COLUMN "Topographybathymetry"."Localtopography"
	IS '4-03 The local topography from the LocalTopographyType codelist'
;

COMMENT ON COLUMN "Topographybathymetry"."Relativeelevation"
	IS '4-03 The relative elevation from the RelativeElevationType codelist'
;

COMMENT ON COLUMN "Topographybathymetry"."Topographiccontext"
	IS '4-03 The topographic context from the TopographicContextType codelist'
;

COMMENT ON COLUMN "Topographybathymetry"."Validperiod"
	IS 'The time period for which the specified topographyBathymetry is known to be valid. Normally, this will be specified as a "from" date, implying that the validity extends but does not include the next topographyBathymetry on record. If only one topographyBathymetry is specified for an observing facility, the time stamp is optional.'
;

COMMENT ON TABLE "Traceabilitytype"
	IS 'Traceability codelist'
;

COMMENT ON TABLE "Transmissionmodetype"
	IS '5-03 Instrument specifications. This is a proxy for several more specific elements, her used for Type "TransmissionModeType". TransmissionModeType uses values (pulsed, continuous-wave)'
;

COMMENT ON TABLE "Uncertaintyevalproctype"
	IS 'Uncertainty evaluation procedure codelist'
;

COMMENT ON TABLE "Unique-observed-variable"
	IS 'Each OM_Observation should describe the observation of a different observed variable (e.g. humidity, air temperature) from a station/facility. '
;

COMMENT ON TABLE "Unit-of-measure"
	IS 'The value for uom, if supplied, shall be taken from the code table published online at http://codes.wmo.int/common/Unit.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;

COMMENT ON TABLE "Valid-local-references"
	IS 'Where xlink:href is used to refer to a local object (using the #id notation) there must be a corresponding object with gml:id equal to "id" in the same XML document.

Where xlink:href is used to make a reference to a non-local object, e.g. using a WIGOS identifier or a link to a term in a codelist then this is not applicable.'
;

COMMENT ON TABLE "Well-formed"
	IS 'XML encodings of WMDR shall be well formed XML documents (syntactically correct). A well-formed XML document conforms to the XML specification. (https://www.w3.org/TR/REC-xml/ )'
;

COMMENT ON TABLE "Wigosmetadatarecord"
	IS 'The WIGOSMetadataRecord is a container for WIGOS information for the purposes of packaging the information for delivery to, or transfer between, systems.'
;

COMMENT ON COLUMN "Wigosmetadatarecord"."Deployment"
	IS 'A Deployment instance in this record. Note that Deployments may also be encoded inline with the OM_Observation (as part of the Process).'
;

COMMENT ON COLUMN "Wigosmetadatarecord"."Equipment"
	IS 'An Equipment instance in this metadata record.'
;

COMMENT ON COLUMN "Wigosmetadatarecord"."Equipmentlog"
	IS 'An EquipmentLog instance in this metadata record. Note that an EquipmentLog may also be encoded inline with the Equipment instance.'
;

COMMENT ON COLUMN "Wigosmetadatarecord"."Extension"
	IS 'This extension point is to facilitate the encoding of any other information for complimentary or local purposes such as complying with legislative frameworks.
However it should not be expected that any extension information will be appropriately processed, stored or made retrievable from any WIGOS systems or services. '
;

COMMENT ON COLUMN "Wigosmetadatarecord"."Facility"
	IS 'An ObservingFacility instance in this metadata record.'
;

COMMENT ON COLUMN "Wigosmetadatarecord"."Facilitylog"
	IS 'A FacilityLog instance in this metadata record. Note that an FacilityLog may also be encoded inline with the ObservingFacility instance.'
;

COMMENT ON COLUMN "Wigosmetadatarecord"."Facilityset"
	IS 'A FacilitySet instance in this metadata record. The FacilitySet will simply consist of links to ObservingFacilities belonging to the set.'
;

COMMENT ON COLUMN "Wigosmetadatarecord"."Headerinformation"
	IS 'A header section must be included with every WIGOS MetadataRecord.'
;

COMMENT ON TABLE "Wmo-region"
	IS 'The value for wmoRegion shall be taken from the code table published online at http://codes.wmo.int/common/wmdr/WMORegion.


This codelist is also described in the WIGOS Metadata Standard, Chapter VII.'
;

COMMENT ON TABLE "Wmoregiontype"
	IS 'WMO Regions (region of origin of data)'
;

COMMENT ON TABLE "Xsd-valid"
	IS 'XML encodings of WMDR shall validate against the WMDR XML Schema (xsd).'
;
