from typing import Union, List, Optional

from pyspark.sql.types import (
    StructType,
    StructField,
    StringType,
    ArrayType,
    BooleanType,
    IntegerType,
    DataType,
)


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class ElementDefinitionSchema:
    """
    Captures constraints on each element within the resource, profile, or
    extension.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
        extension_fields: Optional[List[str]] = [
            "valueBoolean",
            "valueCode",
            "valueDate",
            "valueDateTime",
            "valueDecimal",
            "valueId",
            "valueInteger",
            "valuePositiveInt",
            "valueString",
            "valueTime",
            "valueUnsignedInt",
            "valueUri",
            "valueUrl",
        ],
        extension_depth: int = 0,
        max_extension_depth: Optional[int] = 2,
    ) -> Union[StructType, DataType]:
        """
        Captures constraints on each element within the resource, profile, or
        extension.


        id: unique id for the element within a resource (for internal references). This
            may be any string value that does not contain spaces.

        extension: May be used to represent additional information that is not part of the basic
            definition of the element. In order to make the use of extensions safe and
            manageable, there is a strict set of governance  applied to the definition and
            use of extensions. Though any implementer is allowed to define an extension,
            there is a set of requirements that SHALL be met as part of the definition of
            the extension.

        path: The path identifies the element and is expressed as a "."-separated list of
            ancestor elements, beginning with the name of the resource or extension.

        representation: Codes that define how this element is represented in instances, when the
            deviation varies from the normal case.

        sliceName: The name of this element definition slice, when slicing is working. The name
            must be a token with no dots or spaces. This is a unique name referring to a
            specific set of constraints applied to this element, used to provide a name to
            different slices of the same element.

        label: A single preferred label which is the text to display beside the element
            indicating its meaning or to use to prompt for the element in a user display
            or form.

        code: A code that has the same meaning as the element in a particular terminology.

        slicing: Indicates that the element is sliced into a set of alternative definitions
            (i.e. in a structure definition, there are multiple different constraints on a
            single element in the base resource). Slicing can be used in any resource that
            has cardinality ..* on the base resource, or any resource with a choice of
            types. The set of slices is any elements that come after this in the element
            sequence that have the same path, until a shorter path occurs (the shorter
            path terminates the set).

        short: A concise description of what this element means (e.g. for use in
            autogenerated summaries).

        definition: Provides a complete explanation of the meaning of the data element for human
            readability.  For the case of elements derived from existing elements (e.g.
            constraints), the definition SHALL be consistent with the base definition, but
            convey the meaning of the element in the particular context of use of the
            resource.

        comment: Explanatory notes and implementation guidance about the data element,
            including notes about how to use the data properly, exceptions to proper use,
            etc.

        requirements: This element is for traceability of why the element was created and why the
            constraints exist as they do. This may be used to point to source materials or
            specifications that drove the structure of this element.

        alias: Identifies additional names by which this element might also be known.

        min: The minimum number of times this element SHALL appear in the instance.

        max: The maximum number of times this element is permitted to appear in the
            instance.

        base: Information about the base definition of the element, provided to make it
            unnecessary for tools to trace the deviation of the element through the
            derived and related profiles. This information is provided when the element
            definition is not the original definition of an element - i.g. either in a
            constraint on another type, or for elements from a super type in a snap shot.

        contentReference: Identifies the identity of an element defined elsewhere in the profile whose
            content rules should be applied to the current element.

        type: The data type or resource that the value of this element is permitted to be.

        defaultValueBoolean: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueInteger: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueDecimal: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueBase64Binary: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueInstant: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueString: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueUri: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueDate: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueDateTime: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueTime: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueCode: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueOid: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueUuid: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueId: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueUnsignedInt: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValuePositiveInt: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueMarkdown: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueElement: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueExtension: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueBackboneElement: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueNarrative: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueAnnotation: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueAttachment: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueIdentifier: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueCodeableConcept: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueCoding: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueQuantity: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueDuration: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueSimpleQuantity: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueDistance: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueCount: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueMoney: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueAge: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueRange: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValuePeriod: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueRatio: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueReference: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueSampledData: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueSignature: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueHumanName: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueAddress: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueContactPoint: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueTiming: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueMeta: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueElementDefinition: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueContactDetail: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueContributor: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueDosage: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueRelatedArtifact: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueUsageContext: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueDataRequirement: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueParameterDefinition: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        defaultValueTriggerDefinition: The value that should be used if there is no value stated in the instance
            (e.g. 'if not otherwise specified, the abstract is false').

        meaningWhenMissing: The Implicit meaning that is to be understood when this element is missing
            (e.g. 'when this element is missing, the period is ongoing'.

        orderMeaning: If present, indicates that the order of the repeating element has meaning and
            describes what that meaning is.  If absent, it means that the order of the
            element has no meaning.

        fixedBoolean: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedInteger: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedDecimal: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedBase64Binary: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedInstant: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedString: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedUri: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedDate: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedDateTime: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedTime: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedCode: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedOid: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedUuid: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedId: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedUnsignedInt: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedPositiveInt: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedMarkdown: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedElement: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedExtension: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedBackboneElement: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedNarrative: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedAnnotation: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedAttachment: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedIdentifier: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedCodeableConcept: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedCoding: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedQuantity: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedDuration: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedSimpleQuantity: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedDistance: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedCount: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedMoney: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedAge: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedRange: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedPeriod: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedRatio: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedReference: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedSampledData: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedSignature: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedHumanName: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedAddress: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedContactPoint: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedTiming: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedMeta: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedElementDefinition: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedContactDetail: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedContributor: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedDosage: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedRelatedArtifact: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedUsageContext: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedDataRequirement: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedParameterDefinition: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        fixedTriggerDefinition: Specifies a value that SHALL be exactly the value  for this element in the
            instance. For purposes of comparison, non-significant whitespace is ignored,
            and all values must be an exact match (case and accent sensitive). Missing
            elements/attributes must also be missing.

        patternBoolean: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternInteger: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternDecimal: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternBase64Binary: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternInstant: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternString: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternUri: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternDate: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternDateTime: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternTime: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternCode: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternOid: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternUuid: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternId: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternUnsignedInt: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternPositiveInt: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternMarkdown: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternElement: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternExtension: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternBackboneElement: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternNarrative: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternAnnotation: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternAttachment: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternIdentifier: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternCodeableConcept: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternCoding: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternQuantity: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternDuration: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternSimpleQuantity: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternDistance: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternCount: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternMoney: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternAge: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternRange: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternPeriod: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternRatio: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternReference: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternSampledData: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternSignature: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternHumanName: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternAddress: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternContactPoint: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternTiming: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternMeta: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternElementDefinition: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternContactDetail: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternContributor: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternDosage: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternRelatedArtifact: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternUsageContext: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternDataRequirement: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternParameterDefinition: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        patternTriggerDefinition: Specifies a value that the value in the instance SHALL follow - that is, any
            value in the pattern must be found in the instance. Other additional values
            may be found too. This is effectively constraint by example.  The values of
            elements present in the pattern must match exactly (case-sensitive, accent-
            sensitive, etc.).

        example: A sample value for this element demonstrating the type of information that
            would typically be found in the element.

        minValueDate: The minimum allowed value for the element. The value is inclusive. This is
            allowed for the types date, dateTime, instant, time, decimal, integer, and
            Quantity.

        minValueDateTime: The minimum allowed value for the element. The value is inclusive. This is
            allowed for the types date, dateTime, instant, time, decimal, integer, and
            Quantity.

        minValueInstant: The minimum allowed value for the element. The value is inclusive. This is
            allowed for the types date, dateTime, instant, time, decimal, integer, and
            Quantity.

        minValueTime: The minimum allowed value for the element. The value is inclusive. This is
            allowed for the types date, dateTime, instant, time, decimal, integer, and
            Quantity.

        minValueDecimal: The minimum allowed value for the element. The value is inclusive. This is
            allowed for the types date, dateTime, instant, time, decimal, integer, and
            Quantity.

        minValueInteger: The minimum allowed value for the element. The value is inclusive. This is
            allowed for the types date, dateTime, instant, time, decimal, integer, and
            Quantity.

        minValuePositiveInt: The minimum allowed value for the element. The value is inclusive. This is
            allowed for the types date, dateTime, instant, time, decimal, integer, and
            Quantity.

        minValueUnsignedInt: The minimum allowed value for the element. The value is inclusive. This is
            allowed for the types date, dateTime, instant, time, decimal, integer, and
            Quantity.

        minValueQuantity: The minimum allowed value for the element. The value is inclusive. This is
            allowed for the types date, dateTime, instant, time, decimal, integer, and
            Quantity.

        maxValueDate: The maximum allowed value for the element. The value is inclusive. This is
            allowed for the types date, dateTime, instant, time, decimal, integer, and
            Quantity.

        maxValueDateTime: The maximum allowed value for the element. The value is inclusive. This is
            allowed for the types date, dateTime, instant, time, decimal, integer, and
            Quantity.

        maxValueInstant: The maximum allowed value for the element. The value is inclusive. This is
            allowed for the types date, dateTime, instant, time, decimal, integer, and
            Quantity.

        maxValueTime: The maximum allowed value for the element. The value is inclusive. This is
            allowed for the types date, dateTime, instant, time, decimal, integer, and
            Quantity.

        maxValueDecimal: The maximum allowed value for the element. The value is inclusive. This is
            allowed for the types date, dateTime, instant, time, decimal, integer, and
            Quantity.

        maxValueInteger: The maximum allowed value for the element. The value is inclusive. This is
            allowed for the types date, dateTime, instant, time, decimal, integer, and
            Quantity.

        maxValuePositiveInt: The maximum allowed value for the element. The value is inclusive. This is
            allowed for the types date, dateTime, instant, time, decimal, integer, and
            Quantity.

        maxValueUnsignedInt: The maximum allowed value for the element. The value is inclusive. This is
            allowed for the types date, dateTime, instant, time, decimal, integer, and
            Quantity.

        maxValueQuantity: The maximum allowed value for the element. The value is inclusive. This is
            allowed for the types date, dateTime, instant, time, decimal, integer, and
            Quantity.

        maxLength: Indicates the maximum length in characters that is permitted to be present in
            conformant instances and which is expected to be supported by conformant
            consumers that support the element.

        condition: A reference to an invariant that may make additional statements about the
            cardinality or value in the instance.

        constraint: Formal constraints such as co-occurrence and other constraints that can be
            computationally evaluated within the context of the instance.

        mustSupport: If true, implementations that produce or consume resources SHALL provide
            "support" for the element in some meaningful way.  If false, the element may
            be ignored and not supported.

        isModifier: If true, the value of this element affects the interpretation of the element
            or resource that contains it, and the value of the element cannot be ignored.
            Typically, this is used for status, negation and qualification codes. The
            effect of this is that the element cannot be ignored by systems: they SHALL
            either recognize the element and process it, and/or a pre-determination has
            been made that it is not relevant to their particular system.

        isSummary: Whether the element should be included if a client requests a search with the
            parameter _summary=true.

        binding: Binds to a value set if this element is coded (code, Coding, CodeableConcept,
            Quantity), or the data types (string, uri).

        mapping: Identifies a concept from an external specification that roughly corresponds
            to this element.

        """
        from spark_fhir_schemas.stu3.complex_types.extension import ExtensionSchema
        from spark_fhir_schemas.stu3.complex_types.coding import CodingSchema
        from spark_fhir_schemas.stu3.complex_types.elementdefinition_slicing import (
            ElementDefinition_SlicingSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.elementdefinition_base import (
            ElementDefinition_BaseSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.elementdefinition_type import (
            ElementDefinition_TypeSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.element import ElementSchema
        from spark_fhir_schemas.stu3.complex_types.backboneelement import (
            BackboneElementSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.narrative import NarrativeSchema
        from spark_fhir_schemas.stu3.complex_types.annotation import AnnotationSchema
        from spark_fhir_schemas.stu3.complex_types.attachment import AttachmentSchema
        from spark_fhir_schemas.stu3.complex_types.identifier import IdentifierSchema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import (
            CodeableConceptSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.quantity import QuantitySchema
        from spark_fhir_schemas.stu3.complex_types.duration import DurationSchema
        from spark_fhir_schemas.stu3.complex_types.distance import DistanceSchema
        from spark_fhir_schemas.stu3.complex_types.count import CountSchema
        from spark_fhir_schemas.stu3.complex_types.money import MoneySchema
        from spark_fhir_schemas.stu3.complex_types.age import AgeSchema
        from spark_fhir_schemas.stu3.complex_types.range import RangeSchema
        from spark_fhir_schemas.stu3.complex_types.period import PeriodSchema
        from spark_fhir_schemas.stu3.complex_types.ratio import RatioSchema
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        from spark_fhir_schemas.stu3.complex_types.sampleddata import SampledDataSchema
        from spark_fhir_schemas.stu3.complex_types.signature import SignatureSchema
        from spark_fhir_schemas.stu3.complex_types.humanname import HumanNameSchema
        from spark_fhir_schemas.stu3.complex_types.address import AddressSchema
        from spark_fhir_schemas.stu3.complex_types.contactpoint import (
            ContactPointSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.timing import TimingSchema
        from spark_fhir_schemas.stu3.complex_types.meta import MetaSchema
        from spark_fhir_schemas.stu3.complex_types.contactdetail import (
            ContactDetailSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.contributor import ContributorSchema
        from spark_fhir_schemas.stu3.complex_types.dosage import DosageSchema
        from spark_fhir_schemas.stu3.complex_types.relatedartifact import (
            RelatedArtifactSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.usagecontext import (
            UsageContextSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.datarequirement import (
            DataRequirementSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.parameterdefinition import (
            ParameterDefinitionSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.triggerdefinition import (
            TriggerDefinitionSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.elementdefinition_example import (
            ElementDefinition_ExampleSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.elementdefinition_constraint import (
            ElementDefinition_ConstraintSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.elementdefinition_binding import (
            ElementDefinition_BindingSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.elementdefinition_mapping import (
            ElementDefinition_MappingSchema,
        )

        if (
            max_recursion_limit
            and nesting_list.count("ElementDefinition") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["ElementDefinition"]
        schema = StructType(
            [
                # unique id for the element within a resource (for internal references). This
                # may be any string value that does not contain spaces.
                StructField("id", StringType(), True),
                # May be used to represent additional information that is not part of the basic
                # definition of the element. In order to make the use of extensions safe and
                # manageable, there is a strict set of governance  applied to the definition and
                # use of extensions. Though any implementer is allowed to define an extension,
                # there is a set of requirements that SHALL be met as part of the definition of
                # the extension.
                StructField(
                    "extension",
                    ArrayType(
                        ExtensionSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                            extension_fields=extension_fields,
                            extension_depth=extension_depth,
                            max_extension_depth=max_extension_depth,
                        )
                    ),
                    True,
                ),
                # The path identifies the element and is expressed as a "."-separated list of
                # ancestor elements, beginning with the name of the resource or extension.
                StructField("path", StringType(), True),
                # Codes that define how this element is represented in instances, when the
                # deviation varies from the normal case.
                # The name of this element definition slice, when slicing is working. The name
                # must be a token with no dots or spaces. This is a unique name referring to a
                # specific set of constraints applied to this element, used to provide a name to
                # different slices of the same element.
                StructField("sliceName", StringType(), True),
                # A single preferred label which is the text to display beside the element
                # indicating its meaning or to use to prompt for the element in a user display
                # or form.
                StructField("label", StringType(), True),
                # A code that has the same meaning as the element in a particular terminology.
                StructField(
                    "code",
                    ArrayType(
                        CodingSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                            extension_fields=extension_fields,
                            extension_depth=extension_depth,
                            max_extension_depth=max_extension_depth,
                        )
                    ),
                    True,
                ),
                # Indicates that the element is sliced into a set of alternative definitions
                # (i.e. in a structure definition, there are multiple different constraints on a
                # single element in the base resource). Slicing can be used in any resource that
                # has cardinality ..* on the base resource, or any resource with a choice of
                # types. The set of slices is any elements that come after this in the element
                # sequence that have the same path, until a shorter path occurs (the shorter
                # path terminates the set).
                StructField(
                    "slicing",
                    ElementDefinition_SlicingSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # A concise description of what this element means (e.g. for use in
                # autogenerated summaries).
                StructField("short", StringType(), True),
                # Provides a complete explanation of the meaning of the data element for human
                # readability.  For the case of elements derived from existing elements (e.g.
                # constraints), the definition SHALL be consistent with the base definition, but
                # convey the meaning of the element in the particular context of use of the
                # resource.
                StructField("definition", StringType(), True),
                # Explanatory notes and implementation guidance about the data element,
                # including notes about how to use the data properly, exceptions to proper use,
                # etc.
                StructField("comment", StringType(), True),
                # This element is for traceability of why the element was created and why the
                # constraints exist as they do. This may be used to point to source materials or
                # specifications that drove the structure of this element.
                StructField("requirements", StringType(), True),
                # Identifies additional names by which this element might also be known.
                # The minimum number of times this element SHALL appear in the instance.
                StructField("min", IntegerType(), True),
                # The maximum number of times this element is permitted to appear in the
                # instance.
                StructField("max", StringType(), True),
                # Information about the base definition of the element, provided to make it
                # unnecessary for tools to trace the deviation of the element through the
                # derived and related profiles. This information is provided when the element
                # definition is not the original definition of an element - i.g. either in a
                # constraint on another type, or for elements from a super type in a snap shot.
                StructField(
                    "base",
                    ElementDefinition_BaseSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Identifies the identity of an element defined elsewhere in the profile whose
                # content rules should be applied to the current element.
                StructField("contentReference", StringType(), True),
                # The data type or resource that the value of this element is permitted to be.
                StructField(
                    "type",
                    ArrayType(
                        ElementDefinition_TypeSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                            extension_fields=extension_fields,
                            extension_depth=extension_depth,
                            max_extension_depth=max_extension_depth,
                        )
                    ),
                    True,
                ),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField("defaultValueBoolean", BooleanType(), True),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField("defaultValueInteger", IntegerType(), True),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField("defaultValueDecimal", IntegerType(), True),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField("defaultValueBase64Binary", StringType(), True),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField("defaultValueInstant", StringType(), True),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField("defaultValueString", StringType(), True),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField("defaultValueUri", StringType(), True),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField("defaultValueDate", StringType(), True),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField("defaultValueDateTime", StringType(), True),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField("defaultValueTime", StringType(), True),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField("defaultValueCode", StringType(), True),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField("defaultValueOid", StringType(), True),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField("defaultValueUuid", StringType(), True),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField("defaultValueId", StringType(), True),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField("defaultValueUnsignedInt", IntegerType(), True),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField("defaultValuePositiveInt", IntegerType(), True),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField("defaultValueMarkdown", StringType(), True),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField(
                    "defaultValueElement",
                    ElementSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField(
                    "defaultValueExtension",
                    ExtensionSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField(
                    "defaultValueBackboneElement",
                    BackboneElementSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField(
                    "defaultValueNarrative",
                    NarrativeSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField(
                    "defaultValueAnnotation",
                    AnnotationSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField(
                    "defaultValueAttachment",
                    AttachmentSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField(
                    "defaultValueIdentifier",
                    IdentifierSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField(
                    "defaultValueCodeableConcept",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField(
                    "defaultValueCoding",
                    CodingSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField(
                    "defaultValueQuantity",
                    QuantitySchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField(
                    "defaultValueDuration",
                    DurationSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField(
                    "defaultValueSimpleQuantity",
                    QuantitySchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField(
                    "defaultValueDistance",
                    DistanceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField(
                    "defaultValueCount",
                    CountSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField(
                    "defaultValueMoney",
                    MoneySchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField(
                    "defaultValueAge",
                    AgeSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField(
                    "defaultValueRange",
                    RangeSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField(
                    "defaultValuePeriod",
                    PeriodSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField(
                    "defaultValueRatio",
                    RatioSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField(
                    "defaultValueReference",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField(
                    "defaultValueSampledData",
                    SampledDataSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField(
                    "defaultValueSignature",
                    SignatureSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField(
                    "defaultValueHumanName",
                    HumanNameSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField(
                    "defaultValueAddress",
                    AddressSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField(
                    "defaultValueContactPoint",
                    ContactPointSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField(
                    "defaultValueTiming",
                    TimingSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField(
                    "defaultValueMeta",
                    MetaSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField(
                    "defaultValueElementDefinition",
                    ElementDefinitionSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField(
                    "defaultValueContactDetail",
                    ContactDetailSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField(
                    "defaultValueContributor",
                    ContributorSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField(
                    "defaultValueDosage",
                    DosageSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField(
                    "defaultValueRelatedArtifact",
                    RelatedArtifactSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField(
                    "defaultValueUsageContext",
                    UsageContextSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField(
                    "defaultValueDataRequirement",
                    DataRequirementSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField(
                    "defaultValueParameterDefinition",
                    ParameterDefinitionSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The value that should be used if there is no value stated in the instance
                # (e.g. 'if not otherwise specified, the abstract is false').
                StructField(
                    "defaultValueTriggerDefinition",
                    TriggerDefinitionSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The Implicit meaning that is to be understood when this element is missing
                # (e.g. 'when this element is missing, the period is ongoing'.
                StructField("meaningWhenMissing", StringType(), True),
                # If present, indicates that the order of the repeating element has meaning and
                # describes what that meaning is.  If absent, it means that the order of the
                # element has no meaning.
                StructField("orderMeaning", StringType(), True),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField("fixedBoolean", BooleanType(), True),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField("fixedInteger", IntegerType(), True),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField("fixedDecimal", IntegerType(), True),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField("fixedBase64Binary", StringType(), True),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField("fixedInstant", StringType(), True),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField("fixedString", StringType(), True),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField("fixedUri", StringType(), True),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField("fixedDate", StringType(), True),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField("fixedDateTime", StringType(), True),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField("fixedTime", StringType(), True),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField("fixedCode", StringType(), True),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField("fixedOid", StringType(), True),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField("fixedUuid", StringType(), True),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField("fixedId", StringType(), True),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField("fixedUnsignedInt", IntegerType(), True),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField("fixedPositiveInt", IntegerType(), True),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField("fixedMarkdown", StringType(), True),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField(
                    "fixedElement",
                    ElementSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField(
                    "fixedExtension",
                    ExtensionSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField(
                    "fixedBackboneElement",
                    BackboneElementSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField(
                    "fixedNarrative",
                    NarrativeSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField(
                    "fixedAnnotation",
                    AnnotationSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField(
                    "fixedAttachment",
                    AttachmentSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField(
                    "fixedIdentifier",
                    IdentifierSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField(
                    "fixedCodeableConcept",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField(
                    "fixedCoding",
                    CodingSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField(
                    "fixedQuantity",
                    QuantitySchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField(
                    "fixedDuration",
                    DurationSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField(
                    "fixedSimpleQuantity",
                    QuantitySchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField(
                    "fixedDistance",
                    DistanceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField(
                    "fixedCount",
                    CountSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField(
                    "fixedMoney",
                    MoneySchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField(
                    "fixedAge",
                    AgeSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField(
                    "fixedRange",
                    RangeSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField(
                    "fixedPeriod",
                    PeriodSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField(
                    "fixedRatio",
                    RatioSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField(
                    "fixedReference",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField(
                    "fixedSampledData",
                    SampledDataSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField(
                    "fixedSignature",
                    SignatureSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField(
                    "fixedHumanName",
                    HumanNameSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField(
                    "fixedAddress",
                    AddressSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField(
                    "fixedContactPoint",
                    ContactPointSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField(
                    "fixedTiming",
                    TimingSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField(
                    "fixedMeta",
                    MetaSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField(
                    "fixedElementDefinition",
                    ElementDefinitionSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField(
                    "fixedContactDetail",
                    ContactDetailSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField(
                    "fixedContributor",
                    ContributorSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField(
                    "fixedDosage",
                    DosageSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField(
                    "fixedRelatedArtifact",
                    RelatedArtifactSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField(
                    "fixedUsageContext",
                    UsageContextSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField(
                    "fixedDataRequirement",
                    DataRequirementSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField(
                    "fixedParameterDefinition",
                    ParameterDefinitionSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that SHALL be exactly the value  for this element in the
                # instance. For purposes of comparison, non-significant whitespace is ignored,
                # and all values must be an exact match (case and accent sensitive). Missing
                # elements/attributes must also be missing.
                StructField(
                    "fixedTriggerDefinition",
                    TriggerDefinitionSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField("patternBoolean", BooleanType(), True),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField("patternInteger", IntegerType(), True),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField("patternDecimal", IntegerType(), True),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField("patternBase64Binary", StringType(), True),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField("patternInstant", StringType(), True),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField("patternString", StringType(), True),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField("patternUri", StringType(), True),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField("patternDate", StringType(), True),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField("patternDateTime", StringType(), True),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField("patternTime", StringType(), True),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField("patternCode", StringType(), True),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField("patternOid", StringType(), True),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField("patternUuid", StringType(), True),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField("patternId", StringType(), True),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField("patternUnsignedInt", IntegerType(), True),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField("patternPositiveInt", IntegerType(), True),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField("patternMarkdown", StringType(), True),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField(
                    "patternElement",
                    ElementSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField(
                    "patternExtension",
                    ExtensionSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField(
                    "patternBackboneElement",
                    BackboneElementSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField(
                    "patternNarrative",
                    NarrativeSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField(
                    "patternAnnotation",
                    AnnotationSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField(
                    "patternAttachment",
                    AttachmentSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField(
                    "patternIdentifier",
                    IdentifierSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField(
                    "patternCodeableConcept",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField(
                    "patternCoding",
                    CodingSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField(
                    "patternQuantity",
                    QuantitySchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField(
                    "patternDuration",
                    DurationSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField(
                    "patternSimpleQuantity",
                    QuantitySchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField(
                    "patternDistance",
                    DistanceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField(
                    "patternCount",
                    CountSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField(
                    "patternMoney",
                    MoneySchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField(
                    "patternAge",
                    AgeSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField(
                    "patternRange",
                    RangeSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField(
                    "patternPeriod",
                    PeriodSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField(
                    "patternRatio",
                    RatioSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField(
                    "patternReference",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField(
                    "patternSampledData",
                    SampledDataSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField(
                    "patternSignature",
                    SignatureSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField(
                    "patternHumanName",
                    HumanNameSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField(
                    "patternAddress",
                    AddressSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField(
                    "patternContactPoint",
                    ContactPointSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField(
                    "patternTiming",
                    TimingSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField(
                    "patternMeta",
                    MetaSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField(
                    "patternElementDefinition",
                    ElementDefinitionSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField(
                    "patternContactDetail",
                    ContactDetailSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField(
                    "patternContributor",
                    ContributorSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField(
                    "patternDosage",
                    DosageSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField(
                    "patternRelatedArtifact",
                    RelatedArtifactSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField(
                    "patternUsageContext",
                    UsageContextSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField(
                    "patternDataRequirement",
                    DataRequirementSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField(
                    "patternParameterDefinition",
                    ParameterDefinitionSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Specifies a value that the value in the instance SHALL follow - that is, any
                # value in the pattern must be found in the instance. Other additional values
                # may be found too. This is effectively constraint by example.  The values of
                # elements present in the pattern must match exactly (case-sensitive, accent-
                # sensitive, etc.).
                StructField(
                    "patternTriggerDefinition",
                    TriggerDefinitionSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # A sample value for this element demonstrating the type of information that
                # would typically be found in the element.
                StructField(
                    "example",
                    ArrayType(
                        ElementDefinition_ExampleSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                            extension_fields=extension_fields,
                            extension_depth=extension_depth,
                            max_extension_depth=max_extension_depth,
                        )
                    ),
                    True,
                ),
                # The minimum allowed value for the element. The value is inclusive. This is
                # allowed for the types date, dateTime, instant, time, decimal, integer, and
                # Quantity.
                StructField("minValueDate", StringType(), True),
                # The minimum allowed value for the element. The value is inclusive. This is
                # allowed for the types date, dateTime, instant, time, decimal, integer, and
                # Quantity.
                StructField("minValueDateTime", StringType(), True),
                # The minimum allowed value for the element. The value is inclusive. This is
                # allowed for the types date, dateTime, instant, time, decimal, integer, and
                # Quantity.
                StructField("minValueInstant", StringType(), True),
                # The minimum allowed value for the element. The value is inclusive. This is
                # allowed for the types date, dateTime, instant, time, decimal, integer, and
                # Quantity.
                StructField("minValueTime", StringType(), True),
                # The minimum allowed value for the element. The value is inclusive. This is
                # allowed for the types date, dateTime, instant, time, decimal, integer, and
                # Quantity.
                StructField("minValueDecimal", IntegerType(), True),
                # The minimum allowed value for the element. The value is inclusive. This is
                # allowed for the types date, dateTime, instant, time, decimal, integer, and
                # Quantity.
                StructField("minValueInteger", IntegerType(), True),
                # The minimum allowed value for the element. The value is inclusive. This is
                # allowed for the types date, dateTime, instant, time, decimal, integer, and
                # Quantity.
                StructField("minValuePositiveInt", IntegerType(), True),
                # The minimum allowed value for the element. The value is inclusive. This is
                # allowed for the types date, dateTime, instant, time, decimal, integer, and
                # Quantity.
                StructField("minValueUnsignedInt", IntegerType(), True),
                # The minimum allowed value for the element. The value is inclusive. This is
                # allowed for the types date, dateTime, instant, time, decimal, integer, and
                # Quantity.
                StructField(
                    "minValueQuantity",
                    QuantitySchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The maximum allowed value for the element. The value is inclusive. This is
                # allowed for the types date, dateTime, instant, time, decimal, integer, and
                # Quantity.
                StructField("maxValueDate", StringType(), True),
                # The maximum allowed value for the element. The value is inclusive. This is
                # allowed for the types date, dateTime, instant, time, decimal, integer, and
                # Quantity.
                StructField("maxValueDateTime", StringType(), True),
                # The maximum allowed value for the element. The value is inclusive. This is
                # allowed for the types date, dateTime, instant, time, decimal, integer, and
                # Quantity.
                StructField("maxValueInstant", StringType(), True),
                # The maximum allowed value for the element. The value is inclusive. This is
                # allowed for the types date, dateTime, instant, time, decimal, integer, and
                # Quantity.
                StructField("maxValueTime", StringType(), True),
                # The maximum allowed value for the element. The value is inclusive. This is
                # allowed for the types date, dateTime, instant, time, decimal, integer, and
                # Quantity.
                StructField("maxValueDecimal", IntegerType(), True),
                # The maximum allowed value for the element. The value is inclusive. This is
                # allowed for the types date, dateTime, instant, time, decimal, integer, and
                # Quantity.
                StructField("maxValueInteger", IntegerType(), True),
                # The maximum allowed value for the element. The value is inclusive. This is
                # allowed for the types date, dateTime, instant, time, decimal, integer, and
                # Quantity.
                StructField("maxValuePositiveInt", IntegerType(), True),
                # The maximum allowed value for the element. The value is inclusive. This is
                # allowed for the types date, dateTime, instant, time, decimal, integer, and
                # Quantity.
                StructField("maxValueUnsignedInt", IntegerType(), True),
                # The maximum allowed value for the element. The value is inclusive. This is
                # allowed for the types date, dateTime, instant, time, decimal, integer, and
                # Quantity.
                StructField(
                    "maxValueQuantity",
                    QuantitySchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Indicates the maximum length in characters that is permitted to be present in
                # conformant instances and which is expected to be supported by conformant
                # consumers that support the element.
                StructField("maxLength", IntegerType(), True),
                # A reference to an invariant that may make additional statements about the
                # cardinality or value in the instance.
                # Formal constraints such as co-occurrence and other constraints that can be
                # computationally evaluated within the context of the instance.
                StructField(
                    "constraint",
                    ArrayType(
                        ElementDefinition_ConstraintSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                            extension_fields=extension_fields,
                            extension_depth=extension_depth,
                            max_extension_depth=max_extension_depth,
                        )
                    ),
                    True,
                ),
                # If true, implementations that produce or consume resources SHALL provide
                # "support" for the element in some meaningful way.  If false, the element may
                # be ignored and not supported.
                StructField("mustSupport", BooleanType(), True),
                # If true, the value of this element affects the interpretation of the element
                # or resource that contains it, and the value of the element cannot be ignored.
                # Typically, this is used for status, negation and qualification codes. The
                # effect of this is that the element cannot be ignored by systems: they SHALL
                # either recognize the element and process it, and/or a pre-determination has
                # been made that it is not relevant to their particular system.
                StructField("isModifier", BooleanType(), True),
                # Whether the element should be included if a client requests a search with the
                # parameter _summary=true.
                StructField("isSummary", BooleanType(), True),
                # Binds to a value set if this element is coded (code, Coding, CodeableConcept,
                # Quantity), or the data types (string, uri).
                StructField(
                    "binding",
                    ElementDefinition_BindingSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Identifies a concept from an external specification that roughly corresponds
                # to this element.
                StructField(
                    "mapping",
                    ArrayType(
                        ElementDefinition_MappingSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                            extension_fields=extension_fields,
                            extension_depth=extension_depth,
                            max_extension_depth=max_extension_depth,
                        )
                    ),
                    True,
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]

        return schema
