"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResourcePool = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/vsphere/r/resource_pool vsphere_resource_pool}
*/
class ResourcePool extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vsphere/r/resource_pool vsphere_resource_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ResourcePoolConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vsphere_resource_pool',
            terraformGeneratorMetadata: {
                providerName: 'vsphere',
                providerVersion: '2.2.0',
                providerVersionConstraint: '~> 2.2'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._cpuExpandable = config.cpuExpandable;
        this._cpuLimit = config.cpuLimit;
        this._cpuReservation = config.cpuReservation;
        this._cpuShareLevel = config.cpuShareLevel;
        this._cpuShares = config.cpuShares;
        this._customAttributes = config.customAttributes;
        this._id = config.id;
        this._memoryExpandable = config.memoryExpandable;
        this._memoryLimit = config.memoryLimit;
        this._memoryReservation = config.memoryReservation;
        this._memoryShareLevel = config.memoryShareLevel;
        this._memoryShares = config.memoryShares;
        this._name = config.name;
        this._parentResourcePoolId = config.parentResourcePoolId;
        this._scaleDescendantsShares = config.scaleDescendantsShares;
        this._tags = config.tags;
    }
    get cpuExpandable() {
        return this.getBooleanAttribute('cpu_expandable');
    }
    set cpuExpandable(value) {
        this._cpuExpandable = value;
    }
    resetCpuExpandable() {
        this._cpuExpandable = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuExpandableInput() {
        return this._cpuExpandable;
    }
    get cpuLimit() {
        return this.getNumberAttribute('cpu_limit');
    }
    set cpuLimit(value) {
        this._cpuLimit = value;
    }
    resetCpuLimit() {
        this._cpuLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuLimitInput() {
        return this._cpuLimit;
    }
    get cpuReservation() {
        return this.getNumberAttribute('cpu_reservation');
    }
    set cpuReservation(value) {
        this._cpuReservation = value;
    }
    resetCpuReservation() {
        this._cpuReservation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuReservationInput() {
        return this._cpuReservation;
    }
    get cpuShareLevel() {
        return this.getStringAttribute('cpu_share_level');
    }
    set cpuShareLevel(value) {
        this._cpuShareLevel = value;
    }
    resetCpuShareLevel() {
        this._cpuShareLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuShareLevelInput() {
        return this._cpuShareLevel;
    }
    get cpuShares() {
        return this.getNumberAttribute('cpu_shares');
    }
    set cpuShares(value) {
        this._cpuShares = value;
    }
    resetCpuShares() {
        this._cpuShares = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuSharesInput() {
        return this._cpuShares;
    }
    get customAttributes() {
        return this.getStringMapAttribute('custom_attributes');
    }
    set customAttributes(value) {
        this._customAttributes = value;
    }
    resetCustomAttributes() {
        this._customAttributes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get customAttributesInput() {
        return this._customAttributes;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get memoryExpandable() {
        return this.getBooleanAttribute('memory_expandable');
    }
    set memoryExpandable(value) {
        this._memoryExpandable = value;
    }
    resetMemoryExpandable() {
        this._memoryExpandable = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memoryExpandableInput() {
        return this._memoryExpandable;
    }
    get memoryLimit() {
        return this.getNumberAttribute('memory_limit');
    }
    set memoryLimit(value) {
        this._memoryLimit = value;
    }
    resetMemoryLimit() {
        this._memoryLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memoryLimitInput() {
        return this._memoryLimit;
    }
    get memoryReservation() {
        return this.getNumberAttribute('memory_reservation');
    }
    set memoryReservation(value) {
        this._memoryReservation = value;
    }
    resetMemoryReservation() {
        this._memoryReservation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memoryReservationInput() {
        return this._memoryReservation;
    }
    get memoryShareLevel() {
        return this.getStringAttribute('memory_share_level');
    }
    set memoryShareLevel(value) {
        this._memoryShareLevel = value;
    }
    resetMemoryShareLevel() {
        this._memoryShareLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memoryShareLevelInput() {
        return this._memoryShareLevel;
    }
    get memoryShares() {
        return this.getNumberAttribute('memory_shares');
    }
    set memoryShares(value) {
        this._memoryShares = value;
    }
    resetMemoryShares() {
        this._memoryShares = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memorySharesInput() {
        return this._memoryShares;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get parentResourcePoolId() {
        return this.getStringAttribute('parent_resource_pool_id');
    }
    set parentResourcePoolId(value) {
        this._parentResourcePoolId = value;
    }
    // Temporarily expose input value. Use with caution.
    get parentResourcePoolIdInput() {
        return this._parentResourcePoolId;
    }
    get scaleDescendantsShares() {
        return this.getStringAttribute('scale_descendants_shares');
    }
    set scaleDescendantsShares(value) {
        this._scaleDescendantsShares = value;
    }
    resetScaleDescendantsShares() {
        this._scaleDescendantsShares = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get scaleDescendantsSharesInput() {
        return this._scaleDescendantsShares;
    }
    get tags() {
        return cdktf.Fn.tolist(this.getListAttribute('tags'));
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            cpu_expandable: cdktf.booleanToTerraform(this._cpuExpandable),
            cpu_limit: cdktf.numberToTerraform(this._cpuLimit),
            cpu_reservation: cdktf.numberToTerraform(this._cpuReservation),
            cpu_share_level: cdktf.stringToTerraform(this._cpuShareLevel),
            cpu_shares: cdktf.numberToTerraform(this._cpuShares),
            custom_attributes: cdktf.hashMapper(cdktf.stringToTerraform)(this._customAttributes),
            id: cdktf.stringToTerraform(this._id),
            memory_expandable: cdktf.booleanToTerraform(this._memoryExpandable),
            memory_limit: cdktf.numberToTerraform(this._memoryLimit),
            memory_reservation: cdktf.numberToTerraform(this._memoryReservation),
            memory_share_level: cdktf.stringToTerraform(this._memoryShareLevel),
            memory_shares: cdktf.numberToTerraform(this._memoryShares),
            name: cdktf.stringToTerraform(this._name),
            parent_resource_pool_id: cdktf.stringToTerraform(this._parentResourcePoolId),
            scale_descendants_shares: cdktf.stringToTerraform(this._scaleDescendantsShares),
            tags: cdktf.listMapper(cdktf.stringToTerraform, false)(this._tags),
        };
    }
}
exports.ResourcePool = ResourcePool;
_a = JSII_RTTI_SYMBOL_1;
ResourcePool[_a] = { fqn: "@cdktf/provider-vsphere.resourcePool.ResourcePool", version: "0.0.1" };
// =================
// STATIC PROPERTIES
// =================
ResourcePool.tfResourceType = "vsphere_resource_pool";
//# sourceMappingURL=data:application/json;base64,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