"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HaVmOverride = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/vsphere/r/ha_vm_override vsphere_ha_vm_override}
*/
class HaVmOverride extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vsphere/r/ha_vm_override vsphere_ha_vm_override} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HaVmOverrideConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vsphere_ha_vm_override',
            terraformGeneratorMetadata: {
                providerName: 'vsphere',
                providerVersion: '2.2.0',
                providerVersionConstraint: '~> 2.2'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._computeClusterId = config.computeClusterId;
        this._haDatastoreApdRecoveryAction = config.haDatastoreApdRecoveryAction;
        this._haDatastoreApdResponse = config.haDatastoreApdResponse;
        this._haDatastoreApdResponseDelay = config.haDatastoreApdResponseDelay;
        this._haDatastorePdlResponse = config.haDatastorePdlResponse;
        this._haHostIsolationResponse = config.haHostIsolationResponse;
        this._haVmFailureInterval = config.haVmFailureInterval;
        this._haVmMaximumFailureWindow = config.haVmMaximumFailureWindow;
        this._haVmMaximumResets = config.haVmMaximumResets;
        this._haVmMinimumUptime = config.haVmMinimumUptime;
        this._haVmMonitoring = config.haVmMonitoring;
        this._haVmMonitoringUseClusterDefaults = config.haVmMonitoringUseClusterDefaults;
        this._haVmRestartPriority = config.haVmRestartPriority;
        this._haVmRestartTimeout = config.haVmRestartTimeout;
        this._id = config.id;
        this._virtualMachineId = config.virtualMachineId;
    }
    get computeClusterId() {
        return this.getStringAttribute('compute_cluster_id');
    }
    set computeClusterId(value) {
        this._computeClusterId = value;
    }
    // Temporarily expose input value. Use with caution.
    get computeClusterIdInput() {
        return this._computeClusterId;
    }
    get haDatastoreApdRecoveryAction() {
        return this.getStringAttribute('ha_datastore_apd_recovery_action');
    }
    set haDatastoreApdRecoveryAction(value) {
        this._haDatastoreApdRecoveryAction = value;
    }
    resetHaDatastoreApdRecoveryAction() {
        this._haDatastoreApdRecoveryAction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haDatastoreApdRecoveryActionInput() {
        return this._haDatastoreApdRecoveryAction;
    }
    get haDatastoreApdResponse() {
        return this.getStringAttribute('ha_datastore_apd_response');
    }
    set haDatastoreApdResponse(value) {
        this._haDatastoreApdResponse = value;
    }
    resetHaDatastoreApdResponse() {
        this._haDatastoreApdResponse = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haDatastoreApdResponseInput() {
        return this._haDatastoreApdResponse;
    }
    get haDatastoreApdResponseDelay() {
        return this.getNumberAttribute('ha_datastore_apd_response_delay');
    }
    set haDatastoreApdResponseDelay(value) {
        this._haDatastoreApdResponseDelay = value;
    }
    resetHaDatastoreApdResponseDelay() {
        this._haDatastoreApdResponseDelay = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haDatastoreApdResponseDelayInput() {
        return this._haDatastoreApdResponseDelay;
    }
    get haDatastorePdlResponse() {
        return this.getStringAttribute('ha_datastore_pdl_response');
    }
    set haDatastorePdlResponse(value) {
        this._haDatastorePdlResponse = value;
    }
    resetHaDatastorePdlResponse() {
        this._haDatastorePdlResponse = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haDatastorePdlResponseInput() {
        return this._haDatastorePdlResponse;
    }
    get haHostIsolationResponse() {
        return this.getStringAttribute('ha_host_isolation_response');
    }
    set haHostIsolationResponse(value) {
        this._haHostIsolationResponse = value;
    }
    resetHaHostIsolationResponse() {
        this._haHostIsolationResponse = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haHostIsolationResponseInput() {
        return this._haHostIsolationResponse;
    }
    get haVmFailureInterval() {
        return this.getNumberAttribute('ha_vm_failure_interval');
    }
    set haVmFailureInterval(value) {
        this._haVmFailureInterval = value;
    }
    resetHaVmFailureInterval() {
        this._haVmFailureInterval = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmFailureIntervalInput() {
        return this._haVmFailureInterval;
    }
    get haVmMaximumFailureWindow() {
        return this.getNumberAttribute('ha_vm_maximum_failure_window');
    }
    set haVmMaximumFailureWindow(value) {
        this._haVmMaximumFailureWindow = value;
    }
    resetHaVmMaximumFailureWindow() {
        this._haVmMaximumFailureWindow = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmMaximumFailureWindowInput() {
        return this._haVmMaximumFailureWindow;
    }
    get haVmMaximumResets() {
        return this.getNumberAttribute('ha_vm_maximum_resets');
    }
    set haVmMaximumResets(value) {
        this._haVmMaximumResets = value;
    }
    resetHaVmMaximumResets() {
        this._haVmMaximumResets = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmMaximumResetsInput() {
        return this._haVmMaximumResets;
    }
    get haVmMinimumUptime() {
        return this.getNumberAttribute('ha_vm_minimum_uptime');
    }
    set haVmMinimumUptime(value) {
        this._haVmMinimumUptime = value;
    }
    resetHaVmMinimumUptime() {
        this._haVmMinimumUptime = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmMinimumUptimeInput() {
        return this._haVmMinimumUptime;
    }
    get haVmMonitoring() {
        return this.getStringAttribute('ha_vm_monitoring');
    }
    set haVmMonitoring(value) {
        this._haVmMonitoring = value;
    }
    resetHaVmMonitoring() {
        this._haVmMonitoring = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmMonitoringInput() {
        return this._haVmMonitoring;
    }
    get haVmMonitoringUseClusterDefaults() {
        return this.getBooleanAttribute('ha_vm_monitoring_use_cluster_defaults');
    }
    set haVmMonitoringUseClusterDefaults(value) {
        this._haVmMonitoringUseClusterDefaults = value;
    }
    resetHaVmMonitoringUseClusterDefaults() {
        this._haVmMonitoringUseClusterDefaults = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmMonitoringUseClusterDefaultsInput() {
        return this._haVmMonitoringUseClusterDefaults;
    }
    get haVmRestartPriority() {
        return this.getStringAttribute('ha_vm_restart_priority');
    }
    set haVmRestartPriority(value) {
        this._haVmRestartPriority = value;
    }
    resetHaVmRestartPriority() {
        this._haVmRestartPriority = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmRestartPriorityInput() {
        return this._haVmRestartPriority;
    }
    get haVmRestartTimeout() {
        return this.getNumberAttribute('ha_vm_restart_timeout');
    }
    set haVmRestartTimeout(value) {
        this._haVmRestartTimeout = value;
    }
    resetHaVmRestartTimeout() {
        this._haVmRestartTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmRestartTimeoutInput() {
        return this._haVmRestartTimeout;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get virtualMachineId() {
        return this.getStringAttribute('virtual_machine_id');
    }
    set virtualMachineId(value) {
        this._virtualMachineId = value;
    }
    // Temporarily expose input value. Use with caution.
    get virtualMachineIdInput() {
        return this._virtualMachineId;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            compute_cluster_id: cdktf.stringToTerraform(this._computeClusterId),
            ha_datastore_apd_recovery_action: cdktf.stringToTerraform(this._haDatastoreApdRecoveryAction),
            ha_datastore_apd_response: cdktf.stringToTerraform(this._haDatastoreApdResponse),
            ha_datastore_apd_response_delay: cdktf.numberToTerraform(this._haDatastoreApdResponseDelay),
            ha_datastore_pdl_response: cdktf.stringToTerraform(this._haDatastorePdlResponse),
            ha_host_isolation_response: cdktf.stringToTerraform(this._haHostIsolationResponse),
            ha_vm_failure_interval: cdktf.numberToTerraform(this._haVmFailureInterval),
            ha_vm_maximum_failure_window: cdktf.numberToTerraform(this._haVmMaximumFailureWindow),
            ha_vm_maximum_resets: cdktf.numberToTerraform(this._haVmMaximumResets),
            ha_vm_minimum_uptime: cdktf.numberToTerraform(this._haVmMinimumUptime),
            ha_vm_monitoring: cdktf.stringToTerraform(this._haVmMonitoring),
            ha_vm_monitoring_use_cluster_defaults: cdktf.booleanToTerraform(this._haVmMonitoringUseClusterDefaults),
            ha_vm_restart_priority: cdktf.stringToTerraform(this._haVmRestartPriority),
            ha_vm_restart_timeout: cdktf.numberToTerraform(this._haVmRestartTimeout),
            id: cdktf.stringToTerraform(this._id),
            virtual_machine_id: cdktf.stringToTerraform(this._virtualMachineId),
        };
    }
}
exports.HaVmOverride = HaVmOverride;
_a = JSII_RTTI_SYMBOL_1;
HaVmOverride[_a] = { fqn: "@cdktf/provider-vsphere.haVmOverride.HaVmOverride", version: "0.0.1" };
// =================
// STATIC PROPERTIES
// =================
HaVmOverride.tfResourceType = "vsphere_ha_vm_override";
//# sourceMappingURL=data:application/json;base64,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