"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DistributedPortGroup = exports.DistributedPortGroupVlanRangeList = exports.DistributedPortGroupVlanRangeOutputReference = exports.distributedPortGroupVlanRangeToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function distributedPortGroupVlanRangeToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        max_vlan: cdktf.numberToTerraform(struct.maxVlan),
        min_vlan: cdktf.numberToTerraform(struct.minVlan),
    };
}
exports.distributedPortGroupVlanRangeToTerraform = distributedPortGroupVlanRangeToTerraform;
class DistributedPortGroupVlanRangeOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._maxVlan !== undefined) {
            hasAnyValues = true;
            internalValueResult.maxVlan = this._maxVlan;
        }
        if (this._minVlan !== undefined) {
            hasAnyValues = true;
            internalValueResult.minVlan = this._minVlan;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._maxVlan = undefined;
            this._minVlan = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._maxVlan = value.maxVlan;
            this._minVlan = value.minVlan;
        }
    }
    get maxVlan() {
        return this.getNumberAttribute('max_vlan');
    }
    set maxVlan(value) {
        this._maxVlan = value;
    }
    // Temporarily expose input value. Use with caution.
    get maxVlanInput() {
        return this._maxVlan;
    }
    get minVlan() {
        return this.getNumberAttribute('min_vlan');
    }
    set minVlan(value) {
        this._minVlan = value;
    }
    // Temporarily expose input value. Use with caution.
    get minVlanInput() {
        return this._minVlan;
    }
}
exports.DistributedPortGroupVlanRangeOutputReference = DistributedPortGroupVlanRangeOutputReference;
_a = JSII_RTTI_SYMBOL_1;
DistributedPortGroupVlanRangeOutputReference[_a] = { fqn: "@cdktf/provider-vsphere.distributedPortGroup.DistributedPortGroupVlanRangeOutputReference", version: "0.0.1" };
class DistributedPortGroupVlanRangeList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new DistributedPortGroupVlanRangeOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.DistributedPortGroupVlanRangeList = DistributedPortGroupVlanRangeList;
_b = JSII_RTTI_SYMBOL_1;
DistributedPortGroupVlanRangeList[_b] = { fqn: "@cdktf/provider-vsphere.distributedPortGroup.DistributedPortGroupVlanRangeList", version: "0.0.1" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group vsphere_distributed_port_group}
*/
class DistributedPortGroup extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vsphere/r/distributed_port_group vsphere_distributed_port_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DistributedPortGroupConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vsphere_distributed_port_group',
            terraformGeneratorMetadata: {
                providerName: 'vsphere',
                providerVersion: '2.2.0',
                providerVersionConstraint: '~> 2.2'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // vlan_range - computed: false, optional: true, required: false
        this._vlanRange = new DistributedPortGroupVlanRangeList(this, "vlan_range", true);
        this._activeUplinks = config.activeUplinks;
        this._allowForgedTransmits = config.allowForgedTransmits;
        this._allowMacChanges = config.allowMacChanges;
        this._allowPromiscuous = config.allowPromiscuous;
        this._autoExpand = config.autoExpand;
        this._blockAllPorts = config.blockAllPorts;
        this._blockOverrideAllowed = config.blockOverrideAllowed;
        this._checkBeacon = config.checkBeacon;
        this._customAttributes = config.customAttributes;
        this._description = config.description;
        this._directpathGen2Allowed = config.directpathGen2Allowed;
        this._distributedVirtualSwitchUuid = config.distributedVirtualSwitchUuid;
        this._egressShapingAverageBandwidth = config.egressShapingAverageBandwidth;
        this._egressShapingBurstSize = config.egressShapingBurstSize;
        this._egressShapingEnabled = config.egressShapingEnabled;
        this._egressShapingPeakBandwidth = config.egressShapingPeakBandwidth;
        this._failback = config.failback;
        this._id = config.id;
        this._ingressShapingAverageBandwidth = config.ingressShapingAverageBandwidth;
        this._ingressShapingBurstSize = config.ingressShapingBurstSize;
        this._ingressShapingEnabled = config.ingressShapingEnabled;
        this._ingressShapingPeakBandwidth = config.ingressShapingPeakBandwidth;
        this._lacpEnabled = config.lacpEnabled;
        this._lacpMode = config.lacpMode;
        this._livePortMovingAllowed = config.livePortMovingAllowed;
        this._name = config.name;
        this._netflowEnabled = config.netflowEnabled;
        this._netflowOverrideAllowed = config.netflowOverrideAllowed;
        this._networkResourcePoolKey = config.networkResourcePoolKey;
        this._networkResourcePoolOverrideAllowed = config.networkResourcePoolOverrideAllowed;
        this._notifySwitches = config.notifySwitches;
        this._numberOfPorts = config.numberOfPorts;
        this._portConfigResetAtDisconnect = config.portConfigResetAtDisconnect;
        this._portNameFormat = config.portNameFormat;
        this._portPrivateSecondaryVlanId = config.portPrivateSecondaryVlanId;
        this._securityPolicyOverrideAllowed = config.securityPolicyOverrideAllowed;
        this._shapingOverrideAllowed = config.shapingOverrideAllowed;
        this._standbyUplinks = config.standbyUplinks;
        this._tags = config.tags;
        this._teamingPolicy = config.teamingPolicy;
        this._trafficFilterOverrideAllowed = config.trafficFilterOverrideAllowed;
        this._txUplink = config.txUplink;
        this._type = config.type;
        this._uplinkTeamingOverrideAllowed = config.uplinkTeamingOverrideAllowed;
        this._vlanId = config.vlanId;
        this._vlanOverrideAllowed = config.vlanOverrideAllowed;
        this._vlanRange.internalValue = config.vlanRange;
    }
    get activeUplinks() {
        return this.getListAttribute('active_uplinks');
    }
    set activeUplinks(value) {
        this._activeUplinks = value;
    }
    resetActiveUplinks() {
        this._activeUplinks = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get activeUplinksInput() {
        return this._activeUplinks;
    }
    get allowForgedTransmits() {
        return this.getBooleanAttribute('allow_forged_transmits');
    }
    set allowForgedTransmits(value) {
        this._allowForgedTransmits = value;
    }
    resetAllowForgedTransmits() {
        this._allowForgedTransmits = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowForgedTransmitsInput() {
        return this._allowForgedTransmits;
    }
    get allowMacChanges() {
        return this.getBooleanAttribute('allow_mac_changes');
    }
    set allowMacChanges(value) {
        this._allowMacChanges = value;
    }
    resetAllowMacChanges() {
        this._allowMacChanges = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowMacChangesInput() {
        return this._allowMacChanges;
    }
    get allowPromiscuous() {
        return this.getBooleanAttribute('allow_promiscuous');
    }
    set allowPromiscuous(value) {
        this._allowPromiscuous = value;
    }
    resetAllowPromiscuous() {
        this._allowPromiscuous = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowPromiscuousInput() {
        return this._allowPromiscuous;
    }
    get autoExpand() {
        return this.getBooleanAttribute('auto_expand');
    }
    set autoExpand(value) {
        this._autoExpand = value;
    }
    resetAutoExpand() {
        this._autoExpand = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoExpandInput() {
        return this._autoExpand;
    }
    get blockAllPorts() {
        return this.getBooleanAttribute('block_all_ports');
    }
    set blockAllPorts(value) {
        this._blockAllPorts = value;
    }
    resetBlockAllPorts() {
        this._blockAllPorts = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get blockAllPortsInput() {
        return this._blockAllPorts;
    }
    get blockOverrideAllowed() {
        return this.getBooleanAttribute('block_override_allowed');
    }
    set blockOverrideAllowed(value) {
        this._blockOverrideAllowed = value;
    }
    resetBlockOverrideAllowed() {
        this._blockOverrideAllowed = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get blockOverrideAllowedInput() {
        return this._blockOverrideAllowed;
    }
    get checkBeacon() {
        return this.getBooleanAttribute('check_beacon');
    }
    set checkBeacon(value) {
        this._checkBeacon = value;
    }
    resetCheckBeacon() {
        this._checkBeacon = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get checkBeaconInput() {
        return this._checkBeacon;
    }
    // config_version - computed: true, optional: false, required: false
    get configVersion() {
        return this.getStringAttribute('config_version');
    }
    get customAttributes() {
        return this.getStringMapAttribute('custom_attributes');
    }
    set customAttributes(value) {
        this._customAttributes = value;
    }
    resetCustomAttributes() {
        this._customAttributes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get customAttributesInput() {
        return this._customAttributes;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    get directpathGen2Allowed() {
        return this.getBooleanAttribute('directpath_gen2_allowed');
    }
    set directpathGen2Allowed(value) {
        this._directpathGen2Allowed = value;
    }
    resetDirectpathGen2Allowed() {
        this._directpathGen2Allowed = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get directpathGen2AllowedInput() {
        return this._directpathGen2Allowed;
    }
    get distributedVirtualSwitchUuid() {
        return this.getStringAttribute('distributed_virtual_switch_uuid');
    }
    set distributedVirtualSwitchUuid(value) {
        this._distributedVirtualSwitchUuid = value;
    }
    // Temporarily expose input value. Use with caution.
    get distributedVirtualSwitchUuidInput() {
        return this._distributedVirtualSwitchUuid;
    }
    get egressShapingAverageBandwidth() {
        return this.getNumberAttribute('egress_shaping_average_bandwidth');
    }
    set egressShapingAverageBandwidth(value) {
        this._egressShapingAverageBandwidth = value;
    }
    resetEgressShapingAverageBandwidth() {
        this._egressShapingAverageBandwidth = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get egressShapingAverageBandwidthInput() {
        return this._egressShapingAverageBandwidth;
    }
    get egressShapingBurstSize() {
        return this.getNumberAttribute('egress_shaping_burst_size');
    }
    set egressShapingBurstSize(value) {
        this._egressShapingBurstSize = value;
    }
    resetEgressShapingBurstSize() {
        this._egressShapingBurstSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get egressShapingBurstSizeInput() {
        return this._egressShapingBurstSize;
    }
    get egressShapingEnabled() {
        return this.getBooleanAttribute('egress_shaping_enabled');
    }
    set egressShapingEnabled(value) {
        this._egressShapingEnabled = value;
    }
    resetEgressShapingEnabled() {
        this._egressShapingEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get egressShapingEnabledInput() {
        return this._egressShapingEnabled;
    }
    get egressShapingPeakBandwidth() {
        return this.getNumberAttribute('egress_shaping_peak_bandwidth');
    }
    set egressShapingPeakBandwidth(value) {
        this._egressShapingPeakBandwidth = value;
    }
    resetEgressShapingPeakBandwidth() {
        this._egressShapingPeakBandwidth = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get egressShapingPeakBandwidthInput() {
        return this._egressShapingPeakBandwidth;
    }
    get failback() {
        return this.getBooleanAttribute('failback');
    }
    set failback(value) {
        this._failback = value;
    }
    resetFailback() {
        this._failback = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get failbackInput() {
        return this._failback;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get ingressShapingAverageBandwidth() {
        return this.getNumberAttribute('ingress_shaping_average_bandwidth');
    }
    set ingressShapingAverageBandwidth(value) {
        this._ingressShapingAverageBandwidth = value;
    }
    resetIngressShapingAverageBandwidth() {
        this._ingressShapingAverageBandwidth = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ingressShapingAverageBandwidthInput() {
        return this._ingressShapingAverageBandwidth;
    }
    get ingressShapingBurstSize() {
        return this.getNumberAttribute('ingress_shaping_burst_size');
    }
    set ingressShapingBurstSize(value) {
        this._ingressShapingBurstSize = value;
    }
    resetIngressShapingBurstSize() {
        this._ingressShapingBurstSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ingressShapingBurstSizeInput() {
        return this._ingressShapingBurstSize;
    }
    get ingressShapingEnabled() {
        return this.getBooleanAttribute('ingress_shaping_enabled');
    }
    set ingressShapingEnabled(value) {
        this._ingressShapingEnabled = value;
    }
    resetIngressShapingEnabled() {
        this._ingressShapingEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ingressShapingEnabledInput() {
        return this._ingressShapingEnabled;
    }
    get ingressShapingPeakBandwidth() {
        return this.getNumberAttribute('ingress_shaping_peak_bandwidth');
    }
    set ingressShapingPeakBandwidth(value) {
        this._ingressShapingPeakBandwidth = value;
    }
    resetIngressShapingPeakBandwidth() {
        this._ingressShapingPeakBandwidth = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ingressShapingPeakBandwidthInput() {
        return this._ingressShapingPeakBandwidth;
    }
    // key - computed: true, optional: false, required: false
    get key() {
        return this.getStringAttribute('key');
    }
    get lacpEnabled() {
        return this.getBooleanAttribute('lacp_enabled');
    }
    set lacpEnabled(value) {
        this._lacpEnabled = value;
    }
    resetLacpEnabled() {
        this._lacpEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get lacpEnabledInput() {
        return this._lacpEnabled;
    }
    get lacpMode() {
        return this.getStringAttribute('lacp_mode');
    }
    set lacpMode(value) {
        this._lacpMode = value;
    }
    resetLacpMode() {
        this._lacpMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get lacpModeInput() {
        return this._lacpMode;
    }
    get livePortMovingAllowed() {
        return this.getBooleanAttribute('live_port_moving_allowed');
    }
    set livePortMovingAllowed(value) {
        this._livePortMovingAllowed = value;
    }
    resetLivePortMovingAllowed() {
        this._livePortMovingAllowed = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get livePortMovingAllowedInput() {
        return this._livePortMovingAllowed;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get netflowEnabled() {
        return this.getBooleanAttribute('netflow_enabled');
    }
    set netflowEnabled(value) {
        this._netflowEnabled = value;
    }
    resetNetflowEnabled() {
        this._netflowEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netflowEnabledInput() {
        return this._netflowEnabled;
    }
    get netflowOverrideAllowed() {
        return this.getBooleanAttribute('netflow_override_allowed');
    }
    set netflowOverrideAllowed(value) {
        this._netflowOverrideAllowed = value;
    }
    resetNetflowOverrideAllowed() {
        this._netflowOverrideAllowed = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netflowOverrideAllowedInput() {
        return this._netflowOverrideAllowed;
    }
    get networkResourcePoolKey() {
        return this.getStringAttribute('network_resource_pool_key');
    }
    set networkResourcePoolKey(value) {
        this._networkResourcePoolKey = value;
    }
    resetNetworkResourcePoolKey() {
        this._networkResourcePoolKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get networkResourcePoolKeyInput() {
        return this._networkResourcePoolKey;
    }
    get networkResourcePoolOverrideAllowed() {
        return this.getBooleanAttribute('network_resource_pool_override_allowed');
    }
    set networkResourcePoolOverrideAllowed(value) {
        this._networkResourcePoolOverrideAllowed = value;
    }
    resetNetworkResourcePoolOverrideAllowed() {
        this._networkResourcePoolOverrideAllowed = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get networkResourcePoolOverrideAllowedInput() {
        return this._networkResourcePoolOverrideAllowed;
    }
    get notifySwitches() {
        return this.getBooleanAttribute('notify_switches');
    }
    set notifySwitches(value) {
        this._notifySwitches = value;
    }
    resetNotifySwitches() {
        this._notifySwitches = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get notifySwitchesInput() {
        return this._notifySwitches;
    }
    get numberOfPorts() {
        return this.getNumberAttribute('number_of_ports');
    }
    set numberOfPorts(value) {
        this._numberOfPorts = value;
    }
    resetNumberOfPorts() {
        this._numberOfPorts = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get numberOfPortsInput() {
        return this._numberOfPorts;
    }
    get portConfigResetAtDisconnect() {
        return this.getBooleanAttribute('port_config_reset_at_disconnect');
    }
    set portConfigResetAtDisconnect(value) {
        this._portConfigResetAtDisconnect = value;
    }
    resetPortConfigResetAtDisconnect() {
        this._portConfigResetAtDisconnect = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get portConfigResetAtDisconnectInput() {
        return this._portConfigResetAtDisconnect;
    }
    get portNameFormat() {
        return this.getStringAttribute('port_name_format');
    }
    set portNameFormat(value) {
        this._portNameFormat = value;
    }
    resetPortNameFormat() {
        this._portNameFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get portNameFormatInput() {
        return this._portNameFormat;
    }
    get portPrivateSecondaryVlanId() {
        return this.getNumberAttribute('port_private_secondary_vlan_id');
    }
    set portPrivateSecondaryVlanId(value) {
        this._portPrivateSecondaryVlanId = value;
    }
    resetPortPrivateSecondaryVlanId() {
        this._portPrivateSecondaryVlanId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get portPrivateSecondaryVlanIdInput() {
        return this._portPrivateSecondaryVlanId;
    }
    get securityPolicyOverrideAllowed() {
        return this.getBooleanAttribute('security_policy_override_allowed');
    }
    set securityPolicyOverrideAllowed(value) {
        this._securityPolicyOverrideAllowed = value;
    }
    resetSecurityPolicyOverrideAllowed() {
        this._securityPolicyOverrideAllowed = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get securityPolicyOverrideAllowedInput() {
        return this._securityPolicyOverrideAllowed;
    }
    get shapingOverrideAllowed() {
        return this.getBooleanAttribute('shaping_override_allowed');
    }
    set shapingOverrideAllowed(value) {
        this._shapingOverrideAllowed = value;
    }
    resetShapingOverrideAllowed() {
        this._shapingOverrideAllowed = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get shapingOverrideAllowedInput() {
        return this._shapingOverrideAllowed;
    }
    get standbyUplinks() {
        return this.getListAttribute('standby_uplinks');
    }
    set standbyUplinks(value) {
        this._standbyUplinks = value;
    }
    resetStandbyUplinks() {
        this._standbyUplinks = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get standbyUplinksInput() {
        return this._standbyUplinks;
    }
    get tags() {
        return cdktf.Fn.tolist(this.getListAttribute('tags'));
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    get teamingPolicy() {
        return this.getStringAttribute('teaming_policy');
    }
    set teamingPolicy(value) {
        this._teamingPolicy = value;
    }
    resetTeamingPolicy() {
        this._teamingPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get teamingPolicyInput() {
        return this._teamingPolicy;
    }
    get trafficFilterOverrideAllowed() {
        return this.getBooleanAttribute('traffic_filter_override_allowed');
    }
    set trafficFilterOverrideAllowed(value) {
        this._trafficFilterOverrideAllowed = value;
    }
    resetTrafficFilterOverrideAllowed() {
        this._trafficFilterOverrideAllowed = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get trafficFilterOverrideAllowedInput() {
        return this._trafficFilterOverrideAllowed;
    }
    get txUplink() {
        return this.getBooleanAttribute('tx_uplink');
    }
    set txUplink(value) {
        this._txUplink = value;
    }
    resetTxUplink() {
        this._txUplink = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get txUplinkInput() {
        return this._txUplink;
    }
    get type() {
        return this.getStringAttribute('type');
    }
    set type(value) {
        this._type = value;
    }
    resetType() {
        this._type = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get typeInput() {
        return this._type;
    }
    get uplinkTeamingOverrideAllowed() {
        return this.getBooleanAttribute('uplink_teaming_override_allowed');
    }
    set uplinkTeamingOverrideAllowed(value) {
        this._uplinkTeamingOverrideAllowed = value;
    }
    resetUplinkTeamingOverrideAllowed() {
        this._uplinkTeamingOverrideAllowed = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get uplinkTeamingOverrideAllowedInput() {
        return this._uplinkTeamingOverrideAllowed;
    }
    get vlanId() {
        return this.getNumberAttribute('vlan_id');
    }
    set vlanId(value) {
        this._vlanId = value;
    }
    resetVlanId() {
        this._vlanId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vlanIdInput() {
        return this._vlanId;
    }
    get vlanOverrideAllowed() {
        return this.getBooleanAttribute('vlan_override_allowed');
    }
    set vlanOverrideAllowed(value) {
        this._vlanOverrideAllowed = value;
    }
    resetVlanOverrideAllowed() {
        this._vlanOverrideAllowed = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vlanOverrideAllowedInput() {
        return this._vlanOverrideAllowed;
    }
    get vlanRange() {
        return this._vlanRange;
    }
    putVlanRange(value) {
        this._vlanRange.internalValue = value;
    }
    resetVlanRange() {
        this._vlanRange.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vlanRangeInput() {
        return this._vlanRange.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            active_uplinks: cdktf.listMapper(cdktf.stringToTerraform, false)(this._activeUplinks),
            allow_forged_transmits: cdktf.booleanToTerraform(this._allowForgedTransmits),
            allow_mac_changes: cdktf.booleanToTerraform(this._allowMacChanges),
            allow_promiscuous: cdktf.booleanToTerraform(this._allowPromiscuous),
            auto_expand: cdktf.booleanToTerraform(this._autoExpand),
            block_all_ports: cdktf.booleanToTerraform(this._blockAllPorts),
            block_override_allowed: cdktf.booleanToTerraform(this._blockOverrideAllowed),
            check_beacon: cdktf.booleanToTerraform(this._checkBeacon),
            custom_attributes: cdktf.hashMapper(cdktf.stringToTerraform)(this._customAttributes),
            description: cdktf.stringToTerraform(this._description),
            directpath_gen2_allowed: cdktf.booleanToTerraform(this._directpathGen2Allowed),
            distributed_virtual_switch_uuid: cdktf.stringToTerraform(this._distributedVirtualSwitchUuid),
            egress_shaping_average_bandwidth: cdktf.numberToTerraform(this._egressShapingAverageBandwidth),
            egress_shaping_burst_size: cdktf.numberToTerraform(this._egressShapingBurstSize),
            egress_shaping_enabled: cdktf.booleanToTerraform(this._egressShapingEnabled),
            egress_shaping_peak_bandwidth: cdktf.numberToTerraform(this._egressShapingPeakBandwidth),
            failback: cdktf.booleanToTerraform(this._failback),
            id: cdktf.stringToTerraform(this._id),
            ingress_shaping_average_bandwidth: cdktf.numberToTerraform(this._ingressShapingAverageBandwidth),
            ingress_shaping_burst_size: cdktf.numberToTerraform(this._ingressShapingBurstSize),
            ingress_shaping_enabled: cdktf.booleanToTerraform(this._ingressShapingEnabled),
            ingress_shaping_peak_bandwidth: cdktf.numberToTerraform(this._ingressShapingPeakBandwidth),
            lacp_enabled: cdktf.booleanToTerraform(this._lacpEnabled),
            lacp_mode: cdktf.stringToTerraform(this._lacpMode),
            live_port_moving_allowed: cdktf.booleanToTerraform(this._livePortMovingAllowed),
            name: cdktf.stringToTerraform(this._name),
            netflow_enabled: cdktf.booleanToTerraform(this._netflowEnabled),
            netflow_override_allowed: cdktf.booleanToTerraform(this._netflowOverrideAllowed),
            network_resource_pool_key: cdktf.stringToTerraform(this._networkResourcePoolKey),
            network_resource_pool_override_allowed: cdktf.booleanToTerraform(this._networkResourcePoolOverrideAllowed),
            notify_switches: cdktf.booleanToTerraform(this._notifySwitches),
            number_of_ports: cdktf.numberToTerraform(this._numberOfPorts),
            port_config_reset_at_disconnect: cdktf.booleanToTerraform(this._portConfigResetAtDisconnect),
            port_name_format: cdktf.stringToTerraform(this._portNameFormat),
            port_private_secondary_vlan_id: cdktf.numberToTerraform(this._portPrivateSecondaryVlanId),
            security_policy_override_allowed: cdktf.booleanToTerraform(this._securityPolicyOverrideAllowed),
            shaping_override_allowed: cdktf.booleanToTerraform(this._shapingOverrideAllowed),
            standby_uplinks: cdktf.listMapper(cdktf.stringToTerraform, false)(this._standbyUplinks),
            tags: cdktf.listMapper(cdktf.stringToTerraform, false)(this._tags),
            teaming_policy: cdktf.stringToTerraform(this._teamingPolicy),
            traffic_filter_override_allowed: cdktf.booleanToTerraform(this._trafficFilterOverrideAllowed),
            tx_uplink: cdktf.booleanToTerraform(this._txUplink),
            type: cdktf.stringToTerraform(this._type),
            uplink_teaming_override_allowed: cdktf.booleanToTerraform(this._uplinkTeamingOverrideAllowed),
            vlan_id: cdktf.numberToTerraform(this._vlanId),
            vlan_override_allowed: cdktf.booleanToTerraform(this._vlanOverrideAllowed),
            vlan_range: cdktf.listMapper(distributedPortGroupVlanRangeToTerraform, true)(this._vlanRange.internalValue),
        };
    }
}
exports.DistributedPortGroup = DistributedPortGroup;
_c = JSII_RTTI_SYMBOL_1;
DistributedPortGroup[_c] = { fqn: "@cdktf/provider-vsphere.distributedPortGroup.DistributedPortGroup", version: "0.0.1" };
// =================
// STATIC PROPERTIES
// =================
DistributedPortGroup.tfResourceType = "vsphere_distributed_port_group";
//# sourceMappingURL=data:application/json;base64,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