import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVsphereVirtualMachineConfig extends cdktf.TerraformMetaArguments {
    /**
    * The guest name for the operating system when guest_id is otherGuest or otherGuest64.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#alternate_guest_name DataVsphereVirtualMachine#alternate_guest_name}
    */
    readonly alternateGuestName?: string;
    /**
    * User-provided description of the virtual machine.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#annotation DataVsphereVirtualMachine#annotation}
    */
    readonly annotation?: string;
    /**
    * The number of milliseconds to wait before starting the boot sequence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#boot_delay DataVsphereVirtualMachine#boot_delay}
    */
    readonly bootDelay?: number;
    /**
    * The number of milliseconds to wait before retrying the boot sequence. This only valid if boot_retry_enabled is true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#boot_retry_delay DataVsphereVirtualMachine#boot_retry_delay}
    */
    readonly bootRetryDelay?: number;
    /**
    * If set to true, a virtual machine that fails to boot will try again after the delay defined in boot_retry_delay.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#boot_retry_enabled DataVsphereVirtualMachine#boot_retry_enabled}
    */
    readonly bootRetryEnabled?: boolean | cdktf.IResolvable;
    /**
    * Allow CPUs to be added to this virtual machine while it is running.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#cpu_hot_add_enabled DataVsphereVirtualMachine#cpu_hot_add_enabled}
    */
    readonly cpuHotAddEnabled?: boolean | cdktf.IResolvable;
    /**
    * Allow CPUs to be added to this virtual machine while it is running.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#cpu_hot_remove_enabled DataVsphereVirtualMachine#cpu_hot_remove_enabled}
    */
    readonly cpuHotRemoveEnabled?: boolean | cdktf.IResolvable;
    /**
    * The maximum amount of memory (in MB) or CPU (in MHz) that this virtual machine can consume, regardless of available resources.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#cpu_limit DataVsphereVirtualMachine#cpu_limit}
    */
    readonly cpuLimit?: number;
    /**
    * Enable CPU performance counters on this virtual machine.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#cpu_performance_counters_enabled DataVsphereVirtualMachine#cpu_performance_counters_enabled}
    */
    readonly cpuPerformanceCountersEnabled?: boolean | cdktf.IResolvable;
    /**
    * The amount of memory (in MB) or CPU (in MHz) that this virtual machine is guaranteed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#cpu_reservation DataVsphereVirtualMachine#cpu_reservation}
    */
    readonly cpuReservation?: number;
    /**
    * The amount of shares to allocate to cpu for a custom share level.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#cpu_share_count DataVsphereVirtualMachine#cpu_share_count}
    */
    readonly cpuShareCount?: number;
    /**
    * The allocation level for cpu resources. Can be one of high, low, normal, or custom.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#cpu_share_level DataVsphereVirtualMachine#cpu_share_level}
    */
    readonly cpuShareLevel?: string;
    /**
    * The managed object ID of the datacenter the virtual machine is in. This is not required when using ESXi directly, or if there is only one datacenter in your infrastructure.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#datacenter_id DataVsphereVirtualMachine#datacenter_id}
    */
    readonly datacenterId?: string;
    /**
    * When the boot type set in firmware is efi, this enables EFI secure boot.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#efi_secure_boot_enabled DataVsphereVirtualMachine#efi_secure_boot_enabled}
    */
    readonly efiSecureBootEnabled?: boolean | cdktf.IResolvable;
    /**
    * Expose the UUIDs of attached virtual disks to the virtual machine, allowing access to them in the guest.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#enable_disk_uuid DataVsphereVirtualMachine#enable_disk_uuid}
    */
    readonly enableDiskUuid?: boolean | cdktf.IResolvable;
    /**
    * Enable logging on this virtual machine.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#enable_logging DataVsphereVirtualMachine#enable_logging}
    */
    readonly enableLogging?: boolean | cdktf.IResolvable;
    /**
    * The EPT/RVI (hardware memory virtualization) setting for this virtual machine. Can be one of automatic, on, or off.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#ept_rvi_mode DataVsphereVirtualMachine#ept_rvi_mode}
    */
    readonly eptRviMode?: string;
    /**
    * Extra configuration data for this virtual machine. Can be used to supply advanced parameters not normally in configuration, such as instance metadata, or configuration data for OVF images.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#extra_config DataVsphereVirtualMachine#extra_config}
    */
    readonly extraConfig?: {
        [key: string]: string;
    };
    /**
    * The firmware interface to use on the virtual machine. Can be one of bios or efi.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#firmware DataVsphereVirtualMachine#firmware}
    */
    readonly firmware?: string;
    /**
    * The guest ID for the operating system.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#guest_id DataVsphereVirtualMachine#guest_id}
    */
    readonly guestId?: string;
    /**
    * The hardware version for the virtual machine.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#hardware_version DataVsphereVirtualMachine#hardware_version}
    */
    readonly hardwareVersion?: number;
    /**
    * The (non-nested) hardware virtualization setting for this virtual machine. Can be one of hvAuto, hvOn, or hvOff.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#hv_mode DataVsphereVirtualMachine#hv_mode}
    */
    readonly hvMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#id DataVsphereVirtualMachine#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The number of IDE controllers to scan for disk sizes and controller types on.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#ide_controller_scan_count DataVsphereVirtualMachine#ide_controller_scan_count}
    */
    readonly ideControllerScanCount?: number;
    /**
    * Controls the scheduling delay of the virtual machine. Use a higher sensitivity for applications that require lower latency, such as VOIP, media player applications, or applications that require frequent access to mouse or keyboard devices. Can be one of low, normal, medium, or high.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#latency_sensitivity DataVsphereVirtualMachine#latency_sensitivity}
    */
    readonly latencySensitivity?: string;
    /**
    * The size of the virtual machine's memory, in MB.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#memory DataVsphereVirtualMachine#memory}
    */
    readonly memory?: number;
    /**
    * Allow memory to be added to this virtual machine while it is running.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#memory_hot_add_enabled DataVsphereVirtualMachine#memory_hot_add_enabled}
    */
    readonly memoryHotAddEnabled?: boolean | cdktf.IResolvable;
    /**
    * The maximum amount of memory (in MB) or CPU (in MHz) that this virtual machine can consume, regardless of available resources.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#memory_limit DataVsphereVirtualMachine#memory_limit}
    */
    readonly memoryLimit?: number;
    /**
    * The amount of memory (in MB) or CPU (in MHz) that this virtual machine is guaranteed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#memory_reservation DataVsphereVirtualMachine#memory_reservation}
    */
    readonly memoryReservation?: number;
    /**
    * The amount of shares to allocate to memory for a custom share level.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#memory_share_count DataVsphereVirtualMachine#memory_share_count}
    */
    readonly memoryShareCount?: number;
    /**
    * The allocation level for memory resources. Can be one of high, low, normal, or custom.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#memory_share_level DataVsphereVirtualMachine#memory_share_level}
    */
    readonly memoryShareLevel?: string;
    /**
    * The name of this virtual machine.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#name DataVsphereVirtualMachine#name}
    */
    readonly name?: string;
    /**
    * Enable nested hardware virtualization on this virtual machine, facilitating nested virtualization in the guest.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#nested_hv_enabled DataVsphereVirtualMachine#nested_hv_enabled}
    */
    readonly nestedHvEnabled?: boolean | cdktf.IResolvable;
    /**
    * The number of cores to distribute amongst the CPUs in this virtual machine. If specified, the value supplied to num_cpus must be evenly divisible by this value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#num_cores_per_socket DataVsphereVirtualMachine#num_cores_per_socket}
    */
    readonly numCoresPerSocket?: number;
    /**
    * The number of virtual processors to assign to this virtual machine.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#num_cpus DataVsphereVirtualMachine#num_cpus}
    */
    readonly numCpus?: number;
    /**
    * Triggers replacement of resource whenever it changes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#replace_trigger DataVsphereVirtualMachine#replace_trigger}
    */
    readonly replaceTrigger?: string;
    /**
    * Enable the run of scripts after virtual machine power-on when VMware Tools is installed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#run_tools_scripts_after_power_on DataVsphereVirtualMachine#run_tools_scripts_after_power_on}
    */
    readonly runToolsScriptsAfterPowerOn?: boolean | cdktf.IResolvable;
    /**
    * Enable the run of scripts after virtual machine resume when when VMware Tools is installed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#run_tools_scripts_after_resume DataVsphereVirtualMachine#run_tools_scripts_after_resume}
    */
    readonly runToolsScriptsAfterResume?: boolean | cdktf.IResolvable;
    /**
    * Enable the run of scripts before guest operating system reboot when VMware Tools is installed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#run_tools_scripts_before_guest_reboot DataVsphereVirtualMachine#run_tools_scripts_before_guest_reboot}
    */
    readonly runToolsScriptsBeforeGuestReboot?: boolean | cdktf.IResolvable;
    /**
    * Enable the run of scripts before guest operating system shutdown when VMware Tools is installed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#run_tools_scripts_before_guest_shutdown DataVsphereVirtualMachine#run_tools_scripts_before_guest_shutdown}
    */
    readonly runToolsScriptsBeforeGuestShutdown?: boolean | cdktf.IResolvable;
    /**
    * Enable the run of scripts before guest operating system standby when VMware Tools is installed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#run_tools_scripts_before_guest_standby DataVsphereVirtualMachine#run_tools_scripts_before_guest_standby}
    */
    readonly runToolsScriptsBeforeGuestStandby?: boolean | cdktf.IResolvable;
    /**
    * The number of SATA controllers to scan for disk sizes and controller types on.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#sata_controller_scan_count DataVsphereVirtualMachine#sata_controller_scan_count}
    */
    readonly sataControllerScanCount?: number;
    /**
    * The number of SCSI controllers to scan for disk sizes and controller types on.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#scsi_controller_scan_count DataVsphereVirtualMachine#scsi_controller_scan_count}
    */
    readonly scsiControllerScanCount?: number;
    /**
    * The ID of the storage policy to assign to the virtual machine home directory.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#storage_policy_id DataVsphereVirtualMachine#storage_policy_id}
    */
    readonly storagePolicyId?: string;
    /**
    * The swap file placement policy for this virtual machine. Can be one of inherit, hostLocal, or vmDirectory.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#swap_placement_policy DataVsphereVirtualMachine#swap_placement_policy}
    */
    readonly swapPlacementPolicy?: string;
    /**
    * Enable guest clock synchronization with the host. On vSphere 7.0 U1 and above, with only this setting the clock is synchronized on startup and resume. Requires VMware Tools to be installed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#sync_time_with_host DataVsphereVirtualMachine#sync_time_with_host}
    */
    readonly syncTimeWithHost?: boolean | cdktf.IResolvable;
    /**
    * Enable periodic clock synchronization with the host. Supported only on vSphere 7.0 U1 and above. On prior versions setting `sync_time_with_host` is enough for periodic synchronization. Requires VMware Tools to be installed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#sync_time_with_host_periodically DataVsphereVirtualMachine#sync_time_with_host_periodically}
    */
    readonly syncTimeWithHostPeriodically?: boolean | cdktf.IResolvable;
    /**
    * Set the upgrade policy for VMware Tools. Can be one of `manual` or `upgradeAtPowerCycle`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#tools_upgrade_policy DataVsphereVirtualMachine#tools_upgrade_policy}
    */
    readonly toolsUpgradePolicy?: string;
    /**
    * The UUID of the virtual machine. Also exposed as the ID of the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#uuid DataVsphereVirtualMachine#uuid}
    */
    readonly uuid?: string;
    /**
    * Flag to specify if Virtualization-based security is enabled for this virtual machine.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#vbs_enabled DataVsphereVirtualMachine#vbs_enabled}
    */
    readonly vbsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Flag to specify if I/O MMU virtualization, also called Intel Virtualization Technology for Directed I/O (VT-d) and AMD I/O Virtualization (AMD-Vi or IOMMU), is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#vvtd_enabled DataVsphereVirtualMachine#vvtd_enabled}
    */
    readonly vvtdEnabled?: boolean | cdktf.IResolvable;
    /**
    * vapp block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#vapp DataVsphereVirtualMachine#vapp}
    */
    readonly vapp?: DataVsphereVirtualMachineVapp;
}
export interface DataVsphereVirtualMachineDisks {
}
export declare function dataVsphereVirtualMachineDisksToTerraform(struct?: DataVsphereVirtualMachineDisks): any;
export declare class DataVsphereVirtualMachineDisksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataVsphereVirtualMachineDisks | undefined;
    set internalValue(value: DataVsphereVirtualMachineDisks | undefined);
    get eagerlyScrub(): cdktf.IResolvable;
    get label(): string;
    get size(): number;
    get thinProvisioned(): cdktf.IResolvable;
    get unitNumber(): number;
}
export declare class DataVsphereVirtualMachineDisksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataVsphereVirtualMachineDisksOutputReference;
}
export interface DataVsphereVirtualMachineNetworkInterfaces {
}
export declare function dataVsphereVirtualMachineNetworkInterfacesToTerraform(struct?: DataVsphereVirtualMachineNetworkInterfaces): any;
export declare class DataVsphereVirtualMachineNetworkInterfacesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataVsphereVirtualMachineNetworkInterfaces | undefined;
    set internalValue(value: DataVsphereVirtualMachineNetworkInterfaces | undefined);
    get adapterType(): string;
    get bandwidthLimit(): number;
    get bandwidthReservation(): number;
    get bandwidthShareCount(): number;
    get bandwidthShareLevel(): string;
    get macAddress(): string;
    get networkId(): string;
}
export declare class DataVsphereVirtualMachineNetworkInterfacesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataVsphereVirtualMachineNetworkInterfacesOutputReference;
}
export interface DataVsphereVirtualMachineVapp {
    /**
    * A map of customizable vApp properties and their values. Allows customization of VMs cloned from OVF templates which have customizable vApp properties.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine#properties DataVsphereVirtualMachine#properties}
    */
    readonly properties?: {
        [key: string]: string;
    };
}
export declare function dataVsphereVirtualMachineVappToTerraform(struct?: DataVsphereVirtualMachineVappOutputReference | DataVsphereVirtualMachineVapp): any;
export declare class DataVsphereVirtualMachineVappOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataVsphereVirtualMachineVapp | undefined;
    set internalValue(value: DataVsphereVirtualMachineVapp | undefined);
    private _properties?;
    get properties(): {
        [key: string]: string;
    };
    set properties(value: {
        [key: string]: string;
    });
    resetProperties(): void;
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine vsphere_virtual_machine}
*/
export declare class DataVsphereVirtualMachine extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vsphere_virtual_machine";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine vsphere_virtual_machine} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVsphereVirtualMachineConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataVsphereVirtualMachineConfig);
    private _alternateGuestName?;
    get alternateGuestName(): string;
    set alternateGuestName(value: string);
    resetAlternateGuestName(): void;
    get alternateGuestNameInput(): string | undefined;
    private _annotation?;
    get annotation(): string;
    set annotation(value: string);
    resetAnnotation(): void;
    get annotationInput(): string | undefined;
    private _bootDelay?;
    get bootDelay(): number;
    set bootDelay(value: number);
    resetBootDelay(): void;
    get bootDelayInput(): number | undefined;
    private _bootRetryDelay?;
    get bootRetryDelay(): number;
    set bootRetryDelay(value: number);
    resetBootRetryDelay(): void;
    get bootRetryDelayInput(): number | undefined;
    private _bootRetryEnabled?;
    get bootRetryEnabled(): boolean | cdktf.IResolvable;
    set bootRetryEnabled(value: boolean | cdktf.IResolvable);
    resetBootRetryEnabled(): void;
    get bootRetryEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get changeVersion(): string;
    private _cpuHotAddEnabled?;
    get cpuHotAddEnabled(): boolean | cdktf.IResolvable;
    set cpuHotAddEnabled(value: boolean | cdktf.IResolvable);
    resetCpuHotAddEnabled(): void;
    get cpuHotAddEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _cpuHotRemoveEnabled?;
    get cpuHotRemoveEnabled(): boolean | cdktf.IResolvable;
    set cpuHotRemoveEnabled(value: boolean | cdktf.IResolvable);
    resetCpuHotRemoveEnabled(): void;
    get cpuHotRemoveEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _cpuLimit?;
    get cpuLimit(): number;
    set cpuLimit(value: number);
    resetCpuLimit(): void;
    get cpuLimitInput(): number | undefined;
    private _cpuPerformanceCountersEnabled?;
    get cpuPerformanceCountersEnabled(): boolean | cdktf.IResolvable;
    set cpuPerformanceCountersEnabled(value: boolean | cdktf.IResolvable);
    resetCpuPerformanceCountersEnabled(): void;
    get cpuPerformanceCountersEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _cpuReservation?;
    get cpuReservation(): number;
    set cpuReservation(value: number);
    resetCpuReservation(): void;
    get cpuReservationInput(): number | undefined;
    private _cpuShareCount?;
    get cpuShareCount(): number;
    set cpuShareCount(value: number);
    resetCpuShareCount(): void;
    get cpuShareCountInput(): number | undefined;
    private _cpuShareLevel?;
    get cpuShareLevel(): string;
    set cpuShareLevel(value: string);
    resetCpuShareLevel(): void;
    get cpuShareLevelInput(): string | undefined;
    private _datacenterId?;
    get datacenterId(): string;
    set datacenterId(value: string);
    resetDatacenterId(): void;
    get datacenterIdInput(): string | undefined;
    get defaultIpAddress(): string;
    private _disks;
    get disks(): DataVsphereVirtualMachineDisksList;
    private _efiSecureBootEnabled?;
    get efiSecureBootEnabled(): boolean | cdktf.IResolvable;
    set efiSecureBootEnabled(value: boolean | cdktf.IResolvable);
    resetEfiSecureBootEnabled(): void;
    get efiSecureBootEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _enableDiskUuid?;
    get enableDiskUuid(): boolean | cdktf.IResolvable;
    set enableDiskUuid(value: boolean | cdktf.IResolvable);
    resetEnableDiskUuid(): void;
    get enableDiskUuidInput(): boolean | cdktf.IResolvable | undefined;
    private _enableLogging?;
    get enableLogging(): boolean | cdktf.IResolvable;
    set enableLogging(value: boolean | cdktf.IResolvable);
    resetEnableLogging(): void;
    get enableLoggingInput(): boolean | cdktf.IResolvable | undefined;
    private _eptRviMode?;
    get eptRviMode(): string;
    set eptRviMode(value: string);
    resetEptRviMode(): void;
    get eptRviModeInput(): string | undefined;
    private _extraConfig?;
    get extraConfig(): {
        [key: string]: string;
    };
    set extraConfig(value: {
        [key: string]: string;
    });
    resetExtraConfig(): void;
    get extraConfigInput(): {
        [key: string]: string;
    } | undefined;
    private _firmware?;
    get firmware(): string;
    set firmware(value: string);
    resetFirmware(): void;
    get firmwareInput(): string | undefined;
    private _guestId?;
    get guestId(): string;
    set guestId(value: string);
    resetGuestId(): void;
    get guestIdInput(): string | undefined;
    get guestIpAddresses(): string[];
    private _hardwareVersion?;
    get hardwareVersion(): number;
    set hardwareVersion(value: number);
    resetHardwareVersion(): void;
    get hardwareVersionInput(): number | undefined;
    private _hvMode?;
    get hvMode(): string;
    set hvMode(value: string);
    resetHvMode(): void;
    get hvModeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ideControllerScanCount?;
    get ideControllerScanCount(): number;
    set ideControllerScanCount(value: number);
    resetIdeControllerScanCount(): void;
    get ideControllerScanCountInput(): number | undefined;
    private _latencySensitivity?;
    get latencySensitivity(): string;
    set latencySensitivity(value: string);
    resetLatencySensitivity(): void;
    get latencySensitivityInput(): string | undefined;
    private _memory?;
    get memory(): number;
    set memory(value: number);
    resetMemory(): void;
    get memoryInput(): number | undefined;
    private _memoryHotAddEnabled?;
    get memoryHotAddEnabled(): boolean | cdktf.IResolvable;
    set memoryHotAddEnabled(value: boolean | cdktf.IResolvable);
    resetMemoryHotAddEnabled(): void;
    get memoryHotAddEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _memoryLimit?;
    get memoryLimit(): number;
    set memoryLimit(value: number);
    resetMemoryLimit(): void;
    get memoryLimitInput(): number | undefined;
    private _memoryReservation?;
    get memoryReservation(): number;
    set memoryReservation(value: number);
    resetMemoryReservation(): void;
    get memoryReservationInput(): number | undefined;
    private _memoryShareCount?;
    get memoryShareCount(): number;
    set memoryShareCount(value: number);
    resetMemoryShareCount(): void;
    get memoryShareCountInput(): number | undefined;
    private _memoryShareLevel?;
    get memoryShareLevel(): string;
    set memoryShareLevel(value: string);
    resetMemoryShareLevel(): void;
    get memoryShareLevelInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _nestedHvEnabled?;
    get nestedHvEnabled(): boolean | cdktf.IResolvable;
    set nestedHvEnabled(value: boolean | cdktf.IResolvable);
    resetNestedHvEnabled(): void;
    get nestedHvEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get networkInterfaceTypes(): string[];
    private _networkInterfaces;
    get networkInterfaces(): DataVsphereVirtualMachineNetworkInterfacesList;
    private _numCoresPerSocket?;
    get numCoresPerSocket(): number;
    set numCoresPerSocket(value: number);
    resetNumCoresPerSocket(): void;
    get numCoresPerSocketInput(): number | undefined;
    private _numCpus?;
    get numCpus(): number;
    set numCpus(value: number);
    resetNumCpus(): void;
    get numCpusInput(): number | undefined;
    private _replaceTrigger?;
    get replaceTrigger(): string;
    set replaceTrigger(value: string);
    resetReplaceTrigger(): void;
    get replaceTriggerInput(): string | undefined;
    private _runToolsScriptsAfterPowerOn?;
    get runToolsScriptsAfterPowerOn(): boolean | cdktf.IResolvable;
    set runToolsScriptsAfterPowerOn(value: boolean | cdktf.IResolvable);
    resetRunToolsScriptsAfterPowerOn(): void;
    get runToolsScriptsAfterPowerOnInput(): boolean | cdktf.IResolvable | undefined;
    private _runToolsScriptsAfterResume?;
    get runToolsScriptsAfterResume(): boolean | cdktf.IResolvable;
    set runToolsScriptsAfterResume(value: boolean | cdktf.IResolvable);
    resetRunToolsScriptsAfterResume(): void;
    get runToolsScriptsAfterResumeInput(): boolean | cdktf.IResolvable | undefined;
    private _runToolsScriptsBeforeGuestReboot?;
    get runToolsScriptsBeforeGuestReboot(): boolean | cdktf.IResolvable;
    set runToolsScriptsBeforeGuestReboot(value: boolean | cdktf.IResolvable);
    resetRunToolsScriptsBeforeGuestReboot(): void;
    get runToolsScriptsBeforeGuestRebootInput(): boolean | cdktf.IResolvable | undefined;
    private _runToolsScriptsBeforeGuestShutdown?;
    get runToolsScriptsBeforeGuestShutdown(): boolean | cdktf.IResolvable;
    set runToolsScriptsBeforeGuestShutdown(value: boolean | cdktf.IResolvable);
    resetRunToolsScriptsBeforeGuestShutdown(): void;
    get runToolsScriptsBeforeGuestShutdownInput(): boolean | cdktf.IResolvable | undefined;
    private _runToolsScriptsBeforeGuestStandby?;
    get runToolsScriptsBeforeGuestStandby(): boolean | cdktf.IResolvable;
    set runToolsScriptsBeforeGuestStandby(value: boolean | cdktf.IResolvable);
    resetRunToolsScriptsBeforeGuestStandby(): void;
    get runToolsScriptsBeforeGuestStandbyInput(): boolean | cdktf.IResolvable | undefined;
    private _sataControllerScanCount?;
    get sataControllerScanCount(): number;
    set sataControllerScanCount(value: number);
    resetSataControllerScanCount(): void;
    get sataControllerScanCountInput(): number | undefined;
    get scsiBusSharing(): string;
    private _scsiControllerScanCount?;
    get scsiControllerScanCount(): number;
    set scsiControllerScanCount(value: number);
    resetScsiControllerScanCount(): void;
    get scsiControllerScanCountInput(): number | undefined;
    get scsiType(): string;
    private _storagePolicyId?;
    get storagePolicyId(): string;
    set storagePolicyId(value: string);
    resetStoragePolicyId(): void;
    get storagePolicyIdInput(): string | undefined;
    private _swapPlacementPolicy?;
    get swapPlacementPolicy(): string;
    set swapPlacementPolicy(value: string);
    resetSwapPlacementPolicy(): void;
    get swapPlacementPolicyInput(): string | undefined;
    private _syncTimeWithHost?;
    get syncTimeWithHost(): boolean | cdktf.IResolvable;
    set syncTimeWithHost(value: boolean | cdktf.IResolvable);
    resetSyncTimeWithHost(): void;
    get syncTimeWithHostInput(): boolean | cdktf.IResolvable | undefined;
    private _syncTimeWithHostPeriodically?;
    get syncTimeWithHostPeriodically(): boolean | cdktf.IResolvable;
    set syncTimeWithHostPeriodically(value: boolean | cdktf.IResolvable);
    resetSyncTimeWithHostPeriodically(): void;
    get syncTimeWithHostPeriodicallyInput(): boolean | cdktf.IResolvable | undefined;
    private _toolsUpgradePolicy?;
    get toolsUpgradePolicy(): string;
    set toolsUpgradePolicy(value: string);
    resetToolsUpgradePolicy(): void;
    get toolsUpgradePolicyInput(): string | undefined;
    private _uuid?;
    get uuid(): string;
    set uuid(value: string);
    resetUuid(): void;
    get uuidInput(): string | undefined;
    get vappTransport(): string[];
    private _vbsEnabled?;
    get vbsEnabled(): boolean | cdktf.IResolvable;
    set vbsEnabled(value: boolean | cdktf.IResolvable);
    resetVbsEnabled(): void;
    get vbsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _vvtdEnabled?;
    get vvtdEnabled(): boolean | cdktf.IResolvable;
    set vvtdEnabled(value: boolean | cdktf.IResolvable);
    resetVvtdEnabled(): void;
    get vvtdEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _vapp;
    get vapp(): DataVsphereVirtualMachineVappOutputReference;
    putVapp(value: DataVsphereVirtualMachineVapp): void;
    resetVapp(): void;
    get vappInput(): DataVsphereVirtualMachineVapp | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
