import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVsphereTagConfig extends cdktf.TerraformMetaArguments {
    /**
    * The unique identifier of the parent category for this tag.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/tag#category_id DataVsphereTag#category_id}
    */
    readonly categoryId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/tag#id DataVsphereTag#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The display name of the tag.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/tag#name DataVsphereTag#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vsphere/d/tag vsphere_tag}
*/
export declare class DataVsphereTag extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vsphere_tag";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vsphere/d/tag vsphere_tag} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVsphereTagConfig
    */
    constructor(scope: Construct, id: string, config: DataVsphereTagConfig);
    private _categoryId?;
    get categoryId(): string;
    set categoryId(value: string);
    get categoryIdInput(): string | undefined;
    get description(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
