import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVsphereLicenseConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/license#license_key DataVsphereLicense#license_key}
    */
    readonly licenseKey: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vsphere/d/license vsphere_license}
*/
export declare class DataVsphereLicense extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vsphere_license";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vsphere/d/license vsphere_license} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVsphereLicenseConfig
    */
    constructor(scope: Construct, id: string, config: DataVsphereLicenseConfig);
    get editionKey(): string;
    get id(): string;
    private _labels;
    get labels(): cdktf.StringMap;
    private _licenseKey?;
    get licenseKey(): string;
    set licenseKey(value: string);
    get licenseKeyInput(): string | undefined;
    get name(): string;
    get total(): number;
    get used(): number;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
