import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVsphereDatastoreConfig extends cdktf.TerraformMetaArguments {
    /**
    * The managed object ID of the datacenter the datastore is in. This is not required when using ESXi directly, or if there is only one datacenter in your infrastructure.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/datastore#datacenter_id DataVsphereDatastore#datacenter_id}
    */
    readonly datacenterId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/datastore#id DataVsphereDatastore#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name or path of the datastore.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/datastore#name DataVsphereDatastore#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vsphere/d/datastore vsphere_datastore}
*/
export declare class DataVsphereDatastore extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vsphere_datastore";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vsphere/d/datastore vsphere_datastore} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVsphereDatastoreConfig
    */
    constructor(scope: Construct, id: string, config: DataVsphereDatastoreConfig);
    private _datacenterId?;
    get datacenterId(): string;
    set datacenterId(value: string);
    resetDatacenterId(): void;
    get datacenterIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
