import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVsphereCustomAttributeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/custom_attribute#id DataVsphereCustomAttribute#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The display name of the custom attribute.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/custom_attribute#name DataVsphereCustomAttribute#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vsphere/d/custom_attribute vsphere_custom_attribute}
*/
export declare class DataVsphereCustomAttribute extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vsphere_custom_attribute";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vsphere/d/custom_attribute vsphere_custom_attribute} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVsphereCustomAttributeConfig
    */
    constructor(scope: Construct, id: string, config: DataVsphereCustomAttributeConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get managedObjectType(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
