import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVsphereComputeClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * The managed object ID of the datacenter the cluster is located in. Not required if using an absolute path.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/compute_cluster#datacenter_id DataVsphereComputeCluster#datacenter_id}
    */
    readonly datacenterId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/compute_cluster#id DataVsphereComputeCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name or absolute path to the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/compute_cluster#name DataVsphereComputeCluster#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vsphere/d/compute_cluster vsphere_compute_cluster}
*/
export declare class DataVsphereComputeCluster extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vsphere_compute_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vsphere/d/compute_cluster vsphere_compute_cluster} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVsphereComputeClusterConfig
    */
    constructor(scope: Construct, id: string, config: DataVsphereComputeClusterConfig);
    private _datacenterId?;
    get datacenterId(): string;
    set datacenterId(value: string);
    resetDatacenterId(): void;
    get datacenterIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get resourcePoolId(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
