"""Utilities for testing."""
from numpy.testing import assert_allclose, assert_equal


def assert_rrdict_equal(actual, desired, level=0):
    if actual == desired:
        return

    actual_keys = set(actual.keys())
    desired_keys = set(desired.keys())

    actual_extra = actual_keys - desired_keys
    assert not actual_extra, f"Extra actual keys level {level}: {actual_extra}"

    desired_extra = desired_keys - actual_keys
    assert not desired_extra, f"Extra desired keys level {level}: {desired_extra}"

    for key in actual_keys:
        if level == 0:
            assert_rrdict_equal(actual[key], desired[key], level=1)
        else:
            assert_allclose(actual[key], desired[key])


def assert_rr_equal(actual, desired):
    assert_allclose(actual.count, desired.count)
    assert_equal(actual.elected, desired.elected)
    assert_equal(actual.eliminated, desired.eliminated)
    assert_rrdict_equal(actual.transfers, desired.transfers)
