#!/usr/bin/env python3
"""Remove emojis from textual_config_menu.py - precise version"""

# Define specific replacements for text strings only (not affecting code structure)
replacements = [
    ('🐧 Penguin Tamer', 'Penguin Tamer'),
    ('🤖 Выбор LLM', 'Выбор LLM'),
    ('⚙️ Управление LLM', 'Управление LLM'),
    ('🎛️ Параметры', 'Параметры'),
    ('📝 Контент', 'Контент'),
    ('🔧 Система', 'Система'),
    ('🌐 Язык/Тема', 'Язык/Тема'),
    ('ℹ️ Инфо', 'Инфо'),
    ('✅ Выбрать', 'Выбрать'),
    ('➕ Добавить', 'Добавить'),
    ('✏️ Изменить', 'Изменить'),
    ('🗑️ Удалить', 'Удалить'),
    ('🔄 Обновить', 'Обновить'),
    ('💾 Сохранить', 'Сохранить'),
    ('🌡️ Температура', 'Температура'),
    ('📏 Максимум токенов', 'Максимум токенов'),
    ('🎯 Top P', 'Top P'),
    ('🔄 Штраф частоты', 'Штраф частоты'),
    ('👁️ Штраф присутствия', 'Штраф присутствия'),
    ('🎲 Seed', 'Seed'),
    ('⏱️ Задержка стрима', 'Задержка стрима'),
    ('🔄 Частота обновлений', 'Частота обновлений'),
    ('🐛 Режим отладки', 'Режим отладки'),
    ('🇺🇸 English', 'English'),
    ('🇷🇺 Русский', 'Русский'),
    ('🎨 Тема', 'Тема'),
    ('✅ Меню загружено', 'Меню загружено'),
    ('📊 Загружено', 'Загружено'),
    ('✅ Выбрана:', 'Выбрана:'),
    ('⚠️ Выберите', 'Выберите'),
    ('✅ Добавлена:', 'Добавлена:'),
    ('✅ Обновлена:', 'Обновлена:'),
    ('❌ Нельзя удалить текущую', 'Нельзя удалить текущую'),
    ('✅ Удалена:', 'Удалена:'),
    ('✅ Температура:', 'Температура:'),
    ('❌ Должно быть', 'Должно быть'),
    ('❌ Неверный формат', 'Неверный формат'),
    ('✅ Max tokens:', 'Max tokens:'),
    ('✅ Top P:', 'Top P:'),
    ('✅ Freq penalty:', 'Freq penalty:'),
    ('✅ Pres penalty:', 'Pres penalty:'),
    ('✅ Seed:', 'Seed:'),
    ('✅ Контент сохранён', 'Контент сохранён'),
    ('✅ Контент сброшен', 'Контент сброшен'),
    ('✅ Задержка:', 'Задержка:'),
    ('✅ Частота:', 'Частота:'),
    ('✅ Language:', 'Language:'),
    ('✅ Язык:', 'Язык:'),
    ('✅ Тема:', 'Тема:'),
    ('✅ Информация обновлена', 'Информация обновлена'),
    ('✅ Режим отладки', 'Режим отладки'),
    ('🤖 Текущая LLM', 'Текущая LLM'),
    ('⚙️  Температура', 'Температура'),
    ('🤖 ВЫБОР ТЕКУЩЕЙ LLM', 'ВЫБОР ТЕКУЩЕЙ LLM'),
    ('⚙️ УПРАВЛЕНИЕ LLM', 'УПРАВЛЕНИЕ LLM'),
    ('📊 ТЕКУЩАЯ КОНФИГУРАЦИЯ', 'ТЕКУЩАЯ КОНФИГУРАЦИЯ'),
    ('📝 Контент:', 'Контент:'),
    ('🌐 Язык:', 'Язык:'),
    ('❌ Ошибка:', 'Ошибка:'),
    ('👁️  Штраф присутствия', 'Штраф присутствия'),
    # Additional patterns found
    ('🐛 Отладка:', 'Отладка:'),
    ('✏️ Редактировать', 'Редактировать'),
    ('📝 ПОЛЬЗОВАТЕЛЬСКИЙ КОНТЕНТ', 'ПОЛЬЗОВАТЕЛЬСКИЙ КОНТЕНТ'),
    ('🔄 Сбросить', 'Сбросить'),
    ('🔧 СИСТЕМНЫЕ НАСТРОЙКИ', 'СИСТЕМНЫЕ НАСТРОЙКИ'),
    ('🌐 ЯЗЫК И ТЕМА', 'ЯЗЫК И ТЕМА'),
    ('🔄 Загрузка данных...', 'Загрузка данных...'),
    ('✅ Приложение загружено', 'Приложение загружено'),
    ('✅ Селектор обновлён:', 'Селектор обновлён:'),
    ('✅ Управление обновлено:', 'Управление обновлено:'),
    ('✅ Список обновлён', 'Список обновлён'),
    ('✅ Текущая LLM:', 'Текущая LLM:'),
    ('✅ LLM', 'LLM'),
    ('✅ Максимум токенов:', 'Максимум токенов:'),
    ('✅ Штраф частоты:', 'Штраф частоты:'),
    ('✅ Штраф присутствия:', 'Штраф присутствия:'),
    ('✅ Задержка стрима:', 'Задержка стрима:'),
    ('✅ Частота обновлений:', 'Частота обновлений:'),
]

with open('src/penguin_tamer/textual_config_menu.py', 'r', encoding='utf-8') as f:
    content = f.read()

count = 0
for old, new in replacements:
    if old in content:
        content = content.replace(old, new)
        count += 1

with open('src/penguin_tamer/textual_config_menu.py', 'w', encoding='utf-8') as f:
    f.write(content)

print(f'✓ Successfully replaced {count} emoji patterns!')
