# 🎛️ Руководство по параметрам LLM

Полное описание параметров генерации для настройки поведения языковых моделей в Penguin Tamer.

## 📋 Содержание

- [Основные параметры](#основные-параметры)
- [Продвинутые параметры](#продвинутые-параметры)
- [Примеры конфигураций](#примеры-конфигураций)
- [Рекомендации по использованию](#рекомендации-по-использованию)

---

## Основные параметры

### 🌡️ Temperature (Температура)

**Диапазон:** 0.0 - 2.0  
**Значение по умолчанию:** 0.8

Контролирует случайность и креативность ответов.

- **0.0-0.3**: Детерминированные, точные ответы
  - Идеально для: технических задач, извлечения информации, перевода
  - Пример: `temperature: 0.2`

- **0.4-0.7**: Сбалансированные ответы
  - Идеально для: общего использования, Q&A, поиск решений
  - Пример: `temperature: 0.5`

- **0.8-1.5**: Креативные, разнообразные ответы
  - Идеально для: brainstorming, генерация идей, creative writing
  - Пример: `temperature: 1.0`

- **1.6-2.0**: Очень креативные, иногда непредсказуемые
  - Осторожно: может генерировать несвязный текст
  - Пример: `temperature: 1.8`

```yaml
global:
  temperature: 0.8  # Рекомендуется для системного администрирования
```

### 📏 Max Tokens (Максимум токенов)

**Диапазон:** 1 - модельный лимит (обычно 4000-128000)  
**Значение по умолчанию:** `null` (без ограничений)

Ограничивает длину ответа модели.

- **Что такое токен?** Примерно 0.75 слова или 4 символа
- **100 токенов** ≈ 75 слов ≈ 1-2 параграфа
- **500 токенов** ≈ 375 слов ≈ 1 страница
- **2000 токенов** ≈ 1500 слов ≈ 3-4 страницы

```yaml
global:
  max_tokens: 2000  # Ограничить ответ ~1500 словами
```

**Когда использовать:**
- ✅ Ограничение длинных ответов
- ✅ Контроль стоимости API
- ✅ Быстрые короткие ответы

**Когда НЕ использовать:**
- ❌ Если нужны подробные объяснения
- ❌ Генерация длинного кода
- ❌ Сложные multi-step задачи

### 🎯 Top P (Nucleus Sampling)

**Диапазон:** 0.0 - 1.0  
**Значение по умолчанию:** 0.95

Альтернативный способ контроля случайности (вместо temperature).

- **0.1**: Очень ограниченный выбор (самые вероятные токены)
- **0.5**: Средний выбор
- **0.9**: Широкий выбор (рекомендуется)
- **0.95-1.0**: Почти все возможные токены

```yaml
global:
  top_p: 0.95  # Стандартное значение
```

**💡 Совет:** Рекомендуется менять **либо** `temperature`, **либо** `top_p`, но не оба одновременно.

---

## Продвинутые параметры

### 🔁 Frequency Penalty (Штраф за частоту)

**Диапазон:** -2.0 до 2.0  
**Значение по умолчанию:** 0.0

Уменьшает вероятность повторения одних и тех же токенов.

- **0.0**: Без штрафа (по умолчанию)
- **0.3-0.5**: Лёгкое уменьшение повторов (рекомендуется)
- **1.0-2.0**: Сильное избегание повторов
- **Отрицательные**: Стимулируют повторы (редко используется)

```yaml
global:
  frequency_penalty: 0.3  # Уменьшить повторяющиеся фразы
```

**Когда использовать:**
- ✅ Модель повторяет одни и те же команды
- ✅ Нужно больше разнообразия в ответах
- ✅ Избавление от "зацикливания"

### 💭 Presence Penalty (Штраф за присутствие)

**Диапазон:** -2.0 до 2.0  
**Значение по умолчанию:** 0.0

Увеличивает вероятность обсуждения новых тем.

- **0.0**: Без штрафа
- **0.3-0.6**: Умеренное поощрение новых тем
- **1.0-2.0**: Сильное стимулирование новизны

```yaml
global:
  presence_penalty: 0.2  # Больше разнообразия тем
```

**Разница с frequency_penalty:**
- `frequency_penalty`: наказывает за **частоту** повторения
- `presence_penalty`: наказывает за сам **факт** упоминания

### 🛑 Stop Sequences (Стоп-последовательности)

**Тип:** список строк или `null`  
**Значение по умолчанию:** `null`

Останавливает генерацию при встрече указанной последовательности.

```yaml
global:
  stop: ["\n\n\n", "Human:", "AI:", "---"]
```

**Примеры использования:**

1. **Диалоги:**
   ```yaml
   stop: ["Human:", "User:", "Assistant:"]
   ```

2. **Форматирование:**
   ```yaml
   stop: ["\n\n\n"]  # Остановка после 3 переносов
   ```

3. **Маркеры:**
   ```yaml
   stop: ["END", "STOP", "###"]
   ```

### 🌱 Seed (Детерминизм)

**Тип:** целое число или `null`  
**Значение по умолчанию:** `null` (случайно)

Обеспечивает воспроизводимость результатов.

```yaml
global:
  seed: 42  # Фиксированный результат
```

**Когда использовать:**
- ✅ Тестирование
- ✅ Отладка промптов
- ✅ Демонстрации
- ✅ A/B тестирование

**⚠️ Важно:** 
- Работает не во всех моделях
- Гарантирует одинаковый результат только при идентичных входных данных
- `null` = каждый раз новый результат

---

## Примеры конфигураций

### 🤖 Конфигурация для системного администрирования (по умолчанию)

```yaml
global:
  temperature: 0.8
  max_tokens: null
  top_p: 0.95
  frequency_penalty: 0.0
  presence_penalty: 0.0
  stop: null
  seed: null
```

**Характеристики:** Сбалансированный подход с умеренной креативностью

### 🎯 Точные технические ответы

```yaml
global:
  temperature: 0.2
  max_tokens: 2000
  top_p: 0.9
  frequency_penalty: 0.1
  presence_penalty: 0.0
  stop: null
  seed: null
```

**Применение:** Извлечение информации, техническая документация, команды терминала

### 💡 Креативный brainstorming

```yaml
global:
  temperature: 1.2
  max_tokens: null
  top_p: 0.98
  frequency_penalty: 0.5
  presence_penalty: 0.6
  stop: null
  seed: null
```

**Применение:** Генерация идей, альтернативные решения, нестандартные подходы

### 📝 Краткие ответы

```yaml
global:
  temperature: 0.5
  max_tokens: 500
  top_p: 0.9
  frequency_penalty: 0.2
  presence_penalty: 0.1
  stop: ["\n\n\n"]
  seed: null
```

**Применение:** Быстрые Q&A, короткие объяснения

### 🧪 Тестирование и отладка

```yaml
global:
  temperature: 0.7
  max_tokens: 1000
  top_p: 0.95
  frequency_penalty: 0.0
  presence_penalty: 0.0
  stop: null
  seed: 42  # Фиксированный результат
```

**Применение:** Воспроизводимые тесты, отладка промптов

---

## Рекомендации по использованию

### ✅ Best Practices

1. **Начните с defaults** и постепенно настраивайте
2. **Меняйте один параметр за раз** для понимания влияния
3. **Используйте `debug_mode: true`** для анализа запросов
4. **Документируйте** свои конфигурации

### 🎛️ Комбинации параметров

| Сценарий | Temperature | Max Tokens | Frequency Penalty | Presence Penalty |
|----------|-------------|------------|-------------------|------------------|
| Точные команды | 0.2 | 500 | 0.1 | 0.0 |
| Общее использование | 0.7 | null | 0.0 | 0.0 |
| Креативные решения | 1.0 | null | 0.5 | 0.6 |
| Короткие ответы | 0.5 | 300 | 0.2 | 0.1 |

### 🔍 Отладка параметров

Включите debug mode для просмотра всех параметров:

```bash
export PT_DEBUG=1
pt "ваш запрос"
```

Или в конфиге:
```yaml
global:
  debug_mode: true
```

### 📊 Мониторинг влияния

Экспериментируйте с параметрами и наблюдайте:

1. **Качество ответов**: Точность и релевантность
2. **Разнообразие**: Повторяемость фраз
3. **Длина**: Соответствие ожиданиям
4. **Креативность**: Новизна решений

---

## 🔗 Связанные ресурсы

- [Debug Guide](DEBUG_GUIDE.md) - Отладка LLM запросов
- [OpenAI API Parameters](https://platform.openai.com/docs/api-reference/chat/create) - Официальная документация

## 💡 Дополнительная помощь

Если вы не уверены, какие параметры использовать:

1. Оставьте **defaults** для начала
2. Включите **debug mode** для анализа
3. Постепенно настраивайте по необходимости
4. Создайте несколько профилей для разных задач

---

**Совет:** Сохраните несколько конфигураций для разных сценариев использования!
