# Textual Config Menu для Penguin Tamer

## 📋 Описание

Два варианта конфигурационного меню на базе Textual TUI framework:

### 1. **textual_config_menu.py** - Полное меню
Полнофункциональное меню со всеми настройками:
- 6 вкладок с настройками
- Управление LLM (добавление, редактирование, удаление)
- Все параметры генерации
- Многострочный редактор контента
- Системные настройки
- Выбор языка и темы
- Живой статус в правой панели

### 2. **textual_simple_menu.py** - Упрощённое меню
Минималистичная версия с основными функциями:
- 3 вкладки (LLM, Параметры, Информация)
- Выбор текущей LLM
- Базовые параметры (температура, max tokens, top_p)
- Простой интерфейс

## 🚀 Запуск

### Полное меню:
```bash
# Через модуль
python -m src.penguin_tamer.textual_config_menu

# Напрямую
python src/penguin_tamer/textual_config_menu.py
```

### Упрощённое меню:
```bash
python src/penguin_tamer/textual_simple_menu.py
```

## ⌨️ Управление

- **Tab** - переключение между вкладками
- **↑/↓** - навигация по таблицам и элементам
- **Enter** - выбор элемента / активация кнопки
- **Q** или **Ctrl+C** - выход
- **F1** - помощь (только в полной версии)
- **Ctrl+R** - обновить статус (только в полной версии)

## 📦 Зависимости

```bash
pip install textual>=0.47.0
```

## 🎯 Функции полного меню

### Вкладка 1: Выбор LLM
- Таблица со всеми доступными LLM
- Текущая выбранная LLM выделена ✓
- Кнопки: "Выбрать", "Обновить"

### Вкладка 2: Управление LLM
- Таблица с деталями LLM (название, модель, API URL)
- Кнопки: "Добавить", "Редактировать", "Удалить"
- Модальные диалоги для ввода данных

### Вкладка 3: Параметры генерации
- Temperature (0.0-2.0)
- Max Tokens (null или число)
- Top P (0.0-1.0)
- Frequency Penalty (-2.0 до 2.0)
- Presence Penalty (-2.0 до 2.0)
- Seed (null или число)

Каждый параметр:
- Показывает текущее значение
- Имеет описание назначения
- Поле ввода + кнопка "Установить"
- Валидация значений

### Вкладка 4: Пользовательский контент
- Многострочный редактор (TextArea)
- Поддержка markdown подсветки
- Кнопки: "Сохранить", "Сбросить"

### Вкладка 5: Системные настройки
- Задержка стрима (0.001-0.1 сек)
- Частота обновлений (1-60 Гц)
- Режим отладки (Switch вкл/выкл)

### Вкладка 6: Язык и тема
- Выбор языка: English / Русский
- Выбор темы: Классический, Monokai, Dracula, Nord
- Изменения после перезапуска

### Правая панель: Статус
- Живой предпросмотр всех настроек
- Текущая LLM с деталями
- Все параметры генерации
- Краткое описание каждого параметра
- Превью пользовательского контента

## 🐛 Решение проблем

### Пустые вкладки
Если вкладки пустые:
1. Проверьте версию Textual: `pip show textual`
2. Обновите: `pip install --upgrade textual`
3. Используйте упрощённую версию: `textual_simple_menu.py`

### Ошибка импорта модуля
Если `ModuleNotFoundError: No module named 'penguin_tamer'`:
1. Запускайте через модуль: `python -m src.penguin_tamer.textual_config_menu`
2. Или убедитесь, что в файле есть код добавления пути (уже исправлено)

### Таблицы не отображаются
1. Проверьте, что есть данные: `python -c "from penguin_tamer.config_manager import config; print(config.get_available_llms())"`
2. Проверьте уведомления в приложении (они покажут количество строк)

## 📝 Примечания

- Все изменения сохраняются автоматически
- Валидация ввода с понятными сообщениями об ошибках
- Уведомления о всех действиях
- Подробные описания всех параметров

## 🔍 Отладка

Для диагностики используйте debug-уведомления:
- При запуске показывается количество найденных LLM
- При обновлении таблиц показывается количество строк
- Все ошибки выводятся в уведомлениях

## ✅ Проверка работы

### Тест упрощённого меню:
```bash
python src/penguin_tamer/textual_simple_menu.py
```

Должны видеть:
- 3 вкладки сверху
- В первой вкладке - таблицу с LLM
- Уведомление "Загружено N LLM"

### Тест полного меню:
```bash
python src/penguin_tamer/textual_config_menu.py
```

Должны видеть:
- 6 вкладок слева
- Панель статуса справа
- Несколько уведомлений при загрузке

## 🎨 Кастомизация CSS

Для изменения внешнего вида редактируйте блок `CSS = """..."""` в файле:
- Цвета через переменные ($primary, $success, etc.)
- Отступы через margin/padding (только целые числа)
- Размеры через width/height
- Границы через border

## 📞 Поддержка

При проблемах:
1. Проверьте версию Python >= 3.9
2. Проверьте версию Textual >= 0.47.0
3. Используйте упрощённую версию для диагностики
4. Проверьте логи в консоли
