# Горизонтальная компоновка параметров

## Дата: 6 октября 2025 г.

## Проблема

На вкладках "Параметры" и "Система" параметры занимали много вертикального пространства из-за вертикальной компоновки:
- Название параметра (сверху)
- Описание с текущим значением (посередине)
- Поле ввода или переключатель (снизу)

Результат: **3-4 строки на каждый параметр**, не все параметры влезали на экран.

## Решение

Изменена компоновка на **горизонтальную** (название слева, управляющий элемент справа):
- Название + краткое описание слева (40% ширины)
- Input/Switch справа (60% ширины)

Результат: **2 строки на каждый параметр** → экономия 33-50% высоты.

## Выполненные изменения

### 1. ✅ Добавлены CSS классы для горизонтальной компоновки

**Новые стили:**
```css
.setting-row {
    height: auto;
    align: left middle;
}

.param-label {
    width: 40%;
    color: $text;
    text-style: bold;
    padding-right: 2;
}

.param-control {
    width: 60%;
}

.param-control Input {
    width: 100%;
    margin: 0;
}

.param-control Switch {
    width: auto;
}
```

**Ключевые особенности:**
- `.setting-row` - контейнер для Horizontal layout
- `.param-label` - 40% ширины, название + описание в 2 строки
- `.param-control` - 60% ширины, управляющий элемент
- `align: left middle` - вертикальное выравнивание по центру

### 2. ✅ Изменена структура вкладки "Параметры"

**Было (вертикальная компоновка):**
```python
with Container(classes="setting-group"):
    yield Static("Температура", classes="param-label")
    yield Static(
        f"Текущее: [green]{config.temperature}[/green] • Контролирует креативность (0.0-2.0)",
        classes="param-description",
    )
    yield Input(value=str(config.temperature), id="temp-input", placeholder="0.0-2.0")
```

**Стало (горизонтальная компоновка):**
```python
with Horizontal(classes="setting-row"):
    yield Static(
        "Температура\n[dim]Креативность (0.0-2.0)[/dim]",
        classes="param-label"
    )
    yield Input(
        value=str(config.temperature), 
        id="temp-input",
        placeholder="0.0-2.0",
        classes="param-control"
    )
```

**Изменено 6 параметров:**
1. ✅ Температура
2. ✅ Максимум токенов
3. ✅ Top P
4. ✅ Штраф частоты
5. ✅ Штраф присутствия
6. ✅ Seed

### 3. ✅ Изменена структура вкладки "Система"

**Было (вертикальная компоновка):**
```python
with Container(classes="setting-group"):
    yield Static("Задержка стрима", classes="param-label")
    yield Static(
        f"Текущее: [green]{stream_delay} сек[/green] • Пауза между частями текста (0.001-0.1)",
        classes="param-description",
    )
    yield Input(value=str(stream_delay), id="stream-delay-input", placeholder="0.001-0.1")
```

**Стало (горизонтальная компоновка):**
```python
with Horizontal(classes="setting-row"):
    yield Static(
        "Задержка стрима\n[dim]Пауза между частями (0.001-0.1)[/dim]",
        classes="param-label"
    )
    yield Input(
        value=str(stream_delay), 
        id="stream-delay-input",
        placeholder="0.001-0.1",
        classes="param-control"
    )
```

**Изменено 3 параметра:**
1. ✅ Задержка стрима
2. ✅ Частота обновлений
3. ✅ Режим отладки (с Switch)

### 4. ✅ Упрощены описания параметров

**Было:**
- "Текущее: [green]0.8[/green] • Контролирует креативность (0.0-2.0)"
- 1 длинная строка с текущим значением + описание

**Стало:**
- "Температура\n[dim]Креативность (0.0-2.0)[/dim]"
- 2 строки: жирное название + тусклое описание

**Преимущества:**
- ❌ Убрано отображение "Текущее" (значение видно в Input)
- 📐 Компактнее - описание без избыточной информации
- 👁️ Читаемее - жирный заголовок + dim описание

## Результаты

### Экономия высоты на вкладке "Параметры" (6 параметров):

| Параметр | Было (строк) | Стало (строк) | Экономия |
|----------|-------------|---------------|----------|
| Температура | 4 | 2 | 2 строки |
| Максимум токенов | 4 | 2 | 2 строки |
| Top P | 4 | 2 | 2 строки |
| Штраф частоты | 4 | 2 | 2 строки |
| Штраф присутствия | 4 | 2 | 2 строки |
| Seed | 4 | 2 | 2 строки |
| **ИТОГО** | **24** | **12** | **12 строк (50%)** |

### Экономия высоты на вкладке "Система" (3 параметра):

| Параметр | Было (строк) | Стало (строк) | Экономия |
|----------|-------------|---------------|----------|
| Задержка стрима | 4 | 2 | 2 строки |
| Частота обновлений | 4 | 2 | 2 строки |
| Режим отладки | 5 | 2 | 3 строки |
| **ИТОГО** | **13** | **6** | **7 строк (54%)** |

### Общая экономия:

- **Вкладка "Параметры":** 24 → 12 строк (**-50%**)
- **Вкладка "Система":** 13 → 6 строк (**-54%**)
- **Обе вкладки:** 37 → 18 строк (**-51%**)

## Визуальное сравнение

### ДО (вертикальная компоновка):

```
Температура
Текущее: 0.8 • Контролирует креативность (0.0-2.0)
▊▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▎
▊ 0.8                                        ▎

Максимум токенов
Текущее: неограниченно • Ограничивает длину ответа
▊▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▎
▊ неограниченно                              ▎
```

### ПОСЛЕ (горизонтальная компоновка):

```
Температура                     ▊▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▎
Креативность (0.0-2.0)          ▊ 0.8                  ▎

Максимум токенов                ▊▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▔▎
Длина ответа                    ▊ неограниченно        ▎
```

## Технические детали

### Структура HTML (новая):

```
Horizontal (classes="setting-row")
├── Static (classes="param-label")           [40% ширины]
│   └── "Название\n[dim]Описание[/dim]"
└── Input/Switch (classes="param-control")   [60% ширины]
    └── значение
```

### CSS позиционирование:

- **Horizontal:** `height: auto`, `align: left middle`
- **param-label:** `width: 40%`, `padding-right: 2`
- **param-control:** `width: 60%`
- **Input внутри param-control:** `width: 100%`, `margin: 0`
- **Switch внутри param-control:** `width: auto`

### Файлы изменены:
- `src/penguin_tamer/textual_config_menu.py`
  - CSS блок: добавлены `.setting-row`, `.param-control`
  - Вкладка "Параметры": 6 параметров переделаны
  - Вкладка "Система": 3 параметра переделаны

## Преимущества

### 1. Компактность
- ✅ **50% экономии высоты** - все параметры влезают без прокрутки
- ✅ Больше параметров видно одновременно
- ✅ Меньше скроллинга

### 2. Удобство использования
- ✅ Название и управляющий элемент рядом - легче ассоциировать
- ✅ Меньше движений глазами (горизонталь вместо вертикали)
- ✅ Текущее значение видно в Input - не нужно дублировать

### 3. Визуальная чистота
- ✅ Выровненные управляющие элементы справа
- ✅ Единообразный вид всех параметров
- ✅ Меньше визуального шума

### 4. Адаптивность
- ✅ Соотношение 40/60 оптимально для разных длин названий
- ✅ `padding-right: 2` обеспечивает читаемый разрыв
- ✅ `align: left middle` - вертикальное центрирование

## Тестирование

✅ **Вкладка "Параметры":**
- Все 6 параметров видны без прокрутки
- Input поля выровнены справа
- Placeholder'ы видны и читаемы
- Enter для сохранения работает

✅ **Вкладка "Система":**
- Все 3 параметра видны без прокрутки
- Input поля и Switch выровнены справа
- Switch корректно отображается
- Все функции работают

✅ **Совместимость:**
- Другие вкладки не затронуты
- CSS изменения не влияют на остальные элементы
- Функциональность сохранена

## Итого

**Проблема решена:** Все параметры теперь влезают на вкладки по высоте без необходимости прокрутки.

**Метод:** Горизонтальная компоновка с соотношением 40% (название) / 60% (управляющий элемент).

**Результат:** 
- 📐 **50% экономии высоты**
- 👁️ Лучшая читаемость
- 🎯 Удобнее использование
- ✨ Чище интерфейс
