# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['misp_stix_converter',
 'misp_stix_converter.data.misp-galaxy.tools',
 'misp_stix_converter.data.misp-galaxy.tools.UN M49',
 'misp_stix_converter.data.misp-galaxy.tools.mitre-cti.v1.0',
 'misp_stix_converter.data.misp-galaxy.tools.mitre-cti.v2.0',
 'misp_stix_converter.misp2stix',
 'misp_stix_converter.stix2misp']

package_data = \
{'': ['*'],
 'misp_stix_converter': ['data/*',
                         'data/cti/*',
                         'data/cti/capec/2.0/*',
                         'data/cti/capec/2.0/attack-pattern/*',
                         'data/cti/capec/2.0/course-of-action/*',
                         'data/cti/capec/2.0/identity/*',
                         'data/cti/capec/2.0/marking-definition/*',
                         'data/cti/capec/2.0/relationship/*',
                         'data/cti/capec/2.1/*',
                         'data/cti/capec/2.1/attack-pattern/*',
                         'data/cti/capec/2.1/course-of-action/*',
                         'data/cti/capec/2.1/identity/*',
                         'data/cti/capec/2.1/marking-definition/*',
                         'data/cti/capec/2.1/relationship/*',
                         'data/cti/enterprise-attack/*',
                         'data/cti/enterprise-attack/attack-pattern/*',
                         'data/cti/enterprise-attack/course-of-action/*',
                         'data/cti/enterprise-attack/identity/*',
                         'data/cti/enterprise-attack/intrusion-set/*',
                         'data/cti/enterprise-attack/malware/*',
                         'data/cti/enterprise-attack/marking-definition/*',
                         'data/cti/enterprise-attack/relationship/*',
                         'data/cti/enterprise-attack/tool/*',
                         'data/cti/enterprise-attack/x-mitre-data-component/*',
                         'data/cti/enterprise-attack/x-mitre-data-source/*',
                         'data/cti/enterprise-attack/x-mitre-matrix/*',
                         'data/cti/enterprise-attack/x-mitre-tactic/*',
                         'data/cti/ics-attack/*',
                         'data/cti/ics-attack/attack-pattern/*',
                         'data/cti/ics-attack/course-of-action/*',
                         'data/cti/ics-attack/identity/*',
                         'data/cti/ics-attack/intrusion-set/*',
                         'data/cti/ics-attack/malware/*',
                         'data/cti/ics-attack/marking-definition/*',
                         'data/cti/ics-attack/relationship/*',
                         'data/cti/ics-attack/x-mitre-matrix/*',
                         'data/cti/ics-attack/x-mitre-tactic/*',
                         'data/cti/mobile-attack/*',
                         'data/cti/mobile-attack/attack-pattern/*',
                         'data/cti/mobile-attack/course-of-action/*',
                         'data/cti/mobile-attack/identity/*',
                         'data/cti/mobile-attack/intrusion-set/*',
                         'data/cti/mobile-attack/malware/*',
                         'data/cti/mobile-attack/marking-definition/*',
                         'data/cti/mobile-attack/relationship/*',
                         'data/cti/mobile-attack/tool/*',
                         'data/cti/mobile-attack/x-mitre-matrix/*',
                         'data/cti/mobile-attack/x-mitre-tactic/*',
                         'data/cti/pre-attack/*',
                         'data/cti/pre-attack/attack-pattern/*',
                         'data/cti/pre-attack/identity/*',
                         'data/cti/pre-attack/intrusion-set/*',
                         'data/cti/pre-attack/marking-definition/*',
                         'data/cti/pre-attack/relationship/*',
                         'data/cti/pre-attack/x-mitre-matrix/*',
                         'data/cti/pre-attack/x-mitre-tactic/*',
                         'data/misp-galaxy/*',
                         'data/misp-galaxy/.github/workflows/*',
                         'data/misp-galaxy/clusters/*',
                         'data/misp-galaxy/doc/images/*',
                         'data/misp-galaxy/galaxies/*',
                         'data/misp-galaxy/misp/*',
                         'data/misp-galaxy/vocabularies/common/*',
                         'data/misp-galaxy/vocabularies/threat-actor/*']}

install_requires = \
['cybox>=2.1.0,<3.0.0',
 'maec>=4.1.0,<5.0.0',
 'misp-lib-stix2>=3.0.1,<4.0.0',
 'mixbox>=1.0.3,<2.0.0',
 'pymisp>=2.4.157,<3.0.0',
 'stix>=1.2.0,<2.0.0']

entry_points = \
{'console_scripts': ['misp_stix_converter = misp_stix_converter:main']}

setup_kwargs = {
    'name': 'misp-stix',
    'version': '2.4.161',
    'description': 'Python scripts used by MISP to export MISP format into STIX and to import STIX into MISP format.',
    'long_description': '# MISP-STIX - Python library to handle the conversion between MISP standard and STIX\n\n<img src="https://raw.githubusercontent.com/MISP/misp-stix/main/documentation/logos/misp-stix.png" width="125" height="125">\n\n[![Python version](https://img.shields.io/badge/python-3.7+-blue.svg)](https://www.python.org/downloads/release/python-370/)\n[![MISP-STIX version](https://badge.fury.io/gh/MISP%2Fmisp-stix.svg)](https://badge.fury.io/gh/MISP%2Fmisp-stix)\n[![Github Actions](https://github.com/MISP/misp-stix/workflows/misp-stix/badge.svg)](https://github.com/MISP/misp-stix/actions?query=workflow%3Amisp-stix)\n[![License](https://img.shields.io/github/license/MISP/misp-stix.svg)](#License)\n\nMISP-STIX-converter is a Python library (>=3.7) to handle all the conversions between the [MISP standard format](https://www.misp-standard.org/) and STIX formats.\n\n## Features\n\n- MISP standard format conversion to STIX 1.x (1.1.1 and 1.2)\n- MISP standard format conversion to STIX 2.0 (2.0 and 2.1)\n- Maps [MISP Objects](https://github.com/MISP/misp-objects) and [MISP galaxies](https://github.com/misp/misp-galaxy) with [respective semantically similar objects](https://github.com/MISP/misp-stix/tree/main/documentation)\n- STIX to MISP standard format\n- Provides an extendable library for mapping and facilitate extension\n\nThis library is used by the [MISP core software](https://github.com/MISP/MISP) to perform STIX conversion and serving as a useful tool for anyone looking for a clean way of converting between the MISP standard format and various STIX versions (1.1.1, 1.2, 2.0, 2.1).\n\nA complete [documentation is available](/documentation/) including the mappings between the different formats.\n\n## Install from pip\n\n**It is strongly recommended to use a virtual environment**\n\nIf you want to know more about virtual environments, [python has you covered](https://docs.python.org/3/tutorial/venv.html)\n\nFrom the current repository:\n```\npip3 install misp-stix\n```\n\n## Install the latest version from the repository for development purposes\n\n**Note**: poetry is required; e.g., "pip3 install poetry"\n\n```\ngit clone https://github.com/MISP/misp-stix.git && cd misp-stix\ngit submodule update --init\npoetry install\n```\n\n### Running the tests\n\nTests for MISP format export as STIX 1.1.1 & 1.2:\n```bash\npoetry run pytest tests/test_stix1_export.py\n```\n\nTests for MISP format export as STIX 2.0:\n```bash\npoetry run pytest tests/test_stix20_export.py\n```\n\nTests for MISP format export as STIX 2.1:\n```bash\npoetry run pytest tests/test_stix21_export.py\n```\n\n## Usage\n\n### Command-line Usage\n\n```\nmisp_stix_converter --version 2.1 -f tests/test_events_collection_1.json\n```\n\n#### Parameters\n\n- `--version`: STIX version\n- `--file`: Input file(s)\n\nParameters specific to the case of multiple input file(s):\n- `--single_output`: In case of multiple input files, save the results in on single file\n- `--tmp_files`: Store temporary results in files before gathering the whole conversion result, instead of keeping it on memory\n\nParameters specific to STIX 1 export:\n- `--feature`: MISP data structure level (attribute or event)\n- `--namespace`: Namespace to be used in the STIX 1 header\n- `--org`: Organisation name to be used in the STIX 1 header\n\n### In Python scripts\n\nGiven a MISP Event (with its metadata fields, attributes, objects, galaxies and tags), declared in an `event` variable in JSON format, you can get the result of a conversion into one of the supported STIX versions:\n\n- Convert a MISP Event in STIX1:\n\n```python\nfrom misp_stix_converter import MISPtoSTIX1EventsParser\n\nparser = MISPtoSTIX1EventsParser(\n    \'MISP-Project\', # Example of Org name\n    \'1.1.1\' # STIX1 version (1.1.1 or 1.2)\n)\nparser.parse_misp_event(event)\n\nstix_package = parser.stix_package\n```\n\n- Convert a MISP Event in STIX1 using directly its file name:\n\n```python\nfrom misp_stix_converter import misp_to_stix1\n\nresponse = misp_to_stix1(\n    filename, # file name of the file containing a MISP Event\n    \'xml\', # return format (XML or JSON)\n    \'1.1.1\' # STIX1 version (1.1.1 or 1.2)\n)\n# response = 1 if everything went well\n```\nThe resulting STIX1 Package is then available in a `filename.out` file\n\n- Convert a MISP Event in STIX2:\n\n```python\n# for STIX 2.0\nfrom misp_stix_converter import MISPtoSTIX20Parser\n# for STIX 2.1\nfrom misp_stix_converter import MISPtoSTIX21Parser\n\nparser20 = MISPtoSTIX20Parser()\nparser20.parse_misp_event(event)\n\nparser21 = MISPtoSTIX21Parser()\nparser21.parse_misp_event(event)\n\n# To get the list of parsed STIX objects\nstix_20_objects = parser20.stix_objects\nstix_21_objects = parser21.stix_objects\n\n# To get the list of parser STIX objects within a STIX 2.0 or 2.1 Bundle\nbundle20 = parser20.bundle\nbundle21 = parser21.bundle\n```\n\n- Convert a MISP Event in STIX2 using directly its file name:\n\n```python\nfrom misp_stix_converter import misp_to_stix2_0, misp_to_stix2_1\n\nresponse_20 = misp_to_stix2_0(filename)\nresponse_21 = misp_to_stix2_1(filename)\n# Again response_20 & response_21 should be 1 if everything went well\n```\nThe resulting STIX2 Bundle is the available in a `filename.out` file\n\nIf you get some MISP collection of data, it is also possible to convert it straight into some STIX format:\n\n```python\nfrom misp_stix_converter import MISPtoSTIX1EventsParser, MISPtoSTIX20Parser, MISPtoSTIX21Parser\n\nfilename = _PATH_TO_YOUR_FILE_CONTAINING_MISP_FORMAT_\n\nparser1 = MISPtoSTIX1EventsParser(\'MISP\', \'1.1.1\')\nparser1.parse_json_content(filename)\nstix_package = parser1.stix_package\n\nparser20 = MISPtoSTIX20Parser()\nparser20.parse_json_content(filename)\nstix_20_objects = parser20.stix_objects\nbundle20 = parser20.bundle\n\nparser21 = MISPtoSTIX21Parser()\nparser21.parse_json_content(filename)\nstix_21_objects = parser21.stix_objects\nbundle21 = parser21.bundle\n```\n\nBut in order to parse multiple data collections, you can also use the following helpers:\n\n```python\nfrom misp_stix_converter import misp_event_collection_to_stix1, misp_event_collection_to_stix2_0, misp_event_collection_to_stix2_1\n\ninput_filenames = [filename for filename in Path(_PATH_TO_YOUR_MISP_FILES_).glob(\'*.json\')]\n\nstix1_response = misp_event_collection_to_stix1(\n    output_filename, # path to the file where the results are going to be written\n    \'xml\', # STIX1 return format (XML or JSON)\n    \'1.1.1\', # STIX1 version (1.1.1 or 1.2)\n    *input_filenames\n)\n\nstix20_response = misp_event_collection_to_stix2_0(\n    output_filename, # path to the file where the results are going to be written\n    *input_filenames\n)\n\nstix21_response = misp_event_collection_to_stix2_1(\n    output_filename, # path to the file where the results are going to be written\n    *input_filenames\n)\n```\nAgain, all the response variables should be `1` and the resulting STIX1 Package and STIX 2.0 & 2.1 Bundles are available in the specific output file names.\n\n### Samples and examples\n\nVarious examples are provided and used by the different tests scripts in the [tests](tests/) directory.\nThose example files are showing the results of MISP format exported in the various supported STIX formats.\n\n## MISP <--> STIX Mapping\n\nA specific documentation concerning the mapping between MISP and the various supported STIX versions is also provided in the [documentation](documentation/) directory.\nYou can find there all the different cases illustrated with examples.\n\n# License\n\nmisp-stix is released under a BSD 2-Clause "Simplified" License allow easy reuse with other libraries.\n\n~~~\nCopyright 2019-2022 Christian Studer\nCopyright 2019-2022 CIRCL - Computer Incident Response Center Luxembourg c/o "security made in Lëtzebuerg" (SMILE) g.i.e.\n\nRedistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:\n\n1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.\n\n2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.\n\nTHIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n~~~\n',
    'author': 'Christian Studer',
    'author_email': 'christian.studer@circl.lu',
    'maintainer': 'Christian Studer',
    'maintainer_email': 'christian.studer@circl.lu',
    'url': 'https://github.com/MISP/misp-stix',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
