# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['blackt']

package_data = \
{'': ['*']}

install_requires = \
['black>=21.9b0,<22']

entry_points = \
{'console_scripts': ['blackt = blackt:main']}

setup_kwargs = {
    'name': 'blackt',
    'version': '2021.0.2',
    'description': 'Black but with tabs',
    'long_description': '[![GitHub top language](https://img.shields.io/github/languages/top/FHPythonUtils/blackt.svg?style=for-the-badge)](../../)\n[![Repository size](https://img.shields.io/github/repo-size/FHPythonUtils/blackt.svg?style=for-the-badge)](../../)\n[![Issues](https://img.shields.io/github/issues/FHPythonUtils/blackt.svg?style=for-the-badge)](../../issues)\n[![License](https://img.shields.io/github/license/FHPythonUtils/blackt.svg?style=for-the-badge)](/LICENSE.md)\n[![Commit activity](https://img.shields.io/github/commit-activity/m/FHPythonUtils/blackt.svg?style=for-the-badge)](../../commits/master)\n[![Last commit](https://img.shields.io/github/last-commit/FHPythonUtils/blackt.svg?style=for-the-badge)](../../commits/master)\n[![PyPI Downloads](https://img.shields.io/pypi/dm/blackt.svg?style=for-the-badge)](https://pypistats.org/packages/blackt)\n[![PyPI Total Downloads](https://img.shields.io/badge/dynamic/json?style=for-the-badge&label=total%20downloads&query=%24.total_downloads&url=https%3A%2F%2Fapi.pepy.tech%2Fapi%2Fprojects%2Fblackt)](https://pepy.tech/project/blackt)\n[![PyPI Version](https://img.shields.io/pypi/v/blackt.svg?style=for-the-badge)](https://pypi.org/project/blackt)\n\n<!-- omit in toc -->\n# BlackT\n\n<img src="readme-assets/icons/name.png" alt="Project Icon" width="750">\n\nBlack but with tabs\n\nhttps://github.com/psf/black/\n\n- [Using (snippet from upstream)](#using-snippet-from-upstream)\n\t- [Command line options](#command-line-options)\n- [Docs](#docs)\n- [Install With PIP](#install-with-pip)\n- [Language information](#language-information)\n\t- [Built for](#built-for)\n- [Install Python on Windows](#install-python-on-windows)\n\t- [Chocolatey](#chocolatey)\n\t- [Windows - Python.org](#windows---pythonorg)\n- [Install Python on Linux](#install-python-on-linux)\n\t- [Apt](#apt)\n\t- [Dnf](#dnf)\n- [Install Python on MacOS](#install-python-on-macos)\n\t- [Homebrew](#homebrew)\n\t- [MacOS - Python.org](#macos---pythonorg)\n- [How to run](#how-to-run)\n\t- [Windows](#windows)\n\t- [Linux/ MacOS](#linux-macos)\n- [Download Project](#download-project)\n\t- [Clone](#clone)\n\t\t- [Using The Command Line](#using-the-command-line)\n\t\t- [Using GitHub Desktop](#using-github-desktop)\n\t- [Download Zip File](#download-zip-file)\n- [Community Files](#community-files)\n\t- [Licence](#licence)\n\t- [Changelog](#changelog)\n\t- [Code of Conduct](#code-of-conduct)\n\t- [Contributing](#contributing)\n\t- [Security](#security)\n\t- [Support](#support)\n\t- [Rationale](#rationale)\n\n## Using (snippet from upstream)\n\nTo get started right away with sensible defaults:\n\n```sh\nblack {source_file_or_directory}\n```\n\nYou can run _Black_ as a package if running it as a script doesn\'t work:\n\n```sh\npython -m black {source_file_or_directory}\n```\n\n### Command line options\n\n_Black_ doesn\'t provide many options. You can list them by running `black --help`:\n\n```text\nUsage: black [OPTIONS] SRC ...\n\n  The uncompromising code formatter.\n\nOptions:\n  -c, --code TEXT                 Format the code passed in as a string.\n  -l, --line-length INTEGER       How many characters per line to allow.\n                                  [default: 100]\n  -t, --target-version [py27|py33|py34|py35|py36|py37|py38|py39]\n                                  Python versions that should be supported by\n                                  Black\'s output. [default: per-file auto-\n                                  detection]\n  --pyi                           Format all input files like typing stubs\n                                  regardless of file extension (useful when\n                                  piping source on standard input).\n  --ipynb                         Format all input files like Jupyter\n                                  Notebooks regardless of file extension\n                                  (useful when piping source on standard\n                                  input).\n  -S, --skip-string-normalization\n                                  Don\'t normalize string quotes or prefixes.\n  -C, --skip-magic-trailing-comma\n                                  Don\'t use trailing commas as a reason to\n                                  split lines.\n  --check                         Don\'t write the files back, just return the\n                                  status. Return code 0 means nothing would\n                                  change. Return code 1 means some files would\n                                  be reformatted. Return code 123 means there\n                                  was an internal error.\n  --diff                          Don\'t write the files back, just output a\n                                  diff for each file on stdout.\n  --color / --no-color            Show colored diff. Only applies when\n                                  `--diff` is given.\n  --fast / --safe                 If --fast given, skip temporary sanity\n                                  checks. [default: --safe]\n  --required-version TEXT         Require a specific version of Black to be\n                                  running (useful for unifying results across\n                                  many environments e.g. with a pyproject.toml\n                                  file).\n  --include TEXT                  A regular expression that matches files and\n                                  directories that should be included on\n                                  recursive searches. An empty value means all\n                                  files are included regardless of the name.\n                                  Use forward slashes for directories on all\n                                  platforms (Windows, too). Exclusions are\n                                  calculated first, inclusions later.\n                                  [default: (\\.pyi?|\\.ipynb)$]\n  --exclude TEXT                  A regular expression that matches files and\n                                  directories that should be excluded on\n                                  recursive searches. An empty value means no\n                                  paths are excluded. Use forward slashes for\n                                  directories on all platforms (Windows, too).\n                                  Exclusions are calculated first, inclusions\n                                  later. [default: /(\\.direnv|\\.eggs|\\.git|\\.h\n                                  g|\\.mypy_cache|\\.nox|\\.tox|\\.venv|venv|\\.svn\n                                  |_build|buck-out|build|dist)/]\n  --extend-exclude TEXT           Like --exclude, but adds additional files\n                                  and directories on top of the excluded ones.\n                                  (Useful if you simply want to add to the\n                                  default)\n  --force-exclude TEXT            Like --exclude, but files and directories\n                                  matching this regex will be excluded even\n                                  when they are passed explicitly as\n                                  arguments.\n  --stdin-filename TEXT           The name of the file when passing it through\n                                  stdin. Useful to make sure Black will\n                                  respect --force-exclude option on some\n                                  editors that rely on using stdin.\n  -q, --quiet                     Don\'t emit non-error messages to stderr.\n                                  Errors are still emitted; silence those with\n                                  2>/dev/null.\n  -v, --verbose                   Also emit messages to stderr about files\n                                  that were not changed or were ignored due to\n                                  exclusion patterns.\n  --version                       Show the version and exit.\n  --config FILE                   Read configuration from FILE path.\n  -h, --help                      Show this message and exit.\n```\n\n_Black_ is a well-behaved Unix-style command-line tool:\n\n- it does nothing if no sources are passed to it;\n- it will read from standard input and write to standard output if `-` is used as the\n  filename;\n- it only outputs messages to users on standard error;\n- exits with code 0 unless an internal error occurred (or `--check` was used).\n\nFor more info see https://github.com/psf/black/blob/master/README.md\n\n## Docs\n\nSee the [Docs](/DOCS/) for more information.\n\n## Install With PIP\n\n```python\npip install blackt\n```\n\nHead to https://pypi.org/project/blackt/ for more info\n\n## Language information\n\n### Built for\n\nThis program has been written for Python versions 3.7 - 3.10 and has been tested with both 3.7 and\n3.10\n\n## Install Python on Windows\n\n### Chocolatey\n\n```powershell\nchoco install python\n```\n\n### Windows - Python.org\n\nTo install Python, go to https://www.python.org/downloads/windows/ and download the latest\nversion.\n\n## Install Python on Linux\n\n### Apt\n\n```bash\nsudo apt install python3.x\n```\n\n### Dnf\n\n```bash\nsudo dnf install python3.x\n```\n\n## Install Python on MacOS\n\n### Homebrew\n\n```bash\nbrew install python@3.x\n```\n\n### MacOS - Python.org\n\nTo install Python, go to https://www.python.org/downloads/macos/ and download the latest\nversion.\n\n## How to run\n\n### Windows\n\n- Module\n\t`py -3.x -m [module]` or `[module]` (if module installs a script)\n\n- File\n\t`py -3.x [file]` or `./[file]`\n\n### Linux/ MacOS\n\n- Module\n\t`python3.x -m [module]` or `[module]` (if module installs a script)\n\n- File\n\t`python3.x [file]` or `./[file]`\n\n## Download Project\n\n### Clone\n\n#### Using The Command Line\n\n1. Press the Clone or download button in the top right\n2. Copy the URL (link)\n3. Open the command line and change directory to where you wish to\nclone to\n4. Type \'git clone\' followed by URL in step 2\n\n\t```bash\n\tgit clone https://github.com/FHPythonUtils/blackt\n\t```\n\nMore information can be found at\nhttps://help.github.com/en/articles/cloning-a-repository\n\n#### Using GitHub Desktop\n\n1. Press the Clone or download button in the top right\n2. Click open in desktop\n3. Choose the path for where you want and click Clone\n\nMore information can be found at\nhttps://help.github.com/en/desktop/contributing-to-projects/cloning-a-repository-from-github-to-github-desktop\n\n### Download Zip File\n\n1. Download this GitHub repository\n2. Extract the zip archive\n3. Copy/ move to the desired location\n\n## Community Files\n\n### Licence\n\nMIT License\nCopyright (c) FredHappyface\n(See the [LICENSE](/LICENSE.md) for more information.)\n\n### Changelog\n\nSee the [Changelog](/CHANGELOG.md) for more information.\n\n### Code of Conduct\n\nOnline communities include people from many backgrounds. The *Project*\ncontributors are committed to providing a friendly, safe and welcoming\nenvironment for all. Please see the\n[Code of Conduct](https://github.com/FHPythonUtils/.github/blob/master/CODE_OF_CONDUCT.md)\n for more information.\n\n### Contributing\n\nContributions are welcome, please see the\n[Contributing Guidelines](https://github.com/FHPythonUtils/.github/blob/master/CONTRIBUTING.md)\nfor more information.\n\n### Security\n\nThank you for improving the security of the project, please see the\n[Security Policy](https://github.com/FHPythonUtils/.github/blob/master/SECURITY.md)\nfor more information.\n\n### Support\n\nThank you for using this project, I hope it is of use to you. Please be aware that\nthose involved with the project often do so for fun along with other commitments\n(such as work, family, etc). Please see the\n[Support Policy](https://github.com/FHPythonUtils/.github/blob/master/SUPPORT.md)\nfor more information.\n\n### Rationale\n\nThe rationale acts as a guide to various processes regarding projects such as\nthe versioning scheme and the programming styles used. Please see the\n[Rationale](https://github.com/FHPythonUtils/.github/blob/master/RATIONALE.md)\nfor more information.\n',
    'author': 'FredHappyface',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/FHPythonUtils/blackt',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6.2,<4.0.0',
}


setup(**setup_kwargs)
