# Genome Tree Toolkit

[![version status](https://img.shields.io/pypi/v/genometreetk.svg)](https://pypi.python.org/pypi/genometreetk)
[![conda version](https://img.shields.io/conda/vn/ace-internal/genometreetk.svg?color=green)](https://anaconda.org/ace-internal/genometreetk)
[![Downloads](https://pepy.tech/badge/genometreetk)](https://pepy.tech/project/genometreetk)
[![Downloads](https://pepy.tech/badge/genometreetk/month)](https://pepy.tech/project/genometreetk/month)

The genome tree toolkit is a collection of methods for working with genome trees. It is primarily intended to be used by the GTDB curation team, but has been made available in case others find it useful. It currently supports:

<i>Taxonomy manipulation:</i>
* filling missing ranks
* stripping taxonomy from Newick files
* pulling taxonomy information from a Newick tree

<i>Measures of tree stability:</i>
* bootstrap support
* jackknife taxa support
* jackknife gene support

<i>Tree manipulation:</i>
* outgrouping
* pruning

<i>Tree inference:</i>
* SSU and LSU trees

## Install

The simplest way to install this package is through pip:
> sudo pip install genometreetk

## Cite

If you find this package useful, please cite this git repository (https://github.com/dparks1134/GenomeTreeTk)

## Copyright

Copyright © 2015 Donovan Parks. See LICENSE for further details.
